/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PathKeyframes
implements Keyframes,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int FRACTION_OFFSET = 0;
    private static int X_OFFSET = 1;
    private static int Y_OFFSET = 2;
    private static int NUM_COMPONENTS = 3;
    private static ArrayList<Keyframe> EMPTY_KEYFRAMES;
    private PointF mTempPointF;
    private float[] mKeyframeData;

    private void $$robo$$android_animation_PathKeyframes$__constructor__(Path path) {
    }

    private void $$robo$$android_animation_PathKeyframes$__constructor__(Path path, float error) {
        this.mTempPointF = new PointF();
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path must not be null or empty");
        }
        this.mKeyframeData = path.approximate(error);
    }

    private final ArrayList<Keyframe> $$robo$$android_animation_PathKeyframes$getKeyframes() {
        return EMPTY_KEYFRAMES;
    }

    private final Object $$robo$$android_animation_PathKeyframes$getValue(float fraction2) {
        int numPoints = this.mKeyframeData.length / 3;
        if (fraction2 < 0.0f) {
            return this.interpolateInRange(fraction2, 0, 1);
        }
        if (fraction2 > 1.0f) {
            return this.interpolateInRange(fraction2, numPoints - 2, numPoints - 1);
        }
        if (fraction2 == 0.0f) {
            return this.pointForIndex(0);
        }
        if (fraction2 == 1.0f) {
            return this.pointForIndex(numPoints - 1);
        }
        int low = 0;
        int high = numPoints - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            float midFraction = this.mKeyframeData[mid * 3 + 0];
            if (fraction2 < midFraction) {
                high = mid - 1;
                continue;
            }
            if (fraction2 > midFraction) {
                low = mid + 1;
                continue;
            }
            return this.pointForIndex(mid);
        }
        return this.interpolateInRange(fraction2, high, low);
    }

    private final PointF $$robo$$android_animation_PathKeyframes$interpolateInRange(float fraction2, int startIndex, int endIndex) {
        int startBase = startIndex * 3;
        int endBase = endIndex * 3;
        float startFraction = this.mKeyframeData[startBase + 0];
        float endFraction = this.mKeyframeData[endBase + 0];
        float intervalFraction = (fraction2 - startFraction) / (endFraction - startFraction);
        float startX = this.mKeyframeData[startBase + 1];
        float endX = this.mKeyframeData[endBase + 1];
        float startY = this.mKeyframeData[startBase + 2];
        float endY = this.mKeyframeData[endBase + 2];
        float x = PathKeyframes.interpolate(intervalFraction, startX, endX);
        float y = PathKeyframes.interpolate(intervalFraction, startY, endY);
        this.mTempPointF.set(x, y);
        return this.mTempPointF;
    }

    private final void $$robo$$android_animation_PathKeyframes$setEvaluator(TypeEvaluator evaluator) {
    }

    private final Class $$robo$$android_animation_PathKeyframes$getType() {
        return PointF.class;
    }

    private final Keyframes $$robo$$android_animation_PathKeyframes$clone() {
        Keyframes clone = null;
        try {
            clone = (Keyframes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final PointF $$robo$$android_animation_PathKeyframes$pointForIndex(int index) {
        int base = index * 3;
        int xOffset = base + 1;
        int yOffset = base + 2;
        this.mTempPointF.set(this.mKeyframeData[xOffset], this.mKeyframeData[yOffset]);
        return this.mTempPointF;
    }

    private static final float $$robo$$android_animation_PathKeyframes$interpolate(float fraction2, float startValue, float endValue) {
        float diff = endValue - startValue;
        return startValue + diff * fraction2;
    }

    private final Keyframes.FloatKeyframes $$robo$$android_animation_PathKeyframes$createXFloatKeyframes() {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PathKeyframes this$0;

            private void $$robo$$android_animation_PathKeyframes_1$__constructor__(PathKeyframes this$0) {
                this.this$0 = this$0;
            }

            private final float $$robo$$android_animation_PathKeyframes_1$getFloatValue(float fraction2) {
                PointF pointF = (PointF)this.this$0.getValue(fraction2);
                return pointF.x;
            }

            private void __constructor__(PathKeyframes pathKeyframes) {
                this.$$robo$$android_animation_PathKeyframes_1$__constructor__(pathKeyframes);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_1$__constructor__(android.animation.PathKeyframes ), this, pathKeyframes);
            }

            @Override
            public float getFloatValue(float f) {
                return (float)InvokeDynamicSupport.bootstrap("getFloatValue", $$robo$$android_animation_PathKeyframes_1$getFloatValue(float ), this, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Keyframes.FloatKeyframes $$robo$$android_animation_PathKeyframes$createYFloatKeyframes() {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PathKeyframes this$0;

            private void $$robo$$android_animation_PathKeyframes_2$__constructor__(PathKeyframes this$0) {
                this.this$0 = this$0;
            }

            private final float $$robo$$android_animation_PathKeyframes_2$getFloatValue(float fraction2) {
                PointF pointF = (PointF)this.this$0.getValue(fraction2);
                return pointF.y;
            }

            private void __constructor__(PathKeyframes pathKeyframes) {
                this.$$robo$$android_animation_PathKeyframes_2$__constructor__(pathKeyframes);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_2$__constructor__(android.animation.PathKeyframes ), this, pathKeyframes);
            }

            @Override
            public float getFloatValue(float f) {
                return (float)InvokeDynamicSupport.bootstrap("getFloatValue", $$robo$$android_animation_PathKeyframes_2$getFloatValue(float ), this, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Keyframes.IntKeyframes $$robo$$android_animation_PathKeyframes$createXIntKeyframes() {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PathKeyframes this$0;

            private void $$robo$$android_animation_PathKeyframes_3$__constructor__(PathKeyframes this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_animation_PathKeyframes_3$getIntValue(float fraction2) {
                PointF pointF = (PointF)this.this$0.getValue(fraction2);
                return Math.round(pointF.x);
            }

            private void __constructor__(PathKeyframes pathKeyframes) {
                this.$$robo$$android_animation_PathKeyframes_3$__constructor__(pathKeyframes);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_3$__constructor__(android.animation.PathKeyframes ), this, pathKeyframes);
            }

            @Override
            public int getIntValue(float f) {
                return (int)InvokeDynamicSupport.bootstrap("getIntValue", $$robo$$android_animation_PathKeyframes_3$getIntValue(float ), this, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Keyframes.IntKeyframes $$robo$$android_animation_PathKeyframes$createYIntKeyframes() {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PathKeyframes this$0;

            private void $$robo$$android_animation_PathKeyframes_4$__constructor__(PathKeyframes this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_animation_PathKeyframes_4$getIntValue(float fraction2) {
                PointF pointF = (PointF)this.this$0.getValue(fraction2);
                return Math.round(pointF.y);
            }

            private void __constructor__(PathKeyframes pathKeyframes) {
                this.$$robo$$android_animation_PathKeyframes_4$__constructor__(pathKeyframes);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_4$__constructor__(android.animation.PathKeyframes ), this, pathKeyframes);
            }

            @Override
            public int getIntValue(float f) {
                return (int)InvokeDynamicSupport.bootstrap("getIntValue", $$robo$$android_animation_PathKeyframes_4$getIntValue(float ), this, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    static void __staticInitializer__() {
        EMPTY_KEYFRAMES = new ArrayList();
    }

    private void __constructor__(Path path) {
        this.$$robo$$android_animation_PathKeyframes$__constructor__(path);
    }

    public PathKeyframes(Path path) {
        this(path, 0.5f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes$__constructor__(android.graphics.Path ), this, path);
    }

    private void __constructor__(Path path, float f) {
        this.$$robo$$android_animation_PathKeyframes$__constructor__(path, f);
    }

    public PathKeyframes(Path path, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes$__constructor__(android.graphics.Path float ), this, path, f);
    }

    public ArrayList<Keyframe> getKeyframes() {
        return InvokeDynamicSupport.bootstrap("getKeyframes", $$robo$$android_animation_PathKeyframes$getKeyframes(), this);
    }

    @Override
    public Object getValue(float f) {
        return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_animation_PathKeyframes$getValue(float ), this, f);
    }

    private PointF interpolateInRange(float f, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("interpolateInRange", $$robo$$android_animation_PathKeyframes$interpolateInRange(float int int ), this, f, n, n2);
    }

    @Override
    public void setEvaluator(TypeEvaluator typeEvaluator) {
        InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_PathKeyframes$setEvaluator(android.animation.TypeEvaluator ), this, typeEvaluator);
    }

    @Override
    public Class getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_animation_PathKeyframes$getType(), this);
    }

    @Override
    public Keyframes clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_PathKeyframes$clone(), this);
    }

    private PointF pointForIndex(int n) {
        return InvokeDynamicSupport.bootstrap("pointForIndex", $$robo$$android_animation_PathKeyframes$pointForIndex(int ), this, n);
    }

    private static float interpolate(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("interpolate", $$robo$$android_animation_PathKeyframes$interpolate(float float float ), (float)f, (float)f2, (float)f3);
    }

    public Keyframes.FloatKeyframes createXFloatKeyframes() {
        return InvokeDynamicSupport.bootstrap("createXFloatKeyframes", $$robo$$android_animation_PathKeyframes$createXFloatKeyframes(), this);
    }

    public Keyframes.FloatKeyframes createYFloatKeyframes() {
        return InvokeDynamicSupport.bootstrap("createYFloatKeyframes", $$robo$$android_animation_PathKeyframes$createYFloatKeyframes(), this);
    }

    public Keyframes.IntKeyframes createXIntKeyframes() {
        return InvokeDynamicSupport.bootstrap("createXIntKeyframes", $$robo$$android_animation_PathKeyframes$createXIntKeyframes(), this);
    }

    public Keyframes.IntKeyframes createYIntKeyframes() {
        return InvokeDynamicSupport.bootstrap("createYIntKeyframes", $$robo$$android_animation_PathKeyframes$createYIntKeyframes(), this);
    }

    static {
        RobolectricInternals.classInitializing(PathKeyframes.class);
    }

    public /* synthetic */ PathKeyframes() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PathKeyframes)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class FloatKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.FloatKeyframes,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$__constructor__() {
        }

        private final Class $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$getType() {
            return Float.class;
        }

        private final Object $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$getValue(float fraction2) {
            return Float.valueOf(this.getFloatValue(fraction2));
        }

        private void __constructor__() {
            this.$$robo$$android_animation_PathKeyframes_FloatKeyframesBase$__constructor__();
        }

        public FloatKeyframesBase() {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$__constructor__(), this);
        }

        @Override
        public Class getType() {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$getType(), this);
        }

        @Override
        public Object getValue(float f) {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_animation_PathKeyframes_FloatKeyframesBase$getValue(float ), this, f);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatKeyframesBase)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class IntKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.IntKeyframes,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_animation_PathKeyframes_IntKeyframesBase$__constructor__() {
        }

        private final Class $$robo$$android_animation_PathKeyframes_IntKeyframesBase$getType() {
            return Integer.class;
        }

        private final Object $$robo$$android_animation_PathKeyframes_IntKeyframesBase$getValue(float fraction2) {
            return this.getIntValue(fraction2);
        }

        private void __constructor__() {
            this.$$robo$$android_animation_PathKeyframes_IntKeyframesBase$__constructor__();
        }

        public IntKeyframesBase() {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_IntKeyframesBase$__constructor__(), this);
        }

        @Override
        public Class getType() {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_animation_PathKeyframes_IntKeyframesBase$getType(), this);
        }

        @Override
        public Object getValue(float f) {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_animation_PathKeyframes_IntKeyframesBase$getValue(float ), this, f);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntKeyframesBase)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class SimpleKeyframes
    implements Keyframes,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__() {
        }

        private final void $$robo$$android_animation_PathKeyframes_SimpleKeyframes$setEvaluator(TypeEvaluator evaluator) {
        }

        private final ArrayList<Keyframe> $$robo$$android_animation_PathKeyframes_SimpleKeyframes$getKeyframes() {
            return EMPTY_KEYFRAMES;
        }

        private final Keyframes $$robo$$android_animation_PathKeyframes_SimpleKeyframes$clone() {
            Keyframes clone = null;
            try {
                clone = (Keyframes)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return clone;
        }

        private /* synthetic */ void $$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__();
        }

        public SimpleKeyframes() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__(), this);
        }

        @Override
        public void setEvaluator(TypeEvaluator typeEvaluator) {
            InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_PathKeyframes_SimpleKeyframes$setEvaluator(android.animation.TypeEvaluator ), this, typeEvaluator);
        }

        public ArrayList<Keyframe> getKeyframes() {
            return InvokeDynamicSupport.bootstrap("getKeyframes", $$robo$$android_animation_PathKeyframes_SimpleKeyframes$getKeyframes(), this);
        }

        @Override
        public Keyframes clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_PathKeyframes_SimpleKeyframes$clone(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__(var1_1);
        }

        public /* synthetic */ SimpleKeyframes(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_PathKeyframes_SimpleKeyframes$__constructor__(android.animation.PathKeyframes$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleKeyframes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

