/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AnimatorSet
extends Animator
implements AnimationHandler.AnimationFrameCallback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AnimatorSet";
    private ArrayList<Node> mPlayingSet;
    private ArrayMap<Animator, Node> mNodeMap;
    private ArrayList<AnimationEvent> mEvents;
    private ArrayList<Node> mNodes;
    private boolean mDependencyDirty;
    private boolean mStarted;
    private long mStartDelay;
    private ValueAnimator mDelayAnim;
    private Node mRootNode;
    private long mDuration;
    private TimeInterpolator mInterpolator;
    private long mTotalDuration;
    private boolean mShouldIgnoreEndWithoutStart;
    private boolean mShouldResetValuesAtStart;
    private boolean mEndCanBeCalled;
    private long mLastFrameTime;
    private long mFirstFrame;
    private int mLastEventId;
    private boolean mReversing;
    private boolean mSelfPulse;
    private SeekState mSeekState;
    private boolean mChildrenInitialized;
    private long mPauseTime;
    private AnimatorListenerAdapter mDummyListener;

    private void $$robo$$android_animation_AnimatorSet$__constructor__() {
        boolean isPreO;
        this.mPlayingSet = new ArrayList();
        this.mNodeMap = new ArrayMap();
        this.mEvents = new ArrayList();
        this.mNodes = new ArrayList();
        this.mDependencyDirty = false;
        this.mStarted = false;
        this.mStartDelay = 0L;
        this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(0L);
        this.mRootNode = new Node(this.mDelayAnim);
        this.mDuration = -1L;
        this.mInterpolator = null;
        this.mTotalDuration = 0L;
        this.mLastFrameTime = -1L;
        this.mFirstFrame = -1L;
        this.mLastEventId = -1;
        this.mReversing = false;
        this.mSelfPulse = true;
        this.mSeekState = new SeekState(this, null);
        this.mChildrenInitialized = false;
        this.mPauseTime = -1L;
        this.mDummyListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimatorSet this$0;

            private void $$robo$$android_animation_AnimatorSet_1$__constructor__(AnimatorSet this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_animation_AnimatorSet_1$onAnimationEnd(Animator animation) {
                if (this.this$0.mNodeMap.get(animation) == null) {
                    throw new AndroidRuntimeException("Error: animation ended is not in the node map");
                }
                ((Node)((AnimatorSet)this.this$0).mNodeMap.get((Object)animation)).mEnded = true;
            }

            private void __constructor__(AnimatorSet animatorSet) {
                this.$$robo$$android_animation_AnimatorSet_1$__constructor__(animatorSet);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_1$__constructor__(android.animation.AnimatorSet ), this, animatorSet);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_1$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNodeMap.put(this.mDelayAnim, this.mRootNode);
        this.mNodes.add(this.mRootNode);
        Application app = ActivityThread.currentApplication();
        if (app == null || app.getApplicationInfo() == null) {
            this.mShouldIgnoreEndWithoutStart = true;
            isPreO = true;
        } else {
            this.mShouldIgnoreEndWithoutStart = app.getApplicationInfo().targetSdkVersion < 24;
            isPreO = app.getApplicationInfo().targetSdkVersion < 26;
        }
        this.mShouldResetValuesAtStart = !isPreO;
        this.mEndCanBeCalled = !isPreO;
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Animator ... items) {
        if (items != null) {
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            Builder builder = null;
            for (Animator anim2 : items) {
                if (builder == null) {
                    builder = this.play(anim2);
                    continue;
                }
                builder.with(anim2);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(Animator ... items) {
        if (items != null) {
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    private final ArrayList<Animator> $$robo$$android_animation_AnimatorSet$getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            childList.add(node.mAnimation);
        }
        return childList;
    }

    private final void $$robo$$android_animation_AnimatorSet$setTarget(Object target) {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            Animator animation = node.mAnimation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    private final int $$robo$$android_animation_AnimatorSet$getChangingConfigurations() {
        int conf = super.getChangingConfigurations();
        int nodeCount = this.mNodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            conf |= this.mNodes.get((int)i).mAnimation.getChangingConfigurations();
        }
        return conf;
    }

    private final void $$robo$$android_animation_AnimatorSet$setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    private final TimeInterpolator $$robo$$android_animation_AnimatorSet$getInterpolator() {
        return this.mInterpolator;
    }

    private final Builder $$robo$$android_animation_AnimatorSet$play(Animator anim2) {
        if (anim2 != null) {
            return new Builder(this, anim2);
        }
        return null;
    }

    private final void $$robo$$android_animation_AnimatorSet$cancel() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationCancel(this);
                }
            }
            ArrayList<Node> playingSet = new ArrayList<Node>(this.mPlayingSet);
            int setSize = playingSet.size();
            for (int i = 0; i < setSize; ++i) {
                playingSet.get((int)i).mAnimation.cancel();
            }
            this.mPlayingSet.clear();
            this.endAnimation();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$forceToEnd() {
        if (this.mEndCanBeCalled) {
            this.end();
            return;
        }
        if (this.mReversing) {
            this.handleAnimationEvents(this.mLastEventId, 0, this.getTotalDuration());
        } else {
            long zeroScalePlayTime = this.getTotalDuration();
            if (zeroScalePlayTime == -1L) {
                zeroScalePlayTime = Integer.MAX_VALUE;
            }
            this.handleAnimationEvents(this.mLastEventId, this.mEvents.size() - 1, zeroScalePlayTime);
        }
        this.mPlayingSet.clear();
        this.endAnimation();
    }

    private final void $$robo$$android_animation_AnimatorSet$end() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mShouldIgnoreEndWithoutStart && !this.isStarted()) {
            return;
        }
        if (this.isStarted()) {
            if (this.mReversing) {
                int n = this.mLastEventId = this.mLastEventId == -1 ? this.mEvents.size() : this.mLastEventId;
                while (this.mLastEventId > 0) {
                    --this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim2 = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim2).mEnded) continue;
                    if (event.mEvent == 2) {
                        anim2.reverse();
                        continue;
                    }
                    if (event.mEvent != 1 || !anim2.isStarted()) continue;
                    anim2.end();
                }
            } else {
                while (this.mLastEventId < this.mEvents.size() - 1) {
                    ++this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim3 = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim3).mEnded) continue;
                    if (event.mEvent == 0) {
                        anim3.start();
                        continue;
                    }
                    if (event.mEvent != 2 || !anim3.isStarted()) continue;
                    anim3.end();
                }
            }
            this.mPlayingSet.clear();
        }
        this.endAnimation();
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isRunning() {
        if (this.mStartDelay == 0L) {
            return this.mStarted;
        }
        return this.mLastFrameTime > 0L;
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isStarted() {
        return this.mStarted;
    }

    private final long $$robo$$android_animation_AnimatorSet$getStartDelay() {
        return this.mStartDelay;
    }

    private final void $$robo$$android_animation_AnimatorSet$setStartDelay(long startDelay) {
        long delta;
        if (startDelay < 0L) {
            Log.w("AnimatorSet", "Start delay should always be non-negative");
            startDelay = 0L;
        }
        if ((delta = startDelay - this.mStartDelay) == 0L) {
            return;
        }
        this.mStartDelay = startDelay;
        if (!this.mDependencyDirty) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                if (node == this.mRootNode) {
                    node.mEndTime = this.mStartDelay;
                    continue;
                }
                node.mStartTime = node.mStartTime == -1L ? -1L : node.mStartTime + delta;
                node.mEndTime = node.mEndTime == -1L ? -1L : node.mEndTime + delta;
            }
            if (this.mTotalDuration != -1L) {
                this.mTotalDuration += delta;
            }
        }
    }

    private final long $$robo$$android_animation_AnimatorSet$getDuration() {
        return this.mDuration;
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDependencyDirty = true;
        this.mDuration = duration;
        return this;
    }

    private final void $$robo$$android_animation_AnimatorSet$setupStartValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupStartValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$setupEndValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupEndValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$pause() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$resume() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused && this.mPauseTime >= 0L) {
            this.addAnimationCallback(0L);
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$start() {
        this.start(false, true);
    }

    private final void $$robo$$android_animation_AnimatorSet$startWithoutPulsing(boolean inReverse) {
        this.start(inReverse, false);
    }

    private final void $$robo$$android_animation_AnimatorSet$initAnimation() {
        if (this.mInterpolator != null) {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setInterpolator(this.mInterpolator);
            }
        }
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
    }

    private final void $$robo$$android_animation_AnimatorSet$start(boolean inReverse, boolean selfPulse) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mStarted = true;
        this.mSelfPulse = selfPulse;
        this.mPaused = false;
        this.mPauseTime = -1L;
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            node.mEnded = false;
            node.mAnimation.setAllowRunningAsynchronously(false);
        }
        this.initAnimation();
        if (inReverse && !this.canReverse()) {
            throw new UnsupportedOperationException("Cannot reverse infinite AnimatorSet");
        }
        this.mReversing = inReverse;
        boolean isEmptySet = AnimatorSet.isEmptySet(this);
        if (!isEmptySet) {
            this.startAnimation();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this, inReverse);
            }
        }
        if (isEmptySet) {
            this.end();
        }
    }

    private static final boolean $$robo$$android_animation_AnimatorSet$isEmptySet(AnimatorSet set) {
        if (set.getStartDelay() > 0L) {
            return false;
        }
        for (int i = 0; i < set.getChildAnimations().size(); ++i) {
            Animator anim2 = set.getChildAnimations().get(i);
            if (!(anim2 instanceof AnimatorSet)) {
                return false;
            }
            if (AnimatorSet.isEmptySet((AnimatorSet)anim2)) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_animation_AnimatorSet$updateAnimatorsDuration() {
        if (this.mDuration >= 0L) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setDuration(this.mDuration);
            }
        }
        this.mDelayAnim.setDuration(this.mStartDelay);
    }

    private final void $$robo$$android_animation_AnimatorSet$skipToEndValue(boolean inReverse) {
        if (!this.isInitialized()) {
            throw new UnsupportedOperationException("Children must be initialized.");
        }
        this.initAnimation();
        if (inReverse) {
            for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                if (this.mEvents.get((int)i).mEvent != 1) continue;
                this.mEvents.get((int)i).mNode.mAnimation.skipToEndValue(true);
            }
        } else {
            for (int i = 0; i < this.mEvents.size(); ++i) {
                if (this.mEvents.get((int)i).mEvent != 2) continue;
                this.mEvents.get((int)i).mNode.mAnimation.skipToEndValue(false);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        AnimationEvent event;
        int i;
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        if (inReverse) {
            if (this.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Cannot reverse AnimatorSet with infinite duration");
            }
            long duration = this.getTotalDuration() - this.mStartDelay;
            currentPlayTime = Math.min(currentPlayTime, duration);
            currentPlayTime = duration - currentPlayTime;
            lastPlayTime = duration - lastPlayTime;
            inReverse = false;
        }
        this.skipToStartValue(false);
        ArrayList<Node> unfinishedNodes = new ArrayList<Node>();
        for (i = 0; i < this.mEvents.size() && (event = this.mEvents.get(i)).getTime() <= currentPlayTime && event.getTime() != -1L; ++i) {
            if (event.mEvent == 1 && (event.mNode.mEndTime == -1L || event.mNode.mEndTime > currentPlayTime)) {
                unfinishedNodes.add(event.mNode);
            }
            if (event.mEvent != 2) continue;
            event.mNode.mAnimation.skipToEndValue(false);
        }
        for (i = 0; i < unfinishedNodes.size(); ++i) {
            Node node = (Node)unfinishedNodes.get(i);
            long playTime = this.getPlayTimeForNode(currentPlayTime, node, inReverse);
            if (!inReverse) {
                playTime -= node.mAnimation.getStartDelay();
            }
            node.mAnimation.animateBasedOnPlayTime(playTime, lastPlayTime, inReverse);
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isInitialized() {
        if (this.mChildrenInitialized) {
            return true;
        }
        boolean allInitialized = true;
        for (int i = 0; i < this.mNodes.size(); ++i) {
            if (this.mNodes.get((int)i).mAnimation.isInitialized()) continue;
            allInitialized = false;
            break;
        }
        this.mChildrenInitialized = allInitialized;
        return this.mChildrenInitialized;
    }

    private final void $$robo$$android_animation_AnimatorSet$skipToStartValue(boolean inReverse) {
        this.skipToEndValue(!inReverse);
    }

    private final void $$robo$$android_animation_AnimatorSet$setCurrentPlayTime(long playTime) {
        if (this.mReversing && this.getTotalDuration() == -1L) {
            throw new UnsupportedOperationException("Error: Cannot seek in reverse in an infinite AnimatorSet");
        }
        if (this.getTotalDuration() != -1L && playTime > this.getTotalDuration() - this.mStartDelay || playTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should always be in between0 and duration.");
        }
        this.initAnimation();
        if (!this.isStarted()) {
            if (this.mReversing) {
                throw new UnsupportedOperationException("Error: Something went wrong. mReversing should not be set when AnimatorSet is not started.");
            }
            if (!this.mSeekState.isActive()) {
                this.findLatestEventIdForTime(0L);
                this.initChildren();
                this.skipToStartValue(this.mReversing);
                this.mSeekState.setPlayTime(0L, this.mReversing);
            }
            this.animateBasedOnPlayTime(playTime, 0L, this.mReversing);
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        } else {
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        }
    }

    private final long $$robo$$android_animation_AnimatorSet$getCurrentPlayTime() {
        if (this.mSeekState.isActive()) {
            return this.mSeekState.getPlayTime();
        }
        if (this.mLastFrameTime == -1L) {
            return 0L;
        }
        float durationScale = ValueAnimator.getDurationScale();
        float f = durationScale = durationScale == 0.0f ? 1.0f : durationScale;
        if (this.mReversing) {
            return (long)((float)(this.mLastFrameTime - this.mFirstFrame) / durationScale);
        }
        return (long)((float)(this.mLastFrameTime - this.mFirstFrame - this.mStartDelay) / durationScale);
    }

    private final void $$robo$$android_animation_AnimatorSet$initChildren() {
        if (!this.isInitialized()) {
            this.mChildrenInitialized = true;
            this.skipToEndValue(false);
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$doAnimationFrame(long frameTime) {
        int i;
        float durationScale = ValueAnimator.getDurationScale();
        if (durationScale == 0.0f) {
            this.forceToEnd();
            return true;
        }
        if (this.mFirstFrame < 0L) {
            this.mFirstFrame = frameTime;
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mPauseTime > 0L) {
            this.mFirstFrame += frameTime - this.mPauseTime;
            this.mPauseTime = -1L;
        }
        if (this.mSeekState.isActive()) {
            this.mSeekState.updateSeekDirection(this.mReversing);
            this.mFirstFrame = this.mReversing ? (long)((float)frameTime - (float)this.mSeekState.getPlayTime() * durationScale) : (long)((float)frameTime - (float)(this.mSeekState.getPlayTime() + this.mStartDelay) * durationScale);
            this.mSeekState.reset();
        }
        if (!this.mReversing && (float)frameTime < (float)this.mFirstFrame + (float)this.mStartDelay * durationScale) {
            return false;
        }
        long unscaledPlayTime = (long)((float)(frameTime - this.mFirstFrame) / durationScale);
        this.mLastFrameTime = frameTime;
        int latestId = this.findLatestEventIdForTime(unscaledPlayTime);
        int startId = this.mLastEventId;
        this.handleAnimationEvents(startId, latestId, unscaledPlayTime);
        this.mLastEventId = latestId;
        for (i = 0; i < this.mPlayingSet.size(); ++i) {
            Node node = this.mPlayingSet.get(i);
            if (node.mEnded) continue;
            this.pulseFrame(node, this.getPlayTimeForNode(unscaledPlayTime, node));
        }
        for (i = this.mPlayingSet.size() - 1; i >= 0; --i) {
            if (!this.mPlayingSet.get((int)i).mEnded) continue;
            this.mPlayingSet.remove(i);
        }
        boolean finished = false;
        if (this.mReversing) {
            if (this.mPlayingSet.size() == 1 && this.mPlayingSet.get(0) == this.mRootNode) {
                finished = true;
            } else if (this.mPlayingSet.isEmpty() && this.mLastEventId < 3) {
                finished = true;
            }
        } else {
            boolean bl = finished = this.mPlayingSet.isEmpty() && this.mLastEventId == this.mEvents.size() - 1;
        }
        if (finished) {
            this.endAnimation();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_animation_AnimatorSet$commitAnimationFrame(long frameTime) {
    }

    private final boolean $$robo$$android_animation_AnimatorSet$pulseAnimationFrame(long frameTime) {
        return this.doAnimationFrame(frameTime);
    }

    private final void $$robo$$android_animation_AnimatorSet$handleAnimationEvents(int startId, int latestId, long playTime) {
        if (this.mReversing) {
            startId = startId == -1 ? this.mEvents.size() : startId;
            for (int i = startId - 1; i >= latestId; --i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 2) {
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    this.mPlayingSet.add(event.mNode);
                    node.mAnimation.startWithoutPulsing(true);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 1 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        } else {
            for (int i = startId + 1; i <= latestId; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 0) {
                    this.mPlayingSet.add(event.mNode);
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    node.mAnimation.startWithoutPulsing(false);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 2 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$pulseFrame(Node node, long animPlayTime) {
        if (!node.mEnded) {
            float durationScale = ValueAnimator.getDurationScale();
            durationScale = durationScale == 0.0f ? 1.0f : durationScale;
            node.mEnded = node.mAnimation.pulseAnimationFrame((long)((float)animPlayTime * durationScale));
        }
    }

    private final long $$robo$$android_animation_AnimatorSet$getPlayTimeForNode(long overallPlayTime, Node node) {
        return this.getPlayTimeForNode(overallPlayTime, node, this.mReversing);
    }

    private final long $$robo$$android_animation_AnimatorSet$getPlayTimeForNode(long overallPlayTime, Node node, boolean inReverse) {
        if (inReverse) {
            overallPlayTime = this.getTotalDuration() - overallPlayTime;
            return node.mEndTime - overallPlayTime;
        }
        return overallPlayTime - node.mStartTime;
    }

    private final void $$robo$$android_animation_AnimatorSet$startAnimation() {
        this.addDummyListener();
        this.addAnimationCallback(0L);
        if (this.mSeekState.getPlayTimeNormalized() == 0L && this.mReversing) {
            this.mSeekState.reset();
        }
        if (this.mShouldResetValuesAtStart) {
            if (this.isInitialized()) {
                this.skipToEndValue(!this.mReversing);
            } else if (this.mReversing) {
                this.initChildren();
                this.skipToEndValue(!this.mReversing);
            } else {
                for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                    Animator anim2;
                    if (this.mEvents.get((int)i).mEvent != 1 || !(anim2 = this.mEvents.get((int)i).mNode.mAnimation).isInitialized()) continue;
                    anim2.skipToEndValue(true);
                }
            }
        }
        if (this.mReversing || this.mStartDelay == 0L || this.mSeekState.isActive()) {
            long playTime;
            if (this.mSeekState.isActive()) {
                this.mSeekState.updateSeekDirection(this.mReversing);
                playTime = this.mSeekState.getPlayTime();
            } else {
                playTime = 0L;
            }
            int toId = this.findLatestEventIdForTime(playTime);
            this.handleAnimationEvents(-1, toId, playTime);
            for (int i = this.mPlayingSet.size() - 1; i >= 0; --i) {
                if (!this.mPlayingSet.get((int)i).mEnded) continue;
                this.mPlayingSet.remove(i);
            }
            this.mLastEventId = toId;
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$addDummyListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.addListener(this.mDummyListener);
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$removeDummyListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.removeListener(this.mDummyListener);
        }
    }

    private final int $$robo$$android_animation_AnimatorSet$findLatestEventIdForTime(long currentPlayTime) {
        int size = this.mEvents.size();
        int latestId = this.mLastEventId;
        if (this.mReversing) {
            currentPlayTime = this.getTotalDuration() - currentPlayTime;
            this.mLastEventId = this.mLastEventId == -1 ? size : this.mLastEventId;
            for (int j = this.mLastEventId - 1; j >= 0; --j) {
                AnimationEvent event = this.mEvents.get(j);
                if (event.getTime() < currentPlayTime) continue;
                latestId = j;
            }
        } else {
            for (int i = this.mLastEventId + 1; i < size; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                if (event.getTime() == -1L || event.getTime() > currentPlayTime) continue;
                latestId = i;
            }
        }
        return latestId;
    }

    private final void $$robo$$android_animation_AnimatorSet$endAnimation() {
        this.mStarted = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrame = -1L;
        this.mLastEventId = -1;
        this.mPaused = false;
        this.mPauseTime = -1L;
        this.mSeekState.reset();
        this.mPlayingSet.clear();
        this.removeAnimationCallback();
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this, this.mReversing);
            }
        }
        this.removeDummyListener();
        this.mSelfPulse = true;
        this.mReversing = false;
    }

    private final void $$robo$$android_animation_AnimatorSet$removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.removeCallback(this);
    }

    private final void $$robo$$android_animation_AnimatorSet$addAnimationCallback(long delay) {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addAnimationFrameCallback(this, delay);
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$clone() {
        Object nodeClone;
        Node node;
        AnimatorSet anim2 = (AnimatorSet)super.clone();
        int nodeCount = this.mNodes.size();
        anim2.mStarted = false;
        anim2.mLastFrameTime = -1L;
        anim2.mFirstFrame = -1L;
        anim2.mLastEventId = -1;
        anim2.mPaused = false;
        anim2.mPauseTime = -1L;
        anim2.mSeekState = new SeekState(this, null);
        anim2.mSelfPulse = true;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new ArrayMap();
        anim2.mNodes = new ArrayList(nodeCount);
        anim2.mEvents = new ArrayList();
        anim2.mDummyListener = new ShadowedObject(this, anim2){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimatorSet val$anim;
            /* synthetic */ AnimatorSet this$0;

            private void $$robo$$android_animation_AnimatorSet_2$__constructor__(AnimatorSet this$0, AnimatorSet animatorSet) {
                this.this$0 = this$0;
                this.val$anim = animatorSet;
            }

            private final void $$robo$$android_animation_AnimatorSet_2$onAnimationEnd(Animator animation) {
                if (this.val$anim.mNodeMap.get(animation) == null) {
                    throw new AndroidRuntimeException("Error: animation ended is not in the node map");
                }
                ((Node)((AnimatorSet)this.val$anim).mNodeMap.get((Object)animation)).mEnded = true;
            }

            private void __constructor__(AnimatorSet animatorSet, AnimatorSet animatorSet2) {
                this.$$robo$$android_animation_AnimatorSet_2$__constructor__(animatorSet, animatorSet2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_2$__constructor__(android.animation.AnimatorSet android.animation.AnimatorSet ), this, animatorSet, animatorSet2);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_2$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        anim2.mReversing = false;
        anim2.mDependencyDirty = true;
        HashMap<Node, Object> clonesMap = new HashMap<Node, Object>(nodeCount);
        for (int n = 0; n < nodeCount; ++n) {
            node = this.mNodes.get(n);
            nodeClone = node.clone();
            ((Node)nodeClone).mAnimation.removeListener(this.mDummyListener);
            clonesMap.put(node, nodeClone);
            anim2.mNodes.add((Node)nodeClone);
            anim2.mNodeMap.put(((Node)nodeClone).mAnimation, (Node)nodeClone);
        }
        anim2.mRootNode = (Node)clonesMap.get(this.mRootNode);
        anim2.mDelayAnim = (ValueAnimator)anim2.mRootNode.mAnimation;
        for (int i = 0; i < nodeCount; ++i) {
            int j;
            node = this.mNodes.get(i);
            nodeClone = (Node)clonesMap.get(node);
            ((Node)nodeClone).mLatestParent = node.mLatestParent == null ? null : (Node)clonesMap.get(node.mLatestParent);
            int size = node.mChildNodes == null ? 0 : node.mChildNodes.size();
            for (j = 0; j < size; ++j) {
                ((Node)nodeClone).mChildNodes.set(j, (Node)clonesMap.get(node.mChildNodes.get(j)));
            }
            size = node.mSiblings == null ? 0 : node.mSiblings.size();
            for (j = 0; j < size; ++j) {
                ((Node)nodeClone).mSiblings.set(j, (Node)clonesMap.get(node.mSiblings.get(j)));
            }
            size = node.mParents == null ? 0 : node.mParents.size();
            for (j = 0; j < size; ++j) {
                ((Node)nodeClone).mParents.set(j, (Node)clonesMap.get(node.mParents.get(j)));
            }
        }
        return anim2;
    }

    private final boolean $$robo$$android_animation_AnimatorSet$canReverse() {
        return this.getTotalDuration() != -1L;
    }

    private final void $$robo$$android_animation_AnimatorSet$reverse() {
        this.start(true, true);
    }

    private final String $$robo$$android_animation_AnimatorSet$toString() {
        String returnVal = "AnimatorSet@" + Integer.toHexString(this.hashCode()) + "{";
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            returnVal = returnVal + "\n    " + node.mAnimation.toString();
        }
        return returnVal + "\n}";
    }

    private final void $$robo$$android_animation_AnimatorSet$printChildCount() {
        ArrayList<Node> list = new ArrayList<Node>(this.mNodes.size());
        list.add(this.mRootNode);
        Log.d("AnimatorSet", "Current tree: ");
        int index = 0;
        while (index < list.size()) {
            int listSize = list.size();
            StringBuilder builder = new StringBuilder();
            while (index < listSize) {
                Node node = (Node)list.get(index);
                int num = 0;
                if (node.mChildNodes != null) {
                    for (int i = 0; i < node.mChildNodes.size(); ++i) {
                        Node child = node.mChildNodes.get(i);
                        if (child.mLatestParent != node) continue;
                        ++num;
                        list.add(child);
                    }
                }
                builder.append(" ");
                builder.append(num);
                ++index;
            }
            Log.d("AnimatorSet", builder.toString());
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$createDependencyGraph() {
        Node node;
        int i;
        if (!this.mDependencyDirty) {
            boolean durationChanged = false;
            for (i = 0; i < this.mNodes.size(); ++i) {
                Animator anim2 = this.mNodes.get((int)i).mAnimation;
                if (this.mNodes.get((int)i).mTotalDuration == anim2.getTotalDuration()) continue;
                durationChanged = true;
                break;
            }
            if (!durationChanged) {
                return;
            }
        }
        this.mDependencyDirty = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            this.mNodes.get((int)i).mParentsAdded = false;
        }
        for (i = 0; i < size; ++i) {
            int j;
            node = this.mNodes.get(i);
            if (node.mParentsAdded) continue;
            node.mParentsAdded = true;
            if (node.mSiblings == null) continue;
            this.findSiblings(node, node.mSiblings);
            node.mSiblings.remove(node);
            int siblingSize = node.mSiblings.size();
            for (j = 0; j < siblingSize; ++j) {
                node.addParents(node.mSiblings.get((int)j).mParents);
            }
            for (j = 0; j < siblingSize; ++j) {
                Node sibling = node.mSiblings.get(j);
                sibling.addParents(node.mParents);
                sibling.mParentsAdded = true;
            }
        }
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            if (node == this.mRootNode || node.mParents != null) continue;
            node.addParent(this.mRootNode);
        }
        ArrayList<Node> visited = new ArrayList<Node>(this.mNodes.size());
        this.mRootNode.mStartTime = 0L;
        this.mRootNode.mEndTime = this.mDelayAnim.getDuration();
        this.updatePlayTime(this.mRootNode, visited);
        this.sortAnimationEvents();
        this.mTotalDuration = this.mEvents.get(this.mEvents.size() - 1).getTime();
    }

    private final void $$robo$$android_animation_AnimatorSet$sortAnimationEvents() {
        this.mEvents.clear();
        for (int i = 1; i < this.mNodes.size(); ++i) {
            Node node = this.mNodes.get(i);
            this.mEvents.add(new AnimationEvent(node, 0));
            this.mEvents.add(new AnimationEvent(node, 1));
            this.mEvents.add(new AnimationEvent(node, 2));
        }
        this.mEvents.sort(new Comparator<AnimationEvent>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimatorSet this$0;

            private void $$robo$$android_animation_AnimatorSet_3$__constructor__(AnimatorSet this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_animation_AnimatorSet_3$compare(AnimationEvent e1, AnimationEvent e2) {
                long t2;
                long t1 = e1.getTime();
                if (t1 == (t2 = e2.getTime())) {
                    if (e2.mEvent + e1.mEvent == 1) {
                        return e1.mEvent - e2.mEvent;
                    }
                    return e2.mEvent - e1.mEvent;
                }
                if (t2 == -1L) {
                    return -1;
                }
                if (t1 == -1L) {
                    return 1;
                }
                return (int)(t1 - t2);
            }

            private void __constructor__(AnimatorSet animatorSet) {
                this.$$robo$$android_animation_AnimatorSet_3$__constructor__(animatorSet);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_3$__constructor__(android.animation.AnimatorSet ), this, animatorSet);
            }

            @Override
            public int compare(AnimationEvent animationEvent, AnimationEvent animationEvent2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_animation_AnimatorSet_3$compare(android.animation.AnimatorSet$AnimationEvent android.animation.AnimatorSet$AnimationEvent ), this, animationEvent, animationEvent2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        int eventSize = this.mEvents.size();
        int i = 0;
        while (i < eventSize) {
            AnimationEvent event = this.mEvents.get(i);
            if (event.mEvent == 2) {
                boolean needToSwapStart;
                if (event.mNode.mStartTime == event.mNode.mEndTime) {
                    needToSwapStart = true;
                } else if (event.mNode.mEndTime == event.mNode.mStartTime + event.mNode.mAnimation.getStartDelay()) {
                    needToSwapStart = false;
                } else {
                    ++i;
                    continue;
                }
                int startEventId = eventSize;
                int startDelayEndId = eventSize;
                for (int j = i + 1; j < eventSize && (startEventId >= eventSize || startDelayEndId >= eventSize); ++j) {
                    if (this.mEvents.get((int)j).mNode != event.mNode) continue;
                    if (this.mEvents.get((int)j).mEvent == 0) {
                        startEventId = j;
                        continue;
                    }
                    if (this.mEvents.get((int)j).mEvent != 1) continue;
                    startDelayEndId = j;
                }
                if (needToSwapStart && startEventId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no start isfound after stop for an animation that has the same start and endtime.");
                }
                if (startDelayEndId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no startdelay end is found after stop for an animation");
                }
                if (needToSwapStart) {
                    AnimationEvent startEvent = this.mEvents.remove(startEventId);
                    this.mEvents.add(i, startEvent);
                    ++i;
                }
                AnimationEvent startDelayEndEvent = this.mEvents.remove(startDelayEndId);
                this.mEvents.add(i, startDelayEndEvent);
                i += 2;
                continue;
            }
            ++i;
        }
        if (!this.mEvents.isEmpty() && this.mEvents.get((int)0).mEvent != 0) {
            throw new UnsupportedOperationException("Sorting went bad, the start event should always be at index 0");
        }
        this.mEvents.add(0, new AnimationEvent(this.mRootNode, 0));
        this.mEvents.add(1, new AnimationEvent(this.mRootNode, 1));
        this.mEvents.add(2, new AnimationEvent(this.mRootNode, 2));
        if (this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 0 || this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 1) {
            throw new UnsupportedOperationException("Something went wrong, the last event is not an end event");
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$updatePlayTime(Node parent, ArrayList<Node> visited) {
        if (parent.mChildNodes == null) {
            if (parent == this.mRootNode) {
                for (int i = 0; i < this.mNodes.size(); ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mStartTime = -1L;
                    node.mEndTime = -1L;
                }
            }
            return;
        }
        visited.add(parent);
        int childrenSize = parent.mChildNodes.size();
        for (int i = 0; i < childrenSize; ++i) {
            Node child = parent.mChildNodes.get(i);
            child.mTotalDuration = child.mAnimation.getTotalDuration();
            int index = visited.indexOf(child);
            if (index >= 0) {
                for (int j = index; j < visited.size(); ++j) {
                    visited.get((int)j).mLatestParent = null;
                    visited.get((int)j).mStartTime = -1L;
                    visited.get((int)j).mEndTime = -1L;
                }
                child.mStartTime = -1L;
                child.mEndTime = -1L;
                child.mLatestParent = null;
                Log.w("AnimatorSet", "Cycle found in AnimatorSet: " + this);
                continue;
            }
            if (child.mStartTime != -1L) {
                if (parent.mEndTime == -1L) {
                    child.mLatestParent = parent;
                    child.mStartTime = -1L;
                    child.mEndTime = -1L;
                } else {
                    if (parent.mEndTime >= child.mStartTime) {
                        child.mLatestParent = parent;
                        child.mStartTime = parent.mEndTime;
                    }
                    child.mEndTime = child.mTotalDuration == -1L ? -1L : child.mStartTime + child.mTotalDuration;
                }
            }
            this.updatePlayTime(child, visited);
        }
        visited.remove(parent);
    }

    private final void $$robo$$android_animation_AnimatorSet$findSiblings(Node node, ArrayList<Node> siblings) {
        if (!siblings.contains(node)) {
            siblings.add(node);
            if (node.mSiblings == null) {
                return;
            }
            for (int i = 0; i < node.mSiblings.size(); ++i) {
                this.findSiblings(node.mSiblings.get(i), siblings);
            }
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$shouldPlayTogether() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mRootNode.mChildNodes == null || this.mRootNode.mChildNodes.size() == this.mNodes.size() - 1;
    }

    private final long $$robo$$android_animation_AnimatorSet$getTotalDuration() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mTotalDuration;
    }

    private final Node $$robo$$android_animation_AnimatorSet$getNodeForAnimation(Animator anim2) {
        Node node = this.mNodeMap.get(anim2);
        if (node == null) {
            node = new Node(anim2);
            this.mNodeMap.put(anim2, node);
            this.mNodes.add(node);
        }
        return node;
    }

    private void __constructor__() {
        this.$$robo$$android_animation_AnimatorSet$__constructor__();
    }

    public AnimatorSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet$__constructor__(), this);
    }

    public void playTogether(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(android.animation.Animator[] ), this, animatorArray);
    }

    public void playTogether(Collection<Animator> collection) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(java.util.Collection<android.animation.Animator> ), this, collection);
    }

    public void playSequentially(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(android.animation.Animator[] ), this, animatorArray);
    }

    public void playSequentially(List<Animator> list) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(java.util.List<android.animation.Animator> ), this, list);
    }

    public ArrayList<Animator> getChildAnimations() {
        return InvokeDynamicSupport.bootstrap("getChildAnimations", $$robo$$android_animation_AnimatorSet$getChildAnimations(), this);
    }

    @Override
    public void setTarget(Object object) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_animation_AnimatorSet$setTarget(java.lang.Object ), this, object);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_animation_AnimatorSet$getChangingConfigurations(), this);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_AnimatorSet$setInterpolator(android.animation.TimeInterpolator ), this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_AnimatorSet$getInterpolator(), this);
    }

    public Builder play(Animator animator2) {
        return InvokeDynamicSupport.bootstrap("play", $$robo$$android_animation_AnimatorSet$play(android.animation.Animator ), this, animator2);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_AnimatorSet$cancel(), this);
    }

    private void forceToEnd() {
        InvokeDynamicSupport.bootstrap("forceToEnd", $$robo$$android_animation_AnimatorSet$forceToEnd(), this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_animation_AnimatorSet$end(), this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_AnimatorSet$isRunning(), this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_animation_AnimatorSet$isStarted(), this);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_AnimatorSet$getStartDelay(), this);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_AnimatorSet$setStartDelay(long ), this, l);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_AnimatorSet$getDuration(), this);
    }

    @Override
    public AnimatorSet setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_AnimatorSet$setDuration(long ), this, l);
    }

    @Override
    public void setupStartValues() {
        InvokeDynamicSupport.bootstrap("setupStartValues", $$robo$$android_animation_AnimatorSet$setupStartValues(), this);
    }

    @Override
    public void setupEndValues() {
        InvokeDynamicSupport.bootstrap("setupEndValues", $$robo$$android_animation_AnimatorSet$setupEndValues(), this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_animation_AnimatorSet$pause(), this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_animation_AnimatorSet$resume(), this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_AnimatorSet$start(), this);
    }

    @Override
    void startWithoutPulsing(boolean bl) {
        InvokeDynamicSupport.bootstrap("startWithoutPulsing", $$robo$$android_animation_AnimatorSet$startWithoutPulsing(boolean ), this, bl);
    }

    private void initAnimation() {
        InvokeDynamicSupport.bootstrap("initAnimation", $$robo$$android_animation_AnimatorSet$initAnimation(), this);
    }

    private void start(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_AnimatorSet$start(boolean boolean ), this, bl, bl2);
    }

    private static boolean isEmptySet(AnimatorSet animatorSet) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmptySet", $$robo$$android_animation_AnimatorSet$isEmptySet(android.animation.AnimatorSet ), (AnimatorSet)animatorSet);
    }

    private void updateAnimatorsDuration() {
        InvokeDynamicSupport.bootstrap("updateAnimatorsDuration", $$robo$$android_animation_AnimatorSet$updateAnimatorsDuration(), this);
    }

    @Override
    void skipToEndValue(boolean bl) {
        InvokeDynamicSupport.bootstrap("skipToEndValue", $$robo$$android_animation_AnimatorSet$skipToEndValue(boolean ), this, bl);
    }

    @Override
    void animateBasedOnPlayTime(long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrap("animateBasedOnPlayTime", $$robo$$android_animation_AnimatorSet$animateBasedOnPlayTime(long long boolean ), this, l, l2, bl);
    }

    @Override
    boolean isInitialized() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInitialized", $$robo$$android_animation_AnimatorSet$isInitialized(), this);
    }

    private void skipToStartValue(boolean bl) {
        InvokeDynamicSupport.bootstrap("skipToStartValue", $$robo$$android_animation_AnimatorSet$skipToStartValue(boolean ), this, bl);
    }

    public void setCurrentPlayTime(long l) {
        InvokeDynamicSupport.bootstrap("setCurrentPlayTime", $$robo$$android_animation_AnimatorSet$setCurrentPlayTime(long ), this, l);
    }

    public long getCurrentPlayTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentPlayTime", $$robo$$android_animation_AnimatorSet$getCurrentPlayTime(), this);
    }

    private void initChildren() {
        InvokeDynamicSupport.bootstrap("initChildren", $$robo$$android_animation_AnimatorSet$initChildren(), this);
    }

    @Override
    public boolean doAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("doAnimationFrame", $$robo$$android_animation_AnimatorSet$doAnimationFrame(long ), this, l);
    }

    @Override
    public void commitAnimationFrame(long l) {
        InvokeDynamicSupport.bootstrap("commitAnimationFrame", $$robo$$android_animation_AnimatorSet$commitAnimationFrame(long ), this, l);
    }

    @Override
    boolean pulseAnimationFrame(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("pulseAnimationFrame", $$robo$$android_animation_AnimatorSet$pulseAnimationFrame(long ), this, l);
    }

    private void handleAnimationEvents(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("handleAnimationEvents", $$robo$$android_animation_AnimatorSet$handleAnimationEvents(int int long ), this, n, n2, l);
    }

    private void pulseFrame(Node node, long l) {
        InvokeDynamicSupport.bootstrap("pulseFrame", $$robo$$android_animation_AnimatorSet$pulseFrame(android.animation.AnimatorSet$Node long ), this, node, l);
    }

    private long getPlayTimeForNode(long l, Node node) {
        return (long)InvokeDynamicSupport.bootstrap("getPlayTimeForNode", $$robo$$android_animation_AnimatorSet$getPlayTimeForNode(long android.animation.AnimatorSet$Node ), this, l, node);
    }

    private long getPlayTimeForNode(long l, Node node, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getPlayTimeForNode", $$robo$$android_animation_AnimatorSet$getPlayTimeForNode(long android.animation.AnimatorSet$Node boolean ), this, l, node, bl);
    }

    private void startAnimation() {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_animation_AnimatorSet$startAnimation(), this);
    }

    private void addDummyListener() {
        InvokeDynamicSupport.bootstrap("addDummyListener", $$robo$$android_animation_AnimatorSet$addDummyListener(), this);
    }

    private void removeDummyListener() {
        InvokeDynamicSupport.bootstrap("removeDummyListener", $$robo$$android_animation_AnimatorSet$removeDummyListener(), this);
    }

    private int findLatestEventIdForTime(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findLatestEventIdForTime", $$robo$$android_animation_AnimatorSet$findLatestEventIdForTime(long ), this, l);
    }

    private void endAnimation() {
        InvokeDynamicSupport.bootstrap("endAnimation", $$robo$$android_animation_AnimatorSet$endAnimation(), this);
    }

    private void removeAnimationCallback() {
        InvokeDynamicSupport.bootstrap("removeAnimationCallback", $$robo$$android_animation_AnimatorSet$removeAnimationCallback(), this);
    }

    private void addAnimationCallback(long l) {
        InvokeDynamicSupport.bootstrap("addAnimationCallback", $$robo$$android_animation_AnimatorSet$addAnimationCallback(long ), this, l);
    }

    @Override
    public AnimatorSet clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet$clone(), this);
    }

    @Override
    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_animation_AnimatorSet$canReverse(), this);
    }

    @Override
    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_animation_AnimatorSet$reverse(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_AnimatorSet$toString(), this);
    }

    private void printChildCount() {
        InvokeDynamicSupport.bootstrap("printChildCount", $$robo$$android_animation_AnimatorSet$printChildCount(), this);
    }

    private void createDependencyGraph() {
        InvokeDynamicSupport.bootstrap("createDependencyGraph", $$robo$$android_animation_AnimatorSet$createDependencyGraph(), this);
    }

    private void sortAnimationEvents() {
        InvokeDynamicSupport.bootstrap("sortAnimationEvents", $$robo$$android_animation_AnimatorSet$sortAnimationEvents(), this);
    }

    private void updatePlayTime(Node node, ArrayList<Node> arrayList) {
        InvokeDynamicSupport.bootstrap("updatePlayTime", $$robo$$android_animation_AnimatorSet$updatePlayTime(android.animation.AnimatorSet$Node java.util.ArrayList<android.animation.AnimatorSet$Node> ), this, node, arrayList);
    }

    private void findSiblings(Node node, ArrayList<Node> arrayList) {
        InvokeDynamicSupport.bootstrap("findSiblings", $$robo$$android_animation_AnimatorSet$findSiblings(android.animation.AnimatorSet$Node java.util.ArrayList<android.animation.AnimatorSet$Node> ), this, node, arrayList);
    }

    public boolean shouldPlayTogether() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldPlayTogether", $$robo$$android_animation_AnimatorSet$shouldPlayTogether(), this);
    }

    @Override
    public long getTotalDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_animation_AnimatorSet$getTotalDuration(), this);
    }

    private Node getNodeForAnimation(Animator animator2) {
        return InvokeDynamicSupport.bootstrap("getNodeForAnimation", $$robo$$android_animation_AnimatorSet$getNodeForAnimation(android.animation.Animator ), this, animator2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatorSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Node mCurrentNode;
        /* synthetic */ AnimatorSet this$0;

        private void $$robo$$android_animation_AnimatorSet_Builder$__constructor__(AnimatorSet this$0, Animator anim2) {
            this.this$0 = this$0;
            this$0.mDependencyDirty = true;
            this.mCurrentNode = this$0.getNodeForAnimation(anim2);
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$with(Animator anim2) {
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addSibling(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$before(Animator anim2) {
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addChild(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(Animator anim2) {
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addParent(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }

        private void __constructor__(AnimatorSet animatorSet, Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Builder$__constructor__(animatorSet, animator2);
        }

        public Builder(AnimatorSet animatorSet, Animator animator2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Builder$__constructor__(android.animation.AnimatorSet android.animation.Animator ), this, animatorSet, animator2);
        }

        public Builder with(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("with", $$robo$$android_animation_AnimatorSet_Builder$with(android.animation.Animator ), this, animator2);
        }

        public Builder before(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("before", $$robo$$android_animation_AnimatorSet_Builder$before(android.animation.Animator ), this, animator2);
        }

        public Builder after(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(android.animation.Animator ), this, animator2);
        }

        public Builder after(long l) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(long ), this, l);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SeekState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mPlayTime;
        private boolean mSeekingInReverse;
        /* synthetic */ AnimatorSet this$0;

        private void $$robo$$android_animation_AnimatorSet_SeekState$__constructor__(AnimatorSet animatorSet) {
            this.this$0 = animatorSet;
            this.mPlayTime = -1L;
            this.mSeekingInReverse = false;
        }

        private final void $$robo$$android_animation_AnimatorSet_SeekState$reset() {
            this.mPlayTime = -1L;
            this.mSeekingInReverse = false;
        }

        private final void $$robo$$android_animation_AnimatorSet_SeekState$setPlayTime(long playTime, boolean inReverse) {
            if (this.this$0.getTotalDuration() != -1L) {
                this.mPlayTime = Math.min(playTime, this.this$0.getTotalDuration() - this.this$0.mStartDelay);
            }
            this.mPlayTime = Math.max(0L, this.mPlayTime);
            this.mSeekingInReverse = inReverse;
        }

        private final void $$robo$$android_animation_AnimatorSet_SeekState$updateSeekDirection(boolean inReverse) {
            if (inReverse && this.this$0.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Error: Cannot reverse infinite animator set");
            }
            if (this.mPlayTime >= 0L && inReverse != this.mSeekingInReverse) {
                this.mPlayTime = this.this$0.getTotalDuration() - this.this$0.mStartDelay - this.mPlayTime;
                this.mSeekingInReverse = inReverse;
            }
        }

        private final long $$robo$$android_animation_AnimatorSet_SeekState$getPlayTime() {
            return this.mPlayTime;
        }

        private final long $$robo$$android_animation_AnimatorSet_SeekState$getPlayTimeNormalized() {
            if (this.this$0.mReversing) {
                return this.this$0.getTotalDuration() - this.this$0.mStartDelay - this.mPlayTime;
            }
            return this.mPlayTime;
        }

        private final boolean $$robo$$android_animation_AnimatorSet_SeekState$isActive() {
            return this.mPlayTime != -1L;
        }

        private /* synthetic */ void $$robo$$android_animation_AnimatorSet_SeekState$__constructor__(AnimatorSet x0, 1 x1) {
        }

        private void __constructor__(AnimatorSet animatorSet) {
            this.$$robo$$android_animation_AnimatorSet_SeekState$__constructor__(animatorSet);
        }

        public SeekState(AnimatorSet animatorSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_SeekState$__constructor__(android.animation.AnimatorSet ), this, animatorSet);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_animation_AnimatorSet_SeekState$reset(), this);
        }

        void setPlayTime(long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("setPlayTime", $$robo$$android_animation_AnimatorSet_SeekState$setPlayTime(long boolean ), this, l, bl);
        }

        void updateSeekDirection(boolean bl) {
            InvokeDynamicSupport.bootstrap("updateSeekDirection", $$robo$$android_animation_AnimatorSet_SeekState$updateSeekDirection(boolean ), this, bl);
        }

        long getPlayTime() {
            return (long)InvokeDynamicSupport.bootstrap("getPlayTime", $$robo$$android_animation_AnimatorSet_SeekState$getPlayTime(), this);
        }

        long getPlayTimeNormalized() {
            return (long)InvokeDynamicSupport.bootstrap("getPlayTimeNormalized", $$robo$$android_animation_AnimatorSet_SeekState$getPlayTimeNormalized(), this);
        }

        boolean isActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_animation_AnimatorSet_SeekState$isActive(), this);
        }

        private /* synthetic */ void __constructor__(AnimatorSet animatorSet, 1 var2_2) {
            this.$$robo$$android_animation_AnimatorSet_SeekState$__constructor__(animatorSet, var2_2);
        }

        public /* synthetic */ SeekState(AnimatorSet animatorSet, 1 var2_2) {
            this(animatorSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_SeekState$__constructor__(android.animation.AnimatorSet android.animation.AnimatorSet$1 ), this, animatorSet, var2_2);
        }

        public /* synthetic */ SeekState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SeekState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimationEvent
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int ANIMATION_START = 0;
        static int ANIMATION_DELAY_ENDED = 1;
        static int ANIMATION_END = 2;
        Node mNode;
        int mEvent;

        private void $$robo$$android_animation_AnimatorSet_AnimationEvent$__constructor__(Node node, int event) {
            this.mNode = node;
            this.mEvent = event;
        }

        private final long $$robo$$android_animation_AnimatorSet_AnimationEvent$getTime() {
            if (this.mEvent == 0) {
                return this.mNode.mStartTime;
            }
            if (this.mEvent == 1) {
                return this.mNode.mStartTime == -1L ? -1L : this.mNode.mStartTime + this.mNode.mAnimation.getStartDelay();
            }
            return this.mNode.mEndTime;
        }

        private final String $$robo$$android_animation_AnimatorSet_AnimationEvent$toString() {
            String eventStr = this.mEvent == 0 ? "start" : (this.mEvent == 1 ? "delay ended" : "end");
            return eventStr + " " + this.mNode.mAnimation.toString();
        }

        private void __constructor__(Node node, int n) {
            this.$$robo$$android_animation_AnimatorSet_AnimationEvent$__constructor__(node, n);
        }

        public AnimationEvent(Node node, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_AnimationEvent$__constructor__(android.animation.AnimatorSet$Node int ), this, node, n);
        }

        long getTime() {
            return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_animation_AnimatorSet_AnimationEvent$getTime(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_AnimatorSet_AnimationEvent$toString(), this);
        }

        public /* synthetic */ AnimationEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Node
    implements Cloneable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Animator mAnimation;
        ArrayList<Node> mChildNodes;
        boolean mEnded;
        ArrayList<Node> mSiblings;
        ArrayList<Node> mParents;
        Node mLatestParent;
        boolean mParentsAdded;
        long mStartTime;
        long mEndTime;
        long mTotalDuration;

        private void $$robo$$android_animation_AnimatorSet_Node$__constructor__(Animator animation) {
            this.mChildNodes = null;
            this.mEnded = false;
            this.mLatestParent = null;
            this.mParentsAdded = false;
            this.mStartTime = 0L;
            this.mEndTime = 0L;
            this.mTotalDuration = 0L;
            this.mAnimation = animation;
        }

        private final Node $$robo$$android_animation_AnimatorSet_Node$clone() {
            try {
                Node node = (Node)super.clone();
                node.mAnimation = this.mAnimation.clone();
                if (this.mChildNodes != null) {
                    node.mChildNodes = new ArrayList<Node>(this.mChildNodes);
                }
                if (this.mSiblings != null) {
                    node.mSiblings = new ArrayList<Node>(this.mSiblings);
                }
                if (this.mParents != null) {
                    node.mParents = new ArrayList<Node>(this.mParents);
                }
                node.mEnded = false;
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addChild(Node node) {
            if (this.mChildNodes == null) {
                this.mChildNodes = new ArrayList();
            }
            if (!this.mChildNodes.contains(node)) {
                this.mChildNodes.add(node);
                node.addParent(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addSibling(Node node) {
            if (this.mSiblings == null) {
                this.mSiblings = new ArrayList();
            }
            if (!this.mSiblings.contains(node)) {
                this.mSiblings.add(node);
                node.addSibling(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addParent(Node node) {
            if (this.mParents == null) {
                this.mParents = new ArrayList();
            }
            if (!this.mParents.contains(node)) {
                this.mParents.add(node);
                node.addChild(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addParents(ArrayList<Node> parents) {
            if (parents == null) {
                return;
            }
            int size = parents.size();
            for (int i = 0; i < size; ++i) {
                this.addParent(parents.get(i));
            }
        }

        private void __constructor__(Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Node$__constructor__(animator2);
        }

        public Node(Animator animator2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Node$__constructor__(android.animation.Animator ), this, animator2);
        }

        public Node clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet_Node$clone(), this);
        }

        void addChild(Node node) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_animation_AnimatorSet_Node$addChild(android.animation.AnimatorSet$Node ), this, node);
        }

        public void addSibling(Node node) {
            InvokeDynamicSupport.bootstrap("addSibling", $$robo$$android_animation_AnimatorSet_Node$addSibling(android.animation.AnimatorSet$Node ), this, node);
        }

        public void addParent(Node node) {
            InvokeDynamicSupport.bootstrap("addParent", $$robo$$android_animation_AnimatorSet_Node$addParent(android.animation.AnimatorSet$Node ), this, node);
        }

        public void addParents(ArrayList<Node> arrayList) {
            InvokeDynamicSupport.bootstrap("addParents", $$robo$$android_animation_AnimatorSet_Node$addParents(java.util.ArrayList<android.animation.AnimatorSet$Node> ), this, arrayList);
        }

        public /* synthetic */ Node() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

