/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityButtonController;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.FingerprintGestureController;
import android.accessibilityservice.GestureDescription;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AccessibilityService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int GESTURE_SWIPE_UP = 1;
    public static int GESTURE_SWIPE_DOWN = 2;
    public static int GESTURE_SWIPE_LEFT = 3;
    public static int GESTURE_SWIPE_RIGHT = 4;
    public static int GESTURE_SWIPE_LEFT_AND_RIGHT = 5;
    public static int GESTURE_SWIPE_RIGHT_AND_LEFT = 6;
    public static int GESTURE_SWIPE_UP_AND_DOWN = 7;
    public static int GESTURE_SWIPE_DOWN_AND_UP = 8;
    public static int GESTURE_SWIPE_LEFT_AND_UP = 9;
    public static int GESTURE_SWIPE_LEFT_AND_DOWN = 10;
    public static int GESTURE_SWIPE_RIGHT_AND_UP = 11;
    public static int GESTURE_SWIPE_RIGHT_AND_DOWN = 12;
    public static int GESTURE_SWIPE_UP_AND_LEFT = 13;
    public static int GESTURE_SWIPE_UP_AND_RIGHT = 14;
    public static int GESTURE_SWIPE_DOWN_AND_LEFT = 15;
    public static int GESTURE_SWIPE_DOWN_AND_RIGHT = 16;
    public static String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    public static String SERVICE_META_DATA = "android.accessibilityservice";
    public static int GLOBAL_ACTION_BACK = 1;
    public static int GLOBAL_ACTION_HOME = 2;
    public static int GLOBAL_ACTION_RECENTS = 3;
    public static int GLOBAL_ACTION_NOTIFICATIONS = 4;
    public static int GLOBAL_ACTION_QUICK_SETTINGS = 5;
    public static int GLOBAL_ACTION_POWER_DIALOG = 6;
    public static int GLOBAL_ACTION_TOGGLE_SPLIT_SCREEN = 7;
    public static int GLOBAL_ACTION_LOCK_SCREEN = 8;
    public static int GLOBAL_ACTION_TAKE_SCREENSHOT = 9;
    private static String LOG_TAG = "AccessibilityService";
    public static int SHOW_MODE_AUTO = 0;
    public static int SHOW_MODE_HIDDEN = 1;
    private int mConnectionId;
    private AccessibilityServiceInfo mInfo;
    private IBinder mWindowToken;
    private WindowManager mWindowManager;
    private MagnificationController mMagnificationController;
    private SoftKeyboardController mSoftKeyboardController;
    private AccessibilityButtonController mAccessibilityButtonController;
    private int mGestureStatusCallbackSequence;
    private SparseArray<GestureResultCallbackInfo> mGestureStatusCallbackInfos;
    private Object mLock;
    private FingerprintGestureController mFingerprintGestureController;

    private void $$robo$$android_accessibilityservice_AccessibilityService$__constructor__() {
        this.mConnectionId = -1;
        this.mLock = new Object();
    }

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    public abstract void onInterrupt();

    private final void $$robo$$android_accessibilityservice_AccessibilityService$dispatchServiceConnected() {
        if (this.mMagnificationController != null) {
            this.mMagnificationController.onServiceConnected();
        }
        if (this.mSoftKeyboardController != null) {
            this.mSoftKeyboardController.onServiceConnected();
        }
        this.onServiceConnected();
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onServiceConnected() {
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$onGesture(int gestureId) {
        return false;
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$onKeyEvent(KeyEvent event) {
        return false;
    }

    private final List<AccessibilityWindowInfo> $$robo$$android_accessibilityservice_AccessibilityService$getWindows() {
        return AccessibilityInteractionClient.getInstance().getWindows(this.mConnectionId);
    }

    private final AccessibilityNodeInfo $$robo$$android_accessibilityservice_AccessibilityService$getRootInActiveWindow() {
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(this.mConnectionId);
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$disableSelf() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                connection.disableSelf();
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MagnificationController $$robo$$android_accessibilityservice_AccessibilityService$getMagnificationController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMagnificationController == null) {
                this.mMagnificationController = new MagnificationController(this, this.mLock);
            }
            return this.mMagnificationController;
        }
    }

    private final FingerprintGestureController $$robo$$android_accessibilityservice_AccessibilityService$getFingerprintGestureController() {
        if (this.mFingerprintGestureController == null) {
            AccessibilityInteractionClient.getInstance();
            this.mFingerprintGestureController = new FingerprintGestureController(AccessibilityInteractionClient.getConnection(this.mConnectionId));
        }
        return this.mFingerprintGestureController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$dispatchGesture(GestureDescription gesture, GestureResultCallback callback, Handler handler) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection == null) {
            return false;
        }
        List<GestureDescription.GestureStep> steps = GestureDescription.MotionEventGenerator.getGestureStepsFromGestureDescription(gesture, 100);
        try {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mGestureStatusCallbackSequence;
                if (callback != null) {
                    if (this.mGestureStatusCallbackInfos == null) {
                        this.mGestureStatusCallbackInfos = new SparseArray();
                    }
                    GestureResultCallbackInfo callbackInfo = new GestureResultCallbackInfo(gesture, callback, handler);
                    this.mGestureStatusCallbackInfos.put(this.mGestureStatusCallbackSequence, callbackInfo);
                }
                connection.sendGesture(this.mGestureStatusCallbackSequence, new ParceledListSlice<GestureDescription.GestureStep>(steps));
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_AccessibilityService$onPerformGestureResult(int sequence, boolean completedSuccessfully) {
        GestureResultCallbackInfo callbackInfo;
        if (this.mGestureStatusCallbackInfos == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callbackInfo = this.mGestureStatusCallbackInfos.get(sequence);
        }
        GestureResultCallbackInfo finalCallbackInfo = callbackInfo;
        if (callbackInfo != null && callbackInfo.gestureDescription != null && callbackInfo.callback != null) {
            if (callbackInfo.handler != null) {
                callbackInfo.handler.post(new Runnable(this, completedSuccessfully, finalCallbackInfo){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ boolean val$completedSuccessfully;
                    /* synthetic */ GestureResultCallbackInfo val$finalCallbackInfo;
                    /* synthetic */ AccessibilityService this$0;

                    private void $$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(AccessibilityService this$0, boolean bl, GestureResultCallbackInfo gestureResultCallbackInfo) {
                        this.this$0 = this$0;
                        this.val$completedSuccessfully = bl;
                        this.val$finalCallbackInfo = gestureResultCallbackInfo;
                    }

                    private final void $$robo$$android_accessibilityservice_AccessibilityService_1$run() {
                        if (this.val$completedSuccessfully) {
                            this.val$finalCallbackInfo.callback.onCompleted(this.val$finalCallbackInfo.gestureDescription);
                        } else {
                            this.val$finalCallbackInfo.callback.onCancelled(this.val$finalCallbackInfo.gestureDescription);
                        }
                    }

                    private void __constructor__(AccessibilityService accessibilityService, boolean bl, GestureResultCallbackInfo gestureResultCallbackInfo) {
                        this.$$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(accessibilityService, bl, gestureResultCallbackInfo);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_1$__constructor__(android.accessibilityservice.AccessibilityService boolean android.accessibilityservice.AccessibilityService$GestureResultCallbackInfo ), this, accessibilityService, bl, gestureResultCallbackInfo);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_accessibilityservice_AccessibilityService_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                return;
            }
            if (completedSuccessfully) {
                callbackInfo.callback.onCompleted(callbackInfo.gestureDescription);
            } else {
                callbackInfo.callback.onCancelled(callbackInfo.gestureDescription);
            }
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onMagnificationChanged(Region region, float scale, float centerX, float centerY) {
        if (this.mMagnificationController != null) {
            this.mMagnificationController.dispatchMagnificationChanged(region, scale, centerX, centerY);
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onFingerprintCapturingGesturesChanged(boolean active) {
        this.getFingerprintGestureController().onGestureDetectionActiveChanged(active);
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onFingerprintGesture(int gesture) {
        this.getFingerprintGestureController().onGesture(gesture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SoftKeyboardController $$robo$$android_accessibilityservice_AccessibilityService$getSoftKeyboardController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSoftKeyboardController == null) {
                this.mSoftKeyboardController = new SoftKeyboardController(this, this.mLock);
            }
            return this.mSoftKeyboardController;
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onSoftKeyboardShowModeChanged(int showMode) {
        if (this.mSoftKeyboardController != null) {
            this.mSoftKeyboardController.dispatchSoftKeyboardShowModeChanged(showMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityButtonController $$robo$$android_accessibilityservice_AccessibilityService$getAccessibilityButtonController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityButtonController == null) {
                AccessibilityInteractionClient.getInstance();
                this.mAccessibilityButtonController = new AccessibilityButtonController(AccessibilityInteractionClient.getConnection(this.mConnectionId));
            }
            return this.mAccessibilityButtonController;
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onAccessibilityButtonClicked() {
        this.getAccessibilityButtonController().dispatchAccessibilityButtonClicked();
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$onAccessibilityButtonAvailabilityChanged(boolean available) {
        this.getAccessibilityButtonController().dispatchAccessibilityButtonAvailabilityChanged(available);
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityService$performGlobalAction(int action) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while calling performGlobalAction", re);
                re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final AccessibilityNodeInfo $$robo$$android_accessibilityservice_AccessibilityService$findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    private final AccessibilityServiceInfo $$robo$$android_accessibilityservice_AccessibilityService$getServiceInfo() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while getting AccessibilityServiceInfo", re);
                re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$setServiceInfo(AccessibilityServiceInfo info) {
        this.mInfo = info;
        this.sendServiceInfo();
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityService$sendServiceInfo() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (this.mInfo != null && connection != null) {
            try {
                connection.setServiceInfo(this.mInfo);
                this.mInfo = null;
                AccessibilityInteractionClient.getInstance().clearCache();
            }
            catch (RemoteException re) {
                Log.w("AccessibilityService", "Error while setting AccessibilityServiceInfo", re);
                re.rethrowFromSystemServer();
            }
        }
    }

    private final Object $$robo$$android_accessibilityservice_AccessibilityService$getSystemService(String name) {
        if (this.getBaseContext() == null) {
            throw new IllegalStateException("System services not available to Activities before onCreate()");
        }
        if ("window".equals(name)) {
            if (this.mWindowManager == null) {
                this.mWindowManager = (WindowManager)this.getBaseContext().getSystemService(name);
            }
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    private final IBinder $$robo$$android_accessibilityservice_AccessibilityService$onBind(Intent intent) {
        return new IAccessibilityServiceClientWrapper(this, this.getMainLooper(), new Callbacks(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AccessibilityService this$0;

            private void $$robo$$android_accessibilityservice_AccessibilityService_2$__constructor__(AccessibilityService this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onServiceConnected() {
                this.this$0.dispatchServiceConnected();
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onInterrupt() {
                this.this$0.onInterrupt();
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityEvent(AccessibilityEvent event) {
                this.this$0.onAccessibilityEvent(event);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$init(int connectionId, IBinder windowToken) {
                this.this$0.mConnectionId = connectionId;
                this.this$0.mWindowToken = windowToken;
                WindowManagerImpl wm = (WindowManagerImpl)this.this$0.getSystemService("window");
                wm.setDefaultToken(windowToken);
            }

            private final boolean $$robo$$android_accessibilityservice_AccessibilityService_2$onGesture(int gestureId) {
                return this.this$0.onGesture(gestureId);
            }

            private final boolean $$robo$$android_accessibilityservice_AccessibilityService_2$onKeyEvent(KeyEvent event) {
                return this.this$0.onKeyEvent(event);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onMagnificationChanged(Region region, float scale, float centerX, float centerY) {
                this.this$0.onMagnificationChanged(region, scale, centerX, centerY);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onSoftKeyboardShowModeChanged(int showMode) {
                this.this$0.onSoftKeyboardShowModeChanged(showMode);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                this.this$0.onPerformGestureResult(sequence, completedSuccessfully);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onFingerprintCapturingGesturesChanged(boolean active) {
                this.this$0.onFingerprintCapturingGesturesChanged(active);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onFingerprintGesture(int gesture) {
                this.this$0.onFingerprintGesture(gesture);
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityButtonClicked() {
                this.this$0.onAccessibilityButtonClicked();
            }

            private final void $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityButtonAvailabilityChanged(boolean available) {
                this.this$0.onAccessibilityButtonAvailabilityChanged(available);
            }

            private void __constructor__(AccessibilityService accessibilityService) {
                this.$$robo$$android_accessibilityservice_AccessibilityService_2$__constructor__(accessibilityService);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_2$__constructor__(android.accessibilityservice.AccessibilityService ), this, accessibilityService);
            }

            @Override
            public void onServiceConnected() {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService_2$onServiceConnected(), this);
            }

            @Override
            public void onInterrupt() {
                InvokeDynamicSupport.bootstrap("onInterrupt", $$robo$$android_accessibilityservice_AccessibilityService_2$onInterrupt(), this);
            }

            @Override
            public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
                InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
            }

            @Override
            public void init(int n, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("init", $$robo$$android_accessibilityservice_AccessibilityService_2$init(int android.os.IBinder ), this, n, iBinder);
            }

            @Override
            public boolean onGesture(int n) {
                return (boolean)InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService_2$onGesture(int ), this, n);
            }

            @Override
            public boolean onKeyEvent(KeyEvent keyEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService_2$onKeyEvent(android.view.KeyEvent ), this, keyEvent);
            }

            @Override
            public void onMagnificationChanged(Region region, float f, float f2, float f3) {
                InvokeDynamicSupport.bootstrap("onMagnificationChanged", $$robo$$android_accessibilityservice_AccessibilityService_2$onMagnificationChanged(android.graphics.Region float float float ), this, region, f, f2, f3);
            }

            @Override
            public void onSoftKeyboardShowModeChanged(int n) {
                InvokeDynamicSupport.bootstrap("onSoftKeyboardShowModeChanged", $$robo$$android_accessibilityservice_AccessibilityService_2$onSoftKeyboardShowModeChanged(int ), this, n);
            }

            @Override
            public void onPerformGestureResult(int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onPerformGestureResult", $$robo$$android_accessibilityservice_AccessibilityService_2$onPerformGestureResult(int boolean ), this, n, bl);
            }

            @Override
            public void onFingerprintCapturingGesturesChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onFingerprintCapturingGesturesChanged", $$robo$$android_accessibilityservice_AccessibilityService_2$onFingerprintCapturingGesturesChanged(boolean ), this, bl);
            }

            @Override
            public void onFingerprintGesture(int n) {
                InvokeDynamicSupport.bootstrap("onFingerprintGesture", $$robo$$android_accessibilityservice_AccessibilityService_2$onFingerprintGesture(int ), this, n);
            }

            @Override
            public void onAccessibilityButtonClicked() {
                InvokeDynamicSupport.bootstrap("onAccessibilityButtonClicked", $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityButtonClicked(), this);
            }

            @Override
            public void onAccessibilityButtonAvailabilityChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onAccessibilityButtonAvailabilityChanged", $$robo$$android_accessibilityservice_AccessibilityService_2$onAccessibilityButtonAvailabilityChanged(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private void __constructor__() {
        this.$$robo$$android_accessibilityservice_AccessibilityService$__constructor__();
    }

    public AccessibilityService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService$__constructor__(), this);
    }

    private void dispatchServiceConnected() {
        InvokeDynamicSupport.bootstrap("dispatchServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService$dispatchServiceConnected(), this);
    }

    protected void onServiceConnected() {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService$onServiceConnected(), this);
    }

    protected boolean onGesture(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService$onGesture(int ), this, n);
    }

    protected boolean onKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService$onKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return InvokeDynamicSupport.bootstrap("getWindows", $$robo$$android_accessibilityservice_AccessibilityService$getWindows(), this);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return InvokeDynamicSupport.bootstrap("getRootInActiveWindow", $$robo$$android_accessibilityservice_AccessibilityService$getRootInActiveWindow(), this);
    }

    public void disableSelf() {
        InvokeDynamicSupport.bootstrap("disableSelf", $$robo$$android_accessibilityservice_AccessibilityService$disableSelf(), this);
    }

    public MagnificationController getMagnificationController() {
        return InvokeDynamicSupport.bootstrap("getMagnificationController", $$robo$$android_accessibilityservice_AccessibilityService$getMagnificationController(), this);
    }

    public FingerprintGestureController getFingerprintGestureController() {
        return InvokeDynamicSupport.bootstrap("getFingerprintGestureController", $$robo$$android_accessibilityservice_AccessibilityService$getFingerprintGestureController(), this);
    }

    public boolean dispatchGesture(GestureDescription gestureDescription, GestureResultCallback gestureResultCallback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGesture", $$robo$$android_accessibilityservice_AccessibilityService$dispatchGesture(android.accessibilityservice.GestureDescription android.accessibilityservice.AccessibilityService$GestureResultCallback android.os.Handler ), this, gestureDescription, gestureResultCallback, handler);
    }

    void onPerformGestureResult(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onPerformGestureResult", $$robo$$android_accessibilityservice_AccessibilityService$onPerformGestureResult(int boolean ), this, n, bl);
    }

    private void onMagnificationChanged(Region region, float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("onMagnificationChanged", $$robo$$android_accessibilityservice_AccessibilityService$onMagnificationChanged(android.graphics.Region float float float ), this, region, f, f2, f3);
    }

    private void onFingerprintCapturingGesturesChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onFingerprintCapturingGesturesChanged", $$robo$$android_accessibilityservice_AccessibilityService$onFingerprintCapturingGesturesChanged(boolean ), this, bl);
    }

    private void onFingerprintGesture(int n) {
        InvokeDynamicSupport.bootstrap("onFingerprintGesture", $$robo$$android_accessibilityservice_AccessibilityService$onFingerprintGesture(int ), this, n);
    }

    public SoftKeyboardController getSoftKeyboardController() {
        return InvokeDynamicSupport.bootstrap("getSoftKeyboardController", $$robo$$android_accessibilityservice_AccessibilityService$getSoftKeyboardController(), this);
    }

    private void onSoftKeyboardShowModeChanged(int n) {
        InvokeDynamicSupport.bootstrap("onSoftKeyboardShowModeChanged", $$robo$$android_accessibilityservice_AccessibilityService$onSoftKeyboardShowModeChanged(int ), this, n);
    }

    public AccessibilityButtonController getAccessibilityButtonController() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityButtonController", $$robo$$android_accessibilityservice_AccessibilityService$getAccessibilityButtonController(), this);
    }

    private void onAccessibilityButtonClicked() {
        InvokeDynamicSupport.bootstrap("onAccessibilityButtonClicked", $$robo$$android_accessibilityservice_AccessibilityService$onAccessibilityButtonClicked(), this);
    }

    private void onAccessibilityButtonAvailabilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onAccessibilityButtonAvailabilityChanged", $$robo$$android_accessibilityservice_AccessibilityService$onAccessibilityButtonAvailabilityChanged(boolean ), this, bl);
    }

    public boolean performGlobalAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performGlobalAction", $$robo$$android_accessibilityservice_AccessibilityService$performGlobalAction(int ), this, n);
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_accessibilityservice_AccessibilityService$findFocus(int ), this, n);
    }

    public AccessibilityServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$getServiceInfo(), this);
    }

    public void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        InvokeDynamicSupport.bootstrap("setServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$setServiceInfo(android.accessibilityservice.AccessibilityServiceInfo ), this, accessibilityServiceInfo);
    }

    private void sendServiceInfo() {
        InvokeDynamicSupport.bootstrap("sendServiceInfo", $$robo$$android_accessibilityservice_AccessibilityService$sendServiceInfo(), this);
    }

    @Override
    public Object getSystemService(String string2) {
        return InvokeDynamicSupport.bootstrap("getSystemService", $$robo$$android_accessibilityservice_AccessibilityService$getSystemService(java.lang.String ), this, string2);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_accessibilityservice_AccessibilityService$onBind(android.content.Intent ), this, intent);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class GestureResultCallbackInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        GestureDescription gestureDescription;
        GestureResultCallback callback;
        Handler handler;

        private void $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallbackInfo$__constructor__(GestureDescription gestureDescription, GestureResultCallback callback, Handler handler) {
            this.gestureDescription = gestureDescription;
            this.callback = callback;
            this.handler = handler;
        }

        private void __constructor__(GestureDescription gestureDescription, GestureResultCallback gestureResultCallback, Handler handler) {
            this.$$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallbackInfo$__constructor__(gestureDescription, gestureResultCallback, handler);
        }

        public GestureResultCallbackInfo(GestureDescription gestureDescription, GestureResultCallback gestureResultCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallbackInfo$__constructor__(android.accessibilityservice.GestureDescription android.accessibilityservice.AccessibilityService$GestureResultCallback android.os.Handler ), this, gestureDescription, gestureResultCallback, handler);
        }

        public /* synthetic */ GestureResultCallbackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureResultCallbackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class GestureResultCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$__constructor__() {
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$onCompleted(GestureDescription gestureDescription) {
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$onCancelled(GestureDescription gestureDescription) {
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$__constructor__();
        }

        public GestureResultCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$__constructor__(), this);
        }

        public void onCompleted(GestureDescription gestureDescription) {
            InvokeDynamicSupport.bootstrap("onCompleted", $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$onCompleted(android.accessibilityservice.GestureDescription ), this, gestureDescription);
        }

        public void onCancelled(GestureDescription gestureDescription) {
            InvokeDynamicSupport.bootstrap("onCancelled", $$robo$$android_accessibilityservice_AccessibilityService_GestureResultCallback$onCancelled(android.accessibilityservice.GestureDescription ), this, gestureDescription);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureResultCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IAccessibilityServiceClientWrapper
    extends IAccessibilityServiceClient.Stub
    implements HandlerCaller.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DO_INIT = 1;
        private static int DO_ON_INTERRUPT = 2;
        private static int DO_ON_ACCESSIBILITY_EVENT = 3;
        private static int DO_ON_GESTURE = 4;
        private static int DO_CLEAR_ACCESSIBILITY_CACHE = 5;
        private static int DO_ON_KEY_EVENT = 6;
        private static int DO_ON_MAGNIFICATION_CHANGED = 7;
        private static int DO_ON_SOFT_KEYBOARD_SHOW_MODE_CHANGED = 8;
        private static int DO_GESTURE_COMPLETE = 9;
        private static int DO_ON_FINGERPRINT_ACTIVE_CHANGED = 10;
        private static int DO_ON_FINGERPRINT_GESTURE = 11;
        private static int DO_ACCESSIBILITY_BUTTON_CLICKED = 12;
        private static int DO_ACCESSIBILITY_BUTTON_AVAILABILITY_CHANGED = 13;
        private HandlerCaller mCaller;
        private Callbacks mCallback;
        private int mConnectionId;

        private void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(Context context, Looper looper, Callbacks callback) {
            this.mConnectionId = -1;
            this.mCallback = callback;
            this.mCaller = new HandlerCaller(context, looper, this, true);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$init(IAccessibilityServiceConnection connection, int connectionId, IBinder windowToken) {
            Message message = this.mCaller.obtainMessageIOO(1, connectionId, connection, windowToken);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onInterrupt() {
            Message message = this.mCaller.obtainMessage(2);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityEvent(AccessibilityEvent event, boolean serviceWantsEvent) {
            Message message = this.mCaller.obtainMessageBO(3, serviceWantsEvent, event);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onGesture(int gestureId) {
            Message message = this.mCaller.obtainMessageI(4, gestureId);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$clearAccessibilityCache() {
            Message message = this.mCaller.obtainMessage(5);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onKeyEvent(KeyEvent event, int sequence) {
            Message message = this.mCaller.obtainMessageIO(6, sequence, event);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onMagnificationChanged(Region region, float scale, float centerX, float centerY) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = region;
            args.arg2 = Float.valueOf(scale);
            args.arg3 = Float.valueOf(centerX);
            args.arg4 = Float.valueOf(centerY);
            Message message = this.mCaller.obtainMessageO(7, args);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onSoftKeyboardShowModeChanged(int showMode) {
            Message message = this.mCaller.obtainMessageI(8, showMode);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onPerformGestureResult(int sequence, boolean successfully) {
            Message message = this.mCaller.obtainMessageII(9, sequence, successfully ? 1 : 0);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onFingerprintCapturingGesturesChanged(boolean active) {
            this.mCaller.sendMessage(this.mCaller.obtainMessageI(10, active ? 1 : 0));
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onFingerprintGesture(int gesture) {
            this.mCaller.sendMessage(this.mCaller.obtainMessageI(11, gesture));
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityButtonClicked() {
            Message message = this.mCaller.obtainMessage(12);
            this.mCaller.sendMessage(message);
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityButtonAvailabilityChanged(boolean available) {
            Message message = this.mCaller.obtainMessageI(13, available ? 1 : 0);
            this.mCaller.sendMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$executeMessage(Message message) {
            switch (message.what) {
                case 3: {
                    boolean serviceWantsEvent;
                    AccessibilityEvent event = (AccessibilityEvent)message.obj;
                    boolean bl = serviceWantsEvent = message.arg1 != 0;
                    if (event != null) {
                        AccessibilityInteractionClient.getInstance().onAccessibilityEvent(event);
                        if (serviceWantsEvent && this.mConnectionId != -1) {
                            this.mCallback.onAccessibilityEvent(event);
                        }
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                case 2: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onInterrupt();
                    }
                    return;
                }
                case 1: {
                    this.mConnectionId = message.arg1;
                    SomeArgs args = (SomeArgs)message.obj;
                    IAccessibilityServiceConnection connection = (IAccessibilityServiceConnection)args.arg1;
                    IBinder windowToken = (IBinder)args.arg2;
                    args.recycle();
                    if (connection != null) {
                        AccessibilityInteractionClient.getInstance();
                        AccessibilityInteractionClient.addConnection(this.mConnectionId, connection);
                        this.mCallback.init(this.mConnectionId, windowToken);
                        this.mCallback.onServiceConnected();
                    } else {
                        AccessibilityInteractionClient.getInstance();
                        AccessibilityInteractionClient.removeConnection(this.mConnectionId);
                        this.mConnectionId = -1;
                        AccessibilityInteractionClient.getInstance().clearCache();
                        this.mCallback.init(-1, null);
                    }
                    return;
                }
                case 4: {
                    if (this.mConnectionId != -1) {
                        int gestureId = message.arg1;
                        this.mCallback.onGesture(gestureId);
                    }
                    return;
                }
                case 5: {
                    AccessibilityInteractionClient.getInstance().clearCache();
                    return;
                }
                case 6: {
                    KeyEvent event = (KeyEvent)message.obj;
                    try {
                        AccessibilityInteractionClient.getInstance();
                        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
                        if (connection != null) {
                            boolean result = this.mCallback.onKeyEvent(event);
                            int sequence = message.arg1;
                            try {
                                connection.setOnKeyEventResult(result, sequence);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException connection) {}
                    }
                    return;
                }
                case 7: {
                    if (this.mConnectionId != -1) {
                        SomeArgs args = (SomeArgs)message.obj;
                        Region region = (Region)args.arg1;
                        float scale = ((Float)args.arg2).floatValue();
                        float centerX = ((Float)args.arg3).floatValue();
                        float centerY = ((Float)args.arg4).floatValue();
                        this.mCallback.onMagnificationChanged(region, scale, centerX, centerY);
                    }
                    return;
                }
                case 8: {
                    if (this.mConnectionId != -1) {
                        int showMode = message.arg1;
                        this.mCallback.onSoftKeyboardShowModeChanged(showMode);
                    }
                    return;
                }
                case 9: {
                    if (this.mConnectionId != -1) {
                        boolean successfully = message.arg2 == 1;
                        this.mCallback.onPerformGestureResult(message.arg1, successfully);
                    }
                    return;
                }
                case 10: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onFingerprintCapturingGesturesChanged(message.arg1 == 1);
                    }
                    return;
                }
                case 11: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onFingerprintGesture(message.arg1);
                    }
                    return;
                }
                case 12: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onAccessibilityButtonClicked();
                    }
                    return;
                }
                case 13: {
                    if (this.mConnectionId != -1) {
                        boolean available = message.arg1 != 0;
                        this.mCallback.onAccessibilityButtonAvailabilityChanged(available);
                    }
                    return;
                }
            }
            Log.w("AccessibilityService", "Unknown message type " + message.what);
        }

        private void __constructor__(Context context, Looper looper, Callbacks callbacks) {
            this.$$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(context, looper, callbacks);
        }

        public IAccessibilityServiceClientWrapper(Context context, Looper looper, Callbacks callbacks) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$__constructor__(android.content.Context android.os.Looper android.accessibilityservice.AccessibilityService$Callbacks ), this, context, looper, callbacks);
        }

        @Override
        public void init(IAccessibilityServiceConnection iAccessibilityServiceConnection, int n, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$init(android.accessibilityservice.IAccessibilityServiceConnection int android.os.IBinder ), this, iAccessibilityServiceConnection, n, iBinder);
        }

        @Override
        public void onInterrupt() {
            InvokeDynamicSupport.bootstrap("onInterrupt", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onInterrupt(), this);
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent boolean ), this, accessibilityEvent, bl);
        }

        @Override
        public void onGesture(int n) {
            InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onGesture(int ), this, n);
        }

        @Override
        public void clearAccessibilityCache() {
            InvokeDynamicSupport.bootstrap("clearAccessibilityCache", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$clearAccessibilityCache(), this);
        }

        @Override
        public void onKeyEvent(KeyEvent keyEvent, int n) {
            InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onKeyEvent(android.view.KeyEvent int ), this, keyEvent, n);
        }

        @Override
        public void onMagnificationChanged(Region region, float f, float f2, float f3) {
            InvokeDynamicSupport.bootstrap("onMagnificationChanged", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onMagnificationChanged(android.graphics.Region float float float ), this, region, f, f2, f3);
        }

        @Override
        public void onSoftKeyboardShowModeChanged(int n) {
            InvokeDynamicSupport.bootstrap("onSoftKeyboardShowModeChanged", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onSoftKeyboardShowModeChanged(int ), this, n);
        }

        @Override
        public void onPerformGestureResult(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onPerformGestureResult", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onPerformGestureResult(int boolean ), this, n, bl);
        }

        @Override
        public void onFingerprintCapturingGesturesChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onFingerprintCapturingGesturesChanged", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onFingerprintCapturingGesturesChanged(boolean ), this, bl);
        }

        @Override
        public void onFingerprintGesture(int n) {
            InvokeDynamicSupport.bootstrap("onFingerprintGesture", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onFingerprintGesture(int ), this, n);
        }

        @Override
        public void onAccessibilityButtonClicked() {
            InvokeDynamicSupport.bootstrap("onAccessibilityButtonClicked", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityButtonClicked(), this);
        }

        @Override
        public void onAccessibilityButtonAvailabilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onAccessibilityButtonAvailabilityChanged", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$onAccessibilityButtonAvailabilityChanged(boolean ), this, bl);
        }

        @Override
        public void executeMessage(Message message) {
            InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_accessibilityservice_AccessibilityService_IAccessibilityServiceClientWrapper$executeMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ IAccessibilityServiceClientWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IAccessibilityServiceClientWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SoftKeyboardController
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AccessibilityService mService;
        private ArrayMap<OnShowModeChangedListener, Handler> mListeners;
        private Object mLock;

        private void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$__constructor__(AccessibilityService service, Object lock) {
            this.mService = service;
            this.mLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$onServiceConnected() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners != null && !this.mListeners.isEmpty()) {
                    this.setSoftKeyboardCallbackEnabled(true);
                }
            }
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$addOnShowModeChangedListener(OnShowModeChangedListener listener) {
            this.addOnShowModeChangedListener(listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$addOnShowModeChangedListener(OnShowModeChangedListener listener, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null) {
                    this.mListeners = new ArrayMap();
                }
                boolean shouldEnableCallback = this.mListeners.isEmpty();
                this.mListeners.put(listener, handler);
                if (shouldEnableCallback) {
                    this.setSoftKeyboardCallbackEnabled(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$removeOnShowModeChangedListener(OnShowModeChangedListener listener) {
            if (this.mListeners == null) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean hasKey;
                int keyIndex = this.mListeners.indexOfKey(listener);
                boolean bl = hasKey = keyIndex >= 0;
                if (hasKey) {
                    this.mListeners.removeAt(keyIndex);
                }
                if (hasKey && this.mListeners.isEmpty()) {
                    this.setSoftKeyboardCallbackEnabled(false);
                }
                return hasKey;
            }
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$setSoftKeyboardCallbackEnabled(boolean enabled) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    connection.setSoftKeyboardCallbackEnabled(enabled);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$dispatchSoftKeyboardShowModeChanged(int showMode) {
            ArrayMap<OnShowModeChangedListener, Handler> entries;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null || this.mListeners.isEmpty()) {
                    Slog.w("AccessibilityService", "Received soft keyboard show mode changed callback with no listeners registered!");
                    this.setSoftKeyboardCallbackEnabled(false);
                    return;
                }
                entries = new ArrayMap<OnShowModeChangedListener, Handler>(this.mListeners);
            }
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                OnShowModeChangedListener listener = entries.keyAt(i);
                Handler handler = entries.valueAt(i);
                if (handler != null) {
                    handler.post(new Runnable(this, listener, showMode){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ OnShowModeChangedListener val$listener;
                        /* synthetic */ int val$showMode;
                        /* synthetic */ SoftKeyboardController this$0;

                        private void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController_1$__constructor__(SoftKeyboardController this$0, OnShowModeChangedListener onShowModeChangedListener, int n) {
                            this.this$0 = this$0;
                            this.val$listener = onShowModeChangedListener;
                            this.val$showMode = n;
                        }

                        private final void $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController_1$run() {
                            this.val$listener.onShowModeChanged(this.this$0, this.val$showMode);
                        }

                        private void __constructor__(SoftKeyboardController softKeyboardController, OnShowModeChangedListener onShowModeChangedListener, int n) {
                            this.$$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController_1$__constructor__(softKeyboardController, onShowModeChangedListener, n);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController_1$__constructor__(android.accessibilityservice.AccessibilityService$SoftKeyboardController android.accessibilityservice.AccessibilityService$SoftKeyboardController$OnShowModeChangedListener int ), this, softKeyboardController, onShowModeChangedListener, n);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController_1$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    continue;
                }
                listener.onShowModeChanged(this, showMode);
            }
        }

        private final int $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$getShowMode() {
            try {
                return Settings.Secure.getInt(this.mService.getContentResolver(), "accessibility_soft_keyboard_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                Log.v("AccessibilityService", "Failed to obtain the soft keyboard mode", e);
                return 0;
            }
        }

        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$setShowMode(int showMode) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setSoftKeyboardShowMode(showMode);
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to set soft keyboard behavior", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        private void __constructor__(AccessibilityService accessibilityService, Object object) {
            this.$$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$__constructor__(accessibilityService, object);
        }

        public SoftKeyboardController(AccessibilityService accessibilityService, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$__constructor__(android.accessibilityservice.AccessibilityService java.lang.Object ), this, accessibilityService, object);
        }

        void onServiceConnected() {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$onServiceConnected(), this);
        }

        public void addOnShowModeChangedListener(OnShowModeChangedListener onShowModeChangedListener) {
            InvokeDynamicSupport.bootstrap("addOnShowModeChangedListener", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$addOnShowModeChangedListener(android.accessibilityservice.AccessibilityService$SoftKeyboardController$OnShowModeChangedListener ), this, onShowModeChangedListener);
        }

        public void addOnShowModeChangedListener(OnShowModeChangedListener onShowModeChangedListener, Handler handler) {
            InvokeDynamicSupport.bootstrap("addOnShowModeChangedListener", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$addOnShowModeChangedListener(android.accessibilityservice.AccessibilityService$SoftKeyboardController$OnShowModeChangedListener android.os.Handler ), this, onShowModeChangedListener, handler);
        }

        public boolean removeOnShowModeChangedListener(OnShowModeChangedListener onShowModeChangedListener) {
            return (boolean)InvokeDynamicSupport.bootstrap("removeOnShowModeChangedListener", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$removeOnShowModeChangedListener(android.accessibilityservice.AccessibilityService$SoftKeyboardController$OnShowModeChangedListener ), this, onShowModeChangedListener);
        }

        private void setSoftKeyboardCallbackEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSoftKeyboardCallbackEnabled", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$setSoftKeyboardCallbackEnabled(boolean ), this, bl);
        }

        void dispatchSoftKeyboardShowModeChanged(int n) {
            InvokeDynamicSupport.bootstrap("dispatchSoftKeyboardShowModeChanged", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$dispatchSoftKeyboardShowModeChanged(int ), this, n);
        }

        public int getShowMode() {
            return (int)InvokeDynamicSupport.bootstrap("getShowMode", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$getShowMode(), this);
        }

        public boolean setShowMode(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("setShowMode", $$robo$$android_accessibilityservice_AccessibilityService_SoftKeyboardController$setShowMode(int ), this, n);
        }

        public /* synthetic */ SoftKeyboardController() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoftKeyboardController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface OnShowModeChangedListener {
            public void onShowModeChanged(SoftKeyboardController var1, int var2);
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MagnificationController
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AccessibilityService mService;
        private ArrayMap<OnMagnificationChangedListener, Handler> mListeners;
        private Object mLock;

        private void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$__constructor__(AccessibilityService service, Object lock) {
            this.mService = service;
            this.mLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$onServiceConnected() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners != null && !this.mListeners.isEmpty()) {
                    this.setMagnificationCallbackEnabled(true);
                }
            }
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$addListener(OnMagnificationChangedListener listener) {
            this.addListener(listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$addListener(OnMagnificationChangedListener listener, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null) {
                    this.mListeners = new ArrayMap();
                }
                boolean shouldEnableCallback = this.mListeners.isEmpty();
                this.mListeners.put(listener, handler);
                if (shouldEnableCallback) {
                    this.setMagnificationCallbackEnabled(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$removeListener(OnMagnificationChangedListener listener) {
            if (this.mListeners == null) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean hasKey;
                int keyIndex = this.mListeners.indexOfKey(listener);
                boolean bl = hasKey = keyIndex >= 0;
                if (hasKey) {
                    this.mListeners.removeAt(keyIndex);
                }
                if (hasKey && this.mListeners.isEmpty()) {
                    this.setMagnificationCallbackEnabled(false);
                }
                return hasKey;
            }
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setMagnificationCallbackEnabled(boolean enabled) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    connection.setMagnificationCallbackEnabled(enabled);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$dispatchMagnificationChanged(Region region, float scale, float centerX, float centerY) {
            ArrayMap<OnMagnificationChangedListener, Handler> entries;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null || this.mListeners.isEmpty()) {
                    Slog.d("AccessibilityService", "Received magnification changed callback with no listeners registered!");
                    this.setMagnificationCallbackEnabled(false);
                    return;
                }
                entries = new ArrayMap<OnMagnificationChangedListener, Handler>(this.mListeners);
            }
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                OnMagnificationChangedListener listener = entries.keyAt(i);
                Handler handler = entries.valueAt(i);
                if (handler != null) {
                    handler.post(new Runnable(this, listener, region, scale, centerX, centerY){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ OnMagnificationChangedListener val$listener;
                        /* synthetic */ Region val$region;
                        /* synthetic */ float val$scale;
                        /* synthetic */ float val$centerX;
                        /* synthetic */ float val$centerY;
                        /* synthetic */ MagnificationController this$0;

                        private void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController_1$__constructor__(MagnificationController this$0, OnMagnificationChangedListener onMagnificationChangedListener, Region region, float f, float f2, float f3) {
                            this.this$0 = this$0;
                            this.val$listener = onMagnificationChangedListener;
                            this.val$region = region;
                            this.val$scale = f;
                            this.val$centerX = f2;
                            this.val$centerY = f3;
                        }

                        private final void $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController_1$run() {
                            this.val$listener.onMagnificationChanged(this.this$0, this.val$region, this.val$scale, this.val$centerX, this.val$centerY);
                        }

                        private void __constructor__(MagnificationController magnificationController, OnMagnificationChangedListener onMagnificationChangedListener, Region region, float f, float f2, float f3) {
                            this.$$robo$$android_accessibilityservice_AccessibilityService_MagnificationController_1$__constructor__(magnificationController, onMagnificationChangedListener, region, f, f2, f3);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController_1$__constructor__(android.accessibilityservice.AccessibilityService$MagnificationController android.accessibilityservice.AccessibilityService$MagnificationController$OnMagnificationChangedListener android.graphics.Region float float float ), this, magnificationController, onMagnificationChangedListener, region, f, f2, f3);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController_1$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    continue;
                }
                listener.onMagnificationChanged(this, region, scale, centerX, centerY);
            }
        }

        private final float $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getScale() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationScale();
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to obtain scale", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 1.0f;
        }

        private final float $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getCenterX() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationCenterX();
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to obtain center X", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 0.0f;
        }

        private final float $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getCenterY() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationCenterY();
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to obtain center Y", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 0.0f;
        }

        private final Region $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getMagnificationRegion() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationRegion();
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to obtain magnified region", re);
                    re.rethrowFromSystemServer();
                }
            }
            return Region.obtain();
        }

        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$reset(boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.resetMagnification(animate);
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to reset", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setScale(float scale, boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setMagnificationScaleAndCenter(scale, Float.NaN, Float.NaN, animate);
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to set scale", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        private final boolean $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setCenter(float centerX, float centerY, boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setMagnificationScaleAndCenter(Float.NaN, centerX, centerY, animate);
                }
                catch (RemoteException re) {
                    Log.w("AccessibilityService", "Failed to set center", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        private void __constructor__(AccessibilityService accessibilityService, Object object) {
            this.$$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$__constructor__(accessibilityService, object);
        }

        public MagnificationController(AccessibilityService accessibilityService, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$__constructor__(android.accessibilityservice.AccessibilityService java.lang.Object ), this, accessibilityService, object);
        }

        void onServiceConnected() {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$onServiceConnected(), this);
        }

        public void addListener(OnMagnificationChangedListener onMagnificationChangedListener) {
            InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$addListener(android.accessibilityservice.AccessibilityService$MagnificationController$OnMagnificationChangedListener ), this, onMagnificationChangedListener);
        }

        public void addListener(OnMagnificationChangedListener onMagnificationChangedListener, Handler handler) {
            InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$addListener(android.accessibilityservice.AccessibilityService$MagnificationController$OnMagnificationChangedListener android.os.Handler ), this, onMagnificationChangedListener, handler);
        }

        public boolean removeListener(OnMagnificationChangedListener onMagnificationChangedListener) {
            return (boolean)InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$removeListener(android.accessibilityservice.AccessibilityService$MagnificationController$OnMagnificationChangedListener ), this, onMagnificationChangedListener);
        }

        private void setMagnificationCallbackEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMagnificationCallbackEnabled", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setMagnificationCallbackEnabled(boolean ), this, bl);
        }

        void dispatchMagnificationChanged(Region region, float f, float f2, float f3) {
            InvokeDynamicSupport.bootstrap("dispatchMagnificationChanged", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$dispatchMagnificationChanged(android.graphics.Region float float float ), this, region, f, f2, f3);
        }

        public float getScale() {
            return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getScale(), this);
        }

        public float getCenterX() {
            return (float)InvokeDynamicSupport.bootstrap("getCenterX", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getCenterX(), this);
        }

        public float getCenterY() {
            return (float)InvokeDynamicSupport.bootstrap("getCenterY", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getCenterY(), this);
        }

        public Region getMagnificationRegion() {
            return InvokeDynamicSupport.bootstrap("getMagnificationRegion", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$getMagnificationRegion(), this);
        }

        public boolean reset(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$reset(boolean ), this, bl);
        }

        public boolean setScale(float f, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("setScale", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setScale(float boolean ), this, f, bl);
        }

        public boolean setCenter(float f, float f2, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("setCenter", $$robo$$android_accessibilityservice_AccessibilityService_MagnificationController$setCenter(float float boolean ), this, f, f2, bl);
        }

        public /* synthetic */ MagnificationController() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MagnificationController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface OnMagnificationChangedListener {
            public void onMagnificationChanged(MagnificationController var1, Region var2, float var3, float var4, float var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SoftKeyboardShowMode {
    }

    public static interface Callbacks {
        public void onAccessibilityEvent(AccessibilityEvent var1);

        public void onInterrupt();

        public void onServiceConnected();

        public void init(int var1, IBinder var2);

        public boolean onGesture(int var1);

        public boolean onKeyEvent(KeyEvent var1);

        public void onMagnificationChanged(Region var1, float var2, float var3, float var4);

        public void onSoftKeyboardShowModeChanged(int var1);

        public void onPerformGestureResult(int var1, boolean var2);

        public void onFingerprintCapturingGesturesChanged(boolean var1);

        public void onFingerprintGesture(int var1);

        public void onAccessibilityButtonClicked();

        public void onAccessibilityButtonAvailabilityChanged(boolean var1);
    }
}

