/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlSerializer;

public class KXmlSerializer
implements XmlSerializer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BUFFER_LEN = 8192;
    private char[] mText;
    private int mPos;
    private Writer writer;
    private boolean pending;
    private int auto;
    private int depth;
    private String[] elementStack;
    private int[] nspCounts;
    private String[] nspStack;
    private boolean[] indent;
    private boolean unicode;
    private String encoding;

    private void $$robo$$org_kxml2_io_KXmlSerializer$__constructor__() {
        this.mText = new char[8192];
        this.elementStack = new String[12];
        this.nspCounts = new int[4];
        this.nspStack = new String[8];
        this.indent = new boolean[4];
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$append(char c) throws IOException {
        if (this.mPos >= 8192) {
            this.flushBuffer();
        }
        this.mText[this.mPos++] = c;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$append(String str, int i, int length) throws IOException {
        while (length > 0) {
            int batch;
            if (this.mPos == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.mPos) > length) {
                batch = length;
            }
            str.getChars(i, i + batch, this.mText, this.mPos);
            i += batch;
            length -= batch;
            this.mPos += batch;
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$append(String str) throws IOException {
        this.append(str, 0, str.length());
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$flushBuffer() throws IOException {
        if (this.mPos > 0) {
            this.writer.write(this.mText, 0, this.mPos);
            this.writer.flush();
            this.mPos = 0;
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$check(boolean close) throws IOException {
        if (!this.pending) {
            return;
        }
        ++this.depth;
        this.pending = false;
        if (this.indent.length <= this.depth) {
            boolean[] hlp = new boolean[this.depth + 4];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (boolean[])this.indent, (int)0, (boolean[])hlp, (int)0, (int)this.depth);
            this.indent = hlp;
        }
        this.indent[this.depth] = this.indent[this.depth - 1];
        for (int i = this.nspCounts[this.depth - 1]; i < this.nspCounts[this.depth]; ++i) {
            this.append(" xmlns");
            if (!this.nspStack[i * 2].isEmpty()) {
                this.append(':');
                this.append(this.nspStack[i * 2]);
            } else if (this.getNamespace().isEmpty() && !this.nspStack[i * 2 + 1].isEmpty()) {
                throw new IllegalStateException("Cannot set default namespace for elements in no namespace");
            }
            this.append("=\"");
            this.writeEscaped(this.nspStack[i * 2 + 1], 34);
            this.append('\"');
        }
        if (this.nspCounts.length <= this.depth + 1) {
            int[] hlp = new int[this.depth + 8];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.nspCounts, (int)0, (int[])hlp, (int)0, (int)(this.depth + 1));
            this.nspCounts = hlp;
        }
        this.nspCounts[this.depth + 1] = this.nspCounts[this.depth];
        if (close) {
            this.append(" />");
        } else {
            this.append('>');
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$writeEscaped(String s, int quot) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    if (quot == -1) {
                        this.append(c);
                        continue block6;
                    }
                    this.append("&#" + c + ';');
                    continue block6;
                }
                case '&': {
                    this.append("&amp;");
                    continue block6;
                }
                case '>': {
                    this.append("&gt;");
                    continue block6;
                }
                case '<': {
                    this.append("&lt;");
                    continue block6;
                }
                default: {
                    boolean allowedInXml;
                    if (c == quot) {
                        this.append(c == '\"' ? "&quot;" : "&apos;");
                        continue block6;
                    }
                    boolean bl = allowedInXml = c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
                    if (allowedInXml) {
                        if (this.unicode || c < '\u007f') {
                            this.append(c);
                            continue block6;
                        }
                        this.append("&#" + c + ";");
                        continue block6;
                    }
                    if (Character.isHighSurrogate(c) && i < s.length() - 1) {
                        this.writeSurrogate(c, s.charAt(i + 1));
                        ++i;
                        continue block6;
                    }
                    KXmlSerializer.reportInvalidCharacter(c);
                }
            }
        }
    }

    private static final void $$robo$$org_kxml2_io_KXmlSerializer$reportInvalidCharacter(char ch) {
        throw new IllegalArgumentException("Illegal character (U+" + Integer.toHexString(ch) + ")");
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$docdecl(String dd) throws IOException {
        this.append("<!DOCTYPE");
        this.append(dd);
        this.append('>');
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elementStack[this.depth * 3 - 3], this.elementStack[this.depth * 3 - 1]);
        }
        this.flush();
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$entityRef(String name) throws IOException {
        this.check(false);
        this.append('&');
        this.append(name);
        this.append(';');
    }

    private final boolean $$robo$$org_kxml2_io_KXmlSerializer$getFeature(String name) {
        return "http://xmlpull.org/v1/doc/features.html#indent-output".equals(name) ? this.indent[this.depth] : false;
    }

    private final String $$robo$$org_kxml2_io_KXmlSerializer$getPrefix(String namespace, boolean create) {
        try {
            return this.getPrefix(namespace, false, create);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private final String $$robo$$org_kxml2_io_KXmlSerializer$getPrefix(String namespace, boolean includeDefault, boolean create) throws IOException {
        String prefix;
        for (int i = this.nspCounts[this.depth + 1] * 2 - 2; i >= 0; i -= 2) {
            if (!this.nspStack[i + 1].equals(namespace) || !includeDefault && this.nspStack[i].isEmpty()) continue;
            String cand = this.nspStack[i];
            for (int j = i + 2; j < this.nspCounts[this.depth + 1] * 2; ++j) {
                if (!this.nspStack[j].equals(cand)) continue;
                cand = null;
                break;
            }
            if (cand == null) continue;
            return cand;
        }
        if (!create) {
            return null;
        }
        if (namespace.isEmpty()) {
            prefix = "";
        } else {
            block2: do {
                prefix = "n" + this.auto++;
                for (int i = this.nspCounts[this.depth + 1] * 2 - 2; i >= 0; i -= 2) {
                    if (!prefix.equals(this.nspStack[i])) continue;
                    prefix = null;
                    continue block2;
                }
            } while (prefix == null);
        }
        boolean p = this.pending;
        this.pending = false;
        this.setPrefix(prefix, namespace);
        this.pending = p;
        return prefix;
    }

    private final Object $$robo$$org_kxml2_io_KXmlSerializer$getProperty(String name) {
        throw new RuntimeException("Unsupported property");
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$ignorableWhitespace(String s) throws IOException {
        this.text(s);
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$setFeature(String name, boolean value) {
        if (!"http://xmlpull.org/v1/doc/features.html#indent-output".equals(name)) {
            throw new RuntimeException("Unsupported Feature");
        }
        this.indent[this.depth] = value;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$setProperty(String name, Object value) {
        throw new RuntimeException("Unsupported Property:" + value);
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$setPrefix(String prefix, String namespace) throws IOException {
        String defined;
        this.check(false);
        if (prefix == null) {
            prefix = "";
        }
        if (namespace == null) {
            namespace = "";
        }
        if (prefix.equals(defined = this.getPrefix(namespace, true, false))) {
            return;
        }
        int n = this.depth + 1;
        int n2 = this.nspCounts[n];
        this.nspCounts[n] = n2 + 1;
        int pos = n2 << 1;
        if (this.nspStack.length < pos + 1) {
            String[] hlp = new String[this.nspStack.length + 16];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.nspStack, (int)0, (Object)hlp, (int)0, (int)pos);
            this.nspStack = hlp;
        }
        this.nspStack[pos++] = prefix;
        this.nspStack[pos] = namespace;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$setOutput(Writer writer) {
        this.writer = writer;
        this.nspCounts[0] = 2;
        this.nspCounts[1] = 2;
        this.nspStack[0] = "";
        this.nspStack[1] = "";
        this.nspStack[2] = "xml";
        this.nspStack[3] = "http://www.w3.org/XML/1998/namespace";
        this.pending = false;
        this.auto = 0;
        this.depth = 0;
        this.unicode = false;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$setOutput(OutputStream os, String encoding) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("os == null");
        }
        this.setOutput(encoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, encoding));
        this.encoding = encoding;
        if (encoding != null && encoding.toLowerCase(Locale.US).startsWith("utf")) {
            this.unicode = true;
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$startDocument(String encoding, Boolean standalone) throws IOException {
        this.append("<?xml version='1.0' ");
        if (encoding != null) {
            this.encoding = encoding;
            if (encoding.toLowerCase(Locale.US).startsWith("utf")) {
                this.unicode = true;
            }
        }
        if (this.encoding != null) {
            this.append("encoding='");
            this.append(this.encoding);
            this.append("' ");
        }
        if (standalone != null) {
            this.append("standalone='");
            this.append(standalone != false ? "yes" : "no");
            this.append("' ");
        }
        this.append("?>");
    }

    private final XmlSerializer $$robo$$org_kxml2_io_KXmlSerializer$startTag(String namespace, String name) throws IOException {
        String prefix;
        int esp;
        this.check(false);
        if (this.indent[this.depth]) {
            this.append("\r\n");
            for (int i = 0; i < this.depth; ++i) {
                this.append("  ");
            }
        }
        if (this.elementStack.length < (esp = this.depth * 3) + 3) {
            String[] hlp = new String[this.elementStack.length + 12];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.elementStack, (int)0, (Object)hlp, (int)0, (int)esp);
            this.elementStack = hlp;
        }
        String string2 = prefix = namespace == null ? "" : this.getPrefix(namespace, true, true);
        if (namespace != null && namespace.isEmpty()) {
            for (int i = this.nspCounts[this.depth]; i < this.nspCounts[this.depth + 1]; ++i) {
                if (!this.nspStack[i * 2].isEmpty() || this.nspStack[i * 2 + 1].isEmpty()) continue;
                throw new IllegalStateException("Cannot set default namespace for elements in no namespace");
            }
        }
        this.elementStack[esp++] = namespace;
        this.elementStack[esp++] = prefix;
        this.elementStack[esp] = name;
        this.append('<');
        if (!prefix.isEmpty()) {
            this.append(prefix);
            this.append(':');
        }
        this.append(name);
        this.pending = true;
        return this;
    }

    private final XmlSerializer $$robo$$org_kxml2_io_KXmlSerializer$attribute(String namespace, String name, String value) throws IOException {
        if (!this.pending) {
            throw new IllegalStateException("illegal position for attribute");
        }
        if (namespace == null) {
            namespace = "";
        }
        String prefix = namespace.isEmpty() ? "" : this.getPrefix(namespace, false, true);
        this.append(' ');
        if (!prefix.isEmpty()) {
            this.append(prefix);
            this.append(':');
        }
        this.append(name);
        this.append('=');
        char q = value.indexOf(34) == -1 ? (char)'\"' : '\'';
        this.append(q);
        this.writeEscaped(value, q);
        this.append(q);
        return this;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$flush() throws IOException {
        this.check(false);
        this.flushBuffer();
    }

    private final XmlSerializer $$robo$$org_kxml2_io_KXmlSerializer$endTag(String namespace, String name) throws IOException {
        if (!this.pending) {
            --this.depth;
        }
        if (namespace == null && this.elementStack[this.depth * 3] != null || namespace != null && !namespace.equals(this.elementStack[this.depth * 3]) || !this.elementStack[this.depth * 3 + 2].equals(name)) {
            throw new IllegalArgumentException("</{" + namespace + "}" + name + "> does not match start");
        }
        if (this.pending) {
            this.check(true);
            --this.depth;
        } else {
            if (this.indent[this.depth + 1]) {
                this.append("\r\n");
                for (int i = 0; i < this.depth; ++i) {
                    this.append("  ");
                }
            }
            this.append("</");
            String prefix = this.elementStack[this.depth * 3 + 1];
            if (!prefix.isEmpty()) {
                this.append(prefix);
                this.append(':');
            }
            this.append(name);
            this.append('>');
        }
        this.nspCounts[this.depth + 1] = this.nspCounts[this.depth];
        return this;
    }

    private final String $$robo$$org_kxml2_io_KXmlSerializer$getNamespace() {
        return this.getDepth() == 0 ? null : this.elementStack[this.getDepth() * 3 - 3];
    }

    private final String $$robo$$org_kxml2_io_KXmlSerializer$getName() {
        return this.getDepth() == 0 ? null : this.elementStack[this.getDepth() * 3 - 1];
    }

    private final int $$robo$$org_kxml2_io_KXmlSerializer$getDepth() {
        return this.pending ? this.depth + 1 : this.depth;
    }

    private final XmlSerializer $$robo$$org_kxml2_io_KXmlSerializer$text(String text) throws IOException {
        this.check(false);
        this.indent[this.depth] = false;
        this.writeEscaped(text, -1);
        return this;
    }

    private final XmlSerializer $$robo$$org_kxml2_io_KXmlSerializer$text(char[] text, int start, int len) throws IOException {
        this.text(new String(text, start, len));
        return this;
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$cdsect(String data) throws IOException {
        this.check(false);
        data = data.replace("]]>", "]]]]><![CDATA[>");
        this.append("<![CDATA[");
        for (int i = 0; i < data.length(); ++i) {
            boolean allowedInCdata;
            char ch = data.charAt(i);
            boolean bl = allowedInCdata = ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd';
            if (allowedInCdata) {
                this.append(ch);
                continue;
            }
            if (Character.isHighSurrogate(ch) && i < data.length() - 1) {
                this.append("]]>");
                this.writeSurrogate(ch, data.charAt(++i));
                this.append("<![CDATA[");
                continue;
            }
            KXmlSerializer.reportInvalidCharacter(ch);
        }
        this.append("]]>");
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$writeSurrogate(char high, char low) throws IOException {
        if (!Character.isLowSurrogate(low)) {
            throw new IllegalArgumentException("Bad surrogate pair (U+" + Integer.toHexString(high) + " U+" + Integer.toHexString(low) + ")");
        }
        int codePoint = Character.toCodePoint(high, low);
        this.append("&#" + codePoint + ";");
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$comment(String comment) throws IOException {
        this.check(false);
        this.append("<!--");
        this.append(comment);
        this.append("-->");
    }

    private final void $$robo$$org_kxml2_io_KXmlSerializer$processingInstruction(String pi) throws IOException {
        this.check(false);
        this.append("<?");
        this.append(pi);
        this.append("?>");
    }

    private void __constructor__() {
        this.$$robo$$org_kxml2_io_KXmlSerializer$__constructor__();
    }

    public KXmlSerializer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_kxml2_io_KXmlSerializer$__constructor__(), 0, this);
    }

    private void append(char c) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_kxml2_io_KXmlSerializer$append(char ), 0, this, c);
    }

    private void append(String string2, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_kxml2_io_KXmlSerializer$append(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void append(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$org_kxml2_io_KXmlSerializer$append(java.lang.String ), 0, this, string2);
    }

    private void flushBuffer() throws IOException {
        InvokeDynamicSupport.bootstrap("flushBuffer", $$robo$$org_kxml2_io_KXmlSerializer$flushBuffer(), 0, this);
    }

    private void check(boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("check", $$robo$$org_kxml2_io_KXmlSerializer$check(boolean ), 0, this, bl);
    }

    private void writeEscaped(String string2, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("writeEscaped", $$robo$$org_kxml2_io_KXmlSerializer$writeEscaped(java.lang.String int ), 0, this, string2, n);
    }

    private static void reportInvalidCharacter(char c) {
        InvokeDynamicSupport.bootstrapStatic("reportInvalidCharacter", $$robo$$org_kxml2_io_KXmlSerializer$reportInvalidCharacter(char ), 0, (char)c);
    }

    @Override
    public void docdecl(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("docdecl", $$robo$$org_kxml2_io_KXmlSerializer$docdecl(java.lang.String ), 0, this, string2);
    }

    @Override
    public void endDocument() throws IOException {
        InvokeDynamicSupport.bootstrap("endDocument", $$robo$$org_kxml2_io_KXmlSerializer$endDocument(), 0, this);
    }

    @Override
    public void entityRef(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("entityRef", $$robo$$org_kxml2_io_KXmlSerializer$entityRef(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean getFeature(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFeature", $$robo$$org_kxml2_io_KXmlSerializer$getFeature(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getPrefix(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPrefix", $$robo$$org_kxml2_io_KXmlSerializer$getPrefix(java.lang.String boolean ), 0, this, string2, bl);
    }

    private String getPrefix(String string2, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("getPrefix", $$robo$$org_kxml2_io_KXmlSerializer$getPrefix(java.lang.String boolean boolean ), 0, this, string2, bl, bl2);
    }

    @Override
    public Object getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$org_kxml2_io_KXmlSerializer$getProperty(java.lang.String ), 0, this, string2);
    }

    @Override
    public void ignorableWhitespace(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("ignorableWhitespace", $$robo$$org_kxml2_io_KXmlSerializer$ignorableWhitespace(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setFeature(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setFeature", $$robo$$org_kxml2_io_KXmlSerializer$setFeature(java.lang.String boolean ), 0, this, string2, bl);
    }

    @Override
    public void setProperty(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setProperty", $$robo$$org_kxml2_io_KXmlSerializer$setProperty(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    @Override
    public void setPrefix(String string2, String string3) throws IOException {
        InvokeDynamicSupport.bootstrap("setPrefix", $$robo$$org_kxml2_io_KXmlSerializer$setPrefix(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void setOutput(Writer writer) {
        InvokeDynamicSupport.bootstrap("setOutput", $$robo$$org_kxml2_io_KXmlSerializer$setOutput(java.io.Writer ), 0, this, writer);
    }

    @Override
    public void setOutput(OutputStream outputStream, String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("setOutput", $$robo$$org_kxml2_io_KXmlSerializer$setOutput(java.io.OutputStream java.lang.String ), 0, this, outputStream, string2);
    }

    @Override
    public void startDocument(String string2, Boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("startDocument", $$robo$$org_kxml2_io_KXmlSerializer$startDocument(java.lang.String java.lang.Boolean ), 0, this, string2, bl);
    }

    @Override
    public XmlSerializer startTag(String string2, String string3) throws IOException {
        return InvokeDynamicSupport.bootstrap("startTag", $$robo$$org_kxml2_io_KXmlSerializer$startTag(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public XmlSerializer attribute(String string2, String string3, String string4) throws IOException {
        return InvokeDynamicSupport.bootstrap("attribute", $$robo$$org_kxml2_io_KXmlSerializer$attribute(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_kxml2_io_KXmlSerializer$flush(), 0, this);
    }

    @Override
    public XmlSerializer endTag(String string2, String string3) throws IOException {
        return InvokeDynamicSupport.bootstrap("endTag", $$robo$$org_kxml2_io_KXmlSerializer$endTag(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public String getNamespace() {
        return InvokeDynamicSupport.bootstrap("getNamespace", $$robo$$org_kxml2_io_KXmlSerializer$getNamespace(), 0, this);
    }

    @Override
    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$org_kxml2_io_KXmlSerializer$getName(), 0, this);
    }

    @Override
    public int getDepth() {
        return (int)InvokeDynamicSupport.bootstrap("getDepth", $$robo$$org_kxml2_io_KXmlSerializer$getDepth(), 0, this);
    }

    @Override
    public XmlSerializer text(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("text", $$robo$$org_kxml2_io_KXmlSerializer$text(java.lang.String ), 0, this, string2);
    }

    @Override
    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrap("text", $$robo$$org_kxml2_io_KXmlSerializer$text(char[] int int ), 0, this, cArray, n, n2);
    }

    @Override
    public void cdsect(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("cdsect", $$robo$$org_kxml2_io_KXmlSerializer$cdsect(java.lang.String ), 0, this, string2);
    }

    private void writeSurrogate(char c, char c2) throws IOException {
        InvokeDynamicSupport.bootstrap("writeSurrogate", $$robo$$org_kxml2_io_KXmlSerializer$writeSurrogate(char char ), 0, this, c, c2);
    }

    @Override
    public void comment(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("comment", $$robo$$org_kxml2_io_KXmlSerializer$comment(java.lang.String ), 0, this, string2);
    }

    @Override
    public void processingInstruction(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("processingInstruction", $$robo$$org_kxml2_io_KXmlSerializer$processingInstruction(java.lang.String ), 0, this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KXmlSerializer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

