/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.system.ErrnoException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.BufferIterator;
import libcore.io.MemoryMappedFile;
import libcore.util.BasicLruCache;
import libcore.util.TimeZoneDataFiles;
import libcore.util.ZoneInfo;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ZoneInfoDB
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TZDATA_FILE = "tzdata";
    private static TzData DATA;

    private void $$robo$$libcore_util_ZoneInfoDB$__constructor__() {
    }

    private static final TzData $$robo$$libcore_util_ZoneInfoDB$getInstance() {
        return DATA;
    }

    static void __staticInitializer__() {
        DATA = TzData.loadTzDataWithFallback(TimeZoneDataFiles.getTimeZoneFilePaths("tzdata"));
    }

    private void __constructor__() {
        this.$$robo$$libcore_util_ZoneInfoDB$__constructor__();
    }

    private ZoneInfoDB() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB$__constructor__(), 0, this);
    }

    public static TzData getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$libcore_util_ZoneInfoDB$getInstance(), 0);
    }

    static {
        RobolectricInternals.classInitializing(ZoneInfoDB.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneInfoDB)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TzData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SIZEOF_TZNAME = 40;
        private static int SIZEOF_TZINT = 4;
        public static int SIZEOF_INDEX_ENTRY = 52;
        private boolean closed;
        private MemoryMappedFile mappedFile;
        private String version;
        private String zoneTab;
        private String[] ids;
        private int[] byteOffsets;
        private int[] rawUtcOffsetsCache;
        private static int CACHE_SIZE = 1;
        private BasicLruCache<String, ZoneInfo> cache;

        private static final TzData $$robo$$libcore_util_ZoneInfoDB_TzData$loadTzDataWithFallback(String ... paths) {
            String[] stringArray = paths;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                TzData tzData = new TzData();
                String path = stringArray[i];
                if (!tzData.loadData(path)) continue;
                return tzData;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)"Couldn't find any tzdata file!");
            return TzData.createFallback();
        }

        private static final TzData $$robo$$libcore_util_ZoneInfoDB_TzData$loadTzData(String path) {
            TzData tzData = new TzData();
            if (tzData.loadData(path)) {
                return tzData;
            }
            return null;
        }

        private static final TzData $$robo$$libcore_util_ZoneInfoDB_TzData$createFallback() {
            TzData tzData = new TzData();
            tzData.populateFallback();
            return tzData;
        }

        private void $$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__() {
            this.cache = new BasicLruCache<String, ZoneInfo>(this, 1){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TzData this$0;

                private void $$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(TzData this$0, int maxSize) {
                }

                private final ZoneInfo $$robo$$libcore_util_ZoneInfoDB_TzData_1$create(String id2) {
                    try {
                        return this.this$0.makeTimeZoneUncached(id2);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to load timezone for ID=" + id2, e);
                    }
                }

                private void __constructor__(TzData tzData, int n) {
                    this.$$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(tzData, n);
                }
                {
                    this.this$0 = tzData;
                    super(n);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(libcore.util.ZoneInfoDB$TzData int ), 0, this, tzData, n);
                }

                @Override
                protected ZoneInfo create(String string2) {
                    return InvokeDynamicSupport.bootstrap("create", $$robo$$libcore_util_ZoneInfoDB_TzData_1$create(java.lang.String ), 0, this, string2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final BufferIterator $$robo$$libcore_util_ZoneInfoDB_TzData$getBufferIterator(String id2) {
            this.checkNotClosed();
            int index = Arrays.binarySearch(this.ids, id2);
            if (index < 0) {
                return null;
            }
            int byteOffset = this.byteOffsets[index];
            BufferIterator it = this.mappedFile.bigEndianIterator();
            it.skip(byteOffset);
            return it;
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$populateFallback() {
            this.version = "missing";
            this.zoneTab = "# Emergency fallback data.\n";
            this.ids = new String[]{"GMT"};
            this.rawUtcOffsetsCache = new int[1];
            this.byteOffsets = this.rawUtcOffsetsCache;
        }

        private final boolean $$robo$$libcore_util_ZoneInfoDB_TzData$loadData(String path) {
            try {
                this.mappedFile = MemoryMappedFile.mmapRO(path);
            }
            catch (ErrnoException errnoException) {
                return false;
            }
            try {
                this.readHeader();
                return true;
            }
            catch (Exception ex) {
                this.close();
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("tzdata file \"" + path + "\" was present but invalid!"), (Throwable)ex);
                return false;
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readHeader() throws IOException {
            BufferIterator it = this.mappedFile.bigEndianIterator();
            try {
                byte[] tzdata_version = new byte[12];
                it.readByteArray(tzdata_version, 0, tzdata_version.length);
                String magic = new String(tzdata_version, 0, 6, StandardCharsets.US_ASCII);
                if (!magic.equals("tzdata") || tzdata_version[11] != 0) {
                    throw new IOException("bad tzdata magic: " + Arrays.toString(tzdata_version));
                }
                this.version = new String(tzdata_version, 6, 5, StandardCharsets.US_ASCII);
                int fileSize = this.mappedFile.size();
                int index_offset = it.readInt();
                TzData.validateOffset(index_offset, fileSize);
                int data_offset = it.readInt();
                TzData.validateOffset(data_offset, fileSize);
                int zonetab_offset = it.readInt();
                TzData.validateOffset(zonetab_offset, fileSize);
                if (index_offset >= data_offset || data_offset >= zonetab_offset) {
                    throw new IOException("Invalid offset: index_offset=" + index_offset + ", data_offset=" + data_offset + ", zonetab_offset=" + zonetab_offset + ", fileSize=" + fileSize);
                }
                this.readIndex(it, index_offset, data_offset);
                this.readZoneTab(it, zonetab_offset, fileSize - zonetab_offset);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException("Invalid read from data file", e);
            }
        }

        private static final void $$robo$$libcore_util_ZoneInfoDB_TzData$validateOffset(int offset, int size) throws IOException {
            if (offset < 0 || offset >= size) {
                throw new IOException("Invalid offset=" + offset + ", size=" + size);
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readZoneTab(BufferIterator it, int zoneTabOffset, int zoneTabSize) {
            byte[] bytes = new byte[zoneTabSize];
            it.seek(zoneTabOffset);
            it.readByteArray(bytes, 0, bytes.length);
            this.zoneTab = new String(bytes, 0, bytes.length, StandardCharsets.US_ASCII);
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readIndex(BufferIterator it, int indexOffset, int dataOffset) throws IOException {
            it.seek(indexOffset);
            byte[] idBytes = new byte[40];
            int indexSize = dataOffset - indexOffset;
            if (indexSize % 52 != 0) {
                throw new IOException("Index size is not divisible by 52, indexSize=" + indexSize);
            }
            int entryCount = indexSize / 52;
            this.byteOffsets = new int[entryCount];
            this.ids = new String[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                int len;
                it.readByteArray(idBytes, 0, idBytes.length);
                this.byteOffsets[i] = it.readInt();
                int n = i;
                this.byteOffsets[n] = this.byteOffsets[n] + dataOffset;
                int length = it.readInt();
                if (length < 44) {
                    throw new IOException("length in index file < sizeof(tzhead)");
                }
                it.skip(4);
                for (len = 0; idBytes[len] != 0 && len < idBytes.length; ++len) {
                }
                if (len == 0) {
                    throw new IOException("Invalid ID at index=" + i);
                }
                this.ids[i] = new String(idBytes, 0, len, StandardCharsets.US_ASCII);
                if (i <= 0 || this.ids[i].compareTo(this.ids[i - 1]) > 0) continue;
                throw new IOException("Index not sorted or contains multiple entries with the same ID, index=" + i + ", ids[i]=" + this.ids[i] + ", ids[i - 1]=" + this.ids[i - 1]);
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$validate() throws IOException {
            this.checkNotClosed();
            for (String id2 : this.getAvailableIDs()) {
                ZoneInfo zoneInfo = this.makeTimeZoneUncached(id2);
                if (zoneInfo != null) continue;
                throw new IOException("Unable to find data for ID=" + id2);
            }
        }

        private final ZoneInfo $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZoneUncached(String id2) throws IOException {
            BufferIterator it = this.getBufferIterator(id2);
            if (it == null) {
                return null;
            }
            return ZoneInfo.readTimeZone(id2, it, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        }

        private final String[] $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs() {
            this.checkNotClosed();
            return (String[])this.ids.clone();
        }

        private final String[] $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(int rawUtcOffset) {
            this.checkNotClosed();
            ArrayList<String> matches = new ArrayList<String>();
            int[] rawUtcOffsets = this.getRawUtcOffsets();
            for (int i = 0; i < rawUtcOffsets.length; ++i) {
                if (rawUtcOffsets[i] != rawUtcOffset) continue;
                matches.add(this.ids[i]);
            }
            return matches.toArray(new String[matches.size()]);
        }

        private final synchronized int[] $$robo$$libcore_util_ZoneInfoDB_TzData$getRawUtcOffsets() {
            if (this.rawUtcOffsetsCache != null) {
                return this.rawUtcOffsetsCache;
            }
            this.rawUtcOffsetsCache = new int[this.ids.length];
            for (int i = 0; i < this.ids.length; ++i) {
                this.rawUtcOffsetsCache[i] = this.cache.get(this.ids[i]).getRawOffset();
            }
            return this.rawUtcOffsetsCache;
        }

        private final String $$robo$$libcore_util_ZoneInfoDB_TzData$getVersion() {
            this.checkNotClosed();
            return this.version;
        }

        private final String $$robo$$libcore_util_ZoneInfoDB_TzData$getZoneTab() {
            this.checkNotClosed();
            return this.zoneTab;
        }

        private final ZoneInfo $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZone(String id2) throws IOException {
            this.checkNotClosed();
            ZoneInfo zoneInfo = this.cache.get(id2);
            return zoneInfo == null ? null : (ZoneInfo)zoneInfo.clone();
        }

        private final boolean $$robo$$libcore_util_ZoneInfoDB_TzData$hasTimeZone(String id2) throws IOException {
            this.checkNotClosed();
            return this.cache.get(id2) != null;
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$close() {
            if (!this.closed) {
                this.closed = true;
                this.ids = null;
                this.byteOffsets = null;
                this.rawUtcOffsetsCache = null;
                this.mappedFile = null;
                this.cache.evictAll();
                if (this.mappedFile != null) {
                    try {
                        this.mappedFile.close();
                    }
                    catch (ErrnoException errnoException) {
                        // empty catch block
                    }
                }
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$checkNotClosed() throws IllegalStateException {
            if (this.closed) {
                throw new IllegalStateException("TzData is closed");
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private static final String $$robo$$libcore_util_ZoneInfoDB_TzData$getRulesVersion(File tzDataFile) throws IOException {
            try (FileInputStream is = new FileInputStream(tzDataFile);){
                int bytesToRead = 12;
                byte[] tzdataVersion = new byte[12];
                int bytesRead = is.read(tzdataVersion, 0, 12);
                if (bytesRead != 12) {
                    throw new IOException("File too short: only able to read " + bytesRead + " bytes.");
                }
                String magic = new String(tzdataVersion, 0, 6, StandardCharsets.US_ASCII);
                if (!magic.equals("tzdata") || tzdataVersion[11] != 0) {
                    throw new IOException("bad tzdata magic: " + Arrays.toString(tzdataVersion));
                }
                String string2 = new String(tzdataVersion, 6, 5, StandardCharsets.US_ASCII);
                return string2;
            }
        }

        public static TzData loadTzDataWithFallback(String ... stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("loadTzDataWithFallback", $$robo$$libcore_util_ZoneInfoDB_TzData$loadTzDataWithFallback(java.lang.String[] ), 0, (String[])stringArray);
        }

        public static TzData loadTzData(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("loadTzData", $$robo$$libcore_util_ZoneInfoDB_TzData$loadTzData(java.lang.String ), 0, (String)string2);
        }

        private static TzData createFallback() {
            return InvokeDynamicSupport.bootstrapStatic("createFallback", $$robo$$libcore_util_ZoneInfoDB_TzData$createFallback(), 0);
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__();
        }

        private TzData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__(), 0, this);
        }

        public BufferIterator getBufferIterator(String string2) {
            return InvokeDynamicSupport.bootstrap("getBufferIterator", $$robo$$libcore_util_ZoneInfoDB_TzData$getBufferIterator(java.lang.String ), 0, this, string2);
        }

        private void populateFallback() {
            InvokeDynamicSupport.bootstrap("populateFallback", $$robo$$libcore_util_ZoneInfoDB_TzData$populateFallback(), 0, this);
        }

        private boolean loadData(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("loadData", $$robo$$libcore_util_ZoneInfoDB_TzData$loadData(java.lang.String ), 0, this, string2);
        }

        private void readHeader() throws IOException {
            InvokeDynamicSupport.bootstrap("readHeader", $$robo$$libcore_util_ZoneInfoDB_TzData$readHeader(), 0, this);
        }

        private static void validateOffset(int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrapStatic("validateOffset", $$robo$$libcore_util_ZoneInfoDB_TzData$validateOffset(int int ), 0, (int)n, (int)n2);
        }

        private void readZoneTab(BufferIterator bufferIterator, int n, int n2) {
            InvokeDynamicSupport.bootstrap("readZoneTab", $$robo$$libcore_util_ZoneInfoDB_TzData$readZoneTab(libcore.io.BufferIterator int int ), 0, this, bufferIterator, n, n2);
        }

        private void readIndex(BufferIterator bufferIterator, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("readIndex", $$robo$$libcore_util_ZoneInfoDB_TzData$readIndex(libcore.io.BufferIterator int int ), 0, this, bufferIterator, n, n2);
        }

        public void validate() throws IOException {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$libcore_util_ZoneInfoDB_TzData$validate(), 0, this);
        }

        ZoneInfo makeTimeZoneUncached(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("makeTimeZoneUncached", $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZoneUncached(java.lang.String ), 0, this, string2);
        }

        public String[] getAvailableIDs() {
            return InvokeDynamicSupport.bootstrap("getAvailableIDs", $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(), 0, this);
        }

        public String[] getAvailableIDs(int n) {
            return InvokeDynamicSupport.bootstrap("getAvailableIDs", $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(int ), 0, this, n);
        }

        private synchronized int[] getRawUtcOffsets() {
            return InvokeDynamicSupport.bootstrap("getRawUtcOffsets", $$robo$$libcore_util_ZoneInfoDB_TzData$getRawUtcOffsets(), 0, this);
        }

        public String getVersion() {
            return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$libcore_util_ZoneInfoDB_TzData$getVersion(), 0, this);
        }

        public String getZoneTab() {
            return InvokeDynamicSupport.bootstrap("getZoneTab", $$robo$$libcore_util_ZoneInfoDB_TzData$getZoneTab(), 0, this);
        }

        public ZoneInfo makeTimeZone(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("makeTimeZone", $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZone(java.lang.String ), 0, this, string2);
        }

        public boolean hasTimeZone(String string2) throws IOException {
            return (boolean)InvokeDynamicSupport.bootstrap("hasTimeZone", $$robo$$libcore_util_ZoneInfoDB_TzData$hasTimeZone(java.lang.String ), 0, this, string2);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_util_ZoneInfoDB_TzData$close(), 0, this);
        }

        private void checkNotClosed() throws IllegalStateException {
            InvokeDynamicSupport.bootstrap("checkNotClosed", $$robo$$libcore_util_ZoneInfoDB_TzData$checkNotClosed(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$libcore_util_ZoneInfoDB_TzData$finalize(), 0, this);
        }

        public static String getRulesVersion(File file) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("getRulesVersion", $$robo$$libcore_util_ZoneInfoDB_TzData$getRulesVersion(java.io.File ), 0, (File)file);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TzData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

