/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import libcore.io.BufferIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ZoneInfo
extends TimeZone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long MILLISECONDS_PER_DAY = 86400000L;
    private static long MILLISECONDS_PER_400_YEARS = 12622780800000L;
    private static long UNIX_OFFSET = 62167219200000L;
    private static int[] NORMAL;
    private static int[] LEAP;
    static long serialVersionUID = -4598738130123921552L;
    private int mRawOffset;
    private int mEarliestRawOffset;
    private boolean mUseDst;
    private int mDstSavings;
    private long[] mTransitions;
    private byte[] mTypes;
    private int[] mOffsets;
    private byte[] mIsDsts;

    private static final ZoneInfo $$robo$$libcore_util_ZoneInfo$readTimeZone(String id2, BufferIterator it, long currentTimeMillis) throws IOException {
        int tzh_magic = it.readInt();
        if (tzh_magic != 1415211366) {
            throw new IOException("Timezone id=" + id2 + " has an invalid header=" + tzh_magic);
        }
        it.skip(28);
        int tzh_timecnt = it.readInt();
        int MAX_TRANSITIONS = 2000;
        if (tzh_timecnt < 0 || tzh_timecnt > 2000) {
            throw new IOException("Timezone id=" + id2 + " has an invalid number of transitions=" + tzh_timecnt);
        }
        int tzh_typecnt = it.readInt();
        int MAX_TYPES = 256;
        if (tzh_typecnt < 1) {
            throw new IOException("ZoneInfo requires at least one type to be provided for each timezone but could not find one for '" + id2 + "'");
        }
        if (tzh_typecnt > 256) {
            throw new IOException("Timezone with id " + id2 + " has too many types=" + tzh_typecnt);
        }
        it.skip(4);
        int[] transitions32 = new int[tzh_timecnt];
        it.readIntArray(transitions32, 0, transitions32.length);
        long[] transitions64 = new long[tzh_timecnt];
        for (int i = 0; i < tzh_timecnt; ++i) {
            transitions64[i] = transitions32[i];
            if (i <= 0 || transitions64[i] > transitions64[i - 1]) continue;
            throw new IOException(id2 + " transition at " + i + " is not sorted correctly, is " + transitions64[i] + ", previous is " + transitions64[i - 1]);
        }
        byte[] type = new byte[tzh_timecnt];
        it.readByteArray(type, 0, type.length);
        for (int i = 0; i < type.length; ++i) {
            int typeIndex = type[i] & 0xFF;
            if (typeIndex < tzh_typecnt) continue;
            throw new IOException(id2 + " type at " + i + " is not < " + tzh_typecnt + ", is " + typeIndex);
        }
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = it.readInt();
            byte isDst = it.readByte();
            if (isDst != 0 && isDst != 1) {
                throw new IOException(id2 + " dst at " + i + " is not 0 or 1, is " + isDst);
            }
            isDsts[i] = isDst;
            it.skip(1);
        }
        return new ZoneInfo(id2, transitions64, type, gmtOffsets, isDsts, currentTimeMillis);
    }

    private void $$robo$$libcore_util_ZoneInfo$__constructor__(String name, long[] transitions, byte[] types, int[] gmtOffsets, byte[] isDsts, long currentTimeMillis) {
        long currentUnixTimeSeconds;
        long lastDSTTransitionTime;
        if (gmtOffsets.length == 0) {
            throw new IllegalArgumentException("ZoneInfo requires at least one offset to be provided for each timezone but could not find one for '" + name + "'");
        }
        this.mTransitions = transitions;
        this.mTypes = types;
        this.mIsDsts = isDsts;
        this.setID(name);
        int lastStd = -1;
        int lastDst = -1;
        for (int i = this.mTransitions.length - 1; (lastStd == -1 || lastDst == -1) && i >= 0; --i) {
            int type = this.mTypes[i] & 0xFF;
            if (lastStd == -1 && this.mIsDsts[type] == 0) {
                lastStd = i;
            }
            if (lastDst != -1 || this.mIsDsts[type] == 0) continue;
            lastDst = i;
        }
        if (this.mTransitions.length == 0) {
            this.mRawOffset = gmtOffsets[0];
        } else {
            if (lastStd == -1) {
                throw new IllegalStateException("ZoneInfo requires at least one non-DST transition to be provided for each timezone that has at least one transition but could not find one for '" + name + "'");
            }
            this.mRawOffset = gmtOffsets[this.mTypes[lastStd] & 0xFF];
        }
        if (lastDst != -1 && (lastDSTTransitionTime = this.mTransitions[lastDst]) < (currentUnixTimeSeconds = ZoneInfo.roundUpMillisToSeconds(currentTimeMillis))) {
            lastDst = -1;
        }
        if (lastDst == -1) {
            this.mDstSavings = 0;
            this.mUseDst = false;
        } else {
            int lastGmtOffset = gmtOffsets[this.mTypes[lastStd] & 0xFF];
            int lastDstOffset = gmtOffsets[this.mTypes[lastDst] & 0xFF];
            this.mDstSavings = Math.abs(lastGmtOffset - lastDstOffset) * 1000;
            this.mUseDst = true;
        }
        int firstStd = -1;
        for (int i = 0; i < this.mTransitions.length; ++i) {
            if (this.mIsDsts[this.mTypes[i] & 0xFF] != 0) continue;
            firstStd = i;
            break;
        }
        int earliestRawOffset = firstStd != -1 ? gmtOffsets[this.mTypes[firstStd] & 0xFF] : this.mRawOffset;
        this.mOffsets = gmtOffsets;
        int i = 0;
        while (i < this.mOffsets.length) {
            int n = i++;
            this.mOffsets[n] = this.mOffsets[n] - this.mRawOffset;
        }
        this.mRawOffset *= 1000;
        this.mEarliestRawOffset = earliestRawOffset * 1000;
    }

    private final void $$robo$$libcore_util_ZoneInfo$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.mUseDst && this.mDstSavings != 0) {
            this.mDstSavings = 0;
        }
    }

    private final int $$robo$$libcore_util_ZoneInfo$getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        long calc = (long)(year / 400) * 12622780800000L;
        calc += (long)(year %= 400) * 31536000000L;
        calc += (long)((year + 3) / 4) * 86400000L;
        if (year > 0) {
            calc -= (long)((year - 1) / 100) * 86400000L;
        }
        boolean isLeap = year == 0 || year % 4 == 0 && year % 100 != 0;
        int[] mlen = isLeap ? LEAP : NORMAL;
        calc += (long)mlen[month] * 86400000L;
        calc += (long)(day - 1) * 86400000L;
        calc += (long)millis;
        calc -= (long)this.mRawOffset;
        return this.getOffset(calc -= 62167219200000L);
    }

    private final int $$robo$$libcore_util_ZoneInfo$findTransitionIndex(long seconds) {
        int transition2 = Arrays.binarySearch(this.mTransitions, seconds);
        if (transition2 < 0 && (transition2 = ~transition2 - 1) < 0) {
            return -1;
        }
        return transition2;
    }

    private final int $$robo$$libcore_util_ZoneInfo$findOffsetIndexForTimeInSeconds(long seconds) {
        int transition2 = this.findTransitionIndex(seconds);
        if (transition2 < 0) {
            return -1;
        }
        return this.mTypes[transition2] & 0xFF;
    }

    private final int $$robo$$libcore_util_ZoneInfo$findOffsetIndexForTimeInMilliseconds(long millis) {
        return this.findOffsetIndexForTimeInSeconds(ZoneInfo.roundDownMillisToSeconds(millis));
    }

    private static final long $$robo$$libcore_util_ZoneInfo$roundDownMillisToSeconds(long millis) {
        if (millis < 0L) {
            return (millis - 999L) / 1000L;
        }
        return millis / 1000L;
    }

    private static final long $$robo$$libcore_util_ZoneInfo$roundUpMillisToSeconds(long millis) {
        if (millis > 0L) {
            return (millis + 999L) / 1000L;
        }
        return millis / 1000L;
    }

    private final int $$robo$$libcore_util_ZoneInfo$getOffsetsByUtcTime(long utcTimeInMillis, int[] offsets) {
        int totalOffset;
        int dstOffset;
        int rawOffset;
        int transitionIndex = this.findTransitionIndex(ZoneInfo.roundDownMillisToSeconds(utcTimeInMillis));
        if (transitionIndex == -1) {
            rawOffset = this.mEarliestRawOffset;
            dstOffset = 0;
            totalOffset = rawOffset;
        } else {
            int type = this.mTypes[transitionIndex] & 0xFF;
            totalOffset = this.mRawOffset + this.mOffsets[type] * 1000;
            if (this.mIsDsts[type] == 0) {
                rawOffset = totalOffset;
                dstOffset = 0;
            } else {
                rawOffset = -1;
                --transitionIndex;
                while (transitionIndex >= 0) {
                    type = this.mTypes[transitionIndex] & 0xFF;
                    if (this.mIsDsts[type] == 0) {
                        rawOffset = this.mRawOffset + this.mOffsets[type] * 1000;
                        break;
                    }
                    --transitionIndex;
                }
                if (rawOffset == -1) {
                    rawOffset = this.mEarliestRawOffset;
                }
                dstOffset = totalOffset - rawOffset;
            }
        }
        offsets[0] = rawOffset;
        offsets[1] = dstOffset;
        return totalOffset;
    }

    private final int $$robo$$libcore_util_ZoneInfo$getOffset(long when) {
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(when);
        if (offsetIndex == -1) {
            return this.mEarliestRawOffset;
        }
        return this.mRawOffset + this.mOffsets[offsetIndex] * 1000;
    }

    private final boolean $$robo$$libcore_util_ZoneInfo$inDaylightTime(Date time) {
        long when = time.getTime();
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(when);
        if (offsetIndex == -1) {
            return false;
        }
        return this.mIsDsts[offsetIndex] == 1;
    }

    private final int $$robo$$libcore_util_ZoneInfo$getRawOffset() {
        return this.mRawOffset;
    }

    private final void $$robo$$libcore_util_ZoneInfo$setRawOffset(int off) {
        this.mRawOffset = off;
    }

    private final int $$robo$$libcore_util_ZoneInfo$getDSTSavings() {
        return this.mDstSavings;
    }

    private final boolean $$robo$$libcore_util_ZoneInfo$useDaylightTime() {
        return this.mUseDst;
    }

    private final boolean $$robo$$libcore_util_ZoneInfo$hasSameRules(TimeZone timeZone) {
        if (!(timeZone instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)timeZone;
        if (this.mUseDst != other.mUseDst) {
            return false;
        }
        if (!this.mUseDst) {
            return this.mRawOffset == other.mRawOffset;
        }
        return this.mRawOffset == other.mRawOffset && Arrays.equals(this.mOffsets, other.mOffsets) && Arrays.equals(this.mIsDsts, other.mIsDsts) && Arrays.equals(this.mTypes, other.mTypes) && Arrays.equals(this.mTransitions, other.mTransitions);
    }

    private final boolean $$robo$$libcore_util_ZoneInfo$equals(Object obj) {
        if (!(obj instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)obj;
        return this.getID().equals(other.getID()) && this.hasSameRules(other);
    }

    private final int $$robo$$libcore_util_ZoneInfo$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + Arrays.hashCode(this.mOffsets);
        result = 31 * result + Arrays.hashCode(this.mIsDsts);
        result = 31 * result + this.mRawOffset;
        result = 31 * result + Arrays.hashCode(this.mTransitions);
        result = 31 * result + Arrays.hashCode(this.mTypes);
        result = 31 * result + (this.mUseDst ? 1231 : 1237);
        return result;
    }

    private final String $$robo$$libcore_util_ZoneInfo$toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\",mRawOffset=" + this.mRawOffset + ",mEarliestRawOffset=" + this.mEarliestRawOffset + ",mUseDst=" + this.mUseDst + ",mDstSavings=" + this.mDstSavings + ",transitions=" + this.mTransitions.length + "]";
    }

    private final Object $$robo$$libcore_util_ZoneInfo$clone() {
        return super.clone();
    }

    private static final int $$robo$$libcore_util_ZoneInfo$checkedAdd(long a, int b) throws CheckedArithmeticException {
        long result = a + (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    private static final int $$robo$$libcore_util_ZoneInfo$checkedSubtract(int a, int b) throws CheckedArithmeticException {
        long result = (long)a - (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    static void __staticInitializer__() {
        NORMAL = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    }

    public static ZoneInfo readTimeZone(String string2, BufferIterator bufferIterator, long l) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readTimeZone", $$robo$$libcore_util_ZoneInfo$readTimeZone(java.lang.String libcore.io.BufferIterator long ), 0, (String)string2, (BufferIterator)bufferIterator, (long)l);
    }

    private void __constructor__(String string2, long[] lArray, byte[] byArray, int[] nArray, byte[] byArray2, long l) {
        this.$$robo$$libcore_util_ZoneInfo$__constructor__(string2, lArray, byArray, nArray, byArray2, l);
    }

    private ZoneInfo(String string2, long[] lArray, byte[] byArray, int[] nArray, byte[] byArray2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfo$__constructor__(java.lang.String long[] byte[] int[] byte[] long ), 0, this, string2, lArray, byArray, nArray, byArray2, l);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$libcore_util_ZoneInfo$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    @Override
    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$libcore_util_ZoneInfo$getOffset(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    public int findTransitionIndex(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findTransitionIndex", $$robo$$libcore_util_ZoneInfo$findTransitionIndex(long ), 0, this, l);
    }

    int findOffsetIndexForTimeInSeconds(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findOffsetIndexForTimeInSeconds", $$robo$$libcore_util_ZoneInfo$findOffsetIndexForTimeInSeconds(long ), 0, this, l);
    }

    int findOffsetIndexForTimeInMilliseconds(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findOffsetIndexForTimeInMilliseconds", $$robo$$libcore_util_ZoneInfo$findOffsetIndexForTimeInMilliseconds(long ), 0, this, l);
    }

    static long roundDownMillisToSeconds(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("roundDownMillisToSeconds", $$robo$$libcore_util_ZoneInfo$roundDownMillisToSeconds(long ), 0, (long)l);
    }

    static long roundUpMillisToSeconds(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("roundUpMillisToSeconds", $$robo$$libcore_util_ZoneInfo$roundUpMillisToSeconds(long ), 0, (long)l);
    }

    public int getOffsetsByUtcTime(long l, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetsByUtcTime", $$robo$$libcore_util_ZoneInfo$getOffsetsByUtcTime(long int[] ), 0, this, l, nArray);
    }

    @Override
    public int getOffset(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$libcore_util_ZoneInfo$getOffset(long ), 0, this, l);
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("inDaylightTime", $$robo$$libcore_util_ZoneInfo$inDaylightTime(java.util.Date ), 0, this, date);
    }

    @Override
    public int getRawOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getRawOffset", $$robo$$libcore_util_ZoneInfo$getRawOffset(), 0, this);
    }

    @Override
    public void setRawOffset(int n) {
        InvokeDynamicSupport.bootstrap("setRawOffset", $$robo$$libcore_util_ZoneInfo$setRawOffset(int ), 0, this, n);
    }

    @Override
    public int getDSTSavings() {
        return (int)InvokeDynamicSupport.bootstrap("getDSTSavings", $$robo$$libcore_util_ZoneInfo$getDSTSavings(), 0, this);
    }

    @Override
    public boolean useDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("useDaylightTime", $$robo$$libcore_util_ZoneInfo$useDaylightTime(), 0, this);
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameRules", $$robo$$libcore_util_ZoneInfo$hasSameRules(java.util.TimeZone ), 0, this, timeZone);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_util_ZoneInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_util_ZoneInfo$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_util_ZoneInfo$toString(), 0, this);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$libcore_util_ZoneInfo$clone(), 0, this);
    }

    private static int checkedAdd(long l, int n) throws CheckedArithmeticException {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkedAdd", $$robo$$libcore_util_ZoneInfo$checkedAdd(long int ), 0, (long)l, (int)n);
    }

    private static int checkedSubtract(int n, int n2) throws CheckedArithmeticException {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkedSubtract", $$robo$$libcore_util_ZoneInfo$checkedSubtract(int int ), 0, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(ZoneInfo.class);
    }

    public /* synthetic */ ZoneInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CheckedArithmeticException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$libcore_util_ZoneInfo_CheckedArithmeticException$__constructor__() {
        }

        private /* synthetic */ void $$robo$$libcore_util_ZoneInfo_CheckedArithmeticException$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_ZoneInfo_CheckedArithmeticException$__constructor__();
        }

        private CheckedArithmeticException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfo_CheckedArithmeticException$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_util_ZoneInfo_CheckedArithmeticException$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckedArithmeticException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OffsetInterval
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int startWallTimeSeconds;
        private int endWallTimeSeconds;
        private int isDst;
        private int totalOffsetSeconds;

        private static final OffsetInterval $$robo$$libcore_util_ZoneInfo_OffsetInterval$create(ZoneInfo timeZone, int transitionIndex) throws CheckedArithmeticException {
            if (transitionIndex < -1 || transitionIndex >= timeZone.mTransitions.length) {
                return null;
            }
            int rawOffsetSeconds = timeZone.mRawOffset / 1000;
            if (transitionIndex == -1) {
                int endWallTimeSeconds = ZoneInfo.checkedAdd(timeZone.mTransitions[0], rawOffsetSeconds);
                return new OffsetInterval(Integer.MIN_VALUE, endWallTimeSeconds, 0, rawOffsetSeconds);
            }
            int type = timeZone.mTypes[transitionIndex] & 0xFF;
            int totalOffsetSeconds = timeZone.mOffsets[type] + rawOffsetSeconds;
            int endWallTimeSeconds = transitionIndex == timeZone.mTransitions.length - 1 ? Integer.MAX_VALUE : ZoneInfo.checkedAdd(timeZone.mTransitions[transitionIndex + 1], totalOffsetSeconds);
            byte isDst = timeZone.mIsDsts[type];
            int startWallTimeSeconds = ZoneInfo.checkedAdd(timeZone.mTransitions[transitionIndex], totalOffsetSeconds);
            return new OffsetInterval(startWallTimeSeconds, endWallTimeSeconds, isDst, totalOffsetSeconds);
        }

        private void $$robo$$libcore_util_ZoneInfo_OffsetInterval$__constructor__(int startWallTimeSeconds, int endWallTimeSeconds, int isDst, int totalOffsetSeconds) {
            this.startWallTimeSeconds = startWallTimeSeconds;
            this.endWallTimeSeconds = endWallTimeSeconds;
            this.isDst = isDst;
            this.totalOffsetSeconds = totalOffsetSeconds;
        }

        private final boolean $$robo$$libcore_util_ZoneInfo_OffsetInterval$containsWallTime(long wallTimeSeconds) {
            return wallTimeSeconds >= (long)this.startWallTimeSeconds && wallTimeSeconds < (long)this.endWallTimeSeconds;
        }

        private final int $$robo$$libcore_util_ZoneInfo_OffsetInterval$getIsDst() {
            return this.isDst;
        }

        private final int $$robo$$libcore_util_ZoneInfo_OffsetInterval$getTotalOffsetSeconds() {
            return this.totalOffsetSeconds;
        }

        private final long $$robo$$libcore_util_ZoneInfo_OffsetInterval$getEndWallTimeSeconds() {
            return this.endWallTimeSeconds;
        }

        private final long $$robo$$libcore_util_ZoneInfo_OffsetInterval$getStartWallTimeSeconds() {
            return this.startWallTimeSeconds;
        }

        public static OffsetInterval create(ZoneInfo zoneInfo, int n) throws CheckedArithmeticException {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$libcore_util_ZoneInfo_OffsetInterval$create(libcore.util.ZoneInfo int ), 0, (ZoneInfo)zoneInfo, (int)n);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$libcore_util_ZoneInfo_OffsetInterval$__constructor__(n, n2, n3, n4);
        }

        private OffsetInterval(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfo_OffsetInterval$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        public boolean containsWallTime(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsWallTime", $$robo$$libcore_util_ZoneInfo_OffsetInterval$containsWallTime(long ), 0, this, l);
        }

        public int getIsDst() {
            return (int)InvokeDynamicSupport.bootstrap("getIsDst", $$robo$$libcore_util_ZoneInfo_OffsetInterval$getIsDst(), 0, this);
        }

        public int getTotalOffsetSeconds() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalOffsetSeconds", $$robo$$libcore_util_ZoneInfo_OffsetInterval$getTotalOffsetSeconds(), 0, this);
        }

        public long getEndWallTimeSeconds() {
            return (long)InvokeDynamicSupport.bootstrap("getEndWallTimeSeconds", $$robo$$libcore_util_ZoneInfo_OffsetInterval$getEndWallTimeSeconds(), 0, this);
        }

        public long getStartWallTimeSeconds() {
            return (long)InvokeDynamicSupport.bootstrap("getStartWallTimeSeconds", $$robo$$libcore_util_ZoneInfo_OffsetInterval$getStartWallTimeSeconds(), 0, this);
        }

        public /* synthetic */ OffsetInterval() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetInterval)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WallTime
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private GregorianCalendar calendar;
        private int year;
        private int month;
        private int monthDay;
        private int hour;
        private int minute;
        private int second;
        private int weekDay;
        private int yearDay;
        private int isDst;
        private int gmtOffsetSeconds;

        private void $$robo$$libcore_util_ZoneInfo_WallTime$__constructor__() {
            this.calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$localtime(int timeSeconds, ZoneInfo zoneInfo) {
            try {
                int isDst;
                int offsetSeconds = zoneInfo.mRawOffset / 1000;
                if (zoneInfo.mTransitions.length == 0) {
                    isDst = 0;
                } else {
                    int offsetIndex = zoneInfo.findOffsetIndexForTimeInSeconds(timeSeconds);
                    if (offsetIndex == -1) {
                        isDst = 0;
                    } else {
                        offsetSeconds += zoneInfo.mOffsets[offsetIndex];
                        isDst = zoneInfo.mIsDsts[offsetIndex];
                    }
                }
                int wallTimeSeconds = ZoneInfo.checkedAdd(timeSeconds, offsetSeconds);
                this.calendar.setTimeInMillis((long)wallTimeSeconds * 1000L);
                this.copyFieldsFromCalendar();
                this.isDst = isDst;
                this.gmtOffsetSeconds = offsetSeconds;
            }
            catch (CheckedArithmeticException checkedArithmeticException) {
                // empty catch block
            }
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$mktime(ZoneInfo zoneInfo) {
            this.isDst = this.isDst > 0 ? (this.isDst = 1) : (this.isDst < 0 ? (this.isDst = -1) : 0);
            this.copyFieldsToCalendar();
            long longWallTimeSeconds = this.calendar.getTimeInMillis() / 1000L;
            if (Integer.MIN_VALUE > longWallTimeSeconds || longWallTimeSeconds > Integer.MAX_VALUE) {
                return -1;
            }
            try {
                int wallTimeSeconds = (int)longWallTimeSeconds;
                int rawOffsetSeconds = zoneInfo.mRawOffset / 1000;
                int rawTimeSeconds = ZoneInfo.checkedSubtract(wallTimeSeconds, rawOffsetSeconds);
                if (zoneInfo.mTransitions.length == 0) {
                    if (this.isDst > 0) {
                        return -1;
                    }
                    this.copyFieldsFromCalendar();
                    this.isDst = 0;
                    this.gmtOffsetSeconds = rawOffsetSeconds;
                    return rawTimeSeconds;
                }
                int initialTransitionIndex = zoneInfo.findTransitionIndex(rawTimeSeconds);
                if (this.isDst < 0) {
                    Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
                    return result == null ? -1 : result;
                }
                Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
                if (result == null) {
                    result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, false);
                }
                if (result == null) {
                    result = -1;
                }
                return result;
            }
            catch (CheckedArithmeticException e) {
                return -1;
            }
        }

        private final Integer $$robo$$libcore_util_ZoneInfo_WallTime$tryOffsetAdjustments(ZoneInfo zoneInfo, int oldWallTimeSeconds, OffsetInterval targetInterval, int transitionIndex, int isDstToFind) throws CheckedArithmeticException {
            int[] offsetsToTry = WallTime.getOffsetsOfType(zoneInfo, transitionIndex, isDstToFind);
            for (int j = 0; j < offsetsToTry.length; ++j) {
                int rawOffsetSeconds = zoneInfo.mRawOffset / 1000;
                int jOffsetSeconds = rawOffsetSeconds + offsetsToTry[j];
                int targetIntervalOffsetSeconds = targetInterval.getTotalOffsetSeconds();
                int adjustmentSeconds = targetIntervalOffsetSeconds - jOffsetSeconds;
                int adjustedWallTimeSeconds = ZoneInfo.checkedAdd(oldWallTimeSeconds, adjustmentSeconds);
                if (!targetInterval.containsWallTime(adjustedWallTimeSeconds)) continue;
                int returnValue = ZoneInfo.checkedSubtract(adjustedWallTimeSeconds, targetIntervalOffsetSeconds);
                this.calendar.setTimeInMillis((long)adjustedWallTimeSeconds * 1000L);
                this.copyFieldsFromCalendar();
                this.isDst = targetInterval.getIsDst();
                this.gmtOffsetSeconds = targetIntervalOffsetSeconds;
                return returnValue;
            }
            return null;
        }

        private static final int[] $$robo$$libcore_util_ZoneInfo_WallTime$getOffsetsOfType(ZoneInfo zoneInfo, int startIndex, int isDst) {
            int[] offsets = new int[zoneInfo.mOffsets.length + 1];
            boolean[] seen = new boolean[zoneInfo.mOffsets.length];
            int numFound = 0;
            int delta = 0;
            boolean clampTop = false;
            boolean clampBottom = false;
            do {
                if ((delta *= -1) >= 0) {
                    ++delta;
                }
                int transitionIndex = startIndex + delta;
                if (delta < 0 && transitionIndex < -1) {
                    clampBottom = true;
                    continue;
                }
                if (delta > 0 && transitionIndex >= zoneInfo.mTypes.length) {
                    clampTop = true;
                    continue;
                }
                if (transitionIndex == -1) {
                    if (isDst != 0) continue;
                    offsets[numFound++] = 0;
                    continue;
                }
                int type = zoneInfo.mTypes[transitionIndex] & 0xFF;
                if (seen[type]) continue;
                if (zoneInfo.mIsDsts[type] == isDst) {
                    offsets[numFound++] = zoneInfo.mOffsets[type];
                }
                seen[type] = true;
            } while (!clampTop || !clampBottom);
            int[] toReturn = new int[numFound];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])offsets, (int)0, (int[])toReturn, (int)0, (int)numFound);
            return toReturn;
        }

        private final Integer $$robo$$libcore_util_ZoneInfo_WallTime$doWallTimeSearch(ZoneInfo zoneInfo, int initialTransitionIndex, int wallTimeSeconds, boolean mustMatchDst) throws CheckedArithmeticException {
            int MAX_SEARCH_SECONDS = 86400;
            boolean clampTop = false;
            boolean clampBottom = false;
            int loop = 0;
            do {
                boolean endSearch;
                int isDstToFind;
                Integer returnValue;
                int transitionIndexDelta = (loop + 1) / 2;
                if (loop % 2 == 1) {
                    transitionIndexDelta *= -1;
                }
                ++loop;
                if (transitionIndexDelta > 0 && clampTop || transitionIndexDelta < 0 && clampBottom) continue;
                int currentTransitionIndex = initialTransitionIndex + transitionIndexDelta;
                OffsetInterval offsetInterval = OffsetInterval.create(zoneInfo, currentTransitionIndex);
                if (offsetInterval == null) {
                    clampTop |= transitionIndexDelta > 0;
                    clampBottom |= transitionIndexDelta < 0;
                    continue;
                }
                if (mustMatchDst) {
                    if (offsetInterval.containsWallTime(wallTimeSeconds) && (this.isDst == -1 || offsetInterval.getIsDst() == this.isDst)) {
                        int totalOffsetSeconds = offsetInterval.getTotalOffsetSeconds();
                        int returnValue2 = ZoneInfo.checkedSubtract(wallTimeSeconds, totalOffsetSeconds);
                        this.copyFieldsFromCalendar();
                        this.isDst = offsetInterval.getIsDst();
                        this.gmtOffsetSeconds = totalOffsetSeconds;
                        return returnValue2;
                    }
                } else if (this.isDst != offsetInterval.getIsDst() && (returnValue = this.tryOffsetAdjustments(zoneInfo, wallTimeSeconds, offsetInterval, currentTransitionIndex, isDstToFind = this.isDst)) != null) {
                    return returnValue;
                }
                if (transitionIndexDelta > 0) {
                    boolean bl = endSearch = offsetInterval.getEndWallTimeSeconds() - (long)wallTimeSeconds > 86400L;
                    if (!endSearch) continue;
                    clampTop = true;
                    continue;
                }
                if (transitionIndexDelta >= 0) continue;
                boolean bl = endSearch = (long)wallTimeSeconds - offsetInterval.getStartWallTimeSeconds() >= 86400L;
                if (!endSearch) continue;
                clampBottom = true;
            } while (!clampTop || !clampBottom);
            return null;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setYear(int year) {
            this.year = year;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setMonth(int month) {
            this.month = month;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setMonthDay(int monthDay) {
            this.monthDay = monthDay;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setHour(int hour) {
            this.hour = hour;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setMinute(int minute) {
            this.minute = minute;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setSecond(int second) {
            this.second = second;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setWeekDay(int weekDay) {
            this.weekDay = weekDay;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setYearDay(int yearDay) {
            this.yearDay = yearDay;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setIsDst(int isDst) {
            this.isDst = isDst;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$setGmtOffset(int gmtoff) {
            this.gmtOffsetSeconds = gmtoff;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getYear() {
            return this.year;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getMonth() {
            return this.month;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getMonthDay() {
            return this.monthDay;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getHour() {
            return this.hour;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getMinute() {
            return this.minute;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getSecond() {
            return this.second;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getWeekDay() {
            return this.weekDay;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getYearDay() {
            return this.yearDay;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getGmtOffset() {
            return this.gmtOffsetSeconds;
        }

        private final int $$robo$$libcore_util_ZoneInfo_WallTime$getIsDst() {
            return this.isDst;
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$copyFieldsToCalendar() {
            this.calendar.set(1, this.year);
            this.calendar.set(2, this.month);
            this.calendar.set(5, this.monthDay);
            this.calendar.set(11, this.hour);
            this.calendar.set(12, this.minute);
            this.calendar.set(13, this.second);
            this.calendar.set(14, 0);
        }

        private final void $$robo$$libcore_util_ZoneInfo_WallTime$copyFieldsFromCalendar() {
            this.year = this.calendar.get(1);
            this.month = this.calendar.get(2);
            this.monthDay = this.calendar.get(5);
            this.hour = this.calendar.get(11);
            this.minute = this.calendar.get(12);
            this.second = this.calendar.get(13);
            this.weekDay = this.calendar.get(7) - 1;
            this.yearDay = this.calendar.get(6) - 1;
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_ZoneInfo_WallTime$__constructor__();
        }

        public WallTime() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfo_WallTime$__constructor__(), 0, this);
        }

        public void localtime(int n, ZoneInfo zoneInfo) {
            InvokeDynamicSupport.bootstrap("localtime", $$robo$$libcore_util_ZoneInfo_WallTime$localtime(int libcore.util.ZoneInfo ), 0, this, n, zoneInfo);
        }

        public int mktime(ZoneInfo zoneInfo) {
            return (int)InvokeDynamicSupport.bootstrap("mktime", $$robo$$libcore_util_ZoneInfo_WallTime$mktime(libcore.util.ZoneInfo ), 0, this, zoneInfo);
        }

        private Integer tryOffsetAdjustments(ZoneInfo zoneInfo, int n, OffsetInterval offsetInterval, int n2, int n3) throws CheckedArithmeticException {
            return InvokeDynamicSupport.bootstrap("tryOffsetAdjustments", $$robo$$libcore_util_ZoneInfo_WallTime$tryOffsetAdjustments(libcore.util.ZoneInfo int libcore.util.ZoneInfo$OffsetInterval int int ), 0, this, zoneInfo, n, offsetInterval, n2, n3);
        }

        private static int[] getOffsetsOfType(ZoneInfo zoneInfo, int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("getOffsetsOfType", $$robo$$libcore_util_ZoneInfo_WallTime$getOffsetsOfType(libcore.util.ZoneInfo int int ), 0, (ZoneInfo)zoneInfo, (int)n, (int)n2);
        }

        private Integer doWallTimeSearch(ZoneInfo zoneInfo, int n, int n2, boolean bl) throws CheckedArithmeticException {
            return InvokeDynamicSupport.bootstrap("doWallTimeSearch", $$robo$$libcore_util_ZoneInfo_WallTime$doWallTimeSearch(libcore.util.ZoneInfo int int boolean ), 0, this, zoneInfo, n, n2, bl);
        }

        public void setYear(int n) {
            InvokeDynamicSupport.bootstrap("setYear", $$robo$$libcore_util_ZoneInfo_WallTime$setYear(int ), 0, this, n);
        }

        public void setMonth(int n) {
            InvokeDynamicSupport.bootstrap("setMonth", $$robo$$libcore_util_ZoneInfo_WallTime$setMonth(int ), 0, this, n);
        }

        public void setMonthDay(int n) {
            InvokeDynamicSupport.bootstrap("setMonthDay", $$robo$$libcore_util_ZoneInfo_WallTime$setMonthDay(int ), 0, this, n);
        }

        public void setHour(int n) {
            InvokeDynamicSupport.bootstrap("setHour", $$robo$$libcore_util_ZoneInfo_WallTime$setHour(int ), 0, this, n);
        }

        public void setMinute(int n) {
            InvokeDynamicSupport.bootstrap("setMinute", $$robo$$libcore_util_ZoneInfo_WallTime$setMinute(int ), 0, this, n);
        }

        public void setSecond(int n) {
            InvokeDynamicSupport.bootstrap("setSecond", $$robo$$libcore_util_ZoneInfo_WallTime$setSecond(int ), 0, this, n);
        }

        public void setWeekDay(int n) {
            InvokeDynamicSupport.bootstrap("setWeekDay", $$robo$$libcore_util_ZoneInfo_WallTime$setWeekDay(int ), 0, this, n);
        }

        public void setYearDay(int n) {
            InvokeDynamicSupport.bootstrap("setYearDay", $$robo$$libcore_util_ZoneInfo_WallTime$setYearDay(int ), 0, this, n);
        }

        public void setIsDst(int n) {
            InvokeDynamicSupport.bootstrap("setIsDst", $$robo$$libcore_util_ZoneInfo_WallTime$setIsDst(int ), 0, this, n);
        }

        public void setGmtOffset(int n) {
            InvokeDynamicSupport.bootstrap("setGmtOffset", $$robo$$libcore_util_ZoneInfo_WallTime$setGmtOffset(int ), 0, this, n);
        }

        public int getYear() {
            return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$libcore_util_ZoneInfo_WallTime$getYear(), 0, this);
        }

        public int getMonth() {
            return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$libcore_util_ZoneInfo_WallTime$getMonth(), 0, this);
        }

        public int getMonthDay() {
            return (int)InvokeDynamicSupport.bootstrap("getMonthDay", $$robo$$libcore_util_ZoneInfo_WallTime$getMonthDay(), 0, this);
        }

        public int getHour() {
            return (int)InvokeDynamicSupport.bootstrap("getHour", $$robo$$libcore_util_ZoneInfo_WallTime$getHour(), 0, this);
        }

        public int getMinute() {
            return (int)InvokeDynamicSupport.bootstrap("getMinute", $$robo$$libcore_util_ZoneInfo_WallTime$getMinute(), 0, this);
        }

        public int getSecond() {
            return (int)InvokeDynamicSupport.bootstrap("getSecond", $$robo$$libcore_util_ZoneInfo_WallTime$getSecond(), 0, this);
        }

        public int getWeekDay() {
            return (int)InvokeDynamicSupport.bootstrap("getWeekDay", $$robo$$libcore_util_ZoneInfo_WallTime$getWeekDay(), 0, this);
        }

        public int getYearDay() {
            return (int)InvokeDynamicSupport.bootstrap("getYearDay", $$robo$$libcore_util_ZoneInfo_WallTime$getYearDay(), 0, this);
        }

        public int getGmtOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getGmtOffset", $$robo$$libcore_util_ZoneInfo_WallTime$getGmtOffset(), 0, this);
        }

        public int getIsDst() {
            return (int)InvokeDynamicSupport.bootstrap("getIsDst", $$robo$$libcore_util_ZoneInfo_WallTime$getIsDst(), 0, this);
        }

        private void copyFieldsToCalendar() {
            InvokeDynamicSupport.bootstrap("copyFieldsToCalendar", $$robo$$libcore_util_ZoneInfo_WallTime$copyFieldsToCalendar(), 0, this);
        }

        private void copyFieldsFromCalendar() {
            InvokeDynamicSupport.bootstrap("copyFieldsFromCalendar", $$robo$$libcore_util_ZoneInfo_WallTime$copyFieldsFromCalendar(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallTime)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

