/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.shared2;

import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FileUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$libcore_tzdata_shared2_FileUtils$__constructor__() {
    }

    private static final File $$robo$$libcore_tzdata_shared2_FileUtils$createSubFile(File parentDir, String name) throws IOException {
        File subFile = new File(parentDir, name).getCanonicalFile();
        if (!subFile.getPath().startsWith(parentDir.getCanonicalPath())) {
            throw new IOException(name + " must exist beneath " + parentDir + ". Canonicalized subpath: " + subFile);
        }
        return subFile;
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$ensureDirectoriesExist(File dir, boolean makeWorldReadable) throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        File currentDir = dir;
        do {
            dirs.addFirst(currentDir);
        } while ((currentDir = currentDir.getParentFile()) != null);
        for (File dirToCheck : dirs) {
            if (!dirToCheck.exists()) {
                if (!dirToCheck.mkdir()) {
                    throw new IOException("Unable to create directory: " + dir);
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeDirectoryWorldAccessible(dirToCheck);
                continue;
            }
            if (dirToCheck.isDirectory()) continue;
            throw new IOException(dirToCheck + " exists but is not a directory");
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$makeDirectoryWorldAccessible(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory + " must be a directory");
        }
        FileUtils.makeWorldReadable(directory);
        if (!directory.setExecutable(true, false)) {
            throw new IOException("Unable to make " + directory + " world-executable");
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$makeWorldReadable(File file) throws IOException {
        if (!file.setReadable(true, false)) {
            throw new IOException("Unable to make " + file + " world-readable");
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$rename(File from, File to) throws IOException {
        FileUtils.ensureFileDoesNotExist(to);
        if (!from.renameTo(to)) {
            throw new IOException("Unable to rename " + from + " to " + to);
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$ensureFileDoesNotExist(File file) throws IOException {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IOException(file + " is not a file");
            }
            FileUtils.doDelete(file);
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$doDelete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Unable to delete: " + file);
        }
    }

    private static final boolean $$robo$$libcore_tzdata_shared2_FileUtils$isSymlink(File file) throws IOException {
        String baseName = file.getName();
        String canonicalPathExceptBaseName = new File(file.getParentFile().getCanonicalFile(), baseName).getPath();
        return !file.getCanonicalPath().equals(canonicalPathExceptBaseName);
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$deleteRecursive(File toDelete) throws IOException {
        if (toDelete.isDirectory()) {
            for (File file : toDelete.listFiles()) {
                if (file.isDirectory() && !FileUtils.isSymlink(file)) {
                    FileUtils.deleteRecursive(file);
                    continue;
                }
                FileUtils.doDelete(file);
            }
            Object[] remainingFiles = toDelete.list();
            if (remainingFiles.length != 0) {
                throw new IOException("Unable to delete files: " + Arrays.toString(remainingFiles));
            }
        }
        FileUtils.doDelete(toDelete);
    }

    private static final boolean $$robo$$libcore_tzdata_shared2_FileUtils$filesExist(File rootDir, String ... fileNames) {
        for (String fileName : fileNames) {
            File file = new File(rootDir, fileName);
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private static final byte[] $$robo$$libcore_tzdata_shared2_FileUtils$readBytes(File file, int maxBytes) throws IOException {
        if (maxBytes <= 0) {
            throw new IllegalArgumentException("maxBytes ==" + maxBytes);
        }
        try (FileInputStream in = new FileInputStream(file);){
            byte[] max = new byte[maxBytes];
            int bytesRead = in.read(max, 0, maxBytes);
            byte[] toReturn = new byte[bytesRead];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])max, (int)0, (byte[])toReturn, (int)0, (int)bytesRead);
            byte[] byArray = toReturn;
            return byArray;
        }
    }

    private static final void $$robo$$libcore_tzdata_shared2_FileUtils$createEmptyFile(File file) throws IOException {
        new FileOutputStream(file, false).close();
    }

    private void __constructor__() {
        this.$$robo$$libcore_tzdata_shared2_FileUtils$__constructor__();
    }

    private FileUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_shared2_FileUtils$__constructor__(), 0, this);
    }

    public static File createSubFile(File file, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createSubFile", $$robo$$libcore_tzdata_shared2_FileUtils$createSubFile(java.io.File java.lang.String ), 0, (File)file, (String)string2);
    }

    public static void ensureDirectoriesExist(File file, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("ensureDirectoriesExist", $$robo$$libcore_tzdata_shared2_FileUtils$ensureDirectoriesExist(java.io.File boolean ), 0, (File)file, (boolean)bl);
    }

    public static void makeDirectoryWorldAccessible(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("makeDirectoryWorldAccessible", $$robo$$libcore_tzdata_shared2_FileUtils$makeDirectoryWorldAccessible(java.io.File ), 0, (File)file);
    }

    public static void makeWorldReadable(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("makeWorldReadable", $$robo$$libcore_tzdata_shared2_FileUtils$makeWorldReadable(java.io.File ), 0, (File)file);
    }

    public static void rename(File file, File file2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rename", $$robo$$libcore_tzdata_shared2_FileUtils$rename(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public static void ensureFileDoesNotExist(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("ensureFileDoesNotExist", $$robo$$libcore_tzdata_shared2_FileUtils$ensureFileDoesNotExist(java.io.File ), 0, (File)file);
    }

    public static void doDelete(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("doDelete", $$robo$$libcore_tzdata_shared2_FileUtils$doDelete(java.io.File ), 0, (File)file);
    }

    public static boolean isSymlink(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSymlink", $$robo$$libcore_tzdata_shared2_FileUtils$isSymlink(java.io.File ), 0, (File)file);
    }

    public static void deleteRecursive(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("deleteRecursive", $$robo$$libcore_tzdata_shared2_FileUtils$deleteRecursive(java.io.File ), 0, (File)file);
    }

    public static boolean filesExist(File file, String ... stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("filesExist", $$robo$$libcore_tzdata_shared2_FileUtils$filesExist(java.io.File java.lang.String[] ), 0, (File)file, (String[])stringArray);
    }

    public static byte[] readBytes(File file, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readBytes", $$robo$$libcore_tzdata_shared2_FileUtils$readBytes(java.io.File int ), 0, (File)file, (int)n);
    }

    public static void createEmptyFile(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("createEmptyFile", $$robo$$libcore_tzdata_shared2_FileUtils$createEmptyFile(java.io.File ), 0, (File)file);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

