/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import libcore.reflect.ListOfTypes;
import libcore.reflect.ParameterizedTypeImpl;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Types
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Map<Class<?>, String> PRIMITIVE_TO_SIGNATURE;

    private void $$robo$$libcore_reflect_Types$__constructor__() {
    }

    private static final Type[] $$robo$$libcore_reflect_Types$getTypeArray(ListOfTypes types, boolean clone) {
        if (types.length() == 0) {
            return EmptyArray.TYPE;
        }
        Type[] result = types.getResolvedTypes();
        return clone ? (Type[])result.clone() : result;
    }

    private static final Type $$robo$$libcore_reflect_Types$getType(Type type) {
        if (type instanceof ParameterizedTypeImpl) {
            return ((ParameterizedTypeImpl)type).getResolvedType();
        }
        return type;
    }

    private static final String $$robo$$libcore_reflect_Types$getSignature(Class<?> clazz) {
        String primitiveSignature = PRIMITIVE_TO_SIGNATURE.get(clazz);
        if (primitiveSignature != null) {
            return primitiveSignature;
        }
        if (clazz.isArray()) {
            return "[" + Types.getSignature(clazz.getComponentType());
        }
        return "L" + clazz.getName() + ";";
    }

    private static final String $$robo$$libcore_reflect_Types$toString(Class<?>[] types) {
        if (types.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Types.appendTypeName(result, types[0]);
        for (int i = 1; i < types.length; ++i) {
            result.append(',');
            Types.appendTypeName(result, types[i]);
        }
        return result.toString();
    }

    private static final void $$robo$$libcore_reflect_Types$appendTypeName(StringBuilder out, Class<?> c) {
        int dimensions = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++dimensions;
        }
        out.append(c.getName());
        for (int d = 0; d < dimensions; ++d) {
            out.append("[]");
        }
    }

    private static final void $$robo$$libcore_reflect_Types$appendArrayGenericType(StringBuilder out, Type[] types) {
        if (types.length == 0) {
            return;
        }
        Types.appendGenericType(out, types[0]);
        for (int i = 1; i < types.length; ++i) {
            out.append(',');
            Types.appendGenericType(out, types[i]);
        }
    }

    private static final void $$robo$$libcore_reflect_Types$appendGenericType(StringBuilder out, Type type) {
        if (type instanceof TypeVariable) {
            out.append(((TypeVariable)type).getName());
        } else if (type instanceof ParameterizedType) {
            out.append(type.toString());
        } else if (type instanceof GenericArrayType) {
            Type simplified = ((GenericArrayType)type).getGenericComponentType();
            Types.appendGenericType(out, simplified);
            out.append("[]");
        } else if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                int len;
                String[] as = c.getName().split("\\[");
                if (as[len = as.length - 1].length() > 1) {
                    out.append(as[len].substring(1, as[len].length() - 1));
                } else {
                    char ch = as[len].charAt(0);
                    if (ch == 'I') {
                        out.append("int");
                    } else if (ch == 'B') {
                        out.append("byte");
                    } else if (ch == 'J') {
                        out.append("long");
                    } else if (ch == 'F') {
                        out.append("float");
                    } else if (ch == 'D') {
                        out.append("double");
                    } else if (ch == 'S') {
                        out.append("short");
                    } else if (ch == 'C') {
                        out.append("char");
                    } else if (ch == 'Z') {
                        out.append("boolean");
                    } else if (ch == 'V') {
                        out.append("void");
                    }
                }
                for (int i = 0; i < len; ++i) {
                    out.append("[]");
                }
            } else {
                out.append(c.getName());
            }
        }
    }

    static void __staticInitializer__() {
        PRIMITIVE_TO_SIGNATURE = new HashMap(9);
        PRIMITIVE_TO_SIGNATURE.put(Byte.TYPE, "B");
        PRIMITIVE_TO_SIGNATURE.put(Character.TYPE, "C");
        PRIMITIVE_TO_SIGNATURE.put(Short.TYPE, "S");
        PRIMITIVE_TO_SIGNATURE.put(Integer.TYPE, "I");
        PRIMITIVE_TO_SIGNATURE.put(Long.TYPE, "J");
        PRIMITIVE_TO_SIGNATURE.put(Float.TYPE, "F");
        PRIMITIVE_TO_SIGNATURE.put(Double.TYPE, "D");
        PRIMITIVE_TO_SIGNATURE.put(Void.TYPE, "V");
        PRIMITIVE_TO_SIGNATURE.put(Boolean.TYPE, "Z");
    }

    private void __constructor__() {
        this.$$robo$$libcore_reflect_Types$__constructor__();
    }

    private Types() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_Types$__constructor__(), 0, this);
    }

    public static Type[] getTypeArray(ListOfTypes listOfTypes, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getTypeArray", $$robo$$libcore_reflect_Types$getTypeArray(libcore.reflect.ListOfTypes boolean ), 0, (ListOfTypes)listOfTypes, (boolean)bl);
    }

    public static Type getType(Type type) {
        return InvokeDynamicSupport.bootstrapStatic("getType", $$robo$$libcore_reflect_Types$getType(java.lang.reflect.Type ), 0, (Type)type);
    }

    public static String getSignature(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getSignature", $$robo$$libcore_reflect_Types$getSignature(java.lang.Class<?> ), 0, clazz);
    }

    public static String toString(Class<?>[] classArray) {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$libcore_reflect_Types$toString(java.lang.Class<?>[] ), 0, (Class[])classArray);
    }

    public static void appendTypeName(StringBuilder stringBuilder, Class<?> clazz) {
        InvokeDynamicSupport.bootstrapStatic("appendTypeName", $$robo$$libcore_reflect_Types$appendTypeName(java.lang.StringBuilder java.lang.Class<?> ), 0, (StringBuilder)stringBuilder, clazz);
    }

    public static void appendArrayGenericType(StringBuilder stringBuilder, Type[] typeArray) {
        InvokeDynamicSupport.bootstrapStatic("appendArrayGenericType", $$robo$$libcore_reflect_Types$appendArrayGenericType(java.lang.StringBuilder java.lang.reflect.Type[] ), 0, (StringBuilder)stringBuilder, (Type[])typeArray);
    }

    public static void appendGenericType(StringBuilder stringBuilder, Type type) {
        InvokeDynamicSupport.bootstrapStatic("appendGenericType", $$robo$$libcore_reflect_Types$appendGenericType(java.lang.StringBuilder java.lang.reflect.Type ), 0, (StringBuilder)stringBuilder, (Type)type);
    }

    static {
        RobolectricInternals.classInitializing(Types.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Types)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

