/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.MimeVersionHeader;

public class MimeVersion
extends SIPHeader
implements MimeVersionHeader {
    private static final long serialVersionUID = -7951589626435082068L;
    protected int minorVersion;
    protected int majorVersion;

    public MimeVersion() {
        super("MIME-Version");
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public void setMinorVersion(int minorVersion) throws InvalidArgumentException {
        if (minorVersion < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, MimeVersion, setMinorVersion(), the minorVersion parameter is null");
        }
        this.minorVersion = minorVersion;
    }

    @Override
    public void setMajorVersion(int majorVersion) throws InvalidArgumentException {
        if (majorVersion < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, MimeVersion, setMajorVersion(), the majorVersion parameter is null");
        }
        this.majorVersion = majorVersion;
    }

    @Override
    public String encodeBody() {
        return Integer.toString(this.majorVersion) + "." + Integer.toString(this.minorVersion);
    }
}

