/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.profiler.AsciiHprofWriter;
import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.BinaryHprofReader;
import dalvik.system.profiler.HprofData;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HprofBinaryToAscii
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$dalvik_system_profiler_HprofBinaryToAscii$__constructor__() {
    }

    private static final void $$robo$$dalvik_system_profiler_HprofBinaryToAscii$main(String[] args) {
        System.exit(HprofBinaryToAscii.convert(args) ? 0 : 1);
    }

    private static final boolean $$robo$$dalvik_system_profiler_HprofBinaryToAscii$convert(String[] args) {
        HprofData hprofData;
        if (args.length != 1) {
            HprofBinaryToAscii.usage("binary hprof file argument expected");
            return false;
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            HprofBinaryToAscii.usage("file " + file + " does not exist");
            return false;
        }
        if (HprofBinaryToAscii.startsWithMagic(file)) {
            HprofData hprofData2;
            try {
                hprofData2 = HprofBinaryToAscii.readHprof(file);
            }
            catch (IOException e) {
                System.out.println("Problem reading binary hprof data from " + file + ": " + e.getMessage());
                return false;
            }
            return HprofBinaryToAscii.write(hprofData2);
        }
        try {
            hprofData = HprofBinaryToAscii.readSnapshot(file);
        }
        catch (IOException e) {
            System.out.println("Problem reading snapshot containing binary hprof data from " + file + ": " + e.getMessage());
            return false;
        }
        return HprofBinaryToAscii.write(hprofData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$dalvik_system_profiler_HprofBinaryToAscii$startsWithMagic(File file) {
        DataInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            boolean bl = BinaryHprof.readMagic(inputStream) != null;
            HprofBinaryToAscii.closeQuietly(inputStream);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            HprofBinaryToAscii.closeQuietly(inputStream);
        }
    }

    private static final HprofData $$robo$$dalvik_system_profiler_HprofBinaryToAscii$readHprof(File file) throws IOException {
        HprofData hprofData;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            hprofData = HprofBinaryToAscii.read(inputStream);
        }
        catch (Throwable throwable) {
            HprofBinaryToAscii.closeQuietly(inputStream);
            throw throwable;
        }
        HprofBinaryToAscii.closeQuietly(inputStream);
        return hprofData;
    }

    private static final HprofData $$robo$$dalvik_system_profiler_HprofBinaryToAscii$readSnapshot(File file) throws IOException {
        HprofData hprofData;
        BufferedInputStream inputStream = null;
        try {
            int ch;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            while ((ch = ((InputStream)inputStream).read()) != -1) {
                if (ch != 10 || ((InputStream)inputStream).read() != 10) continue;
                hprofData = HprofBinaryToAscii.read(inputStream);
            }
        }
        catch (Throwable throwable) {
            HprofBinaryToAscii.closeQuietly(inputStream);
            throw throwable;
        }
        {
            HprofBinaryToAscii.closeQuietly(inputStream);
            return hprofData;
        }
        throw new EOFException("Could not find expected header");
    }

    private static final HprofData $$robo$$dalvik_system_profiler_HprofBinaryToAscii$read(InputStream inputStream) throws IOException {
        BinaryHprofReader reader = new BinaryHprofReader(inputStream);
        reader.setStrict(false);
        reader.read();
        return reader.getHprofData();
    }

    private static final void $$robo$$dalvik_system_profiler_HprofBinaryToAscii$closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final boolean $$robo$$dalvik_system_profiler_HprofBinaryToAscii$write(HprofData hprofData) {
        try {
            AsciiHprofWriter.write(hprofData, System.out);
        }
        catch (IOException e) {
            System.out.println("Problem writing ASCII hprof data: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static final void $$robo$$dalvik_system_profiler_HprofBinaryToAscii$usage(String error) {
        System.out.print("ERROR: ");
        System.out.println(error);
        System.out.println();
        System.out.println("usage: HprofBinaryToAscii <binary-hprof-file>");
        System.out.println();
        System.out.println("Reads a binary hprof file and print it in ASCII format");
    }

    private void __constructor__() {
        this.$$robo$$dalvik_system_profiler_HprofBinaryToAscii$__constructor__();
    }

    public HprofBinaryToAscii() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$__constructor__(), 0, this);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$main(java.lang.String[] ), 0, (String[])stringArray);
    }

    private static boolean convert(String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$convert(java.lang.String[] ), 0, (String[])stringArray);
    }

    private static boolean startsWithMagic(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("startsWithMagic", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$startsWithMagic(java.io.File ), 0, (File)file);
    }

    private static HprofData readHprof(File file) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readHprof", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$readHprof(java.io.File ), 0, (File)file);
    }

    private static HprofData readSnapshot(File file) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readSnapshot", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$readSnapshot(java.io.File ), 0, (File)file);
    }

    private static HprofData read(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("read", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$read(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    private static void closeQuietly(Closeable closeable) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$closeQuietly(java.io.Closeable ), 0, (Closeable)closeable);
    }

    private static boolean write(HprofData hprofData) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("write", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$write(dalvik.system.profiler.HprofData ), 0, (HprofData)hprofData);
    }

    private static void usage(String string2) {
        InvokeDynamicSupport.bootstrapStatic("usage", $$robo$$dalvik_system_profiler_HprofBinaryToAscii$usage(java.lang.String ), 0, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HprofBinaryToAscii)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

