/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.WindowManagerPolicy;
import com.android.server.AnimationThread;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowSurfacePlacer;
import java.io.PrintWriter;

public class WindowAnimator {
    private static final String TAG = "WindowManager";
    final WindowManagerService mService;
    final Context mContext;
    final WindowManagerPolicy mPolicy;
    private final WindowSurfacePlacer mWindowPlacerLocked;
    private boolean mAnimating;
    private boolean mLastAnimating;
    boolean mAppWindowAnimating;
    final Choreographer.FrameCallback mAnimationFrameCallback;
    long mCurrentTime;
    int mAnimTransactionSequence;
    WindowState mWindowDetachedWallpaper = null;
    int mBulkUpdateParams = 0;
    Object mLastWindowFreezeSource;
    SparseArray<DisplayContentsAnimator> mDisplayContentsAnimators = new SparseArray(2);
    boolean mInitialized = false;
    private boolean mRemoveReplacedWindows = false;
    private Choreographer mChoreographer;
    private boolean mAnimationFrameCallbackScheduled;

    WindowAnimator(WindowManagerService service) {
        this.mService = service;
        this.mContext = service.mContext;
        this.mPolicy = service.mPolicy;
        this.mWindowPlacerLocked = service.mWindowPlacerLocked;
        AnimationThread.getHandler().runWithScissors(() -> {
            this.mChoreographer = Choreographer.getSfInstance();
        }, 0L);
        this.mAnimationFrameCallback = frameTimeNs -> {
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                this.mAnimationFrameCallbackScheduled = false;
            }
            this.animate(frameTimeNs);
        };
    }

    void addDisplayLocked(int displayId) {
        this.getDisplayContentsAnimatorLocked(displayId);
        if (displayId == 0) {
            this.mInitialized = true;
        }
    }

    void removeDisplayLocked(int displayId) {
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator != null && displayAnimator.mScreenRotationAnimation != null) {
            displayAnimator.mScreenRotationAnimation.kill();
            displayAnimator.mScreenRotationAnimation = null;
        }
        this.mDisplayContentsAnimators.delete(displayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animate(long frameTimeNs) {
        WindowHashMap windowHashMap;
        boolean transactionOpen = false;
        try {
            windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                DisplayContent dc;
                int displayId;
                int i;
                block29: {
                    if (this.mInitialized) break block29;
                    return;
                }
                this.mCurrentTime = frameTimeNs / 1000000L;
                this.mBulkUpdateParams = 8;
                this.mAnimating = false;
                this.mAppWindowAnimating = false;
                this.mService.openSurfaceTransaction();
                transactionOpen = true;
                SurfaceControl.setAnimationTransaction();
                AccessibilityController accessibilityController = this.mService.mAccessibilityController;
                int numDisplays = this.mDisplayContentsAnimators.size();
                for (i = 0; i < numDisplays; ++i) {
                    displayId = this.mDisplayContentsAnimators.keyAt(i);
                    dc = this.mService.mRoot.getDisplayContentOrCreate(displayId);
                    dc.stepAppWindowsAnimation(this.mCurrentTime);
                    DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
                    ScreenRotationAnimation screenRotationAnimation = displayAnimator.mScreenRotationAnimation;
                    if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                        if (screenRotationAnimation.stepAnimationLocked(this.mCurrentTime)) {
                            this.setAnimating(true);
                        } else {
                            this.mBulkUpdateParams |= 1;
                            screenRotationAnimation.kill();
                            displayAnimator.mScreenRotationAnimation = null;
                            if (accessibilityController != null && dc.isDefaultDisplay) {
                                accessibilityController.onRotationChangedLocked(this.mService.getDefaultDisplayContentLocked());
                            }
                        }
                    }
                    ++this.mAnimTransactionSequence;
                    dc.updateWindowsForAnimator(this);
                    dc.updateWallpaperForAnimator(this);
                    dc.prepareWindowSurfaces();
                }
                for (i = 0; i < numDisplays; ++i) {
                    displayId = this.mDisplayContentsAnimators.keyAt(i);
                    dc = this.mService.mRoot.getDisplayContentOrCreate(displayId);
                    dc.checkAppWindowsReadyToShow();
                    ScreenRotationAnimation screenRotationAnimation = this.mDisplayContentsAnimators.valueAt((int)i).mScreenRotationAnimation;
                    if (screenRotationAnimation != null) {
                        screenRotationAnimation.updateSurfacesInTransaction();
                    }
                    this.orAnimating(dc.animateDimLayers());
                    this.orAnimating(dc.getDockedDividerController().animate(this.mCurrentTime));
                    if (accessibilityController == null || !dc.isDefaultDisplay) continue;
                    accessibilityController.drawMagnifiedRegionBorderIfNeededLocked();
                }
                if (this.mService.mDragState != null) {
                    this.mAnimating |= this.mService.mDragState.stepAnimationLocked(this.mCurrentTime);
                }
                if (this.mAnimating) {
                    this.mService.scheduleAnimationLocked();
                }
                if (this.mService.mWatermark != null) {
                    this.mService.mWatermark.drawIfNeeded();
                }
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            if (transactionOpen) {
                this.mService.closeSurfaceTransaction(false);
            }
        }
        windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            boolean hasPendingLayoutChanges = this.mService.mRoot.hasPendingLayoutChanges(this);
            boolean doRequest = false;
            if (this.mBulkUpdateParams != 0) {
                doRequest = this.mService.mRoot.copyAnimToLayoutParams();
            }
            if (hasPendingLayoutChanges || doRequest) {
                this.mWindowPlacerLocked.requestTraversal();
            }
            if (this.mAnimating && !this.mLastAnimating) {
                this.mService.mTaskSnapshotController.setPersisterPaused(true);
                Trace.asyncTraceBegin(32L, "animating", 0);
            }
            if (!this.mAnimating && this.mLastAnimating) {
                this.mWindowPlacerLocked.requestTraversal();
                this.mService.mTaskSnapshotController.setPersisterPaused(false);
                Trace.asyncTraceEnd(32L, "animating", 0);
            }
            this.mLastAnimating = this.mAnimating;
            if (this.mRemoveReplacedWindows) {
                this.mService.mRoot.removeReplacedWindows();
                this.mRemoveReplacedWindows = false;
            }
            this.mService.stopUsingSavedSurfaceLocked();
            this.mService.destroyPreservedSurfaceLocked();
            this.mService.mWindowPlacerLocked.destroyPendingSurfaces();
        }
    }

    private static String bulkUpdateParamsToString(int bulkUpdateParams) {
        StringBuilder builder = new StringBuilder(128);
        if ((bulkUpdateParams & 1) != 0) {
            builder.append(" UPDATE_ROTATION");
        }
        if ((bulkUpdateParams & 2) != 0) {
            builder.append(" WALLPAPER_MAY_CHANGE");
        }
        if ((bulkUpdateParams & 4) != 0) {
            builder.append(" FORCE_HIDING_CHANGED");
        }
        if ((bulkUpdateParams & 8) != 0) {
            builder.append(" ORIENTATION_CHANGE_COMPLETE");
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            builder.append(" TURN_ON_SCREEN");
        }
        return builder.toString();
    }

    public void dumpLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        String subPrefix = "  " + prefix;
        String subSubPrefix = "  " + subPrefix;
        for (int i = 0; i < this.mDisplayContentsAnimators.size(); ++i) {
            pw.print(prefix);
            pw.print("DisplayContentsAnimator #");
            pw.print(this.mDisplayContentsAnimators.keyAt(i));
            pw.println(":");
            DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.valueAt(i);
            DisplayContent dc = this.mService.mRoot.getDisplayContentOrCreate(this.mDisplayContentsAnimators.keyAt(i));
            dc.dumpWindowAnimators(pw, subPrefix);
            if (displayAnimator.mScreenRotationAnimation != null) {
                pw.print(subPrefix);
                pw.println("mScreenRotationAnimation:");
                displayAnimator.mScreenRotationAnimation.printTo(subSubPrefix, pw);
            } else if (dumpAll) {
                pw.print(subPrefix);
                pw.println("no ScreenRotationAnimation ");
            }
            pw.println();
        }
        pw.println();
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mAnimTransactionSequence=");
            pw.print(this.mAnimTransactionSequence);
            pw.print(prefix);
            pw.print("mCurrentTime=");
            pw.println(TimeUtils.formatUptime(this.mCurrentTime));
        }
        if (this.mBulkUpdateParams != 0) {
            pw.print(prefix);
            pw.print("mBulkUpdateParams=0x");
            pw.print(Integer.toHexString(this.mBulkUpdateParams));
            pw.println(WindowAnimator.bulkUpdateParamsToString(this.mBulkUpdateParams));
        }
        if (this.mWindowDetachedWallpaper != null) {
            pw.print(prefix);
            pw.print("mWindowDetachedWallpaper=");
            pw.println(this.mWindowDetachedWallpaper);
        }
    }

    int getPendingLayoutChanges(int displayId) {
        if (displayId < 0) {
            return 0;
        }
        DisplayContent displayContent = this.mService.mRoot.getDisplayContentOrCreate(displayId);
        return displayContent != null ? displayContent.pendingLayoutChanges : 0;
    }

    void setPendingLayoutChanges(int displayId, int changes) {
        if (displayId < 0) {
            return;
        }
        DisplayContent displayContent = this.mService.mRoot.getDisplayContentOrCreate(displayId);
        if (displayContent != null) {
            displayContent.pendingLayoutChanges |= changes;
        }
    }

    private DisplayContentsAnimator getDisplayContentsAnimatorLocked(int displayId) {
        if (displayId < 0) {
            return null;
        }
        DisplayContentsAnimator displayAnimator = this.mDisplayContentsAnimators.get(displayId);
        if (displayAnimator == null && this.mService.mRoot.getDisplayContent(displayId) != null) {
            displayAnimator = new DisplayContentsAnimator();
            this.mDisplayContentsAnimators.put(displayId, displayAnimator);
        }
        return displayAnimator;
    }

    void setScreenRotationAnimationLocked(int displayId, ScreenRotationAnimation animation) {
        DisplayContentsAnimator animator2 = this.getDisplayContentsAnimatorLocked(displayId);
        if (animator2 != null) {
            animator2.mScreenRotationAnimation = animation;
        }
    }

    ScreenRotationAnimation getScreenRotationAnimationLocked(int displayId) {
        if (displayId < 0) {
            return null;
        }
        DisplayContentsAnimator animator2 = this.getDisplayContentsAnimatorLocked(displayId);
        return animator2 != null ? animator2.mScreenRotationAnimation : null;
    }

    void requestRemovalOfReplacedWindows(WindowState win) {
        this.mRemoveReplacedWindows = true;
    }

    void scheduleAnimation() {
        if (!this.mAnimationFrameCallbackScheduled) {
            this.mAnimationFrameCallbackScheduled = true;
            this.mChoreographer.postFrameCallback(this.mAnimationFrameCallback);
        }
    }

    boolean isAnimating() {
        return this.mAnimating;
    }

    boolean isAnimationScheduled() {
        return this.mAnimationFrameCallbackScheduled;
    }

    Choreographer getChoreographer() {
        return this.mChoreographer;
    }

    void setAnimating(boolean animating) {
        this.mAnimating = animating;
    }

    void orAnimating(boolean animating) {
        this.mAnimating |= animating;
    }

    private class DisplayContentsAnimator {
        ScreenRotationAnimation mScreenRotationAnimation = null;

        private DisplayContentsAnimator() {
        }
    }
}

