/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.ArrayMap;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

class UnknownAppVisibilityController {
    private static final String TAG = "WindowManager";
    private static final int UNKNOWN_STATE_WAITING_RESUME = 1;
    private static final int UNKNOWN_STATE_WAITING_RELAYOUT = 2;
    private static final int UNKNOWN_STATE_WAITING_VISIBILITY_UPDATE = 3;
    private final ArrayMap<AppWindowToken, Integer> mUnknownApps = new ArrayMap();
    private final WindowManagerService mService;

    UnknownAppVisibilityController(WindowManagerService service) {
        this.mService = service;
    }

    boolean allResolved() {
        return this.mUnknownApps.isEmpty();
    }

    void clear() {
        this.mUnknownApps.clear();
    }

    String getDebugMessage() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.mUnknownApps.size() - 1; i >= 0; --i) {
            builder.append("app=").append(this.mUnknownApps.keyAt(i)).append(" state=").append(this.mUnknownApps.valueAt(i));
            if (i == 0) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    void appRemovedOrHidden(AppWindowToken appWindow) {
        this.mUnknownApps.remove(appWindow);
    }

    void notifyLaunched(AppWindowToken appWindow) {
        this.mUnknownApps.put(appWindow, 1);
    }

    void notifyAppResumedFinished(AppWindowToken appWindow) {
        if (this.mUnknownApps.containsKey(appWindow) && this.mUnknownApps.get(appWindow) == 1) {
            this.mUnknownApps.put(appWindow, 2);
        }
    }

    void notifyRelayouted(AppWindowToken appWindow) {
        if (!this.mUnknownApps.containsKey(appWindow)) {
            return;
        }
        int state = this.mUnknownApps.get(appWindow);
        if (state == 2) {
            this.mUnknownApps.put(appWindow, 3);
            this.mService.notifyKeyguardFlagsChanged(this::notifyVisibilitiesUpdated);
        }
    }

    private void notifyVisibilitiesUpdated() {
        boolean changed = false;
        for (int i = this.mUnknownApps.size() - 1; i >= 0; --i) {
            if (this.mUnknownApps.valueAt(i) != 3) continue;
            this.mUnknownApps.removeAt(i);
            changed = true;
        }
        if (changed) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    void dump(PrintWriter pw, String prefix) {
        if (this.mUnknownApps.isEmpty()) {
            return;
        }
        pw.println(prefix + "Unknown visibilities:");
        for (int i = this.mUnknownApps.size() - 1; i >= 0; --i) {
            pw.println(prefix + "  app=" + this.mUnknownApps.keyAt(i) + " state=" + this.mUnknownApps.valueAt(i));
        }
    }
}

