/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Trace;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.WindowManagerPolicy;
import com.android.internal.R;
import com.android.server.AttributeCache;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SnapshotStartingData;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;

public class AppWindowContainerController
extends WindowContainerController<AppWindowToken, AppWindowContainerListener> {
    private static final int STARTING_WINDOW_TYPE_NONE = 0;
    private static final int STARTING_WINDOW_TYPE_SNAPSHOT = 1;
    private static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 2;
    private final IApplicationToken mToken;
    private final Handler mHandler;
    private final Runnable mOnWindowsVisible = () -> {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsVisible();
    };
    private final Runnable mOnWindowsGone = () -> {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsGone();
    };
    private final Runnable mRemoveStartingWindow = () -> {
        WindowManagerPolicy.StartingSurface surface = null;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                return;
            }
            if (((AppWindowToken)this.mContainer).startingData != null) {
                surface = ((AppWindowToken)this.mContainer).startingSurface;
                ((AppWindowToken)this.mContainer).startingData = null;
                ((AppWindowToken)this.mContainer).startingSurface = null;
                ((AppWindowToken)this.mContainer).startingWindow = null;
                ((AppWindowToken)this.mContainer).startingDisplayed = false;
                if (surface == null) {
                    // empty if block
                }
            }
        }
        if (surface != null) {
            try {
                surface.remove();
            }
            catch (Exception e) {
                Slog.w("WindowManager", "Exception when removing starting window", e);
            }
        }
    };
    private final Runnable mAddStartingWindow = () -> {
        AppWindowToken container;
        StartingData startingData;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                return;
            }
            startingData = ((AppWindowToken)this.mContainer).startingData;
            container = (AppWindowToken)this.mContainer;
        }
        if (startingData == null) {
            return;
        }
        WindowManagerPolicy.StartingSurface surface = null;
        try {
            surface = startingData.createStartingSurface(container);
        }
        catch (Exception e) {
            Slog.w("WindowManager", "Exception when adding starting window", e);
        }
        if (surface != null) {
            boolean abort = false;
            WindowHashMap windowHashMap2 = this.mWindowMap;
            synchronized (windowHashMap2) {
                if (container.removed || container.startingData == null) {
                    container.startingWindow = null;
                    container.startingData = null;
                    abort = true;
                } else {
                    container.startingSurface = surface;
                }
            }
            if (abort) {
                surface.remove();
            }
        }
    };

    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, Configuration overrideConfig, Rect bounds) {
        this(taskController, token, listener, index, requestedOrientation, fullscreen, showForAllUsers, configChanges, voiceInteraction, launchTaskBehind, alwaysFocusable, targetSdkVersion, rotationAnimationHint, inputDispatchingTimeoutNanos, WindowManagerService.getInstance(), overrideConfig, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, WindowManagerService service, Configuration overrideConfig, Rect bounds) {
        super(listener, service);
        this.mHandler = new H(service.mH.getLooper());
        this.mToken = token;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            AppWindowToken atoken = this.mRoot.getAppWindowToken(this.mToken.asBinder());
            if (atoken != null) {
                Slog.w("WindowManager", "Attempted to add existing app token: " + this.mToken);
                return;
            }
            Task task = (Task)taskController.mContainer;
            if (task == null) {
                throw new IllegalArgumentException("AppWindowContainerController: invalid  controller=" + taskController);
            }
            atoken = this.createAppWindow(this.mService, token, voiceInteraction, task.getDisplayContent(), inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdkVersion, requestedOrientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, this, overrideConfig, bounds);
            task.addChild(atoken, index);
        }
    }

    AppWindowToken createAppWindow(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller, Configuration overrideConfig, Rect bounds) {
        return new AppWindowToken(service, token, voiceInteraction, dc, inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdk, orientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, controller, overrideConfig, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainer(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            DisplayContent dc = this.mRoot.getDisplayContent(displayId);
            if (dc == null) {
                Slog.w("WindowManager", "removeAppToken: Attempted to remove binder token: " + this.mToken + " from non-existing displayId=" + displayId);
                return;
            }
            dc.removeAppToken(this.mToken.asBinder());
            super.removeContainer();
        }
    }

    @Override
    public void removeContainer() {
        throw new UnsupportedOperationException("Use removeContainer(displayId) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(TaskWindowContainerController taskController, int position) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                return;
            }
            Task task = (Task)taskController.mContainer;
            if (task == null) {
                throw new IllegalArgumentException("reparent: could not find task=" + taskController);
            }
            ((AppWindowToken)this.mContainer).reparent(task, position);
            ((AppWindowToken)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration setOrientation(int requestedOrientation, int displayId, Configuration displayConfig, boolean freezeScreenIfNeeded) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set orientation of non-existing app token: " + this.mToken);
                return null;
            }
            ((AppWindowToken)this.mContainer).setOrientation(requestedOrientation);
            IBinder binder = freezeScreenIfNeeded ? this.mToken.asBinder() : null;
            return this.mService.updateOrientationFromAppTokens(displayConfig, binder, displayId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrientation() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                return -1;
            }
            return ((AppWindowToken)this.mContainer).getOrientationIgnoreVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOverrideConfigurationChanged(Configuration overrideConfiguration, Rect bounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer != null) {
                ((AppWindowToken)this.mContainer).onOverrideConfigurationChanged(overrideConfiguration, bounds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablePreviewScreenshots(boolean disable) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set disable screenshots of non-existing app token: " + this.mToken);
                return;
            }
            ((AppWindowToken)this.mContainer).setDisablePreviewScreenshots(disable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(boolean visible, boolean deferHidingClient) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set visibility of non-existing app token: " + this.mToken);
                return;
            }
            AppWindowToken wtoken = (AppWindowToken)this.mContainer;
            if (!visible && wtoken.hiddenRequested) {
                if (!deferHidingClient && wtoken.mDeferHidingClient) {
                    wtoken.mDeferHidingClient = deferHidingClient;
                    wtoken.setClientHidden(true);
                }
                return;
            }
            this.mService.mOpeningApps.remove(wtoken);
            this.mService.mClosingApps.remove(wtoken);
            wtoken.waitingToShow = false;
            wtoken.hiddenRequested = !visible;
            wtoken.mDeferHidingClient = deferHidingClient;
            if (!visible) {
                wtoken.removeDeadWindows();
                wtoken.setVisibleBeforeClientHidden();
                this.mService.mUnknownAppVisibilityController.appRemovedOrHidden(wtoken);
            } else {
                if (!this.mService.mAppTransition.isTransitionSet() && this.mService.mAppTransition.isReady()) {
                    this.mService.mOpeningApps.add(wtoken);
                }
                wtoken.startingMoved = false;
                if (wtoken.hidden || wtoken.mAppStopped) {
                    wtoken.clearAllDrawn();
                    if (wtoken.hidden) {
                        wtoken.waitingToShow = true;
                    }
                    if (wtoken.isClientHidden()) {
                        wtoken.setClientHidden(false);
                    }
                }
                wtoken.requestUpdateWallpaperIfNeeded();
                wtoken.mAppStopped = false;
            }
            if (this.mService.okToDisplay() && this.mService.mAppTransition.isTransitionSet()) {
                AppWindowToken focusedToken;
                WindowState win;
                if (wtoken.mAppAnimator.usingTransferredAnimation && wtoken.mAppAnimator.animation == null) {
                    Slog.wtf("WindowManager", "Will NOT set dummy animation on: " + wtoken + ", using null transferred animation!");
                }
                if (!(wtoken.mAppAnimator.usingTransferredAnimation || wtoken.startingDisplayed && !this.mService.mSkipAppTransitionAnimation)) {
                    wtoken.mAppAnimator.setDummyAnimation();
                }
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mService.mOpeningApps.add(wtoken);
                    wtoken.mEnteringAnimation = true;
                } else {
                    this.mService.mClosingApps.add(wtoken);
                    wtoken.mEnteringAnimation = false;
                }
                if (this.mService.mAppTransition.getAppTransition() == 16 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null && (focusedToken = win.mAppToken) != null) {
                    focusedToken.hidden = true;
                    this.mService.mOpeningApps.add(focusedToken);
                }
                return;
            }
            wtoken.setVisibility(null, visible, -1, true, wtoken.mVoiceInteraction);
            wtoken.updateReportedVisibilityLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownVisibilityLaunched() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer != null) {
                this.mService.mUnknownAppVisibilityController.notifyLaunched((AppWindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set icon of non-existing app token: " + this.mToken);
                return false;
            }
            if (!this.mService.okToDisplay()) {
                return false;
            }
            if (((AppWindowToken)this.mContainer).startingData != null) {
                return false;
            }
            WindowState mainWin = ((AppWindowToken)this.mContainer).findMainWindow();
            if (mainWin != null && mainWin.isVisible() && mainWin.isDrawnLw()) {
                return false;
            }
            ActivityManager.TaskSnapshot snapshot = this.mService.mTaskSnapshotController.getSnapshot(((AppWindowToken)this.mContainer).getTask().mTaskId, ((AppWindowToken)this.mContainer).getTask().mUserId, false, false);
            int type = this.getStartingWindowType(newTask, taskSwitch, processRunning, allowTaskSnapshot, activityCreated, fromRecents, snapshot);
            if (type == 1) {
                return this.createSnapshot(snapshot);
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mService.mCurrentUserId);
                if (ent == null) {
                    return false;
                }
                boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                boolean windowIsFloating = ent.array.getBoolean(4, false);
                boolean windowShowWallpaper = ent.array.getBoolean(14, false);
                boolean windowDisableStarting = ent.array.getBoolean(12, false);
                if (windowIsTranslucent) {
                    return false;
                }
                if (windowIsFloating || windowDisableStarting) {
                    return false;
                }
                if (windowShowWallpaper) {
                    if (((AppWindowToken)this.mContainer).getDisplayContent().mWallpaperController.getWallpaperTarget() == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return false;
                    }
                }
            }
            if (((AppWindowToken)this.mContainer).transferStartingWindow(transferFrom)) {
                return true;
            }
            if (type != 2) {
                return false;
            }
            ((AppWindowToken)this.mContainer).startingData = new SplashScreenStartingData(this.mService, pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, ((AppWindowToken)this.mContainer).getMergedOverrideConfiguration());
            this.scheduleAddStartingWindow();
        }
        return true;
    }

    private int getStartingWindowType(boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents, ActivityManager.TaskSnapshot snapshot) {
        if (this.mService.mAppTransition.getAppTransition() == 19) {
            return 0;
        }
        if (newTask || !processRunning || taskSwitch && !activityCreated) {
            return 2;
        }
        if (taskSwitch && allowTaskSnapshot) {
            return snapshot == null ? 0 : (this.snapshotOrientationSameAsTask(snapshot) || fromRecents ? 1 : 2);
        }
        return 0;
    }

    void scheduleAddStartingWindow() {
        this.mService.mAnimationHandler.postAtFrontOfQueue(this.mAddStartingWindow);
    }

    private boolean createSnapshot(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        ((AppWindowToken)this.mContainer).startingData = new SnapshotStartingData(this.mService, snapshot);
        this.scheduleAddStartingWindow();
        return true;
    }

    private boolean snapshotOrientationSameAsTask(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return ((AppWindowToken)this.mContainer).getTask().getConfiguration().orientation == snapshot.getOrientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStartingWindow() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mHandler.hasCallbacks(this.mRemoveStartingWindow)) {
                return;
            }
            if (((AppWindowToken)this.mContainer).startingWindow == null) {
                if (((AppWindowToken)this.mContainer).startingData != null) {
                    ((AppWindowToken)this.mContainer).startingData = null;
                }
                return;
            }
            this.mHandler.post(this.mRemoveStartingWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer != null) {
                this.mService.mInputMonitor.pauseDispatchingLw((WindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer != null) {
                this.mService.mInputMonitor.resumeDispatchingLw((WindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppResumed(boolean wasStopped) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to notify resumed of non-existing app token: " + this.mToken);
                return;
            }
            ((AppWindowToken)this.mContainer).notifyAppResumed(wasStopped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppStopped() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to notify stopped of non-existing app token: " + this.mToken);
                return;
            }
            ((AppWindowToken)this.mContainer).notifyAppStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFreezingScreen(int configChanges) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (configChanges == 0 && this.mService.okToDisplay()) {
                return;
            }
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to freeze screen with non-existing app token: " + this.mContainer);
                return;
            }
            ((AppWindowToken)this.mContainer).startFreezingScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFreezingScreen(boolean force) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mContainer == null) {
                return;
            }
            ((AppWindowToken)this.mContainer).stopFreezingScreen(true, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap screenshotApplications(int displayId, int width, int height, float frameScale) {
        try {
            DisplayContent dc;
            Trace.traceBegin(32L, "screenshotApplications");
            Object object = this.mWindowMap;
            synchronized (object) {
                dc = this.mRoot.getDisplayContentOrCreate(displayId);
                if (dc == null) {
                    Bitmap bitmap = null;
                    return bitmap;
                }
            }
            object = dc.screenshotApplications(this.mToken.asBinder(), width, height, false, frameScale, Bitmap.Config.RGB_565, false, false);
            return object;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    void reportStartingWindowDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    void reportWindowsDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
    }

    void reportWindowsVisible() {
        this.mHandler.post(this.mOnWindowsVisible);
    }

    void reportWindowsGone() {
        this.mHandler.post(this.mOnWindowsGone);
    }

    boolean keyDispatchingTimedOut(String reason, int windowPid) {
        return this.mListener != null && ((AppWindowContainerListener)this.mListener).keyDispatchingTimedOut(reason, windowPid);
    }

    public String toString() {
        return "AppWindowContainerController{ token=" + this.mToken + " mContainer=" + this.mContainer + " mListener=" + this.mListener + "}";
    }

    private final class H
    extends Handler {
        public static final int NOTIFY_WINDOWS_DRAWN = 1;
        public static final int NOTIFY_STARTING_WINDOW_DRAWN = 2;

        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onWindowsDrawn(msg.getWhen());
                    break;
                }
                case 2: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onStartingWindowDrawn(msg.getWhen());
                    break;
                }
            }
        }
    }
}

