/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import java.util.Objects;

public class ManagedApplicationService {
    private final String TAG = this.getClass().getSimpleName();
    private final Context mContext;
    private final int mUserId;
    private final ComponentName mComponent;
    private final int mClientLabel;
    private final String mSettingsAction;
    private final BinderChecker mChecker;
    private final IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = ManagedApplicationService.this.mLock;
            synchronized (object) {
                ManagedApplicationService.this.mBoundInterface = null;
            }
        }
    };
    private final Object mLock = new Object();
    private ServiceConnection mPendingConnection;
    private ServiceConnection mConnection;
    private IInterface mBoundInterface;
    private PendingEvent mPendingEvent;

    private ManagedApplicationService(Context context, ComponentName component, int userId, int clientLabel, String settingsAction, BinderChecker binderChecker) {
        this.mContext = context;
        this.mComponent = component;
        this.mUserId = userId;
        this.mClientLabel = clientLabel;
        this.mSettingsAction = settingsAction;
        this.mChecker = binderChecker;
    }

    public static ManagedApplicationService build(Context context, ComponentName component, int userId, int clientLabel, String settingsAction, BinderChecker binderChecker) {
        return new ManagedApplicationService(context, component, userId, clientLabel, settingsAction, binderChecker);
    }

    public int getUserId() {
        return this.mUserId;
    }

    public ComponentName getComponent() {
        return this.mComponent;
    }

    public boolean disconnectIfNotMatching(ComponentName componentName, int userId) {
        if (this.matches(componentName, userId)) {
            return false;
        }
        this.disconnect();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(PendingEvent event) {
        IInterface iface;
        Object object = this.mLock;
        synchronized (object) {
            iface = this.mBoundInterface;
            if (iface == null) {
                this.mPendingEvent = event;
            }
        }
        if (iface != null) {
            try {
                event.runEvent(iface);
            }
            catch (RemoteException | RuntimeException ex) {
                Slog.e(this.TAG, "Received exception from user service: ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingConnection = null;
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            }
            this.mBoundInterface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mLock;
        synchronized (object) {
            ServiceConnection serviceConnection;
            if (this.mConnection != null || this.mPendingConnection != null) {
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent(this.mSettingsAction), 0);
            final Intent intent = new Intent().setComponent(this.mComponent).putExtra("android.intent.extra.client_label", this.mClientLabel).putExtra("android.intent.extra.client_intent", pendingIntent);
            this.mPendingConnection = serviceConnection = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                    IInterface iface = null;
                    PendingEvent pendingEvent = null;
                    Object object = ManagedApplicationService.this.mLock;
                    synchronized (object) {
                        if (ManagedApplicationService.this.mPendingConnection != this) {
                            ManagedApplicationService.this.mContext.unbindService(this);
                            return;
                        }
                        ManagedApplicationService.this.mPendingConnection = null;
                        ManagedApplicationService.this.mConnection = this;
                        try {
                            iBinder.linkToDeath(ManagedApplicationService.this.mDeathRecipient, 0);
                            ManagedApplicationService.this.mBoundInterface = ManagedApplicationService.this.mChecker.asInterface(iBinder);
                            if (!ManagedApplicationService.this.mChecker.checkType(ManagedApplicationService.this.mBoundInterface)) {
                                ManagedApplicationService.this.mContext.unbindService(this);
                                ManagedApplicationService.this.mBoundInterface = null;
                            }
                            iface = ManagedApplicationService.this.mBoundInterface;
                            pendingEvent = ManagedApplicationService.this.mPendingEvent;
                            ManagedApplicationService.this.mPendingEvent = null;
                        }
                        catch (RemoteException e) {
                            Slog.w(ManagedApplicationService.this.TAG, "Unable to bind service: " + intent, e);
                            ManagedApplicationService.this.mBoundInterface = null;
                        }
                    }
                    if (iface != null && pendingEvent != null) {
                        try {
                            pendingEvent.runEvent(iface);
                        }
                        catch (RemoteException | RuntimeException ex) {
                            Slog.e(ManagedApplicationService.this.TAG, "Received exception from user service: ", ex);
                        }
                    }
                }

                @Override
                public void onServiceDisconnected(ComponentName componentName) {
                    Slog.w(ManagedApplicationService.this.TAG, "Service disconnected: " + intent);
                    ManagedApplicationService.this.mConnection = null;
                    ManagedApplicationService.this.mBoundInterface = null;
                }
            };
            try {
                if (!this.mContext.bindServiceAsUser(intent, serviceConnection, 0x4000001, new UserHandle(this.mUserId))) {
                    Slog.w(this.TAG, "Unable to bind service: " + intent);
                }
            }
            catch (SecurityException e) {
                Slog.w(this.TAG, "Unable to bind service: " + intent, e);
            }
        }
    }

    private boolean matches(ComponentName component, int userId) {
        return Objects.equals(this.mComponent, component) && this.mUserId == userId;
    }

    public static interface PendingEvent {
        public void runEvent(IInterface var1) throws RemoteException;
    }

    public static interface BinderChecker {
        public IInterface asInterface(IBinder var1);

        public boolean checkType(IInterface var1);
    }
}

