/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.printservice.IPrintService;
import android.printservice.IPrintServiceClient;
import android.util.Slog;
import com.android.server.print.RemotePrintSpooler;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

final class RemotePrintService
implements IBinder.DeathRecipient {
    private static final String LOG_TAG = "RemotePrintService";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final ComponentName mComponentName;
    private final Intent mIntent;
    private final RemotePrintSpooler mSpooler;
    private final PrintServiceCallbacks mCallbacks;
    private final int mUserId;
    private final List<Runnable> mPendingCommands = new ArrayList<Runnable>();
    private final ServiceConnection mServiceConnection = new RemoteServiceConneciton();
    private final RemotePrintServiceClient mPrintServiceClient;
    private final Handler mHandler;
    private IPrintService mPrintService;
    private boolean mBinding;
    private boolean mDestroyed;
    private boolean mHasActivePrintJobs;
    private boolean mHasPrinterDiscoverySession;
    private boolean mServiceDied;
    private List<PrinterId> mDiscoveryPriorityList;
    private List<PrinterId> mTrackedPrinterList;

    public RemotePrintService(Context context, ComponentName componentName, int userId, RemotePrintSpooler spooler, PrintServiceCallbacks callbacks) {
        this.mContext = context;
        this.mCallbacks = callbacks;
        this.mComponentName = componentName;
        this.mIntent = new Intent().setComponent(this.mComponentName);
        this.mUserId = userId;
        this.mSpooler = spooler;
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mPrintServiceClient = new RemotePrintServiceClient(this);
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public void destroy() {
        this.mHandler.sendEmptyMessage(11);
    }

    private void handleDestroy() {
        this.stopTrackingAllPrinters();
        if (this.mDiscoveryPriorityList != null) {
            this.handleStopPrinterDiscovery();
        }
        if (this.mHasPrinterDiscoverySession) {
            this.handleDestroyPrinterDiscoverySession();
        }
        this.ensureUnbound();
        this.mDestroyed = true;
    }

    @Override
    public void binderDied() {
        this.mHandler.sendEmptyMessage(12);
    }

    private void handleBinderDied() {
        if (this.mPrintService != null) {
            this.mPrintService.asBinder().unlinkToDeath(this, 0);
        }
        this.mPrintService = null;
        this.mServiceDied = true;
        this.mCallbacks.onServiceDied(this);
    }

    public void onAllPrintJobsHandled() {
        this.mHandler.sendEmptyMessage(8);
    }

    private void handleOnAllPrintJobsHandled() {
        this.mHasActivePrintJobs = false;
        if (!this.isBound()) {
            if (this.mServiceDied && !this.mHasPrinterDiscoverySession) {
                this.ensureUnbound();
                return;
            }
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleOnAllPrintJobsHandled();
                }
            });
        } else if (!this.mHasPrinterDiscoverySession) {
            this.ensureUnbound();
        }
    }

    public void onRequestCancelPrintJob(PrintJobInfo printJob) {
        this.mHandler.obtainMessage(9, printJob).sendToTarget();
    }

    private void handleRequestCancelPrintJob(final PrintJobInfo printJob) {
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleRequestCancelPrintJob(printJob);
                }
            });
        } else {
            try {
                this.mPrintService.requestCancelPrintJob(printJob);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error canceling a pring job.", re);
            }
        }
    }

    public void onPrintJobQueued(PrintJobInfo printJob) {
        this.mHandler.obtainMessage(10, printJob).sendToTarget();
    }

    private void handleOnPrintJobQueued(final PrintJobInfo printJob) {
        this.mHasActivePrintJobs = true;
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleOnPrintJobQueued(printJob);
                }
            });
        } else {
            try {
                this.mPrintService.onPrintJobQueued(printJob);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error announcing queued pring job.", re);
            }
        }
    }

    public void createPrinterDiscoverySession() {
        this.mHandler.sendEmptyMessage(1);
    }

    private void handleCreatePrinterDiscoverySession() {
        this.mHasPrinterDiscoverySession = true;
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleCreatePrinterDiscoverySession();
                }
            });
        } else {
            try {
                this.mPrintService.createPrinterDiscoverySession();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error creating printer discovery session.", re);
            }
        }
    }

    public void destroyPrinterDiscoverySession() {
        this.mHandler.sendEmptyMessage(2);
    }

    private void handleDestroyPrinterDiscoverySession() {
        this.mHasPrinterDiscoverySession = false;
        if (!this.isBound()) {
            if (this.mServiceDied && !this.mHasActivePrintJobs) {
                this.ensureUnbound();
                return;
            }
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleDestroyPrinterDiscoverySession();
                }
            });
        } else {
            try {
                this.mPrintService.destroyPrinterDiscoverySession();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error destroying printer dicovery session.", re);
            }
            if (!this.mHasActivePrintJobs) {
                this.ensureUnbound();
            }
        }
    }

    public void startPrinterDiscovery(List<PrinterId> priorityList) {
        this.mHandler.obtainMessage(3, priorityList).sendToTarget();
    }

    private void handleStartPrinterDiscovery(final List<PrinterId> priorityList) {
        this.mDiscoveryPriorityList = new ArrayList<PrinterId>();
        if (priorityList != null) {
            this.mDiscoveryPriorityList.addAll(priorityList);
        }
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleStartPrinterDiscovery(priorityList);
                }
            });
        } else {
            try {
                this.mPrintService.startPrinterDiscovery(priorityList);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error starting printer dicovery.", re);
            }
        }
    }

    public void stopPrinterDiscovery() {
        this.mHandler.sendEmptyMessage(4);
    }

    private void handleStopPrinterDiscovery() {
        this.mDiscoveryPriorityList = null;
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleStopPrinterDiscovery();
                }
            });
        } else {
            this.stopTrackingAllPrinters();
            try {
                this.mPrintService.stopPrinterDiscovery();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error stopping printer discovery.", re);
            }
        }
    }

    public void validatePrinters(List<PrinterId> printerIds) {
        this.mHandler.obtainMessage(5, printerIds).sendToTarget();
    }

    private void handleValidatePrinters(final List<PrinterId> printerIds) {
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleValidatePrinters(printerIds);
                }
            });
        } else {
            try {
                this.mPrintService.validatePrinters(printerIds);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error requesting printers validation.", re);
            }
        }
    }

    public void startPrinterStateTracking(PrinterId printerId) {
        this.mHandler.obtainMessage(6, printerId).sendToTarget();
    }

    public void requestCustomPrinterIcon(PrinterId printerId) {
        this.mHandler.obtainMessage(13, printerId).sendToTarget();
    }

    private void handleRequestCustomPrinterIcon(PrinterId printerId) {
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(() -> this.handleRequestCustomPrinterIcon(printerId));
        } else {
            try {
                this.mPrintService.requestCustomPrinterIcon(printerId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error requesting icon for " + printerId, re);
            }
        }
    }

    private void handleStartPrinterStateTracking(final PrinterId printerId) {
        if (this.mTrackedPrinterList == null) {
            this.mTrackedPrinterList = new ArrayList<PrinterId>();
        }
        this.mTrackedPrinterList.add(printerId);
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleStartPrinterStateTracking(printerId);
                }
            });
        } else {
            try {
                this.mPrintService.startPrinterStateTracking(printerId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error requesting start printer tracking.", re);
            }
        }
    }

    public void stopPrinterStateTracking(PrinterId printerId) {
        this.mHandler.obtainMessage(7, printerId).sendToTarget();
    }

    private void handleStopPrinterStateTracking(final PrinterId printerId) {
        if (this.mTrackedPrinterList == null || !this.mTrackedPrinterList.remove(printerId)) {
            return;
        }
        if (this.mTrackedPrinterList.isEmpty()) {
            this.mTrackedPrinterList = null;
        }
        if (!this.isBound()) {
            this.ensureBound();
            this.mPendingCommands.add(new Runnable(){

                @Override
                public void run() {
                    RemotePrintService.this.handleStopPrinterStateTracking(printerId);
                }
            });
        } else {
            try {
                this.mPrintService.stopPrinterStateTracking(printerId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error requesting stop printer tracking.", re);
            }
        }
    }

    private void stopTrackingAllPrinters() {
        if (this.mTrackedPrinterList == null) {
            return;
        }
        int trackedPrinterCount = this.mTrackedPrinterList.size();
        for (int i = trackedPrinterCount - 1; i >= 0; --i) {
            PrinterId printerId = this.mTrackedPrinterList.get(i);
            if (!printerId.getServiceName().equals(this.mComponentName)) continue;
            this.handleStopPrinterStateTracking(printerId);
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        String tab = "  ";
        pw.append(prefix).append("service:").println();
        pw.append(prefix).append(tab).append("componentName=").append(this.mComponentName.flattenToString()).println();
        pw.append(prefix).append(tab).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
        pw.append(prefix).append(tab).append("bound=").append(String.valueOf(this.isBound())).println();
        pw.append(prefix).append(tab).append("hasDicoverySession=").append(String.valueOf(this.mHasPrinterDiscoverySession)).println();
        pw.append(prefix).append(tab).append("hasActivePrintJobs=").append(String.valueOf(this.mHasActivePrintJobs)).println();
        pw.append(prefix).append(tab).append("isDiscoveringPrinters=").append(String.valueOf(this.mDiscoveryPriorityList != null)).println();
        pw.append(prefix).append(tab).append("trackedPrinters=").append(this.mTrackedPrinterList != null ? this.mTrackedPrinterList.toString() : "null");
    }

    private boolean isBound() {
        return this.mPrintService != null;
    }

    private void ensureBound() {
        if (this.isBound() || this.mBinding) {
            return;
        }
        this.mBinding = true;
        boolean wasBound = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 0x4000001, new UserHandle(this.mUserId));
        if (!wasBound) {
            this.mBinding = false;
            if (!this.mServiceDied) {
                this.handleBinderDied();
            }
        }
    }

    private void ensureUnbound() {
        if (!this.isBound() && !this.mBinding) {
            return;
        }
        this.mBinding = false;
        this.mPendingCommands.clear();
        this.mHasActivePrintJobs = false;
        this.mHasPrinterDiscoverySession = false;
        this.mDiscoveryPriorityList = null;
        this.mTrackedPrinterList = null;
        if (this.isBound()) {
            try {
                this.mPrintService.setClient(null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mPrintService.asBinder().unlinkToDeath(this, 0);
            this.mPrintService = null;
            this.mContext.unbindService(this.mServiceConnection);
        }
    }

    private static final class RemotePrintServiceClient
    extends IPrintServiceClient.Stub {
        private final WeakReference<RemotePrintService> mWeakService;

        public RemotePrintServiceClient(RemotePrintService service) {
            this.mWeakService = new WeakReference<RemotePrintService>(service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PrintJobInfo> getPrintJobInfos() {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    List<PrintJobInfo> list = service.mSpooler.getPrintJobInfos(service.mComponentName, -4, -2);
                    return list;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintJobInfo getPrintJobInfo(PrintJobId printJobId) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    PrintJobInfo printJobInfo = service.mSpooler.getPrintJobInfo(printJobId, -2);
                    return printJobInfo;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPrintJobState(PrintJobId printJobId, int state, String error) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    boolean bl = service.mSpooler.setPrintJobState(printJobId, state, error);
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPrintJobTag(PrintJobId printJobId, String tag) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    boolean bl = service.mSpooler.setPrintJobTag(printJobId, tag);
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writePrintJobData(ParcelFileDescriptor fd, PrintJobId printJobId) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mSpooler.writePrintJobData(fd, printJobId);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProgress(PrintJobId printJobId, float progress) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mSpooler.setProgress(printJobId, progress);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStatus(PrintJobId printJobId, CharSequence status) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mSpooler.setStatus(printJobId, status);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStatusRes(PrintJobId printJobId, int status, CharSequence appPackageName) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mSpooler.setStatus(printJobId, status, appPackageName);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrintersAdded(ParceledListSlice printers) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                List addedPrinters = printers.getList();
                this.throwIfPrinterIdsForPrinterInfoTampered(service.mComponentName, addedPrinters);
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mCallbacks.onPrintersAdded(addedPrinters);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrintersRemoved(ParceledListSlice printerIds) {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                List removedPrinterIds = printerIds.getList();
                this.throwIfPrinterIdsTampered(service.mComponentName, removedPrinterIds);
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mCallbacks.onPrintersRemoved(removedPrinterIds);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        private void throwIfPrinterIdsForPrinterInfoTampered(ComponentName serviceName, List<PrinterInfo> printerInfos) {
            int printerInfoCount = printerInfos.size();
            for (int i = 0; i < printerInfoCount; ++i) {
                PrinterId printerId = printerInfos.get(i).getId();
                this.throwIfPrinterIdTampered(serviceName, printerId);
            }
        }

        private void throwIfPrinterIdsTampered(ComponentName serviceName, List<PrinterId> printerIds) {
            int printerIdCount = printerIds.size();
            for (int i = 0; i < printerIdCount; ++i) {
                PrinterId printerId = printerIds.get(i);
                this.throwIfPrinterIdTampered(serviceName, printerId);
            }
        }

        private void throwIfPrinterIdTampered(ComponentName serviceName, PrinterId printerId) {
            if (printerId == null || !printerId.getServiceName().equals(serviceName)) {
                throw new IllegalArgumentException("Invalid printer id: " + printerId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCustomPrinterIconLoaded(PrinterId printerId, Icon icon) throws RemoteException {
            RemotePrintService service = (RemotePrintService)this.mWeakService.get();
            if (service != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    service.mCallbacks.onCustomPrinterIconLoaded(printerId, icon);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_CREATE_PRINTER_DISCOVERY_SESSION = 1;
        public static final int MSG_DESTROY_PRINTER_DISCOVERY_SESSION = 2;
        public static final int MSG_START_PRINTER_DISCOVERY = 3;
        public static final int MSG_STOP_PRINTER_DISCOVERY = 4;
        public static final int MSG_VALIDATE_PRINTERS = 5;
        public static final int MSG_START_PRINTER_STATE_TRACKING = 6;
        public static final int MSG_STOP_PRINTER_STATE_TRACKING = 7;
        public static final int MSG_ON_ALL_PRINT_JOBS_HANDLED = 8;
        public static final int MSG_ON_REQUEST_CANCEL_PRINT_JOB = 9;
        public static final int MSG_ON_PRINT_JOB_QUEUED = 10;
        public static final int MSG_DESTROY = 11;
        public static final int MSG_BINDER_DIED = 12;
        public static final int MSG_REQUEST_CUSTOM_PRINTER_ICON = 13;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message message) {
            if (RemotePrintService.this.mDestroyed) {
                Slog.w(RemotePrintService.LOG_TAG, "Not handling " + message + " as service for " + RemotePrintService.this.mComponentName + " is already destroyed");
                return;
            }
            switch (message.what) {
                case 1: {
                    RemotePrintService.this.handleCreatePrinterDiscoverySession();
                    break;
                }
                case 2: {
                    RemotePrintService.this.handleDestroyPrinterDiscoverySession();
                    break;
                }
                case 3: {
                    ArrayList priorityList = (ArrayList)message.obj;
                    RemotePrintService.this.handleStartPrinterDiscovery(priorityList);
                    break;
                }
                case 4: {
                    RemotePrintService.this.handleStopPrinterDiscovery();
                    break;
                }
                case 5: {
                    List printerIds = (List)message.obj;
                    RemotePrintService.this.handleValidatePrinters(printerIds);
                    break;
                }
                case 6: {
                    PrinterId printerId = (PrinterId)message.obj;
                    RemotePrintService.this.handleStartPrinterStateTracking(printerId);
                    break;
                }
                case 7: {
                    PrinterId printerId = (PrinterId)message.obj;
                    RemotePrintService.this.handleStopPrinterStateTracking(printerId);
                    break;
                }
                case 8: {
                    RemotePrintService.this.handleOnAllPrintJobsHandled();
                    break;
                }
                case 9: {
                    PrintJobInfo printJob = (PrintJobInfo)message.obj;
                    RemotePrintService.this.handleRequestCancelPrintJob(printJob);
                    break;
                }
                case 10: {
                    PrintJobInfo printJob = (PrintJobInfo)message.obj;
                    RemotePrintService.this.handleOnPrintJobQueued(printJob);
                    break;
                }
                case 11: {
                    RemotePrintService.this.handleDestroy();
                    break;
                }
                case 12: {
                    RemotePrintService.this.handleBinderDied();
                    break;
                }
                case 13: {
                    PrinterId printerId = (PrinterId)message.obj;
                    RemotePrintService.this.handleRequestCustomPrinterIcon(printerId);
                }
            }
        }
    }

    private class RemoteServiceConneciton
    implements ServiceConnection {
        private RemoteServiceConneciton() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (RemotePrintService.this.mDestroyed || !RemotePrintService.this.mBinding) {
                RemotePrintService.this.mContext.unbindService(RemotePrintService.this.mServiceConnection);
                return;
            }
            RemotePrintService.this.mBinding = false;
            RemotePrintService.this.mPrintService = IPrintService.Stub.asInterface(service);
            try {
                service.linkToDeath(RemotePrintService.this, 0);
            }
            catch (RemoteException re) {
                RemotePrintService.this.handleBinderDied();
                return;
            }
            try {
                RemotePrintService.this.mPrintService.setClient(RemotePrintService.this.mPrintServiceClient);
            }
            catch (RemoteException re) {
                Slog.e(RemotePrintService.LOG_TAG, "Error setting client for: " + service, re);
                RemotePrintService.this.handleBinderDied();
                return;
            }
            if (RemotePrintService.this.mServiceDied && RemotePrintService.this.mHasPrinterDiscoverySession) {
                RemotePrintService.this.handleCreatePrinterDiscoverySession();
            }
            if (RemotePrintService.this.mServiceDied && RemotePrintService.this.mDiscoveryPriorityList != null) {
                RemotePrintService.this.handleStartPrinterDiscovery(RemotePrintService.this.mDiscoveryPriorityList);
            }
            if (RemotePrintService.this.mServiceDied && RemotePrintService.this.mTrackedPrinterList != null) {
                int trackedPrinterCount = RemotePrintService.this.mTrackedPrinterList.size();
                for (int i = 0; i < trackedPrinterCount; ++i) {
                    RemotePrintService.this.handleStartPrinterStateTracking((PrinterId)RemotePrintService.this.mTrackedPrinterList.get(i));
                }
            }
            while (!RemotePrintService.this.mPendingCommands.isEmpty()) {
                Runnable pendingCommand = (Runnable)RemotePrintService.this.mPendingCommands.remove(0);
                pendingCommand.run();
            }
            if (!RemotePrintService.this.mHasPrinterDiscoverySession && !RemotePrintService.this.mHasActivePrintJobs) {
                RemotePrintService.this.ensureUnbound();
            }
            RemotePrintService.this.mServiceDied = false;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            RemotePrintService.this.mBinding = true;
        }
    }

    public static interface PrintServiceCallbacks {
        public void onPrintersAdded(List<PrinterInfo> var1);

        public void onPrintersRemoved(List<PrinterId> var1);

        public void onServiceDied(RemotePrintService var1);

        public void onCustomPrinterIconLoaded(PrinterId var1, Icon var2);
    }
}

