/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.IUiModeManager;
import android.app.ProgressDialog;
import android.app.SearchManager;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.input.InputManager;
import android.hardware.input.InputManagerInternal;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Binder;
import android.os.Bundle;
import android.os.FactoryTest;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.DreamManagerInternal;
import android.service.dreams.IDreamManager;
import android.service.vr.IPersistentVrStateCallbacks;
import android.telecom.TelecomManager;
import android.util.EventLog;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.MutableBoolean;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IApplicationToken;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.autofill.AutofillManagerInternal;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.R;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.ScreenShapeHelper;
import com.android.internal.widget.PointerLocationView;
import com.android.server.GestureLauncherService;
import com.android.server.LocalServices;
import com.android.server.SystemServiceManager;
import com.android.server.policy.AccessibilityShortcutController;
import com.android.server.policy.BarController;
import com.android.server.policy.BurnInProtectionHelper;
import com.android.server.policy.GlobalActions;
import com.android.server.policy.GlobalKeyManager;
import com.android.server.policy.ImmersiveModeConfirmation;
import com.android.server.policy.LogDecelerateInterpolator;
import com.android.server.policy.PolicyControl;
import com.android.server.policy.ShortcutManager;
import com.android.server.policy.SplashScreenSurface;
import com.android.server.policy.StatusBarController;
import com.android.server.policy.SystemGesturesPointerEventListener;
import com.android.server.policy.WakeGestureListener;
import com.android.server.policy.WindowOrientationListener;
import com.android.server.policy.keyguard.KeyguardServiceDelegate;
import com.android.server.policy.keyguard.KeyguardStateMonitor;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.vr.VrManagerInternal;
import com.android.server.wm.AppTransition;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class PhoneWindowManager
implements WindowManagerPolicy {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_KEYGUARD = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_SPLASH_SCREEN = false;
    static final boolean DEBUG_WAKEUP = false;
    static final boolean SHOW_SPLASH_SCREENS = true;
    static final boolean ENABLE_DESK_DOCK_HOME_CAPTURE = false;
    static final boolean ENABLE_VR_HEADSET_HOME_CAPTURE = true;
    static final boolean ALTERNATE_CAR_MODE_NAV_SIZE = false;
    static final int SHORT_PRESS_POWER_NOTHING = 0;
    static final int SHORT_PRESS_POWER_GO_TO_SLEEP = 1;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP = 2;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP_AND_GO_HOME = 3;
    static final int SHORT_PRESS_POWER_GO_HOME = 4;
    static final int SHORT_PRESS_POWER_CLOSE_IME_OR_GO_HOME = 5;
    static final int LONG_PRESS_POWER_NOTHING = 0;
    static final int LONG_PRESS_POWER_GLOBAL_ACTIONS = 1;
    static final int LONG_PRESS_POWER_SHUT_OFF = 2;
    static final int LONG_PRESS_POWER_SHUT_OFF_NO_CONFIRM = 3;
    static final int LONG_PRESS_BACK_NOTHING = 0;
    static final int LONG_PRESS_BACK_GO_TO_VOICE_ASSIST = 1;
    static final int MULTI_PRESS_POWER_NOTHING = 0;
    static final int MULTI_PRESS_POWER_THEATER_MODE = 1;
    static final int MULTI_PRESS_POWER_BRIGHTNESS_BOOST = 2;
    static final int PANIC_PRESS_BACK_COUNT = 4;
    static final int PANIC_PRESS_BACK_NOTHING = 0;
    static final int PANIC_PRESS_BACK_HOME = 1;
    static final int LONG_PRESS_HOME_NOTHING = 0;
    static final int LONG_PRESS_HOME_ALL_APPS = 1;
    static final int LONG_PRESS_HOME_ASSIST = 2;
    static final int LAST_LONG_PRESS_HOME_BEHAVIOR = 2;
    static final int DOUBLE_TAP_HOME_NOTHING = 0;
    static final int DOUBLE_TAP_HOME_RECENT_SYSTEM_UI = 1;
    static final int SHORT_PRESS_WINDOW_NOTHING = 0;
    static final int SHORT_PRESS_WINDOW_PICTURE_IN_PICTURE = 1;
    static final int SHORT_PRESS_SLEEP_GO_TO_SLEEP = 0;
    static final int SHORT_PRESS_SLEEP_GO_TO_SLEEP_AND_GO_HOME = 1;
    static final int PENDING_KEY_NULL = -1;
    static final int NAV_BAR_OPAQUE_WHEN_FREEFORM_OR_DOCKED = 0;
    static final int NAV_BAR_TRANSLUCENT_WHEN_FREEFORM_OPAQUE_OTHERWISE = 1;
    public static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    public static final String SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS = "globalactions";
    public static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
    public static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    public static final String SYSTEM_DIALOG_REASON_ASSIST = "assist";
    static final int SYSTEM_UI_CHANGING_LAYOUT = -1073709042;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private static final long PANIC_GESTURE_EXPIRATION = 30000L;
    private static final String SYSUI_PACKAGE = "com.android.systemui";
    private static final String SYSUI_SCREENSHOT_SERVICE = "com.android.systemui.screenshot.TakeScreenshotService";
    private static final String SYSUI_SCREENSHOT_ERROR_RECEIVER = "com.android.systemui.screenshot.ScreenshotServiceErrorReceiver";
    private static final int NAV_BAR_BOTTOM = 0;
    private static final int NAV_BAR_RIGHT = 1;
    private static final int NAV_BAR_LEFT = 2;
    private boolean mKeyguardDrawnOnce;
    static SparseArray<String> sApplicationLaunchKeyCategories = new SparseArray();
    static final int WAITING_FOR_DRAWN_TIMEOUT = 1000;
    public static final int TOAST_WINDOW_TIMEOUT = 3500;
    private final Object mLock = new Object();
    Context mContext;
    IWindowManager mWindowManager;
    WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    WindowManagerInternal mWindowManagerInternal;
    PowerManager mPowerManager;
    ActivityManagerInternal mActivityManagerInternal;
    AutofillManagerInternal mAutofillManagerInternal;
    InputManagerInternal mInputManagerInternal;
    InputMethodManagerInternal mInputMethodManagerInternal;
    DreamManagerInternal mDreamManagerInternal;
    PowerManagerInternal mPowerManagerInternal;
    IStatusBarService mStatusBarService;
    StatusBarManagerInternal mStatusBarManagerInternal;
    boolean mPreloadedRecentApps;
    final Object mServiceAquireLock = new Object();
    Vibrator mVibrator;
    SearchManager mSearchManager;
    AccessibilityManager mAccessibilityManager;
    BurnInProtectionHelper mBurnInProtectionHelper;
    AppOpsManager mAppOpsManager;
    private boolean mHasFeatureWatch;
    private boolean mHasFeatureLeanback;
    volatile VrManagerInternal mVrManagerInternal;
    long[] mLongPressVibePattern;
    long[] mVirtualKeyVibePattern;
    long[] mKeyboardTapVibePattern;
    long[] mClockTickVibePattern;
    long[] mCalendarDateVibePattern;
    long[] mSafeModeDisabledVibePattern;
    long[] mSafeModeEnabledVibePattern;
    long[] mContextClickVibePattern;
    boolean mEnableShiftMenuBugReports = false;
    private AccessibilityShortcutController mAccessibilityShortcutController;
    boolean mSafeMode;
    WindowManagerPolicy.WindowState mStatusBar = null;
    int mStatusBarHeight;
    WindowManagerPolicy.WindowState mNavigationBar = null;
    boolean mHasNavigationBar = false;
    boolean mNavigationBarCanMove = false;
    int mNavigationBarPosition = 0;
    int[] mNavigationBarHeightForRotationDefault = new int[4];
    int[] mNavigationBarWidthForRotationDefault = new int[4];
    int[] mNavigationBarHeightForRotationInCarMode = new int[4];
    int[] mNavigationBarWidthForRotationInCarMode = new int[4];
    private LongSparseArray<IShortcutService> mShortcutKeyServices = new LongSparseArray();
    private boolean mEnableCarDockHomeCapture = true;
    boolean mBootMessageNeedsHiding;
    KeyguardServiceDelegate mKeyguardDelegate;
    private boolean mKeyguardBound;
    final Runnable mWindowManagerDrawCallback = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(7);
        }
    };
    final KeyguardServiceDelegate.DrawnListener mKeyguardDrawnCallback = new KeyguardServiceDelegate.DrawnListener(){

        @Override
        public void onDrawn() {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(5);
        }
    };
    GlobalActions mGlobalActions;
    Handler mHandler;
    WindowManagerPolicy.WindowState mLastInputMethodWindow = null;
    WindowManagerPolicy.WindowState mLastInputMethodTargetWindow = null;
    volatile boolean mPowerKeyHandled;
    volatile boolean mBackKeyHandled;
    volatile boolean mBeganFromNonInteractive;
    volatile int mPowerKeyPressCounter;
    volatile int mBackKeyPressCounter;
    volatile boolean mEndCallKeyHandled;
    volatile boolean mCameraGestureTriggeredDuringGoingToSleep;
    volatile boolean mGoingToSleep;
    volatile boolean mRecentsVisible;
    volatile boolean mPictureInPictureVisible;
    private volatile boolean mPersistentVrModeEnabled;
    private volatile boolean mDismissImeOnBackKeyPressed;
    volatile int mPendingWakeKey = -1;
    int mRecentAppsHeldModifiers;
    boolean mLanguageSwitchKeyPressed;
    int mLidState = -1;
    int mCameraLensCoverState = -1;
    boolean mHaveBuiltInKeyboard;
    boolean mSystemReady;
    boolean mSystemBooted;
    boolean mHdmiPlugged;
    HdmiControl mHdmiControl;
    IUiModeManager mUiModeManager;
    int mUiMode;
    int mDockMode = 0;
    int mLidOpenRotation;
    int mCarDockRotation;
    int mDeskDockRotation;
    int mUndockedHdmiRotation;
    int mDemoHdmiRotation;
    boolean mDemoHdmiRotationLock;
    int mDemoRotation;
    boolean mDemoRotationLock;
    boolean mWakeGestureEnabledSetting;
    MyWakeGestureListener mWakeGestureListener;
    private boolean mForceDefaultOrientation = false;
    int mUserRotationMode = 0;
    int mUserRotation = 0;
    boolean mAccelerometerDefault;
    boolean mSupportAutoRotation;
    int mAllowAllRotations = -1;
    boolean mCarDockEnablesAccelerometer;
    boolean mDeskDockEnablesAccelerometer;
    int mLidKeyboardAccessibility;
    int mLidNavigationAccessibility;
    boolean mLidControlsScreenLock;
    boolean mLidControlsSleep;
    int mShortPressOnPowerBehavior;
    int mLongPressOnPowerBehavior;
    int mDoublePressOnPowerBehavior;
    int mTriplePressOnPowerBehavior;
    int mLongPressOnBackBehavior;
    int mPanicPressOnBackBehavior;
    int mShortPressOnSleepBehavior;
    int mShortPressWindowBehavior;
    boolean mAwake;
    boolean mScreenOnEarly;
    boolean mScreenOnFully;
    WindowManagerPolicy.ScreenOnListener mScreenOnListener;
    boolean mKeyguardDrawComplete;
    boolean mWindowManagerDrawComplete;
    boolean mOrientationSensorEnabled = false;
    int mCurrentAppOrientation = -1;
    boolean mHasSoftInput = false;
    boolean mTranslucentDecorEnabled = true;
    boolean mUseTvRouting;
    private boolean mHandleVolumeKeysInWM;
    int mPointerLocationMode = 0;
    WindowManagerPolicy.WindowState mFocusedWindow;
    IApplicationToken mFocusedApp;
    PointerLocationView mPointerLocationView;
    int mOverscanScreenLeft;
    int mOverscanScreenTop;
    int mOverscanScreenWidth;
    int mOverscanScreenHeight;
    int mUnrestrictedScreenLeft;
    int mUnrestrictedScreenTop;
    int mUnrestrictedScreenWidth;
    int mUnrestrictedScreenHeight;
    int mRestrictedOverscanScreenLeft;
    int mRestrictedOverscanScreenTop;
    int mRestrictedOverscanScreenWidth;
    int mRestrictedOverscanScreenHeight;
    int mRestrictedScreenLeft;
    int mRestrictedScreenTop;
    int mRestrictedScreenWidth;
    int mRestrictedScreenHeight;
    int mSystemLeft;
    int mSystemTop;
    int mSystemRight;
    int mSystemBottom;
    int mStableLeft;
    int mStableTop;
    int mStableRight;
    int mStableBottom;
    int mStableFullscreenLeft;
    int mStableFullscreenTop;
    int mStableFullscreenRight;
    int mStableFullscreenBottom;
    int mCurLeft;
    int mCurTop;
    int mCurRight;
    int mCurBottom;
    int mContentLeft;
    int mContentTop;
    int mContentRight;
    int mContentBottom;
    int mVoiceContentLeft;
    int mVoiceContentTop;
    int mVoiceContentRight;
    int mVoiceContentBottom;
    int mDockLeft;
    int mDockTop;
    int mDockRight;
    int mDockBottom;
    int mDockLayer;
    int mStatusBarLayer;
    int mLastSystemUiFlags;
    int mResettingSystemUiFlags = 0;
    int mForceClearedSystemUiFlags = 0;
    int mLastFullscreenStackSysUiFlags;
    int mLastDockedStackSysUiFlags;
    final Rect mNonDockedStackBounds = new Rect();
    final Rect mDockedStackBounds = new Rect();
    final Rect mLastNonDockedStackBounds = new Rect();
    final Rect mLastDockedStackBounds = new Rect();
    boolean mLastFocusNeedsMenu = false;
    private long mPendingPanicGestureUptime;
    WindowManagerPolicy.InputConsumer mInputConsumer = null;
    static final Rect mTmpParentFrame;
    static final Rect mTmpDisplayFrame;
    static final Rect mTmpOverscanFrame;
    static final Rect mTmpContentFrame;
    static final Rect mTmpVisibleFrame;
    static final Rect mTmpDecorFrame;
    static final Rect mTmpStableFrame;
    static final Rect mTmpNavigationFrame;
    static final Rect mTmpOutsetFrame;
    private static final Rect mTmpRect;
    WindowManagerPolicy.WindowState mTopFullscreenOpaqueWindowState;
    WindowManagerPolicy.WindowState mTopFullscreenOpaqueOrDimmingWindowState;
    WindowManagerPolicy.WindowState mTopDockedOpaqueWindowState;
    WindowManagerPolicy.WindowState mTopDockedOpaqueOrDimmingWindowState;
    boolean mTopIsFullscreen;
    boolean mForceStatusBar;
    boolean mForceStatusBarFromKeyguard;
    private boolean mForceStatusBarTransparent;
    int mNavBarOpacityMode = 0;
    boolean mForcingShowNavBar;
    int mForcingShowNavBarLayer;
    private boolean mPendingKeyguardOccluded;
    private boolean mKeyguardOccludedChanged;
    boolean mShowingDream;
    private boolean mLastShowingDream;
    boolean mDreamingLockscreen;
    boolean mDreamingSleepTokenNeeded;
    ActivityManagerInternal.SleepToken mDreamingSleepToken;
    ActivityManagerInternal.SleepToken mScreenOffSleepToken;
    volatile boolean mKeyguardOccluded;
    boolean mHomePressed;
    boolean mHomeConsumed;
    boolean mHomeDoubleTapPending;
    Intent mHomeIntent;
    Intent mCarDockIntent;
    Intent mDeskDockIntent;
    Intent mVrHeadsetHomeIntent;
    boolean mSearchKeyShortcutPending;
    boolean mConsumeSearchKeyUp;
    boolean mAssistKeyLongPressed;
    boolean mPendingMetaAction;
    boolean mPendingCapsLockToggle;
    int mMetaState;
    int mInitialMetaState;
    boolean mForceShowSystemBars;
    boolean mAllowLockscreenWhenOn;
    int mLockScreenTimeout;
    boolean mLockScreenTimerActive;
    int mEndcallBehavior;
    int mIncallPowerBehavior;
    int mIncallBackBehavior;
    Display mDisplay;
    private int mDisplayRotation;
    int mLandscapeRotation = 0;
    int mSeascapeRotation = 0;
    int mPortraitRotation = 0;
    int mUpsideDownRotation = 0;
    int mOverscanLeft = 0;
    int mOverscanTop = 0;
    int mOverscanRight = 0;
    int mOverscanBottom = 0;
    private int mLongPressOnHomeBehavior;
    private int mDoubleTapOnHomeBehavior;
    private boolean mAllowTheaterModeWakeFromKey;
    private boolean mAllowTheaterModeWakeFromPowerKey;
    private boolean mAllowTheaterModeWakeFromMotion;
    private boolean mAllowTheaterModeWakeFromMotionWhenNotDreaming;
    private boolean mAllowTheaterModeWakeFromCameraLens;
    private boolean mAllowTheaterModeWakeFromLidSwitch;
    private boolean mAllowTheaterModeWakeFromWakeGesture;
    private boolean mSupportLongPressPowerWhenNonInteractive;
    private boolean mGoToSleepOnButtonPressTheaterMode;
    private static final long SCREENSHOT_CHORD_DEBOUNCE_DELAY_MILLIS = 150L;
    private static final float KEYGUARD_SCREENSHOT_CHORD_DELAY_MULTIPLIER = 2.5f;
    private boolean mScreenshotChordEnabled;
    private boolean mScreenshotChordVolumeDownKeyTriggered;
    private long mScreenshotChordVolumeDownKeyTime;
    private boolean mScreenshotChordVolumeDownKeyConsumed;
    private boolean mA11yShortcutChordVolumeUpKeyTriggered;
    private long mA11yShortcutChordVolumeUpKeyTime;
    private boolean mA11yShortcutChordVolumeUpKeyConsumed;
    private boolean mScreenshotChordPowerKeyTriggered;
    private long mScreenshotChordPowerKeyTime;
    private static final long BUGREPORT_TV_GESTURE_TIMEOUT_MILLIS = 1000L;
    private boolean mBugreportTvKey1Pressed;
    private boolean mBugreportTvKey2Pressed;
    private boolean mBugreportTvScheduled;
    private boolean mAccessibilityTvKey1Pressed;
    private boolean mAccessibilityTvKey2Pressed;
    private boolean mAccessibilityTvScheduled;
    private static final int BRIGHTNESS_STEPS = 10;
    SettingsObserver mSettingsObserver;
    ShortcutManager mShortcutManager;
    PowerManager.WakeLock mBroadcastWakeLock;
    PowerManager.WakeLock mPowerKeyWakeLock;
    boolean mHavePendingMediaKeyRepeatWithWakeLock;
    private int mCurrentUserId;
    private GlobalKeyManager mGlobalKeyManager;
    private final SparseArray<KeyCharacterMap.FallbackAction> mFallbackActions = new SparseArray();
    private final LogDecelerateInterpolator mLogDecelerateInterpolator = new LogDecelerateInterpolator(100, 0);
    private final MutableBoolean mTmpBoolean = new MutableBoolean(false);
    private static final int MSG_ENABLE_POINTER_LOCATION = 1;
    private static final int MSG_DISABLE_POINTER_LOCATION = 2;
    private static final int MSG_DISPATCH_MEDIA_KEY_WITH_WAKE_LOCK = 3;
    private static final int MSG_DISPATCH_MEDIA_KEY_REPEAT_WITH_WAKE_LOCK = 4;
    private static final int MSG_KEYGUARD_DRAWN_COMPLETE = 5;
    private static final int MSG_KEYGUARD_DRAWN_TIMEOUT = 6;
    private static final int MSG_WINDOW_MANAGER_DRAWN_COMPLETE = 7;
    private static final int MSG_DISPATCH_SHOW_RECENTS = 9;
    private static final int MSG_DISPATCH_SHOW_GLOBAL_ACTIONS = 10;
    private static final int MSG_HIDE_BOOT_MESSAGE = 11;
    private static final int MSG_LAUNCH_VOICE_ASSIST_WITH_WAKE_LOCK = 12;
    private static final int MSG_POWER_DELAYED_PRESS = 13;
    private static final int MSG_POWER_LONG_PRESS = 14;
    private static final int MSG_UPDATE_DREAMING_SLEEP_TOKEN = 15;
    private static final int MSG_REQUEST_TRANSIENT_BARS = 16;
    private static final int MSG_SHOW_PICTURE_IN_PICTURE_MENU = 17;
    private static final int MSG_BACK_LONG_PRESS = 18;
    private static final int MSG_DISPOSE_INPUT_CONSUMER = 19;
    private static final int MSG_BACK_DELAYED_PRESS = 20;
    private static final int MSG_ACCESSIBILITY_SHORTCUT = 21;
    private static final int MSG_BUGREPORT_TV = 22;
    private static final int MSG_ACCESSIBILITY_TV = 23;
    private static final int MSG_DISPATCH_BACK_KEY_TO_AUTOFILL = 24;
    private static final int MSG_REQUEST_TRANSIENT_BARS_ARG_STATUS = 0;
    private static final int MSG_REQUEST_TRANSIENT_BARS_ARG_NAVIGATION = 1;
    private UEventObserver mHDMIObserver = new UEventObserver(){

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            PhoneWindowManager.this.setHdmiPlugged("1".equals(event.get("SWITCH_STATE")));
        }
    };
    MyOrientationListener mOrientationListener;
    final IPersistentVrStateCallbacks mPersistentVrModeListener = new IPersistentVrStateCallbacks.Stub(){

        @Override
        public void onPersistentVrStateChanged(boolean enabled) {
            PhoneWindowManager.this.mPersistentVrModeEnabled = enabled;
        }
    };
    private final StatusBarController mStatusBarController = new StatusBarController();
    private final BarController mNavigationBarController = new BarController("NavigationBar", 0x8000000, 0x20000000, Integer.MIN_VALUE, 2, 0x8000000, 32768);
    private final BarController.OnBarVisibilityChangedListener mNavBarVisibilityListener = new BarController.OnBarVisibilityChangedListener(){

        @Override
        public void onBarVisibilityChanged(boolean visible) {
            PhoneWindowManager.this.mAccessibilityManager.notifyAccessibilityButtonVisibilityChanged(visible);
        }
    };
    private ImmersiveModeConfirmation mImmersiveModeConfirmation;
    private SystemGesturesPointerEventListener mSystemGestures;
    private final Runnable mEndCallLongPress = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mEndCallKeyHandled = true;
            PhoneWindowManager.this.performHapticFeedbackLw(null, 0, false);
            PhoneWindowManager.this.showGlobalActionsInternal();
        }
    };
    private final ScreenshotRunnable mScreenshotRunnable = new ScreenshotRunnable();
    private final Runnable mHomeDoubleTapTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (PhoneWindowManager.this.mHomeDoubleTapPending) {
                PhoneWindowManager.this.mHomeDoubleTapPending = false;
                PhoneWindowManager.this.handleShortPressOnHome();
            }
        }
    };
    static final boolean PRINT_ANIM = false;
    private static final int[] WINDOW_TYPES_WHERE_HOME_DOESNT_WORK;
    private final Runnable mClearHideNavigationFlag = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
            synchronized (object) {
                PhoneWindowManager.this.mForceClearedSystemUiFlags &= 0xFFFFFFFD;
            }
            PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
        }
    };
    final Object mScreenshotLock = new Object();
    ServiceConnection mScreenshotConnection = null;
    final Runnable mScreenshotTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PhoneWindowManager.this.mScreenshotLock;
            synchronized (object) {
                if (PhoneWindowManager.this.mScreenshotConnection != null) {
                    PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                    PhoneWindowManager.this.mScreenshotConnection = null;
                    PhoneWindowManager.this.notifyScreenshotError();
                }
            }
        }
    };
    BroadcastReceiver mDockReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DOCK_EVENT".equals(intent.getAction())) {
                PhoneWindowManager.this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            } else {
                try {
                    IUiModeManager uiModeService = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
                    PhoneWindowManager.this.mUiMode = uiModeService.getCurrentModeType();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            PhoneWindowManager.this.updateRotation(true);
            Object object = PhoneWindowManager.this.mLock;
            synchronized (object) {
                PhoneWindowManager.this.updateOrientationListenerLp();
            }
        }
    };
    BroadcastReceiver mDreamReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DREAMING_STARTED".equals(intent.getAction())) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.onDreamingStarted();
                }
            } else if ("android.intent.action.DREAMING_STOPPED".equals(intent.getAction()) && PhoneWindowManager.this.mKeyguardDelegate != null) {
                PhoneWindowManager.this.mKeyguardDelegate.onDreamingStopped();
            }
        }
    };
    BroadcastReceiver mMultiuserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                PhoneWindowManager.this.mSettingsObserver.onChange(false);
                Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
                synchronized (object) {
                    PhoneWindowManager.this.mLastSystemUiFlags = 0;
                    PhoneWindowManager.this.updateSystemUiVisibilityLw();
                }
            }
        }
    };
    private final Runnable mHiddenNavPanic = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
            synchronized (object) {
                if (!PhoneWindowManager.this.isUserSetupComplete()) {
                    return;
                }
                PhoneWindowManager.this.mPendingPanicGestureUptime = SystemClock.uptimeMillis();
                if (!PhoneWindowManager.isNavBarEmpty(PhoneWindowManager.this.mLastSystemUiFlags)) {
                    PhoneWindowManager.this.mNavigationBarController.showTransient();
                }
            }
        }
    };
    ProgressDialog mBootMsgDialog = null;
    ScreenLockTimeout mScreenLockTimeout = new ScreenLockTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatusBarService getStatusBarService() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            }
            return this.mStatusBarService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusBarManagerInternal getStatusBarManagerInternal() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarManagerInternal == null) {
                this.mStatusBarManagerInternal = LocalServices.getService(StatusBarManagerInternal.class);
            }
            return this.mStatusBarManagerInternal;
        }
    }

    boolean needSensorRunningLp() {
        if (this.mSupportAutoRotation && (this.mCurrentAppOrientation == 4 || this.mCurrentAppOrientation == 10 || this.mCurrentAppOrientation == 7 || this.mCurrentAppOrientation == 6)) {
            return true;
        }
        if (this.mCarDockEnablesAccelerometer && this.mDockMode == 2 || this.mDeskDockEnablesAccelerometer && (this.mDockMode == 1 || this.mDockMode == 3 || this.mDockMode == 4)) {
            return true;
        }
        if (this.mUserRotationMode == 1) {
            return false;
        }
        return this.mSupportAutoRotation;
    }

    void updateOrientationListenerLp() {
        if (!this.mOrientationListener.canDetectOrientation()) {
            return;
        }
        boolean keyguardGoingAway = this.mWindowManagerInternal.isKeyguardGoingAway();
        boolean disable = true;
        if (this.mScreenOnEarly && this.mAwake && (this.mKeyguardDrawComplete && this.mWindowManagerDrawComplete || keyguardGoingAway) && this.needSensorRunningLp()) {
            disable = false;
            if (!this.mOrientationSensorEnabled) {
                this.mOrientationListener.enable(!keyguardGoingAway);
                this.mOrientationSensorEnabled = true;
            }
        }
        if (disable && this.mOrientationSensorEnabled) {
            this.mOrientationListener.disable();
            this.mOrientationSensorEnabled = false;
        }
    }

    private void interceptBackKeyDown() {
        MetricsLogger.count(this.mContext, "key_back_down", 1);
        this.mBackKeyHandled = false;
        if (this.hasPanicPressOnBackBehavior() && this.mBackKeyPressCounter != 0 && this.mBackKeyPressCounter < 4) {
            this.mHandler.removeMessages(20);
        }
        if (this.hasLongPressOnBackBehavior()) {
            Message msg = this.mHandler.obtainMessage(18);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
        }
    }

    private boolean interceptBackKeyUp(KeyEvent event) {
        TelecomManager telecomManager;
        boolean handled = this.mBackKeyHandled;
        if (this.hasPanicPressOnBackBehavior()) {
            ++this.mBackKeyPressCounter;
            long eventTime = event.getDownTime();
            if (this.mBackKeyPressCounter <= 4) {
                Message msg = this.mHandler.obtainMessage(20, this.mBackKeyPressCounter, 0, eventTime);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getMultiPressTimeout());
            }
        }
        this.cancelPendingBackKeyAction();
        if (this.mHasFeatureWatch && (telecomManager = this.getTelecommService()) != null) {
            if (telecomManager.isRinging()) {
                telecomManager.silenceRinger();
                return false;
            }
            if ((this.mIncallBackBehavior & 1) != 0 && telecomManager.isInCall()) {
                return telecomManager.endCall();
            }
        }
        if (this.mAutofillManagerInternal != null && event.getKeyCode() == 4) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(24));
        }
        return handled;
    }

    private void interceptPowerKeyDown(KeyEvent event, boolean interactive) {
        boolean panic;
        if (!this.mPowerKeyWakeLock.isHeld()) {
            this.mPowerKeyWakeLock.acquire();
        }
        if (this.mPowerKeyPressCounter != 0) {
            this.mHandler.removeMessages(13);
        }
        if (panic = this.mImmersiveModeConfirmation.onPowerKeyDown(interactive, SystemClock.elapsedRealtime(), this.isImmersiveMode(this.mLastSystemUiFlags), PhoneWindowManager.isNavBarEmpty(this.mLastSystemUiFlags))) {
            this.mHandler.post(this.mHiddenNavPanic);
        }
        if (interactive && !this.mScreenshotChordPowerKeyTriggered && (event.getFlags() & 0x400) == 0) {
            this.mScreenshotChordPowerKeyTriggered = true;
            this.mScreenshotChordPowerKeyTime = event.getDownTime();
            this.interceptScreenshotChord();
        }
        TelecomManager telecomManager = this.getTelecommService();
        boolean hungUp = false;
        if (telecomManager != null) {
            if (telecomManager.isRinging()) {
                telecomManager.silenceRinger();
            } else if ((this.mIncallPowerBehavior & 2) != 0 && telecomManager.isInCall() && interactive) {
                hungUp = telecomManager.endCall();
            }
        }
        GestureLauncherService gestureService = LocalServices.getService(GestureLauncherService.class);
        boolean gesturedServiceIntercepted = false;
        if (gestureService != null) {
            gesturedServiceIntercepted = gestureService.interceptPowerKeyDown(event, interactive, this.mTmpBoolean);
            if (this.mTmpBoolean.value && this.mGoingToSleep) {
                this.mCameraGestureTriggeredDuringGoingToSleep = true;
            }
        }
        boolean bl = this.mPowerKeyHandled = hungUp || this.mScreenshotChordVolumeDownKeyTriggered || this.mA11yShortcutChordVolumeUpKeyTriggered || gesturedServiceIntercepted;
        if (!this.mPowerKeyHandled) {
            if (interactive) {
                if (this.hasLongPressOnPowerBehavior()) {
                    Message msg = this.mHandler.obtainMessage(14);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                }
            } else {
                this.wakeUpFromPowerKey(event.getDownTime());
                if (this.mSupportLongPressPowerWhenNonInteractive && this.hasLongPressOnPowerBehavior()) {
                    Message msg = this.mHandler.obtainMessage(14);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                    this.mBeganFromNonInteractive = true;
                } else {
                    int maxCount = this.getMaxMultiPressPowerCount();
                    if (maxCount <= 1) {
                        this.mPowerKeyHandled = true;
                    } else {
                        this.mBeganFromNonInteractive = true;
                    }
                }
            }
        }
    }

    private void interceptPowerKeyUp(KeyEvent event, boolean interactive, boolean canceled) {
        boolean handled = canceled || this.mPowerKeyHandled;
        this.mScreenshotChordPowerKeyTriggered = false;
        this.cancelPendingScreenshotChordAction();
        this.cancelPendingPowerKeyAction();
        if (!handled) {
            ++this.mPowerKeyPressCounter;
            int maxCount = this.getMaxMultiPressPowerCount();
            long eventTime = event.getDownTime();
            if (this.mPowerKeyPressCounter < maxCount) {
                Message msg = this.mHandler.obtainMessage(13, interactive ? 1 : 0, this.mPowerKeyPressCounter, eventTime);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getDoubleTapTimeout());
                return;
            }
            this.powerPress(eventTime, interactive, this.mPowerKeyPressCounter);
        }
        this.finishPowerKeyPress();
    }

    private void finishPowerKeyPress() {
        this.mBeganFromNonInteractive = false;
        this.mPowerKeyPressCounter = 0;
        if (this.mPowerKeyWakeLock.isHeld()) {
            this.mPowerKeyWakeLock.release();
        }
    }

    private void finishBackKeyPress() {
        this.mBackKeyPressCounter = 0;
    }

    private void cancelPendingPowerKeyAction() {
        if (!this.mPowerKeyHandled) {
            this.mPowerKeyHandled = true;
            this.mHandler.removeMessages(14);
        }
    }

    private void cancelPendingBackKeyAction() {
        if (!this.mBackKeyHandled) {
            this.mBackKeyHandled = true;
            this.mHandler.removeMessages(18);
        }
    }

    private void backMultiPressAction(long eventTime, int count) {
        if (count >= 4) {
            switch (this.mPanicPressOnBackBehavior) {
                case 0: {
                    break;
                }
                case 1: {
                    this.launchHomeFromHotKey();
                }
            }
        }
    }

    private void powerPress(long eventTime, boolean interactive, int count) {
        if (this.mScreenOnEarly && !this.mScreenOnFully) {
            Slog.i(TAG, "Suppressed redundant power key press while already in the process of turning the screen on.");
            return;
        }
        if (count == 2) {
            this.powerMultiPressAction(eventTime, interactive, this.mDoublePressOnPowerBehavior);
        } else if (count == 3) {
            this.powerMultiPressAction(eventTime, interactive, this.mTriplePressOnPowerBehavior);
        } else if (interactive && !this.mBeganFromNonInteractive) {
            switch (this.mShortPressOnPowerBehavior) {
                case 0: {
                    break;
                }
                case 1: {
                    this.mPowerManager.goToSleep(eventTime, 4, 0);
                    break;
                }
                case 2: {
                    this.mPowerManager.goToSleep(eventTime, 4, 1);
                    break;
                }
                case 3: {
                    this.mPowerManager.goToSleep(eventTime, 4, 1);
                    this.launchHomeFromHotKey();
                    break;
                }
                case 4: {
                    this.shortPressPowerGoHome();
                    break;
                }
                case 5: {
                    if (this.mDismissImeOnBackKeyPressed) {
                        if (this.mInputMethodManagerInternal == null) {
                            this.mInputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
                        }
                        if (this.mInputMethodManagerInternal == null) break;
                        this.mInputMethodManagerInternal.hideCurrentInputMethod();
                        break;
                    }
                    this.shortPressPowerGoHome();
                }
            }
        }
    }

    private void shortPressPowerGoHome() {
        this.launchHomeFromHotKey(true, false);
        if (this.isKeyguardShowingAndNotOccluded()) {
            this.mKeyguardDelegate.onShortPowerPressedGoHome();
        }
    }

    private void powerMultiPressAction(long eventTime, boolean interactive, int behavior) {
        switch (behavior) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.isUserSetupComplete()) {
                    Slog.i(TAG, "Ignoring toggling theater mode - device not setup.");
                    break;
                }
                if (this.isTheaterModeEnabled()) {
                    Slog.i(TAG, "Toggling theater mode off.");
                    Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 0);
                    if (interactive) break;
                    this.wakeUpFromPowerKey(eventTime);
                    break;
                }
                Slog.i(TAG, "Toggling theater mode on.");
                Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 1);
                if (!this.mGoToSleepOnButtonPressTheaterMode || !interactive) break;
                this.mPowerManager.goToSleep(eventTime, 4, 0);
                break;
            }
            case 2: {
                Slog.i(TAG, "Starting brightness boost.");
                if (!interactive) {
                    this.wakeUpFromPowerKey(eventTime);
                }
                this.mPowerManager.boostScreenBrightness(eventTime);
            }
        }
    }

    private int getMaxMultiPressPowerCount() {
        if (this.mTriplePressOnPowerBehavior != 0) {
            return 3;
        }
        if (this.mDoublePressOnPowerBehavior != 0) {
            return 2;
        }
        return 1;
    }

    private void powerLongPress() {
        int behavior = this.getResolvedLongPressOnPowerBehavior();
        switch (behavior) {
            case 0: {
                break;
            }
            case 1: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedbackLw(null, 0, false);
                this.showGlobalActionsInternal();
                break;
            }
            case 2: 
            case 3: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedbackLw(null, 0, false);
                this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
                this.mWindowManagerFuncs.shutdown(behavior == 2);
            }
        }
    }

    private void backLongPress() {
        this.mBackKeyHandled = true;
        switch (this.mLongPressOnBackBehavior) {
            case 0: {
                break;
            }
            case 1: {
                boolean keyguardActive;
                boolean bl = keyguardActive = this.mKeyguardDelegate == null ? false : this.mKeyguardDelegate.isShowing();
                if (keyguardActive) break;
                Intent intent = new Intent("android.intent.action.VOICE_ASSIST");
                this.startActivityAsUser(intent, UserHandle.CURRENT_OR_SELF);
            }
        }
    }

    private void accessibilityShortcutActivated() {
        this.mAccessibilityShortcutController.performAccessibilityShortcut();
    }

    private void disposeInputConsumer(WindowManagerPolicy.InputConsumer inputConsumer) {
        if (inputConsumer != null) {
            inputConsumer.dismiss();
        }
    }

    private void sleepPress(long eventTime) {
        if (this.mShortPressOnSleepBehavior == 1) {
            this.launchHomeFromHotKey(false, true);
        }
    }

    private void sleepRelease(long eventTime) {
        switch (this.mShortPressOnSleepBehavior) {
            case 0: 
            case 1: {
                Slog.i(TAG, "sleepRelease() calling goToSleep(GO_TO_SLEEP_REASON_SLEEP_BUTTON)");
                this.mPowerManager.goToSleep(eventTime, 6, 0);
            }
        }
    }

    private int getResolvedLongPressOnPowerBehavior() {
        if (FactoryTest.isLongPressOnPowerOffEnabled()) {
            return 3;
        }
        return this.mLongPressOnPowerBehavior;
    }

    private boolean hasLongPressOnPowerBehavior() {
        return this.getResolvedLongPressOnPowerBehavior() != 0;
    }

    private boolean hasLongPressOnBackBehavior() {
        return this.mLongPressOnBackBehavior != 0;
    }

    private boolean hasPanicPressOnBackBehavior() {
        return this.mPanicPressOnBackBehavior != 0;
    }

    private void interceptScreenshotChord() {
        long now;
        if (this.mScreenshotChordEnabled && this.mScreenshotChordVolumeDownKeyTriggered && this.mScreenshotChordPowerKeyTriggered && !this.mA11yShortcutChordVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mScreenshotChordVolumeDownKeyTime + 150L && now <= this.mScreenshotChordPowerKeyTime + 150L) {
            this.mScreenshotChordVolumeDownKeyConsumed = true;
            this.cancelPendingPowerKeyAction();
            this.mScreenshotRunnable.setScreenshotType(1);
            this.mHandler.postDelayed(this.mScreenshotRunnable, this.getScreenshotChordLongPressDelay());
        }
    }

    private void interceptAccessibilityShortcutChord() {
        long now;
        if (this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(this.isKeyguardLocked()) && this.mScreenshotChordVolumeDownKeyTriggered && this.mA11yShortcutChordVolumeUpKeyTriggered && !this.mScreenshotChordPowerKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mScreenshotChordVolumeDownKeyTime + 150L && now <= this.mA11yShortcutChordVolumeUpKeyTime + 150L) {
            this.mScreenshotChordVolumeDownKeyConsumed = true;
            this.mA11yShortcutChordVolumeUpKeyConsumed = true;
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(21), ViewConfiguration.get(this.mContext).getAccessibilityShortcutKeyTimeout());
        }
    }

    private long getScreenshotChordLongPressDelay() {
        if (this.mKeyguardDelegate.isShowing()) {
            return (long)(2.5f * (float)ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
        }
        return ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout();
    }

    private void cancelPendingScreenshotChordAction() {
        this.mHandler.removeCallbacks(this.mScreenshotRunnable);
    }

    private void cancelPendingAccessibilityShortcutAction() {
        this.mHandler.removeMessages(21);
    }

    @Override
    public void showGlobalActions() {
        this.mHandler.removeMessages(10);
        this.mHandler.sendEmptyMessage(10);
    }

    void showGlobalActionsInternal() {
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
        if (this.mGlobalActions == null) {
            this.mGlobalActions = new GlobalActions(this.mContext, this.mWindowManagerFuncs);
        }
        boolean keyguardShowing = this.isKeyguardShowingAndNotOccluded();
        this.mGlobalActions.showDialog(keyguardShowing, this.isDeviceProvisioned());
        if (keyguardShowing) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
    }

    boolean isUserSetupComplete() {
        boolean isSetupComplete;
        boolean bl = isSetupComplete = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 0, -2) != 0;
        if (this.mHasFeatureLeanback) {
            isSetupComplete &= this.isTvUserSetupComplete();
        }
        return isSetupComplete;
    }

    private boolean isTvUserSetupComplete() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "tv_user_setup_complete", 0, -2) != 0;
    }

    private void handleShortPressOnHome() {
        HdmiControl hdmiControl = this.getHdmiControl();
        if (hdmiControl != null) {
            hdmiControl.turnOnTv();
        }
        if (this.mDreamManagerInternal != null && this.mDreamManagerInternal.isDreaming()) {
            this.mDreamManagerInternal.stopDream(false);
            return;
        }
        this.launchHomeFromHotKey();
    }

    private HdmiControl getHdmiControl() {
        if (null == this.mHdmiControl) {
            if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.hdmi.cec")) {
                return null;
            }
            HdmiControlManager manager = (HdmiControlManager)this.mContext.getSystemService("hdmi_control");
            HdmiPlaybackClient client = null;
            if (manager != null) {
                client = manager.getPlaybackClient();
            }
            this.mHdmiControl = new HdmiControl(client);
        }
        return this.mHdmiControl;
    }

    private void handleLongPressOnHome(int deviceId) {
        if (this.mLongPressOnHomeBehavior == 0) {
            return;
        }
        this.mHomeConsumed = true;
        this.performHapticFeedbackLw(null, 0, false);
        switch (this.mLongPressOnHomeBehavior) {
            case 1: {
                this.launchAllAppsAction();
                break;
            }
            case 2: {
                this.launchAssistAction(null, deviceId);
                break;
            }
            default: {
                Log.w(TAG, "Undefined home long press behavior: " + this.mLongPressOnHomeBehavior);
            }
        }
    }

    private void launchAllAppsAction() {
        Intent intent = new Intent("android.intent.action.ALL_APPS");
        this.startActivityAsUser(intent, UserHandle.CURRENT);
    }

    private void handleDoubleTapOnHome() {
        if (this.mDoubleTapOnHomeBehavior == 1) {
            this.mHomeConsumed = true;
            this.toggleRecentApps();
        }
    }

    private void showPictureInPictureMenu(KeyEvent event) {
        this.mHandler.removeMessages(17);
        Message msg = this.mHandler.obtainMessage(17);
        msg.setAsynchronous(true);
        msg.sendToTarget();
    }

    private void showPictureInPictureMenuInternal() {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.showPictureInPictureMenu();
        }
    }

    private boolean isRoundWindow() {
        return this.mContext.getResources().getConfiguration().isScreenRound();
    }

    @Override
    public void init(Context context, IWindowManager windowManager, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        this.mDreamManagerInternal = LocalServices.getService(DreamManagerInternal.class);
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mHasFeatureWatch = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        this.mHasFeatureLeanback = this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
        this.mAccessibilityShortcutController = new AccessibilityShortcutController(this.mContext, new Handler(), this.mCurrentUserId);
        boolean burnInProtectionEnabled = context.getResources().getBoolean(17956940);
        boolean burnInProtectionDevMode = SystemProperties.getBoolean("persist.debug.force_burn_in", false);
        if (burnInProtectionEnabled || burnInProtectionDevMode) {
            int maxRadius;
            int maxVertical;
            int minVertical;
            int maxHorizontal;
            int minHorizontal;
            if (burnInProtectionDevMode) {
                minHorizontal = -8;
                maxHorizontal = 8;
                minVertical = -8;
                maxVertical = -4;
                maxRadius = this.isRoundWindow() ? 6 : -1;
            } else {
                Resources resources = context.getResources();
                minHorizontal = resources.getInteger(17694749);
                maxHorizontal = resources.getInteger(17694746);
                minVertical = resources.getInteger(0x10E001E);
                maxVertical = resources.getInteger(17694748);
                maxRadius = resources.getInteger(17694747);
            }
            this.mBurnInProtectionHelper = new BurnInProtectionHelper(context, minHorizontal, maxHorizontal, minVertical, maxVertical, maxRadius);
        }
        this.mHandler = new PolicyHandler();
        this.mWakeGestureListener = new MyWakeGestureListener(this.mContext, this.mHandler);
        this.mOrientationListener = new MyOrientationListener(this.mContext, this.mHandler);
        try {
            this.mOrientationListener.setCurrentRotation(windowManager.getDefaultDisplayRotation());
        }
        catch (RemoteException minHorizontal) {
            // empty catch block
        }
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mShortcutManager = new ShortcutManager(context);
        this.mUiMode = context.getResources().getInteger(17694769);
        this.mHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mHomeIntent.addCategory("android.intent.category.HOME");
        this.mHomeIntent.addFlags(0x10200000);
        this.mEnableCarDockHomeCapture = context.getResources().getBoolean(17956941);
        this.mCarDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mCarDockIntent.addCategory("android.intent.category.CAR_DOCK");
        this.mCarDockIntent.addFlags(0x10200000);
        this.mDeskDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mDeskDockIntent.addCategory("android.intent.category.DESK_DOCK");
        this.mDeskDockIntent.addFlags(0x10200000);
        this.mVrHeadsetHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mVrHeadsetHomeIntent.addCategory("android.intent.category.VR_HOME");
        this.mVrHeadsetHomeIntent.addFlags(0x10200000);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mBroadcastWakeLock = this.mPowerManager.newWakeLock(1, "PhoneWindowManager.mBroadcastWakeLock");
        this.mPowerKeyWakeLock = this.mPowerManager.newWakeLock(1, "PhoneWindowManager.mPowerKeyWakeLock");
        this.mEnableShiftMenuBugReports = "1".equals(SystemProperties.get("ro.debuggable"));
        this.mSupportAutoRotation = this.mContext.getResources().getBoolean(17957010);
        this.mLidOpenRotation = this.readRotation(17694794);
        this.mCarDockRotation = this.readRotation(17694753);
        this.mDeskDockRotation = this.readRotation(17694772);
        this.mUndockedHdmiRotation = this.readRotation(17694855);
        this.mCarDockEnablesAccelerometer = this.mContext.getResources().getBoolean(17956907);
        this.mDeskDockEnablesAccelerometer = this.mContext.getResources().getBoolean(17956918);
        this.mLidKeyboardAccessibility = this.mContext.getResources().getInteger(17694792);
        this.mLidNavigationAccessibility = this.mContext.getResources().getInteger(17694793);
        this.mLidControlsScreenLock = this.mContext.getResources().getBoolean(17956968);
        this.mLidControlsSleep = this.mContext.getResources().getBoolean(17956969);
        this.mTranslucentDecorEnabled = this.mContext.getResources().getBoolean(17956952);
        this.mAllowTheaterModeWakeFromKey = this.mContext.getResources().getBoolean(17956879);
        this.mAllowTheaterModeWakeFromPowerKey = this.mAllowTheaterModeWakeFromKey || this.mContext.getResources().getBoolean(17956883);
        this.mAllowTheaterModeWakeFromMotion = this.mContext.getResources().getBoolean(0x1120011);
        this.mAllowTheaterModeWakeFromMotionWhenNotDreaming = this.mContext.getResources().getBoolean(0x1120012);
        this.mAllowTheaterModeWakeFromCameraLens = this.mContext.getResources().getBoolean(17956876);
        this.mAllowTheaterModeWakeFromLidSwitch = this.mContext.getResources().getBoolean(0x1120010);
        this.mAllowTheaterModeWakeFromWakeGesture = this.mContext.getResources().getBoolean(17956878);
        this.mGoToSleepOnButtonPressTheaterMode = this.mContext.getResources().getBoolean(17956961);
        this.mSupportLongPressPowerWhenNonInteractive = this.mContext.getResources().getBoolean(17957012);
        this.mLongPressOnBackBehavior = this.mContext.getResources().getInteger(17694797);
        this.mPanicPressOnBackBehavior = this.mContext.getResources().getInteger(0x10E0011);
        this.mShortPressOnPowerBehavior = this.mContext.getResources().getInteger(17694848);
        this.mLongPressOnPowerBehavior = this.mContext.getResources().getInteger(17694799);
        this.mDoublePressOnPowerBehavior = this.mContext.getResources().getInteger(17694774);
        this.mTriplePressOnPowerBehavior = this.mContext.getResources().getInteger(17694854);
        this.mShortPressOnSleepBehavior = this.mContext.getResources().getInteger(17694849);
        this.mUseTvRouting = AudioSystem.getPlatformType(this.mContext) == 2;
        this.mHandleVolumeKeysInWM = this.mContext.getResources().getBoolean(17956963);
        this.readConfigurationDependentBehaviors();
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        IntentFilter filter = new IntentFilter();
        filter.addAction(UiModeManager.ACTION_ENTER_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_ENTER_DESK_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_DESK_MODE);
        filter.addAction("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(this.mDockReceiver, filter);
        if (intent != null) {
            this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
        }
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DREAMING_STARTED");
        filter.addAction("android.intent.action.DREAMING_STOPPED");
        context.registerReceiver(this.mDreamReceiver, filter);
        filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        context.registerReceiver(this.mMultiuserReceiver, filter);
        this.mSystemGestures = new SystemGesturesPointerEventListener(context, new SystemGesturesPointerEventListener.Callbacks(){

            @Override
            public void onSwipeFromTop() {
                if (PhoneWindowManager.this.mStatusBar != null) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mStatusBar);
                }
            }

            @Override
            public void onSwipeFromBottom() {
                if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBarPosition == 0) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
                }
            }

            @Override
            public void onSwipeFromRight() {
                if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBarPosition == 1) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
                }
            }

            @Override
            public void onSwipeFromLeft() {
                if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBarPosition == 2) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
                }
            }

            @Override
            public void onFling(int duration) {
                if (PhoneWindowManager.this.mPowerManagerInternal != null) {
                    PhoneWindowManager.this.mPowerManagerInternal.powerHint(2, duration);
                }
            }

            @Override
            public void onDebug() {
            }

            @Override
            public void onDown() {
                PhoneWindowManager.this.mOrientationListener.onTouchStart();
            }

            @Override
            public void onUpOrCancel() {
                PhoneWindowManager.this.mOrientationListener.onTouchEnd();
            }

            @Override
            public void onMouseHoverAtTop() {
                PhoneWindowManager.this.mHandler.removeMessages(16);
                Message msg = PhoneWindowManager.this.mHandler.obtainMessage(16);
                msg.arg1 = 0;
                PhoneWindowManager.this.mHandler.sendMessageDelayed(msg, 500L);
            }

            @Override
            public void onMouseHoverAtBottom() {
                PhoneWindowManager.this.mHandler.removeMessages(16);
                Message msg = PhoneWindowManager.this.mHandler.obtainMessage(16);
                msg.arg1 = 1;
                PhoneWindowManager.this.mHandler.sendMessageDelayed(msg, 500L);
            }

            @Override
            public void onMouseLeaveFromEdge() {
                PhoneWindowManager.this.mHandler.removeMessages(16);
            }
        });
        this.mImmersiveModeConfirmation = new ImmersiveModeConfirmation(this.mContext);
        this.mWindowManagerFuncs.registerPointerEventListener(this.mSystemGestures);
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mLongPressVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236011);
        this.mVirtualKeyVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236042);
        this.mKeyboardTapVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236009);
        this.mClockTickVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235992);
        this.mCalendarDateVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235986);
        this.mSafeModeDisabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236022);
        this.mSafeModeEnabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236023);
        this.mContextClickVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235993);
        this.mScreenshotChordEnabled = this.mContext.getResources().getBoolean(17956951);
        this.mGlobalKeyManager = new GlobalKeyManager(this.mContext);
        this.initializeHdmiState();
        if (!this.mPowerManager.isInteractive()) {
            this.startedGoingToSleep(2);
            this.finishedGoingToSleep(2);
        }
        this.mWindowManagerInternal.registerAppTransitionListener(this.mStatusBarController.getAppTransitionListener());
        this.mWindowManagerInternal.registerAppTransitionListener(new WindowManagerInternal.AppTransitionListener(){

            @Override
            public int onAppTransitionStartingLocked(int transit, IBinder openToken, IBinder closeToken, Animation openAnimation, Animation closeAnimation) {
                return PhoneWindowManager.this.handleStartTransitionForKeyguardLw(transit, openAnimation);
            }

            @Override
            public void onAppTransitionCancelledLocked(int transit) {
                PhoneWindowManager.this.handleStartTransitionForKeyguardLw(transit, null);
            }
        });
        this.mKeyguardDelegate = new KeyguardServiceDelegate(this.mContext, new KeyguardStateMonitor.StateCallback(){

            @Override
            public void onTrustedChanged() {
                PhoneWindowManager.this.mWindowManagerFuncs.notifyKeyguardTrustedChanged();
            }
        });
    }

    private void readConfigurationDependentBehaviors() {
        Resources res = this.mContext.getResources();
        this.mLongPressOnHomeBehavior = res.getInteger(17694798);
        if (this.mLongPressOnHomeBehavior < 0 || this.mLongPressOnHomeBehavior > 2) {
            this.mLongPressOnHomeBehavior = 0;
        }
        this.mDoubleTapOnHomeBehavior = res.getInteger(17694775);
        if (this.mDoubleTapOnHomeBehavior < 0 || this.mDoubleTapOnHomeBehavior > 1) {
            this.mDoubleTapOnHomeBehavior = 0;
        }
        this.mShortPressWindowBehavior = 0;
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.picture_in_picture")) {
            this.mShortPressWindowBehavior = 1;
        }
        this.mNavBarOpacityMode = res.getInteger(17694813);
    }

    @Override
    public void setInitialDisplaySize(Display display, int width, int height, int density) {
        int longSize;
        int shortSize;
        if (this.mContext == null || display.getDisplayId() != 0) {
            return;
        }
        this.mDisplay = display;
        Resources res = this.mContext.getResources();
        if (width > height) {
            shortSize = height;
            longSize = width;
            this.mLandscapeRotation = 0;
            this.mSeascapeRotation = 2;
            if (res.getBoolean(17956990)) {
                this.mPortraitRotation = 1;
                this.mUpsideDownRotation = 3;
            } else {
                this.mPortraitRotation = 3;
                this.mUpsideDownRotation = 1;
            }
        } else {
            shortSize = width;
            longSize = height;
            this.mPortraitRotation = 0;
            this.mUpsideDownRotation = 2;
            if (res.getBoolean(17956990)) {
                this.mLandscapeRotation = 3;
                this.mSeascapeRotation = 1;
            } else {
                this.mLandscapeRotation = 1;
                this.mSeascapeRotation = 3;
            }
        }
        int shortSizeDp = shortSize * 160 / density;
        int longSizeDp = longSize * 160 / density;
        this.mNavigationBarCanMove = width != height && shortSizeDp < 600;
        this.mHasNavigationBar = res.getBoolean(17956998);
        String navBarOverride = SystemProperties.get("qemu.hw.mainkeys");
        if ("1".equals(navBarOverride)) {
            this.mHasNavigationBar = false;
        } else if ("0".equals(navBarOverride)) {
            this.mHasNavigationBar = true;
        }
        this.mDemoHdmiRotation = "portrait".equals(SystemProperties.get("persist.demo.hdmirotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
        this.mDemoHdmiRotationLock = SystemProperties.getBoolean("persist.demo.hdmirotationlock", false);
        this.mDemoRotation = "portrait".equals(SystemProperties.get("persist.demo.remoterotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
        this.mDemoRotationLock = SystemProperties.getBoolean("persist.demo.rotationlock", false);
        this.mForceDefaultOrientation = longSizeDp >= 960 && shortSizeDp >= 720 && res.getBoolean(17956958) && !"true".equals(SystemProperties.get("config.override_forced_orient"));
    }

    private boolean canHideNavigationBar() {
        return this.mHasNavigationBar;
    }

    @Override
    public boolean isDefaultOrientationForced() {
        return this.mForceDefaultOrientation;
    }

    @Override
    public void setDisplayOverscan(Display display, int left, int top, int right, int bottom) {
        if (display.getDisplayId() == 0) {
            this.mOverscanLeft = left;
            this.mOverscanTop = top;
            this.mOverscanRight = right;
            this.mOverscanBottom = bottom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean updateRotation = false;
        Object object = this.mLock;
        synchronized (object) {
            boolean hasSoftInput;
            int pointerLocation;
            int userRotationMode;
            int userRotation;
            boolean wakeGestureEnabledSetting;
            this.mEndcallBehavior = Settings.System.getIntForUser(resolver, "end_button_behavior", 2, -2);
            this.mIncallPowerBehavior = Settings.Secure.getIntForUser(resolver, "incall_power_button_behavior", 1, -2);
            this.mIncallBackBehavior = Settings.Secure.getIntForUser(resolver, "incall_back_button_behavior", 0, -2);
            boolean bl = wakeGestureEnabledSetting = Settings.Secure.getIntForUser(resolver, "wake_gesture_enabled", 0, -2) != 0;
            if (this.mWakeGestureEnabledSetting != wakeGestureEnabledSetting) {
                this.mWakeGestureEnabledSetting = wakeGestureEnabledSetting;
                this.updateWakeGestureListenerLp();
            }
            if (this.mUserRotation != (userRotation = Settings.System.getIntForUser(resolver, "user_rotation", 0, -2))) {
                this.mUserRotation = userRotation;
                updateRotation = true;
            }
            int n = userRotationMode = Settings.System.getIntForUser(resolver, "accelerometer_rotation", 0, -2) != 0 ? 0 : 1;
            if (this.mUserRotationMode != userRotationMode) {
                this.mUserRotationMode = userRotationMode;
                updateRotation = true;
                this.updateOrientationListenerLp();
            }
            if (this.mSystemReady && this.mPointerLocationMode != (pointerLocation = Settings.System.getIntForUser(resolver, "pointer_location", 0, -2))) {
                this.mPointerLocationMode = pointerLocation;
                this.mHandler.sendEmptyMessage(pointerLocation != 0 ? 1 : 2);
            }
            this.mLockScreenTimeout = Settings.System.getIntForUser(resolver, "screen_off_timeout", 0, -2);
            String imId = Settings.Secure.getStringForUser(resolver, "default_input_method", -2);
            boolean bl2 = hasSoftInput = imId != null && imId.length() > 0;
            if (this.mHasSoftInput != hasSoftInput) {
                this.mHasSoftInput = hasSoftInput;
                updateRotation = true;
            }
            if (this.mImmersiveModeConfirmation != null) {
                this.mImmersiveModeConfirmation.loadSetting(this.mCurrentUserId);
            }
        }
        object = this.mWindowManagerFuncs.getWindowManagerLock();
        synchronized (object) {
            PolicyControl.reloadFromSetting(this.mContext);
        }
        if (updateRotation) {
            this.updateRotation(true);
        }
    }

    private void updateWakeGestureListenerLp() {
        if (this.shouldEnableWakeGestureLp()) {
            this.mWakeGestureListener.requestWakeUpTrigger();
        } else {
            this.mWakeGestureListener.cancelWakeUpTrigger();
        }
    }

    private boolean shouldEnableWakeGestureLp() {
        return this.mWakeGestureEnabledSetting && !this.mAwake && (!this.mLidControlsSleep || this.mLidState != 0) && this.mWakeGestureListener.isSupported();
    }

    private void enablePointerLocation() {
        if (this.mPointerLocationView == null) {
            this.mPointerLocationView = new PointerLocationView(this.mContext);
            this.mPointerLocationView.setPrintCoords(false);
            WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1);
            lp.type = 2015;
            lp.flags = 1304;
            if (ActivityManager.isHighEndGfx()) {
                lp.flags |= 0x1000000;
                lp.privateFlags |= 2;
            }
            lp.format = -3;
            lp.setTitle("PointerLocation");
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            lp.inputFeatures |= 2;
            wm.addView(this.mPointerLocationView, lp);
            this.mWindowManagerFuncs.registerPointerEventListener(this.mPointerLocationView);
        }
    }

    private void disablePointerLocation() {
        if (this.mPointerLocationView != null) {
            this.mWindowManagerFuncs.unregisterPointerEventListener(this.mPointerLocationView);
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.removeView(this.mPointerLocationView);
            this.mPointerLocationView = null;
        }
    }

    private int readRotation(int resID) {
        try {
            int rotation = this.mContext.getResources().getInteger(resID);
            switch (rotation) {
                case 0: {
                    return 0;
                }
                case 90: {
                    return 1;
                }
                case 180: {
                    return 2;
                }
                case 270: {
                    return 3;
                }
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public int checkAddPermission(WindowManager.LayoutParams attrs, int[] outAppOp) {
        ApplicationInfo appInfo;
        int type = attrs.type;
        outAppOp[0] = -1;
        if (!(type >= 1 && type <= 99 || type >= 1000 && type <= 1999 || type >= 2000 && type <= 2999)) {
            return -10;
        }
        if (type < 2000 || type > 2999) {
            return 0;
        }
        if (!WindowManager.LayoutParams.isSystemAlertWindowType(type)) {
            switch (type) {
                case 2005: {
                    outAppOp[0] = 45;
                    return 0;
                }
                case 2011: 
                case 2013: 
                case 2023: 
                case 2030: 
                case 2031: 
                case 2032: 
                case 2035: 
                case 2037: {
                    return 0;
                }
            }
            return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") == 0 ? 0 : -8;
        }
        outAppOp[0] = 24;
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) == 1000) {
            return 0;
        }
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(attrs.packageName, 0, UserHandle.getUserId(callingUid));
        }
        catch (PackageManager.NameNotFoundException e) {
            appInfo = null;
        }
        if (appInfo == null || type != 2038 && appInfo.targetSdkVersion >= 26) {
            return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") == 0 ? 0 : -8;
        }
        int mode = this.mAppOpsManager.checkOpNoThrow(outAppOp[0], callingUid, attrs.packageName);
        switch (mode) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                if (appInfo.targetSdkVersion < 23) {
                    return 0;
                }
                return -8;
            }
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.SYSTEM_ALERT_WINDOW") == 0 ? 0 : -8;
    }

    @Override
    public boolean checkShowToOwnerOnly(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            default: {
                if ((attrs.privateFlags & 0x10) != 0) break;
                return true;
            }
            case 3: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2014: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2020: 
            case 2021: 
            case 2022: 
            case 2024: 
            case 2026: 
            case 2027: 
            case 2030: 
            case 2034: 
            case 2037: 
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0;
    }

    @Override
    public void adjustWindowParamsLw(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2006: 
            case 2015: {
                attrs.flags |= 0x18;
                attrs.flags &= 0xFFFBFFFF;
                break;
            }
            case 2000: {
                if (!this.mKeyguardOccluded) break;
                attrs.flags &= 0xFFEFFFFF;
                attrs.privateFlags &= 0xFFFFFBFF;
                break;
            }
            case 2036: {
                attrs.flags |= 8;
                break;
            }
            case 2005: {
                if (attrs.hideTimeoutMilliseconds < 0L || attrs.hideTimeoutMilliseconds > 3500L) {
                    attrs.hideTimeoutMilliseconds = 3500L;
                }
                attrs.windowAnimations = 16973828;
            }
        }
        if (attrs.type != 2000) {
            attrs.privateFlags &= 0xFFFFFBFF;
        }
        if (ActivityManager.isHighEndGfx()) {
            boolean forceWindowDrawsStatusBarBackground;
            if ((attrs.flags & Integer.MIN_VALUE) != 0) {
                attrs.subtreeSystemUiVisibility |= 0x200;
            }
            boolean bl = forceWindowDrawsStatusBarBackground = (attrs.privateFlags & 0x20000) != 0;
            if ((attrs.flags & Integer.MIN_VALUE) != 0 || forceWindowDrawsStatusBarBackground && attrs.height == -1 && attrs.width == -1) {
                attrs.subtreeSystemUiVisibility |= 0x400;
            }
        }
    }

    void readLidState() {
        this.mLidState = this.mWindowManagerFuncs.getLidState();
    }

    private void readCameraLensCoverState() {
        this.mCameraLensCoverState = this.mWindowManagerFuncs.getCameraLensCoverState();
    }

    private boolean isHidden(int accessibilityMode) {
        switch (accessibilityMode) {
            case 1: {
                return this.mLidState == 0;
            }
            case 2: {
                return this.mLidState == 1;
            }
        }
        return false;
    }

    @Override
    public void adjustConfigurationLw(Configuration config, int keyboardPresence, int navigationPresence) {
        this.mHaveBuiltInKeyboard = (keyboardPresence & 1) != 0;
        this.readConfigurationDependentBehaviors();
        this.readLidState();
        if (config.keyboard == 1 || keyboardPresence == 1 && this.isHidden(this.mLidKeyboardAccessibility)) {
            config.hardKeyboardHidden = 2;
            if (!this.mHasSoftInput) {
                config.keyboardHidden = 2;
            }
        }
        if (config.navigation == 1 || navigationPresence == 1 && this.isHidden(this.mLidNavigationAccessibility)) {
            config.navigationHidden = 2;
        }
    }

    @Override
    public void onConfigurationChanged() {
        Resources res = this.mContext.getResources();
        this.mStatusBarHeight = res.getDimensionPixelSize(17105227);
        this.mNavigationBarHeightForRotationDefault[this.mPortraitRotation] = this.mNavigationBarHeightForRotationDefault[this.mUpsideDownRotation] = res.getDimensionPixelSize(17105135);
        this.mNavigationBarHeightForRotationDefault[this.mLandscapeRotation] = this.mNavigationBarHeightForRotationDefault[this.mSeascapeRotation] = res.getDimensionPixelSize(17105137);
        this.mNavigationBarWidthForRotationDefault[this.mLandscapeRotation] = this.mNavigationBarWidthForRotationDefault[this.mSeascapeRotation] = res.getDimensionPixelSize(17105140);
        this.mNavigationBarWidthForRotationDefault[this.mUpsideDownRotation] = this.mNavigationBarWidthForRotationDefault[this.mSeascapeRotation];
        this.mNavigationBarWidthForRotationDefault[this.mPortraitRotation] = this.mNavigationBarWidthForRotationDefault[this.mSeascapeRotation];
    }

    @Override
    public int getMaxWallpaperLayer() {
        return this.getWindowLayerFromTypeLw(2000);
    }

    private int getNavigationBarWidth(int rotation, int uiMode) {
        return this.mNavigationBarWidthForRotationDefault[rotation];
    }

    @Override
    public int getNonDecorDisplayWidth(int fullWidth, int fullHeight, int rotation, int uiMode, int displayId) {
        if (displayId == 0 && this.mHasNavigationBar && this.mNavigationBarCanMove && fullWidth > fullHeight) {
            return fullWidth - this.getNavigationBarWidth(rotation, uiMode);
        }
        return fullWidth;
    }

    private int getNavigationBarHeight(int rotation, int uiMode) {
        return this.mNavigationBarHeightForRotationDefault[rotation];
    }

    @Override
    public int getNonDecorDisplayHeight(int fullWidth, int fullHeight, int rotation, int uiMode, int displayId) {
        if (displayId == 0 && this.mHasNavigationBar && (!this.mNavigationBarCanMove || fullWidth < fullHeight)) {
            return fullHeight - this.getNavigationBarHeight(rotation, uiMode);
        }
        return fullHeight;
    }

    @Override
    public int getConfigDisplayWidth(int fullWidth, int fullHeight, int rotation, int uiMode, int displayId) {
        return this.getNonDecorDisplayWidth(fullWidth, fullHeight, rotation, uiMode, displayId);
    }

    @Override
    public int getConfigDisplayHeight(int fullWidth, int fullHeight, int rotation, int uiMode, int displayId) {
        if (displayId == 0) {
            return this.getNonDecorDisplayHeight(fullWidth, fullHeight, rotation, uiMode, displayId) - this.mStatusBarHeight;
        }
        return fullHeight;
    }

    @Override
    public boolean isKeyguardHostWindow(WindowManager.LayoutParams attrs) {
        return attrs.type == 2000;
    }

    @Override
    public boolean canBeHiddenByKeyguardLw(WindowManagerPolicy.WindowState win) {
        switch (win.getAttrs().type) {
            case 2000: 
            case 2013: 
            case 2019: 
            case 2023: {
                return false;
            }
        }
        return this.getWindowLayerLw(win) < this.getWindowLayerFromTypeLw(2000);
    }

    private boolean shouldBeHiddenByKeyguard(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState imeTarget) {
        boolean allowWhenLocked;
        if (win.getAppToken() != null) {
            return false;
        }
        WindowManager.LayoutParams attrs = win.getAttrs();
        boolean showImeOverKeyguard = imeTarget != null && imeTarget.isVisibleLw() && ((imeTarget.getAttrs().flags & 0x80000) != 0 || !this.canBeHiddenByKeyguardLw(imeTarget));
        boolean bl = allowWhenLocked = (win.isInputMethodWindow() || imeTarget == this) && showImeOverKeyguard;
        if (this.isKeyguardLocked() && this.isKeyguardOccluded()) {
            allowWhenLocked |= (attrs.flags & 0x80000) != 0 || (attrs.privateFlags & 0x100) != 0;
        }
        boolean keyguardLocked = this.isKeyguardLocked();
        boolean hideDockDivider = attrs.type == 2034 && !this.mWindowManagerInternal.isStackVisible(3);
        return keyguardLocked && !allowWhenLocked && win.getDisplayId() == 0 || hideDockDivider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowManagerPolicy.StartingSurface addSplashScreen(IBinder appToken, String packageName, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, Configuration overrideConfig, int displayId) {
        if (packageName == null) {
            return null;
        }
        WindowManager wm = null;
        View view = null;
        try {
            Context context = this.mContext;
            Context displayContext = this.getDisplayContext(context, displayId);
            if (displayContext == null) {
                WindowManagerPolicy.StartingSurface startingSurface = null;
                return startingSurface;
            }
            context = displayContext;
            if (theme != context.getThemeResId() || labelRes != 0) {
                try {
                    context = context.createPackageContext(packageName, 4);
                    context.setTheme(theme);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (overrideConfig != null && !overrideConfig.equals(Configuration.EMPTY)) {
                Context overrideContext = context.createConfigurationContext(overrideConfig);
                overrideContext.setTheme(theme);
                TypedArray typedArray = overrideContext.obtainStyledAttributes(R.styleable.Window);
                int resId = typedArray.getResourceId(1, 0);
                if (resId != 0 && overrideContext.getDrawable(resId) != null) {
                    context = overrideContext;
                }
                typedArray.recycle();
            }
            PhoneWindow win = new PhoneWindow(context);
            win.setIsStartingWindow(true);
            CharSequence label = context.getResources().getText(labelRes, null);
            if (label != null) {
                win.setTitle(label, true);
            } else {
                win.setTitle(nonLocalizedLabel, false);
            }
            win.setType(3);
            Object resId = this.mWindowManagerFuncs.getWindowManagerLock();
            synchronized (resId) {
                if (this.mKeyguardOccluded) {
                    windowFlags |= 0x80000;
                }
            }
            win.setFlags(windowFlags | 0x10 | 8 | 0x20000, windowFlags | 0x10 | 8 | 0x20000);
            win.setDefaultIcon(icon);
            win.setDefaultLogo(logo);
            win.setLayout(-1, -1);
            WindowManager.LayoutParams params = win.getAttributes();
            params.token = appToken;
            params.packageName = packageName;
            params.windowAnimations = win.getWindowStyle().getResourceId(8, 0);
            params.privateFlags |= 1;
            params.privateFlags |= 0x10;
            if (!compatInfo.supportsScreen()) {
                params.privateFlags |= 0x80;
            }
            params.setTitle("Splash Screen " + packageName);
            this.addSplashscreenContent(win, context);
            wm = (WindowManager)context.getSystemService("window");
            view = win.getDecorView();
            wm.addView(view, params);
            SplashScreenSurface splashScreenSurface = view.getParent() != null ? new SplashScreenSurface(view, appToken) : null;
            return splashScreenSurface;
        }
        catch (WindowManager.BadTokenException e) {
            Log.w(TAG, appToken + " already running, starting window not displayed. " + e.getMessage());
        }
        catch (RuntimeException e) {
            Log.w(TAG, appToken + " failed creating starting window", e);
        }
        finally {
            if (view != null && view.getParent() == null) {
                Log.w(TAG, "view not successfully added to wm, removing view");
                wm.removeViewImmediate(view);
            }
        }
        return null;
    }

    private void addSplashscreenContent(PhoneWindow win, Context ctx) {
        TypedArray a = ctx.obtainStyledAttributes(R.styleable.Window);
        int resId = a.getResourceId(48, 0);
        a.recycle();
        if (resId == 0) {
            return;
        }
        Drawable drawable2 = ctx.getDrawable(resId);
        if (drawable2 == null) {
            return;
        }
        View v = new View(ctx);
        v.setBackground(drawable2);
        win.setContentView(v);
    }

    private Context getDisplayContext(Context context, int displayId) {
        if (displayId == 0) {
            return context;
        }
        DisplayManager dm = (DisplayManager)context.getSystemService("display");
        Display targetDisplay = dm.getDisplay(displayId);
        if (targetDisplay == null) {
            return null;
        }
        return context.createDisplayContext(targetDisplay);
    }

    @Override
    public int prepareAddWindowLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2000: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                if (this.mStatusBar != null && this.mStatusBar.isAlive()) {
                    return -7;
                }
                this.mStatusBar = win;
                this.mStatusBarController.setWindow(win);
                this.setKeyguardOccludedLw(this.mKeyguardOccluded, true);
                break;
            }
            case 2019: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                if (this.mNavigationBar != null && this.mNavigationBar.isAlive()) {
                    return -7;
                }
                this.mNavigationBar = win;
                this.mNavigationBarController.setWindow(win);
                this.mNavigationBarController.setOnBarVisibilityChangedListener(this.mNavBarVisibilityListener, true);
                break;
            }
            case 2014: 
            case 2017: 
            case 2024: 
            case 2033: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
            }
        }
        return 0;
    }

    @Override
    public void removeWindowLw(WindowManagerPolicy.WindowState win) {
        if (this.mStatusBar == win) {
            this.mStatusBar = null;
            this.mStatusBarController.setWindow(null);
        } else if (this.mNavigationBar == win) {
            this.mNavigationBar = null;
            this.mNavigationBarController.setWindow(null);
        }
    }

    @Override
    public int selectAnimationLw(WindowManagerPolicy.WindowState win, int transit) {
        if (win == this.mStatusBar) {
            boolean expanded;
            boolean isKeyguard = (win.getAttrs().privateFlags & 0x400) != 0;
            boolean bl = expanded = win.getAttrs().height == -1 && win.getAttrs().width == -1;
            if (isKeyguard || expanded) {
                return -1;
            }
            if (transit == 2 || transit == 4) {
                return 17432619;
            }
            if (transit == 1 || transit == 3) {
                return 17432618;
            }
        } else if (win == this.mNavigationBar) {
            if (win.getAttrs().windowAnimations != 0) {
                return 0;
            }
            if (this.mNavigationBarPosition == 0) {
                if (transit == 2 || transit == 4) {
                    if (this.isKeyguardShowingAndNotOccluded()) {
                        return 17432613;
                    }
                    return 17432612;
                }
                if (transit == 1 || transit == 3) {
                    return 17432611;
                }
            } else if (this.mNavigationBarPosition == 1) {
                if (transit == 2 || transit == 4) {
                    return 17432617;
                }
                if (transit == 1 || transit == 3) {
                    return 17432616;
                }
            } else if (this.mNavigationBarPosition == 2) {
                if (transit == 2 || transit == 4) {
                    return 17432615;
                }
                if (transit == 1 || transit == 3) {
                    return 17432614;
                }
            }
        } else if (win.getAttrs().type == 2034) {
            return this.selectDockedDividerAnimationLw(win, transit);
        }
        if (transit == 5) {
            if (win.hasAppShownWindows()) {
                return 0x10A0011;
            }
        } else if (win.getAttrs().type == 2023 && this.mDreamingLockscreen && transit == 1) {
            return -1;
        }
        return 0;
    }

    private int selectDockedDividerAnimationLw(WindowManagerPolicy.WindowState win, int transit) {
        boolean offscreen;
        int insets = this.mWindowManagerFuncs.getDockedDividerInsetsLw();
        Rect frame = win.getFrameLw();
        boolean behindNavBar = this.mNavigationBar != null && (this.mNavigationBarPosition == 0 && frame.top + insets >= this.mNavigationBar.getFrameLw().top || this.mNavigationBarPosition == 1 && frame.left + insets >= this.mNavigationBar.getFrameLw().left || this.mNavigationBarPosition == 2 && frame.right - insets <= this.mNavigationBar.getFrameLw().right);
        boolean landscape = frame.height() > frame.width();
        boolean offscreenLandscape = landscape && (frame.right - insets <= 0 || frame.left + insets >= win.getDisplayFrameLw().right);
        boolean offscreenPortrait = !landscape && (frame.top - insets <= 0 || frame.bottom + insets >= win.getDisplayFrameLw().bottom);
        boolean bl = offscreen = offscreenLandscape || offscreenPortrait;
        if (behindNavBar || offscreen) {
            return 0;
        }
        if (transit == 1 || transit == 3) {
            return 0x10A0000;
        }
        if (transit == 2) {
            return 0x10A0001;
        }
        return 0;
    }

    @Override
    public void selectRotationAnimationLw(int[] anim2) {
        if (this.mTopFullscreenOpaqueWindowState != null) {
            int animationHint = this.mTopFullscreenOpaqueWindowState.getRotationAnimationHint();
            if (animationHint < 0 && this.mTopIsFullscreen) {
                animationHint = this.mTopFullscreenOpaqueWindowState.getAttrs().rotationAnimation;
            }
            switch (animationHint) {
                case 1: 
                case 3: {
                    anim2[0] = 17432686;
                    anim2[1] = 17432684;
                    break;
                }
                case 2: {
                    anim2[0] = 17432685;
                    anim2[1] = 17432684;
                    break;
                }
                default: {
                    anim2[1] = 0;
                    anim2[0] = 0;
                    break;
                }
            }
        } else {
            anim2[1] = 0;
            anim2[0] = 0;
        }
    }

    @Override
    public boolean validateRotationAnimationLw(int exitAnimId, int enterAnimId, boolean forceDefault) {
        switch (exitAnimId) {
            case 17432685: 
            case 17432686: {
                if (forceDefault) {
                    return false;
                }
                int[] anim2 = new int[2];
                this.selectRotationAnimationLw(anim2);
                return exitAnimId == anim2[0] && enterAnimId == anim2[1];
            }
        }
        return true;
    }

    @Override
    public Animation createHiddenByKeyguardExit(boolean onWallpaper, boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return AnimationUtils.loadAnimation(this.mContext, 17432661);
        }
        AnimationSet set = (AnimationSet)AnimationUtils.loadAnimation(this.mContext, onWallpaper ? 17432662 : 17432660);
        List<Animation> animations = set.getAnimations();
        for (int i = animations.size() - 1; i >= 0; --i) {
            animations.get(i).setInterpolator(this.mLogDecelerateInterpolator);
        }
        return set;
    }

    @Override
    public Animation createKeyguardWallpaperExit(boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return null;
        }
        return AnimationUtils.loadAnimation(this.mContext, 17432665);
    }

    private static void awakenDreams() {
        IDreamManager dreamManager = PhoneWindowManager.getDreamManager();
        if (dreamManager != null) {
            try {
                dreamManager.awaken();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static IDreamManager getDreamManager() {
        return IDreamManager.Stub.asInterface(ServiceManager.checkService("dreams"));
    }

    TelecomManager getTelecommService() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    static IAudioService getAudioService() {
        IAudioService audioService = IAudioService.Stub.asInterface(ServiceManager.checkService("audio"));
        if (audioService == null) {
            Log.w(TAG, "Unable to find IAudioService interface.");
        }
        return audioService;
    }

    boolean keyguardOn() {
        return this.isKeyguardShowingAndNotOccluded() || this.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public long interceptKeyBeforeDispatching(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        String category;
        Intent shortcutIntent;
        KeyCharacterMap kcm;
        long timeoutTime;
        long now;
        boolean keyguardOn = this.keyguardOn();
        int keyCode = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int flags = event.getFlags();
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        if (this.mScreenshotChordEnabled && (flags & 0x400) == 0) {
            if (this.mScreenshotChordVolumeDownKeyTriggered && !this.mScreenshotChordPowerKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = this.mScreenshotChordVolumeDownKeyTime + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mScreenshotChordVolumeDownKeyConsumed) {
                if (!down) {
                    this.mScreenshotChordVolumeDownKeyConsumed = false;
                }
                return -1L;
            }
        }
        if (this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(false) && (flags & 0x400) == 0) {
            if (this.mScreenshotChordVolumeDownKeyTriggered ^ this.mA11yShortcutChordVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = (this.mScreenshotChordVolumeDownKeyTriggered ? this.mScreenshotChordVolumeDownKeyTime : this.mA11yShortcutChordVolumeUpKeyTime) + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mScreenshotChordVolumeDownKeyConsumed) {
                if (!down) {
                    this.mScreenshotChordVolumeDownKeyConsumed = false;
                }
                return -1L;
            }
            if (keyCode == 24 && this.mA11yShortcutChordVolumeUpKeyConsumed) {
                if (!down) {
                    this.mA11yShortcutChordVolumeUpKeyConsumed = false;
                }
                return -1L;
            }
        }
        if (this.mPendingMetaAction && !KeyEvent.isMetaKey(keyCode)) {
            this.mPendingMetaAction = false;
        }
        if (this.mPendingCapsLockToggle && !KeyEvent.isMetaKey(keyCode) && !KeyEvent.isAltKey(keyCode)) {
            this.mPendingCapsLockToggle = false;
        }
        if (keyCode == 3) {
            WindowManager.LayoutParams attrs;
            if (!down) {
                this.cancelPreloadRecentApps();
                if (this.mHasFeatureLeanback) {
                    this.mAccessibilityTvKey2Pressed = down;
                }
                this.mHomePressed = false;
                if (this.mHomeConsumed) {
                    this.mHomeConsumed = false;
                    return -1L;
                }
                if (canceled) {
                    Log.i(TAG, "Ignoring HOME; event canceled.");
                    return -1L;
                }
                if (this.mDoubleTapOnHomeBehavior != 0) {
                    this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.mHomeDoubleTapPending = true;
                    this.mHandler.postDelayed(this.mHomeDoubleTapTimeoutRunnable, ViewConfiguration.getDoubleTapTimeout());
                    return -1L;
                }
                this.handleShortPressOnHome();
                return -1L;
            }
            WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
            if (attrs != null) {
                int type = attrs.type;
                if (type == 2009 || (attrs.privateFlags & 0x400) != 0) {
                    return 0L;
                }
                int typeCount = WINDOW_TYPES_WHERE_HOME_DOESNT_WORK.length;
                for (int i = 0; i < typeCount; ++i) {
                    if (type != WINDOW_TYPES_WHERE_HOME_DOESNT_WORK[i]) continue;
                    return -1L;
                }
            }
            if (repeatCount == 0) {
                this.mHomePressed = true;
                if (this.mHomeDoubleTapPending) {
                    this.mHomeDoubleTapPending = false;
                    this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.handleDoubleTapOnHome();
                } else if (this.mDoubleTapOnHomeBehavior == 1) {
                    this.preloadRecentApps();
                }
            } else if ((event.getFlags() & 0x80) != 0) {
                if (this.mHasFeatureLeanback) {
                    this.mAccessibilityTvKey2Pressed = down;
                    if (this.interceptAccessibilityGestureTv()) {
                        return -1L;
                    }
                }
                if (!keyguardOn) {
                    this.handleLongPressOnHome(event.getDeviceId());
                }
            }
            return -1L;
        }
        if (keyCode == 82) {
            boolean chordBug = true;
            if (down && repeatCount == 0 && this.mEnableShiftMenuBugReports && (metaState & 1) == 1) {
                Intent intent = new Intent("android.intent.action.BUG_REPORT");
                this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT, null, null, null, 0, null, null);
                return -1L;
            }
        } else {
            if (keyCode == 84) {
                if (down) {
                    if (repeatCount == 0) {
                        this.mSearchKeyShortcutPending = true;
                        this.mConsumeSearchKeyUp = false;
                    }
                } else {
                    this.mSearchKeyShortcutPending = false;
                    if (this.mConsumeSearchKeyUp) {
                        this.mConsumeSearchKeyUp = false;
                        return -1L;
                    }
                }
                return 0L;
            }
            if (keyCode == 187) {
                if (!keyguardOn) {
                    if (down && repeatCount == 0) {
                        this.preloadRecentApps();
                    } else if (!down) {
                        this.toggleRecentApps();
                    }
                }
                return -1L;
            }
            if (keyCode == 42 && event.isMetaPressed()) {
                IStatusBarService service;
                if (down && (service = this.getStatusBarService()) != null) {
                    try {
                        service.expandNotificationsPanel();
                    }
                    catch (RemoteException intent) {}
                }
            } else if (keyCode == 47 && event.isMetaPressed() && event.isCtrlPressed()) {
                if (down && repeatCount == 0) {
                    int type = event.isShiftPressed() ? 2 : 1;
                    this.mScreenshotRunnable.setScreenshotType(type);
                    this.mHandler.post(this.mScreenshotRunnable);
                    return -1L;
                }
            } else if (keyCode == 76 && event.isMetaPressed()) {
                if (down && repeatCount == 0 && !this.isKeyguardLocked()) {
                    this.toggleKeyboardShortcutsMenu(event.getDeviceId());
                }
            } else {
                if (keyCode == 219) {
                    if (down) {
                        if (repeatCount == 0) {
                            this.mAssistKeyLongPressed = false;
                        } else if (repeatCount == 1) {
                            this.mAssistKeyLongPressed = true;
                            if (!keyguardOn) {
                                this.launchAssistLongPressAction();
                            }
                        }
                    } else if (this.mAssistKeyLongPressed) {
                        this.mAssistKeyLongPressed = false;
                    } else if (!keyguardOn) {
                        this.launchAssistAction(null, event.getDeviceId());
                    }
                    return -1L;
                }
                if (keyCode == 231) {
                    if (!down) {
                        Intent voiceIntent;
                        if (!keyguardOn) {
                            voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
                        } else {
                            IDeviceIdleController dic = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
                            if (dic != null) {
                                try {
                                    dic.exitIdle("voice-search");
                                }
                                catch (RemoteException typeCount) {
                                    // empty catch block
                                }
                            }
                            voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                            voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", true);
                        }
                        this.startActivityAsUser(voiceIntent, UserHandle.CURRENT_OR_SELF);
                    }
                } else {
                    if (keyCode == 120) {
                        if (down && repeatCount == 0) {
                            this.mScreenshotRunnable.setScreenshotType(1);
                            this.mHandler.post(this.mScreenshotRunnable);
                        }
                        return -1L;
                    }
                    if (keyCode == 221 || keyCode == 220) {
                        if (down) {
                            int direction = keyCode == 221 ? 1 : -1;
                            int auto = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                            if (auto != 0) {
                                Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                            }
                            int min = this.mPowerManager.getMinimumScreenBrightnessSetting();
                            int max = this.mPowerManager.getMaximumScreenBrightnessSetting();
                            int step = (max - min + 10 - 1) / 10 * direction;
                            int brightness = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness", this.mPowerManager.getDefaultScreenBrightnessSetting(), -3);
                            brightness += step;
                            brightness = Math.min(max, brightness);
                            brightness = Math.max(min, brightness);
                            Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness", brightness, -3);
                            this.startActivityAsUser(new Intent("com.android.intent.action.SHOW_BRIGHTNESS_DIALOG"), UserHandle.CURRENT_OR_SELF);
                        }
                        return -1L;
                    }
                    if (keyCode == 24 || keyCode == 25 || keyCode == 164) {
                        if (this.mUseTvRouting || this.mHandleVolumeKeysInWM) {
                            this.dispatchDirectAudioEvent(event);
                            return -1L;
                        }
                        if (this.mPersistentVrModeEnabled) {
                            return -1L;
                        }
                    } else {
                        if (keyCode == 61 && event.isMetaPressed()) {
                            return 0L;
                        }
                        if (this.mHasFeatureLeanback && this.interceptBugreportGestureTv(keyCode, down)) {
                            return -1L;
                        }
                        if (this.mHasFeatureLeanback && keyCode == 23) {
                            this.mAccessibilityTvKey1Pressed = down;
                            if (this.interceptAccessibilityGestureTv()) {
                                return -1L;
                            }
                        }
                    }
                }
            }
        }
        boolean actionTriggered = false;
        if (KeyEvent.isModifierKey(keyCode)) {
            if (!this.mPendingCapsLockToggle) {
                this.mInitialMetaState = this.mMetaState;
                this.mPendingCapsLockToggle = true;
            } else if (event.getAction() == 1) {
                int altOnMask = this.mMetaState & 0x32;
                int metaOnMask = this.mMetaState & 0x70000;
                if (metaOnMask != 0 && altOnMask != 0 && this.mInitialMetaState == (this.mMetaState ^ (altOnMask | metaOnMask))) {
                    this.mInputManagerInternal.toggleCapsLock(event.getDeviceId());
                    actionTriggered = true;
                }
                this.mPendingCapsLockToggle = false;
            }
        }
        this.mMetaState = metaState;
        if (actionTriggered) {
            return -1L;
        }
        if (KeyEvent.isMetaKey(keyCode)) {
            if (down) {
                this.mPendingMetaAction = true;
            } else if (this.mPendingMetaAction) {
                this.launchAssistAction("android.intent.extra.ASSIST_INPUT_HINT_KEYBOARD", event.getDeviceId());
            }
            return -1L;
        }
        if (this.mSearchKeyShortcutPending && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode)) {
            this.mConsumeSearchKeyUp = true;
            this.mSearchKeyShortcutPending = false;
            if (down && repeatCount == 0 && !keyguardOn) {
                Intent shortcutIntent2 = this.mShortcutManager.getIntent(kcm, keyCode, metaState);
                if (shortcutIntent2 != null) {
                    shortcutIntent2.addFlags(0x10000000);
                    try {
                        this.startActivityAsUser(shortcutIntent2, UserHandle.CURRENT);
                        this.dismissKeyboardShortcutsMenu();
                    }
                    catch (ActivityNotFoundException ex) {
                        Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: SEARCH+" + KeyEvent.keyCodeToString(keyCode), ex);
                    }
                } else {
                    Slog.i(TAG, "Dropping unregistered shortcut key combination: SEARCH+" + KeyEvent.keyCodeToString(keyCode));
                }
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (metaState & 0x10000) != 0 && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode) && (shortcutIntent = this.mShortcutManager.getIntent(kcm, keyCode, metaState & 0xFFF8FFFF)) != null) {
            shortcutIntent.addFlags(0x10000000);
            try {
                this.startActivityAsUser(shortcutIntent, UserHandle.CURRENT);
                this.dismissKeyboardShortcutsMenu();
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: META+" + KeyEvent.keyCodeToString(keyCode), ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (category = sApplicationLaunchKeyCategories.get(keyCode)) != null) {
            Intent intent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", category);
            intent.setFlags(0x10000000);
            try {
                this.startActivityAsUser(intent, UserHandle.CURRENT);
                this.dismissKeyboardShortcutsMenu();
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping application launch key because the activity to which it is registered was not found: keyCode=" + keyCode + ", category=" + category, ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && keyCode == 61) {
            int shiftlessModifiers;
            if (this.mRecentAppsHeldModifiers == 0 && !keyguardOn && this.isUserSetupComplete() && KeyEvent.metaStateHasModifiers(shiftlessModifiers = event.getModifiers() & 0xFFFFFF3E, 2)) {
                this.mRecentAppsHeldModifiers = shiftlessModifiers;
                this.showRecentApps(true, false);
                return -1L;
            }
        } else if (!down && this.mRecentAppsHeldModifiers != 0 && (metaState & this.mRecentAppsHeldModifiers) == 0) {
            this.mRecentAppsHeldModifiers = 0;
            this.hideRecentApps(true, false);
        }
        if (down && repeatCount == 0 && (keyCode == 204 || keyCode == 62 && (metaState & 0x70000) != 0)) {
            boolean forwardDirection = (metaState & 0xC1) == 0;
            this.mWindowManagerFuncs.switchInputMethod(forwardDirection);
            return -1L;
        }
        if (this.mLanguageSwitchKeyPressed && !down && (keyCode == 204 || keyCode == 62)) {
            this.mLanguageSwitchKeyPressed = false;
            return -1L;
        }
        if (PhoneWindowManager.isValidGlobalKey(keyCode) && this.mGlobalKeyManager.handleGlobalKey(this.mContext, keyCode, event)) {
            return -1L;
        }
        if (down) {
            IShortcutService shortcutService;
            long shortcutCode = keyCode;
            if (event.isCtrlPressed()) {
                shortcutCode |= 0x100000000000L;
            }
            if (event.isAltPressed()) {
                shortcutCode |= 0x200000000L;
            }
            if (event.isShiftPressed()) {
                shortcutCode |= 0x100000000L;
            }
            if (event.isMetaPressed()) {
                shortcutCode |= 0x1000000000000L;
            }
            if ((shortcutService = this.mShortcutKeyServices.get(shortcutCode)) != null) {
                try {
                    if (this.isUserSetupComplete()) {
                        shortcutService.notifyShortcutKeyPressed(shortcutCode);
                    }
                }
                catch (RemoteException e) {
                    this.mShortcutKeyServices.delete(shortcutCode);
                }
                return -1L;
            }
        }
        if ((metaState & 0x10000) != 0) {
            return -1L;
        }
        return 0L;
    }

    private boolean interceptBugreportGestureTv(int keyCode, boolean down) {
        if (keyCode == 23) {
            this.mBugreportTvKey1Pressed = down;
        } else if (keyCode == 4) {
            this.mBugreportTvKey2Pressed = down;
        }
        if (this.mBugreportTvKey1Pressed && this.mBugreportTvKey2Pressed) {
            if (!this.mBugreportTvScheduled) {
                this.mBugreportTvScheduled = true;
                Message msg = Message.obtain(this.mHandler, 22);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, 1000L);
            }
        } else if (this.mBugreportTvScheduled) {
            this.mHandler.removeMessages(22);
            this.mBugreportTvScheduled = false;
        }
        return this.mBugreportTvScheduled;
    }

    private boolean interceptAccessibilityGestureTv() {
        if (this.mAccessibilityTvKey1Pressed && this.mAccessibilityTvKey2Pressed) {
            if (!this.mAccessibilityTvScheduled) {
                this.mAccessibilityTvScheduled = true;
                Message msg = Message.obtain(this.mHandler, 23);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
            }
        } else if (this.mAccessibilityTvScheduled) {
            this.mHandler.removeMessages(23);
            this.mAccessibilityTvScheduled = false;
        }
        return this.mAccessibilityTvScheduled;
    }

    private void takeBugreport() {
        if ("1".equals(SystemProperties.get("ro.debuggable")) || Settings.Global.getInt(this.mContext.getContentResolver(), "development_settings_enabled", 0) == 1) {
            try {
                ActivityManager.getService().requestBugReport(1);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error taking bugreport", e);
            }
        }
    }

    @Override
    public KeyEvent dispatchUnhandledKey(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        KeyEvent fallbackEvent = null;
        if ((event.getFlags() & 0x400) == 0) {
            KeyCharacterMap kcm = event.getKeyCharacterMap();
            int keyCode = event.getKeyCode();
            int metaState = event.getMetaState();
            boolean initialDown = event.getAction() == 0 && event.getRepeatCount() == 0;
            KeyCharacterMap.FallbackAction fallbackAction = initialDown ? kcm.getFallbackAction(keyCode, metaState) : this.mFallbackActions.get(keyCode);
            if (fallbackAction != null) {
                int flags = event.getFlags() | 0x400;
                fallbackEvent = KeyEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), fallbackAction.keyCode, event.getRepeatCount(), fallbackAction.metaState, event.getDeviceId(), event.getScanCode(), flags, event.getSource(), null);
                if (!this.interceptFallback(win, fallbackEvent, policyFlags)) {
                    fallbackEvent.recycle();
                    fallbackEvent = null;
                }
                if (initialDown) {
                    this.mFallbackActions.put(keyCode, fallbackAction);
                } else if (event.getAction() == 1) {
                    this.mFallbackActions.remove(keyCode);
                    fallbackAction.recycle();
                }
            }
        }
        return fallbackEvent;
    }

    private boolean interceptFallback(WindowManagerPolicy.WindowState win, KeyEvent fallbackEvent, int policyFlags) {
        long delayMillis;
        int actions = this.interceptKeyBeforeQueueing(fallbackEvent, policyFlags);
        return (actions & 1) != 0 && (delayMillis = this.interceptKeyBeforeDispatching(win, fallbackEvent, policyFlags)) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerShortcutKey(long shortcutCode, IShortcutService shortcutService) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            IShortcutService service = this.mShortcutKeyServices.get(shortcutCode);
            if (service != null && service.asBinder().pingBinder()) {
                throw new RemoteException("Key already exists.");
            }
            this.mShortcutKeyServices.put(shortcutCode, shortcutService);
        }
    }

    @Override
    public void onKeyguardOccludedChangedLw(boolean occluded) {
        if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.isShowing()) {
            this.mPendingKeyguardOccluded = occluded;
            this.mKeyguardOccludedChanged = true;
        } else {
            this.setKeyguardOccludedLw(occluded, false);
        }
    }

    private int handleStartTransitionForKeyguardLw(int transit, Animation anim2) {
        if (this.mKeyguardOccludedChanged) {
            this.mKeyguardOccludedChanged = false;
            if (this.setKeyguardOccludedLw(this.mPendingKeyguardOccluded, false)) {
                return 5;
            }
        }
        if (AppTransition.isKeyguardGoingAwayTransit(transit)) {
            long startTime = anim2 != null ? SystemClock.uptimeMillis() + anim2.getStartOffset() : SystemClock.uptimeMillis();
            long duration = anim2 != null ? anim2.getDuration() : 0L;
            this.startKeyguardExitAnimation(startTime, duration);
        }
        return 0;
    }

    private void launchAssistLongPressAction() {
        this.performHapticFeedbackLw(null, 0, false);
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
        intent.setFlags(0x10000000);
        try {
            SearchManager searchManager = this.getSearchManager();
            if (searchManager != null) {
                searchManager.stopSearch();
            }
            this.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        catch (ActivityNotFoundException e) {
            Slog.w(TAG, "No activity to handle assist long press action.", e);
        }
    }

    private void launchAssistAction(String hint, int deviceId) {
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        if (!this.isUserSetupComplete()) {
            return;
        }
        Bundle args = null;
        if (deviceId > Integer.MIN_VALUE) {
            args = new Bundle();
            args.putInt("android.intent.extra.ASSIST_INPUT_DEVICE_ID", deviceId);
        }
        if ((this.mContext.getResources().getConfiguration().uiMode & 0xF) == 4) {
            ((SearchManager)this.mContext.getSystemService("search")).launchLegacyAssist(hint, UserHandle.myUserId(), args);
        } else {
            StatusBarManagerInternal statusbar;
            if (hint != null) {
                if (args == null) {
                    args = new Bundle();
                }
                args.putBoolean(hint, true);
            }
            if ((statusbar = this.getStatusBarManagerInternal()) != null) {
                statusbar.startAssist(args);
            }
        }
    }

    private void startActivityAsUser(Intent intent, UserHandle handle) {
        if (this.isUserSetupComplete()) {
            this.mContext.startActivityAsUser(intent, handle);
        } else {
            Slog.i(TAG, "Not starting activity because user setup is in progress: " + intent);
        }
    }

    private SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    private void preloadRecentApps() {
        this.mPreloadedRecentApps = true;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.preloadRecentApps();
        }
    }

    private void cancelPreloadRecentApps() {
        if (this.mPreloadedRecentApps) {
            this.mPreloadedRecentApps = false;
            StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
            if (statusbar != null) {
                statusbar.cancelPreloadRecentApps();
            }
        }
    }

    private void toggleRecentApps() {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.toggleRecentApps();
        }
    }

    @Override
    public void showRecentApps(boolean fromHome) {
        this.mHandler.removeMessages(9);
        this.mHandler.obtainMessage(9, fromHome ? 1 : 0, 0).sendToTarget();
    }

    private void showRecentApps(boolean triggeredFromAltTab, boolean fromHome) {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.showRecentApps(triggeredFromAltTab, fromHome);
        }
    }

    private void toggleKeyboardShortcutsMenu(int deviceId) {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.toggleKeyboardShortcutsMenu(deviceId);
        }
    }

    private void dismissKeyboardShortcutsMenu() {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.dismissKeyboardShortcutsMenu();
        }
    }

    private void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHome) {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.hideRecentApps(triggeredFromAltTab, triggeredFromHome);
        }
    }

    void launchHomeFromHotKey() {
        this.launchHomeFromHotKey(true, true);
    }

    void launchHomeFromHotKey(final boolean awakenFromDreams, boolean respectKeyguard) {
        if (respectKeyguard) {
            if (this.isKeyguardShowingAndNotOccluded()) {
                return;
            }
            if (!this.mKeyguardOccluded && this.mKeyguardDelegate.isInputRestricted()) {
                this.mKeyguardDelegate.verifyUnlock(new WindowManagerPolicy.OnKeyguardExitResult(){

                    @Override
                    public void onKeyguardExitResult(boolean success) {
                        if (success) {
                            try {
                                ActivityManager.getService().stopAppSwitches();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_HOME_KEY);
                            PhoneWindowManager.this.startDockOrHome(true, awakenFromDreams);
                        }
                    }
                });
                return;
            }
        }
        try {
            ActivityManager.getService().stopAppSwitches();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mRecentsVisible) {
            if (awakenFromDreams) {
                PhoneWindowManager.awakenDreams();
            }
            this.hideRecentApps(false, true);
        } else {
            this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_HOME_KEY);
            this.startDockOrHome(true, awakenFromDreams);
        }
    }

    @Override
    public void setRecentsVisibilityLw(boolean visible) {
        this.mRecentsVisible = visible;
    }

    @Override
    public void setPipVisibilityLw(boolean visible) {
        this.mPictureInPictureVisible = visible;
    }

    @Override
    public int adjustSystemUiVisibilityLw(int visibility) {
        this.mStatusBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mNavigationBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mResettingSystemUiFlags &= visibility;
        return visibility & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
    }

    @Override
    public boolean getInsetHintLw(WindowManager.LayoutParams attrs, Rect taskBounds, int displayRotation, int displayWidth, int displayHeight, Rect outContentInsets, Rect outStableInsets, Rect outOutsets) {
        int outset;
        boolean useOutsets;
        int fl = PolicyControl.getWindowFlags(null, attrs);
        int sysuiVis = PolicyControl.getSystemUiVisibility(null, attrs);
        int systemUiVisibility = sysuiVis | attrs.subtreeSystemUiVisibility;
        boolean bl = useOutsets = outOutsets != null && this.shouldUseOutsets(attrs, fl);
        if (useOutsets && (outset = ScreenShapeHelper.getWindowOutsetBottomPx(this.mContext.getResources())) > 0) {
            if (displayRotation == 0) {
                outOutsets.bottom += outset;
            } else if (displayRotation == 1) {
                outOutsets.right += outset;
            } else if (displayRotation == 2) {
                outOutsets.top += outset;
            } else if (displayRotation == 3) {
                outOutsets.left += outset;
            }
        }
        if ((fl & 0x10100) == 65792) {
            int availBottom;
            int availRight;
            if (this.canHideNavigationBar() && (systemUiVisibility & 0x200) != 0) {
                availRight = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                availBottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
            } else {
                availRight = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                availBottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
            }
            if ((systemUiVisibility & 0x100) != 0) {
                if ((fl & 0x400) != 0) {
                    outContentInsets.set(this.mStableFullscreenLeft, this.mStableFullscreenTop, availRight - this.mStableFullscreenRight, availBottom - this.mStableFullscreenBottom);
                } else {
                    outContentInsets.set(this.mStableLeft, this.mStableTop, availRight - this.mStableRight, availBottom - this.mStableBottom);
                }
            } else if ((fl & 0x400) != 0 || (fl & 0x2000000) != 0) {
                outContentInsets.setEmpty();
            } else if ((systemUiVisibility & 0x404) == 0) {
                outContentInsets.set(this.mCurLeft, this.mCurTop, availRight - this.mCurRight, availBottom - this.mCurBottom);
            } else {
                outContentInsets.set(this.mCurLeft, this.mCurTop, availRight - this.mCurRight, availBottom - this.mCurBottom);
            }
            outStableInsets.set(this.mStableLeft, this.mStableTop, availRight - this.mStableRight, availBottom - this.mStableBottom);
            if (taskBounds != null) {
                this.calculateRelevantTaskInsets(taskBounds, outContentInsets, displayWidth, displayHeight);
                this.calculateRelevantTaskInsets(taskBounds, outStableInsets, displayWidth, displayHeight);
            }
            return this.mForceShowSystemBars;
        }
        outContentInsets.setEmpty();
        outStableInsets.setEmpty();
        return this.mForceShowSystemBars;
    }

    private void calculateRelevantTaskInsets(Rect taskBounds, Rect inOutInsets, int displayWidth, int displayHeight) {
        mTmpRect.set(0, 0, displayWidth, displayHeight);
        mTmpRect.inset(inOutInsets);
        mTmpRect.intersect(taskBounds);
        int leftInset = PhoneWindowManager.mTmpRect.left - taskBounds.left;
        int topInset = PhoneWindowManager.mTmpRect.top - taskBounds.top;
        int rightInset = taskBounds.right - PhoneWindowManager.mTmpRect.right;
        int bottomInset = taskBounds.bottom - PhoneWindowManager.mTmpRect.bottom;
        inOutInsets.set(leftInset, topInset, rightInset, bottomInset);
    }

    private boolean shouldUseOutsets(WindowManager.LayoutParams attrs, int fl) {
        return attrs.type == 2013 || (fl & 0x2000400) != 0;
    }

    @Override
    public void beginLayoutLw(boolean isDefaultDisplay, int displayWidth, int displayHeight, int displayRotation, int uiMode) {
        int overscanBottom;
        int overscanRight;
        int overscanTop;
        int overscanLeft;
        this.mDisplayRotation = displayRotation;
        if (isDefaultDisplay) {
            switch (displayRotation) {
                case 1: {
                    overscanLeft = this.mOverscanTop;
                    overscanTop = this.mOverscanRight;
                    overscanRight = this.mOverscanBottom;
                    overscanBottom = this.mOverscanLeft;
                    break;
                }
                case 2: {
                    overscanLeft = this.mOverscanRight;
                    overscanTop = this.mOverscanBottom;
                    overscanRight = this.mOverscanLeft;
                    overscanBottom = this.mOverscanTop;
                    break;
                }
                case 3: {
                    overscanLeft = this.mOverscanBottom;
                    overscanTop = this.mOverscanLeft;
                    overscanRight = this.mOverscanTop;
                    overscanBottom = this.mOverscanRight;
                    break;
                }
                default: {
                    overscanLeft = this.mOverscanLeft;
                    overscanTop = this.mOverscanTop;
                    overscanRight = this.mOverscanRight;
                    overscanBottom = this.mOverscanBottom;
                    break;
                }
            }
        } else {
            overscanLeft = 0;
            overscanTop = 0;
            overscanRight = 0;
            overscanBottom = 0;
        }
        this.mRestrictedOverscanScreenLeft = 0;
        this.mOverscanScreenLeft = 0;
        this.mRestrictedOverscanScreenTop = 0;
        this.mOverscanScreenTop = 0;
        this.mOverscanScreenWidth = this.mRestrictedOverscanScreenWidth = displayWidth;
        this.mOverscanScreenHeight = this.mRestrictedOverscanScreenHeight = displayHeight;
        this.mSystemLeft = 0;
        this.mSystemTop = 0;
        this.mSystemRight = displayWidth;
        this.mSystemBottom = displayHeight;
        this.mUnrestrictedScreenLeft = overscanLeft;
        this.mUnrestrictedScreenTop = overscanTop;
        this.mUnrestrictedScreenWidth = displayWidth - overscanLeft - overscanRight;
        this.mUnrestrictedScreenHeight = displayHeight - overscanTop - overscanBottom;
        this.mRestrictedScreenLeft = this.mUnrestrictedScreenLeft;
        this.mRestrictedScreenTop = this.mUnrestrictedScreenTop;
        this.mRestrictedScreenWidth = this.mSystemGestures.screenWidth = this.mUnrestrictedScreenWidth;
        this.mRestrictedScreenHeight = this.mSystemGestures.screenHeight = this.mUnrestrictedScreenHeight;
        this.mStableFullscreenLeft = this.mCurLeft = this.mUnrestrictedScreenLeft;
        this.mStableLeft = this.mCurLeft;
        this.mVoiceContentLeft = this.mCurLeft;
        this.mContentLeft = this.mCurLeft;
        this.mDockLeft = this.mCurLeft;
        this.mStableFullscreenTop = this.mCurTop = this.mUnrestrictedScreenTop;
        this.mStableTop = this.mCurTop;
        this.mVoiceContentTop = this.mCurTop;
        this.mContentTop = this.mCurTop;
        this.mDockTop = this.mCurTop;
        this.mStableFullscreenRight = this.mCurRight = displayWidth - overscanRight;
        this.mStableRight = this.mCurRight;
        this.mVoiceContentRight = this.mCurRight;
        this.mContentRight = this.mCurRight;
        this.mDockRight = this.mCurRight;
        this.mStableFullscreenBottom = this.mCurBottom = displayHeight - overscanBottom;
        this.mStableBottom = this.mCurBottom;
        this.mVoiceContentBottom = this.mCurBottom;
        this.mContentBottom = this.mCurBottom;
        this.mDockBottom = this.mCurBottom;
        this.mDockLayer = 0x10000000;
        this.mStatusBarLayer = -1;
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect of = mTmpOverscanFrame;
        Rect vf = mTmpVisibleFrame;
        Rect dcf = mTmpDecorFrame;
        of.left = vf.left = this.mDockLeft;
        df.left = vf.left;
        pf.left = vf.left;
        of.top = vf.top = this.mDockTop;
        df.top = vf.top;
        pf.top = vf.top;
        of.right = vf.right = this.mDockRight;
        df.right = vf.right;
        pf.right = vf.right;
        of.bottom = vf.bottom = this.mDockBottom;
        df.bottom = vf.bottom;
        pf.bottom = vf.bottom;
        dcf.setEmpty();
        if (isDefaultDisplay) {
            boolean statusBarExpandedNotKeyguard;
            boolean isKeyguardShowing;
            int sysui = this.mLastSystemUiFlags;
            boolean navVisible = (sysui & 2) == 0;
            boolean navTranslucent = (sysui & 0x80008000) != 0;
            boolean immersive = (sysui & 0x800) != 0;
            boolean immersiveSticky = (sysui & 0x1000) != 0;
            boolean navAllowedHidden = immersive || immersiveSticky;
            navTranslucent &= !immersiveSticky;
            boolean bl = isKeyguardShowing = this.isStatusBarKeyguard() && !this.mKeyguardOccluded;
            if (!isKeyguardShowing) {
                navTranslucent &= this.areTranslucentBarsAllowed();
            }
            boolean bl2 = statusBarExpandedNotKeyguard = !isKeyguardShowing && this.mStatusBar != null && this.mStatusBar.getAttrs().height == -1 && this.mStatusBar.getAttrs().width == -1;
            if (navVisible || navAllowedHidden) {
                if (this.mInputConsumer != null) {
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(19, this.mInputConsumer));
                    this.mInputConsumer = null;
                }
            } else if (this.mInputConsumer == null) {
                this.mInputConsumer = this.mWindowManagerFuncs.createInputConsumer(this.mHandler.getLooper(), "nav_input_consumer", (channel, looper) -> new HideNavInputEventReceiver(channel, looper));
                InputManager.getInstance().setPointerIconType(0);
            }
            boolean updateSysUiVisibility = this.layoutNavigationBar(displayWidth, displayHeight, displayRotation, uiMode, overscanLeft, overscanRight, overscanBottom, dcf, navVisible |= !this.canHideNavigationBar(), navTranslucent, navAllowedHidden, statusBarExpandedNotKeyguard);
            if (updateSysUiVisibility |= this.layoutStatusBar(pf, df, of, vf, dcf, sysui, isKeyguardShowing)) {
                this.updateSystemUiVisibilityLw();
            }
        }
    }

    private boolean layoutStatusBar(Rect pf, Rect df, Rect of, Rect vf, Rect dcf, int sysui, boolean isKeyguardShowing) {
        if (this.mStatusBar != null) {
            boolean statusBarTranslucent;
            df.left = of.left = this.mUnrestrictedScreenLeft;
            pf.left = of.left;
            df.top = of.top = this.mUnrestrictedScreenTop;
            pf.top = of.top;
            df.right = of.right = this.mUnrestrictedScreenWidth + this.mUnrestrictedScreenLeft;
            pf.right = of.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenHeight + this.mUnrestrictedScreenTop;
            pf.bottom = of.bottom;
            vf.left = this.mStableLeft;
            vf.top = this.mStableTop;
            vf.right = this.mStableRight;
            vf.bottom = this.mStableBottom;
            this.mStatusBarLayer = this.mStatusBar.getSurfaceLayer();
            this.mStatusBar.computeFrameLw(pf, df, vf, vf, vf, dcf, vf, vf);
            this.mStableTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight;
            boolean statusBarTransient = (sysui & 0x4000000) != 0;
            boolean bl = statusBarTranslucent = (sysui & 0x40000008) != 0;
            if (!isKeyguardShowing) {
                statusBarTranslucent &= this.areTranslucentBarsAllowed();
            }
            if (this.mStatusBar.isVisibleLw() && !statusBarTransient) {
                this.mVoiceContentTop = this.mCurTop = (this.mDockTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight);
                this.mContentTop = this.mCurTop;
                this.mVoiceContentBottom = this.mCurBottom = this.mDockBottom;
                this.mContentBottom = this.mCurBottom;
                this.mVoiceContentLeft = this.mCurLeft = this.mDockLeft;
                this.mContentLeft = this.mCurLeft;
                this.mVoiceContentRight = this.mCurRight = this.mDockRight;
                this.mContentRight = this.mCurRight;
            }
            if (!(!this.mStatusBar.isVisibleLw() || this.mStatusBar.isAnimatingLw() || statusBarTransient || statusBarTranslucent || this.mStatusBarController.wasRecentlyTranslucent())) {
                this.mSystemTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight;
            }
            if (this.mStatusBarController.checkHiddenLw()) {
                return true;
            }
        }
        return false;
    }

    private boolean layoutNavigationBar(int displayWidth, int displayHeight, int displayRotation, int uiMode, int overscanLeft, int overscanRight, int overscanBottom, Rect dcf, boolean navVisible, boolean navTranslucent, boolean navAllowedHidden, boolean statusBarExpandedNotKeyguard) {
        if (this.mNavigationBar != null) {
            boolean transientNavBarShowing = this.mNavigationBarController.isTransientShowing();
            this.mNavigationBarPosition = this.navigationBarPosition(displayWidth, displayHeight, displayRotation);
            if (this.mNavigationBarPosition == 0) {
                int top = displayHeight - overscanBottom - this.getNavigationBarHeight(displayRotation, uiMode);
                mTmpNavigationFrame.set(0, top, displayWidth, displayHeight - overscanBottom);
                this.mStableBottom = this.mStableFullscreenBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                if (transientNavBarShowing) {
                    this.mNavigationBarController.setBarShowingLw(true);
                } else if (navVisible) {
                    this.mNavigationBarController.setBarShowingLw(true);
                    this.mDockBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                    this.mRestrictedScreenHeight = this.mDockBottom - this.mRestrictedScreenTop;
                    this.mRestrictedOverscanScreenHeight = this.mDockBottom - this.mRestrictedOverscanScreenTop;
                } else {
                    this.mNavigationBarController.setBarShowingLw(statusBarExpandedNotKeyguard);
                }
                if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                    this.mSystemBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                }
            } else if (this.mNavigationBarPosition == 1) {
                int left = displayWidth - overscanRight - this.getNavigationBarWidth(displayRotation, uiMode);
                mTmpNavigationFrame.set(left, 0, displayWidth - overscanRight, displayHeight);
                this.mStableRight = this.mStableFullscreenRight = PhoneWindowManager.mTmpNavigationFrame.left;
                if (transientNavBarShowing) {
                    this.mNavigationBarController.setBarShowingLw(true);
                } else if (navVisible) {
                    this.mNavigationBarController.setBarShowingLw(true);
                    this.mDockRight = PhoneWindowManager.mTmpNavigationFrame.left;
                    this.mRestrictedScreenWidth = this.mDockRight - this.mRestrictedScreenLeft;
                    this.mRestrictedOverscanScreenWidth = this.mDockRight - this.mRestrictedOverscanScreenLeft;
                } else {
                    this.mNavigationBarController.setBarShowingLw(statusBarExpandedNotKeyguard);
                }
                if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                    this.mSystemRight = PhoneWindowManager.mTmpNavigationFrame.left;
                }
            } else if (this.mNavigationBarPosition == 2) {
                int right = overscanLeft + this.getNavigationBarWidth(displayRotation, uiMode);
                mTmpNavigationFrame.set(overscanLeft, 0, right, displayHeight);
                this.mStableLeft = this.mStableFullscreenLeft = PhoneWindowManager.mTmpNavigationFrame.right;
                if (transientNavBarShowing) {
                    this.mNavigationBarController.setBarShowingLw(true);
                } else if (navVisible) {
                    this.mNavigationBarController.setBarShowingLw(true);
                    this.mRestrictedScreenLeft = this.mRestrictedOverscanScreenLeft = (this.mDockLeft = PhoneWindowManager.mTmpNavigationFrame.right);
                    this.mRestrictedScreenWidth = this.mDockRight - this.mRestrictedScreenLeft;
                    this.mRestrictedOverscanScreenWidth = this.mDockRight - this.mRestrictedOverscanScreenLeft;
                } else {
                    this.mNavigationBarController.setBarShowingLw(statusBarExpandedNotKeyguard);
                }
                if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                    this.mSystemLeft = PhoneWindowManager.mTmpNavigationFrame.right;
                }
            }
            this.mVoiceContentTop = this.mCurTop = this.mDockTop;
            this.mContentTop = this.mCurTop;
            this.mVoiceContentBottom = this.mCurBottom = this.mDockBottom;
            this.mContentBottom = this.mCurBottom;
            this.mVoiceContentLeft = this.mCurLeft = this.mDockLeft;
            this.mContentLeft = this.mCurLeft;
            this.mVoiceContentRight = this.mCurRight = this.mDockRight;
            this.mContentRight = this.mCurRight;
            this.mStatusBarLayer = this.mNavigationBar.getSurfaceLayer();
            this.mNavigationBar.computeFrameLw(mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, dcf, mTmpNavigationFrame, mTmpNavigationFrame);
            if (this.mNavigationBarController.checkHiddenLw()) {
                return true;
            }
        }
        return false;
    }

    private int navigationBarPosition(int displayWidth, int displayHeight, int displayRotation) {
        if (this.mNavigationBarCanMove && displayWidth > displayHeight) {
            if (displayRotation == 3) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getSystemDecorLayerLw() {
        if (this.mStatusBar != null && this.mStatusBar.isVisibleLw()) {
            return this.mStatusBar.getSurfaceLayer();
        }
        if (this.mNavigationBar != null && this.mNavigationBar.isVisibleLw()) {
            return this.mNavigationBar.getSurfaceLayer();
        }
        return 0;
    }

    @Override
    public void getContentRectLw(Rect r) {
        r.set(this.mContentLeft, this.mContentTop, this.mContentRight, this.mContentBottom);
    }

    void setAttachedWindowFrames(WindowManagerPolicy.WindowState win, int fl, int adjust, WindowManagerPolicy.WindowState attached, boolean insetDecors, Rect pf, Rect df, Rect of, Rect cf, Rect vf) {
        if (win.getSurfaceLayer() > this.mDockLayer && attached.getSurfaceLayer() < this.mDockLayer) {
            cf.left = vf.left = this.mDockLeft;
            of.left = vf.left;
            df.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            of.top = vf.top;
            df.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            of.right = vf.right;
            df.right = vf.right;
            cf.bottom = vf.bottom = this.mDockBottom;
            of.bottom = vf.bottom;
            df.bottom = vf.bottom;
        } else {
            if (adjust != 16) {
                cf.set((fl & 0x40000000) != 0 ? attached.getContentFrameLw() : attached.getOverscanFrameLw());
            } else {
                cf.set(attached.getContentFrameLw());
                if (attached.isVoiceInteraction()) {
                    if (cf.left < this.mVoiceContentLeft) {
                        cf.left = this.mVoiceContentLeft;
                    }
                    if (cf.top < this.mVoiceContentTop) {
                        cf.top = this.mVoiceContentTop;
                    }
                    if (cf.right > this.mVoiceContentRight) {
                        cf.right = this.mVoiceContentRight;
                    }
                    if (cf.bottom > this.mVoiceContentBottom) {
                        cf.bottom = this.mVoiceContentBottom;
                    }
                } else if (attached.getSurfaceLayer() < this.mDockLayer) {
                    if (cf.left < this.mContentLeft) {
                        cf.left = this.mContentLeft;
                    }
                    if (cf.top < this.mContentTop) {
                        cf.top = this.mContentTop;
                    }
                    if (cf.right > this.mContentRight) {
                        cf.right = this.mContentRight;
                    }
                    if (cf.bottom > this.mContentBottom) {
                        cf.bottom = this.mContentBottom;
                    }
                }
            }
            df.set(insetDecors ? attached.getDisplayFrameLw() : cf);
            of.set(insetDecors ? attached.getOverscanFrameLw() : cf);
            vf.set(attached.getVisibleFrameLw());
        }
        pf.set((fl & 0x100) == 0 ? attached.getFrameLw() : df);
    }

    private void applyStableConstraints(int sysui, int fl, Rect r) {
        if ((sysui & 0x100) != 0) {
            if ((fl & 0x400) != 0) {
                if (r.left < this.mStableFullscreenLeft) {
                    r.left = this.mStableFullscreenLeft;
                }
                if (r.top < this.mStableFullscreenTop) {
                    r.top = this.mStableFullscreenTop;
                }
                if (r.right > this.mStableFullscreenRight) {
                    r.right = this.mStableFullscreenRight;
                }
                if (r.bottom > this.mStableFullscreenBottom) {
                    r.bottom = this.mStableFullscreenBottom;
                }
            } else {
                if (r.left < this.mStableLeft) {
                    r.left = this.mStableLeft;
                }
                if (r.top < this.mStableTop) {
                    r.top = this.mStableTop;
                }
                if (r.right > this.mStableRight) {
                    r.right = this.mStableRight;
                }
                if (r.bottom > this.mStableBottom) {
                    r.bottom = this.mStableBottom;
                }
            }
        }
    }

    private boolean canReceiveInput(WindowManagerPolicy.WindowState win) {
        boolean notFocusable = (win.getAttrs().flags & 8) != 0;
        boolean altFocusableIm = (win.getAttrs().flags & 0x20000) != 0;
        boolean notFocusableForIm = notFocusable ^ altFocusableIm;
        return !notFocusableForIm;
    }

    @Override
    public void layoutWindowLw(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState attached) {
        boolean needsToOffsetInputMethodTarget;
        if (win == this.mStatusBar && !this.canReceiveInput(win) || win == this.mNavigationBar) {
            return;
        }
        WindowManager.LayoutParams attrs = win.getAttrs();
        boolean isDefaultDisplay = win.isDefaultDisplay();
        boolean bl = needsToOffsetInputMethodTarget = isDefaultDisplay && win == this.mLastInputMethodTargetWindow && this.mLastInputMethodWindow != null;
        if (needsToOffsetInputMethodTarget) {
            this.offsetInputMethodWindowLw(this.mLastInputMethodWindow);
        }
        int fl = PolicyControl.getWindowFlags(win, attrs);
        int pfl = attrs.privateFlags;
        int sim = attrs.softInputMode;
        int sysUiFl = PolicyControl.getSystemUiVisibility(win, null);
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect of = mTmpOverscanFrame;
        Rect cf = mTmpContentFrame;
        Rect vf = mTmpVisibleFrame;
        Rect dcf = mTmpDecorFrame;
        Rect sf = mTmpStableFrame;
        Rect osf = null;
        dcf.setEmpty();
        boolean hasNavBar = isDefaultDisplay && this.mHasNavigationBar && this.mNavigationBar != null && this.mNavigationBar.isVisibleLw();
        int adjust = sim & 0xF0;
        if (isDefaultDisplay) {
            sf.set(this.mStableLeft, this.mStableTop, this.mStableRight, this.mStableBottom);
        } else {
            sf.set(this.mOverscanLeft, this.mOverscanTop, this.mOverscanRight, this.mOverscanBottom);
        }
        if (!isDefaultDisplay) {
            if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, true, pf, df, of, cf, vf);
            } else {
                of.left = cf.left = this.mOverscanScreenLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mOverscanScreenTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            }
        } else if (attrs.type == 2011) {
            cf.left = vf.left = this.mDockLeft;
            of.left = vf.left;
            df.left = vf.left;
            pf.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            of.top = vf.top;
            df.top = vf.top;
            pf.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            of.right = vf.right;
            df.right = vf.right;
            pf.right = vf.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
            pf.bottom = of.bottom;
            cf.bottom = vf.bottom = this.mStableBottom;
            if (this.mStatusBar != null && this.mFocusedWindow == this.mStatusBar && this.canReceiveInput(this.mStatusBar)) {
                if (this.mNavigationBarPosition == 1) {
                    cf.right = vf.right = this.mStableRight;
                    of.right = vf.right;
                    df.right = vf.right;
                    pf.right = vf.right;
                } else if (this.mNavigationBarPosition == 2) {
                    cf.left = vf.left = this.mStableLeft;
                    of.left = vf.left;
                    df.left = vf.left;
                    pf.left = vf.left;
                }
            }
            attrs.gravity = 80;
            this.mDockLayer = win.getSurfaceLayer();
        } else if (attrs.type == 2031) {
            df.left = of.left = this.mUnrestrictedScreenLeft;
            pf.left = of.left;
            df.top = of.top = this.mUnrestrictedScreenTop;
            pf.top = of.top;
            df.right = of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
            pf.right = of.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
            pf.bottom = of.bottom;
            if (adjust != 16) {
                cf.left = this.mDockLeft;
                cf.top = this.mDockTop;
                cf.right = this.mDockRight;
                cf.bottom = this.mDockBottom;
            } else {
                cf.left = this.mContentLeft;
                cf.top = this.mContentTop;
                cf.right = this.mContentRight;
                cf.bottom = this.mContentBottom;
            }
            if (adjust != 48) {
                vf.left = this.mCurLeft;
                vf.top = this.mCurTop;
                vf.right = this.mCurRight;
                vf.bottom = this.mCurBottom;
            } else {
                vf.set(cf);
            }
        } else if (attrs.type == 2013) {
            this.layoutWallpaper(win, pf, df, of, cf);
        } else if (win == this.mStatusBar) {
            df.left = of.left = this.mUnrestrictedScreenLeft;
            pf.left = of.left;
            df.top = of.top = this.mUnrestrictedScreenTop;
            pf.top = of.top;
            df.right = of.right = this.mUnrestrictedScreenWidth + this.mUnrestrictedScreenLeft;
            pf.right = of.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenHeight + this.mUnrestrictedScreenTop;
            pf.bottom = of.bottom;
            cf.left = vf.left = this.mStableLeft;
            cf.top = vf.top = this.mStableTop;
            cf.right = vf.right = this.mStableRight;
            vf.bottom = this.mStableBottom;
            if (adjust == 16) {
                cf.bottom = this.mContentBottom;
            } else {
                cf.bottom = this.mDockBottom;
                vf.bottom = this.mContentBottom;
            }
        } else {
            boolean topAtRest;
            dcf.left = this.mSystemLeft;
            dcf.top = this.mSystemTop;
            dcf.right = this.mSystemRight;
            dcf.bottom = this.mSystemBottom;
            boolean inheritTranslucentDecor = (attrs.privateFlags & 0x200) != 0;
            boolean isAppWindow = attrs.type >= 1 && attrs.type <= 99;
            boolean bl2 = topAtRest = win == this.mTopFullscreenOpaqueWindowState && !win.isAnimatingLw();
            if (isAppWindow && !inheritTranslucentDecor && !topAtRest) {
                if ((sysUiFl & 4) == 0 && (fl & 0x400) == 0 && (fl & 0x4000000) == 0 && (fl & Integer.MIN_VALUE) == 0 && (pfl & 0x20000) == 0) {
                    dcf.top = this.mStableTop;
                }
                if ((fl & 0x8000000) == 0 && (sysUiFl & 2) == 0 && (fl & Integer.MIN_VALUE) == 0) {
                    dcf.bottom = this.mStableBottom;
                    dcf.right = this.mStableRight;
                }
            }
            if ((fl & 0x10100) == 65792) {
                if (attached != null) {
                    this.setAttachedWindowFrames(win, fl, adjust, attached, true, pf, df, of, cf, vf);
                } else {
                    if (attrs.type == 2014 || attrs.type == 2017) {
                        of.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                        df.left = of.left;
                        pf.left = of.left;
                        df.top = of.top = this.mUnrestrictedScreenTop;
                        pf.top = of.top;
                        of.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        df.right = of.right;
                        pf.right = of.right;
                        of.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                        df.bottom = of.bottom;
                        pf.bottom = of.bottom;
                    } else if ((fl & 0x2000000) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                        df.left = of.left = this.mOverscanScreenLeft;
                        pf.left = of.left;
                        df.top = of.top = this.mOverscanScreenTop;
                        pf.top = of.top;
                        df.right = of.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                        pf.right = of.right;
                        df.bottom = of.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                        pf.bottom = of.bottom;
                    } else if (this.canHideNavigationBar() && (sysUiFl & 0x200) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                        pf.left = df.left = this.mOverscanScreenLeft;
                        pf.top = df.top = this.mOverscanScreenTop;
                        pf.right = df.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                        pf.bottom = df.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                        of.left = this.mUnrestrictedScreenLeft;
                        of.top = this.mUnrestrictedScreenTop;
                        of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    } else {
                        pf.left = df.left = this.mRestrictedOverscanScreenLeft;
                        pf.top = df.top = this.mRestrictedOverscanScreenTop;
                        pf.right = df.right = this.mRestrictedOverscanScreenLeft + this.mRestrictedOverscanScreenWidth;
                        pf.bottom = df.bottom = this.mRestrictedOverscanScreenTop + this.mRestrictedOverscanScreenHeight;
                        of.left = this.mUnrestrictedScreenLeft;
                        of.top = this.mUnrestrictedScreenTop;
                        of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    }
                    if ((fl & 0x400) == 0) {
                        if (win.isVoiceInteraction()) {
                            cf.left = this.mVoiceContentLeft;
                            cf.top = this.mVoiceContentTop;
                            cf.right = this.mVoiceContentRight;
                            cf.bottom = this.mVoiceContentBottom;
                        } else if (adjust != 16) {
                            cf.left = this.mDockLeft;
                            cf.top = this.mDockTop;
                            cf.right = this.mDockRight;
                            cf.bottom = this.mDockBottom;
                        } else {
                            cf.left = this.mContentLeft;
                            cf.top = this.mContentTop;
                            cf.right = this.mContentRight;
                            cf.bottom = this.mContentBottom;
                        }
                    } else {
                        cf.left = this.mRestrictedScreenLeft;
                        cf.top = this.mRestrictedScreenTop;
                        cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                        cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    }
                    this.applyStableConstraints(sysUiFl, fl, cf);
                    if (adjust != 48) {
                        vf.left = this.mCurLeft;
                        vf.top = this.mCurTop;
                        vf.right = this.mCurRight;
                        vf.bottom = this.mCurBottom;
                    } else {
                        vf.set(cf);
                    }
                }
            } else if ((fl & 0x100) != 0 || (sysUiFl & 0x600) != 0) {
                if (attrs.type == 2014 || attrs.type == 2017 || attrs.type == 2020) {
                    cf.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                    of.left = cf.left;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mUnrestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    cf.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    of.right = cf.right;
                    df.right = cf.right;
                    pf.right = cf.right;
                    cf.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    of.bottom = cf.bottom;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2019 || attrs.type == 2024) {
                    df.left = of.left = this.mUnrestrictedScreenLeft;
                    pf.left = of.left;
                    df.top = of.top = this.mUnrestrictedScreenTop;
                    pf.top = of.top;
                    df.right = of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    pf.right = of.right;
                    df.bottom = of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    pf.bottom = of.bottom;
                } else if ((attrs.type == 2015 || attrs.type == 2021 || attrs.type == 2036) && (fl & 0x400) != 0) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2021) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if ((fl & 0x2000000) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (this.canHideNavigationBar() && (sysUiFl & 0x200) != 0 && (attrs.type == 2000 || attrs.type == 2005 || attrs.type == 2034 || attrs.type == 2033 || attrs.type >= 1 && attrs.type <= 1999)) {
                    of.left = cf.left = this.mUnrestrictedScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mUnrestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if ((sysUiFl & 0x400) != 0) {
                    df.left = of.left = this.mRestrictedScreenLeft;
                    pf.left = of.left;
                    df.top = of.top = this.mRestrictedScreenTop;
                    pf.top = of.top;
                    df.right = of.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                    pf.right = of.right;
                    df.bottom = of.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    pf.bottom = of.bottom;
                    if (adjust != 16) {
                        cf.left = this.mDockLeft;
                        cf.top = this.mDockTop;
                        cf.right = this.mDockRight;
                        cf.bottom = this.mDockBottom;
                    } else {
                        cf.left = this.mContentLeft;
                        cf.top = this.mContentTop;
                        cf.right = this.mContentRight;
                        cf.bottom = this.mContentBottom;
                    }
                } else {
                    of.left = cf.left = this.mRestrictedScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mRestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                }
                this.applyStableConstraints(sysUiFl, fl, cf);
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            } else if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, false, pf, df, of, cf, vf);
            } else if (attrs.type == 2014 || attrs.type == 2020) {
                of.left = cf.left = this.mRestrictedScreenLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mRestrictedScreenTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            } else if (attrs.type == 2005 || attrs.type == 2003) {
                of.left = cf.left = this.mStableLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mStableTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mStableRight;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mStableBottom;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            } else {
                pf.left = this.mContentLeft;
                pf.top = this.mContentTop;
                pf.right = this.mContentRight;
                pf.bottom = this.mContentBottom;
                if (win.isVoiceInteraction()) {
                    of.left = cf.left = this.mVoiceContentLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mVoiceContentTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mVoiceContentRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mVoiceContentBottom;
                    df.bottom = cf.bottom;
                } else if (adjust != 16) {
                    of.left = cf.left = this.mDockLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mDockTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mDockRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mDockBottom;
                    df.bottom = cf.bottom;
                } else {
                    of.left = cf.left = this.mContentLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mContentTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mContentRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mContentBottom;
                    df.bottom = cf.bottom;
                }
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            }
        }
        if ((fl & 0x200) != 0 && attrs.type != 2010 && !win.isInMultiWindowMode()) {
            df.top = -10000;
            df.left = -10000;
            df.bottom = 10000;
            df.right = 10000;
            if (attrs.type != 2013) {
                vf.top = -10000;
                vf.left = -10000;
                cf.top = -10000;
                cf.left = -10000;
                of.top = -10000;
                of.left = -10000;
                vf.bottom = 10000;
                vf.right = 10000;
                cf.bottom = 10000;
                cf.right = 10000;
                of.bottom = 10000;
                of.right = 10000;
            }
        }
        boolean useOutsets = this.shouldUseOutsets(attrs, fl);
        if (isDefaultDisplay && useOutsets) {
            osf = mTmpOutsetFrame;
            osf.set(cf.left, cf.top, cf.right, cf.bottom);
            int outset = ScreenShapeHelper.getWindowOutsetBottomPx(this.mContext.getResources());
            if (outset > 0) {
                int rotation = this.mDisplayRotation;
                if (rotation == 0) {
                    osf.bottom += outset;
                } else if (rotation == 1) {
                    osf.right += outset;
                } else if (rotation == 2) {
                    osf.top -= outset;
                } else if (rotation == 3) {
                    osf.left -= outset;
                }
            }
        }
        win.computeFrameLw(pf, df, of, cf, vf, dcf, sf, osf);
        if (attrs.type == 2011 && win.isVisibleLw() && !win.getGivenInsetsPendingLw()) {
            this.setLastInputMethodWindowLw(null, null);
            this.offsetInputMethodWindowLw(win);
        }
        if (attrs.type == 2031 && win.isVisibleLw() && !win.getGivenInsetsPendingLw()) {
            this.offsetVoiceInputWindowLw(win);
        }
    }

    private void layoutWallpaper(WindowManagerPolicy.WindowState win, Rect pf, Rect df, Rect of, Rect cf) {
        pf.left = df.left = this.mOverscanScreenLeft;
        pf.top = df.top = this.mOverscanScreenTop;
        pf.right = df.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
        pf.bottom = df.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
        of.left = cf.left = this.mUnrestrictedScreenLeft;
        of.top = cf.top = this.mUnrestrictedScreenTop;
        of.right = cf.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
        of.bottom = cf.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
    }

    private void offsetInputMethodWindowLw(WindowManagerPolicy.WindowState win) {
        int top = Math.max(win.getDisplayFrameLw().top, win.getContentFrameLw().top);
        if (this.mContentBottom > (top += win.getGivenContentInsetsLw().top)) {
            this.mContentBottom = top;
        }
        if (this.mVoiceContentBottom > top) {
            this.mVoiceContentBottom = top;
        }
        top = win.getVisibleFrameLw().top;
        if (this.mCurBottom > (top += win.getGivenVisibleInsetsLw().top)) {
            this.mCurBottom = top;
        }
    }

    private void offsetVoiceInputWindowLw(WindowManagerPolicy.WindowState win) {
        int top = Math.max(win.getDisplayFrameLw().top, win.getContentFrameLw().top);
        if (this.mVoiceContentBottom > (top += win.getGivenContentInsetsLw().top)) {
            this.mVoiceContentBottom = top;
        }
    }

    @Override
    public void finishLayoutLw() {
    }

    @Override
    public void beginPostLayoutPolicyLw(int displayWidth, int displayHeight) {
        this.mTopFullscreenOpaqueWindowState = null;
        this.mTopFullscreenOpaqueOrDimmingWindowState = null;
        this.mTopDockedOpaqueWindowState = null;
        this.mTopDockedOpaqueOrDimmingWindowState = null;
        this.mForceStatusBar = false;
        this.mForceStatusBarFromKeyguard = false;
        this.mForceStatusBarTransparent = false;
        this.mForcingShowNavBar = false;
        this.mForcingShowNavBarLayer = -1;
        this.mAllowLockscreenWhenOn = false;
        this.mShowingDream = false;
    }

    @Override
    public void applyPostLayoutPolicyLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs, WindowManagerPolicy.WindowState attached, WindowManagerPolicy.WindowState imeTarget) {
        boolean affectsSystemUi = win.canAffectSystemUiFlags();
        this.applyKeyguardPolicyLw(win, imeTarget);
        int fl = PolicyControl.getWindowFlags(win, attrs);
        if (this.mTopFullscreenOpaqueWindowState == null && affectsSystemUi && attrs.type == 2011) {
            this.mForcingShowNavBar = true;
            this.mForcingShowNavBarLayer = win.getSurfaceLayer();
        }
        if (attrs.type == 2000) {
            if ((attrs.privateFlags & 0x400) != 0) {
                this.mForceStatusBarFromKeyguard = true;
            }
            if ((attrs.privateFlags & 0x1000) != 0) {
                this.mForceStatusBarTransparent = true;
            }
        }
        boolean appWindow = attrs.type >= 1 && attrs.type < 2000;
        int stackId = win.getStackId();
        if (this.mTopFullscreenOpaqueWindowState == null && affectsSystemUi) {
            if ((fl & 0x800) != 0) {
                this.mForceStatusBar = true;
            }
            if (attrs.type == 2023 && (!this.mDreamingLockscreen || win.isVisibleLw() && win.hasDrawnLw())) {
                this.mShowingDream = true;
                appWindow = true;
            }
            if (appWindow && attached == null && this.isFullscreen(attrs) && ActivityManager.StackId.normallyFullscreenWindows(stackId)) {
                this.mTopFullscreenOpaqueWindowState = win;
                if (this.mTopFullscreenOpaqueOrDimmingWindowState == null) {
                    this.mTopFullscreenOpaqueOrDimmingWindowState = win;
                }
                if ((fl & 1) != 0) {
                    this.mAllowLockscreenWhenOn = true;
                }
            }
        }
        if (affectsSystemUi && win.getAttrs().type == 2031) {
            if (this.mTopFullscreenOpaqueWindowState == null) {
                this.mTopFullscreenOpaqueWindowState = win;
                if (this.mTopFullscreenOpaqueOrDimmingWindowState == null) {
                    this.mTopFullscreenOpaqueOrDimmingWindowState = win;
                }
            }
            if (this.mTopDockedOpaqueWindowState == null) {
                this.mTopDockedOpaqueWindowState = win;
                if (this.mTopDockedOpaqueOrDimmingWindowState == null) {
                    this.mTopDockedOpaqueOrDimmingWindowState = win;
                }
            }
        }
        if (this.mTopFullscreenOpaqueOrDimmingWindowState == null && affectsSystemUi && win.isDimming() && ActivityManager.StackId.normallyFullscreenWindows(stackId)) {
            this.mTopFullscreenOpaqueOrDimmingWindowState = win;
        }
        if (this.mTopDockedOpaqueWindowState == null && affectsSystemUi && appWindow && attached == null && this.isFullscreen(attrs) && stackId == 3) {
            this.mTopDockedOpaqueWindowState = win;
            if (this.mTopDockedOpaqueOrDimmingWindowState == null) {
                this.mTopDockedOpaqueOrDimmingWindowState = win;
            }
        }
        if (this.mTopDockedOpaqueOrDimmingWindowState == null && affectsSystemUi && win.isDimming() && stackId == 3) {
            this.mTopDockedOpaqueOrDimmingWindowState = win;
        }
    }

    private void applyKeyguardPolicyLw(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState imeTarget) {
        if (this.canBeHiddenByKeyguardLw(win)) {
            if (this.shouldBeHiddenByKeyguard(win, imeTarget)) {
                win.hideLw(false);
            } else {
                win.showLw(false);
            }
        }
    }

    private boolean isFullscreen(WindowManager.LayoutParams attrs) {
        return attrs.x == 0 && attrs.y == 0 && attrs.width == -1 && attrs.height == -1;
    }

    @Override
    public int finishPostLayoutPolicyLw() {
        WindowManager.LayoutParams lp;
        int changes = 0;
        boolean topIsFullscreen = false;
        WindowManager.LayoutParams layoutParams = lp = this.mTopFullscreenOpaqueWindowState != null ? this.mTopFullscreenOpaqueWindowState.getAttrs() : null;
        if (!this.mShowingDream) {
            this.mDreamingLockscreen = this.isKeyguardShowingAndNotOccluded();
            if (this.mDreamingSleepTokenNeeded) {
                this.mDreamingSleepTokenNeeded = false;
                this.mHandler.obtainMessage(15, 0, 1).sendToTarget();
            }
        } else if (!this.mDreamingSleepTokenNeeded) {
            this.mDreamingSleepTokenNeeded = true;
            this.mHandler.obtainMessage(15, 1, 1).sendToTarget();
        }
        if (this.mStatusBar != null) {
            boolean statusBarExpanded;
            boolean shouldBeTransparent;
            boolean bl = shouldBeTransparent = this.mForceStatusBarTransparent && !this.mForceStatusBar && !this.mForceStatusBarFromKeyguard;
            if (!shouldBeTransparent) {
                this.mStatusBarController.setShowTransparent(false);
            } else if (!this.mStatusBar.isVisibleLw()) {
                this.mStatusBarController.setShowTransparent(true);
            }
            WindowManager.LayoutParams statusBarAttrs = this.mStatusBar.getAttrs();
            boolean bl2 = statusBarExpanded = statusBarAttrs.height == -1 && statusBarAttrs.width == -1;
            if (this.mForceStatusBar || this.mForceStatusBarFromKeyguard || this.mForceStatusBarTransparent || statusBarExpanded) {
                if (this.mStatusBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
                boolean bl3 = topIsFullscreen = this.mTopIsFullscreen && this.mStatusBar.isAnimatingLw();
                if ((this.mForceStatusBarFromKeyguard || statusBarExpanded) && this.mStatusBarController.isTransientShowing()) {
                    this.mStatusBarController.updateVisibilityLw(false, this.mLastSystemUiFlags, this.mLastSystemUiFlags);
                }
                if (statusBarExpanded && this.mNavigationBar != null && this.mNavigationBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
            } else if (this.mTopFullscreenOpaqueWindowState != null) {
                int fl = PolicyControl.getWindowFlags(null, lp);
                boolean bl4 = topIsFullscreen = (fl & 0x400) != 0 || (this.mLastSystemUiFlags & 4) != 0;
                if (this.mStatusBarController.isTransientShowing()) {
                    if (this.mStatusBarController.setBarShowingLw(true)) {
                        changes |= 1;
                    }
                } else if (topIsFullscreen && !this.mWindowManagerInternal.isStackVisible(2) && !this.mWindowManagerInternal.isStackVisible(3)) {
                    if (this.mStatusBarController.setBarShowingLw(false)) {
                        changes |= 1;
                    }
                } else if (this.mStatusBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
            }
        }
        if (this.mTopIsFullscreen != topIsFullscreen) {
            if (!topIsFullscreen) {
                changes |= 1;
            }
            this.mTopIsFullscreen = topIsFullscreen;
        }
        if ((this.updateSystemUiVisibilityLw() & 0xC000800E) != 0) {
            changes |= 1;
        }
        if (this.mShowingDream != this.mLastShowingDream) {
            this.mLastShowingDream = this.mShowingDream;
            this.mWindowManagerFuncs.notifyShowingDreamChanged();
        }
        this.updateLockScreenTimeout();
        return changes;
    }

    private boolean setKeyguardOccludedLw(boolean isOccluded, boolean force) {
        boolean changed;
        boolean wasOccluded = this.mKeyguardOccluded;
        boolean showing = this.mKeyguardDelegate.isShowing();
        boolean bl = changed = wasOccluded != isOccluded || force;
        if (!isOccluded && changed && showing) {
            this.mKeyguardOccluded = false;
            this.mKeyguardDelegate.setOccluded(false, true);
            if (this.mStatusBar != null) {
                this.mStatusBar.getAttrs().privateFlags |= 0x400;
                if (!this.mKeyguardDelegate.hasLockscreenWallpaper()) {
                    this.mStatusBar.getAttrs().flags |= 0x100000;
                }
            }
            return true;
        }
        if (isOccluded && changed && showing) {
            this.mKeyguardOccluded = true;
            this.mKeyguardDelegate.setOccluded(true, false);
            if (this.mStatusBar != null) {
                this.mStatusBar.getAttrs().privateFlags &= 0xFFFFFBFF;
                this.mStatusBar.getAttrs().flags &= 0xFFEFFFFF;
            }
            return true;
        }
        if (changed) {
            this.mKeyguardOccluded = isOccluded;
            this.mKeyguardDelegate.setOccluded(isOccluded, false);
            return false;
        }
        return false;
    }

    private boolean isStatusBarKeyguard() {
        return this.mStatusBar != null && (this.mStatusBar.getAttrs().privateFlags & 0x400) != 0;
    }

    @Override
    public boolean allowAppAnimationsLw() {
        return !this.mShowingDream;
    }

    @Override
    public int focusChangedLw(WindowManagerPolicy.WindowState lastFocus, WindowManagerPolicy.WindowState newFocus) {
        this.mFocusedWindow = newFocus;
        if ((this.updateSystemUiVisibilityLw() & 0xC000800E) != 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        int newLidState;
        int n = newLidState = lidOpen ? 1 : 0;
        if (newLidState == this.mLidState) {
            return;
        }
        this.mLidState = newLidState;
        this.applyLidSwitchState();
        this.updateRotation(true);
        if (lidOpen) {
            this.wakeUp(SystemClock.uptimeMillis(), this.mAllowTheaterModeWakeFromLidSwitch, "android.policy:LID");
        } else if (!this.mLidControlsSleep) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    @Override
    public void notifyCameraLensCoverSwitchChanged(long whenNanos, boolean lensCovered) {
        int lensCoverState;
        int n = lensCoverState = lensCovered ? 1 : 0;
        if (this.mCameraLensCoverState == lensCoverState) {
            return;
        }
        if (this.mCameraLensCoverState == 1 && lensCoverState == 0) {
            boolean keyguardActive = this.mKeyguardDelegate == null ? false : this.mKeyguardDelegate.isShowing();
            Intent intent = keyguardActive ? new Intent("android.media.action.STILL_IMAGE_CAMERA_SECURE") : new Intent("android.media.action.STILL_IMAGE_CAMERA");
            this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromCameraLens, "android.policy:CAMERA_COVER");
            this.startActivityAsUser(intent, UserHandle.CURRENT_OR_SELF);
        }
        this.mCameraLensCoverState = lensCoverState;
    }

    void setHdmiPlugged(boolean plugged) {
        if (this.mHdmiPlugged != plugged) {
            this.mHdmiPlugged = plugged;
            this.updateRotation(true, true);
            Intent intent = new Intent("android.intent.action.HDMI_PLUGGED");
            intent.addFlags(0x4000000);
            intent.putExtra("state", plugged);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeHdmiState() {
        boolean plugged = false;
        if (new File("/sys/devices/virtual/switch/hdmi/state").exists()) {
            this.mHDMIObserver.startObserving("DEVPATH=/devices/virtual/switch/hdmi");
            String filename = "/sys/class/switch/hdmi/state";
            FileReader reader = null;
            try {
                reader = new FileReader("/sys/class/switch/hdmi/state");
                char[] buf = new char[15];
                int n = reader.read(buf);
                if (n > 1) {
                    plugged = 0 != Integer.parseInt(new String(buf, 0, n - 1));
                }
            }
            catch (IOException ex) {
                Slog.w(TAG, "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            catch (NumberFormatException ex) {
                Slog.w(TAG, "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        this.mHdmiPlugged = !plugged;
        this.setHdmiPlugged(!this.mHdmiPlugged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeScreenshot(final int screenshotType) {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            if (this.mScreenshotConnection != null) {
                return;
            }
            ComponentName serviceComponent = new ComponentName(SYSUI_PACKAGE, SYSUI_SCREENSHOT_SERVICE);
            Intent serviceIntent = new Intent();
            serviceIntent.setComponent(serviceComponent);
            ServiceConnection conn = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Object object = PhoneWindowManager.this.mScreenshotLock;
                    synchronized (object) {
                        if (PhoneWindowManager.this.mScreenshotConnection != this) {
                            return;
                        }
                        Messenger messenger = new Messenger(service);
                        Message msg = Message.obtain(null, screenshotType);
                        final 14 myConn = this;
                        Handler h = new Handler(PhoneWindowManager.this.mHandler.getLooper()){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleMessage(Message msg) {
                                Object object = PhoneWindowManager.this.mScreenshotLock;
                                synchronized (object) {
                                    if (PhoneWindowManager.this.mScreenshotConnection == myConn) {
                                        PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                                        PhoneWindowManager.this.mScreenshotConnection = null;
                                        PhoneWindowManager.this.mHandler.removeCallbacks(PhoneWindowManager.this.mScreenshotTimeout);
                                    }
                                }
                            }
                        };
                        msg.replyTo = new Messenger(h);
                        msg.arg2 = 0;
                        msg.arg1 = 0;
                        if (PhoneWindowManager.this.mStatusBar != null && PhoneWindowManager.this.mStatusBar.isVisibleLw()) {
                            msg.arg1 = 1;
                        }
                        if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBar.isVisibleLw()) {
                            msg.arg2 = 1;
                        }
                        try {
                            messenger.send(msg);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Object object = PhoneWindowManager.this.mScreenshotLock;
                    synchronized (object) {
                        if (PhoneWindowManager.this.mScreenshotConnection != null) {
                            PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                            PhoneWindowManager.this.mScreenshotConnection = null;
                            PhoneWindowManager.this.mHandler.removeCallbacks(PhoneWindowManager.this.mScreenshotTimeout);
                            PhoneWindowManager.this.notifyScreenshotError();
                        }
                    }
                }
            };
            if (this.mContext.bindServiceAsUser(serviceIntent, conn, 0x2000001, UserHandle.CURRENT)) {
                this.mScreenshotConnection = conn;
                this.mHandler.postDelayed(this.mScreenshotTimeout, 10000L);
            }
        }
    }

    private void notifyScreenshotError() {
        ComponentName errorComponent = new ComponentName(SYSUI_PACKAGE, SYSUI_SCREENSHOT_ERROR_RECEIVER);
        Intent errorIntent = new Intent("android.intent.action.USER_PRESENT");
        errorIntent.setComponent(errorComponent);
        errorIntent.addFlags(0x14000000);
        this.mContext.sendBroadcastAsUser(errorIntent, UserHandle.CURRENT);
    }

    @Override
    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        int result;
        boolean isWakeKey;
        boolean isInjected;
        if (!this.mSystemBooted) {
            return 0;
        }
        boolean interactive = (policyFlags & 0x20000000) != 0;
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        int keyCode = event.getKeyCode();
        boolean bl = isInjected = (policyFlags & 0x1000000) != 0;
        boolean keyguardActive = this.mKeyguardDelegate == null ? false : (interactive ? this.isKeyguardShowingAndNotOccluded() : this.mKeyguardDelegate.isShowing());
        boolean bl2 = isWakeKey = (policyFlags & 1) != 0 || event.isWakeKey();
        if (interactive || isInjected && !isWakeKey) {
            result = 1;
            isWakeKey = false;
            if (interactive) {
                if (keyCode == this.mPendingWakeKey && !down) {
                    result = 0;
                }
                this.mPendingWakeKey = -1;
            }
        } else if (!interactive && this.shouldDispatchInputWhenNonInteractive(event)) {
            result = 1;
            this.mPendingWakeKey = -1;
        } else {
            result = 0;
            if (!(!isWakeKey || down && this.isWakeKeyWhenScreenOff(keyCode))) {
                isWakeKey = false;
            }
            if (isWakeKey && down) {
                this.mPendingWakeKey = keyCode;
            }
        }
        if (PhoneWindowManager.isValidGlobalKey(keyCode) && this.mGlobalKeyManager.shouldHandleGlobalKey(keyCode, event)) {
            if (isWakeKey) {
                this.wakeUp(event.getEventTime(), this.mAllowTheaterModeWakeFromKey, "android.policy:KEY");
            }
            return result;
        }
        boolean useHapticFeedback = down && (policyFlags & 2) != 0 && event.getRepeatCount() == 0;
        switch (keyCode) {
            case 4: {
                if (down) {
                    this.interceptBackKeyDown();
                    break;
                }
                boolean handled = this.interceptBackKeyUp(event);
                if (!handled) break;
                result &= 0xFFFFFFFE;
                break;
            }
            case 24: 
            case 25: 
            case 164: {
                if (keyCode == 25) {
                    if (down) {
                        if (interactive && !this.mScreenshotChordVolumeDownKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mScreenshotChordVolumeDownKeyTriggered = true;
                            this.mScreenshotChordVolumeDownKeyTime = event.getDownTime();
                            this.mScreenshotChordVolumeDownKeyConsumed = false;
                            this.cancelPendingPowerKeyAction();
                            this.interceptScreenshotChord();
                            this.interceptAccessibilityShortcutChord();
                        }
                    } else {
                        this.mScreenshotChordVolumeDownKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                        this.cancelPendingAccessibilityShortcutAction();
                    }
                } else if (keyCode == 24) {
                    if (down) {
                        if (interactive && !this.mA11yShortcutChordVolumeUpKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mA11yShortcutChordVolumeUpKeyTriggered = true;
                            this.mA11yShortcutChordVolumeUpKeyTime = event.getDownTime();
                            this.mA11yShortcutChordVolumeUpKeyConsumed = false;
                            this.cancelPendingPowerKeyAction();
                            this.cancelPendingScreenshotChordAction();
                            this.interceptAccessibilityShortcutChord();
                        }
                    } else {
                        this.mA11yShortcutChordVolumeUpKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                        this.cancelPendingAccessibilityShortcutAction();
                    }
                }
                if (down) {
                    boolean isInCall;
                    TelecomManager telecomManager = this.getTelecommService();
                    if (telecomManager != null && telecomManager.isRinging()) {
                        Log.i(TAG, "interceptKeyBeforeQueueing: VOLUME key-down while ringing: Silence ringer!");
                        telecomManager.silenceRinger();
                        result &= 0xFFFFFFFE;
                        break;
                    }
                    int audioMode = 0;
                    try {
                        audioMode = PhoneWindowManager.getAudioService().getMode();
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Error getting AudioService in interceptKeyBeforeQueueing.", e);
                    }
                    boolean bl3 = isInCall = telecomManager != null && telecomManager.isInCall() || audioMode == 3;
                    if (isInCall && (result & 1) == 0) {
                        MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, Integer.MIN_VALUE, false);
                        break;
                    }
                }
                if (this.mUseTvRouting || this.mHandleVolumeKeysInWM) {
                    result |= 1;
                    break;
                }
                if ((result & 1) != 0) break;
                MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, Integer.MIN_VALUE, true);
                break;
            }
            case 6: {
                result &= 0xFFFFFFFE;
                if (down) {
                    TelecomManager telecomManager = this.getTelecommService();
                    boolean hungUp = false;
                    if (telecomManager != null) {
                        hungUp = telecomManager.endCall();
                    }
                    if (interactive && !hungUp) {
                        this.mEndCallKeyHandled = false;
                        this.mHandler.postDelayed(this.mEndCallLongPress, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                        break;
                    }
                    this.mEndCallKeyHandled = true;
                    break;
                }
                if (this.mEndCallKeyHandled) break;
                this.mHandler.removeCallbacks(this.mEndCallLongPress);
                if (canceled || (this.mEndcallBehavior & 1) != 0 && this.goHome() || (this.mEndcallBehavior & 2) == 0) break;
                this.mPowerManager.goToSleep(event.getEventTime(), 4, 0);
                isWakeKey = false;
                break;
            }
            case 26: {
                this.cancelPendingAccessibilityShortcutAction();
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (down) {
                    this.interceptPowerKeyDown(event, interactive);
                    break;
                }
                this.interceptPowerKeyUp(event, interactive, canceled);
                break;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                result &= 0xFFFFFFFE;
                this.interceptSystemNavigationKey(event);
                break;
            }
            case 223: {
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (!this.mPowerManager.isInteractive()) {
                    useHapticFeedback = false;
                }
                if (down) {
                    this.sleepPress(event.getEventTime());
                    break;
                }
                this.sleepRelease(event.getEventTime());
                break;
            }
            case 276: {
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (down) break;
                this.mPowerManagerInternal.setUserInactiveOverrideFromWindowManager();
                break;
            }
            case 224: {
                result &= 0xFFFFFFFE;
                isWakeKey = true;
                break;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                if (MediaSessionLegacyHelper.getHelper(this.mContext).isGlobalPriorityActive()) {
                    result &= 0xFFFFFFFE;
                }
                if ((result & 1) != 0) break;
                this.mBroadcastWakeLock.acquire();
                Message msg = this.mHandler.obtainMessage(3, new KeyEvent(event));
                msg.setAsynchronous(true);
                msg.sendToTarget();
                break;
            }
            case 5: {
                TelecomManager telecomManager;
                if (!down || (telecomManager = this.getTelecommService()) == null || !telecomManager.isRinging()) break;
                Log.i(TAG, "interceptKeyBeforeQueueing: CALL key-down while ringing: Answer the call!");
                telecomManager.acceptRingingCall();
                result &= 0xFFFFFFFE;
                break;
            }
            case 231: {
                if ((result & 1) != 0 || down) break;
                this.mBroadcastWakeLock.acquire();
                Message msg = this.mHandler.obtainMessage(12, keyguardActive ? 1 : 0, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
                break;
            }
            case 171: {
                if (this.mShortPressWindowBehavior != 1 || !this.mPictureInPictureVisible) break;
                if (!down) {
                    this.showPictureInPictureMenu(event);
                }
                result &= 0xFFFFFFFE;
            }
        }
        if (useHapticFeedback) {
            this.performHapticFeedbackLw(null, 1, false);
        }
        if (isWakeKey) {
            this.wakeUp(event.getEventTime(), this.mAllowTheaterModeWakeFromKey, "android.policy:KEY");
        }
        return result;
    }

    private void interceptSystemNavigationKey(KeyEvent event) {
        IStatusBarService sbar;
        if (!(event.getAction() != 1 || this.mAccessibilityManager.isEnabled() && this.mAccessibilityManager.sendFingerprintGesture(event.getKeyCode()) || !this.areSystemNavigationKeysEnabled() || (sbar = this.getStatusBarService()) == null)) {
            try {
                sbar.handleSystemNavigationKey(event.getKeyCode());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static boolean isValidGlobalKey(int keyCode) {
        switch (keyCode) {
            case 26: 
            case 223: 
            case 224: {
                return false;
            }
        }
        return true;
    }

    private boolean isWakeKeyWhenScreenOff(int keyCode) {
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                return this.mDockMode != 0;
            }
            case 27: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int interceptMotionBeforeQueueingNonInteractive(long whenNanos, int policyFlags) {
        if ((policyFlags & 1) != 0 && this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromMotion, "android.policy:MOTION")) {
            return 0;
        }
        if (this.shouldDispatchInputWhenNonInteractive(null)) {
            return 1;
        }
        if (this.isTheaterModeEnabled() && (policyFlags & 1) != 0) {
            this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromMotionWhenNotDreaming, "android.policy:MOTION");
        }
        return 0;
    }

    private boolean shouldDispatchInputWhenNonInteractive(KeyEvent event) {
        boolean displayOff;
        boolean bl = displayOff = this.mDisplay == null || this.mDisplay.getState() == 1;
        if (displayOff && !this.mHasFeatureWatch) {
            return false;
        }
        if (this.isKeyguardShowingAndNotOccluded() && !displayOff) {
            return true;
        }
        if (this.mHasFeatureWatch && event != null && (event.getKeyCode() == 4 || event.getKeyCode() == 264)) {
            return false;
        }
        IDreamManager dreamManager = PhoneWindowManager.getDreamManager();
        try {
            if (dreamManager != null && dreamManager.isDreaming()) {
                return true;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException when checking if dreaming", e);
        }
        return false;
    }

    private void dispatchDirectAudioEvent(KeyEvent event) {
        if (event.getAction() != 0) {
            return;
        }
        int keyCode = event.getKeyCode();
        int flags = 4101;
        String pkgName = this.mContext.getOpPackageName();
        switch (keyCode) {
            case 24: {
                try {
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(1, Integer.MIN_VALUE, flags, pkgName, TAG);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching volume up in dispatchTvAudioEvent.", e);
                }
                break;
            }
            case 25: {
                try {
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(-1, Integer.MIN_VALUE, flags, pkgName, TAG);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching volume down in dispatchTvAudioEvent.", e);
                }
                break;
            }
            case 164: {
                try {
                    if (event.getRepeatCount() != 0) break;
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(101, Integer.MIN_VALUE, flags, pkgName, TAG);
                    break;
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching mute in dispatchTvAudioEvent.", e);
                }
            }
        }
    }

    void dispatchMediaKeyWithWakeLock(KeyEvent event) {
        if (this.mHavePendingMediaKeyRepeatWithWakeLock) {
            this.mHandler.removeMessages(4);
            this.mHavePendingMediaKeyRepeatWithWakeLock = false;
            this.mBroadcastWakeLock.release();
        }
        this.dispatchMediaKeyWithWakeLockToAudioService(event);
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            this.mHavePendingMediaKeyRepeatWithWakeLock = true;
            Message msg = this.mHandler.obtainMessage(4, event);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getKeyRepeatTimeout());
        } else {
            this.mBroadcastWakeLock.release();
        }
    }

    void dispatchMediaKeyRepeatWithWakeLock(KeyEvent event) {
        this.mHavePendingMediaKeyRepeatWithWakeLock = false;
        KeyEvent repeatEvent = KeyEvent.changeTimeRepeat(event, SystemClock.uptimeMillis(), 1, event.getFlags() | 0x80);
        this.dispatchMediaKeyWithWakeLockToAudioService(repeatEvent);
        this.mBroadcastWakeLock.release();
    }

    void dispatchMediaKeyWithWakeLockToAudioService(KeyEvent event) {
        if (this.mActivityManagerInternal.isSystemReady()) {
            MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(event, true);
        }
    }

    void launchVoiceAssistWithWakeLock(boolean keyguardActive) {
        IDeviceIdleController dic = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        if (dic != null) {
            try {
                dic.exitIdle("voice-search");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        Intent voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
        voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", keyguardActive);
        this.startActivityAsUser(voiceIntent, UserHandle.CURRENT_OR_SELF);
        this.mBroadcastWakeLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestTransientBars(WindowManagerPolicy.WindowState swipeTarget) {
        Object object = this.mWindowManagerFuncs.getWindowManagerLock();
        synchronized (object) {
            boolean nb;
            if (!this.isUserSetupComplete()) {
                return;
            }
            boolean sb = this.mStatusBarController.checkShowTransientBarLw();
            boolean bl = nb = this.mNavigationBarController.checkShowTransientBarLw() && !PhoneWindowManager.isNavBarEmpty(this.mLastSystemUiFlags);
            if (sb || nb) {
                if (!nb && swipeTarget == this.mNavigationBar) {
                    return;
                }
                if (sb) {
                    this.mStatusBarController.showTransient();
                }
                if (nb) {
                    this.mNavigationBarController.showTransient();
                }
                this.mImmersiveModeConfirmation.confirmCurrentPrompt();
                this.updateSystemUiVisibilityLw();
            }
        }
    }

    @Override
    public void startedGoingToSleep(int why) {
        this.mCameraGestureTriggeredDuringGoingToSleep = false;
        this.mGoingToSleep = true;
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onStartedGoingToSleep(why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishedGoingToSleep(int why) {
        EventLog.writeEvent(70000, 0);
        MetricsLogger.histogram(this.mContext, "screen_timeout", this.mLockScreenTimeout / 1000);
        this.mGoingToSleep = false;
        Object object = this.mLock;
        synchronized (object) {
            this.mAwake = false;
            this.updateWakeGestureListenerLp();
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onFinishedGoingToSleep(why, this.mCameraGestureTriggeredDuringGoingToSleep);
        }
        this.mCameraGestureTriggeredDuringGoingToSleep = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startedWakingUp() {
        EventLog.writeEvent(70000, 1);
        Object object = this.mLock;
        synchronized (object) {
            this.mAwake = true;
            this.updateWakeGestureListenerLp();
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onStartedWakingUp();
        }
    }

    @Override
    public void finishedWakingUp() {
    }

    private void wakeUpFromPowerKey(long eventTime) {
        this.wakeUp(eventTime, this.mAllowTheaterModeWakeFromPowerKey, "android.policy:POWER");
    }

    private boolean wakeUp(long wakeTime, boolean wakeInTheaterMode, String reason) {
        boolean theaterModeEnabled = this.isTheaterModeEnabled();
        if (!wakeInTheaterMode && theaterModeEnabled) {
            return false;
        }
        if (theaterModeEnabled) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 0);
        }
        this.mPowerManager.wakeUp(wakeTime, reason);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishKeyguardDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mScreenOnEarly || this.mKeyguardDrawComplete) {
                return;
            }
            this.mKeyguardDrawComplete = true;
            if (this.mKeyguardDelegate != null) {
                this.mHandler.removeMessages(6);
            }
            this.mWindowManagerDrawComplete = false;
        }
        this.mWindowManagerInternal.waitForAllWindowsDrawn(this.mWindowManagerDrawCallback, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurnedOff() {
        this.updateScreenOffSleepToken(true);
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = false;
            this.mScreenOnFully = false;
            this.mKeyguardDrawComplete = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = null;
            this.updateOrientationListenerLp();
            if (this.mKeyguardDelegate != null) {
                this.mKeyguardDelegate.onScreenTurnedOff();
            }
        }
        this.reportScreenStateToVrManager(false);
    }

    private long getKeyguardDrawnTimeout() {
        boolean bootCompleted = LocalServices.getService(SystemServiceManager.class).isBootCompleted();
        return bootCompleted ? 1000L : 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurningOn(WindowManagerPolicy.ScreenOnListener screenOnListener) {
        this.updateScreenOffSleepToken(false);
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = true;
            this.mScreenOnFully = false;
            this.mKeyguardDrawComplete = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = screenOnListener;
            if (this.mKeyguardDelegate != null) {
                this.mHandler.removeMessages(6);
                this.mHandler.sendEmptyMessageDelayed(6, this.getKeyguardDrawnTimeout());
                this.mKeyguardDelegate.onScreenTurningOn(this.mKeyguardDrawnCallback);
            } else {
                this.finishKeyguardDrawn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurnedOn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null) {
                this.mKeyguardDelegate.onScreenTurnedOn();
            }
        }
        this.reportScreenStateToVrManager(true);
    }

    @Override
    public void screenTurningOff(WindowManagerPolicy.ScreenOffListener screenOffListener) {
        this.mWindowManagerFuncs.screenTurningOff(screenOffListener);
    }

    private void reportScreenStateToVrManager(boolean isScreenOn) {
        if (this.mVrManagerInternal == null) {
            return;
        }
        this.mVrManagerInternal.onScreenStateChanged(isScreenOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWindowsDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mScreenOnEarly || this.mWindowManagerDrawComplete) {
                return;
            }
            this.mWindowManagerDrawComplete = true;
        }
        this.finishScreenTurningOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishScreenTurningOn() {
        boolean enableScreen;
        WindowManagerPolicy.ScreenOnListener listener;
        Object object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLp();
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mScreenOnFully || !this.mScreenOnEarly || !this.mWindowManagerDrawComplete || this.mAwake && !this.mKeyguardDrawComplete) {
                return;
            }
            listener = this.mScreenOnListener;
            this.mScreenOnListener = null;
            this.mScreenOnFully = true;
            if (!this.mKeyguardDrawnOnce && this.mAwake) {
                this.mKeyguardDrawnOnce = true;
                enableScreen = true;
                if (this.mBootMessageNeedsHiding) {
                    this.mBootMessageNeedsHiding = false;
                    this.hideBootMessages();
                }
            } else {
                enableScreen = false;
            }
        }
        if (listener != null) {
            listener.onScreenOn();
        }
        if (enableScreen) {
            try {
                this.mWindowManager.enableScreenIfNeeded();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHideBootMessage() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mKeyguardDrawnOnce) {
                this.mBootMessageNeedsHiding = true;
                return;
            }
        }
        if (this.mBootMsgDialog != null) {
            this.mBootMsgDialog.dismiss();
            this.mBootMsgDialog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScreenOn() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mScreenOnEarly;
        }
    }

    @Override
    public void enableKeyguard(boolean enabled) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setKeyguardEnabled(enabled);
        }
    }

    @Override
    public void exitKeyguardSecurely(WindowManagerPolicy.OnKeyguardExitResult callback) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.verifyUnlock(callback);
        }
    }

    @Override
    public boolean isKeyguardShowingAndNotOccluded() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isShowing() && !this.mKeyguardOccluded;
    }

    @Override
    public boolean isKeyguardTrustedLw() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isTrusted();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.keyguardOn();
    }

    @Override
    public boolean isKeyguardSecure(int userId) {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isSecure(userId);
    }

    @Override
    public boolean isKeyguardOccluded() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardOccluded;
    }

    @Override
    public boolean inKeyguardRestrictedKeyInputMode() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isInputRestricted();
    }

    @Override
    public void dismissKeyguardLw(IKeyguardDismissCallback callback) {
        if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.isShowing()) {
            this.mKeyguardDelegate.dismiss(callback);
        } else if (callback != null) {
            try {
                callback.onDismissError();
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to call callback", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardDrawnLw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mKeyguardDrawnOnce;
        }
    }

    @Override
    public boolean isShowingDreamLw() {
        return this.mShowingDream;
    }

    @Override
    public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
    }

    @Override
    public void getStableInsetsLw(int displayRotation, int displayWidth, int displayHeight, Rect outInsets) {
        outInsets.setEmpty();
        this.getNonDecorInsetsLw(displayRotation, displayWidth, displayHeight, outInsets);
        outInsets.top = this.mStatusBarHeight;
    }

    @Override
    public void getNonDecorInsetsLw(int displayRotation, int displayWidth, int displayHeight, Rect outInsets) {
        outInsets.setEmpty();
        if (this.mHasNavigationBar) {
            int position = this.navigationBarPosition(displayWidth, displayHeight, displayRotation);
            if (position == 0) {
                outInsets.bottom = this.getNavigationBarHeight(displayRotation, this.mUiMode);
            } else if (position == 1) {
                outInsets.right = this.getNavigationBarWidth(displayRotation, this.mUiMode);
            } else if (position == 2) {
                outInsets.left = this.getNavigationBarWidth(displayRotation, this.mUiMode);
            }
        }
    }

    @Override
    public boolean isNavBarForcedShownLw(WindowManagerPolicy.WindowState windowState) {
        return this.mForceShowSystemBars;
    }

    @Override
    public boolean isDockSideAllowed(int dockSide) {
        if (!this.mNavigationBarCanMove) {
            return dockSide == 2 || dockSide == 1 || dockSide == 3;
        }
        return dockSide == 2 || dockSide == 1;
    }

    void sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.mContext, null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindow.sendCloseSystemWindows(this.mContext, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rotationForOrientationLw(int orientation, int lastRotation) {
        if (this.mForceDefaultOrientation) {
            return 0;
        }
        Object object = this.mLock;
        synchronized (object) {
            int preferredRotation;
            int sensorRotation = this.mOrientationListener.getProposedRotation();
            if (sensorRotation < 0) {
                sensorRotation = lastRotation;
            }
            if (this.mLidState == 1 && this.mLidOpenRotation >= 0) {
                preferredRotation = this.mLidOpenRotation;
            } else if (this.mDockMode == 2 && (this.mCarDockEnablesAccelerometer || this.mCarDockRotation >= 0)) {
                preferredRotation = this.mCarDockEnablesAccelerometer ? sensorRotation : this.mCarDockRotation;
            } else if (!(this.mDockMode != 1 && this.mDockMode != 3 && this.mDockMode != 4 || !this.mDeskDockEnablesAccelerometer && this.mDeskDockRotation < 0)) {
                preferredRotation = this.mDeskDockEnablesAccelerometer ? sensorRotation : this.mDeskDockRotation;
            } else if (this.mHdmiPlugged && this.mDemoHdmiRotationLock) {
                preferredRotation = this.mDemoHdmiRotation;
            } else if (this.mHdmiPlugged && this.mDockMode == 0 && this.mUndockedHdmiRotation >= 0) {
                preferredRotation = this.mUndockedHdmiRotation;
            } else if (this.mDemoRotationLock) {
                preferredRotation = this.mDemoRotation;
            } else if (orientation == 14) {
                preferredRotation = lastRotation;
            } else if (!this.mSupportAutoRotation) {
                preferredRotation = -1;
            } else if (this.mUserRotationMode == 0 && (orientation == 2 || orientation == -1 || orientation == 11 || orientation == 12 || orientation == 13) || orientation == 4 || orientation == 10 || orientation == 6 || orientation == 7) {
                if (this.mAllowAllRotations < 0) {
                    int n = this.mAllowAllRotations = this.mContext.getResources().getBoolean(17956870) ? 1 : 0;
                }
                preferredRotation = sensorRotation != 2 || this.mAllowAllRotations == 1 || orientation == 10 || orientation == 13 ? (this.mPersistentVrModeEnabled ? 0 : sensorRotation) : lastRotation;
            } else {
                preferredRotation = this.mUserRotationMode == 1 && orientation != 5 ? this.mUserRotation : -1;
            }
            switch (orientation) {
                case 1: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mPortraitRotation;
                }
                case 0: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 9: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mUpsideDownRotation;
                }
                case 8: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mSeascapeRotation;
                }
                case 6: 
                case 11: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isLandscapeOrSeascape(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 7: 
                case 12: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isAnyPortrait(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mPortraitRotation;
                }
            }
            if (preferredRotation >= 0) {
                return preferredRotation;
            }
            return 0;
        }
    }

    @Override
    public boolean rotationHasCompatibleMetricsLw(int orientation, int rotation) {
        switch (orientation) {
            case 1: 
            case 7: 
            case 9: {
                return this.isAnyPortrait(rotation);
            }
            case 0: 
            case 6: 
            case 8: {
                return this.isLandscapeOrSeascape(rotation);
            }
        }
        return true;
    }

    @Override
    public void setRotationLw(int rotation) {
        this.mOrientationListener.setCurrentRotation(rotation);
    }

    private boolean isLandscapeOrSeascape(int rotation) {
        return rotation == this.mLandscapeRotation || rotation == this.mSeascapeRotation;
    }

    private boolean isAnyPortrait(int rotation) {
        return rotation == this.mPortraitRotation || rotation == this.mUpsideDownRotation;
    }

    @Override
    public int getUserRotationMode() {
        return Settings.System.getIntForUser(this.mContext.getContentResolver(), "accelerometer_rotation", 0, -2) != 0 ? 0 : 1;
    }

    @Override
    public void setUserRotationMode(int mode, int rot) {
        ContentResolver res = this.mContext.getContentResolver();
        if (mode == 1) {
            Settings.System.putIntForUser(res, "user_rotation", rot, -2);
            Settings.System.putIntForUser(res, "accelerometer_rotation", 0, -2);
        } else {
            Settings.System.putIntForUser(res, "accelerometer_rotation", 1, -2);
        }
    }

    @Override
    public void setSafeMode(boolean safeMode) {
        this.mSafeMode = safeMode;
        this.performHapticFeedbackLw(null, safeMode ? 10001 : 10000, true);
    }

    static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindKeyguard() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardBound) {
                return;
            }
            this.mKeyguardBound = true;
        }
        this.mKeyguardDelegate.bindService(this.mContext);
    }

    @Override
    public void onSystemUiStarted() {
        this.bindKeyguard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mKeyguardDelegate.onSystemReady();
        this.mVrManagerInternal = LocalServices.getService(VrManagerInternal.class);
        if (this.mVrManagerInternal != null) {
            this.mVrManagerInternal.addPersistentVrModeStateListener(this.mPersistentVrModeListener);
        }
        this.readCameraLensCoverState();
        this.updateUiMode();
        Object object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLp();
            this.mSystemReady = true;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.updateSettings();
                }
            });
            if (this.mSystemBooted) {
                this.mKeyguardDelegate.onBootCompleted();
            }
        }
        this.mSystemGestures.systemReady();
        this.mImmersiveModeConfirmation.systemReady();
        this.mAutofillManagerInternal = LocalServices.getService(AutofillManagerInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemBooted() {
        this.bindKeyguard();
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemBooted = true;
            if (this.mSystemReady) {
                this.mKeyguardDelegate.onBootCompleted();
            }
        }
        this.startedWakingUp();
        this.screenTurningOn(null);
        this.screenTurnedOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDismissBootAnimation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mKeyguardDrawComplete;
        }
    }

    @Override
    public void showBootMessage(final CharSequence msg, boolean always) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PhoneWindowManager.this.mBootMsgDialog == null) {
                    int theme = PhoneWindowManager.this.mContext.getPackageManager().hasSystemFeature("android.software.leanback") ? 16974818 : 0;
                    PhoneWindowManager.this.mBootMsgDialog = new ProgressDialog(PhoneWindowManager.this.mContext, theme){

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchKeyShortcutEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTouchEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTrackballEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
                            return true;
                        }
                    };
                    if (PhoneWindowManager.this.mContext.getPackageManager().isUpgrade()) {
                        PhoneWindowManager.this.mBootMsgDialog.setTitle(17039472);
                    } else {
                        PhoneWindowManager.this.mBootMsgDialog.setTitle(17039464);
                    }
                    PhoneWindowManager.this.mBootMsgDialog.setProgressStyle(0);
                    PhoneWindowManager.this.mBootMsgDialog.setIndeterminate(true);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setType(2021);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().addFlags(258);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setDimAmount(1.0f);
                    WindowManager.LayoutParams lp = PhoneWindowManager.this.mBootMsgDialog.getWindow().getAttributes();
                    lp.screenOrientation = 5;
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setAttributes(lp);
                    PhoneWindowManager.this.mBootMsgDialog.setCancelable(false);
                    PhoneWindowManager.this.mBootMsgDialog.show();
                }
                PhoneWindowManager.this.mBootMsgDialog.setMessage(msg);
            }
        });
    }

    @Override
    public void hideBootMessages() {
        this.mHandler.sendEmptyMessage(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userActivity() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            if (this.mLockScreenTimerActive) {
                this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
            }
        }
    }

    @Override
    public void lockNow(Bundle options) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        this.mHandler.removeCallbacks(this.mScreenLockTimeout);
        if (options != null) {
            this.mScreenLockTimeout.setLockOptions(options);
        }
        this.mHandler.post(this.mScreenLockTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockScreenTimeout() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            boolean enable;
            boolean bl = enable = this.mAllowLockscreenWhenOn && this.mAwake && this.mKeyguardDelegate != null && this.mKeyguardDelegate.isSecure(this.mCurrentUserId);
            if (this.mLockScreenTimerActive != enable) {
                if (enable) {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                    this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
                } else {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                }
                this.mLockScreenTimerActive = enable;
            }
        }
    }

    private void updateDreamingSleepToken(boolean acquire) {
        if (acquire) {
            if (this.mDreamingSleepToken == null) {
                this.mDreamingSleepToken = this.mActivityManagerInternal.acquireSleepToken("Dream");
            }
        } else if (this.mDreamingSleepToken != null) {
            this.mDreamingSleepToken.release();
            this.mDreamingSleepToken = null;
        }
    }

    private void updateScreenOffSleepToken(boolean acquire) {
        if (acquire) {
            if (this.mScreenOffSleepToken == null) {
                this.mScreenOffSleepToken = this.mActivityManagerInternal.acquireSleepToken("ScreenOff");
            }
        } else if (this.mScreenOffSleepToken != null) {
            this.mScreenOffSleepToken.release();
            this.mScreenOffSleepToken = null;
        }
    }

    @Override
    public void enableScreenAfterBoot() {
        this.readLidState();
        this.applyLidSwitchState();
        this.updateRotation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLidSwitchState() {
        if (this.mLidState == 0 && this.mLidControlsSleep) {
            this.mPowerManager.goToSleep(SystemClock.uptimeMillis(), 3, 1);
        } else if (this.mLidState == 0 && this.mLidControlsScreenLock) {
            this.mWindowManagerFuncs.lockDeviceNow();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.updateWakeGestureListenerLp();
        }
    }

    void updateUiMode() {
        if (this.mUiModeManager == null) {
            this.mUiModeManager = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
        }
        try {
            this.mUiMode = this.mUiModeManager.getCurrentModeType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateRotation(boolean alwaysSendConfiguration) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration, forceRelayout);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Intent createHomeDockIntent() {
        Intent intent = null;
        if (this.mUiMode == 3) {
            if (this.mEnableCarDockHomeCapture) {
                intent = this.mCarDockIntent;
            }
        } else if (this.mUiMode != 2) {
            if (this.mUiMode == 6 && (this.mDockMode == 1 || this.mDockMode == 4 || this.mDockMode == 3)) {
                intent = this.mDeskDockIntent;
            } else if (this.mUiMode == 7) {
                intent = this.mVrHeadsetHomeIntent;
            }
        }
        if (intent == null) {
            return null;
        }
        ActivityInfo ai = null;
        ResolveInfo info = this.mContext.getPackageManager().resolveActivityAsUser(intent, 65664, this.mCurrentUserId);
        if (info != null) {
            ai = info.activityInfo;
        }
        if (ai != null && ai.metaData != null && ai.metaData.getBoolean("android.dock_home")) {
            intent = new Intent(intent);
            intent.setClassName(ai.packageName, ai.name);
            return intent;
        }
        return null;
    }

    void startDockOrHome(boolean fromHomeKey, boolean awakenFromDreams) {
        Intent intent;
        Intent dock;
        if (awakenFromDreams) {
            PhoneWindowManager.awakenDreams();
        }
        if ((dock = this.createHomeDockIntent()) != null) {
            try {
                if (fromHomeKey) {
                    dock.putExtra("android.intent.extra.FROM_HOME_KEY", fromHomeKey);
                }
                this.startActivityAsUser(dock, UserHandle.CURRENT);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
        if (fromHomeKey) {
            intent = new Intent(this.mHomeIntent);
            intent.putExtra("android.intent.extra.FROM_HOME_KEY", fromHomeKey);
        } else {
            intent = this.mHomeIntent;
        }
        this.startActivityAsUser(intent, UserHandle.CURRENT);
    }

    boolean goHome() {
        if (!this.isUserSetupComplete()) {
            Slog.i(TAG, "Not going home because user setup is in progress.");
            return false;
        }
        try {
            if (SystemProperties.getInt("persist.sys.uts-test-mode", 0) == 1) {
                Log.d(TAG, "UTS-TEST-MODE");
            } else {
                int result;
                ActivityManager.getService().stopAppSwitches();
                this.sendCloseSystemWindows();
                Intent dock = this.createHomeDockIntent();
                if (dock != null && (result = ActivityManager.getService().startActivityAsUser(null, null, dock, dock.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2)) == 1) {
                    return false;
                }
            }
            int result = ActivityManager.getService().startActivityAsUser(null, null, this.mHomeIntent, this.mHomeIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2);
            if (result == 1) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentOrientationLw(int newOrientation) {
        Object object = this.mLock;
        synchronized (object) {
            if (newOrientation != this.mCurrentAppOrientation) {
                this.mCurrentAppOrientation = newOrientation;
                this.updateOrientationListenerLp();
            }
        }
    }

    private boolean isTheaterModeEnabled() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "theater_mode_on", 0) == 1;
    }

    private boolean areSystemNavigationKeysEnabled() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "system_navigation_keys_enabled", 0, -2) == 1;
    }

    @Override
    public boolean performHapticFeedbackLw(WindowManagerPolicy.WindowState win, int effectId, boolean always) {
        String owningPackage;
        int owningUid;
        boolean hapticsDisabled;
        if (!this.mVibrator.hasVibrator()) {
            return false;
        }
        boolean bl = hapticsDisabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 0, -2) == 0;
        if (hapticsDisabled && !always) {
            return false;
        }
        VibrationEffect effect = this.getVibrationEffect(effectId);
        if (effect == null) {
            return false;
        }
        if (win != null) {
            owningUid = win.getOwningUid();
            owningPackage = win.getOwningPackage();
        } else {
            owningUid = Process.myUid();
            owningPackage = this.mContext.getOpPackageName();
        }
        this.mVibrator.vibrate(owningUid, owningPackage, effect, VIBRATION_ATTRIBUTES);
        return true;
    }

    private VibrationEffect getVibrationEffect(int effectId) {
        long[] pattern;
        switch (effectId) {
            case 1: {
                return VibrationEffect.get(0);
            }
            case 0: {
                pattern = this.mLongPressVibePattern;
                break;
            }
            case 3: {
                return VibrationEffect.get(0);
            }
            case 4: {
                pattern = this.mClockTickVibePattern;
                break;
            }
            case 5: {
                pattern = this.mCalendarDateVibePattern;
                break;
            }
            case 10000: {
                pattern = this.mSafeModeDisabledVibePattern;
                break;
            }
            case 10001: {
                pattern = this.mSafeModeEnabledVibePattern;
                break;
            }
            case 6: {
                pattern = this.mContextClickVibePattern;
                break;
            }
            default: {
                return null;
            }
        }
        if (pattern.length == 0) {
            return null;
        }
        if (pattern.length == 1) {
            return VibrationEffect.createOneShot(pattern[0], -1);
        }
        return VibrationEffect.createWaveform(pattern, -1);
    }

    @Override
    public void keepScreenOnStartedLw() {
    }

    @Override
    public void keepScreenOnStoppedLw() {
        if (this.isKeyguardShowingAndNotOccluded()) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    private int updateSystemUiVisibilityLw() {
        WindowManagerPolicy.WindowState winCandidate;
        WindowManagerPolicy.WindowState windowState = winCandidate = this.mFocusedWindow != null ? this.mFocusedWindow : this.mTopFullscreenOpaqueWindowState;
        if (winCandidate == null) {
            return 0;
        }
        if (winCandidate.getAttrs().token == this.mImmersiveModeConfirmation.getWindowToken()) {
            WindowManagerPolicy.WindowState windowState2 = winCandidate = this.isStatusBarKeyguard() ? this.mStatusBar : this.mTopFullscreenOpaqueWindowState;
            if (winCandidate == null) {
                return 0;
            }
        }
        final WindowManagerPolicy.WindowState win = winCandidate;
        if ((win.getAttrs().privateFlags & 0x400) != 0 && this.mKeyguardOccluded) {
            return 0;
        }
        int tmpVisibility = PolicyControl.getSystemUiVisibility(win, null) & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
        if (this.mForcingShowNavBar && win.getSurfaceLayer() < this.mForcingShowNavBarLayer) {
            tmpVisibility &= ~PolicyControl.adjustClearableFlags(win, 7);
        }
        final int fullscreenVisibility = this.updateLightStatusBarLw(0, this.mTopFullscreenOpaqueWindowState, this.mTopFullscreenOpaqueOrDimmingWindowState);
        final int dockedVisibility = this.updateLightStatusBarLw(0, this.mTopDockedOpaqueWindowState, this.mTopDockedOpaqueOrDimmingWindowState);
        this.mWindowManagerFuncs.getStackBounds(0, this.mNonDockedStackBounds);
        this.mWindowManagerFuncs.getStackBounds(3, this.mDockedStackBounds);
        final int visibility = this.updateSystemBarsLw(win, this.mLastSystemUiFlags, tmpVisibility);
        int diff = visibility ^ this.mLastSystemUiFlags;
        int fullscreenDiff = fullscreenVisibility ^ this.mLastFullscreenStackSysUiFlags;
        int dockedDiff = dockedVisibility ^ this.mLastDockedStackSysUiFlags;
        final boolean needsMenu = win.getNeedsMenuLw(this.mTopFullscreenOpaqueWindowState);
        if (diff == 0 && fullscreenDiff == 0 && dockedDiff == 0 && this.mLastFocusNeedsMenu == needsMenu && this.mFocusedApp == win.getAppToken() && this.mLastNonDockedStackBounds.equals(this.mNonDockedStackBounds) && this.mLastDockedStackBounds.equals(this.mDockedStackBounds)) {
            return 0;
        }
        this.mLastSystemUiFlags = visibility;
        this.mLastFullscreenStackSysUiFlags = fullscreenVisibility;
        this.mLastDockedStackSysUiFlags = dockedVisibility;
        this.mLastFocusNeedsMenu = needsMenu;
        this.mFocusedApp = win.getAppToken();
        final Rect fullscreenStackBounds = new Rect(this.mNonDockedStackBounds);
        final Rect dockedStackBounds = new Rect(this.mDockedStackBounds);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                StatusBarManagerInternal statusbar = PhoneWindowManager.this.getStatusBarManagerInternal();
                if (statusbar != null) {
                    statusbar.setSystemUiVisibility(visibility, fullscreenVisibility, dockedVisibility, -1, fullscreenStackBounds, dockedStackBounds, win.toString());
                    statusbar.topAppWindowChanged(needsMenu);
                }
            }
        });
        return diff;
    }

    private int updateLightStatusBarLw(int vis, WindowManagerPolicy.WindowState opaque, WindowManagerPolicy.WindowState opaqueOrDimming) {
        WindowManagerPolicy.WindowState statusColorWin;
        WindowManagerPolicy.WindowState windowState = statusColorWin = this.isStatusBarKeyguard() && !this.mKeyguardOccluded ? this.mStatusBar : opaqueOrDimming;
        if (statusColorWin != null) {
            if (statusColorWin == opaque) {
                vis &= 0xFFFFDFFF;
                vis |= PolicyControl.getSystemUiVisibility(statusColorWin, null) & 0x2000;
            } else if (statusColorWin != null && statusColorWin.isDimming()) {
                vis &= 0xFFFFDFFF;
            }
        }
        return vis;
    }

    private int updateLightNavigationBarLw(int vis, WindowManagerPolicy.WindowState opaque, WindowManagerPolicy.WindowState opaqueOrDimming) {
        WindowManagerPolicy.WindowState imeWin = this.mWindowManagerFuncs.getInputMethodWindowLw();
        WindowManagerPolicy.WindowState navColorWin = imeWin != null && imeWin.isVisibleLw() ? imeWin : opaqueOrDimming;
        if (navColorWin != null) {
            if (navColorWin == opaque) {
                vis &= 0xFFFFFFEF;
                vis |= PolicyControl.getSystemUiVisibility(navColorWin, null) & 0x10;
            } else if (navColorWin.isDimming() || navColorWin == imeWin) {
                vis &= 0xFFFFFFEF;
            }
        }
        return vis;
    }

    private boolean drawsSystemBarBackground(WindowManagerPolicy.WindowState win) {
        return win == null || (win.getAttrs().flags & Integer.MIN_VALUE) != 0;
    }

    private boolean forcesDrawStatusBarBackground(WindowManagerPolicy.WindowState win) {
        return win == null || (win.getAttrs().privateFlags & 0x20000) != 0;
    }

    private int updateSystemBarsLw(WindowManagerPolicy.WindowState win, int oldVis, int vis) {
        boolean navAllowedHidden;
        boolean denyTransientNav;
        boolean pendingPanic;
        boolean statusBarHasFocus;
        boolean dockedStackVisible = this.mWindowManagerInternal.isStackVisible(3);
        boolean freeformStackVisible = this.mWindowManagerInternal.isStackVisible(2);
        boolean resizing = this.mWindowManagerInternal.isDockedDividerResizing();
        this.mForceShowSystemBars = dockedStackVisible || freeformStackVisible || resizing;
        boolean forceOpaqueStatusBar = this.mForceShowSystemBars && !this.mForceStatusBarFromKeyguard;
        WindowManagerPolicy.WindowState fullscreenTransWin = this.isStatusBarKeyguard() && !this.mKeyguardOccluded ? this.mStatusBar : this.mTopFullscreenOpaqueWindowState;
        vis = this.mStatusBarController.applyTranslucentFlagLw(fullscreenTransWin, vis, oldVis);
        vis = this.mNavigationBarController.applyTranslucentFlagLw(fullscreenTransWin, vis, oldVis);
        int dockedVis = this.mStatusBarController.applyTranslucentFlagLw(this.mTopDockedOpaqueWindowState, 0, 0);
        boolean fullscreenDrawsStatusBarBackground = this.drawsSystemBarBackground(this.mTopFullscreenOpaqueWindowState) && (vis & 0x40000000) == 0 || this.forcesDrawStatusBarBackground(this.mTopFullscreenOpaqueWindowState);
        boolean dockedDrawsStatusBarBackground = this.drawsSystemBarBackground(this.mTopDockedOpaqueWindowState) && (dockedVis & 0x40000000) == 0 || this.forcesDrawStatusBarBackground(this.mTopDockedOpaqueWindowState);
        int type = win.getAttrs().type;
        boolean bl = statusBarHasFocus = type == 2000;
        if (statusBarHasFocus && !this.isStatusBarKeyguard()) {
            int flags = 14342;
            if (this.mKeyguardOccluded) {
                flags |= 0xC0000000;
            }
            vis = vis & ~flags | oldVis & flags;
        }
        if (fullscreenDrawsStatusBarBackground && dockedDrawsStatusBarBackground) {
            vis |= 8;
            vis &= 0xBFFFFFFF;
        } else if (!this.areTranslucentBarsAllowed() && fullscreenTransWin != this.mStatusBar || forceOpaqueStatusBar) {
            vis &= 0xBFFFFFF7;
        }
        vis = this.configureNavBarOpacity(vis, dockedStackVisible, freeformStackVisible, resizing);
        boolean immersiveSticky = (vis & 0x1000) != 0;
        boolean hideStatusBarWM = this.mTopFullscreenOpaqueWindowState != null && (PolicyControl.getWindowFlags(this.mTopFullscreenOpaqueWindowState, null) & 0x400) != 0;
        boolean hideStatusBarSysui = (vis & 4) != 0;
        boolean hideNavBarSysui = (vis & 2) != 0;
        boolean transientStatusBarAllowed = this.mStatusBar != null && (statusBarHasFocus || !this.mForceShowSystemBars && (hideStatusBarWM || hideStatusBarSysui && immersiveSticky));
        boolean transientNavBarAllowed = this.mNavigationBar != null && !this.mForceShowSystemBars && hideNavBarSysui && immersiveSticky;
        long now = SystemClock.uptimeMillis();
        boolean bl2 = pendingPanic = this.mPendingPanicGestureUptime != 0L && now - this.mPendingPanicGestureUptime <= 30000L;
        if (pendingPanic && hideNavBarSysui && !this.isStatusBarKeyguard() && this.mKeyguardDrawComplete) {
            this.mPendingPanicGestureUptime = 0L;
            this.mStatusBarController.showTransient();
            if (!PhoneWindowManager.isNavBarEmpty(vis)) {
                this.mNavigationBarController.showTransient();
            }
        }
        boolean denyTransientStatus = this.mStatusBarController.isTransientShowRequested() && !transientStatusBarAllowed && hideStatusBarSysui;
        boolean bl3 = denyTransientNav = this.mNavigationBarController.isTransientShowRequested() && !transientNavBarAllowed;
        if (denyTransientStatus || denyTransientNav || this.mForceShowSystemBars) {
            this.clearClearableFlagsLw();
            vis &= 0xFFFFFFF8;
        }
        boolean immersive = (vis & 0x800) != 0;
        immersiveSticky = (vis & 0x1000) != 0;
        boolean bl4 = navAllowedHidden = immersive || immersiveSticky;
        if (hideNavBarSysui && !navAllowedHidden && this.getWindowLayerLw(win) > this.getWindowLayerFromTypeLw(2022)) {
            vis &= 0xFFFFFFFD;
        }
        vis = this.mStatusBarController.updateVisibilityLw(transientStatusBarAllowed, oldVis, vis);
        boolean oldImmersiveMode = this.isImmersiveMode(oldVis);
        boolean newImmersiveMode = this.isImmersiveMode(vis);
        if (win != null && oldImmersiveMode != newImmersiveMode) {
            String pkg = win.getOwningPackage();
            this.mImmersiveModeConfirmation.immersiveModeChangedLw(pkg, newImmersiveMode, this.isUserSetupComplete(), PhoneWindowManager.isNavBarEmpty(win.getSystemUiVisibility()));
        }
        vis = this.mNavigationBarController.updateVisibilityLw(transientNavBarAllowed, oldVis, vis);
        vis = this.updateLightNavigationBarLw(vis, this.mTopFullscreenOpaqueWindowState, this.mTopFullscreenOpaqueOrDimmingWindowState);
        return vis;
    }

    private int configureNavBarOpacity(int visibility, boolean dockedStackVisible, boolean freeformStackVisible, boolean isDockedDividerResizing) {
        if (this.mNavBarOpacityMode == 0) {
            if (dockedStackVisible || freeformStackVisible || isDockedDividerResizing) {
                visibility = this.setNavBarOpaqueFlag(visibility);
            }
        } else if (this.mNavBarOpacityMode == 1) {
            visibility = isDockedDividerResizing ? this.setNavBarOpaqueFlag(visibility) : (freeformStackVisible ? this.setNavBarTranslucentFlag(visibility) : this.setNavBarOpaqueFlag(visibility));
        }
        if (!this.areTranslucentBarsAllowed()) {
            visibility &= Integer.MAX_VALUE;
        }
        return visibility;
    }

    private int setNavBarOpaqueFlag(int visibility) {
        return visibility &= 0x7FFF7FFF;
    }

    private int setNavBarTranslucentFlag(int visibility) {
        visibility &= 0xFFFF7FFF;
        return visibility |= Integer.MIN_VALUE;
    }

    private void clearClearableFlagsLw() {
        int newVal = this.mResettingSystemUiFlags | 7;
        if (newVal != this.mResettingSystemUiFlags) {
            this.mResettingSystemUiFlags = newVal;
            this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
        }
    }

    private boolean isImmersiveMode(int vis) {
        int flags = 6144;
        return this.mNavigationBar != null && (vis & 2) != 0 && (vis & 0x1800) != 0 && this.canHideNavigationBar();
    }

    private static boolean isNavBarEmpty(int systemUiFlags) {
        int disableNavigationBar = 0x1600000;
        return (systemUiFlags & 0x1600000) == 0x1600000;
    }

    private boolean areTranslucentBarsAllowed() {
        return this.mTranslucentDecorEnabled;
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mHasNavigationBar;
    }

    @Override
    public void setLastInputMethodWindowLw(WindowManagerPolicy.WindowState ime, WindowManagerPolicy.WindowState target) {
        this.mLastInputMethodWindow = ime;
        this.mLastInputMethodTargetWindow = target;
    }

    @Override
    public void setDismissImeOnBackKeyPressed(boolean newValue) {
        this.mDismissImeOnBackKeyPressed = newValue;
    }

    @Override
    public int getInputMethodWindowVisibleHeightLw() {
        return this.mDockBottom - this.mCurBottom;
    }

    @Override
    public void setCurrentUserLw(int newUserId) {
        StatusBarManagerInternal statusBar;
        this.mCurrentUserId = newUserId;
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setCurrentUser(newUserId);
        }
        if (this.mAccessibilityShortcutController != null) {
            this.mAccessibilityShortcutController.setCurrentUser(newUserId);
        }
        if ((statusBar = this.getStatusBarManagerInternal()) != null) {
            statusBar.setCurrentUser(newUserId);
        }
        this.setLastInputMethodWindowLw(null, null);
    }

    @Override
    public void setSwitchingUser(boolean switching) {
        this.mKeyguardDelegate.setSwitchingUser(switching);
    }

    @Override
    public boolean canMagnifyWindow(int windowType) {
        switch (windowType) {
            case 2011: 
            case 2012: 
            case 2019: 
            case 2027: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isTopLevelWindow(int windowType) {
        if (windowType >= 1000 && windowType <= 1999) {
            return windowType == 1003;
        }
        return true;
    }

    @Override
    public boolean shouldRotateSeamlessly(int oldRotation, int newRotation) {
        if (oldRotation == this.mUpsideDownRotation || newRotation == this.mUpsideDownRotation) {
            return false;
        }
        if (!this.mNavigationBarCanMove) {
            return false;
        }
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        if (delta == 2) {
            return false;
        }
        WindowManagerPolicy.WindowState w = this.mTopFullscreenOpaqueWindowState;
        if (w != this.mFocusedWindow) {
            return false;
        }
        return w != null && !w.isAnimatingLw() && (w.getAttrs().rotationAnimation == 2 || w.getAttrs().rotationAnimation == 3);
    }

    @Override
    public void dump(String prefix, PrintWriter pw, String[] args) {
        pw.print(prefix);
        pw.print("mSafeMode=");
        pw.print(this.mSafeMode);
        pw.print(" mSystemReady=");
        pw.print(this.mSystemReady);
        pw.print(" mSystemBooted=");
        pw.println(this.mSystemBooted);
        pw.print(prefix);
        pw.print("mLidState=");
        pw.print(this.mLidState);
        pw.print(" mLidOpenRotation=");
        pw.print(this.mLidOpenRotation);
        pw.print(" mCameraLensCoverState=");
        pw.print(this.mCameraLensCoverState);
        pw.print(" mHdmiPlugged=");
        pw.println(this.mHdmiPlugged);
        if (this.mLastSystemUiFlags != 0 || this.mResettingSystemUiFlags != 0 || this.mForceClearedSystemUiFlags != 0) {
            pw.print(prefix);
            pw.print("mLastSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mLastSystemUiFlags));
            pw.print(" mResettingSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mResettingSystemUiFlags));
            pw.print(" mForceClearedSystemUiFlags=0x");
            pw.println(Integer.toHexString(this.mForceClearedSystemUiFlags));
        }
        if (this.mLastFocusNeedsMenu) {
            pw.print(prefix);
            pw.print("mLastFocusNeedsMenu=");
            pw.println(this.mLastFocusNeedsMenu);
        }
        pw.print(prefix);
        pw.print("mWakeGestureEnabledSetting=");
        pw.println(this.mWakeGestureEnabledSetting);
        pw.print(prefix);
        pw.print("mSupportAutoRotation=");
        pw.println(this.mSupportAutoRotation);
        pw.print(prefix);
        pw.print("mUiMode=");
        pw.print(this.mUiMode);
        pw.print(" mDockMode=");
        pw.print(this.mDockMode);
        pw.print(" mEnableCarDockHomeCapture=");
        pw.print(this.mEnableCarDockHomeCapture);
        pw.print(" mCarDockRotation=");
        pw.print(this.mCarDockRotation);
        pw.print(" mDeskDockRotation=");
        pw.println(this.mDeskDockRotation);
        pw.print(prefix);
        pw.print("mUserRotationMode=");
        pw.print(this.mUserRotationMode);
        pw.print(" mUserRotation=");
        pw.print(this.mUserRotation);
        pw.print(" mAllowAllRotations=");
        pw.println(this.mAllowAllRotations);
        pw.print(prefix);
        pw.print("mCurrentAppOrientation=");
        pw.println(this.mCurrentAppOrientation);
        pw.print(prefix);
        pw.print("mCarDockEnablesAccelerometer=");
        pw.print(this.mCarDockEnablesAccelerometer);
        pw.print(" mDeskDockEnablesAccelerometer=");
        pw.println(this.mDeskDockEnablesAccelerometer);
        pw.print(prefix);
        pw.print("mLidKeyboardAccessibility=");
        pw.print(this.mLidKeyboardAccessibility);
        pw.print(" mLidNavigationAccessibility=");
        pw.print(this.mLidNavigationAccessibility);
        pw.print(" mLidControlsScreenLock=");
        pw.println(this.mLidControlsScreenLock);
        pw.print(" mLidControlsSleep=");
        pw.println(this.mLidControlsSleep);
        pw.print(prefix);
        pw.print(" mLongPressOnBackBehavior=");
        pw.println(this.mLongPressOnBackBehavior);
        pw.print(prefix);
        pw.print("mShortPressOnPowerBehavior=");
        pw.print(this.mShortPressOnPowerBehavior);
        pw.print(" mLongPressOnPowerBehavior=");
        pw.println(this.mLongPressOnPowerBehavior);
        pw.print(prefix);
        pw.print("mDoublePressOnPowerBehavior=");
        pw.print(this.mDoublePressOnPowerBehavior);
        pw.print(" mTriplePressOnPowerBehavior=");
        pw.println(this.mTriplePressOnPowerBehavior);
        pw.print(prefix);
        pw.print("mHasSoftInput=");
        pw.println(this.mHasSoftInput);
        pw.print(prefix);
        pw.print("mAwake=");
        pw.println(this.mAwake);
        pw.print(prefix);
        pw.print("mScreenOnEarly=");
        pw.print(this.mScreenOnEarly);
        pw.print(" mScreenOnFully=");
        pw.println(this.mScreenOnFully);
        pw.print(prefix);
        pw.print("mKeyguardDrawComplete=");
        pw.print(this.mKeyguardDrawComplete);
        pw.print(" mWindowManagerDrawComplete=");
        pw.println(this.mWindowManagerDrawComplete);
        pw.print(prefix);
        pw.print("mOrientationSensorEnabled=");
        pw.println(this.mOrientationSensorEnabled);
        pw.print(prefix);
        pw.print("mOverscanScreen=(");
        pw.print(this.mOverscanScreenLeft);
        pw.print(",");
        pw.print(this.mOverscanScreenTop);
        pw.print(") ");
        pw.print(this.mOverscanScreenWidth);
        pw.print("x");
        pw.println(this.mOverscanScreenHeight);
        if (this.mOverscanLeft != 0 || this.mOverscanTop != 0 || this.mOverscanRight != 0 || this.mOverscanBottom != 0) {
            pw.print(prefix);
            pw.print("mOverscan left=");
            pw.print(this.mOverscanLeft);
            pw.print(" top=");
            pw.print(this.mOverscanTop);
            pw.print(" right=");
            pw.print(this.mOverscanRight);
            pw.print(" bottom=");
            pw.println(this.mOverscanBottom);
        }
        pw.print(prefix);
        pw.print("mRestrictedOverscanScreen=(");
        pw.print(this.mRestrictedOverscanScreenLeft);
        pw.print(",");
        pw.print(this.mRestrictedOverscanScreenTop);
        pw.print(") ");
        pw.print(this.mRestrictedOverscanScreenWidth);
        pw.print("x");
        pw.println(this.mRestrictedOverscanScreenHeight);
        pw.print(prefix);
        pw.print("mUnrestrictedScreen=(");
        pw.print(this.mUnrestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mUnrestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mUnrestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mUnrestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mRestrictedScreen=(");
        pw.print(this.mRestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mRestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mRestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mRestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mStableFullscreen=(");
        pw.print(this.mStableFullscreenLeft);
        pw.print(",");
        pw.print(this.mStableFullscreenTop);
        pw.print(")-(");
        pw.print(this.mStableFullscreenRight);
        pw.print(",");
        pw.print(this.mStableFullscreenBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mStable=(");
        pw.print(this.mStableLeft);
        pw.print(",");
        pw.print(this.mStableTop);
        pw.print(")-(");
        pw.print(this.mStableRight);
        pw.print(",");
        pw.print(this.mStableBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mSystem=(");
        pw.print(this.mSystemLeft);
        pw.print(",");
        pw.print(this.mSystemTop);
        pw.print(")-(");
        pw.print(this.mSystemRight);
        pw.print(",");
        pw.print(this.mSystemBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mCur=(");
        pw.print(this.mCurLeft);
        pw.print(",");
        pw.print(this.mCurTop);
        pw.print(")-(");
        pw.print(this.mCurRight);
        pw.print(",");
        pw.print(this.mCurBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mContent=(");
        pw.print(this.mContentLeft);
        pw.print(",");
        pw.print(this.mContentTop);
        pw.print(")-(");
        pw.print(this.mContentRight);
        pw.print(",");
        pw.print(this.mContentBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mVoiceContent=(");
        pw.print(this.mVoiceContentLeft);
        pw.print(",");
        pw.print(this.mVoiceContentTop);
        pw.print(")-(");
        pw.print(this.mVoiceContentRight);
        pw.print(",");
        pw.print(this.mVoiceContentBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDock=(");
        pw.print(this.mDockLeft);
        pw.print(",");
        pw.print(this.mDockTop);
        pw.print(")-(");
        pw.print(this.mDockRight);
        pw.print(",");
        pw.print(this.mDockBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDockLayer=");
        pw.print(this.mDockLayer);
        pw.print(" mStatusBarLayer=");
        pw.println(this.mStatusBarLayer);
        pw.print(prefix);
        pw.print("mShowingDream=");
        pw.print(this.mShowingDream);
        pw.print(" mDreamingLockscreen=");
        pw.print(this.mDreamingLockscreen);
        pw.print(" mDreamingSleepToken=");
        pw.println(this.mDreamingSleepToken);
        if (this.mLastInputMethodWindow != null) {
            pw.print(prefix);
            pw.print("mLastInputMethodWindow=");
            pw.println(this.mLastInputMethodWindow);
        }
        if (this.mLastInputMethodTargetWindow != null) {
            pw.print(prefix);
            pw.print("mLastInputMethodTargetWindow=");
            pw.println(this.mLastInputMethodTargetWindow);
        }
        pw.print(prefix);
        pw.print("mDismissImeOnBackKeyPressed=");
        pw.println(this.mDismissImeOnBackKeyPressed);
        if (this.mStatusBar != null) {
            pw.print(prefix);
            pw.print("mStatusBar=");
            pw.print(this.mStatusBar);
            pw.print(" isStatusBarKeyguard=");
            pw.println(this.isStatusBarKeyguard());
        }
        if (this.mNavigationBar != null) {
            pw.print(prefix);
            pw.print("mNavigationBar=");
            pw.println(this.mNavigationBar);
        }
        if (this.mFocusedWindow != null) {
            pw.print(prefix);
            pw.print("mFocusedWindow=");
            pw.println(this.mFocusedWindow);
        }
        if (this.mFocusedApp != null) {
            pw.print(prefix);
            pw.print("mFocusedApp=");
            pw.println(this.mFocusedApp);
        }
        if (this.mTopFullscreenOpaqueWindowState != null) {
            pw.print(prefix);
            pw.print("mTopFullscreenOpaqueWindowState=");
            pw.println(this.mTopFullscreenOpaqueWindowState);
        }
        if (this.mTopFullscreenOpaqueOrDimmingWindowState != null) {
            pw.print(prefix);
            pw.print("mTopFullscreenOpaqueOrDimmingWindowState=");
            pw.println(this.mTopFullscreenOpaqueOrDimmingWindowState);
        }
        if (this.mForcingShowNavBar) {
            pw.print(prefix);
            pw.print("mForcingShowNavBar=");
            pw.println(this.mForcingShowNavBar);
            pw.print("mForcingShowNavBarLayer=");
            pw.println(this.mForcingShowNavBarLayer);
        }
        pw.print(prefix);
        pw.print("mTopIsFullscreen=");
        pw.print(this.mTopIsFullscreen);
        pw.print(" mKeyguardOccluded=");
        pw.println(this.mKeyguardOccluded);
        pw.print(" mKeyguardOccludedChanged=");
        pw.println(this.mKeyguardOccludedChanged);
        pw.print(" mPendingKeyguardOccluded=");
        pw.println(this.mPendingKeyguardOccluded);
        pw.print(prefix);
        pw.print("mForceStatusBar=");
        pw.print(this.mForceStatusBar);
        pw.print(" mForceStatusBarFromKeyguard=");
        pw.println(this.mForceStatusBarFromKeyguard);
        pw.print(prefix);
        pw.print("mHomePressed=");
        pw.println(this.mHomePressed);
        pw.print(prefix);
        pw.print("mAllowLockscreenWhenOn=");
        pw.print(this.mAllowLockscreenWhenOn);
        pw.print(" mLockScreenTimeout=");
        pw.print(this.mLockScreenTimeout);
        pw.print(" mLockScreenTimerActive=");
        pw.println(this.mLockScreenTimerActive);
        pw.print(prefix);
        pw.print("mEndcallBehavior=");
        pw.print(this.mEndcallBehavior);
        pw.print(" mIncallPowerBehavior=");
        pw.print(this.mIncallPowerBehavior);
        pw.print(" mIncallBackBehavior=");
        pw.print(this.mIncallBackBehavior);
        pw.print(" mLongPressOnHomeBehavior=");
        pw.println(this.mLongPressOnHomeBehavior);
        pw.print(prefix);
        pw.print("mLandscapeRotation=");
        pw.print(this.mLandscapeRotation);
        pw.print(" mSeascapeRotation=");
        pw.println(this.mSeascapeRotation);
        pw.print(prefix);
        pw.print("mPortraitRotation=");
        pw.print(this.mPortraitRotation);
        pw.print(" mUpsideDownRotation=");
        pw.println(this.mUpsideDownRotation);
        pw.print(prefix);
        pw.print("mDemoHdmiRotation=");
        pw.print(this.mDemoHdmiRotation);
        pw.print(" mDemoHdmiRotationLock=");
        pw.println(this.mDemoHdmiRotationLock);
        pw.print(prefix);
        pw.print("mUndockedHdmiRotation=");
        pw.println(this.mUndockedHdmiRotation);
        if (this.mHasFeatureLeanback) {
            pw.print(prefix);
            pw.print("mAccessibilityTvKey1Pressed=");
            pw.println(this.mAccessibilityTvKey1Pressed);
            pw.print(prefix);
            pw.print("mAccessibilityTvKey2Pressed=");
            pw.println(this.mAccessibilityTvKey2Pressed);
            pw.print(prefix);
            pw.print("mAccessibilityTvScheduled=");
            pw.println(this.mAccessibilityTvScheduled);
        }
        this.mGlobalKeyManager.dump(prefix, pw);
        this.mStatusBarController.dump(pw, prefix);
        this.mNavigationBarController.dump(pw, prefix);
        PolicyControl.dump(prefix, pw);
        if (this.mWakeGestureListener != null) {
            this.mWakeGestureListener.dump(pw, prefix);
        }
        if (this.mOrientationListener != null) {
            this.mOrientationListener.dump(pw, prefix);
        }
        if (this.mBurnInProtectionHelper != null) {
            this.mBurnInProtectionHelper.dump(prefix, pw);
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.dump(prefix, pw);
        }
    }

    static {
        sApplicationLaunchKeyCategories.append(64, "android.intent.category.APP_BROWSER");
        sApplicationLaunchKeyCategories.append(65, "android.intent.category.APP_EMAIL");
        sApplicationLaunchKeyCategories.append(207, "android.intent.category.APP_CONTACTS");
        sApplicationLaunchKeyCategories.append(208, "android.intent.category.APP_CALENDAR");
        sApplicationLaunchKeyCategories.append(209, "android.intent.category.APP_MUSIC");
        sApplicationLaunchKeyCategories.append(210, "android.intent.category.APP_CALCULATOR");
        mTmpParentFrame = new Rect();
        mTmpDisplayFrame = new Rect();
        mTmpOverscanFrame = new Rect();
        mTmpContentFrame = new Rect();
        mTmpVisibleFrame = new Rect();
        mTmpDecorFrame = new Rect();
        mTmpStableFrame = new Rect();
        mTmpNavigationFrame = new Rect();
        mTmpOutsetFrame = new Rect();
        mTmpRect = new Rect();
        WINDOW_TYPES_WHERE_HOME_DOESNT_WORK = new int[]{2003, 2010};
    }

    class ScreenLockTimeout
    implements Runnable {
        Bundle options;

        ScreenLockTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScreenLockTimeout screenLockTimeout = this;
            synchronized (screenLockTimeout) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.doKeyguardTimeout(this.options);
                }
                PhoneWindowManager.this.mLockScreenTimerActive = false;
                this.options = null;
            }
        }

        public void setLockOptions(Bundle options) {
            this.options = options;
        }
    }

    final class HideNavInputEventReceiver
    extends InputEventReceiver {
        public HideNavInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block11: {
                boolean handled = false;
                try {
                    MotionEvent motionEvent;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || (motionEvent = (MotionEvent)event).getAction() != 0) break block11;
                    boolean changed = false;
                    Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
                    synchronized (object) {
                        block12: {
                            if (PhoneWindowManager.this.mInputConsumer != null) break block12;
                            return;
                        }
                        int newVal = PhoneWindowManager.this.mResettingSystemUiFlags | 2 | 1 | 4;
                        if (PhoneWindowManager.this.mResettingSystemUiFlags != newVal) {
                            PhoneWindowManager.this.mResettingSystemUiFlags = newVal;
                            changed = true;
                        }
                        if (PhoneWindowManager.this.mForceClearedSystemUiFlags != (newVal = PhoneWindowManager.this.mForceClearedSystemUiFlags | 2)) {
                            PhoneWindowManager.this.mForceClearedSystemUiFlags = newVal;
                            changed = true;
                            PhoneWindowManager.this.mHandler.postDelayed(PhoneWindowManager.this.mClearHideNavigationFlag, 1000L);
                        }
                    }
                    if (changed) {
                        PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
                    }
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    private static class HdmiControl {
        private final HdmiPlaybackClient mClient;

        private HdmiControl(HdmiPlaybackClient client) {
            this.mClient = client;
        }

        public void turnOnTv() {
            if (this.mClient == null) {
                return;
            }
            this.mClient.oneTouchPlay(new HdmiPlaybackClient.OneTouchPlayCallback(){

                @Override
                public void onComplete(int result) {
                    if (result != 0) {
                        Log.w(PhoneWindowManager.TAG, "One touch play failed: " + result);
                    }
                }
            });
        }
    }

    private class ScreenshotRunnable
    implements Runnable {
        private int mScreenshotType = 1;

        private ScreenshotRunnable() {
        }

        public void setScreenshotType(int screenshotType) {
            this.mScreenshotType = screenshotType;
        }

        @Override
        public void run() {
            PhoneWindowManager.this.takeScreenshot(this.mScreenshotType);
        }
    }

    class MyOrientationListener
    extends WindowOrientationListener {
        private final Runnable mUpdateRotationRunnable;

        MyOrientationListener(Context context, Handler handler) {
            super(context, handler);
            this.mUpdateRotationRunnable = new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.mPowerManagerInternal.powerHint(2, 0);
                    PhoneWindowManager.this.updateRotation(false);
                }
            };
        }

        @Override
        public void onProposedRotationChanged(int rotation) {
            PhoneWindowManager.this.mHandler.post(this.mUpdateRotationRunnable);
        }
    }

    class MyWakeGestureListener
    extends WakeGestureListener {
        MyWakeGestureListener(Context context, Handler handler) {
            super(context, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWakeUp() {
            Object object = PhoneWindowManager.this.mLock;
            synchronized (object) {
                if (PhoneWindowManager.this.shouldEnableWakeGestureLp()) {
                    PhoneWindowManager.this.performHapticFeedbackLw(null, 1, false);
                    PhoneWindowManager.this.wakeUp(SystemClock.uptimeMillis(), PhoneWindowManager.this.mAllowTheaterModeWakeFromWakeGesture, "android.policy:GESTURE");
                }
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = PhoneWindowManager.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor("end_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("incall_power_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("incall_back_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("wake_gesture_enabled"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("accelerometer_rotation"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("user_rotation"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("pointer_location"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("immersive_mode_confirmations"), false, this, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("policy_control"), false, this, -1);
            PhoneWindowManager.this.updateSettings();
        }

        @Override
        public void onChange(boolean selfChange) {
            PhoneWindowManager.this.updateSettings();
            PhoneWindowManager.this.updateRotation(false);
        }
    }

    private class PolicyHandler
    extends Handler {
        private PolicyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PhoneWindowManager.this.enablePointerLocation();
                    break;
                }
                case 2: {
                    PhoneWindowManager.this.disablePointerLocation();
                    break;
                }
                case 3: {
                    PhoneWindowManager.this.dispatchMediaKeyWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 4: {
                    PhoneWindowManager.this.dispatchMediaKeyRepeatWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 9: {
                    PhoneWindowManager.this.showRecentApps(false, msg.arg1 != 0);
                    break;
                }
                case 10: {
                    PhoneWindowManager.this.showGlobalActionsInternal();
                    break;
                }
                case 5: {
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 6: {
                    Slog.w(PhoneWindowManager.TAG, "Keyguard drawn timeout. Setting mKeyguardDrawComplete");
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 7: {
                    PhoneWindowManager.this.finishWindowsDrawn();
                    break;
                }
                case 11: {
                    PhoneWindowManager.this.handleHideBootMessage();
                    break;
                }
                case 12: {
                    PhoneWindowManager.this.launchVoiceAssistWithWakeLock(msg.arg1 != 0);
                    break;
                }
                case 13: {
                    PhoneWindowManager.this.powerPress((Long)msg.obj, msg.arg1 != 0, msg.arg2);
                    PhoneWindowManager.this.finishPowerKeyPress();
                    break;
                }
                case 14: {
                    PhoneWindowManager.this.powerLongPress();
                    break;
                }
                case 15: {
                    PhoneWindowManager.this.updateDreamingSleepToken(msg.arg1 != 0);
                    break;
                }
                case 16: {
                    WindowManagerPolicy.WindowState targetBar;
                    WindowManagerPolicy.WindowState windowState = targetBar = msg.arg1 == 0 ? PhoneWindowManager.this.mStatusBar : PhoneWindowManager.this.mNavigationBar;
                    if (targetBar == null) break;
                    PhoneWindowManager.this.requestTransientBars(targetBar);
                    break;
                }
                case 17: {
                    PhoneWindowManager.this.showPictureInPictureMenuInternal();
                    break;
                }
                case 18: {
                    PhoneWindowManager.this.backLongPress();
                    PhoneWindowManager.this.finishBackKeyPress();
                    break;
                }
                case 19: {
                    PhoneWindowManager.this.disposeInputConsumer((WindowManagerPolicy.InputConsumer)msg.obj);
                    break;
                }
                case 20: {
                    PhoneWindowManager.this.backMultiPressAction((Long)msg.obj, msg.arg1);
                    PhoneWindowManager.this.finishBackKeyPress();
                    break;
                }
                case 21: {
                    PhoneWindowManager.this.accessibilityShortcutActivated();
                    break;
                }
                case 22: {
                    PhoneWindowManager.this.takeBugreport();
                    break;
                }
                case 23: {
                    if (!PhoneWindowManager.this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(false)) break;
                    PhoneWindowManager.this.accessibilityShortcutActivated();
                    break;
                }
                case 24: {
                    PhoneWindowManager.this.mAutofillManagerInternal.onBackKeyPressed();
                }
            }
        }
    }
}

