/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageParser;
import android.os.FileUtils;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.pm.CompilerStats;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PackageDexOptimizer {
    private static final String TAG = "PackageManager.DexOptimizer";
    static final String OAT_DIR_NAME = "oat";
    public static final int DEX_OPT_SKIPPED = 0;
    public static final int DEX_OPT_PERFORMED = 1;
    public static final int DEX_OPT_FAILED = -1;
    private static final long WAKELOCK_TIMEOUT_MS = 660000L;
    public static final String SKIP_SHARED_LIBRARY_CHECK = "&";
    @GuardedBy(value="mInstallLock")
    private final Installer mInstaller;
    private final Object mInstallLock;
    @GuardedBy(value="mInstallLock")
    private final PowerManager.WakeLock mDexoptWakeLock;
    private volatile boolean mSystemReady;

    PackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mDexoptWakeLock = powerManager.newWakeLock(1, wakeLockTag);
    }

    protected PackageDexOptimizer(PackageDexOptimizer from) {
        this.mInstaller = from.mInstaller;
        this.mInstallLock = from.mInstallLock;
        this.mDexoptWakeLock = from.mDexoptWakeLock;
        this.mSystemReady = from.mSystemReady;
    }

    static boolean canOptimizePackage(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performDexOpt(PackageParser.Package pkg, String[] sharedLibraries, String[] instructionSets, boolean checkProfiles, String targetCompilationFilter, CompilerStats.PackageStats packageStats, boolean isUsedByOtherApps) {
        if (!PackageDexOptimizer.canOptimizePackage(pkg)) {
            return 0;
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            int n;
            long acquireTime = this.acquireWakeLockLI(pkg.applicationInfo.uid);
            try {
                n = this.performDexOptLI(pkg, sharedLibraries, instructionSets, checkProfiles, targetCompilationFilter, packageStats, isUsedByOtherApps);
                this.releaseWakeLockLI(acquireTime);
            }
            catch (Throwable throwable) {
                this.releaseWakeLockLI(acquireTime);
                throw throwable;
            }
            return n;
        }
    }

    @GuardedBy(value="mInstallLock")
    private int performDexOptLI(PackageParser.Package pkg, String[] sharedLibraries, String[] targetInstructionSets, boolean checkForProfileUpdates, String targetCompilerFilter, CompilerStats.PackageStats packageStats, boolean isUsedByOtherApps) {
        String[] instructionSets = targetInstructionSets != null ? targetInstructionSets : InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
        List<String> paths = pkg.getAllCodePaths();
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        String compilerFilter = this.getRealCompilerFilter(pkg.applicationInfo, targetCompilerFilter, isUsedByOtherApps);
        boolean profileUpdated = checkForProfileUpdates && this.isProfileUpdated(pkg, sharedGid, compilerFilter);
        String sharedLibrariesPath = this.getSharedLibrariesPath(sharedLibraries);
        int dexoptFlags = this.getDexFlags(pkg, compilerFilter);
        String[] splitDependencies = this.getSplitDependencies(pkg);
        int result = 0;
        for (int i = 0; i < paths.size(); ++i) {
            if (i == 0 && (pkg.applicationInfo.flags & 4) == 0 || i != 0 && (pkg.splitFlags[i - 1] & 4) == 0) continue;
            String path = paths.get(i);
            String sharedLibrariesPathWithSplits = sharedLibrariesPath != null && splitDependencies[i] != null ? sharedLibrariesPath + ":" + splitDependencies[i] : (splitDependencies[i] != null ? splitDependencies[i] : sharedLibrariesPath);
            for (String dexCodeIsa : dexCodeInstructionSets) {
                int newResult = this.dexOptPath(pkg, path, dexCodeIsa, compilerFilter, profileUpdated, sharedLibrariesPathWithSplits, dexoptFlags, sharedGid, packageStats);
                if (result == -1 || newResult == 0) continue;
                result = newResult;
            }
        }
        return result;
    }

    @GuardedBy(value="mInstallLock")
    private int dexOptPath(PackageParser.Package pkg, String path, String isa, String compilerFilter, boolean profileUpdated, String sharedLibrariesPath, int dexoptFlags, int uid, CompilerStats.PackageStats packageStats) {
        int dexoptNeeded = this.getDexoptNeeded(path, isa, compilerFilter, profileUpdated);
        if (Math.abs(dexoptNeeded) == 0) {
            return 0;
        }
        String oatDir = this.createOatDirIfSupported(pkg, isa);
        Log.i(TAG, "Running dexopt (dexoptNeeded=" + dexoptNeeded + ") on: " + path + " pkg=" + pkg.applicationInfo.packageName + " isa=" + isa + " dexoptFlags=" + this.printDexoptFlags(dexoptFlags) + " target-filter=" + compilerFilter + " oatDir=" + oatDir + " sharedLibraries=" + sharedLibrariesPath);
        try {
            long startTime = System.currentTimeMillis();
            this.mInstaller.dexopt(path, uid, pkg.packageName, isa, dexoptNeeded, oatDir, dexoptFlags, compilerFilter, pkg.volumeUuid, sharedLibrariesPath, pkg.applicationInfo.seInfo);
            if (packageStats != null) {
                long endTime = System.currentTimeMillis();
                packageStats.setCompileTime(path, (int)(endTime - startTime));
            }
            return 1;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dexopt", e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dexOptSecondaryDexPath(ApplicationInfo info, String path, Set<String> isas, String compilerFilter, boolean isUsedByOtherApps) {
        Object object = this.mInstallLock;
        synchronized (object) {
            int n;
            long acquireTime = this.acquireWakeLockLI(info.uid);
            try {
                n = this.dexOptSecondaryDexPathLI(info, path, isas, compilerFilter, isUsedByOtherApps);
                this.releaseWakeLockLI(acquireTime);
            }
            catch (Throwable throwable) {
                this.releaseWakeLockLI(acquireTime);
                throw throwable;
            }
            return n;
        }
    }

    @GuardedBy(value="mInstallLock")
    private long acquireWakeLockLI(int uid) {
        if (!this.mSystemReady) {
            return -1L;
        }
        this.mDexoptWakeLock.setWorkSource(new WorkSource(uid));
        this.mDexoptWakeLock.acquire(660000L);
        return SystemClock.elapsedRealtime();
    }

    @GuardedBy(value="mInstallLock")
    private void releaseWakeLockLI(long acquireTime) {
        if (acquireTime < 0L) {
            return;
        }
        try {
            long duration;
            if (this.mDexoptWakeLock.isHeld()) {
                this.mDexoptWakeLock.release();
            }
            if ((duration = SystemClock.elapsedRealtime() - acquireTime) >= 660000L) {
                Slog.wtf(TAG, "WakeLock " + this.mDexoptWakeLock.getTag() + " time out. Operation took " + duration + " ms. Thread: " + Thread.currentThread().getName());
            }
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Error while releasing " + this.mDexoptWakeLock.getTag() + " lock", e);
        }
    }

    @GuardedBy(value="mInstallLock")
    private int dexOptSecondaryDexPathLI(ApplicationInfo info, String path, Set<String> isas, String compilerFilter, boolean isUsedByOtherApps) {
        compilerFilter = this.getRealCompilerFilter(info, compilerFilter, isUsedByOtherApps);
        int dexoptFlags = this.getDexFlags(info, compilerFilter) | 0x20;
        if (info.deviceProtectedDataDir != null && FileUtils.contains(info.deviceProtectedDataDir, path)) {
            dexoptFlags |= 0x100;
        } else if (info.credentialProtectedDataDir != null && FileUtils.contains(info.credentialProtectedDataDir, path)) {
            dexoptFlags |= 0x80;
        } else {
            Slog.e(TAG, "Could not infer CE/DE storage for package " + info.packageName);
            return -1;
        }
        Log.d(TAG, "Running dexopt on: " + path + " pkg=" + info.packageName + " isa=" + isas + " dexoptFlags=" + this.printDexoptFlags(dexoptFlags) + " target-filter=" + compilerFilter);
        try {
            for (String isa : isas) {
                this.mInstaller.dexopt(path, info.uid, info.packageName, isa, 0, null, dexoptFlags, compilerFilter, info.volumeUuid, SKIP_SHARED_LIBRARY_CHECK, info.seInfoUser);
            }
            return 1;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dexopt", e);
            return -1;
        }
    }

    protected int adjustDexoptNeeded(int dexoptNeeded) {
        return dexoptNeeded;
    }

    protected int adjustDexoptFlags(int dexoptFlags) {
        return dexoptFlags;
    }

    void dumpDexoptState(IndentingPrintWriter pw, PackageParser.Package pkg) {
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        for (String instructionSet : dexCodeInstructionSets) {
            pw.println("Instruction Set: " + instructionSet);
            pw.increaseIndent();
            for (String path : paths) {
                String status = null;
                try {
                    status = DexFile.getDexFileStatus(path, instructionSet);
                }
                catch (IOException ioe) {
                    status = "[Exception]: " + ioe.getMessage();
                }
                pw.println("path: " + path);
                pw.println("status: " + status);
            }
            pw.decreaseIndent();
        }
    }

    private String getRealCompilerFilter(ApplicationInfo info, String targetCompilerFilter, boolean isUsedByOtherApps) {
        boolean vmSafeMode;
        int flags = info.flags;
        boolean bl = vmSafeMode = (flags & 0x4000) != 0;
        if (vmSafeMode) {
            return DexFile.getSafeModeCompilerFilter(targetCompilerFilter);
        }
        if (DexFile.isProfileGuidedCompilerFilter(targetCompilerFilter) && isUsedByOtherApps) {
            return DexFile.getNonProfileGuidedCompilerFilter(targetCompilerFilter);
        }
        return targetCompilerFilter;
    }

    private int getDexFlags(PackageParser.Package pkg, String compilerFilter) {
        return this.getDexFlags(pkg.applicationInfo, compilerFilter);
    }

    private int getDexFlags(ApplicationInfo info, String compilerFilter) {
        int flags = info.flags;
        boolean debuggable = (flags & 2) != 0;
        boolean isProfileGuidedFilter = DexFile.isProfileGuidedCompilerFilter(compilerFilter);
        boolean isPublic = !info.isForwardLocked() && !isProfileGuidedFilter;
        int profileFlag = isProfileGuidedFilter ? 16 : 0;
        int dexFlags = (isPublic ? 2 : 0) | (debuggable ? 4 : 0) | profileFlag | 8;
        return this.adjustDexoptFlags(dexFlags);
    }

    private int getDexoptNeeded(String path, String isa, String compilerFilter, boolean newProfile) {
        int dexoptNeeded;
        try {
            dexoptNeeded = DexFile.getDexOptNeeded(path, isa, compilerFilter, newProfile);
        }
        catch (IOException ioe) {
            Slog.w(TAG, "IOException reading apk: " + path, ioe);
            return -1;
        }
        return this.adjustDexoptNeeded(dexoptNeeded);
    }

    private String getSharedLibrariesPath(String[] sharedLibraries) {
        if (sharedLibraries == null || sharedLibraries.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String lib : sharedLibraries) {
            if (sb.length() != 0) {
                sb.append(":");
            }
            sb.append(lib);
        }
        return sb.toString();
    }

    private String[] getSplitDependencies(PackageParser.Package pkg) {
        String baseCodePath = new File(pkg.baseCodePath).getParent();
        List<String> paths = pkg.getAllCodePaths();
        String[] splitDependencies = new String[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            File pathFile = new File(paths.get(i));
            String fileName = pathFile.getName();
            paths.set(i, fileName);
            String basePath = pathFile.getParent();
            if (basePath.equals(baseCodePath)) continue;
            Slog.wtf(TAG, "Split paths have different base paths: " + basePath + " and " + baseCodePath);
        }
        SparseArray<int[]> dependencies = pkg.applicationInfo.splitDependencies;
        if (dependencies == null) {
            for (int i = 1; i < paths.size(); ++i) {
                splitDependencies[i] = paths.get(0);
            }
            return splitDependencies;
        }
        for (int i = 1; i < dependencies.size(); ++i) {
            this.getParentDependencies(dependencies.keyAt(i), paths, dependencies, splitDependencies);
        }
        return splitDependencies;
    }

    private String getParentDependencies(int index, List<String> paths, SparseArray<int[]> dependencies, String[] splitDependencies) {
        String path;
        if (index == 0) {
            return null;
        }
        if (splitDependencies[index] != null) {
            return splitDependencies[index];
        }
        int parent = dependencies.get(index)[0];
        String parentDependencies = this.getParentDependencies(parent, paths, dependencies, splitDependencies);
        splitDependencies[index] = path = parentDependencies == null ? paths.get(parent) : parentDependencies + ":" + paths.get(parent);
        return path;
    }

    private boolean isProfileUpdated(PackageParser.Package pkg, int uid, String compilerFilter) {
        if (!DexFile.isProfileGuidedCompilerFilter(compilerFilter)) {
            return false;
        }
        try {
            return this.mInstaller.mergeProfiles(uid, pkg.packageName);
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to merge profiles", e);
            return false;
        }
    }

    private String createOatDirIfSupported(PackageParser.Package pkg, String dexInstructionSet) {
        if (!pkg.canHaveOatDir()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            File oatDir = PackageDexOptimizer.getOatDir(codePath);
            try {
                this.mInstaller.createOatDir(oatDir.getAbsolutePath(), dexInstructionSet);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, "Failed to create oat dir", e);
                return null;
            }
            return oatDir.getAbsolutePath();
        }
        return null;
    }

    static File getOatDir(File codePath) {
        return new File(codePath, OAT_DIR_NAME);
    }

    void systemReady() {
        this.mSystemReady = true;
    }

    private String printDexoptFlags(int flags) {
        ArrayList<String> flagsList = new ArrayList<String>();
        if ((flags & 8) == 8) {
            flagsList.add("boot_complete");
        }
        if ((flags & 4) == 4) {
            flagsList.add("debuggable");
        }
        if ((flags & 0x10) == 16) {
            flagsList.add("profile_guided");
        }
        if ((flags & 2) == 2) {
            flagsList.add("public");
        }
        if ((flags & 0x20) == 32) {
            flagsList.add("secondary");
        }
        if ((flags & 0x40) == 64) {
            flagsList.add("force");
        }
        if ((flags & 0x80) == 128) {
            flagsList.add("storage_ce");
        }
        if ((flags & 0x100) == 256) {
            flagsList.add("storage_de");
        }
        return String.join((CharSequence)",", flagsList);
    }

    public static class ForcedUpdatePackageDexOptimizer
    extends PackageDexOptimizer {
        public ForcedUpdatePackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
            super(installer, installLock, context, wakeLockTag);
        }

        public ForcedUpdatePackageDexOptimizer(PackageDexOptimizer from) {
            super(from);
        }

        @Override
        protected int adjustDexoptNeeded(int dexoptNeeded) {
            if (dexoptNeeded == 0) {
                return -3;
            }
            return dexoptNeeded;
        }

        @Override
        protected int adjustDexoptFlags(int flags) {
            return flags | 0x40;
        }
    }
}

