/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.util.ArrayMap;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class OverlayManagerSettings {
    private final ArrayList<SettingsItem> mItems = new ArrayList();

    OverlayManagerSettings() {
    }

    void init(String packageName, int userId, String targetPackageName, String baseCodePath, boolean isStatic, int priority) {
        this.remove(packageName, userId);
        SettingsItem item = new SettingsItem(packageName, userId, targetPackageName, baseCodePath, isStatic, priority);
        if (isStatic) {
            SettingsItem parentItem;
            int i;
            for (i = this.mItems.size() - 1; !(i < 0 || (parentItem = this.mItems.get(i)).mIsStatic && parentItem.mPriority <= priority); --i) {
            }
            int pos = i + 1;
            if (pos == this.mItems.size()) {
                this.mItems.add(item);
            } else {
                this.mItems.add(pos, item);
            }
        } else {
            this.mItems.add(item);
        }
    }

    boolean remove(String packageName, int userId) {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            return false;
        }
        this.mItems.remove(idx);
        return true;
    }

    OverlayInfo getOverlayInfo(String packageName, int userId) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).getOverlayInfo();
    }

    boolean setBaseCodePath(String packageName, int userId, String path) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).setBaseCodePath(path);
    }

    boolean getEnabled(String packageName, int userId) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).isEnabled();
    }

    boolean setEnabled(String packageName, int userId, boolean enable) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).setEnabled(enable);
    }

    int getState(String packageName, int userId) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).getState();
    }

    boolean setState(String packageName, int userId, int state) throws BadKeyException {
        int idx = this.select(packageName, userId);
        if (idx < 0) {
            throw new BadKeyException(packageName, userId);
        }
        return this.mItems.get(idx).setState(state);
    }

    List<OverlayInfo> getOverlaysForTarget(String targetPackageName, int userId) {
        return this.selectWhereTarget(targetPackageName, userId).map(rec$ -> ((SettingsItem)rec$).getOverlayInfo()).collect(Collectors.toList());
    }

    ArrayMap<String, List<OverlayInfo>> getOverlaysForUser(int userId) {
        return this.selectWhereUser(userId).map(rec$ -> ((SettingsItem)rec$).getOverlayInfo()).collect(Collectors.groupingBy(info -> info.targetPackageName, ArrayMap::new, Collectors.toList()));
    }

    int[] getUsers() {
        return this.mItems.stream().mapToInt(rec$ -> ((SettingsItem)rec$).getUserId()).distinct().toArray();
    }

    boolean removeUser(int userId) {
        boolean removed = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            SettingsItem item = this.mItems.get(i);
            if (item.getUserId() != userId) continue;
            this.mItems.remove(i);
            removed = true;
            --i;
        }
        return removed;
    }

    boolean setPriority(String packageName, String newParentPackageName, int userId) {
        if (packageName.equals(newParentPackageName)) {
            return false;
        }
        int moveIdx = this.select(packageName, userId);
        if (moveIdx < 0) {
            return false;
        }
        int parentIdx = this.select(newParentPackageName, userId);
        if (parentIdx < 0) {
            return false;
        }
        SettingsItem itemToMove = this.mItems.get(moveIdx);
        if (!itemToMove.getTargetPackageName().equals(this.mItems.get(parentIdx).getTargetPackageName())) {
            return false;
        }
        this.mItems.remove(moveIdx);
        int newParentIdx = this.select(newParentPackageName, userId);
        this.mItems.add(newParentIdx, itemToMove);
        return moveIdx != newParentIdx;
    }

    boolean setLowestPriority(String packageName, int userId) {
        int idx = this.select(packageName, userId);
        if (idx <= 0) {
            return false;
        }
        SettingsItem item = this.mItems.get(idx);
        this.mItems.remove(item);
        this.mItems.add(0, item);
        return true;
    }

    boolean setHighestPriority(String packageName, int userId) {
        int idx = this.select(packageName, userId);
        if (idx < 0 || idx == this.mItems.size() - 1) {
            return false;
        }
        SettingsItem item = this.mItems.get(idx);
        this.mItems.remove(idx);
        this.mItems.add(item);
        return true;
    }

    void dump(PrintWriter p) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)p, "  ");
        pw.println("Settings");
        pw.increaseIndent();
        if (this.mItems.isEmpty()) {
            pw.println("<none>");
            return;
        }
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            pw.println(item.mPackageName + ":" + item.getUserId() + " {");
            pw.increaseIndent();
            pw.print("mPackageName.......: ");
            pw.println(item.mPackageName);
            pw.print("mUserId............: ");
            pw.println(item.getUserId());
            pw.print("mTargetPackageName.: ");
            pw.println(item.getTargetPackageName());
            pw.print("mBaseCodePath......: ");
            pw.println(item.getBaseCodePath());
            pw.print("mState.............: ");
            pw.println(OverlayInfo.stateToString(item.getState()));
            pw.print("mIsEnabled.........: ");
            pw.println(item.isEnabled());
            pw.print("mIsStatic..........: ");
            pw.println(item.isStatic());
            pw.decreaseIndent();
            pw.println("}");
        }
    }

    void restore(InputStream is) throws IOException, XmlPullParserException {
        Serializer.restore(this.mItems, is);
    }

    void persist(OutputStream os) throws IOException, XmlPullParserException {
        Serializer.persist(this.mItems, os);
    }

    private int select(String packageName, int userId) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            if (item.mUserId != userId || !item.mPackageName.equals(packageName)) continue;
            return i;
        }
        return -1;
    }

    private Stream<SettingsItem> selectWhereUser(int userId) {
        return this.mItems.stream().filter(item -> ((SettingsItem)item).mUserId == userId);
    }

    private Stream<SettingsItem> selectWhereTarget(String targetPackageName, int userId) {
        return this.selectWhereUser(userId).filter(item -> ((SettingsItem)item).getTargetPackageName().equals(targetPackageName));
    }

    static final class BadKeyException
    extends RuntimeException {
        BadKeyException(String packageName, int userId) {
            super("Bad key mPackageName=" + packageName + " mUserId=" + userId);
        }
    }

    private static final class SettingsItem {
        private final int mUserId;
        private final String mPackageName;
        private final String mTargetPackageName;
        private String mBaseCodePath;
        private int mState;
        private boolean mIsEnabled;
        private OverlayInfo mCache;
        private boolean mIsStatic;
        private int mPriority;

        SettingsItem(String packageName, int userId, String targetPackageName, String baseCodePath, int state, boolean isEnabled, boolean isStatic, int priority) {
            this.mPackageName = packageName;
            this.mUserId = userId;
            this.mTargetPackageName = targetPackageName;
            this.mBaseCodePath = baseCodePath;
            this.mState = state;
            this.mIsEnabled = isEnabled;
            this.mCache = null;
            this.mIsStatic = isStatic;
            this.mPriority = priority;
        }

        SettingsItem(String packageName, int userId, String targetPackageName, String baseCodePath, boolean isStatic, int priority) {
            this(packageName, userId, targetPackageName, baseCodePath, -1, false, isStatic, priority);
        }

        private String getTargetPackageName() {
            return this.mTargetPackageName;
        }

        private int getUserId() {
            return this.mUserId;
        }

        private String getBaseCodePath() {
            return this.mBaseCodePath;
        }

        private boolean setBaseCodePath(String path) {
            if (!this.mBaseCodePath.equals(path)) {
                this.mBaseCodePath = path;
                this.invalidateCache();
                return true;
            }
            return false;
        }

        private int getState() {
            return this.mState;
        }

        private boolean setState(int state) {
            if (this.mState != state) {
                this.mState = state;
                this.invalidateCache();
                return true;
            }
            return false;
        }

        private boolean isEnabled() {
            return this.mIsEnabled;
        }

        private boolean setEnabled(boolean enable) {
            if (this.mIsEnabled != enable) {
                this.mIsEnabled = enable;
                this.invalidateCache();
                return true;
            }
            return false;
        }

        private OverlayInfo getOverlayInfo() {
            if (this.mCache == null) {
                this.mCache = new OverlayInfo(this.mPackageName, this.mTargetPackageName, this.mBaseCodePath, this.mState, this.mUserId);
            }
            return this.mCache;
        }

        private void invalidateCache() {
            this.mCache = null;
        }

        private boolean isStatic() {
            return this.mIsStatic;
        }

        private int getPriority() {
            return this.mPriority;
        }
    }

    private static final class Serializer {
        private static final String TAG_OVERLAYS = "overlays";
        private static final String TAG_ITEM = "item";
        private static final String ATTR_BASE_CODE_PATH = "baseCodePath";
        private static final String ATTR_IS_ENABLED = "isEnabled";
        private static final String ATTR_PACKAGE_NAME = "packageName";
        private static final String ATTR_STATE = "state";
        private static final String ATTR_TARGET_PACKAGE_NAME = "targetPackageName";
        private static final String ATTR_IS_STATIC = "isStatic";
        private static final String ATTR_PRIORITY = "priority";
        private static final String ATTR_USER_ID = "userId";
        private static final String ATTR_VERSION = "version";
        private static final int CURRENT_VERSION = 3;

        private Serializer() {
        }

        public static void restore(ArrayList<SettingsItem> table, InputStream is) throws IOException, XmlPullParserException {
            try (InputStreamReader reader = new InputStreamReader(is);){
                table.clear();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(reader);
                XmlUtils.beginDocument(parser, TAG_OVERLAYS);
                int version = XmlUtils.readIntAttribute(parser, ATTR_VERSION);
                if (version != 3) {
                    Serializer.upgrade(version);
                }
                int depth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, depth)) {
                    switch (parser.getName()) {
                        case "item": {
                            SettingsItem item = Serializer.restoreRow(parser, depth + 1);
                            table.add(item);
                        }
                    }
                }
            }
        }

        private static void upgrade(int oldVersion) throws XmlPullParserException {
            switch (oldVersion) {
                case 0: 
                case 1: 
                case 2: {
                    throw new XmlPullParserException("old version " + oldVersion + "; ignoring");
                }
            }
            throw new XmlPullParserException("unrecognized version " + oldVersion);
        }

        private static SettingsItem restoreRow(XmlPullParser parser, int depth) throws IOException {
            String packageName = XmlUtils.readStringAttribute(parser, ATTR_PACKAGE_NAME);
            int userId = XmlUtils.readIntAttribute(parser, ATTR_USER_ID);
            String targetPackageName = XmlUtils.readStringAttribute(parser, ATTR_TARGET_PACKAGE_NAME);
            String baseCodePath = XmlUtils.readStringAttribute(parser, ATTR_BASE_CODE_PATH);
            int state = XmlUtils.readIntAttribute(parser, ATTR_STATE);
            boolean isEnabled = XmlUtils.readBooleanAttribute(parser, ATTR_IS_ENABLED);
            boolean isStatic = XmlUtils.readBooleanAttribute(parser, ATTR_IS_STATIC);
            int priority = XmlUtils.readIntAttribute(parser, ATTR_PRIORITY);
            return new SettingsItem(packageName, userId, targetPackageName, baseCodePath, state, isEnabled, isStatic, priority);
        }

        public static void persist(ArrayList<SettingsItem> table, OutputStream os) throws IOException, XmlPullParserException {
            FastXmlSerializer xml2 = new FastXmlSerializer();
            xml2.setOutput(os, "utf-8");
            xml2.startDocument(null, true);
            xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xml2.startTag(null, TAG_OVERLAYS);
            XmlUtils.writeIntAttribute(xml2, ATTR_VERSION, 3);
            int N = table.size();
            for (int i = 0; i < N; ++i) {
                SettingsItem item = table.get(i);
                Serializer.persistRow(xml2, item);
            }
            xml2.endTag(null, TAG_OVERLAYS);
            xml2.endDocument();
        }

        private static void persistRow(FastXmlSerializer xml2, SettingsItem item) throws IOException {
            xml2.startTag(null, TAG_ITEM);
            XmlUtils.writeStringAttribute(xml2, ATTR_PACKAGE_NAME, item.mPackageName);
            XmlUtils.writeIntAttribute(xml2, ATTR_USER_ID, item.mUserId);
            XmlUtils.writeStringAttribute(xml2, ATTR_TARGET_PACKAGE_NAME, item.mTargetPackageName);
            XmlUtils.writeStringAttribute(xml2, ATTR_BASE_CODE_PATH, item.mBaseCodePath);
            XmlUtils.writeIntAttribute(xml2, ATTR_STATE, item.mState);
            XmlUtils.writeBooleanAttribute(xml2, ATTR_IS_ENABLED, item.mIsEnabled);
            XmlUtils.writeBooleanAttribute(xml2, ATTR_IS_STATIC, item.mIsStatic);
            XmlUtils.writeIntAttribute(xml2, ATTR_PRIORITY, item.mPriority);
            xml2.endTag(null, TAG_ITEM);
        }
    }
}

