/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.hardware.location.GeofenceHardwareImpl;
import android.location.FusedBatchOptions;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.IGnssStatusListener;
import android.location.IGnssStatusProvider;
import android.location.IGpsGeofenceHardware;
import android.location.ILocationManager;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Log;
import android.util.NtpTrustedTime;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.location.GpsNetInitiatedHandler;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.server.location.GnssMeasurementsProvider;
import com.android.server.location.GnssNavigationMessageProvider;
import com.android.server.location.GnssStatusListenerHelper;
import com.android.server.location.GpsXtraDownloader;
import com.android.server.location.LocationProviderInterface;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import libcore.io.IoUtils;

public class GnssLocationProvider
implements LocationProviderInterface {
    private static final String TAG = "GnssLocationProvider";
    private static final boolean DEBUG = Log.isLoggable("GnssLocationProvider", 3);
    private static final boolean VERBOSE = Log.isLoggable("GnssLocationProvider", 2);
    private static final ProviderProperties PROPERTIES = new ProviderProperties(true, true, false, false, true, true, true, 3, 1);
    private static final int GPS_POSITION_MODE_STANDALONE = 0;
    private static final int GPS_POSITION_MODE_MS_BASED = 1;
    private static final int GPS_POSITION_MODE_MS_ASSISTED = 2;
    private static final int GPS_POSITION_RECURRENCE_PERIODIC = 0;
    private static final int GPS_POSITION_RECURRENCE_SINGLE = 1;
    private static final int GPS_STATUS_NONE = 0;
    private static final int GPS_STATUS_SESSION_BEGIN = 1;
    private static final int GPS_STATUS_SESSION_END = 2;
    private static final int GPS_STATUS_ENGINE_ON = 3;
    private static final int GPS_STATUS_ENGINE_OFF = 4;
    private static final int GPS_REQUEST_AGPS_DATA_CONN = 1;
    private static final int GPS_RELEASE_AGPS_DATA_CONN = 2;
    private static final int GPS_AGPS_DATA_CONNECTED = 3;
    private static final int GPS_AGPS_DATA_CONN_DONE = 4;
    private static final int GPS_AGPS_DATA_CONN_FAILED = 5;
    private static final int LOCATION_INVALID = 0;
    private static final int LOCATION_HAS_LAT_LONG = 1;
    private static final int LOCATION_HAS_ALTITUDE = 2;
    private static final int LOCATION_HAS_SPEED = 4;
    private static final int LOCATION_HAS_BEARING = 8;
    private static final int LOCATION_HAS_HORIZONTAL_ACCURACY = 16;
    private static final int LOCATION_HAS_VERTICAL_ACCURACY = 32;
    private static final int LOCATION_HAS_SPEED_ACCURACY = 64;
    private static final int LOCATION_HAS_BEARING_ACCURACY = 128;
    private static final int GPS_DELETE_EPHEMERIS = 1;
    private static final int GPS_DELETE_ALMANAC = 2;
    private static final int GPS_DELETE_POSITION = 4;
    private static final int GPS_DELETE_TIME = 8;
    private static final int GPS_DELETE_IONO = 16;
    private static final int GPS_DELETE_UTC = 32;
    private static final int GPS_DELETE_HEALTH = 64;
    private static final int GPS_DELETE_SVDIR = 128;
    private static final int GPS_DELETE_SVSTEER = 256;
    private static final int GPS_DELETE_SADATA = 512;
    private static final int GPS_DELETE_RTI = 1024;
    private static final int GPS_DELETE_CELLDB_INFO = 32768;
    private static final int GPS_DELETE_ALL = 65535;
    private static final int GPS_CAPABILITY_SCHEDULING = 1;
    private static final int GPS_CAPABILITY_MSB = 2;
    private static final int GPS_CAPABILITY_MSA = 4;
    private static final int GPS_CAPABILITY_SINGLE_SHOT = 8;
    private static final int GPS_CAPABILITY_ON_DEMAND_TIME = 16;
    private static final int GPS_CAPABILITY_GEOFENCING = 32;
    private static final int GPS_CAPABILITY_MEASUREMENTS = 64;
    private static final int GPS_CAPABILITY_NAV_MESSAGES = 128;
    private static final int AGPS_SUPL_MODE_MSA = 2;
    private static final int AGPS_SUPL_MODE_MSB = 1;
    private static final int AGPS_TYPE_SUPL = 1;
    private static final int AGPS_TYPE_C2K = 2;
    private static final int APN_INVALID = 0;
    private static final int APN_IPV4 = 1;
    private static final int APN_IPV6 = 2;
    private static final int APN_IPV4V6 = 3;
    private static final int AGPS_DATA_CONNECTION_CLOSED = 0;
    private static final int AGPS_DATA_CONNECTION_OPENING = 1;
    private static final int AGPS_DATA_CONNECTION_OPEN = 2;
    private static final int CHECK_LOCATION = 1;
    private static final int ENABLE = 2;
    private static final int SET_REQUEST = 3;
    private static final int UPDATE_NETWORK_STATE = 4;
    private static final int INJECT_NTP_TIME = 5;
    private static final int DOWNLOAD_XTRA_DATA = 6;
    private static final int UPDATE_LOCATION = 7;
    private static final int ADD_LISTENER = 8;
    private static final int REMOVE_LISTENER = 9;
    private static final int INJECT_NTP_TIME_FINISHED = 10;
    private static final int DOWNLOAD_XTRA_DATA_FINISHED = 11;
    private static final int SUBSCRIPTION_OR_SIM_CHANGED = 12;
    private static final int INITIALIZE_HANDLER = 13;
    private static final int REQUEST_SUPL_CONNECTION = 14;
    private static final int RELEASE_SUPL_CONNECTION = 15;
    private static final int AGPS_RIL_REQUEST_SETID_IMSI = 1;
    private static final int AGPS_RIL_REQUEST_SETID_MSISDN = 2;
    private static final String DEBUG_PROPERTIES_FILE = "/etc/gps_debug.conf";
    private static final int AGPS_REF_LOCATION_TYPE_GSM_CELLID = 1;
    private static final int AGPS_REF_LOCATION_TYPE_UMTS_CELLID = 2;
    private static final int AGPS_SETID_TYPE_NONE = 0;
    private static final int AGPS_SETID_TYPE_IMSI = 1;
    private static final int AGPS_SETID_TYPE_MSISDN = 2;
    private static final int GPS_GEOFENCE_UNAVAILABLE = 1;
    private static final int GPS_GEOFENCE_AVAILABLE = 2;
    private static final int GPS_GEOFENCE_OPERATION_SUCCESS = 0;
    private static final int GPS_GEOFENCE_ERROR_TOO_MANY_GEOFENCES = 100;
    private static final int GPS_GEOFENCE_ERROR_ID_EXISTS = -101;
    private static final int GPS_GEOFENCE_ERROR_ID_UNKNOWN = -102;
    private static final int GPS_GEOFENCE_ERROR_INVALID_TRANSITION = -103;
    private static final int GPS_GEOFENCE_ERROR_GENERIC = -149;
    private static final int TCP_MIN_PORT = 0;
    private static final int TCP_MAX_PORT = 65535;
    private Object mLock = new Object();
    private int mStatus = 1;
    private long mStatusUpdateTime = SystemClock.elapsedRealtime();
    private static final long RECENT_FIX_TIMEOUT = 10000L;
    private static final int NO_FIX_TIMEOUT = 60000;
    private static final int GPS_POLLING_THRESHOLD_INTERVAL = 10000;
    private static final long NTP_INTERVAL = 86400000L;
    private static final long RETRY_INTERVAL = 300000L;
    private static final long MAX_RETRY_INTERVAL = 14400000L;
    private static final long DOWNLOAD_XTRA_DATA_TIMEOUT_MS = 60000L;
    private BackOff mNtpBackOff = new BackOff(300000L, 14400000L);
    private BackOff mXtraBackOff = new BackOff(300000L, 14400000L);
    private boolean mEnabled;
    private static final int STATE_PENDING_NETWORK = 0;
    private static final int STATE_DOWNLOADING = 1;
    private static final int STATE_IDLE = 2;
    private int mInjectNtpTimePending = 0;
    private int mDownloadXtraDataPending = 0;
    private boolean mOnDemandTimeInjection;
    private boolean mNavigating;
    private boolean mEngineOn;
    private int mFixInterval = 1000;
    private boolean mStarted;
    private boolean mSingleShot;
    private int mEngineCapabilities;
    private boolean mSupportsXtra;
    private long mFixRequestTime = 0L;
    private int mTimeToFirstFix = 0;
    private long mLastFixTime;
    private int mPositionMode;
    private ProviderRequest mProviderRequest = null;
    private WorkSource mWorkSource = null;
    private boolean mDisableGps = false;
    private Properties mProperties;
    private String mSuplServerHost;
    private int mSuplServerPort = 0;
    private String mC2KServerHost;
    private int mC2KServerPort;
    private boolean mSuplEsEnabled = false;
    private final Context mContext;
    private final NtpTrustedTime mNtpTime;
    private final ILocationManager mILocationManager;
    private Location mLocation = new Location("gps");
    private Bundle mLocationExtras = new Bundle();
    private final GnssStatusListenerHelper mListenerHelper;
    private final GnssMeasurementsProvider mGnssMeasurementsProvider;
    private final GnssNavigationMessageProvider mGnssNavigationMessageProvider;
    private Handler mHandler;
    private int mAGpsDataConnectionState;
    private InetAddress mAGpsDataConnectionIpAddr;
    private final ConnectivityManager mConnMgr;
    private final GpsNetInitiatedHandler mNIHandler;
    private static final String WAKELOCK_KEY = "GnssLocationProvider";
    private final PowerManager.WakeLock mWakeLock;
    private static final String DOWNLOAD_EXTRA_WAKELOCK_KEY = "GnssLocationProviderXtraDownload";
    private final PowerManager.WakeLock mDownloadXtraWakeLock;
    private static final String ALARM_WAKEUP = "com.android.internal.location.ALARM_WAKEUP";
    private static final String ALARM_TIMEOUT = "com.android.internal.location.ALARM_TIMEOUT";
    private static final String SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    private static final String LPP_PROFILE = "persist.sys.gps.lpp";
    private final PowerManager mPowerManager;
    private final AlarmManager mAlarmManager;
    private final PendingIntent mWakeupIntent;
    private final PendingIntent mTimeoutIntent;
    private final IAppOpsService mAppOpsService;
    private final IBatteryStats mBatteryStats;
    private WorkSource mClientSource = new WorkSource();
    private GeofenceHardwareImpl mGeofenceHardwareImpl;
    private int mYearOfHardware = 0;
    private static final float ITAR_SPEED_LIMIT_METERS_PER_SECOND = 400.0f;
    private boolean mItarSpeedLimitExceeded = false;
    private final IGnssStatusProvider mGnssStatusProvider = new IGnssStatusProvider.Stub(){

        @Override
        public void registerGnssStatusCallback(IGnssStatusListener callback) {
            GnssLocationProvider.this.mListenerHelper.addListener(callback);
        }

        @Override
        public void unregisterGnssStatusCallback(IGnssStatusListener callback) {
            GnssLocationProvider.this.mListenerHelper.removeListener(callback);
        }
    };
    private final ConnectivityManager.NetworkCallback mNetworkConnectivityCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onAvailable(Network network) {
            if (GnssLocationProvider.this.mInjectNtpTimePending == 0) {
                GnssLocationProvider.this.requestUtcTime();
            }
            if (GnssLocationProvider.this.mDownloadXtraDataPending == 0) {
                GnssLocationProvider.this.xtraDownloadRequest();
            }
            GnssLocationProvider.this.sendMessage(4, 0, network);
        }
    };
    private final ConnectivityManager.NetworkCallback mSuplConnectivityCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onAvailable(Network network) {
            GnssLocationProvider.this.sendMessage(4, 0, network);
        }

        @Override
        public void onLost(Network network) {
            GnssLocationProvider.this.releaseSuplConnection(2);
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (DEBUG) {
                Log.d("GnssLocationProvider", "receive broadcast intent, action: " + action);
            }
            if (action == null) {
                return;
            }
            if (action.equals(GnssLocationProvider.ALARM_WAKEUP)) {
                GnssLocationProvider.this.startNavigating(false);
            } else if (action.equals(GnssLocationProvider.ALARM_TIMEOUT)) {
                GnssLocationProvider.this.hibernate();
            } else if ("android.os.action.POWER_SAVE_MODE_CHANGED".equals(action) || "android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(action) || "android.intent.action.SCREEN_OFF".equals(action) || "android.intent.action.SCREEN_ON".equals(action)) {
                GnssLocationProvider.this.updateLowPowerMode();
            } else if (action.equals(GnssLocationProvider.SIM_STATE_CHANGED)) {
                GnssLocationProvider.this.subscriptionOrSimChanged(context);
            }
        }
    };
    private final SubscriptionManager.OnSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SubscriptionManager.OnSubscriptionsChangedListener(){

        @Override
        public void onSubscriptionsChanged() {
            GnssLocationProvider.this.sendMessage(12, 0, null);
        }
    };
    private IGpsGeofenceHardware mGpsGeofenceBinder = new IGpsGeofenceHardware.Stub(){

        @Override
        public boolean isHardwareGeofenceSupported() {
            return GnssLocationProvider.native_is_geofence_supported();
        }

        @Override
        public boolean addCircularHardwareGeofence(int geofenceId, double latitude, double longitude, double radius, int lastTransition, int monitorTransitions, int notificationResponsiveness, int unknownTimer) {
            return GnssLocationProvider.native_add_geofence(geofenceId, latitude, longitude, radius, lastTransition, monitorTransitions, notificationResponsiveness, unknownTimer);
        }

        @Override
        public boolean removeHardwareGeofence(int geofenceId) {
            return GnssLocationProvider.native_remove_geofence(geofenceId);
        }

        @Override
        public boolean pauseHardwareGeofence(int geofenceId) {
            return GnssLocationProvider.native_pause_geofence(geofenceId);
        }

        @Override
        public boolean resumeHardwareGeofence(int geofenceId, int monitorTransition) {
            return GnssLocationProvider.native_resume_geofence(geofenceId, monitorTransition);
        }
    };
    private final INetInitiatedListener mNetInitiatedListener = new INetInitiatedListener.Stub(){

        @Override
        public boolean sendNiResponse(int notificationId, int userResponse) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "sendNiResponse, notifId: " + notificationId + ", response: " + userResponse);
            }
            GnssLocationProvider.this.native_send_ni_response(notificationId, userResponse);
            return true;
        }
    };
    private static final int MAX_SVS = 64;
    private int[] mSvidWithFlags = new int[64];
    private float[] mCn0s = new float[64];
    private float[] mSvElevations = new float[64];
    private float[] mSvAzimuths = new float[64];
    private float[] mSvCarrierFreqs = new float[64];
    private int mSvCount;
    private byte[] mNmeaBuffer = new byte[120];

    public IGnssStatusProvider getGnssStatusProvider() {
        return this.mGnssStatusProvider;
    }

    public IGpsGeofenceHardware getGpsGeofenceProxy() {
        return this.mGpsGeofenceBinder;
    }

    public GnssMeasurementsProvider getGnssMeasurementsProvider() {
        return this.mGnssMeasurementsProvider;
    }

    public GnssNavigationMessageProvider getGnssNavigationMessageProvider() {
        return this.mGnssNavigationMessageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscriptionOrSimChanged(Context context) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "received SIM related action: ");
        }
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        String mccMnc = phone.getSimOperator();
        boolean isKeepLppProfile = false;
        if (!TextUtils.isEmpty(mccMnc)) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "SIM MCC/MNC is available: " + mccMnc);
            }
            Object object = this.mLock;
            synchronized (object) {
                if (configManager != null) {
                    PersistableBundle b = configManager.getConfig();
                    isKeepLppProfile = b.getBoolean("persist_lpp_mode_bool");
                }
                if (isKeepLppProfile) {
                    this.loadPropertiesFromResource(context, this.mProperties);
                    String lpp_profile = this.mProperties.getProperty("LPP_PROFILE");
                    SystemProperties.set(LPP_PROFILE, lpp_profile);
                } else {
                    SystemProperties.set(LPP_PROFILE, "");
                }
                this.reloadGpsProperties(context, this.mProperties);
                this.mNIHandler.setSuplEsEnabled(this.mSuplEsEnabled);
            }
        } else if (DEBUG) {
            Log.d("GnssLocationProvider", "SIM MCC/MNC is still not available");
        }
    }

    private void updateLowPowerMode() {
        boolean disableGps = this.mPowerManager.isDeviceIdleMode();
        PowerSaveState result = this.mPowerManager.getPowerSaveState(1);
        switch (result.gpsMode) {
            case 1: {
                disableGps |= result.batterySaverEnabled && !this.mPowerManager.isInteractive();
            }
        }
        if (disableGps != this.mDisableGps) {
            this.mDisableGps = disableGps;
            this.updateRequirements();
        }
    }

    public static boolean isSupported() {
        return GnssLocationProvider.native_is_supported();
    }

    private void reloadGpsProperties(Context context, Properties properties) {
        String suplESProperty;
        if (DEBUG) {
            Log.d("GnssLocationProvider", "Reset GPS properties, previous size = " + properties.size());
        }
        this.loadPropertiesFromResource(context, properties);
        String lpp_prof = SystemProperties.get(LPP_PROFILE);
        if (!TextUtils.isEmpty(lpp_prof)) {
            properties.setProperty("LPP_PROFILE", lpp_prof);
        }
        this.loadPropertiesFromFile(DEBUG_PROPERTIES_FILE, properties);
        this.setSuplHostPort(properties.getProperty("SUPL_HOST"), properties.getProperty("SUPL_PORT"));
        this.mC2KServerHost = properties.getProperty("C2K_HOST");
        String portString = properties.getProperty("C2K_PORT");
        if (this.mC2KServerHost != null && portString != null) {
            try {
                this.mC2KServerPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                Log.e("GnssLocationProvider", "unable to parse C2K_PORT: " + portString);
            }
        }
        if (GnssLocationProvider.native_is_gnss_configuration_supported()) {
            HashMap<String, SetCarrierProperty> map = new HashMap<String, SetCarrierProperty>(){
                {
                    this.put("SUPL_VER", val -> GnssLocationProvider.native_set_supl_version(val));
                    this.put("SUPL_MODE", val -> GnssLocationProvider.native_set_supl_mode(val));
                    this.put("SUPL_ES", val -> GnssLocationProvider.native_set_supl_es(val));
                    this.put("LPP_PROFILE", val -> GnssLocationProvider.native_set_lpp_profile(val));
                    this.put("A_GLONASS_POS_PROTOCOL_SELECT", val -> GnssLocationProvider.native_set_gnss_pos_protocol_select(val));
                    this.put("USE_EMERGENCY_PDN_FOR_EMERGENCY_SUPL", val -> GnssLocationProvider.native_set_emergency_supl_pdn(val));
                    this.put("GPS_LOCK", val -> GnssLocationProvider.native_set_gps_lock(val));
                }
            };
            for (Map.Entry entry : map.entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValueString = properties.getProperty(propertyName);
                if (propertyValueString == null) continue;
                try {
                    int propertyValueInt = Integer.decode(propertyValueString);
                    boolean result = ((SetCarrierProperty)entry.getValue()).set(propertyValueInt);
                    if (result) continue;
                    Log.e("GnssLocationProvider", "Unable to set " + propertyName);
                }
                catch (NumberFormatException e) {
                    Log.e("GnssLocationProvider", "unable to parse propertyName: " + propertyValueString);
                }
            }
        } else if (DEBUG) {
            Log.d("GnssLocationProvider", "Skipped configuration update because GNSS configuration in GPS HAL is not supported");
        }
        if ((suplESProperty = this.mProperties.getProperty("SUPL_ES")) != null) {
            try {
                this.mSuplEsEnabled = Integer.parseInt(suplESProperty) == 1;
            }
            catch (NumberFormatException e) {
                Log.e("GnssLocationProvider", "unable to parse SUPL_ES: " + suplESProperty);
            }
        }
    }

    private void loadPropertiesFromResource(Context context, Properties properties) {
        String[] configValues;
        for (String item : configValues = context.getResources().getStringArray(17236007)) {
            String[] split;
            if (DEBUG) {
                Log.d("GnssLocationProvider", "GpsParamsResource: " + item);
            }
            if ((split = item.split("=")).length == 2) {
                properties.setProperty(split[0].trim().toUpperCase(), split[1]);
                continue;
            }
            Log.w("GnssLocationProvider", "malformed contents: " + item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPropertiesFromFile(String filename, Properties properties) {
        try {
            File file = new File(filename);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                properties.load(stream);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(stream);
                throw throwable;
            }
            IoUtils.closeQuietly(stream);
        }
        catch (IOException e) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "Could not open GPS configuration file " + filename);
            }
            return false;
        }
        return true;
    }

    public GnssLocationProvider(Context context, ILocationManager ilocationManager, Looper looper) {
        this.mContext = context;
        this.mNtpTime = NtpTrustedTime.getInstance(context);
        this.mILocationManager = ilocationManager;
        this.mLocation.setExtras(this.mLocationExtras);
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(1, "GnssLocationProvider");
        this.mWakeLock.setReferenceCounted(true);
        this.mDownloadXtraWakeLock = this.mPowerManager.newWakeLock(1, DOWNLOAD_EXTRA_WAKELOCK_KEY);
        this.mDownloadXtraWakeLock.setReferenceCounted(true);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mWakeupIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ALARM_WAKEUP), 0);
        this.mTimeoutIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ALARM_TIMEOUT), 0);
        this.mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mHandler = new ProviderHandler(looper);
        this.mProperties = new Properties();
        this.sendMessage(13, 0, null);
        this.mNIHandler = new GpsNetInitiatedHandler(context, this.mNetInitiatedListener, this.mSuplEsEnabled);
        this.mListenerHelper = new GnssStatusListenerHelper(this.mHandler){

            @Override
            protected boolean isAvailableInPlatform() {
                return GnssLocationProvider.isSupported();
            }

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isEnabled();
            }
        };
        this.mGnssMeasurementsProvider = new GnssMeasurementsProvider(this.mHandler){

            @Override
            public boolean isAvailableInPlatform() {
                return GnssLocationProvider.native_is_measurement_supported();
            }

            @Override
            protected boolean registerWithService() {
                return GnssLocationProvider.this.native_start_measurement_collection();
            }

            @Override
            protected void unregisterFromService() {
                GnssLocationProvider.this.native_stop_measurement_collection();
            }

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isEnabled();
            }
        };
        this.mGnssNavigationMessageProvider = new GnssNavigationMessageProvider(this.mHandler){

            @Override
            protected boolean isAvailableInPlatform() {
                return GnssLocationProvider.native_is_navigation_message_supported();
            }

            @Override
            protected boolean registerWithService() {
                return GnssLocationProvider.this.native_start_navigation_message_collection();
            }

            @Override
            protected void unregisterFromService() {
                GnssLocationProvider.this.native_stop_navigation_message_collection();
            }

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isEnabled();
            }
        };
        boolean isInitialized = this.native_init();
        if (!isInitialized) {
            Log.d("GnssLocationProvider", "Failed to initialize at bootup");
        } else {
            this.native_cleanup();
        }
    }

    @Override
    public String getName() {
        return "gps";
    }

    @Override
    public ProviderProperties getProperties() {
        return PROPERTIES;
    }

    private void handleUpdateNetworkState(Network network) {
        NetworkInfo info = this.mConnMgr.getNetworkInfo(network);
        if (info == null) {
            return;
        }
        boolean isConnected = info.isConnected();
        if (DEBUG) {
            String message = String.format("UpdateNetworkState, state=%s, connected=%s, info=%s, capabilities=%S", this.agpsDataConnStateAsString(), isConnected, info, this.mConnMgr.getNetworkCapabilities(network));
            Log.d("GnssLocationProvider", message);
        }
        if (GnssLocationProvider.native_is_agps_ril_supported()) {
            boolean dataEnabled = TelephonyManager.getDefault().getDataEnabled();
            boolean networkAvailable = info.isAvailable() && dataEnabled;
            String defaultApn = this.getSelectedApn();
            if (defaultApn == null) {
                defaultApn = "dummy-apn";
            }
            this.native_update_network_state(isConnected, info.getType(), info.isRoaming(), networkAvailable, info.getExtraInfo(), defaultApn);
        } else if (DEBUG) {
            Log.d("GnssLocationProvider", "Skipped network state update because GPS HAL AGPS-RIL is not  supported");
        }
        if (this.mAGpsDataConnectionState == 1) {
            if (isConnected) {
                String apnName = info.getExtraInfo();
                if (apnName == null) {
                    apnName = "dummy-apn";
                }
                int apnIpType = this.getApnIpType(apnName);
                this.setRouting();
                if (DEBUG) {
                    String message = String.format("native_agps_data_conn_open: mAgpsApn=%s, mApnIpType=%s", apnName, apnIpType);
                    Log.d("GnssLocationProvider", message);
                }
                this.native_agps_data_conn_open(apnName, apnIpType);
                this.mAGpsDataConnectionState = 2;
            } else {
                this.handleReleaseSuplConnection(5);
            }
        }
    }

    private void handleRequestSuplConnection(InetAddress address) {
        if (DEBUG) {
            String message = String.format("requestSuplConnection, state=%s, address=%s", this.agpsDataConnStateAsString(), address);
            Log.d("GnssLocationProvider", message);
        }
        if (this.mAGpsDataConnectionState != 0) {
            return;
        }
        this.mAGpsDataConnectionIpAddr = address;
        this.mAGpsDataConnectionState = 1;
        NetworkRequest.Builder requestBuilder = new NetworkRequest.Builder();
        requestBuilder.addTransportType(0);
        requestBuilder.addCapability(1);
        NetworkRequest request = requestBuilder.build();
        this.mConnMgr.requestNetwork(request, this.mSuplConnectivityCallback);
    }

    private void handleReleaseSuplConnection(int agpsDataConnStatus) {
        if (DEBUG) {
            String message = String.format("releaseSuplConnection, state=%s, status=%s", this.agpsDataConnStateAsString(), this.agpsDataConnStatusAsString(agpsDataConnStatus));
            Log.d("GnssLocationProvider", message);
        }
        if (this.mAGpsDataConnectionState == 0) {
            return;
        }
        this.mAGpsDataConnectionState = 0;
        this.mConnMgr.unregisterNetworkCallback(this.mSuplConnectivityCallback);
        switch (agpsDataConnStatus) {
            case 5: {
                this.native_agps_data_conn_failed();
                break;
            }
            case 2: {
                this.native_agps_data_conn_closed();
                break;
            }
            default: {
                Log.e("GnssLocationProvider", "Invalid status to release SUPL connection: " + agpsDataConnStatus);
            }
        }
    }

    private void handleInjectNtpTime() {
        if (this.mInjectNtpTimePending == 1) {
            return;
        }
        if (!this.isDataNetworkConnected()) {
            this.mInjectNtpTimePending = 0;
            return;
        }
        this.mInjectNtpTimePending = 1;
        this.mWakeLock.acquire();
        Log.i("GnssLocationProvider", "WakeLock acquired by handleInjectNtpTime()");
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                long delay;
                boolean refreshSuccess = true;
                if (GnssLocationProvider.this.mNtpTime.getCacheAge() >= 86400000L) {
                    refreshSuccess = GnssLocationProvider.this.mNtpTime.forceRefresh();
                }
                if (GnssLocationProvider.this.mNtpTime.getCacheAge() < 86400000L) {
                    long time = GnssLocationProvider.this.mNtpTime.getCachedNtpTime();
                    long timeReference = GnssLocationProvider.this.mNtpTime.getCachedNtpTimeReference();
                    long certainty = GnssLocationProvider.this.mNtpTime.getCacheCertainty();
                    if (DEBUG) {
                        long now = System.currentTimeMillis();
                        Log.d("GnssLocationProvider", "NTP server returned: " + time + " (" + new Date(time) + ") reference: " + timeReference + " certainty: " + certainty + " system time offset: " + (time - now));
                    }
                    GnssLocationProvider.this.native_inject_time(time, timeReference, (int)certainty);
                    delay = 86400000L;
                    GnssLocationProvider.this.mNtpBackOff.reset();
                } else {
                    Log.e("GnssLocationProvider", "requestTime failed");
                    delay = GnssLocationProvider.this.mNtpBackOff.nextBackoffMillis();
                }
                GnssLocationProvider.this.sendMessage(10, 0, null);
                if (DEBUG) {
                    String message = String.format("onDemandTimeInjection=%s, refreshSuccess=%s, delay=%s", GnssLocationProvider.this.mOnDemandTimeInjection, refreshSuccess, delay);
                    Log.d("GnssLocationProvider", message);
                }
                if (GnssLocationProvider.this.mOnDemandTimeInjection || !refreshSuccess) {
                    GnssLocationProvider.this.mHandler.sendEmptyMessageDelayed(5, delay);
                }
                GnssLocationProvider.this.mWakeLock.release();
                Log.i("GnssLocationProvider", "WakeLock released by handleInjectNtpTime()");
            }
        });
    }

    private void handleDownloadXtraData() {
        if (!this.mSupportsXtra) {
            Log.d("GnssLocationProvider", "handleDownloadXtraData() called when Xtra not supported");
            return;
        }
        if (this.mDownloadXtraDataPending == 1) {
            return;
        }
        if (!this.isDataNetworkConnected()) {
            this.mDownloadXtraDataPending = 0;
            return;
        }
        this.mDownloadXtraDataPending = 1;
        this.mDownloadXtraWakeLock.acquire(60000L);
        Log.i("GnssLocationProvider", "WakeLock acquired by handleDownloadXtraData()");
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GpsXtraDownloader xtraDownloader = new GpsXtraDownloader(GnssLocationProvider.this.mProperties);
                byte[] data = xtraDownloader.downloadXtraData();
                if (data != null) {
                    if (DEBUG) {
                        Log.d("GnssLocationProvider", "calling native_inject_xtra_data");
                    }
                    GnssLocationProvider.this.native_inject_xtra_data(data, data.length);
                    GnssLocationProvider.this.mXtraBackOff.reset();
                }
                GnssLocationProvider.this.sendMessage(11, 0, null);
                if (data == null) {
                    GnssLocationProvider.this.mHandler.sendEmptyMessageDelayed(6, GnssLocationProvider.this.mXtraBackOff.nextBackoffMillis());
                }
                Object object = GnssLocationProvider.this.mLock;
                synchronized (object) {
                    if (GnssLocationProvider.this.mDownloadXtraWakeLock.isHeld()) {
                        GnssLocationProvider.this.mDownloadXtraWakeLock.release();
                        if (DEBUG) {
                            Log.d("GnssLocationProvider", "WakeLock released by handleDownloadXtraData()");
                        }
                    } else {
                        Log.e("GnssLocationProvider", "WakeLock expired before release in handleDownloadXtraData()");
                    }
                }
            }
        });
    }

    private void handleUpdateLocation(Location location) {
        if (location.hasAccuracy()) {
            this.native_inject_location(location.getLatitude(), location.getLongitude(), location.getAccuracy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled) {
                return;
            }
            this.mEnabled = true;
        }
        this.sendMessage(2, 1, null);
    }

    private void setSuplHostPort(String hostString, String portString) {
        if (hostString != null) {
            this.mSuplServerHost = hostString;
        }
        if (portString != null) {
            try {
                this.mSuplServerPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                Log.e("GnssLocationProvider", "unable to parse SUPL_PORT: " + portString);
            }
        }
        if (this.mSuplServerHost != null && this.mSuplServerPort > 0 && this.mSuplServerPort <= 65535) {
            this.native_set_agps_server(1, this.mSuplServerHost, this.mSuplServerPort);
        }
    }

    private int getSuplMode(Properties properties, boolean agpsEnabled, boolean singleShot) {
        if (agpsEnabled) {
            String modeString = properties.getProperty("SUPL_MODE");
            int suplMode = 0;
            if (!TextUtils.isEmpty(modeString)) {
                try {
                    suplMode = Integer.parseInt(modeString);
                }
                catch (NumberFormatException e) {
                    Log.e("GnssLocationProvider", "unable to parse SUPL_MODE: " + modeString);
                    return 0;
                }
            }
            if (this.hasCapability(2) && (suplMode & 1) != 0) {
                return 1;
            }
            if (singleShot && this.hasCapability(4) && (suplMode & 2) != 0) {
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnable() {
        boolean enabled;
        if (DEBUG) {
            Log.d("GnssLocationProvider", "handleEnable");
        }
        if (enabled = this.native_init()) {
            this.mSupportsXtra = this.native_supports_xtra();
            if (this.mSuplServerHost != null) {
                this.native_set_agps_server(1, this.mSuplServerHost, this.mSuplServerPort);
            }
            if (this.mC2KServerHost != null) {
                this.native_set_agps_server(2, this.mC2KServerHost, this.mC2KServerPort);
            }
            this.mGnssMeasurementsProvider.onGpsEnabledChanged();
            this.mGnssNavigationMessageProvider.onGpsEnabledChanged();
            this.enableBatching();
        } else {
            Object object = this.mLock;
            synchronized (object) {
                this.mEnabled = false;
            }
            Log.w("GnssLocationProvider", "Failed to enable location provider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                return;
            }
            this.mEnabled = false;
        }
        this.sendMessage(2, 0, null);
    }

    private void handleDisable() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "handleDisable");
        }
        this.updateClientUids(new WorkSource());
        this.stopNavigating();
        this.mAlarmManager.cancel(this.mWakeupIntent);
        this.mAlarmManager.cancel(this.mTimeoutIntent);
        this.disableBatching();
        this.native_cleanup();
        this.mGnssMeasurementsProvider.onGpsEnabledChanged();
        this.mGnssNavigationMessageProvider.onGpsEnabledChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    @Override
    public int getStatus(Bundle extras) {
        if (extras != null) {
            extras.putInt("satellites", this.mSvCount);
        }
        return this.mStatus;
    }

    private void updateStatus(int status, int svCount) {
        if (status != this.mStatus || svCount != this.mSvCount) {
            this.mStatus = status;
            this.mSvCount = svCount;
            this.mLocationExtras.putInt("satellites", svCount);
            this.mStatusUpdateTime = SystemClock.elapsedRealtime();
        }
    }

    @Override
    public long getStatusUpdateTime() {
        return this.mStatusUpdateTime;
    }

    @Override
    public void setRequest(ProviderRequest request, WorkSource source) {
        this.sendMessage(3, 0, new GpsRequest(request, source));
    }

    private void handleSetRequest(ProviderRequest request, WorkSource source) {
        this.mProviderRequest = request;
        this.mWorkSource = source;
        this.updateRequirements();
    }

    private void updateRequirements() {
        if (this.mProviderRequest == null || this.mWorkSource == null) {
            return;
        }
        boolean singleShot = false;
        if (this.mProviderRequest.locationRequests != null && this.mProviderRequest.locationRequests.size() > 0) {
            singleShot = true;
            for (LocationRequest lr : this.mProviderRequest.locationRequests) {
                if (lr.getNumUpdates() == 1) continue;
                singleShot = false;
            }
        }
        if (DEBUG) {
            Log.d("GnssLocationProvider", "setRequest " + this.mProviderRequest);
        }
        if (this.mProviderRequest.reportLocation && !this.mDisableGps && this.isEnabled()) {
            this.updateClientUids(this.mWorkSource);
            this.mFixInterval = (int)this.mProviderRequest.interval;
            if ((long)this.mFixInterval != this.mProviderRequest.interval) {
                Log.w("GnssLocationProvider", "interval overflow: " + this.mProviderRequest.interval);
                this.mFixInterval = Integer.MAX_VALUE;
            }
            if (this.mStarted && this.hasCapability(1)) {
                if (!this.native_set_position_mode(this.mPositionMode, 0, this.mFixInterval, 0, 0)) {
                    Log.e("GnssLocationProvider", "set_position_mode failed in setMinTime()");
                }
            } else if (!this.mStarted) {
                this.startNavigating(singleShot);
            }
        } else {
            this.updateClientUids(new WorkSource());
            this.stopNavigating();
            this.mAlarmManager.cancel(this.mWakeupIntent);
            this.mAlarmManager.cancel(this.mTimeoutIntent);
        }
    }

    private void updateClientUids(WorkSource source) {
        int i;
        int lastuid;
        WorkSource[] changes = this.mClientSource.setReturningDiffs(source);
        if (changes == null) {
            return;
        }
        WorkSource newWork = changes[0];
        WorkSource goneWork = changes[1];
        if (newWork != null) {
            lastuid = -1;
            for (i = 0; i < newWork.size(); ++i) {
                try {
                    int uid = newWork.get(i);
                    this.mAppOpsService.startOperation(AppOpsManager.getToken(this.mAppOpsService), 2, uid, newWork.getName(i));
                    if (uid == lastuid) continue;
                    lastuid = uid;
                    this.mBatteryStats.noteStartGps(uid);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w("GnssLocationProvider", "RemoteException", e);
                }
            }
        }
        if (goneWork != null) {
            lastuid = -1;
            for (i = 0; i < goneWork.size(); ++i) {
                try {
                    int uid = goneWork.get(i);
                    this.mAppOpsService.finishOperation(AppOpsManager.getToken(this.mAppOpsService), 2, uid, goneWork.getName(i));
                    if (uid == lastuid) continue;
                    lastuid = uid;
                    this.mBatteryStats.noteStopGps(uid);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w("GnssLocationProvider", "RemoteException", e);
                }
            }
        }
    }

    @Override
    public boolean sendExtraCommand(String command, Bundle extras) {
        long identity = Binder.clearCallingIdentity();
        boolean result = false;
        if ("delete_aiding_data".equals(command)) {
            result = this.deleteAidingData(extras);
        } else if ("force_time_injection".equals(command)) {
            this.requestUtcTime();
            result = true;
        } else if ("force_xtra_injection".equals(command)) {
            if (this.mSupportsXtra) {
                this.xtraDownloadRequest();
                result = true;
            }
        } else {
            Log.w("GnssLocationProvider", "sendExtraCommand: unknown command " + command);
        }
        Binder.restoreCallingIdentity(identity);
        return result;
    }

    private boolean deleteAidingData(Bundle extras) {
        int flags;
        if (extras == null) {
            flags = 65535;
        } else {
            flags = 0;
            if (extras.getBoolean("ephemeris")) {
                flags |= 1;
            }
            if (extras.getBoolean("almanac")) {
                flags |= 2;
            }
            if (extras.getBoolean("position")) {
                flags |= 4;
            }
            if (extras.getBoolean("time")) {
                flags |= 8;
            }
            if (extras.getBoolean("iono")) {
                flags |= 0x10;
            }
            if (extras.getBoolean("utc")) {
                flags |= 0x20;
            }
            if (extras.getBoolean("health")) {
                flags |= 0x40;
            }
            if (extras.getBoolean("svdir")) {
                flags |= 0x80;
            }
            if (extras.getBoolean("svsteer")) {
                flags |= 0x100;
            }
            if (extras.getBoolean("sadata")) {
                flags |= 0x200;
            }
            if (extras.getBoolean("rti")) {
                flags |= 0x400;
            }
            if (extras.getBoolean("celldb-info")) {
                flags |= 0x8000;
            }
            if (extras.getBoolean("all")) {
                flags |= 0xFFFF;
            }
        }
        if (flags != 0) {
            this.native_delete_aiding_data(flags);
            return true;
        }
        return false;
    }

    private void startNavigating(boolean singleShot) {
        if (!this.mStarted) {
            int interval;
            if (DEBUG) {
                Log.d("GnssLocationProvider", "startNavigating, singleShot is " + singleShot);
            }
            this.mTimeToFirstFix = 0;
            this.mLastFixTime = 0L;
            this.mStarted = true;
            this.mSingleShot = singleShot;
            this.mPositionMode = 0;
            if (this.mItarSpeedLimitExceeded) {
                Log.i("GnssLocationProvider", "startNavigating with ITAR limit in place. Output limited  until slow enough speed reported.");
            }
            boolean agpsEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "assisted_gps_enabled", 1) != 0;
            this.mPositionMode = this.getSuplMode(this.mProperties, agpsEnabled, singleShot);
            if (DEBUG) {
                String mode;
                switch (this.mPositionMode) {
                    case 0: {
                        mode = "standalone";
                        break;
                    }
                    case 2: {
                        mode = "MS_ASSISTED";
                        break;
                    }
                    case 1: {
                        mode = "MS_BASED";
                        break;
                    }
                    default: {
                        mode = "unknown";
                    }
                }
                Log.d("GnssLocationProvider", "setting position_mode to " + mode);
            }
            int n = interval = this.hasCapability(1) ? this.mFixInterval : 1000;
            if (!this.native_set_position_mode(this.mPositionMode, 0, interval, 0, 0)) {
                this.mStarted = false;
                Log.e("GnssLocationProvider", "set_position_mode failed in startNavigating()");
                return;
            }
            if (!this.native_start()) {
                this.mStarted = false;
                Log.e("GnssLocationProvider", "native_start failed in startNavigating()");
                return;
            }
            this.updateStatus(1, 0);
            this.mFixRequestTime = SystemClock.elapsedRealtime();
            if (!this.hasCapability(1) && this.mFixInterval >= 60000) {
                this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 60000L, this.mTimeoutIntent);
            }
        }
    }

    private void stopNavigating() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "stopNavigating");
        }
        if (this.mStarted) {
            this.mStarted = false;
            this.mSingleShot = false;
            this.native_stop();
            this.mTimeToFirstFix = 0;
            this.mLastFixTime = 0L;
            this.updateStatus(1, 0);
        }
    }

    private void hibernate() {
        this.stopNavigating();
        this.mAlarmManager.cancel(this.mTimeoutIntent);
        this.mAlarmManager.cancel(this.mWakeupIntent);
        long now = SystemClock.elapsedRealtime();
        this.mAlarmManager.set(2, now + (long)this.mFixInterval, this.mWakeupIntent);
    }

    private boolean hasCapability(int capability) {
        return (this.mEngineCapabilities & capability) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLocation(boolean hasLatLong, Location location) {
        if (location.hasSpeed()) {
            boolean bl = this.mItarSpeedLimitExceeded = location.getSpeed() > 400.0f;
        }
        if (this.mItarSpeedLimitExceeded) {
            Log.i("GnssLocationProvider", "Hal reported a speed in excess of ITAR limit.  GPS/GNSS Navigation output blocked.");
            return;
        }
        if (VERBOSE) {
            Log.v("GnssLocationProvider", "reportLocation " + location.toString());
        }
        Location location2 = this.mLocation;
        synchronized (location2) {
            this.mLocation = location;
            this.mLocation.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            this.mLocation.setExtras(this.mLocationExtras);
            try {
                this.mILocationManager.reportLocation(this.mLocation, false);
            }
            catch (RemoteException e) {
                Log.e("GnssLocationProvider", "RemoteException calling reportLocation");
            }
        }
        this.mLastFixTime = SystemClock.elapsedRealtime();
        if (this.mTimeToFirstFix == 0 && hasLatLong) {
            this.mTimeToFirstFix = (int)(this.mLastFixTime - this.mFixRequestTime);
            if (DEBUG) {
                Log.d("GnssLocationProvider", "TTFF: " + this.mTimeToFirstFix);
            }
            this.mListenerHelper.onFirstFix(this.mTimeToFirstFix);
        }
        if (this.mSingleShot) {
            this.stopNavigating();
        }
        if (this.mStarted && this.mStatus != 2) {
            if (!this.hasCapability(1) && this.mFixInterval < 60000) {
                this.mAlarmManager.cancel(this.mTimeoutIntent);
            }
            Intent intent = new Intent("android.location.GPS_FIX_CHANGE");
            intent.putExtra("enabled", true);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            this.updateStatus(2, this.mSvCount);
        }
        if (!this.hasCapability(1) && this.mStarted && this.mFixInterval > 10000) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "got fix, hibernating");
            }
            this.hibernate();
        }
    }

    private void reportStatus(int status) {
        if (DEBUG) {
            Log.v("GnssLocationProvider", "reportStatus status: " + status);
        }
        boolean wasNavigating = this.mNavigating;
        switch (status) {
            case 1: {
                this.mNavigating = true;
                this.mEngineOn = true;
                break;
            }
            case 2: {
                this.mNavigating = false;
                break;
            }
            case 3: {
                this.mEngineOn = true;
                break;
            }
            case 4: {
                this.mEngineOn = false;
                this.mNavigating = false;
            }
        }
        if (wasNavigating != this.mNavigating) {
            this.mListenerHelper.onStatusChanged(this.mNavigating);
            Intent intent = new Intent("android.location.GPS_ENABLED_CHANGE");
            intent.putExtra("enabled", this.mNavigating);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    private void reportSvStatus() {
        int svCount = this.native_read_sv_status(this.mSvidWithFlags, this.mCn0s, this.mSvElevations, this.mSvAzimuths, this.mSvCarrierFreqs);
        this.mListenerHelper.onSvStatusChanged(svCount, this.mSvidWithFlags, this.mCn0s, this.mSvElevations, this.mSvAzimuths, this.mSvCarrierFreqs);
        if (VERBOSE) {
            Log.v("GnssLocationProvider", "SV count: " + svCount);
        }
        int usedInFixCount = 0;
        for (int i = 0; i < svCount; ++i) {
            if ((this.mSvidWithFlags[i] & 4) != 0) {
                ++usedInFixCount;
            }
            if (!VERBOSE) continue;
            Log.v("GnssLocationProvider", "svid: " + (this.mSvidWithFlags[i] >> 8) + " cn0: " + this.mCn0s[i] / 10.0f + " elev: " + this.mSvElevations[i] + " azimuth: " + this.mSvAzimuths[i] + " carrier frequency: " + this.mSvCarrierFreqs[i] + ((this.mSvidWithFlags[i] & 1) == 0 ? "  " : " E") + ((this.mSvidWithFlags[i] & 2) == 0 ? "  " : " A") + ((this.mSvidWithFlags[i] & 4) == 0 ? "" : "U") + ((this.mSvidWithFlags[i] & 8) == 0 ? "" : "F"));
        }
        this.updateStatus(this.mStatus, usedInFixCount);
        if (this.mNavigating && this.mStatus == 2 && this.mLastFixTime > 0L && SystemClock.elapsedRealtime() - this.mLastFixTime > 10000L) {
            Intent intent = new Intent("android.location.GPS_FIX_CHANGE");
            intent.putExtra("enabled", false);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            this.updateStatus(1, this.mSvCount);
        }
    }

    private void reportAGpsStatus(int type, int status, byte[] ipaddr) {
        switch (status) {
            case 1: {
                if (DEBUG) {
                    Log.d("GnssLocationProvider", "GPS_REQUEST_AGPS_DATA_CONN");
                }
                Log.v("GnssLocationProvider", "Received SUPL IP addr[]: " + Arrays.toString(ipaddr));
                InetAddress connectionIpAddress = null;
                if (ipaddr != null) {
                    try {
                        connectionIpAddress = InetAddress.getByAddress(ipaddr);
                        if (DEBUG) {
                            Log.d("GnssLocationProvider", "IP address converted to: " + connectionIpAddress);
                        }
                    }
                    catch (UnknownHostException e) {
                        Log.e("GnssLocationProvider", "Bad IP Address: " + ipaddr, e);
                    }
                }
                this.sendMessage(14, 0, connectionIpAddress);
                break;
            }
            case 2: {
                if (DEBUG) {
                    Log.d("GnssLocationProvider", "GPS_RELEASE_AGPS_DATA_CONN");
                }
                this.releaseSuplConnection(2);
                break;
            }
            case 3: {
                if (!DEBUG) break;
                Log.d("GnssLocationProvider", "GPS_AGPS_DATA_CONNECTED");
                break;
            }
            case 4: {
                if (!DEBUG) break;
                Log.d("GnssLocationProvider", "GPS_AGPS_DATA_CONN_DONE");
                break;
            }
            case 5: {
                if (!DEBUG) break;
                Log.d("GnssLocationProvider", "GPS_AGPS_DATA_CONN_FAILED");
                break;
            }
            default: {
                if (!DEBUG) break;
                Log.d("GnssLocationProvider", "Received Unknown AGPS status: " + status);
            }
        }
    }

    private void releaseSuplConnection(int connStatus) {
        this.sendMessage(15, connStatus, null);
    }

    private void reportNmea(long timestamp) {
        if (!this.mItarSpeedLimitExceeded) {
            int length = this.native_read_nmea(this.mNmeaBuffer, this.mNmeaBuffer.length);
            String nmea = new String(this.mNmeaBuffer, 0, length);
            this.mListenerHelper.onNmeaReceived(timestamp, nmea);
        }
    }

    private void reportMeasurementData(GnssMeasurementsEvent event) {
        if (!this.mItarSpeedLimitExceeded) {
            this.mGnssMeasurementsProvider.onMeasurementsAvailable(event);
        }
    }

    private void reportNavigationMessage(GnssNavigationMessage event) {
        if (!this.mItarSpeedLimitExceeded) {
            this.mGnssNavigationMessageProvider.onNavigationMessageAvailable(event);
        }
    }

    private void setEngineCapabilities(int capabilities) {
        this.mEngineCapabilities = capabilities;
        if (this.hasCapability(16)) {
            this.mOnDemandTimeInjection = true;
            this.requestUtcTime();
        }
        this.mGnssMeasurementsProvider.onCapabilitiesUpdated((capabilities & 0x40) == 64);
        this.mGnssNavigationMessageProvider.onCapabilitiesUpdated((capabilities & 0x80) == 128);
    }

    private void setGnssYearOfHardware(int yearOfHardware) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "setGnssYearOfHardware called with " + yearOfHardware);
        }
        this.mYearOfHardware = yearOfHardware;
    }

    public GnssSystemInfoProvider getGnssSystemInfoProvider() {
        return new GnssSystemInfoProvider(){

            @Override
            public int getGnssYearOfHardware() {
                return GnssLocationProvider.this.mYearOfHardware;
            }
        };
    }

    public GnssBatchingProvider getGnssBatchingProvider() {
        return new GnssBatchingProvider(){

            @Override
            public int getSize() {
                return GnssLocationProvider.native_get_batch_size();
            }

            @Override
            public boolean start(long periodNanos, boolean wakeOnFifoFull) {
                if (periodNanos <= 0L) {
                    Log.e("GnssLocationProvider", "Invalid periodNanos " + periodNanos + "in batching request, not started");
                    return false;
                }
                return GnssLocationProvider.native_start_batch(periodNanos, wakeOnFifoFull);
            }

            @Override
            public void flush() {
                GnssLocationProvider.native_flush_batch();
            }

            @Override
            public boolean stop() {
                return GnssLocationProvider.native_stop_batch();
            }
        };
    }

    private void enableBatching() {
        if (!GnssLocationProvider.native_init_batching()) {
            Log.e("GnssLocationProvider", "Failed to initialize GNSS batching");
        }
    }

    private void disableBatching() {
        GnssLocationProvider.native_stop_batch();
        GnssLocationProvider.native_cleanup_batching();
    }

    private void reportLocationBatch(Location[] locationArray) {
        ArrayList<Location> locations = new ArrayList<Location>(Arrays.asList(locationArray));
        if (DEBUG) {
            Log.d("GnssLocationProvider", "Location batch of size " + locationArray.length + "reported");
        }
        try {
            this.mILocationManager.reportLocationBatch(locations);
        }
        catch (RemoteException e) {
            Log.e("GnssLocationProvider", "RemoteException calling reportLocationBatch");
        }
    }

    private void xtraDownloadRequest() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "xtraDownloadRequest");
        }
        this.sendMessage(6, 0, null);
    }

    private int getGeofenceStatus(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case -149: {
                return 5;
            }
            case -101: {
                return 2;
            }
            case -103: {
                return 4;
            }
            case 100: {
                return 1;
            }
            case -102: {
                return 3;
            }
        }
        return -1;
    }

    private void reportGeofenceTransition(int geofenceId, Location location, int transition2, long transitionTimestamp) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        this.mGeofenceHardwareImpl.reportGeofenceTransition(geofenceId, location, transition2, transitionTimestamp, 0, FusedBatchOptions.SourceTechnologies.GNSS);
    }

    private void reportGeofenceStatus(int status, Location location) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        int monitorStatus = 1;
        if (status == 2) {
            monitorStatus = 0;
        }
        this.mGeofenceHardwareImpl.reportGeofenceMonitorStatus(0, monitorStatus, location, FusedBatchOptions.SourceTechnologies.GNSS);
    }

    private void reportGeofenceAddStatus(int geofenceId, int status) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        this.mGeofenceHardwareImpl.reportGeofenceAddStatus(geofenceId, this.getGeofenceStatus(status));
    }

    private void reportGeofenceRemoveStatus(int geofenceId, int status) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        this.mGeofenceHardwareImpl.reportGeofenceRemoveStatus(geofenceId, this.getGeofenceStatus(status));
    }

    private void reportGeofencePauseStatus(int geofenceId, int status) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        this.mGeofenceHardwareImpl.reportGeofencePauseStatus(geofenceId, this.getGeofenceStatus(status));
    }

    private void reportGeofenceResumeStatus(int geofenceId, int status) {
        if (this.mGeofenceHardwareImpl == null) {
            this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        this.mGeofenceHardwareImpl.reportGeofenceResumeStatus(geofenceId, this.getGeofenceStatus(status));
    }

    public INetInitiatedListener getNetInitiatedListener() {
        return this.mNetInitiatedListener;
    }

    public void reportNiNotification(int notificationId, int niType, int notifyFlags, int timeout, int defaultResponse, String requestorId, String text, int requestorIdEncoding, int textEncoding) {
        Log.i("GnssLocationProvider", "reportNiNotification: entered");
        Log.i("GnssLocationProvider", "notificationId: " + notificationId + ", niType: " + niType + ", notifyFlags: " + notifyFlags + ", timeout: " + timeout + ", defaultResponse: " + defaultResponse);
        Log.i("GnssLocationProvider", "requestorId: " + requestorId + ", text: " + text + ", requestorIdEncoding: " + requestorIdEncoding + ", textEncoding: " + textEncoding);
        GpsNetInitiatedHandler.GpsNiNotification notification = new GpsNetInitiatedHandler.GpsNiNotification();
        notification.notificationId = notificationId;
        notification.niType = niType;
        notification.needNotify = (notifyFlags & 1) != 0;
        notification.needVerify = (notifyFlags & 2) != 0;
        notification.privacyOverride = (notifyFlags & 4) != 0;
        notification.timeout = timeout;
        notification.defaultResponse = defaultResponse;
        notification.requestorId = requestorId;
        notification.text = text;
        notification.requestorIdEncoding = requestorIdEncoding;
        notification.textEncoding = textEncoding;
        this.mNIHandler.handleNiNotification(notification);
    }

    private void requestSetID(int flags) {
        String data_temp;
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        int type = 0;
        String data = "";
        if ((flags & 1) == 1) {
            String data_temp2 = phone.getSubscriberId();
            if (data_temp2 != null) {
                data = data_temp2;
                type = 1;
            }
        } else if ((flags & 2) == 2 && (data_temp = phone.getLine1Number()) != null) {
            data = data_temp;
            type = 2;
        }
        this.native_agps_set_id(type, data);
    }

    private void requestUtcTime() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "utcTimeRequest");
        }
        this.sendMessage(5, 0, null);
    }

    private void requestRefLocation() {
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        int phoneType = phone.getPhoneType();
        if (phoneType == 1) {
            GsmCellLocation gsm_cell = (GsmCellLocation)phone.getCellLocation();
            if (gsm_cell != null && phone.getNetworkOperator() != null && phone.getNetworkOperator().length() > 3) {
                int mcc = Integer.parseInt(phone.getNetworkOperator().substring(0, 3));
                int mnc = Integer.parseInt(phone.getNetworkOperator().substring(3));
                int networkType = phone.getNetworkType();
                int type = networkType == 3 || networkType == 8 || networkType == 9 || networkType == 10 || networkType == 15 ? 2 : 1;
                this.native_agps_set_ref_location_cellid(type, mcc, mnc, gsm_cell.getLac(), gsm_cell.getCid());
            } else {
                Log.e("GnssLocationProvider", "Error getting cell location info.");
            }
        } else if (phoneType == 2) {
            Log.e("GnssLocationProvider", "CDMA not supported.");
        }
    }

    private void sendMessage(int message, int arg, Object obj) {
        this.mWakeLock.acquire();
        if (Log.isLoggable("GnssLocationProvider", 4)) {
            Log.i("GnssLocationProvider", "WakeLock acquired by sendMessage(" + this.messageIdAsString(message) + ", " + arg + ", " + obj + ")");
        }
        this.mHandler.obtainMessage(message, arg, 1, obj).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectedApn() {
        Uri uri = Uri.parse("content://telephony/carriers/preferapn");
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(uri, new String[]{"apn"}, null, null, "name ASC");
            if (cursor != null && cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            Log.e("GnssLocationProvider", "No APN found to select.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getApnIpType(String apn) {
        this.ensureInHandlerThread();
        if (apn == null) {
            return 0;
        }
        String selection = String.format("current = 1 and apn = '%s' and carrier_enabled = 1", apn);
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Telephony.Carriers.CONTENT_URI, new String[]{"protocol"}, selection, null, "name ASC");
            if (null != cursor && cursor.moveToFirst()) {
                int n = this.translateToApnIpType(cursor.getString(0), apn);
                return n;
            }
            Log.e("GnssLocationProvider", "No entry found in query for APN: " + apn);
        }
        return 0;
    }

    private int translateToApnIpType(String ipProtocol, String apn) {
        if ("IP".equals(ipProtocol)) {
            return 1;
        }
        if ("IPV6".equals(ipProtocol)) {
            return 2;
        }
        if ("IPV4V6".equals(ipProtocol)) {
            return 3;
        }
        String message = String.format("Unknown IP Protocol: %s, for APN: %s", ipProtocol, apn);
        Log.e("GnssLocationProvider", message);
        return 0;
    }

    private void setRouting() {
        if (this.mAGpsDataConnectionIpAddr == null) {
            return;
        }
        boolean result = this.mConnMgr.requestRouteToHostAddress(3, this.mAGpsDataConnectionIpAddr);
        if (!result) {
            Log.e("GnssLocationProvider", "Error requesting route to host: " + this.mAGpsDataConnectionIpAddr);
        } else if (DEBUG) {
            Log.d("GnssLocationProvider", "Successfully requested route to host: " + this.mAGpsDataConnectionIpAddr);
        }
    }

    private boolean isDataNetworkConnected() {
        NetworkInfo activeNetworkInfo = this.mConnMgr.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private void ensureInHandlerThread() {
        if (this.mHandler != null && Looper.myLooper() == this.mHandler.getLooper()) {
            return;
        }
        throw new RuntimeException("This method must run on the Handler thread.");
    }

    private String agpsDataConnStateAsString() {
        switch (this.mAGpsDataConnectionState) {
            case 0: {
                return "CLOSED";
            }
            case 2: {
                return "OPEN";
            }
            case 1: {
                return "OPENING";
            }
        }
        return "<Unknown>";
    }

    private String agpsDataConnStatusAsString(int agpsDataConnStatus) {
        switch (agpsDataConnStatus) {
            case 3: {
                return "CONNECTED";
            }
            case 4: {
                return "DONE";
            }
            case 5: {
                return "FAILED";
            }
            case 2: {
                return "RELEASE";
            }
            case 1: {
                return "REQUEST";
            }
        }
        return "<Unknown>";
    }

    private String messageIdAsString(int message) {
        switch (message) {
            case 2: {
                return "ENABLE";
            }
            case 3: {
                return "SET_REQUEST";
            }
            case 4: {
                return "UPDATE_NETWORK_STATE";
            }
            case 14: {
                return "REQUEST_SUPL_CONNECTION";
            }
            case 15: {
                return "RELEASE_SUPL_CONNECTION";
            }
            case 5: {
                return "INJECT_NTP_TIME";
            }
            case 6: {
                return "DOWNLOAD_XTRA_DATA";
            }
            case 10: {
                return "INJECT_NTP_TIME_FINISHED";
            }
            case 11: {
                return "DOWNLOAD_XTRA_DATA_FINISHED";
            }
            case 7: {
                return "UPDATE_LOCATION";
            }
            case 12: {
                return "SUBSCRIPTION_OR_SIM_CHANGED";
            }
            case 13: {
                return "INITIALIZE_HANDLER";
            }
        }
        return "<Unknown>";
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        StringBuilder s = new StringBuilder();
        s.append("  mFixInterval=").append(this.mFixInterval).append('\n');
        s.append("  mDisableGps (battery saver mode)=").append(this.mDisableGps).append('\n');
        s.append("  mEngineCapabilities=0x").append(Integer.toHexString(this.mEngineCapabilities));
        s.append(" ( ");
        if (this.hasCapability(1)) {
            s.append("SCHEDULING ");
        }
        if (this.hasCapability(2)) {
            s.append("MSB ");
        }
        if (this.hasCapability(4)) {
            s.append("MSA ");
        }
        if (this.hasCapability(8)) {
            s.append("SINGLE_SHOT ");
        }
        if (this.hasCapability(16)) {
            s.append("ON_DEMAND_TIME ");
        }
        if (this.hasCapability(32)) {
            s.append("GEOFENCING ");
        }
        if (this.hasCapability(64)) {
            s.append("MEASUREMENTS ");
        }
        if (this.hasCapability(128)) {
            s.append("NAV_MESSAGES ");
        }
        s.append(")\n");
        s.append("  internal state: ").append(this.native_get_internal_state());
        s.append("\n");
        pw.append(s);
    }

    private static native void class_init_native();

    private static native boolean native_is_supported();

    private static native boolean native_is_agps_ril_supported();

    private static native boolean native_is_gnss_configuration_supported();

    private native boolean native_init();

    private native void native_cleanup();

    private native boolean native_set_position_mode(int var1, int var2, int var3, int var4, int var5);

    private native boolean native_start();

    private native boolean native_stop();

    private native void native_delete_aiding_data(int var1);

    private native int native_read_sv_status(int[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    private native int native_read_nmea(byte[] var1, int var2);

    private native void native_inject_location(double var1, double var3, float var5);

    private native void native_inject_time(long var1, long var3, int var5);

    private native boolean native_supports_xtra();

    private native void native_inject_xtra_data(byte[] var1, int var2);

    private native String native_get_internal_state();

    private native void native_agps_data_conn_open(String var1, int var2);

    private native void native_agps_data_conn_closed();

    private native void native_agps_data_conn_failed();

    private native void native_agps_ni_message(byte[] var1, int var2);

    private native void native_set_agps_server(int var1, String var2, int var3);

    private native void native_send_ni_response(int var1, int var2);

    private native void native_agps_set_ref_location_cellid(int var1, int var2, int var3, int var4, int var5);

    private native void native_agps_set_id(int var1, String var2);

    private native void native_update_network_state(boolean var1, int var2, boolean var3, boolean var4, String var5, String var6);

    private static native boolean native_is_geofence_supported();

    private static native boolean native_add_geofence(int var0, double var1, double var3, double var5, int var7, int var8, int var9, int var10);

    private static native boolean native_remove_geofence(int var0);

    private static native boolean native_resume_geofence(int var0, int var1);

    private static native boolean native_pause_geofence(int var0);

    private static native boolean native_is_measurement_supported();

    private native boolean native_start_measurement_collection();

    private native boolean native_stop_measurement_collection();

    private static native boolean native_is_navigation_message_supported();

    private native boolean native_start_navigation_message_collection();

    private native boolean native_stop_navigation_message_collection();

    private static native boolean native_set_supl_version(int var0);

    private static native boolean native_set_supl_mode(int var0);

    private static native boolean native_set_supl_es(int var0);

    private static native boolean native_set_lpp_profile(int var0);

    private static native boolean native_set_gnss_pos_protocol_select(int var0);

    private static native boolean native_set_gps_lock(int var0);

    private static native boolean native_set_emergency_supl_pdn(int var0);

    private static native int native_get_batch_size();

    private static native boolean native_start_batch(long var0, boolean var2);

    private static native void native_flush_batch();

    private static native boolean native_stop_batch();

    private static native boolean native_init_batching();

    private static native void native_cleanup_batching();

    static {
        GnssLocationProvider.class_init_native();
    }

    private static final class BackOff {
        private static final int MULTIPLIER = 2;
        private final long mInitIntervalMillis;
        private final long mMaxIntervalMillis;
        private long mCurrentIntervalMillis;

        public BackOff(long initIntervalMillis, long maxIntervalMillis) {
            this.mInitIntervalMillis = initIntervalMillis;
            this.mMaxIntervalMillis = maxIntervalMillis;
            this.mCurrentIntervalMillis = this.mInitIntervalMillis / 2L;
        }

        public long nextBackoffMillis() {
            if (this.mCurrentIntervalMillis > this.mMaxIntervalMillis) {
                return this.mMaxIntervalMillis;
            }
            this.mCurrentIntervalMillis *= 2L;
            return this.mCurrentIntervalMillis;
        }

        public void reset() {
            this.mCurrentIntervalMillis = this.mInitIntervalMillis / 2L;
        }
    }

    private final class NetworkLocationListener
    implements LocationListener {
        private NetworkLocationListener() {
        }

        @Override
        public void onLocationChanged(Location location) {
            if ("network".equals(location.getProvider())) {
                GnssLocationProvider.this.handleUpdateLocation(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    }

    private final class ProviderHandler
    extends Handler {
        public ProviderHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            int message = msg.what;
            switch (message) {
                case 2: {
                    if (msg.arg1 == 1) {
                        GnssLocationProvider.this.handleEnable();
                        break;
                    }
                    GnssLocationProvider.this.handleDisable();
                    break;
                }
                case 3: {
                    GpsRequest gpsRequest = (GpsRequest)msg.obj;
                    GnssLocationProvider.this.handleSetRequest(gpsRequest.request, gpsRequest.source);
                    break;
                }
                case 4: {
                    GnssLocationProvider.this.handleUpdateNetworkState((Network)msg.obj);
                    break;
                }
                case 14: {
                    GnssLocationProvider.this.handleRequestSuplConnection((InetAddress)msg.obj);
                    break;
                }
                case 15: {
                    GnssLocationProvider.this.handleReleaseSuplConnection(msg.arg1);
                    break;
                }
                case 5: {
                    GnssLocationProvider.this.handleInjectNtpTime();
                    break;
                }
                case 6: {
                    GnssLocationProvider.this.handleDownloadXtraData();
                    break;
                }
                case 10: {
                    GnssLocationProvider.this.mInjectNtpTimePending = 2;
                    break;
                }
                case 11: {
                    GnssLocationProvider.this.mDownloadXtraDataPending = 2;
                    break;
                }
                case 7: {
                    GnssLocationProvider.this.handleUpdateLocation((Location)msg.obj);
                    break;
                }
                case 12: {
                    GnssLocationProvider.this.subscriptionOrSimChanged(GnssLocationProvider.this.mContext);
                    break;
                }
                case 13: {
                    this.handleInitialize();
                }
            }
            if (msg.arg2 == 1) {
                GnssLocationProvider.this.mWakeLock.release();
                if (Log.isLoggable("GnssLocationProvider", 4)) {
                    Log.i("GnssLocationProvider", "WakeLock released by handleMessage(" + GnssLocationProvider.this.messageIdAsString(message) + ", " + msg.arg1 + ", " + msg.obj + ")");
                }
            }
        }

        private void handleInitialize() {
            IntentFilter intentFilter;
            GnssLocationProvider.this.reloadGpsProperties(GnssLocationProvider.this.mContext, GnssLocationProvider.this.mProperties);
            SubscriptionManager.from(GnssLocationProvider.this.mContext).addOnSubscriptionsChangedListener(GnssLocationProvider.this.mOnSubscriptionsChangedListener);
            if (GnssLocationProvider.native_is_agps_ril_supported()) {
                intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.DATA_SMS_RECEIVED");
                intentFilter.addDataScheme("sms");
                intentFilter.addDataAuthority("localhost", "7275");
                GnssLocationProvider.this.mContext.registerReceiver(GnssLocationProvider.this.mBroadcastReceiver, intentFilter, null, this);
                intentFilter = new IntentFilter();
                intentFilter.addAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
                try {
                    intentFilter.addDataType("application/vnd.omaloc-supl-init");
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w("GnssLocationProvider", "Malformed SUPL init mime type");
                }
                GnssLocationProvider.this.mContext.registerReceiver(GnssLocationProvider.this.mBroadcastReceiver, intentFilter, null, this);
            } else if (DEBUG) {
                Log.d("GnssLocationProvider", "Skipped registration for SMS/WAP-PUSH messages because AGPS Ril in GPS HAL is not supported");
            }
            intentFilter = new IntentFilter();
            intentFilter.addAction(GnssLocationProvider.ALARM_WAKEUP);
            intentFilter.addAction(GnssLocationProvider.ALARM_TIMEOUT);
            intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
            intentFilter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction(GnssLocationProvider.SIM_STATE_CHANGED);
            GnssLocationProvider.this.mContext.registerReceiver(GnssLocationProvider.this.mBroadcastReceiver, intentFilter, null, this);
            NetworkRequest.Builder networkRequestBuilder = new NetworkRequest.Builder();
            networkRequestBuilder.addTransportType(0);
            networkRequestBuilder.addTransportType(1);
            NetworkRequest networkRequest = networkRequestBuilder.build();
            GnssLocationProvider.this.mConnMgr.registerNetworkCallback(networkRequest, GnssLocationProvider.this.mNetworkConnectivityCallback);
            LocationManager locManager = (LocationManager)GnssLocationProvider.this.mContext.getSystemService("location");
            long minTime = 0L;
            float minDistance = 0.0f;
            boolean oneShot = false;
            LocationRequest request = LocationRequest.createFromDeprecatedProvider("passive", minTime, minDistance, oneShot);
            request.setHideFromAppOps(true);
            locManager.requestLocationUpdates(request, new NetworkLocationListener(), this.getLooper());
        }
    }

    public static interface GnssBatchingProvider {
        public int getSize();

        public boolean start(long var1, boolean var3);

        public void flush();

        public boolean stop();
    }

    public static interface GnssSystemInfoProvider {
        public int getGnssYearOfHardware();
    }

    static interface SetCarrierProperty {
        public boolean set(int var1);
    }

    private static class GpsRequest {
        public ProviderRequest request;
        public WorkSource source;

        public GpsRequest(ProviderRequest request, WorkSource source) {
            this.request = request;
            this.source = source;
        }
    }
}

