/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.firewall;

import android.content.ComponentName;
import android.content.Intent;
import com.android.server.firewall.Filter;
import com.android.server.firewall.FilterFactory;
import com.android.server.firewall.IntentFirewall;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class CategoryFilter
implements Filter {
    private static final String ATTR_NAME = "name";
    private final String mCategoryName;
    public static final FilterFactory FACTORY = new FilterFactory("category"){

        @Override
        public Filter newFilter(XmlPullParser parser) throws IOException, XmlPullParserException {
            String categoryName = parser.getAttributeValue(null, CategoryFilter.ATTR_NAME);
            if (categoryName == null) {
                throw new XmlPullParserException("Category name must be specified.", parser, null);
            }
            return new CategoryFilter(categoryName);
        }
    };

    private CategoryFilter(String categoryName) {
        this.mCategoryName = categoryName;
    }

    @Override
    public boolean matches(IntentFirewall ifw, ComponentName resolvedComponent, Intent intent, int callerUid, int callerPid, String resolvedType, int receivingUid) {
        Set<String> categories = intent.getCategories();
        if (categories == null) {
            return false;
        }
        return categories.contains(this.mCategoryName);
    }
}

