/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.FingerprintUtils;

public abstract class RemovalClient
extends ClientMonitor {
    private int mFingerId;

    public RemovalClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int fingerId, int groupId, int userId, boolean restricted, String owner) {
        super(context, halDeviceId, token, receiver, userId, groupId, restricted, owner);
        this.mFingerId = fingerId;
    }

    @Override
    public int start() {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        try {
            int result = daemon.remove(this.getGroupId(), this.mFingerId);
            if (result != 0) {
                Slog.w("FingerprintService", "startRemove with id = " + this.mFingerId + " failed, result=" + result);
                MetricsLogger.histogram(this.getContext(), "fingerprintd_remove_start_error", result);
                this.onError(1, 0);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startRemove failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w("FingerprintService", "stopRemove: already cancelled!");
            return 0;
        }
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "stopRemoval: no fingerprint HAL!");
            return 3;
        }
        try {
            int result = daemon.cancel();
            if (result != 0) {
                Slog.w("FingerprintService", "stopRemoval failed, result=" + result);
                return result;
            }
            Slog.w("FingerprintService", "client " + this.getOwnerString() + " is no longer removing");
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "stopRemoval failed", e);
            return 3;
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    private boolean sendRemoved(int fingerId, int groupId, int remaining) {
        IFingerprintServiceReceiver receiver = this.getReceiver();
        try {
            if (receiver != null) {
                receiver.onRemoved(this.getHalDeviceId(), fingerId, groupId, remaining);
            }
        }
        catch (RemoteException e) {
            Slog.w("FingerprintService", "Failed to notify Removed:", e);
        }
        return remaining == 0;
    }

    @Override
    public boolean onRemoved(int fingerId, int groupId, int remaining) {
        if (fingerId != 0) {
            FingerprintUtils.getInstance().removeFingerprintIdForUser(this.getContext(), fingerId, this.getTargetUserId());
        }
        return this.sendRemoved(fingerId, this.getGroupId(), remaining);
    }

    @Override
    public boolean onEnrollResult(int fingerId, int groupId, int rem) {
        Slog.w("FingerprintService", "onEnrollResult() called for remove!");
        return true;
    }

    @Override
    public boolean onAuthenticated(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onAuthenticated() called for remove!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onEnumerationResult() called for remove!");
        return true;
    }
}

