/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.emergency;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.server.SystemService;
import java.util.ArrayList;
import java.util.List;

public class EmergencyAffordanceService
extends SystemService {
    private static final String TAG = "EmergencyAffordanceService";
    private static final int NUM_SCANS_UNTIL_ABORT = 4;
    private static final int INITIALIZE_STATE = 1;
    private static final int CELL_INFO_STATE_CHANGED = 2;
    private static final int SUBSCRIPTION_CHANGED = 3;
    private static final String EMERGENCY_SIM_INSERTED_SETTING = "emergency_sim_inserted_before";
    private final Context mContext;
    private final ArrayList<Integer> mEmergencyCallMccNumbers;
    private final Object mLock = new Object();
    private TelephonyManager mTelephonyManager;
    private SubscriptionManager mSubscriptionManager;
    private boolean mEmergencyAffordanceNeeded;
    private MyHandler mHandler;
    private int mScansCompleted;
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onCellInfoChanged(List<CellInfo> cellInfo) {
            if (!EmergencyAffordanceService.this.isEmergencyAffordanceNeeded()) {
                EmergencyAffordanceService.this.requestCellScan();
            }
        }

        @Override
        public void onCellLocationChanged(CellLocation location) {
            if (!EmergencyAffordanceService.this.isEmergencyAffordanceNeeded()) {
                EmergencyAffordanceService.this.requestCellScan();
            }
        }
    };
    private BroadcastReceiver mAirplaneModeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0) == 0) {
                EmergencyAffordanceService.this.startScanning();
                EmergencyAffordanceService.this.requestCellScan();
            }
        }
    };
    private boolean mSimNeedsEmergencyAffordance;
    private boolean mNetworkNeedsEmergencyAffordance;
    private boolean mVoiceCapable;
    private SubscriptionManager.OnSubscriptionsChangedListener mSubscriptionChangedListener = new SubscriptionManager.OnSubscriptionsChangedListener(){

        @Override
        public void onSubscriptionsChanged() {
            EmergencyAffordanceService.this.mHandler.obtainMessage(3).sendToTarget();
        }
    };

    private void requestCellScan() {
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    public EmergencyAffordanceService(Context context) {
        super(context);
        this.mContext = context;
        int[] numbers = context.getResources().getIntArray(17236004);
        this.mEmergencyCallMccNumbers = new ArrayList(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            this.mEmergencyCallMccNumbers.add(numbers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmergencyAffordanceNeeded() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEmergencyAffordanceNeeded = this.mVoiceCapable && (this.mSimNeedsEmergencyAffordance || this.mNetworkNeedsEmergencyAffordance);
            Settings.Global.putInt(this.mContext.getContentResolver(), "emergency_affordance_needed", this.mEmergencyAffordanceNeeded ? 1 : 0);
            if (this.mEmergencyAffordanceNeeded) {
                this.stopScanning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScanning() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
            this.mScansCompleted = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmergencyAffordanceNeeded() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEmergencyAffordanceNeeded;
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            this.mTelephonyManager = this.mContext.getSystemService(TelephonyManager.class);
            this.mVoiceCapable = this.mTelephonyManager.isVoiceCapable();
            if (!this.mVoiceCapable) {
                this.updateEmergencyAffordanceNeeded();
                return;
            }
            this.mSubscriptionManager = SubscriptionManager.from(this.mContext);
            HandlerThread thread = new HandlerThread(TAG);
            thread.start();
            this.mHandler = new MyHandler(thread.getLooper());
            this.mHandler.obtainMessage(1).sendToTarget();
            this.startScanning();
            IntentFilter filter = new IntentFilter("android.intent.action.AIRPLANE_MODE");
            this.mContext.registerReceiver(this.mAirplaneModeReceiver, filter);
            this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mSubscriptionChangedListener);
        }
    }

    private void startScanning() {
        this.mTelephonyManager.listen(this.mPhoneStateListener, 1040);
    }

    private void handleInitializeState() {
        if (this.handleUpdateSimSubscriptionInfo()) {
            return;
        }
        if (this.handleUpdateCellInfo()) {
            return;
        }
        this.updateEmergencyAffordanceNeeded();
    }

    private boolean handleUpdateSimSubscriptionInfo() {
        boolean neededBefore;
        boolean neededNow = neededBefore = this.simNeededAffordanceBefore();
        List<SubscriptionInfo> activeSubscriptionInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        if (activeSubscriptionInfoList == null) {
            this.setSimNeedsEmergencyAffordance(neededNow);
            return neededNow;
        }
        for (SubscriptionInfo info : activeSubscriptionInfoList) {
            int mcc = info.getMcc();
            if (this.mccRequiresEmergencyAffordance(mcc)) {
                neededNow = true;
                break;
            }
            if (mcc != 0 && mcc != Integer.MAX_VALUE) {
                neededNow = false;
            }
            String simOperator = this.mTelephonyManager.getSimOperator(info.getSubscriptionId());
            mcc = 0;
            if (simOperator != null && simOperator.length() >= 3) {
                mcc = Integer.parseInt(simOperator.substring(0, 3));
            }
            if (mcc == 0) continue;
            if (this.mccRequiresEmergencyAffordance(mcc)) {
                neededNow = true;
                break;
            }
            neededNow = false;
        }
        this.setSimNeedsEmergencyAffordance(neededNow);
        return neededNow;
    }

    private void setSimNeedsEmergencyAffordance(boolean simNeedsEmergencyAffordance) {
        if (this.simNeededAffordanceBefore() != simNeedsEmergencyAffordance) {
            Settings.Global.putInt(this.mContext.getContentResolver(), EMERGENCY_SIM_INSERTED_SETTING, simNeedsEmergencyAffordance ? 1 : 0);
        }
        if (simNeedsEmergencyAffordance != this.mSimNeedsEmergencyAffordance) {
            this.mSimNeedsEmergencyAffordance = simNeedsEmergencyAffordance;
            this.updateEmergencyAffordanceNeeded();
        }
    }

    private boolean simNeededAffordanceBefore() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), EMERGENCY_SIM_INSERTED_SETTING, 0) != 0;
    }

    private boolean handleUpdateCellInfo() {
        List<CellInfo> cellInfos = this.mTelephonyManager.getAllCellInfo();
        if (cellInfos == null) {
            return false;
        }
        boolean stopScanningAfterScan = false;
        for (CellInfo cellInfo : cellInfos) {
            int mcc = 0;
            if (cellInfo instanceof CellInfoGsm) {
                mcc = ((CellInfoGsm)cellInfo).getCellIdentity().getMcc();
            } else if (cellInfo instanceof CellInfoLte) {
                mcc = ((CellInfoLte)cellInfo).getCellIdentity().getMcc();
            } else if (cellInfo instanceof CellInfoWcdma) {
                mcc = ((CellInfoWcdma)cellInfo).getCellIdentity().getMcc();
            }
            if (this.mccRequiresEmergencyAffordance(mcc)) {
                this.setNetworkNeedsEmergencyAffordance(true);
                return true;
            }
            if (mcc == 0 || mcc == Integer.MAX_VALUE) continue;
            stopScanningAfterScan = true;
        }
        if (stopScanningAfterScan) {
            this.stopScanning();
        } else {
            this.onCellScanFinishedUnsuccessful();
        }
        this.setNetworkNeedsEmergencyAffordance(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNetworkNeedsEmergencyAffordance(boolean needsAffordance) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkNeedsEmergencyAffordance = needsAffordance;
            this.updateEmergencyAffordanceNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCellScanFinishedUnsuccessful() {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mScansCompleted;
            if (this.mScansCompleted >= 4) {
                this.stopScanning();
            }
        }
    }

    private boolean mccRequiresEmergencyAffordance(int mcc) {
        return this.mEmergencyCallMccNumbers.contains(mcc);
    }

    private class MyHandler
    extends Handler {
        public MyHandler(Looper l) {
            super(l);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    EmergencyAffordanceService.this.handleInitializeState();
                    break;
                }
                case 2: {
                    EmergencyAffordanceService.this.handleUpdateCellInfo();
                    break;
                }
                case 3: {
                    EmergencyAffordanceService.this.handleUpdateSimSubscriptionInfo();
                }
            }
        }
    }
}

