/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

final class HysteresisLevels {
    private static final String TAG = "HysteresisLevels";
    private static final float DEFAULT_BRIGHTENING_HYSTERESIS = 0.1f;
    private static final float DEFAULT_DARKENING_HYSTERESIS = 0.2f;
    private static final boolean DEBUG = false;
    private final float[] mBrightLevels;
    private final float[] mDarkLevels;
    private final float[] mLuxLevels;

    public HysteresisLevels(int[] brightLevels, int[] darkLevels, int[] luxLevels) {
        if (brightLevels.length != darkLevels.length || darkLevels.length != luxLevels.length + 1) {
            throw new IllegalArgumentException("Mismatch between hysteresis array lengths.");
        }
        this.mBrightLevels = this.setArrayFormat(brightLevels, 1000.0f);
        this.mDarkLevels = this.setArrayFormat(darkLevels, 1000.0f);
        this.mLuxLevels = this.setArrayFormat(luxLevels, 1.0f);
    }

    public float getBrighteningThreshold(float lux) {
        float brightConstant = this.getReferenceLevel(lux, this.mBrightLevels);
        float brightThreshold = lux * (1.0f + brightConstant);
        return brightThreshold;
    }

    public float getDarkeningThreshold(float lux) {
        float darkConstant = this.getReferenceLevel(lux, this.mDarkLevels);
        float darkThreshold = lux * (1.0f - darkConstant);
        return darkThreshold;
    }

    private float getReferenceLevel(float lux, float[] referenceLevels) {
        int index;
        for (index = 0; this.mLuxLevels.length > index && lux >= this.mLuxLevels[index]; ++index) {
        }
        return referenceLevels[index];
    }

    private float[] setArrayFormat(int[] configArray, float divideFactor) {
        float[] levelArray = new float[configArray.length];
        for (int index = 0; levelArray.length > index; ++index) {
            levelArray[index] = (float)configArray[index] / divideFactor;
        }
        return levelArray;
    }
}

