/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.IDeviceAdminService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.server.am.PersistentConnection;
import com.android.server.devicepolicy.DevicePolicyConstants;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.io.PrintWriter;
import java.util.List;

public class DeviceAdminServiceController {
    static final String TAG = "DevicePolicyManager";
    static final boolean DEBUG = false;
    final Object mLock = new Object();
    final Context mContext;
    private final DevicePolicyManagerService mService;
    private final DevicePolicyManagerService.Injector mInjector;
    private final DevicePolicyConstants mConstants;
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private final SparseArray<DevicePolicyServiceConnection> mConnections = new SparseArray();

    static void debug(String format, Object ... args) {
    }

    public DeviceAdminServiceController(DevicePolicyManagerService service, DevicePolicyConstants constants) {
        this.mService = service;
        this.mInjector = service.mInjector;
        this.mContext = this.mInjector.mContext;
        this.mHandler = new Handler(BackgroundThread.get().getLooper());
        this.mConstants = constants;
    }

    private ServiceInfo findService(String packageName, int userId) {
        Intent intent = new Intent("android.app.action.DEVICE_ADMIN_SERVICE");
        intent.setPackage(packageName);
        try {
            ParceledListSlice pls = this.mInjector.getIPackageManager().queryIntentServices(intent, null, 0, userId);
            if (pls == null) {
                return null;
            }
            List list = pls.getList();
            if (list.size() == 0) {
                return null;
            }
            if (list.size() > 1) {
                Log.e(TAG, "More than one DeviceAdminService's found in package " + packageName + ".  They'll all be ignored.");
                return null;
            }
            ServiceInfo si = ((ResolveInfo)list.get((int)0)).serviceInfo;
            if (!"android.permission.BIND_DEVICE_ADMIN".equals(si.permission)) {
                Log.e(TAG, "DeviceAdminService " + si.getComponentName().flattenToShortString() + " must be protected with " + "android.permission.BIND_DEVICE_ADMIN" + ".");
                return null;
            }
            return si;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServiceForOwner(String packageName, int userId, String actionForLog) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                ServiceInfo service;
                block9: {
                    service = this.findService(packageName, userId);
                    if (service != null) break block9;
                    DeviceAdminServiceController.debug("Owner package %s on u%d has no service.", packageName, userId);
                    this.disconnectServiceOnUserLocked(userId, actionForLog);
                    return;
                }
                PersistentConnection existing = this.mConnections.get(userId);
                if (existing != null) {
                    DeviceAdminServiceController.debug("Disconnecting from existing service connection.", packageName, userId);
                    this.disconnectServiceOnUserLocked(userId, actionForLog);
                }
                DeviceAdminServiceController.debug("Owner package %s on u%d has service %s for %s", packageName, userId, service.getComponentName().flattenToShortString(), actionForLog);
                DevicePolicyServiceConnection conn = new DevicePolicyServiceConnection(userId, service.getComponentName());
                this.mConnections.put(userId, conn);
                conn.bind();
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceForOwner(int userId, String actionForLog) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.disconnectServiceOnUserLocked(userId, actionForLog);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void disconnectServiceOnUserLocked(int userId, String actionForLog) {
        DevicePolicyServiceConnection conn = this.mConnections.get(userId);
        if (conn != null) {
            DeviceAdminServiceController.debug("Stopping service for u%d if already running for %s.", userId, actionForLog);
            conn.unbind();
            this.mConnections.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnections.size() == 0) {
                return;
            }
            pw.println();
            pw.print(prefix);
            pw.println("Owner Services:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                int userId = this.mConnections.keyAt(i);
                pw.print(prefix);
                pw.print("  ");
                pw.print("User: ");
                pw.println(userId);
                DevicePolicyServiceConnection con = this.mConnections.valueAt(i);
                con.dump(prefix + "    ", pw);
            }
            pw.println();
        }
    }

    private class DevicePolicyServiceConnection
    extends PersistentConnection<IDeviceAdminService> {
        public DevicePolicyServiceConnection(int userId, ComponentName componentName) {
            super(DeviceAdminServiceController.TAG, DeviceAdminServiceController.this.mContext, DeviceAdminServiceController.this.mHandler, userId, componentName, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_BACKOFF_SEC, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_BACKOFF_INCREASE, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_MAX_BACKOFF_SEC);
        }

        @Override
        protected IDeviceAdminService asInterface(IBinder binder) {
            return IDeviceAdminService.Stub.asInterface(binder);
        }
    }
}

