/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.INotificationManager;
import android.app.backup.BlobBackupHelper;
import android.content.Context;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;

public class NotificationBackupHelper
extends BlobBackupHelper {
    static final String TAG = "NotifBackupHelper";
    static final boolean DEBUG = Log.isLoggable("NotifBackupHelper", 3);
    static final int BLOB_VERSION = 1;
    static final String KEY_NOTIFICATIONS = "notifications";

    public NotificationBackupHelper(Context context) {
        super(1, KEY_NOTIFICATIONS);
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        byte[] newPayload = null;
        if (KEY_NOTIFICATIONS.equals(key)) {
            try {
                INotificationManager nm = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
                newPayload = nm.getBackupPayload(0);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with notification manager");
                newPayload = null;
            }
        }
        return newPayload;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        if (DEBUG) {
            Slog.v(TAG, "Got restore of " + key);
        }
        if (KEY_NOTIFICATIONS.equals(key)) {
            try {
                INotificationManager nm = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
                nm.applyRestore(payload, 0);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with notification manager");
            }
        }
    }
}

