/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Point;
import android.graphics.Rect;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.text.TextUtils;
import android.util.Slog;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListView;
import android.widget.RemoteViews;
import com.android.server.UiThread;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.OverlayControl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import libcore.util.Objects;

final class FillUi {
    private static final String TAG = "FillUi";
    private static final int VISIBLE_OPTIONS_MAX_COUNT = 3;
    private static final TypedValue sTempTypedValue = new TypedValue();
    private final Point mTempPoint = new Point();
    private final AutofillWindowPresenter mWindowPresenter = new AutofillWindowPresenter();
    private final Context mContext;
    private final AnchoredWindow mWindow;
    private final Callback mCallback;
    private final ListView mListView;
    private final ItemsAdapter mAdapter;
    private String mFilterText;
    private AnnounceFilterResult mAnnounceFilterResult;
    private int mContentWidth;
    private int mContentHeight;
    private boolean mDestroyed;

    FillUi(Context context, FillResponse response, AutofillId focusedViewId, String filterText, OverlayControl overlayControl, Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
        LayoutInflater inflater = LayoutInflater.from(context);
        ViewGroup decor = (ViewGroup)inflater.inflate(17367100, null);
        RemoteViews.OnClickHandler interceptionHandler = new RemoteViews.OnClickHandler(){

            @Override
            public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
                if (pendingIntent != null) {
                    FillUi.this.mCallback.startIntentSender(pendingIntent.getIntentSender());
                }
                return true;
            }
        };
        if (response.getAuthentication() != null) {
            View content;
            this.mListView = null;
            this.mAdapter = null;
            try {
                content = response.getPresentation().apply(context, decor, interceptionHandler);
                decor.addView(content);
            }
            catch (RuntimeException e) {
                callback.onCanceled();
                Slog.e(TAG, "Error inflating remote views", e);
                this.mWindow = null;
                return;
            }
            Point maxSize = this.mTempPoint;
            FillUi.resolveMaxWindowSize(context, maxSize);
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
            decor.measure(widthMeasureSpec, heightMeasureSpec);
            decor.setOnClickListener(v -> this.mCallback.onResponsePicked(response));
            this.mContentWidth = content.getMeasuredWidth();
            this.mContentHeight = content.getMeasuredHeight();
            this.mWindow = new AnchoredWindow(decor, overlayControl);
            this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
        } else {
            int datasetCount = response.getDatasets().size();
            ArrayList<ViewItem> items = new ArrayList<ViewItem>(datasetCount);
            for (int i = 0; i < datasetCount; ++i) {
                View view2;
                Dataset dataset = response.getDatasets().get(i);
                int index = dataset.getFieldIds().indexOf(focusedViewId);
                if (index < 0) continue;
                RemoteViews presentation = dataset.getFieldPresentation(index);
                try {
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "setting remote view for " + focusedViewId);
                    }
                    view2 = presentation.apply(context, null, interceptionHandler);
                }
                catch (RuntimeException e) {
                    Slog.e(TAG, "Error inflating remote views", e);
                    continue;
                }
                AutofillValue value = dataset.getFieldValues().get(index);
                String valueText = null;
                if (value != null && value.isText() && dataset.getAuthentication() == null) {
                    valueText = value.getTextValue().toString().toLowerCase();
                }
                items.add(new ViewItem(dataset, valueText, view2));
            }
            this.mAdapter = new ItemsAdapter(items);
            this.mListView = (ListView)decor.findViewById(16908724);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setVisibility(0);
            this.mListView.setOnItemClickListener((adapter, view, position, id2) -> {
                ViewItem vi = this.mAdapter.getItem(position);
                this.mCallback.onDatasetPicked(vi.getDataset());
            });
            this.mFilterText = filterText == null ? null : filterText.toLowerCase();
            this.applyNewFilterText();
            this.mWindow = new AnchoredWindow(decor, overlayControl);
        }
    }

    private void applyNewFilterText() {
        int oldCount = this.mAdapter.getCount();
        this.mAdapter.getFilter().filter(this.mFilterText, count -> {
            if (this.mDestroyed) {
                return;
            }
            if (count <= 0) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "No dataset matches filter: " + this.mFilterText);
                }
                this.mCallback.requestHideFillUi();
            } else {
                if (this.updateContentSize()) {
                    this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
                }
                if (this.mAdapter.getCount() > 3) {
                    this.mListView.setVerticalScrollBarEnabled(true);
                    this.mListView.onVisibilityAggregated(true);
                } else {
                    this.mListView.setVerticalScrollBarEnabled(false);
                }
                if (this.mAdapter.getCount() != oldCount) {
                    this.mListView.requestLayout();
                }
            }
        });
    }

    public void setFilterText(String filterText) {
        this.throwIfDestroyed();
        if (this.mAdapter == null) {
            return;
        }
        if (Objects.equal(this.mFilterText, filterText = filterText == null ? null : filterText.toLowerCase())) {
            return;
        }
        this.mFilterText = filterText;
        this.applyNewFilterText();
    }

    public void destroy() {
        this.throwIfDestroyed();
        this.mCallback.onDestroy();
        this.mCallback.requestHideFillUi();
        this.mDestroyed = true;
    }

    private boolean updateContentSize() {
        if (this.mAdapter == null) {
            return false;
        }
        boolean changed = false;
        if (this.mAdapter.getCount() <= 0) {
            if (this.mContentWidth != 0) {
                this.mContentWidth = 0;
                changed = true;
            }
            if (this.mContentHeight != 0) {
                this.mContentHeight = 0;
                changed = true;
            }
            return changed;
        }
        Point maxSize = this.mTempPoint;
        FillUi.resolveMaxWindowSize(this.mContext, maxSize);
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
        int itemCount = this.mAdapter.getCount();
        for (int i = 0; i < itemCount; ++i) {
            int clampedMeasuredHeight;
            int newContentHeight;
            View view = this.mAdapter.getItem(i).getView();
            view.measure(widthMeasureSpec, heightMeasureSpec);
            int clampedMeasuredWidth = Math.min(view.getMeasuredWidth(), maxSize.x);
            int newContentWidth = Math.max(this.mContentWidth, clampedMeasuredWidth);
            if (newContentWidth != this.mContentWidth) {
                this.mContentWidth = newContentWidth;
                changed = true;
            }
            if (i >= 3 || (newContentHeight = this.mContentHeight + (clampedMeasuredHeight = Math.min(view.getMeasuredHeight(), maxSize.y))) == this.mContentHeight) continue;
            this.mContentHeight = newContentHeight;
            changed = true;
        }
        return changed;
    }

    private void throwIfDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("cannot interact with a destroyed instance");
        }
    }

    private static void resolveMaxWindowSize(Context context, Point outPoint) {
        context.getDisplay().getSize(outPoint);
        TypedValue typedValue = sTempTypedValue;
        context.getTheme().resolveAttribute(0x1110010, typedValue, true);
        outPoint.x = (int)typedValue.getFraction(outPoint.x, outPoint.x);
        context.getTheme().resolveAttribute(0x111000F, typedValue, true);
        outPoint.y = (int)typedValue.getFraction(outPoint.y, outPoint.y);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mCallback: ");
        pw.println(this.mCallback != null);
        pw.print(prefix);
        pw.print("mListView: ");
        pw.println(this.mListView);
        pw.print(prefix);
        pw.print("mAdapter: ");
        pw.println(this.mAdapter != null);
        pw.print(prefix);
        pw.print("mFilterText: ");
        pw.println(this.mFilterText);
        pw.print(prefix);
        pw.print("mContentWidth: ");
        pw.println(this.mContentWidth);
        pw.print(prefix);
        pw.print("mContentHeight: ");
        pw.println(this.mContentHeight);
        pw.print(prefix);
        pw.print("mDestroyed: ");
        pw.println(this.mDestroyed);
        pw.print(prefix);
        pw.print("mWindow: ");
        if (this.mWindow == null) {
            pw.println("N/A");
        } else {
            String prefix2 = prefix + "  ";
            pw.println();
            pw.print(prefix2);
            pw.print("showing: ");
            pw.println(this.mWindow.mShowing);
            pw.print(prefix2);
            pw.print("view: ");
            pw.println(this.mWindow.mContentView);
            pw.print(prefix2);
            pw.print("screen coordinates: ");
            if (this.mWindow.mContentView == null) {
                pw.println("N/A");
            } else {
                int[] coordinates = this.mWindow.mContentView.getLocationOnScreen();
                pw.print(coordinates[0]);
                pw.print("x");
                pw.println(coordinates[1]);
            }
        }
    }

    private void announceSearchResultIfNeeded() {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAnnounceFilterResult == null) {
                this.mAnnounceFilterResult = new AnnounceFilterResult();
            }
            this.mAnnounceFilterResult.post();
        }
    }

    private final class AnnounceFilterResult
    implements Runnable {
        private static final int SEARCH_RESULT_ANNOUNCEMENT_DELAY = 1000;

        private AnnounceFilterResult() {
        }

        public void post() {
            this.remove();
            FillUi.this.mListView.postDelayed(this, 1000L);
        }

        public void remove() {
            FillUi.this.mListView.removeCallbacks(this);
        }

        @Override
        public void run() {
            int count = FillUi.this.mListView.getAdapter().getCount();
            String text = count <= 0 ? FillUi.this.mContext.getString(17039540) : FillUi.this.mContext.getResources().getQuantityString(0x1150000, count, count);
            FillUi.this.mListView.announceForAccessibility(text);
        }
    }

    private final class ItemsAdapter
    extends BaseAdapter
    implements Filterable {
        private final List<ViewItem> mAllItems;
        private final List<ViewItem> mFilteredItems = new ArrayList<ViewItem>();

        ItemsAdapter(List<ViewItem> items) {
            this.mAllItems = Collections.unmodifiableList(new ArrayList<ViewItem>(items));
            this.mFilteredItems.addAll(items);
        }

        @Override
        public Filter getFilter() {
            return new Filter(){

                @Override
                protected Filter.FilterResults performFiltering(CharSequence constraint) {
                    Filter.FilterResults results = new Filter.FilterResults();
                    if (TextUtils.isEmpty(constraint)) {
                        results.values = ItemsAdapter.this.mAllItems;
                        results.count = ItemsAdapter.this.mAllItems.size();
                        return results;
                    }
                    ArrayList<ViewItem> filteredItems = new ArrayList<ViewItem>();
                    String constraintLowerCase = constraint.toString().toLowerCase();
                    int itemCount = ItemsAdapter.this.mAllItems.size();
                    for (int i = 0; i < itemCount; ++i) {
                        ViewItem item = (ViewItem)ItemsAdapter.this.mAllItems.get(i);
                        String value = item.getValue();
                        if (value != null && !value.toLowerCase().startsWith(constraintLowerCase)) continue;
                        filteredItems.add(item);
                    }
                    results.values = filteredItems;
                    results.count = filteredItems.size();
                    return results;
                }

                @Override
                protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                    boolean resultCountChanged;
                    int oldItemCount = ItemsAdapter.this.mFilteredItems.size();
                    ItemsAdapter.this.mFilteredItems.clear();
                    List items = (List)results.values;
                    ItemsAdapter.this.mFilteredItems.addAll(items);
                    boolean bl = resultCountChanged = oldItemCount != ItemsAdapter.this.mFilteredItems.size();
                    if (resultCountChanged) {
                        FillUi.this.announceSearchResultIfNeeded();
                    }
                    ItemsAdapter.this.notifyDataSetChanged();
                }
            };
        }

        @Override
        public int getCount() {
            return this.mFilteredItems.size();
        }

        @Override
        public ViewItem getItem(int position) {
            return this.mFilteredItems.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getItem(position).getView();
        }
    }

    final class AnchoredWindow
    implements View.OnTouchListener {
        private final OverlayControl mOverlayControl;
        private final WindowManager mWm;
        private final View mContentView;
        private boolean mShowing;

        AnchoredWindow(View contentView, OverlayControl overlayControl) {
            this.mWm = contentView.getContext().getSystemService(WindowManager.class);
            this.mContentView = contentView;
            this.mOverlayControl = overlayControl;
        }

        public void show(WindowManager.LayoutParams params) {
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "show(): showing=" + this.mShowing + ", params=" + params);
            }
            try {
                if (!this.mShowing) {
                    params.accessibilityTitle = this.mContentView.getContext().getString(17039539);
                    this.mWm.addView(this.mContentView, params);
                    this.mContentView.setOnTouchListener(this);
                    this.mOverlayControl.hideOverlays();
                    this.mShowing = true;
                } else {
                    this.mWm.updateViewLayout(this.mContentView, params);
                }
            }
            catch (WindowManager.BadTokenException e) {
                if (Helper.sDebug) {
                    Slog.d(FillUi.TAG, "Filed with with token " + params.token + " gone.");
                }
                FillUi.this.mCallback.onDestroy();
            }
            catch (IllegalStateException e) {
                Slog.e(FillUi.TAG, "Exception showing window " + params, e);
                FillUi.this.mCallback.onDestroy();
            }
        }

        void hide() {
            try {
                if (this.mShowing) {
                    this.mContentView.setOnTouchListener(null);
                    this.mWm.removeView(this.mContentView);
                    this.mShowing = false;
                }
            }
            catch (IllegalStateException e) {
                Slog.e(FillUi.TAG, "Exception hiding window ", e);
                FillUi.this.mCallback.onDestroy();
            }
            finally {
                this.mOverlayControl.showOverlays();
            }
        }

        @Override
        public boolean onTouch(View view, MotionEvent event) {
            if (view == this.mContentView && event.getAction() == 4) {
                FillUi.this.mCallback.onCanceled();
                return true;
            }
            return false;
        }
    }

    private final class AutofillWindowPresenter
    extends IAutofillWindowPresenter.Stub {
        private AutofillWindowPresenter() {
        }

        @Override
        public void show(WindowManager.LayoutParams p, Rect transitionEpicenter, boolean fitsSystemWindows, int layoutDirection) {
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "AutofillWindowPresenter.show(): fit=" + fitsSystemWindows + ", epicenter=" + transitionEpicenter + ", dir=" + layoutDirection + ", params=" + p);
            }
            UiThread.getHandler().post(() -> FillUi.this.mWindow.show(p));
        }

        @Override
        public void hide(Rect transitionEpicenter) {
            UiThread.getHandler().post(FillUi.this.mWindow::hide);
        }
    }

    private static class ViewItem {
        private final String mValue;
        private final Dataset mDataset;
        private final View mView;

        ViewItem(Dataset dataset, String value, View view) {
            this.mDataset = dataset;
            this.mValue = value;
            this.mView = view;
        }

        public View getView() {
            return this.mView;
        }

        public Dataset getDataset() {
            return this.mDataset;
        }

        public String getValue() {
            return this.mValue;
        }

        public String toString() {
            return this.mValue;
        }
    }

    static interface Callback {
        public void onResponsePicked(FillResponse var1);

        public void onDatasetPicked(Dataset var1);

        public void onCanceled();

        public void onDestroy();

        public void requestShowFillUi(int var1, int var2, IAutofillWindowPresenter var3);

        public void requestHideFillUi();

        public void startIntentSender(IntentSender var1);
    }
}

