/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.pm.ActivityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Slog;
import android.view.Display;
import com.android.server.am.TaskRecord;
import java.util.ArrayList;

class LaunchingTaskPositioner {
    private static final String TAG = "ActivityManager";
    private static final int BOUNDS_CONFLICT_MIN_DISTANCE = 4;
    private static final int WINDOW_SIZE_DENOMINATOR = 2;
    private static final int MARGIN_SIZE_DENOMINATOR = 4;
    private static final int STEP_DENOMINATOR = 16;
    private static final int MINIMAL_STEP = 1;
    private static final boolean ALLOW_RESTART = true;
    private static final int SHIFT_POLICY_DIAGONAL_DOWN = 1;
    private static final int SHIFT_POLICY_HORIZONTAL_RIGHT = 2;
    private static final int SHIFT_POLICY_HORIZONTAL_LEFT = 3;
    private boolean mDefaultStartBoundsConfigurationSet = false;
    private final Rect mAvailableRect = new Rect();
    private final Rect mTmpProposal = new Rect();
    private final Rect mTmpOriginal = new Rect();
    private int mDefaultFreeformStartX;
    private int mDefaultFreeformStartY;
    private int mDefaultFreeformWidth;
    private int mDefaultFreeformHeight;
    private int mDefaultFreeformStepHorizontal;
    private int mDefaultFreeformStepVertical;
    private int mDisplayWidth;
    private int mDisplayHeight;

    LaunchingTaskPositioner() {
    }

    void setDisplay(Display display) {
        Point size = new Point();
        display.getSize(size);
        this.mDisplayWidth = size.x;
        this.mDisplayHeight = size.y;
    }

    void configure(Rect stackBounds) {
        if (stackBounds == null) {
            this.mAvailableRect.set(0, 0, this.mDisplayWidth, this.mDisplayHeight);
        } else {
            this.mAvailableRect.set(stackBounds);
        }
        int width = this.mAvailableRect.width();
        int height = this.mAvailableRect.height();
        this.mDefaultFreeformStartX = this.mAvailableRect.left + width / 4;
        this.mDefaultFreeformStartY = this.mAvailableRect.top + height / 4;
        this.mDefaultFreeformWidth = width / 2;
        this.mDefaultFreeformHeight = height / 2;
        this.mDefaultFreeformStepHorizontal = Math.max(width / 16, 1);
        this.mDefaultFreeformStepVertical = Math.max(height / 16, 1);
        this.mDefaultStartBoundsConfigurationSet = true;
    }

    void updateDefaultBounds(TaskRecord task, ArrayList<TaskRecord> tasks, ActivityInfo.WindowLayout windowLayout) {
        if (!this.mDefaultStartBoundsConfigurationSet) {
            return;
        }
        if (windowLayout == null) {
            this.positionCenter(task, tasks, this.mDefaultFreeformWidth, this.mDefaultFreeformHeight);
            return;
        }
        int width = this.getFinalWidth(windowLayout);
        int height = this.getFinalHeight(windowLayout);
        int verticalGravity = windowLayout.gravity & 0x70;
        int horizontalGravity = windowLayout.gravity & 7;
        if (verticalGravity == 48) {
            if (horizontalGravity == 5) {
                this.positionTopRight(task, tasks, width, height);
            } else {
                this.positionTopLeft(task, tasks, width, height);
            }
        } else if (verticalGravity == 80) {
            if (horizontalGravity == 5) {
                this.positionBottomRight(task, tasks, width, height);
            } else {
                this.positionBottomLeft(task, tasks, width, height);
            }
        } else {
            Slog.w(TAG, "Received unsupported gravity: " + windowLayout.gravity + ", positioning in the center instead.");
            this.positionCenter(task, tasks, width, height);
        }
    }

    private int getFinalWidth(ActivityInfo.WindowLayout windowLayout) {
        int width = this.mDefaultFreeformWidth;
        if (windowLayout.width > 0) {
            width = windowLayout.width;
        }
        if (windowLayout.widthFraction > 0.0f) {
            width = (int)((float)this.mAvailableRect.width() * windowLayout.widthFraction);
        }
        return width;
    }

    private int getFinalHeight(ActivityInfo.WindowLayout windowLayout) {
        int height = this.mDefaultFreeformHeight;
        if (windowLayout.height > 0) {
            height = windowLayout.height;
        }
        if (windowLayout.heightFraction > 0.0f) {
            height = (int)((float)this.mAvailableRect.height() * windowLayout.heightFraction);
        }
        return height;
    }

    private void positionBottomLeft(TaskRecord task, ArrayList<TaskRecord> tasks, int width, int height) {
        this.mTmpProposal.set(this.mAvailableRect.left, this.mAvailableRect.bottom - height, this.mAvailableRect.left + width, this.mAvailableRect.bottom);
        this.position(task, tasks, this.mTmpProposal, false, 2);
    }

    private void positionBottomRight(TaskRecord task, ArrayList<TaskRecord> tasks, int width, int height) {
        this.mTmpProposal.set(this.mAvailableRect.right - width, this.mAvailableRect.bottom - height, this.mAvailableRect.right, this.mAvailableRect.bottom);
        this.position(task, tasks, this.mTmpProposal, false, 3);
    }

    private void positionTopLeft(TaskRecord task, ArrayList<TaskRecord> tasks, int width, int height) {
        this.mTmpProposal.set(this.mAvailableRect.left, this.mAvailableRect.top, this.mAvailableRect.left + width, this.mAvailableRect.top + height);
        this.position(task, tasks, this.mTmpProposal, false, 2);
    }

    private void positionTopRight(TaskRecord task, ArrayList<TaskRecord> tasks, int width, int height) {
        this.mTmpProposal.set(this.mAvailableRect.right - width, this.mAvailableRect.top, this.mAvailableRect.right, this.mAvailableRect.top + height);
        this.position(task, tasks, this.mTmpProposal, false, 3);
    }

    private void positionCenter(TaskRecord task, ArrayList<TaskRecord> tasks, int width, int height) {
        this.mTmpProposal.set(this.mDefaultFreeformStartX, this.mDefaultFreeformStartY, this.mDefaultFreeformStartX + width, this.mDefaultFreeformStartY + height);
        this.position(task, tasks, this.mTmpProposal, true, 1);
    }

    private void position(TaskRecord task, ArrayList<TaskRecord> tasks, Rect proposal, boolean allowRestart, int shiftPolicy) {
        this.mTmpOriginal.set(proposal);
        boolean restarted = false;
        while (LaunchingTaskPositioner.boundsConflict(proposal, tasks)) {
            this.shiftStartingPoint(proposal, shiftPolicy);
            if (this.shiftedToFar(proposal, shiftPolicy)) {
                if (!allowRestart) {
                    proposal.set(this.mTmpOriginal);
                    break;
                }
                proposal.set(this.mAvailableRect.left, this.mAvailableRect.top, this.mAvailableRect.left + proposal.width(), this.mAvailableRect.top + proposal.height());
                restarted = true;
            }
            if (!restarted || proposal.left <= this.mDefaultFreeformStartX && proposal.top <= this.mDefaultFreeformStartY) continue;
            proposal.set(this.mTmpOriginal);
            break;
        }
        task.updateOverrideConfiguration(proposal);
    }

    private boolean shiftedToFar(Rect start, int shiftPolicy) {
        switch (shiftPolicy) {
            case 3: {
                return start.left < this.mAvailableRect.left;
            }
            case 2: {
                return start.right > this.mAvailableRect.right;
            }
        }
        return start.right > this.mAvailableRect.right || start.bottom > this.mAvailableRect.bottom;
    }

    private void shiftStartingPoint(Rect posposal, int shiftPolicy) {
        switch (shiftPolicy) {
            case 3: {
                posposal.offset(-this.mDefaultFreeformStepHorizontal, 0);
                break;
            }
            case 2: {
                posposal.offset(this.mDefaultFreeformStepHorizontal, 0);
                break;
            }
            default: {
                posposal.offset(this.mDefaultFreeformStepHorizontal, this.mDefaultFreeformStepVertical);
            }
        }
    }

    private static boolean boundsConflict(Rect proposal, ArrayList<TaskRecord> tasks) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Rect bounds;
            TaskRecord task = tasks.get(i);
            if (task.mActivities.isEmpty() || task.mBounds == null || !LaunchingTaskPositioner.closeLeftTopCorner(proposal, bounds = task.mBounds) && !LaunchingTaskPositioner.closeRightTopCorner(proposal, bounds) && !LaunchingTaskPositioner.closeLeftBottomCorner(proposal, bounds) && !LaunchingTaskPositioner.closeRightBottomCorner(proposal, bounds)) continue;
            return true;
        }
        return false;
    }

    private static final boolean closeLeftTopCorner(Rect first, Rect second) {
        return Math.abs(first.left - second.left) < 4 && Math.abs(first.top - second.top) < 4;
    }

    private static final boolean closeRightTopCorner(Rect first, Rect second) {
        return Math.abs(first.right - second.right) < 4 && Math.abs(first.top - second.top) < 4;
    }

    private static final boolean closeLeftBottomCorner(Rect first, Rect second) {
        return Math.abs(first.left - second.left) < 4 && Math.abs(first.bottom - second.bottom) < 4;
    }

    private static final boolean closeRightBottomCorner(Rect first, Rect second) {
        return Math.abs(first.right - second.right) < 4 && Math.abs(first.bottom - second.bottom) < 4;
    }

    void reset() {
        this.mDefaultStartBoundsConfigurationSet = false;
    }
}

