/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.BatteryStats;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os.health.HealthStatsParceler;
import android.os.health.HealthStatsWriter;
import android.os.health.UidHealthStats;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.IntArray;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.am.HealthStatsBatteryStatsWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeoutException;

public final class BatteryStatsService
extends IBatteryStats.Stub
implements PowerManagerInternal.LowPowerModeListener,
BatteryStatsImpl.PlatformIdleStateCallback {
    static final String TAG = "BatteryStatsService";
    static final boolean DBG = false;
    private static final long EXTERNAL_STATS_SYNC_TIMEOUT_MILLIS = 2000L;
    private static final long MAX_WIFI_STATS_SAMPLE_ERROR_MILLIS = 750L;
    private static IBatteryStats sService;
    final BatteryStatsImpl mStats;
    private final BatteryStatsHandler mHandler;
    private Context mContext;
    private IWifiManager mWifiManager;
    private TelephonyManager mTelephony;
    private final Object mExternalStatsLock = new Object();
    @GuardedBy(value="mExternalStatsLock")
    private WifiActivityEnergyInfo mLastInfo = new WifiActivityEnergyInfo(0L, 0, 0L, new long[]{0L}, 0L, 0L, 0L);
    private CharsetDecoder mDecoderStat = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
    private ByteBuffer mUtf8BufferStat = ByteBuffer.allocateDirect(512);
    private CharBuffer mUtf16BufferStat = CharBuffer.allocate(512);
    private static final int MAX_LOW_POWER_STATS_SIZE = 512;

    private native int getPlatformLowPowerStats(ByteBuffer var1);

    @Override
    public String getPlatformLowPowerStats() {
        int bytesWritten;
        block5: {
            block4: {
                this.mUtf8BufferStat.clear();
                this.mUtf16BufferStat.clear();
                this.mDecoderStat.reset();
                bytesWritten = this.getPlatformLowPowerStats(this.mUtf8BufferStat);
                if (bytesWritten >= 0) break block4;
                String string2 = null;
                return string2;
            }
            if (bytesWritten != 0) break block5;
            String string3 = "Empty";
            return string3;
        }
        this.mUtf8BufferStat.limit(bytesWritten);
        this.mDecoderStat.decode(this.mUtf8BufferStat, this.mUtf16BufferStat, true);
        this.mUtf16BufferStat.flip();
        String string4 = this.mUtf16BufferStat.toString();
        return string4;
    }

    BatteryStatsService(File systemDir, Handler handler) {
        ServiceThread thread = new ServiceThread("batterystats-sync", 0, true);
        thread.start();
        this.mHandler = new BatteryStatsHandler(thread.getLooper());
        this.mStats = new BatteryStatsImpl(systemDir, handler, this.mHandler, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Context context) {
        this.mContext = context;
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.setRadioScanningTimeoutLocked((long)this.mContext.getResources().getInteger(17694836) * 1000L);
            this.mStats.setPowerProfileLocked(new PowerProfile(context));
        }
        ServiceManager.addService("batterystats", this.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPowerManagement() {
        PowerManagerInternal powerMgr = LocalServices.getService(PowerManagerInternal.class);
        powerMgr.registerLowPowerModeObserver(this);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePowerSaveModeLocked(powerMgr.getLowPowerState((int)9).batterySaverEnabled);
        }
        new WakeupReasonThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w("BatteryStats", "Writing battery stats before shutdown...");
        this.updateExternalStatsSync("shutdown", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.shutdownLocked();
        }
        this.mHandler.getLooper().quit();
    }

    public static IBatteryStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("batterystats");
        sService = BatteryStatsService.asInterface(b);
        return sService;
    }

    @Override
    public int getServiceType() {
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLowPowerModeChanged(PowerSaveState result) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePowerSaveModeLocked(result.batterySaverEnabled);
        }
    }

    public BatteryStatsImpl getActiveStatistics() {
        return this.mStats;
    }

    public void scheduleWriteToDisk() {
        this.mHandler.sendEmptyMessage(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUid(int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.removeUidStatsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.addIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.scheduleRemoveIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessStart(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessCrash(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessCrashLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessAnr(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessAnrLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessFinish(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteUidProcessState(int uid, int state) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUidProcessStateLocked(uid, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getStatistics() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.updateExternalStatsSync("get-stats", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getStatisticsStream() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.updateExternalStatsSync("get-stats", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        try {
            return ParcelFileDescriptor.fromData(data, "battery-stats");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to create shared memory", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCharging() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.isCharging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeBatteryTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeChargeTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteEvent(int code, String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteEventLocked(code, name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeLocked(uid, pid, name, historyName, type, unimportantForLogging, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeLocked(uid, pid, name, historyName, type, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeFromSourceLocked(ws, pid, name, historyName, type, unimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteChangeWakelockFromSourceLocked(ws, pid, name, historyName, type, newWs, newPid, newName, newHistoryName, newType, newUnimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeFromSourceLocked(ws, pid, name, historyName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockStart(String name, String historyName, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockStart(name, historyName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockFinish(String name, String historyName, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockFinish(name, historyName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOn(int uid, long durationMillis) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOnLocked(uid, durationMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenState(int state) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenStateLocked(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenBrightness(int brightness) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenBrightnessLocked(brightness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteUserActivity(int uid, int event) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUserActivityLocked(uid, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeUp(String reason, int reasonUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWakeUpLocked(reason, reasonUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteInteractive(boolean interactive) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteInteractiveLocked(interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteConnectivityChanged(int type, String extra) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteConnectivityChangedLocked(type, extra);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteMobileRadioPowerState(int powerState, long timestampNs, int uid) {
        boolean update;
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            update = this.mStats.noteMobileRadioPowerStateLocked(powerState, timestampNs, uid);
        }
        if (update) {
            this.mHandler.scheduleSync("modem-data", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneSignalStrength(SignalStrength signalStrength) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneSignalStrengthLocked(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneDataConnectionState(int dataType, boolean hasData) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneDataConnectionStateLocked(dataType, hasData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneState(int state) {
        this.enforceCallingPermission();
        int simState = TelephonyManager.getDefault().getSimState();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneStateLocked(state, simState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetAudio() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetAudioLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetVideo() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetVideoLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOn(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetCamera() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetCameraLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetFlashlight() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetFlashlightLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRadioPowerState(int powerState, long tsNanos, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            if (this.mStats.isOnBattery()) {
                String type = powerState == 3 || powerState == 2 ? "active" : "inactive";
                this.mHandler.scheduleSync("wifi-data: " + type, 2);
            }
            this.mStats.noteWifiRadioPowerState(powerState, tsNanos, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunning(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningChangedLocked(oldWs, newWs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStoppedLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiState(int wifiState, String accessPoint) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStateLocked(wifiState, accessPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiSupplicantStateChangedLocked(supplState, failedAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRssiChanged(int newRssi) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRssiChangedLocked(newRssi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStarted(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStopped(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStartedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStartedFromSourceLocked(ws, csph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkInterfaceType(String iface, int networkType) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkInterfaceTypeLocked(iface, networkType);
        }
    }

    @Override
    public void noteNetworkStatsEnabled() {
        this.enforceCallingPermission();
        this.mHandler.scheduleSync("network-stats-enabled", 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteDeviceIdleMode(int mode, String activeReason, int activeUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteDeviceIdleModeLocked(mode, activeReason, activeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageInstalled(String pkgName, int versionCode) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageInstalledLocked(pkgName, versionCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageUninstalled(String pkgName) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageUninstalledLocked(pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanStarted(WorkSource ws, boolean isUnoptimized) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanStartedFromSourceLocked(ws, isUnoptimized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetBleScan() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetBluetoothScanLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanResults(WorkSource ws, int numNewResults) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanResultsFromSourceLocked(ws, numNewResults);
        }
    }

    @Override
    public void noteWifiControllerActivity(WifiActivityEnergyInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid wifi data given: " + info);
            return;
        }
        this.mStats.updateWifiState(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBluetoothControllerActivity(BluetoothActivityEnergyInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid bluetooth data given: " + info);
            return;
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.updateBluetoothStateLocked(info);
        }
    }

    @Override
    public void noteModemControllerActivity(ModemActivityInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid modem data given: " + info);
            return;
        }
        this.mStats.updateMobileRadioState(info);
    }

    public boolean isOnBattery() {
        return this.mStats.isOnBattery();
    }

    @Override
    public void setBatteryState(final int status, final int health, final int plugType, final int level, final int temp, final int volt, final int chargeUAh, final int chargeFullUAh) {
        this.enforceCallingPermission();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                synchronized (batteryStatsImpl) {
                    boolean onBattery;
                    boolean bl = onBattery = plugType == 0;
                    if (BatteryStatsService.this.mStats.isOnBattery() == onBattery) {
                        BatteryStatsService.this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt, chargeUAh, chargeFullUAh);
                        return;
                    }
                }
                BatteryStatsService.this.updateExternalStatsSync("battery-state", 15);
                batteryStatsImpl = BatteryStatsService.this.mStats;
                synchronized (batteryStatsImpl) {
                    BatteryStatsService.this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt, chargeUAh, chargeFullUAh);
                }
            }
        });
    }

    @Override
    public long getAwakeTimeBattery() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimeBattery();
    }

    @Override
    public long getAwakeTimePlugged() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimePlugged();
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static native int nativeWaitWakeup(ByteBuffer var0);

    private void dumpHelp(PrintWriter pw) {
        pw.println("Battery stats (batterystats) dump options:");
        pw.println("  [--checkin] [--history] [--history-start] [--charged] [-c]");
        pw.println("  [--daily] [--reset] [--write] [--new-daily] [--read-daily] [-h] [<package.name>]");
        pw.println("  --checkin: generate output for a checkin report; will write (and clear) the");
        pw.println("             last old completed stats when they had been reset.");
        pw.println("  -c: write the current stats in checkin format.");
        pw.println("  --history: show only history data.");
        pw.println("  --history-start <num>: show only history data starting at given time offset.");
        pw.println("  --charged: only output data since last charged.");
        pw.println("  --daily: only output full daily data.");
        pw.println("  --reset: reset the stats, clearing all current data.");
        pw.println("  --write: force write current collected stats to disk.");
        pw.println("  --new-daily: immediately create and write new daily stats record.");
        pw.println("  --read-daily: read-load last written daily stats.");
        pw.println("  <package.name>: optional name of package to filter output by.");
        pw.println("  -h: print this help text.");
        pw.println("Battery stats (batterystats) commands:");
        pw.println("  enable|disable <option>");
        pw.println("    Enable or disable a running option.  Option state is not saved across boots.");
        pw.println("    Options are:");
        pw.println("      full-history: include additional detailed events in battery history:");
        pw.println("          wake_lock_in, alarms and proc events");
        pw.println("      no-auto-reset: don't automatically reset stats when unplugged");
        pw.println("      pretend-screen-off: pretend the screen is off, even if screen state changes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnableOrDisable(PrintWriter pw, int i, String[] args, boolean enable) {
        if (++i >= args.length) {
            pw.println("Missing option argument for " + (enable ? "--enable" : "--disable"));
            this.dumpHelp(pw);
            return -1;
        }
        if ("full-wake-history".equals(args[i]) || "full-history".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setRecordAllHistoryLocked(enable);
            }
        } else if ("no-auto-reset".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setNoAutoReset(enable);
            }
        } else if ("pretend-screen-off".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setPretendScreenOff(enable);
            }
        } else {
            pw.println("Unknown enable/disable option: " + args[i]);
            this.dumpHelp(pw);
            return -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        BatteryStatsImpl batteryStatsImpl;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        int flags = 0;
        boolean useCheckinFormat = false;
        boolean isRealCheckin = false;
        boolean noOutput = false;
        boolean writeData = false;
        long historyStart = -1L;
        int reqUid = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("--checkin".equals(arg)) {
                    useCheckinFormat = true;
                    isRealCheckin = true;
                    continue;
                }
                if ("--history".equals(arg)) {
                    flags |= 8;
                    continue;
                }
                if ("--history-start".equals(arg)) {
                    flags |= 8;
                    if (++i >= args.length) {
                        pw.println("Missing time argument for --history-since");
                        this.dumpHelp(pw);
                        return;
                    }
                    historyStart = Long.parseLong(args[i]);
                    writeData = true;
                    continue;
                }
                if ("-c".equals(arg)) {
                    useCheckinFormat = true;
                    flags |= 0x10;
                    continue;
                }
                if ("--charged".equals(arg)) {
                    flags |= 2;
                    continue;
                }
                if ("--daily".equals(arg)) {
                    flags |= 4;
                    continue;
                }
                if ("--reset".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.resetAllStatsCmdLocked();
                        pw.println("Battery stats reset.");
                        noOutput = true;
                    }
                    this.updateExternalStatsSync("dump", 15);
                    continue;
                }
                if ("--write".equals(arg)) {
                    this.updateExternalStatsSync("dump", 15);
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.writeSyncLocked();
                        pw.println("Battery stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--new-daily".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.recordDailyStatsLocked();
                        pw.println("New daily stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--read-daily".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.readDailyStatsLocked();
                        pw.println("Last daily stats read.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--enable".equals(arg) || "enable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, true)) < 0) {
                        return;
                    }
                    pw.println("Enabled: " + args[i]);
                    return;
                }
                if ("--disable".equals(arg) || "disable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, false)) < 0) {
                        return;
                    }
                    pw.println("Disabled: " + args[i]);
                    return;
                }
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) {
                    flags |= 0x20;
                    continue;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
                try {
                    reqUid = this.mContext.getPackageManager().getPackageUidAsUser(arg, UserHandle.getCallingUserId());
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    pw.println("Unknown package: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
            }
        }
        if (noOutput) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (BatteryStatsHelper.checkWifiOnly(this.mContext)) {
                flags |= 0x40;
            }
            this.updateExternalStatsSync("dump", 15);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (reqUid >= 0 && (flags & 0xA) == 0) {
            flags |= 2;
            flags &= 0xFFFFFFEF;
        }
        if (useCheckinFormat) {
            Object object;
            List<ApplicationInfo> apps = this.mContext.getPackageManager().getInstalledApplications(0x420000);
            if (isRealCheckin) {
                object = this.mStats.mCheckinFile;
                synchronized (object) {
                    if (this.mStats.mCheckinFile.exists()) {
                        try {
                            byte[] raw2 = this.mStats.mCheckinFile.readFully();
                            if (raw2 != null) {
                                Parcel in = Parcel.obtain();
                                in.unmarshall(raw2, 0, raw2.length);
                                in.setDataPosition(0);
                                BatteryStatsImpl checkinStats = new BatteryStatsImpl(null, this.mStats.mHandler, null);
                                checkinStats.readSummaryFromParcel(in);
                                in.recycle();
                                checkinStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                                this.mStats.mCheckinFile.delete();
                                return;
                            }
                        }
                        catch (ParcelFormatException | IOException e) {
                            Slog.w(TAG, "Failure reading checkin file " + this.mStats.mCheckinFile.getBaseFile(), e);
                        }
                    }
                }
            }
            object = this.mStats;
            synchronized (object) {
                this.mStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                if (writeData) {
                    this.mStats.writeAsyncLocked();
                }
            }
        }
        batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpLocked(this.mContext, pw, flags, reqUid, historyStart);
            if (writeData) {
                this.mStats.writeAsyncLocked();
            }
        }
    }

    private WifiActivityEnergyInfo extractDelta(WifiActivityEnergyInfo latest) {
        long timePeriodMs = latest.mTimestamp - this.mLastInfo.mTimestamp;
        long lastIdleMs = this.mLastInfo.mControllerIdleTimeMs;
        long lastTxMs = this.mLastInfo.mControllerTxTimeMs;
        long lastRxMs = this.mLastInfo.mControllerRxTimeMs;
        long lastEnergy = this.mLastInfo.mControllerEnergyUsed;
        WifiActivityEnergyInfo delta = this.mLastInfo;
        delta.mTimestamp = latest.getTimeStamp();
        delta.mStackState = latest.getStackState();
        long txTimeMs = latest.mControllerTxTimeMs - lastTxMs;
        long rxTimeMs = latest.mControllerRxTimeMs - lastRxMs;
        long idleTimeMs = latest.mControllerIdleTimeMs - lastIdleMs;
        if (txTimeMs < 0L || rxTimeMs < 0L) {
            delta.mControllerEnergyUsed = latest.mControllerEnergyUsed;
            delta.mControllerRxTimeMs = latest.mControllerRxTimeMs;
            delta.mControllerTxTimeMs = latest.mControllerTxTimeMs;
            delta.mControllerIdleTimeMs = latest.mControllerIdleTimeMs;
            Slog.v(TAG, "WiFi energy data was reset, new WiFi energy data is " + delta);
        } else {
            long maxExpectedIdleTimeMs;
            long totalActiveTimeMs = txTimeMs + rxTimeMs;
            if (totalActiveTimeMs > timePeriodMs) {
                maxExpectedIdleTimeMs = 0L;
                if (totalActiveTimeMs > timePeriodMs + 750L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Total Active time ");
                    TimeUtils.formatDuration(totalActiveTimeMs, sb);
                    sb.append(" is longer than sample period ");
                    TimeUtils.formatDuration(timePeriodMs, sb);
                    sb.append(".\n");
                    sb.append("Previous WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(lastIdleMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(lastRxMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(lastTxMs, sb);
                    sb.append(" e=").append(lastEnergy);
                    sb.append("\n");
                    sb.append("Current WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(latest.mControllerIdleTimeMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(latest.mControllerRxTimeMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(latest.mControllerTxTimeMs, sb);
                    sb.append(" e=").append(latest.mControllerEnergyUsed);
                    Slog.wtf(TAG, sb.toString());
                }
            } else {
                maxExpectedIdleTimeMs = timePeriodMs - totalActiveTimeMs;
            }
            delta.mControllerTxTimeMs = txTimeMs;
            delta.mControllerRxTimeMs = rxTimeMs;
            delta.mControllerIdleTimeMs = Math.min(maxExpectedIdleTimeMs, Math.max(0L, idleTimeMs));
            delta.mControllerEnergyUsed = Math.max(0L, latest.mControllerEnergyUsed - lastEnergy);
        }
        this.mLastInfo = latest;
        return delta;
    }

    private static <T extends Parcelable> T awaitControllerInfo(SynchronousResultReceiver receiver) throws TimeoutException {
        if (receiver == null) {
            return null;
        }
        SynchronousResultReceiver.Result result = receiver.awaitResult(2000L);
        if (result.bundle != null) {
            result.bundle.setDefusable(true);
            Object data = result.bundle.getParcelable("controller_activity");
            if (data != null) {
                return data;
            }
        }
        Slog.e(TAG, "no controller energy info supplied");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateExternalStatsSync(String reason, int updateFlags) {
        SynchronousResultReceiver wifiReceiver = null;
        SynchronousResultReceiver bluetoothReceiver = null;
        SynchronousResultReceiver modemReceiver = null;
        Object object = this.mExternalStatsLock;
        synchronized (object) {
            BluetoothAdapter adapter;
            if (this.mContext == null) {
                return;
            }
            if ((updateFlags & 2) != 0) {
                if (this.mWifiManager == null) {
                    this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
                }
                if (this.mWifiManager != null) {
                    try {
                        wifiReceiver = new SynchronousResultReceiver();
                        this.mWifiManager.requestActivityInfo(wifiReceiver);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if ((updateFlags & 8) != 0 && (adapter = BluetoothAdapter.getDefaultAdapter()) != null) {
                bluetoothReceiver = new SynchronousResultReceiver();
                adapter.requestControllerActivityEnergyInfo(bluetoothReceiver);
            }
            if ((updateFlags & 4) != 0) {
                if (this.mTelephony == null) {
                    this.mTelephony = TelephonyManager.from(this.mContext);
                }
                if (this.mTelephony != null) {
                    modemReceiver = new SynchronousResultReceiver();
                    this.mTelephony.requestModemActivityInfo(modemReceiver);
                }
            }
            WifiActivityEnergyInfo wifiInfo = null;
            BluetoothActivityEnergyInfo bluetoothInfo = null;
            ModemActivityInfo modemInfo = null;
            try {
                wifiInfo = (WifiActivityEnergyInfo)BatteryStatsService.awaitControllerInfo(wifiReceiver);
            }
            catch (TimeoutException e) {
                Slog.w(TAG, "Timeout reading wifi stats");
            }
            try {
                bluetoothInfo = (BluetoothActivityEnergyInfo)BatteryStatsService.awaitControllerInfo(bluetoothReceiver);
            }
            catch (TimeoutException e) {
                Slog.w(TAG, "Timeout reading bt stats");
            }
            try {
                modemInfo = (ModemActivityInfo)BatteryStatsService.awaitControllerInfo(modemReceiver);
            }
            catch (TimeoutException e) {
                Slog.w(TAG, "Timeout reading modem stats");
            }
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.addHistoryEventLocked(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis(), 14, reason, 0);
                if ((updateFlags & 1) != 0) {
                    this.mStats.updateCpuTimeLocked(true);
                }
                this.mStats.updateKernelWakelocksLocked();
                this.mStats.updateKernelMemoryBandwidthLocked();
                if (bluetoothInfo != null) {
                    if (bluetoothInfo.isValid()) {
                        this.mStats.updateBluetoothStateLocked(bluetoothInfo);
                    } else {
                        Slog.e(TAG, "bluetooth info is invalid: " + bluetoothInfo);
                    }
                }
            }
            if (wifiInfo != null) {
                if (wifiInfo.isValid()) {
                    this.mStats.updateWifiState(this.extractDelta(wifiInfo));
                } else {
                    Slog.e(TAG, "wifi info is invalid: " + wifiInfo);
                }
            }
            if (modemInfo != null) {
                if (modemInfo.isValid()) {
                    this.mStats.updateMobileRadioState(modemInfo);
                } else {
                    Slog.e(TAG, "modem info is invalid: " + modemInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthStatsParceler takeUidSnapshot(int requestUid) {
        if (requestUid != Binder.getCallingUid()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.updateExternalStatsSync("get-health-stats-for-uid", 15);
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                try {
                    HealthStatsParceler healthStatsParceler = this.getHealthStatsForUidLocked(requestUid);
                    return healthStatsParceler;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception ex) {
                        Slog.w(TAG, "Crashed while writing for takeUidSnapshot(" + requestUid + ")", ex);
                        throw ex;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthStatsParceler[] takeUidSnapshots(int[] requestUids) {
        if (!BatteryStatsService.onlyCaller(requestUids)) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        }
        long ident = Binder.clearCallingIdentity();
        int i = -1;
        try {
            this.updateExternalStatsSync("get-health-stats-for-uids", 15);
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                int N = requestUids.length;
                HealthStatsParceler[] results = new HealthStatsParceler[N];
                for (i = 0; i < N; ++i) {
                    results[i] = this.getHealthStatsForUidLocked(requestUids[i]);
                }
                HealthStatsParceler[] healthStatsParcelerArray = results;
                return healthStatsParcelerArray;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static boolean onlyCaller(int[] requestUids) {
        int caller = Binder.getCallingUid();
        int N = requestUids.length;
        for (int i = 0; i < N; ++i) {
            if (requestUids[i] == caller) continue;
            return false;
        }
        return true;
    }

    HealthStatsParceler getHealthStatsForUidLocked(int requestUid) {
        HealthStatsBatteryStatsWriter writer = new HealthStatsBatteryStatsWriter();
        HealthStatsWriter uidWriter = new HealthStatsWriter(UidHealthStats.CONSTANTS);
        BatteryStats.Uid uid = this.mStats.getUidStats().get(requestUid);
        if (uid != null) {
            writer.writeUid(uidWriter, this.mStats, uid);
        }
        return new HealthStatsParceler(uidWriter);
    }

    final class WakeupReasonThread
    extends Thread {
        private static final int MAX_REASON_SIZE = 512;
        private CharsetDecoder mDecoder;
        private ByteBuffer mUtf8Buffer;
        private CharBuffer mUtf16Buffer;

        WakeupReasonThread() {
            super("BatteryStats_wakeupReason");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority(-2);
            this.mDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            this.mUtf8Buffer = ByteBuffer.allocateDirect(512);
            this.mUtf16Buffer = CharBuffer.allocate(512);
            try {
                String reason;
                while ((reason = this.waitWakeup()) != null) {
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsService.this.mStats.noteWakeupReasonLocked(reason);
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                Slog.e(BatteryStatsService.TAG, "Failure reading wakeup reasons", e);
            }
        }

        private String waitWakeup() {
            this.mUtf8Buffer.clear();
            this.mUtf16Buffer.clear();
            this.mDecoder.reset();
            int bytesWritten = BatteryStatsService.nativeWaitWakeup(this.mUtf8Buffer);
            if (bytesWritten < 0) {
                return null;
            }
            if (bytesWritten == 0) {
                return "unknown";
            }
            this.mUtf8Buffer.limit(bytesWritten);
            this.mDecoder.decode(this.mUtf8Buffer, this.mUtf16Buffer, true);
            this.mUtf16Buffer.flip();
            return this.mUtf16Buffer.toString();
        }
    }

    class BatteryStatsHandler
    extends Handler
    implements BatteryStatsImpl.ExternalStatsSync {
        public static final int MSG_SYNC_EXTERNAL_STATS = 1;
        public static final int MSG_WRITE_TO_DISK = 2;
        private int mUpdateFlags;
        private IntArray mUidsToRemove;

        public BatteryStatsHandler(Looper looper) {
            super(looper);
            this.mUpdateFlags = 0;
            this.mUidsToRemove = new IntArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int updateFlags;
                    Object object = this;
                    synchronized (object) {
                        this.removeMessages(1);
                        updateFlags = this.mUpdateFlags;
                        this.mUpdateFlags = 0;
                    }
                    BatteryStatsService.this.updateExternalStatsSync((String)msg.obj, updateFlags);
                    object = BatteryStatsService.this.mStats;
                    synchronized (object) {
                        BatteryStatsHandler batteryStatsHandler = this;
                        synchronized (batteryStatsHandler) {
                            int numUidsToRemove = this.mUidsToRemove.size();
                            for (int i = 0; i < numUidsToRemove; ++i) {
                                BatteryStatsService.this.mStats.removeIsolatedUidLocked(this.mUidsToRemove.get(i));
                            }
                        }
                        this.mUidsToRemove.clear();
                        break;
                    }
                }
                case 2: {
                    BatteryStatsService.this.updateExternalStatsSync("write", 15);
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsService.this.mStats.writeAsyncLocked();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleSync(String reason, int updateFlags) {
            BatteryStatsHandler batteryStatsHandler = this;
            synchronized (batteryStatsHandler) {
                this.scheduleSyncLocked(reason, updateFlags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleCpuSyncDueToRemovedUid(int uid) {
            BatteryStatsHandler batteryStatsHandler = this;
            synchronized (batteryStatsHandler) {
                this.scheduleSyncLocked("remove-uid", 1);
                this.mUidsToRemove.add(uid);
            }
        }

        private void scheduleSyncLocked(String reason, int updateFlags) {
            if (this.mUpdateFlags == 0) {
                this.sendMessage(Message.obtain(this, 1, reason));
            }
            this.mUpdateFlags |= updateFlags;
        }
    }
}

