/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SlidingTab
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SlidingTab";
    private static boolean DBG = false;
    private static int HORIZONTAL = 0;
    private static int VERTICAL = 1;
    private static float THRESHOLD = 0.6666667f;
    private static long VIBRATE_SHORT = 30L;
    private static long VIBRATE_LONG = 40L;
    private static int TRACKING_MARGIN = 50;
    private static int ANIM_DURATION = 250;
    private static int ANIM_TARGET_TIME = 500;
    private boolean mHoldLeftOnTransition;
    private boolean mHoldRightOnTransition;
    private static AudioAttributes VIBRATION_ATTRIBUTES;
    private OnTriggerListener mOnTriggerListener;
    private int mGrabbedState;
    private boolean mTriggered;
    private Vibrator mVibrator;
    private float mDensity;
    private int mOrientation;
    private Slider mLeftSlider;
    private Slider mRightSlider;
    private Slider mCurrentSlider;
    private boolean mTracking;
    private float mThreshold;
    private Slider mOtherSlider;
    private boolean mAnimating;
    private Rect mTmpRect;
    private Animation.AnimationListener mAnimationDoneListener;

    private void $$robo$$com_android_internal_widget_SlidingTab$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_SlidingTab$__constructor__(Context context, AttributeSet attrs) {
        this.mHoldLeftOnTransition = true;
        this.mHoldRightOnTransition = true;
        this.mGrabbedState = 0;
        this.mTriggered = false;
        this.mAnimationDoneListener = new Animation.AnimationListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SlidingTab this$0;

            private void $$robo$$com_android_internal_widget_SlidingTab_1$__constructor__(SlidingTab this$0) {
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationStart(Animation animation) {
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationRepeat(Animation animation) {
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationEnd(Animation animation) {
                this.this$0.onAnimationDone();
            }

            private void __constructor__(SlidingTab slidingTab) {
                this.$$robo$$com_android_internal_widget_SlidingTab_1$__constructor__(slidingTab);
            }
            {
                this.this$0 = slidingTab;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SlidingTab_1$__constructor__(com.android.internal.widget.SlidingTab ), 0, this, slidingTab);
            }

            @Override
            public void onAnimationStart(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationStart(android.view.animation.Animation ), 0, this, animation);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationRepeat(android.view.animation.Animation ), 0, this, animation);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_SlidingTab_1$onAnimationEnd(android.view.animation.Animation ), 0, this, animation);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTmpRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlidingTab);
        this.mOrientation = a.getInt(0, 0);
        a.recycle();
        Resources r = this.getResources();
        this.mDensity = r.getDisplayMetrics().density;
        this.mLeftSlider = new Slider(this, 17302699, 17302682, 17302713);
        this.mRightSlider = new Slider(this, 17302708, 17302691, 17302713);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        this.mLeftSlider.measure(widthMeasureSpec, heightMeasureSpec);
        this.mRightSlider.measure(widthMeasureSpec, heightMeasureSpec);
        int leftTabWidth = this.mLeftSlider.getTabWidth();
        int rightTabWidth = this.mRightSlider.getTabWidth();
        int leftTabHeight = this.mLeftSlider.getTabHeight();
        int rightTabHeight = this.mRightSlider.getTabHeight();
        if (this.isHorizontal()) {
            width = Math.max(widthSpecSize, leftTabWidth + rightTabWidth);
            height = Math.max(leftTabHeight, rightTabHeight);
        } else {
            width = Math.max(leftTabWidth, rightTabHeight);
            height = Math.max(heightSpecSize, leftTabHeight + rightTabHeight);
        }
        this.setMeasuredDimension(width, height);
    }

    private final boolean $$robo$$com_android_internal_widget_SlidingTab$onInterceptTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        if (this.mAnimating) {
            return false;
        }
        ImageView leftHandle = this.mLeftSlider.tab;
        leftHandle.getHitRect(this.mTmpRect);
        boolean leftHit = this.mTmpRect.contains((int)x, (int)y);
        ImageView rightHandle = this.mRightSlider.tab;
        rightHandle.getHitRect(this.mTmpRect);
        boolean rightHit = this.mTmpRect.contains((int)x, (int)y);
        if (!(this.mTracking || leftHit || rightHit)) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mTracking = true;
                this.mTriggered = false;
                this.vibrate(30L);
                if (leftHit) {
                    this.mCurrentSlider = this.mLeftSlider;
                    this.mOtherSlider = this.mRightSlider;
                    this.mThreshold = this.isHorizontal() ? 0.6666667f : 0.3333333f;
                    this.setGrabbedState(1);
                } else {
                    this.mCurrentSlider = this.mRightSlider;
                    this.mOtherSlider = this.mLeftSlider;
                    this.mThreshold = this.isHorizontal() ? 0.3333333f : 0.6666667f;
                    this.setGrabbedState(2);
                }
                this.mCurrentSlider.setState(1);
                this.mCurrentSlider.showTarget();
                this.mOtherSlider.hide();
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$reset(boolean animate) {
        this.mLeftSlider.reset(animate);
        this.mRightSlider.reset(animate);
        if (!animate) {
            this.mAnimating = false;
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setVisibility(int visibility) {
        if (visibility != this.getVisibility() && visibility == 4) {
            this.reset(false);
        }
        super.setVisibility(visibility);
    }

    private final boolean $$robo$$com_android_internal_widget_SlidingTab$onTouchEvent(MotionEvent event) {
        if (this.mTracking) {
            int action = event.getAction();
            float x = event.getX();
            float y = event.getY();
            switch (action) {
                case 2: {
                    if (this.withinView(x, y, this)) {
                        boolean thresholdReached;
                        this.moveHandle(x, y);
                        float position = this.isHorizontal() ? x : y;
                        float target = this.mThreshold * (float)(this.isHorizontal() ? this.getWidth() : this.getHeight());
                        if (this.isHorizontal()) {
                            thresholdReached = this.mCurrentSlider == this.mLeftSlider ? position > target : position < target;
                        } else {
                            boolean bl = this.mCurrentSlider == this.mLeftSlider ? position < target : (thresholdReached = position > target);
                        }
                        if (this.mTriggered || !thresholdReached) break;
                        this.mTriggered = true;
                        this.mTracking = false;
                        this.mCurrentSlider.setState(2);
                        boolean isLeft = this.mCurrentSlider == this.mLeftSlider;
                        this.dispatchTriggerEvent(isLeft ? 1 : 2);
                        this.startAnimating(isLeft ? this.mHoldLeftOnTransition : this.mHoldRightOnTransition);
                        this.setGrabbedState(0);
                        break;
                    }
                }
                case 1: 
                case 3: {
                    this.cancelGrab();
                }
            }
        }
        return this.mTracking || super.onTouchEvent(event);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$cancelGrab() {
        this.mTracking = false;
        this.mTriggered = false;
        this.mOtherSlider.show(true);
        this.mCurrentSlider.reset(false);
        this.mCurrentSlider.hideTarget();
        this.mCurrentSlider = null;
        this.mOtherSlider = null;
        this.setGrabbedState(0);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$startAnimating(boolean holdAfter) {
        int dy;
        int dx;
        this.mAnimating = true;
        Slider slider = this.mCurrentSlider;
        Slider other = this.mOtherSlider;
        if (this.isHorizontal()) {
            int right = slider.tab.getRight();
            int width = slider.tab.getWidth();
            int left = slider.tab.getLeft();
            int viewWidth = this.getWidth();
            int holdOffset = holdAfter ? 0 : width;
            dx = slider == this.mRightSlider ? -(right + viewWidth - holdOffset) : viewWidth - left + viewWidth - holdOffset;
            dy = 0;
        } else {
            int top = slider.tab.getTop();
            int bottom = slider.tab.getBottom();
            int height = slider.tab.getHeight();
            int viewHeight = this.getHeight();
            int holdOffset = holdAfter ? 0 : height;
            dx = 0;
            dy = slider == this.mRightSlider ? top + viewHeight - holdOffset : -(viewHeight - bottom + viewHeight - holdOffset);
        }
        TranslateAnimation trans1 = new TranslateAnimation(0.0f, dx, 0.0f, dy);
        trans1.setDuration(250L);
        trans1.setInterpolator(new LinearInterpolator());
        trans1.setFillAfter(true);
        TranslateAnimation trans2 = new TranslateAnimation(0.0f, dx, 0.0f, dy);
        trans2.setDuration(250L);
        trans2.setInterpolator(new LinearInterpolator());
        trans2.setFillAfter(true);
        trans1.setAnimationListener(new Animation.AnimationListener(this, holdAfter, dx, dy){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ boolean val$holdAfter;
            /* synthetic */ int val$dx;
            /* synthetic */ int val$dy;
            /* synthetic */ SlidingTab this$0;

            private void $$robo$$com_android_internal_widget_SlidingTab_2$__constructor__(SlidingTab this$0, boolean bl, int n, int n2) {
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationEnd(Animation animation) {
                Animation anim2;
                if (this.val$holdAfter) {
                    anim2 = new TranslateAnimation(this.val$dx, this.val$dx, this.val$dy, this.val$dy);
                    anim2.setDuration(1000L);
                    this.this$0.mAnimating = false;
                } else {
                    anim2 = new AlphaAnimation(0.5f, 1.0f);
                    anim2.setDuration(250L);
                    this.this$0.resetView();
                }
                anim2.setAnimationListener(this.this$0.mAnimationDoneListener);
                this.this$0.mLeftSlider.startAnimation(anim2, anim2);
                this.this$0.mRightSlider.startAnimation(anim2, anim2);
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationRepeat(Animation animation) {
            }

            private final void $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationStart(Animation animation) {
            }

            private void __constructor__(SlidingTab slidingTab, boolean bl, int n, int n2) {
                this.$$robo$$com_android_internal_widget_SlidingTab_2$__constructor__(slidingTab, bl, n, n2);
            }
            {
                this.this$0 = slidingTab;
                this.val$holdAfter = bl;
                this.val$dx = n;
                this.val$dy = n2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SlidingTab_2$__constructor__(com.android.internal.widget.SlidingTab boolean int int ), 0, this, slidingTab, bl, n, n2);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationEnd(android.view.animation.Animation ), 0, this, animation);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationRepeat(android.view.animation.Animation ), 0, this, animation);
            }

            @Override
            public void onAnimationStart(Animation animation) {
                InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_SlidingTab_2$onAnimationStart(android.view.animation.Animation ), 0, this, animation);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        slider.hideTarget();
        slider.startAnimation(trans1, trans2);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$onAnimationDone() {
        this.resetView();
        this.mAnimating = false;
    }

    private final boolean $$robo$$com_android_internal_widget_SlidingTab$withinView(float x, float y, View view) {
        return this.isHorizontal() && y > -50.0f && y < (float)(50 + view.getHeight()) || !this.isHorizontal() && x > -50.0f && x < (float)(50 + view.getWidth());
    }

    private final boolean $$robo$$com_android_internal_widget_SlidingTab$isHorizontal() {
        return this.mOrientation == 0;
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$resetView() {
        this.mLeftSlider.reset(false);
        this.mRightSlider.reset(false);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$onLayout(boolean changed, int l, int t, int r, int b) {
        if (!changed) {
            return;
        }
        this.mLeftSlider.layout(l, t, r, b, this.isHorizontal() ? 0 : 3);
        this.mRightSlider.layout(l, t, r, b, this.isHorizontal() ? 1 : 2);
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$moveHandle(float x, float y) {
        ImageView handle = this.mCurrentSlider.tab;
        TextView content = this.mCurrentSlider.text;
        if (this.isHorizontal()) {
            int deltaX = (int)x - handle.getLeft() - handle.getWidth() / 2;
            handle.offsetLeftAndRight(deltaX);
            content.offsetLeftAndRight(deltaX);
        } else {
            int deltaY = (int)y - handle.getTop() - handle.getHeight() / 2;
            handle.offsetTopAndBottom(deltaY);
            content.offsetTopAndBottom(deltaY);
        }
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setLeftTabResources(int iconId, int targetId, int barId, int tabId) {
        this.mLeftSlider.setIcon(iconId);
        this.mLeftSlider.setTarget(targetId);
        this.mLeftSlider.setBarBackgroundResource(barId);
        this.mLeftSlider.setTabBackgroundResource(tabId);
        this.mLeftSlider.updateDrawableStates();
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setLeftHintText(int resId) {
        if (this.isHorizontal()) {
            this.mLeftSlider.setHintText(resId);
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setRightTabResources(int iconId, int targetId, int barId, int tabId) {
        this.mRightSlider.setIcon(iconId);
        this.mRightSlider.setTarget(targetId);
        this.mRightSlider.setBarBackgroundResource(barId);
        this.mRightSlider.setTabBackgroundResource(tabId);
        this.mRightSlider.updateDrawableStates();
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setRightHintText(int resId) {
        if (this.isHorizontal()) {
            this.mRightSlider.setHintText(resId);
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setHoldAfterTrigger(boolean holdLeft, boolean holdRight) {
        this.mHoldLeftOnTransition = holdLeft;
        this.mHoldRightOnTransition = holdRight;
    }

    private final synchronized void $$robo$$com_android_internal_widget_SlidingTab$vibrate(long duration) {
        boolean hapticEnabled;
        boolean bl = hapticEnabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) != 0;
        if (hapticEnabled) {
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(duration, VIBRATION_ATTRIBUTES);
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setOnTriggerListener(OnTriggerListener listener) {
        this.mOnTriggerListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$dispatchTriggerEvent(int whichHandle) {
        this.vibrate(40L);
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, whichHandle);
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (changedView == this && visibility != 0 && this.mGrabbedState != 0) {
            this.cancelGrab();
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            this.mGrabbedState = newState;
            if (this.mOnTriggerListener != null) {
                this.mOnTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_SlidingTab$log(String msg) {
        Log.d("SlidingTab", msg);
    }

    static void __staticInitializer__() {
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SlidingTab$__constructor__(context);
    }

    public SlidingTab(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SlidingTab$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SlidingTab$__constructor__(context, attributeSet);
    }

    public SlidingTab(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SlidingTab$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_SlidingTab$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_SlidingTab$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void reset(boolean bl) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_SlidingTab$reset(boolean ), 0, this, bl);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$com_android_internal_widget_SlidingTab$setVisibility(int ), 0, this, n);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_SlidingTab$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void cancelGrab() {
        InvokeDynamicSupport.bootstrap("cancelGrab", $$robo$$com_android_internal_widget_SlidingTab$cancelGrab(), 0, this);
    }

    void startAnimating(boolean bl) {
        InvokeDynamicSupport.bootstrap("startAnimating", $$robo$$com_android_internal_widget_SlidingTab$startAnimating(boolean ), 0, this, bl);
    }

    private void onAnimationDone() {
        InvokeDynamicSupport.bootstrap("onAnimationDone", $$robo$$com_android_internal_widget_SlidingTab$onAnimationDone(), 0, this);
    }

    private boolean withinView(float f, float f2, View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("withinView", $$robo$$com_android_internal_widget_SlidingTab$withinView(float float android.view.View ), 0, this, f, f2, view);
    }

    private boolean isHorizontal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHorizontal", $$robo$$com_android_internal_widget_SlidingTab$isHorizontal(), 0, this);
    }

    private void resetView() {
        InvokeDynamicSupport.bootstrap("resetView", $$robo$$com_android_internal_widget_SlidingTab$resetView(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_SlidingTab$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private void moveHandle(float f, float f2) {
        InvokeDynamicSupport.bootstrap("moveHandle", $$robo$$com_android_internal_widget_SlidingTab$moveHandle(float float ), 0, this, f, f2);
    }

    public void setLeftTabResources(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setLeftTabResources", $$robo$$com_android_internal_widget_SlidingTab$setLeftTabResources(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setLeftHintText(int n) {
        InvokeDynamicSupport.bootstrap("setLeftHintText", $$robo$$com_android_internal_widget_SlidingTab$setLeftHintText(int ), 0, this, n);
    }

    public void setRightTabResources(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setRightTabResources", $$robo$$com_android_internal_widget_SlidingTab$setRightTabResources(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setRightHintText(int n) {
        InvokeDynamicSupport.bootstrap("setRightHintText", $$robo$$com_android_internal_widget_SlidingTab$setRightHintText(int ), 0, this, n);
    }

    public void setHoldAfterTrigger(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setHoldAfterTrigger", $$robo$$com_android_internal_widget_SlidingTab$setHoldAfterTrigger(boolean boolean ), 0, this, bl, bl2);
    }

    private synchronized void vibrate(long l) {
        InvokeDynamicSupport.bootstrap("vibrate", $$robo$$com_android_internal_widget_SlidingTab$vibrate(long ), 0, this, l);
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        InvokeDynamicSupport.bootstrap("setOnTriggerListener", $$robo$$com_android_internal_widget_SlidingTab$setOnTriggerListener(com.android.internal.widget.SlidingTab$OnTriggerListener ), 0, this, onTriggerListener);
    }

    private void dispatchTriggerEvent(int n) {
        InvokeDynamicSupport.bootstrap("dispatchTriggerEvent", $$robo$$com_android_internal_widget_SlidingTab$dispatchTriggerEvent(int ), 0, this, n);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$com_android_internal_widget_SlidingTab$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private void setGrabbedState(int n) {
        InvokeDynamicSupport.bootstrap("setGrabbedState", $$robo$$com_android_internal_widget_SlidingTab$setGrabbedState(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_widget_SlidingTab$log(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(SlidingTab.class);
    }

    public /* synthetic */ SlidingTab() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SlidingTab)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Slider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int ALIGN_LEFT = 0;
        public static int ALIGN_RIGHT = 1;
        public static int ALIGN_TOP = 2;
        public static int ALIGN_BOTTOM = 3;
        public static int ALIGN_UNKNOWN = 4;
        private static int STATE_NORMAL = 0;
        private static int STATE_PRESSED = 1;
        private static int STATE_ACTIVE = 2;
        private ImageView tab;
        private TextView text;
        private ImageView target;
        private int currentState;
        private int alignment;
        private int alignment_value;

        private void $$robo$$com_android_internal_widget_SlidingTab_Slider$__constructor__(ViewGroup parent, int tabId, int barId, int targetId) {
            this.currentState = 0;
            this.alignment = 4;
            this.tab = new ImageView(parent.getContext());
            this.tab.setBackgroundResource(tabId);
            this.tab.setScaleType(ImageView.ScaleType.CENTER);
            this.tab.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.text = new TextView(parent.getContext());
            this.text.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            this.text.setBackgroundResource(barId);
            this.text.setTextAppearance(parent.getContext(), 16974750);
            this.target = new ImageView(parent.getContext());
            this.target.setImageResource(targetId);
            this.target.setScaleType(ImageView.ScaleType.CENTER);
            this.target.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.target.setVisibility(4);
            parent.addView(this.target);
            parent.addView(this.tab);
            parent.addView(this.text);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setIcon(int iconId) {
            this.tab.setImageResource(iconId);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setTabBackgroundResource(int tabId) {
            this.tab.setBackgroundResource(tabId);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setBarBackgroundResource(int barId) {
            this.text.setBackgroundResource(barId);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setHintText(int resId) {
            this.text.setText(resId);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$hide() {
            int dx;
            boolean horiz;
            boolean bl = horiz = this.alignment == 0 || this.alignment == 1;
            int n = horiz ? (this.alignment == 0 ? this.alignment_value - this.tab.getRight() : this.alignment_value - this.tab.getLeft()) : (dx = 0);
            int dy = horiz ? 0 : (this.alignment == 2 ? this.alignment_value - this.tab.getBottom() : this.alignment_value - this.tab.getTop());
            TranslateAnimation trans = new TranslateAnimation(0.0f, dx, 0.0f, dy);
            trans.setDuration(250L);
            trans.setFillAfter(true);
            this.tab.startAnimation(trans);
            this.text.startAnimation(trans);
            this.target.setVisibility(4);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$show(boolean animate) {
            this.text.setVisibility(0);
            this.tab.setVisibility(0);
            if (animate) {
                int dx;
                boolean horiz;
                boolean bl = horiz = this.alignment == 0 || this.alignment == 1;
                int n = horiz ? (this.alignment == 0 ? this.tab.getWidth() : -this.tab.getWidth()) : (dx = 0);
                int dy = horiz ? 0 : (this.alignment == 2 ? this.tab.getHeight() : -this.tab.getHeight());
                TranslateAnimation trans = new TranslateAnimation(-dx, 0.0f, -dy, 0.0f);
                trans.setDuration(250L);
                this.tab.startAnimation(trans);
                this.text.startAnimation(trans);
            }
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setState(int state) {
            this.text.setPressed(state == 1);
            this.tab.setPressed(state == 1);
            if (state == 2) {
                int[] activeState = new int[]{16842914};
                if (this.text.getBackground().isStateful()) {
                    this.text.getBackground().setState(activeState);
                }
                if (this.tab.getBackground().isStateful()) {
                    this.tab.getBackground().setState(activeState);
                }
                this.text.setTextAppearance(this.text.getContext(), 16974749);
            } else {
                this.text.setTextAppearance(this.text.getContext(), 16974750);
            }
            this.currentState = state;
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$showTarget() {
            AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 1.0f);
            alphaAnim.setDuration(500L);
            this.target.startAnimation(alphaAnim);
            this.target.setVisibility(0);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$reset(boolean animate) {
            int dy;
            int dx;
            boolean horiz;
            this.setState(0);
            this.text.setVisibility(0);
            this.text.setTextAppearance(this.text.getContext(), 16974750);
            this.tab.setVisibility(0);
            this.target.setVisibility(4);
            boolean bl = horiz = this.alignment == 0 || this.alignment == 1;
            int n = horiz ? (this.alignment == 0 ? this.alignment_value - this.tab.getLeft() : this.alignment_value - this.tab.getRight()) : (dx = 0);
            int n2 = horiz ? 0 : (dy = this.alignment == 2 ? this.alignment_value - this.tab.getTop() : this.alignment_value - this.tab.getBottom());
            if (animate) {
                TranslateAnimation trans = new TranslateAnimation(0.0f, dx, 0.0f, dy);
                trans.setDuration(250L);
                trans.setFillAfter(false);
                this.text.startAnimation(trans);
                this.tab.startAnimation(trans);
            } else {
                if (horiz) {
                    this.text.offsetLeftAndRight(dx);
                    this.tab.offsetLeftAndRight(dx);
                } else {
                    this.text.offsetTopAndBottom(dy);
                    this.tab.offsetTopAndBottom(dy);
                }
                this.text.clearAnimation();
                this.tab.clearAnimation();
                this.target.clearAnimation();
            }
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$setTarget(int targetId) {
            this.target.setImageResource(targetId);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$layout(int l, int t, int r, int b, int alignment) {
            this.alignment = alignment;
            Drawable tabBackground = this.tab.getBackground();
            int handleWidth = tabBackground.getIntrinsicWidth();
            int handleHeight = tabBackground.getIntrinsicHeight();
            Drawable targetDrawable = this.target.getDrawable();
            int targetWidth = targetDrawable.getIntrinsicWidth();
            int targetHeight = targetDrawable.getIntrinsicHeight();
            int parentWidth = r - l;
            int parentHeight = b - t;
            int leftTarget = (int)(0.6666667f * (float)parentWidth) - targetWidth + handleWidth / 2;
            int rightTarget = (int)(0.3333333f * (float)parentWidth) - handleWidth / 2;
            int left = (parentWidth - handleWidth) / 2;
            int right = left + handleWidth;
            if (alignment == 0 || alignment == 1) {
                int targetTop = (parentHeight - targetHeight) / 2;
                int targetBottom = targetTop + targetHeight;
                int top = (parentHeight - handleHeight) / 2;
                int bottom = (parentHeight + handleHeight) / 2;
                if (alignment == 0) {
                    this.tab.layout(0, top, handleWidth, bottom);
                    this.text.layout(0 - parentWidth, top, 0, bottom);
                    this.text.setGravity(5);
                    this.target.layout(leftTarget, targetTop, leftTarget + targetWidth, targetBottom);
                    this.alignment_value = l;
                } else {
                    this.tab.layout(parentWidth - handleWidth, top, parentWidth, bottom);
                    this.text.layout(parentWidth, top, parentWidth + parentWidth, bottom);
                    this.target.layout(rightTarget, targetTop, rightTarget + targetWidth, targetBottom);
                    this.text.setGravity(48);
                    this.alignment_value = r;
                }
            } else {
                int targetLeft = (parentWidth - targetWidth) / 2;
                int targetRight = (parentWidth + targetWidth) / 2;
                int top = (int)(0.6666667f * (float)parentHeight) + handleHeight / 2 - targetHeight;
                int bottom = (int)(0.3333333f * (float)parentHeight) - handleHeight / 2;
                if (alignment == 2) {
                    this.tab.layout(left, 0, right, handleHeight);
                    this.text.layout(left, 0 - parentHeight, right, 0);
                    this.target.layout(targetLeft, top, targetRight, top + targetHeight);
                    this.alignment_value = t;
                } else {
                    this.tab.layout(left, parentHeight - handleHeight, right, parentHeight);
                    this.text.layout(left, parentHeight, right, parentHeight + parentHeight);
                    this.target.layout(targetLeft, bottom, targetRight, bottom + targetHeight);
                    this.alignment_value = b;
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$updateDrawableStates() {
            this.setState(this.currentState);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$measure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = View.MeasureSpec.getSize(widthMeasureSpec);
            int height = View.MeasureSpec.getSize(heightMeasureSpec);
            this.tab.measure(View.MeasureSpec.makeSafeMeasureSpec(width, 0), View.MeasureSpec.makeSafeMeasureSpec(height, 0));
            this.text.measure(View.MeasureSpec.makeSafeMeasureSpec(width, 0), View.MeasureSpec.makeSafeMeasureSpec(height, 0));
        }

        private final int $$robo$$com_android_internal_widget_SlidingTab_Slider$getTabWidth() {
            return this.tab.getMeasuredWidth();
        }

        private final int $$robo$$com_android_internal_widget_SlidingTab_Slider$getTabHeight() {
            return this.tab.getMeasuredHeight();
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$startAnimation(Animation anim1, Animation anim2) {
            this.tab.startAnimation(anim1);
            this.text.startAnimation(anim2);
        }

        private final void $$robo$$com_android_internal_widget_SlidingTab_Slider$hideTarget() {
            this.target.clearAnimation();
            this.target.setVisibility(4);
        }

        private void __constructor__(ViewGroup viewGroup, int n, int n2, int n3) {
            this.$$robo$$com_android_internal_widget_SlidingTab_Slider$__constructor__(viewGroup, n, n2, n3);
        }

        Slider(ViewGroup viewGroup, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SlidingTab_Slider$__constructor__(android.view.ViewGroup int int int ), 0, this, viewGroup, n, n2, n3);
        }

        void setIcon(int n) {
            InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_widget_SlidingTab_Slider$setIcon(int ), 0, this, n);
        }

        void setTabBackgroundResource(int n) {
            InvokeDynamicSupport.bootstrap("setTabBackgroundResource", $$robo$$com_android_internal_widget_SlidingTab_Slider$setTabBackgroundResource(int ), 0, this, n);
        }

        void setBarBackgroundResource(int n) {
            InvokeDynamicSupport.bootstrap("setBarBackgroundResource", $$robo$$com_android_internal_widget_SlidingTab_Slider$setBarBackgroundResource(int ), 0, this, n);
        }

        void setHintText(int n) {
            InvokeDynamicSupport.bootstrap("setHintText", $$robo$$com_android_internal_widget_SlidingTab_Slider$setHintText(int ), 0, this, n);
        }

        void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_widget_SlidingTab_Slider$hide(), 0, this);
        }

        void show(boolean bl) {
            InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_widget_SlidingTab_Slider$show(boolean ), 0, this, bl);
        }

        void setState(int n) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_widget_SlidingTab_Slider$setState(int ), 0, this, n);
        }

        void showTarget() {
            InvokeDynamicSupport.bootstrap("showTarget", $$robo$$com_android_internal_widget_SlidingTab_Slider$showTarget(), 0, this);
        }

        void reset(boolean bl) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_SlidingTab_Slider$reset(boolean ), 0, this, bl);
        }

        void setTarget(int n) {
            InvokeDynamicSupport.bootstrap("setTarget", $$robo$$com_android_internal_widget_SlidingTab_Slider$setTarget(int ), 0, this, n);
        }

        void layout(int n, int n2, int n3, int n4, int n5) {
            InvokeDynamicSupport.bootstrap("layout", $$robo$$com_android_internal_widget_SlidingTab_Slider$layout(int int int int int ), 0, this, n, n2, n3, n4, n5);
        }

        public void updateDrawableStates() {
            InvokeDynamicSupport.bootstrap("updateDrawableStates", $$robo$$com_android_internal_widget_SlidingTab_Slider$updateDrawableStates(), 0, this);
        }

        public void measure(int n, int n2) {
            InvokeDynamicSupport.bootstrap("measure", $$robo$$com_android_internal_widget_SlidingTab_Slider$measure(int int ), 0, this, n, n2);
        }

        public int getTabWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getTabWidth", $$robo$$com_android_internal_widget_SlidingTab_Slider$getTabWidth(), 0, this);
        }

        public int getTabHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getTabHeight", $$robo$$com_android_internal_widget_SlidingTab_Slider$getTabHeight(), 0, this);
        }

        public void startAnimation(Animation animation, Animation animation2) {
            InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$com_android_internal_widget_SlidingTab_Slider$startAnimation(android.view.animation.Animation android.view.animation.Animation ), 0, this, animation, animation2);
        }

        public void hideTarget() {
            InvokeDynamicSupport.bootstrap("hideTarget", $$robo$$com_android_internal_widget_SlidingTab_Slider$hideTarget(), 0, this);
        }

        public /* synthetic */ Slider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Slider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnTriggerListener
    extends InstrumentedInterface {
        public static final int NO_HANDLE = 0;
        public static final int LEFT_HANDLE = 1;
        public static final int RIGHT_HANDLE = 2;

        public void onTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

