/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class NotificationActionListLayout
extends LinearLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mTotalWidth;
    private ArrayList<Pair<Integer, TextView>> mMeasureOrderTextViews;
    private ArrayList<View> mMeasureOrderOther;
    private boolean mMeasureLinearly;
    private int mDefaultPaddingEnd;
    private Drawable mDefaultBackground;
    public static Comparator<Pair<Integer, TextView>> MEASURE_ORDER_COMPARATOR;

    private void $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mTotalWidth = 0;
        this.mMeasureOrderTextViews = new ArrayList();
        this.mMeasureOrderOther = new ArrayList();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMeasureLinearly) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int N = this.getChildCount();
        int textViews = 0;
        int otherViews = 0;
        int notGoneChildren = 0;
        View lastNotGoneChild = null;
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView) {
                ++textViews;
            } else {
                ++otherViews;
            }
            if (c.getVisibility() == 8) continue;
            ++notGoneChildren;
            lastNotGoneChild = c;
        }
        boolean needRebuild = false;
        if (textViews != this.mMeasureOrderTextViews.size() || otherViews != this.mMeasureOrderOther.size()) {
            needRebuild = true;
        }
        if (!needRebuild) {
            int size = this.mMeasureOrderTextViews.size();
            for (int i = 0; i < size; ++i) {
                Pair<Integer, TextView> pair = this.mMeasureOrderTextViews.get(i);
                if (((Integer)pair.first).intValue() == ((TextView)pair.second).getText().length()) continue;
                needRebuild = true;
            }
        }
        if (notGoneChildren > 1 && needRebuild) {
            this.rebuildMeasureOrder(textViews, otherViews);
        }
        boolean constrained = View.MeasureSpec.getMode(widthMeasureSpec) != 0;
        int innerWidth = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        int otherSize = this.mMeasureOrderOther.size();
        int usedWidth = 0;
        int measuredChildren = 0;
        for (int i = 0; i < N && notGoneChildren > 1; ++i) {
            View c = i < otherSize ? this.mMeasureOrderOther.get(i) : (View)this.mMeasureOrderTextViews.get((int)(i - otherSize)).second;
            if (c.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)c.getLayoutParams();
            int usedWidthForChild = usedWidth;
            if (constrained) {
                int availableWidth = innerWidth - usedWidth;
                int maxWidthForChild = availableWidth / (notGoneChildren - measuredChildren);
                usedWidthForChild = innerWidth - maxWidthForChild;
            }
            this.measureChildWithMargins(c, widthMeasureSpec, usedWidthForChild, heightMeasureSpec, 0);
            usedWidth += c.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            ++measuredChildren;
        }
        if (lastNotGoneChild != null && (constrained && usedWidth < innerWidth || notGoneChildren == 1)) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)lastNotGoneChild.getLayoutParams();
            if (notGoneChildren > 1) {
                usedWidth -= lastNotGoneChild.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            }
            int originalWidth = lp.width;
            lp.width = -1;
            this.measureChildWithMargins(lastNotGoneChild, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
            lp.width = originalWidth;
            usedWidth += lastNotGoneChild.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
        }
        this.mTotalWidth = usedWidth + this.mPaddingRight + this.mPaddingLeft;
        this.setMeasuredDimension(NotificationActionListLayout.resolveSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), NotificationActionListLayout.resolveSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$rebuildMeasureOrder(int capacityText, int capacityOther) {
        this.clearMeasureOrder();
        this.mMeasureOrderTextViews.ensureCapacity(capacityText);
        this.mMeasureOrderOther.ensureCapacity(capacityOther);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView && ((TextView)c).getText().length() > 0) {
                this.mMeasureOrderTextViews.add(Pair.create(((TextView)c).getText().length(), (TextView)c));
                continue;
            }
            this.mMeasureOrderOther.add(c);
        }
        this.mMeasureOrderTextViews.sort(MEASURE_ORDER_COMPARATOR);
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$clearMeasureOrder() {
        this.mMeasureOrderOther.clear();
        this.mMeasureOrderTextViews.clear();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewAdded(View child) {
        super.onViewAdded(child);
        this.clearMeasureOrder();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.clearMeasureOrder();
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childLeft;
        if (this.mMeasureLinearly) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        int height = bottom - top;
        int innerHeight = height - paddingTop - this.mPaddingBottom;
        int count = this.getChildCount();
        int layoutDirection = this.getLayoutDirection();
        switch (Gravity.getAbsoluteGravity(0x800003, layoutDirection)) {
            case 5: {
                childLeft = this.mPaddingLeft + right - left - this.mTotalWidth;
                break;
            }
            default: {
                childLeft = this.mPaddingLeft;
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childIndex = start + dir * i;
            View child = this.getChildAt(childIndex);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childTop = paddingTop + (innerHeight - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
            child.layout(childLeft += lp.leftMargin, childTop, childLeft + childWidth, childTop + childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$onFinishInflate() {
        super.onFinishInflate();
        this.mDefaultPaddingEnd = this.getPaddingEnd();
        this.mDefaultBackground = this.getBackground();
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_NotificationActionListLayout$setEmphasizedMode(boolean emphasizedMode) {
        this.mMeasureLinearly = emphasizedMode;
        this.setPaddingRelative(this.getPaddingStart(), this.getPaddingTop(), emphasizedMode ? 0 : this.mDefaultPaddingEnd, this.getPaddingBottom());
        this.setBackground(emphasizedMode ? null : this.mDefaultBackground);
        this.requestLayout();
    }

    static void __staticInitializer__() {
        MEASURE_ORDER_COMPARATOR = (a, b) -> ((Integer)a.first).compareTo((Integer)b.first);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(context, attributeSet);
    }

    public NotificationActionListLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_NotificationActionListLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_NotificationActionListLayout$onMeasure(int int ), 0, this, n, n2);
    }

    private void rebuildMeasureOrder(int n, int n2) {
        InvokeDynamicSupport.bootstrap("rebuildMeasureOrder", $$robo$$com_android_internal_widget_NotificationActionListLayout$rebuildMeasureOrder(int int ), 0, this, n, n2);
    }

    private void clearMeasureOrder() {
        InvokeDynamicSupport.bootstrap("clearMeasureOrder", $$robo$$com_android_internal_widget_NotificationActionListLayout$clearMeasureOrder(), 0, this);
    }

    @Override
    public void onViewAdded(View view) {
        InvokeDynamicSupport.bootstrap("onViewAdded", $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewAdded(android.view.View ), 0, this, view);
    }

    @Override
    public void onViewRemoved(View view) {
        InvokeDynamicSupport.bootstrap("onViewRemoved", $$robo$$com_android_internal_widget_NotificationActionListLayout$onViewRemoved(android.view.View ), 0, this, view);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_NotificationActionListLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_NotificationActionListLayout$onFinishInflate(), 0, this);
    }

    @RemotableViewMethod
    public void setEmphasizedMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEmphasizedMode", $$robo$$com_android_internal_widget_NotificationActionListLayout$setEmphasizedMode(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(NotificationActionListLayout.class);
    }

    public /* synthetic */ NotificationActionListLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationActionListLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

