/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.Window;
import com.android.internal.policy.PhoneWindow;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DecorCaptionView
extends ViewGroup
implements View.OnTouchListener,
GestureDetector.OnGestureListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DecorCaptionView";
    private PhoneWindow mOwner;
    private boolean mShow;
    private boolean mDragging;
    private boolean mOverlayWithAppContent;
    private View mCaption;
    private View mContent;
    private View mMaximize;
    private View mClose;
    private int mTouchDownX;
    private int mTouchDownY;
    private boolean mCheckForDragging;
    private int mDragSlop;
    private ArrayList<View> mTouchDispatchList;
    private GestureDetector mGestureDetector;
    private Rect mCloseRect;
    private Rect mMaximizeRect;
    private View mClickTarget;

    private void $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(Context context) {
        this.mOwner = null;
        this.mShow = false;
        this.mDragging = false;
        this.mOverlayWithAppContent = false;
        this.mTouchDispatchList = new ArrayList(2);
        this.mCloseRect = new Rect();
        this.mMaximizeRect = new Rect();
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(Context context, AttributeSet attrs) {
        this.mOwner = null;
        this.mShow = false;
        this.mDragging = false;
        this.mOverlayWithAppContent = false;
        this.mTouchDispatchList = new ArrayList(2);
        this.mCloseRect = new Rect();
        this.mMaximizeRect = new Rect();
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mOwner = null;
        this.mShow = false;
        this.mDragging = false;
        this.mOverlayWithAppContent = false;
        this.mTouchDispatchList = new ArrayList(2);
        this.mCloseRect = new Rect();
        this.mMaximizeRect = new Rect();
        this.init(context);
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$init(Context context) {
        this.mDragSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mGestureDetector = new GestureDetector(context, this);
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onFinishInflate() {
        super.onFinishInflate();
        this.mCaption = this.getChildAt(0);
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$setPhoneWindow(PhoneWindow owner, boolean show) {
        this.mOwner = owner;
        this.mShow = show;
        this.mOverlayWithAppContent = owner.isOverlayWithDecorCaptionEnabled();
        if (this.mOverlayWithAppContent) {
            this.mCaption.setBackgroundColor(0);
        }
        this.updateCaptionVisibility();
        this.mOwner.getDecorView().setOutlineProvider(ViewOutlineProvider.BOUNDS);
        this.mMaximize = this.findViewById(16909031);
        this.mClose = this.findViewById(16908791);
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            int y;
            int x = (int)ev.getX();
            if (this.mMaximizeRect.contains(x, y = (int)ev.getY())) {
                this.mClickTarget = this.mMaximize;
            }
            if (this.mCloseRect.contains(x, y)) {
                this.mClickTarget = this.mClose;
            }
        }
        return this.mClickTarget != null;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onTouchEvent(MotionEvent event) {
        if (this.mClickTarget != null) {
            this.mGestureDetector.onTouchEvent(event);
            int action = event.getAction();
            if (action == 1 || action == 3) {
                this.mClickTarget = null;
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onTouch(View v, MotionEvent e) {
        int x = (int)e.getX();
        int y = (int)e.getY();
        boolean fromMouse = e.getToolType(e.getActionIndex()) == 3;
        boolean primaryButton = (e.getButtonState() & 1) != 0;
        switch (e.getActionMasked()) {
            case 0: {
                if (!this.mShow) {
                    return false;
                }
                if (fromMouse && !primaryButton) break;
                this.mCheckForDragging = true;
                this.mTouchDownX = x;
                this.mTouchDownY = y;
                break;
            }
            case 2: {
                if (this.mDragging || !this.mCheckForDragging || !fromMouse && !this.passedSlop(x, y)) break;
                this.mCheckForDragging = false;
                this.mDragging = true;
                this.startMovingTask(e.getRawX(), e.getRawY());
                break;
            }
            case 1: 
            case 3: {
                if (!this.mDragging) break;
                this.mDragging = false;
                return !this.mCheckForDragging;
            }
        }
        return this.mDragging || this.mCheckForDragging;
    }

    private final ArrayList<View> $$robo$$com_android_internal_widget_DecorCaptionView$buildTouchDispatchChildList() {
        this.mTouchDispatchList.ensureCapacity(3);
        if (this.mCaption != null) {
            this.mTouchDispatchList.add(this.mCaption);
        }
        if (this.mContent != null) {
            this.mTouchDispatchList.add(this.mContent);
        }
        return this.mTouchDispatchList;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$shouldDelayChildPressedState() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$passedSlop(int x, int y) {
        return Math.abs(x - this.mTouchDownX) > this.mDragSlop || Math.abs(y - this.mTouchDownY) > this.mDragSlop;
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onConfigurationChanged(boolean show) {
        this.mShow = show;
        this.updateCaptionVisibility();
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!(params instanceof ViewGroup.MarginLayoutParams)) {
            throw new IllegalArgumentException("params " + params + " must subclass MarginLayoutParams");
        }
        if (index >= 2 || this.getChildCount() >= 2) {
            throw new IllegalStateException("DecorCaptionView can only handle 1 client view");
        }
        super.addView(child, 0, params);
        this.mContent = child;
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int captionHeight;
        if (this.mCaption.getVisibility() != 8) {
            this.measureChildWithMargins(this.mCaption, widthMeasureSpec, 0, heightMeasureSpec, 0);
            captionHeight = this.mCaption.getMeasuredHeight();
        } else {
            captionHeight = 0;
        }
        if (this.mContent != null) {
            if (this.mOverlayWithAppContent) {
                this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, 0);
            } else {
                this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, captionHeight);
            }
        }
        this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), View.MeasureSpec.getSize(heightMeasureSpec));
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int captionHeight;
        if (this.mCaption.getVisibility() != 8) {
            this.mCaption.layout(0, 0, this.mCaption.getMeasuredWidth(), this.mCaption.getMeasuredHeight());
            captionHeight = this.mCaption.getBottom() - this.mCaption.getTop();
            this.mMaximize.getHitRect(this.mMaximizeRect);
            this.mClose.getHitRect(this.mCloseRect);
        } else {
            captionHeight = 0;
            this.mMaximizeRect.setEmpty();
            this.mCloseRect.setEmpty();
        }
        if (this.mContent != null) {
            if (this.mOverlayWithAppContent) {
                this.mContent.layout(0, 0, this.mContent.getMeasuredWidth(), this.mContent.getMeasuredHeight());
            } else {
                this.mContent.layout(0, captionHeight, this.mContent.getMeasuredWidth(), captionHeight + this.mContent.getMeasuredHeight());
            }
        }
        this.mOwner.notifyRestrictedCaptionAreaCallback(this.mMaximize.getLeft(), this.mMaximize.getTop(), this.mClose.getRight(), this.mClose.getBottom());
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$isFillingScreen() {
        return 0 != ((this.getWindowSystemUiVisibility() | this.getSystemUiVisibility()) & 0xA05);
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$updateCaptionVisibility() {
        boolean invisible = this.isFillingScreen() || !this.mShow;
        this.mCaption.setVisibility(invisible ? 8 : 0);
        this.mCaption.setOnTouchListener(this);
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$maximizeWindow() {
        Window.WindowControllerCallback callback = this.mOwner.getWindowControllerCallback();
        if (callback != null) {
            try {
                callback.exitFreeformMode();
            }
            catch (RemoteException ex) {
                Log.e("DecorCaptionView", "Cannot change task workspace.");
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$isCaptionShowing() {
        return this.mShow;
    }

    private final int $$robo$$com_android_internal_widget_DecorCaptionView$getCaptionHeight() {
        return this.mCaption != null ? this.mCaption.getHeight() : 0;
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$removeContentView() {
        if (this.mContent != null) {
            this.removeView(this.mContent);
            this.mContent = null;
        }
    }

    private final View $$robo$$com_android_internal_widget_DecorCaptionView$getCaption() {
        return this.mCaption;
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_DecorCaptionView$generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_DecorCaptionView$generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -1);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_DecorCaptionView$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onDown(MotionEvent e) {
        return false;
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onShowPress(MotionEvent e) {
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onSingleTapUp(MotionEvent e) {
        if (this.mClickTarget == this.mMaximize) {
            this.maximizeWindow();
        } else if (this.mClickTarget == this.mClose) {
            this.mOwner.dispatchOnWindowDismissed(true, false);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    private final void $$robo$$com_android_internal_widget_DecorCaptionView$onLongPress(MotionEvent e) {
    }

    private final boolean $$robo$$com_android_internal_widget_DecorCaptionView$onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(context);
    }

    public DecorCaptionView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(context, attributeSet);
    }

    public DecorCaptionView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(context, attributeSet, n);
    }

    public DecorCaptionView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_DecorCaptionView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_widget_DecorCaptionView$init(android.content.Context ), 0, this, context);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_DecorCaptionView$onFinishInflate(), 0, this);
    }

    public void setPhoneWindow(PhoneWindow phoneWindow, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPhoneWindow", $$robo$$com_android_internal_widget_DecorCaptionView$setPhoneWindow(com.android.internal.policy.PhoneWindow boolean ), 0, this, phoneWindow, bl);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_DecorCaptionView$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_DecorCaptionView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$com_android_internal_widget_DecorCaptionView$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
    }

    @Override
    public ArrayList<View> buildTouchDispatchChildList() {
        return InvokeDynamicSupport.bootstrap("buildTouchDispatchChildList", $$robo$$com_android_internal_widget_DecorCaptionView$buildTouchDispatchChildList(), 0, this);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$com_android_internal_widget_DecorCaptionView$shouldDelayChildPressedState(), 0, this);
    }

    private boolean passedSlop(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("passedSlop", $$robo$$com_android_internal_widget_DecorCaptionView$passedSlop(int int ), 0, this, n, n2);
    }

    public void onConfigurationChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_widget_DecorCaptionView$onConfigurationChanged(boolean ), 0, this, bl);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_DecorCaptionView$addView(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_DecorCaptionView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_DecorCaptionView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private boolean isFillingScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFillingScreen", $$robo$$com_android_internal_widget_DecorCaptionView$isFillingScreen(), 0, this);
    }

    private void updateCaptionVisibility() {
        InvokeDynamicSupport.bootstrap("updateCaptionVisibility", $$robo$$com_android_internal_widget_DecorCaptionView$updateCaptionVisibility(), 0, this);
    }

    private void maximizeWindow() {
        InvokeDynamicSupport.bootstrap("maximizeWindow", $$robo$$com_android_internal_widget_DecorCaptionView$maximizeWindow(), 0, this);
    }

    public boolean isCaptionShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCaptionShowing", $$robo$$com_android_internal_widget_DecorCaptionView$isCaptionShowing(), 0, this);
    }

    public int getCaptionHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getCaptionHeight", $$robo$$com_android_internal_widget_DecorCaptionView$getCaptionHeight(), 0, this);
    }

    public void removeContentView() {
        InvokeDynamicSupport.bootstrap("removeContentView", $$robo$$com_android_internal_widget_DecorCaptionView$removeContentView(), 0, this);
    }

    public View getCaption() {
        return InvokeDynamicSupport.bootstrap("getCaption", $$robo$$com_android_internal_widget_DecorCaptionView$getCaption(), 0, this);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_DecorCaptionView$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_DecorCaptionView$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_DecorCaptionView$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_widget_DecorCaptionView$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public boolean onDown(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDown", $$robo$$com_android_internal_widget_DecorCaptionView$onDown(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void onShowPress(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onShowPress", $$robo$$com_android_internal_widget_DecorCaptionView$onShowPress(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onSingleTapUp(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSingleTapUp", $$robo$$com_android_internal_widget_DecorCaptionView$onSingleTapUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onScroll", $$robo$$com_android_internal_widget_DecorCaptionView$onScroll(android.view.MotionEvent android.view.MotionEvent float float ), 0, this, motionEvent, motionEvent2, f, f2);
    }

    @Override
    public void onLongPress(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$com_android_internal_widget_DecorCaptionView$onLongPress(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onFling", $$robo$$com_android_internal_widget_DecorCaptionView$onFling(android.view.MotionEvent android.view.MotionEvent float float ), 0, this, motionEvent, motionEvent2, f, f2);
    }

    public /* synthetic */ DecorCaptionView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecorCaptionView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

