/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BaseMenuPresenter
implements MenuPresenter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected Context mSystemContext;
    protected Context mContext;
    protected MenuBuilder mMenu;
    protected LayoutInflater mSystemInflater;
    protected LayoutInflater mInflater;
    private MenuPresenter.Callback mCallback;
    private int mMenuLayoutRes;
    private int mItemLayoutRes;
    protected MenuView mMenuView;
    private int mId;

    private void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$__constructor__(Context context, int menuLayoutRes, int itemLayoutRes) {
        this.mSystemContext = context;
        this.mSystemInflater = LayoutInflater.from(context);
        this.mMenuLayoutRes = menuLayoutRes;
        this.mItemLayoutRes = itemLayoutRes;
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$initForMenu(Context context, MenuBuilder menu2) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from(this.mContext);
        this.mMenu = menu2;
    }

    private final MenuView $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getMenuView(ViewGroup root) {
        if (this.mMenuView == null) {
            this.mMenuView = (MenuView)((Object)this.mSystemInflater.inflate(this.mMenuLayoutRes, root, false));
            this.mMenuView.initialize(this.mMenu);
            this.updateMenuView(true);
        }
        return this.mMenuView;
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$updateMenuView(boolean cleared) {
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        if (parent == null) {
            return;
        }
        int childIndex = 0;
        if (this.mMenu != null) {
            this.mMenu.flagActionItems();
            ArrayList<MenuItemImpl> visibleItems = this.mMenu.getVisibleItems();
            int itemCount = visibleItems.size();
            for (int i = 0; i < itemCount; ++i) {
                MenuItemImpl item = visibleItems.get(i);
                if (!this.shouldIncludeItem(childIndex, item)) continue;
                View convertView = parent.getChildAt(childIndex);
                MenuItemImpl oldItem = convertView instanceof MenuView.ItemView ? ((MenuView.ItemView)((Object)convertView)).getItemData() : null;
                View itemView = this.getItemView(item, convertView, parent);
                if (item != oldItem) {
                    itemView.setPressed(false);
                    itemView.jumpDrawablesToCurrentState();
                }
                if (itemView != convertView) {
                    this.addItemView(itemView, childIndex);
                }
                ++childIndex;
            }
        }
        while (childIndex < parent.getChildCount()) {
            if (this.filterLeftoverView(parent, childIndex)) continue;
            ++childIndex;
        }
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$addItemView(View itemView, int childIndex) {
        ViewGroup currentParent = (ViewGroup)itemView.getParent();
        if (currentParent != null) {
            currentParent.removeView(itemView);
        }
        ((ViewGroup)((Object)this.mMenuView)).addView(itemView, childIndex);
    }

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$filterLeftoverView(ViewGroup parent, int childIndex) {
        parent.removeViewAt(childIndex);
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$setCallback(MenuPresenter.Callback cb) {
        this.mCallback = cb;
    }

    private final MenuPresenter.Callback $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getCallback() {
        return this.mCallback;
    }

    private final MenuView.ItemView $$robo$$com_android_internal_view_menu_BaseMenuPresenter$createItemView(ViewGroup parent) {
        return (MenuView.ItemView)((Object)this.mSystemInflater.inflate(this.mItemLayoutRes, parent, false));
    }

    private final View $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getItemView(MenuItemImpl item, View convertView, ViewGroup parent) {
        MenuView.ItemView itemView = convertView instanceof MenuView.ItemView ? (MenuView.ItemView)((Object)convertView) : this.createItemView(parent);
        this.bindItemView(item, itemView);
        return (View)((Object)itemView);
    }

    public abstract void bindItemView(MenuItemImpl var1, MenuView.ItemView var2);

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$shouldIncludeItem(int childIndex, MenuItemImpl item) {
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        if (this.mCallback != null) {
            this.mCallback.onCloseMenu(menu2, allMenusAreClosing);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$onSubMenuSelected(SubMenuBuilder menu2) {
        if (this.mCallback != null) {
            return this.mCallback.onOpenSubMenu(menu2);
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$flagActionItems() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_BaseMenuPresenter$collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getId() {
        return this.mId;
    }

    private final void $$robo$$com_android_internal_view_menu_BaseMenuPresenter$setId(int id2) {
        this.mId = id2;
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$com_android_internal_view_menu_BaseMenuPresenter$__constructor__(context, n, n2);
    }

    public BaseMenuPresenter(Context context, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$__constructor__(android.content.Context int int ), 0, this, context, n, n2);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initForMenu", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$initForMenu(android.content.Context com.android.internal.view.menu.MenuBuilder ), 0, this, context, menuBuilder);
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getMenuView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getMenuView(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$updateMenuView(boolean ), 0, this, bl);
    }

    protected void addItemView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addItemView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$addItemView(android.view.View int ), 0, this, view, n);
    }

    protected boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterLeftoverView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$filterLeftoverView(android.view.ViewGroup int ), 0, this, viewGroup, n);
    }

    @Override
    public void setCallback(MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$setCallback(com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, callback);
    }

    public MenuPresenter.Callback getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getCallback(), 0, this);
    }

    public MenuView.ItemView createItemView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("createItemView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$createItemView(android.view.ViewGroup ), 0, this, viewGroup);
    }

    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getItemView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getItemView(com.android.internal.view.menu.MenuItemImpl android.view.View android.view.ViewGroup ), 0, this, menuItemImpl, view, viewGroup);
    }

    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIncludeItem", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$shouldIncludeItem(int com.android.internal.view.menu.MenuItemImpl ), 0, this, n, menuItemImpl);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$flagActionItems(), 0, this);
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandItemActionView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$expandItemActionView(com.android.internal.view.menu.MenuBuilder com.android.internal.view.menu.MenuItemImpl ), 0, this, menuBuilder, menuItemImpl);
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseItemActionView", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$collapseItemActionView(com.android.internal.view.menu.MenuBuilder com.android.internal.view.menu.MenuItemImpl ), 0, this, menuBuilder, menuItemImpl);
    }

    @Override
    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$getId(), 0, this);
    }

    public void setId(int n) {
        InvokeDynamicSupport.bootstrap("setId", $$robo$$com_android_internal_view_menu_BaseMenuPresenter$setId(int ), 0, this, n);
    }

    public /* synthetic */ BaseMenuPresenter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseMenuPresenter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

