/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.inputmethodservice.AbstractInputMethodService;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputConnectionWrapper
implements InputConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_WAIT_TIME_MILLIS = 2000;
    private IInputContext mIInputContext;
    private WeakReference<AbstractInputMethodService> mInputMethodService;
    private int mMissingMethods;

    private void $$robo$$com_android_internal_view_InputConnectionWrapper$__constructor__(WeakReference<AbstractInputMethodService> inputMethodService, IInputContext inputContext, int missingMethods) {
        this.mInputMethodService = inputMethodService;
        this.mIInputContext = inputContext;
        this.mMissingMethods = missingMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$com_android_internal_view_InputConnectionWrapper$getTextAfterCursor(int length, int flags) {
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getTextAfterCursor(length, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mTextAfterCursor;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$com_android_internal_view_InputConnectionWrapper$getTextBeforeCursor(int length, int flags) {
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getTextBeforeCursor(length, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mTextBeforeCursor;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$com_android_internal_view_InputConnectionWrapper$getSelectedText(int flags) {
        if (this.isMethodMissing(1)) {
            return null;
        }
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getSelectedText(flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mSelectedText;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_view_InputConnectionWrapper$getCursorCapsMode(int reqModes) {
        int value = 0;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getCursorCapsMode(reqModes, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mCursorCapsMode;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return 0;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtractedText $$robo$$com_android_internal_view_InputConnectionWrapper$getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getExtractedText(request, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mExtractedText;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$commitText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.commitText(text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$commitCompletion(CompletionInfo text) {
        if (this.isMethodMissing(4)) {
            return false;
        }
        try {
            this.mIInputContext.commitCompletion(text);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$commitCorrection(CorrectionInfo correctionInfo) {
        try {
            this.mIInputContext.commitCorrection(correctionInfo);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$setSelection(int start, int end) {
        try {
            this.mIInputContext.setSelection(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$performEditorAction(int actionCode) {
        try {
            this.mIInputContext.performEditorAction(actionCode);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$performContextMenuAction(int id2) {
        try {
            this.mIInputContext.performContextMenuAction(id2);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$setComposingRegion(int start, int end) {
        if (this.isMethodMissing(2)) {
            return false;
        }
        try {
            this.mIInputContext.setComposingRegion(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$setComposingText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.setComposingText(text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$finishComposingText() {
        try {
            this.mIInputContext.finishComposingText();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$sendKeyEvent(KeyEvent event) {
        try {
            this.mIInputContext.sendKeyEvent(event);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$clearMetaKeyStates(int states) {
        try {
            this.mIInputContext.clearMetaKeyStates(states);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mIInputContext.deleteSurroundingText(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        if (this.isMethodMissing(16)) {
            return false;
        }
        try {
            this.mIInputContext.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$reportFullscreenMode(boolean enabled) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$performPrivateCommand(String action, Bundle data) {
        try {
            this.mIInputContext.performPrivateCommand(action, data);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$requestCursorUpdates(int cursorUpdateMode) {
        boolean result = false;
        if (this.isMethodMissing(8)) {
            return false;
        }
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.requestUpdateCursorAnchorInfo(cursorUpdateMode, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    result = callback.mRequestUpdateCursorAnchorInfoResult;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    private final Handler $$robo$$com_android_internal_view_InputConnectionWrapper$getHandler() {
        return null;
    }

    private final void $$robo$$com_android_internal_view_InputConnectionWrapper$closeConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        boolean result = false;
        if (this.isMethodMissing(128)) {
            return false;
        }
        try {
            if ((flags & 1) != 0) {
                AbstractInputMethodService inputMethodService = (AbstractInputMethodService)this.mInputMethodService.get();
                if (inputMethodService == null) {
                    return false;
                }
                inputMethodService.exposeContent(inputContentInfo, this);
            }
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.commitContent(inputContentInfo, flags, opts, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    result = callback.mCommitContentResult;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_view_InputConnectionWrapper$isMethodMissing(int methodFlag) {
        return (this.mMissingMethods & methodFlag) == methodFlag;
    }

    private final String $$robo$$com_android_internal_view_InputConnectionWrapper$toString() {
        return "InputConnectionWrapper{idHash=#" + Integer.toHexString(System.identityHashCode(this)) + " mMissingMethods=" + InputConnectionInspector.getMissingMethodFlagsAsString(this.mMissingMethods) + "}";
    }

    private void __constructor__(WeakReference<AbstractInputMethodService> weakReference, IInputContext iInputContext, int n) {
        this.$$robo$$com_android_internal_view_InputConnectionWrapper$__constructor__(weakReference, iInputContext, n);
    }

    public InputConnectionWrapper(WeakReference<AbstractInputMethodService> weakReference, IInputContext iInputContext, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_InputConnectionWrapper$__constructor__(java.lang.ref.WeakReference<android.inputmethodservice.AbstractInputMethodService> com.android.internal.view.IInputContext int ), 0, this, weakReference, iInputContext, n);
    }

    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getTextAfterCursor", $$robo$$com_android_internal_view_InputConnectionWrapper$getTextAfterCursor(int int ), 0, this, n, n2);
    }

    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getTextBeforeCursor", $$robo$$com_android_internal_view_InputConnectionWrapper$getTextBeforeCursor(int int ), 0, this, n, n2);
    }

    @Override
    public CharSequence getSelectedText(int n) {
        return InvokeDynamicSupport.bootstrap("getSelectedText", $$robo$$com_android_internal_view_InputConnectionWrapper$getSelectedText(int ), 0, this, n);
    }

    @Override
    public int getCursorCapsMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCursorCapsMode", $$robo$$com_android_internal_view_InputConnectionWrapper$getCursorCapsMode(int ), 0, this, n);
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        return InvokeDynamicSupport.bootstrap("getExtractedText", $$robo$$com_android_internal_view_InputConnectionWrapper$getExtractedText(android.view.inputmethod.ExtractedTextRequest int ), 0, this, extractedTextRequest, n);
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitText", $$robo$$com_android_internal_view_InputConnectionWrapper$commitText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCompletion", $$robo$$com_android_internal_view_InputConnectionWrapper$commitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCorrection", $$robo$$com_android_internal_view_InputConnectionWrapper$commitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    @Override
    public boolean setSelection(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setSelection", $$robo$$com_android_internal_view_InputConnectionWrapper$setSelection(int int ), 0, this, n, n2);
    }

    @Override
    public boolean performEditorAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performEditorAction", $$robo$$com_android_internal_view_InputConnectionWrapper$performEditorAction(int ), 0, this, n);
    }

    @Override
    public boolean performContextMenuAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performContextMenuAction", $$robo$$com_android_internal_view_InputConnectionWrapper$performContextMenuAction(int ), 0, this, n);
    }

    @Override
    public boolean setComposingRegion(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setComposingRegion", $$robo$$com_android_internal_view_InputConnectionWrapper$setComposingRegion(int int ), 0, this, n, n2);
    }

    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setComposingText", $$robo$$com_android_internal_view_InputConnectionWrapper$setComposingText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public boolean finishComposingText() {
        return (boolean)InvokeDynamicSupport.bootstrap("finishComposingText", $$robo$$com_android_internal_view_InputConnectionWrapper$finishComposingText(), 0, this);
    }

    @Override
    public boolean beginBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$com_android_internal_view_InputConnectionWrapper$beginBatchEdit(), 0, this);
    }

    @Override
    public boolean endBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$com_android_internal_view_InputConnectionWrapper$endBatchEdit(), 0, this);
    }

    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$com_android_internal_view_InputConnectionWrapper$sendKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean clearMetaKeyStates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearMetaKeyStates", $$robo$$com_android_internal_view_InputConnectionWrapper$clearMetaKeyStates(int ), 0, this, n);
    }

    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingText", $$robo$$com_android_internal_view_InputConnectionWrapper$deleteSurroundingText(int int ), 0, this, n, n2);
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingTextInCodePoints", $$robo$$com_android_internal_view_InputConnectionWrapper$deleteSurroundingTextInCodePoints(int int ), 0, this, n, n2);
    }

    @Override
    public boolean reportFullscreenMode(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$com_android_internal_view_InputConnectionWrapper$reportFullscreenMode(boolean ), 0, this, bl);
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPrivateCommand", $$robo$$com_android_internal_view_InputConnectionWrapper$performPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public boolean requestCursorUpdates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestCursorUpdates", $$robo$$com_android_internal_view_InputConnectionWrapper$requestCursorUpdates(int ), 0, this, n);
    }

    @Override
    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_view_InputConnectionWrapper$getHandler(), 0, this);
    }

    @Override
    public void closeConnection() {
        InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$com_android_internal_view_InputConnectionWrapper$closeConnection(), 0, this);
    }

    @Override
    public boolean commitContent(InputContentInfo inputContentInfo, int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitContent", $$robo$$com_android_internal_view_InputConnectionWrapper$commitContent(android.view.inputmethod.InputContentInfo int android.os.Bundle ), 0, this, inputContentInfo, n, bundle);
    }

    private boolean isMethodMissing(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMethodMissing", $$robo$$com_android_internal_view_InputConnectionWrapper$isMethodMissing(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_view_InputConnectionWrapper$toString(), 0, this);
    }

    public /* synthetic */ InputConnectionWrapper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputConnectionWrapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InputContextCallback
    extends IInputContextCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "InputConnectionWrapper.ICC";
        public int mSeq;
        public boolean mHaveValue;
        public CharSequence mTextBeforeCursor;
        public CharSequence mTextAfterCursor;
        public CharSequence mSelectedText;
        public ExtractedText mExtractedText;
        public int mCursorCapsMode;
        public boolean mRequestUpdateCursorAnchorInfoResult;
        public boolean mCommitContentResult;
        private static InputContextCallback sInstance;
        private static int sSequenceNumber;

        private void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final InputContextCallback $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$getInstance() {
            Class<InputContextCallback> clazz = InputContextCallback.class;
            synchronized (InputContextCallback.class) {
                InputContextCallback callback;
                if (sInstance != null) {
                    callback = sInstance;
                    sInstance = null;
                    callback.mHaveValue = false;
                } else {
                    callback = new InputContextCallback();
                }
                callback.mSeq = sSequenceNumber++;
                // ** MonitorExit[var0] (shouldn't be in output)
                return callback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$dispose() {
            Class<InputContextCallback> clazz = InputContextCallback.class;
            synchronized (InputContextCallback.class) {
                if (sInstance == null) {
                    this.mTextAfterCursor = null;
                    this.mTextBeforeCursor = null;
                    this.mExtractedText = null;
                    sInstance = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setTextBeforeCursor(CharSequence textBeforeCursor, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mTextBeforeCursor = textBeforeCursor;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setTextBeforeCursor, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setTextAfterCursor(CharSequence textAfterCursor, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mTextAfterCursor = textAfterCursor;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setTextAfterCursor, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setSelectedText(CharSequence selectedText, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mSelectedText = selectedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setSelectedText, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setCursorCapsMode(int capsMode, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mCursorCapsMode = capsMode;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCursorCapsMode, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setExtractedText(ExtractedText extractedText, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mExtractedText = extractedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setExtractedText, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setRequestUpdateCursorAnchorInfoResult(boolean result, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mRequestUpdateCursorAnchorInfoResult = result;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCursorAnchorInfoRequestResult, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setCommitContentResult(boolean result, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mCommitContentResult = result;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i("InputConnectionWrapper.ICC", "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCommitContentResult, ignoring.");
                }
            }
        }

        private final void $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$waitForResultLocked() {
            long startTime = SystemClock.uptimeMillis();
            long endTime = startTime + 2000L;
            while (!this.mHaveValue) {
                long remainingTime = endTime - SystemClock.uptimeMillis();
                if (remainingTime <= 0L) {
                    Log.w("InputConnectionWrapper.ICC", "Timed out waiting on IInputContextCallback");
                    return;
                }
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        static void __staticInitializer__() {
            sInstance = new InputContextCallback();
            sSequenceNumber = 1;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$__constructor__();
        }

        InputContextCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$__constructor__(), 0, this);
        }

        private static InputContextCallback getInstance() {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$getInstance(), 0);
        }

        private void dispose() {
            InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$dispose(), 0, this);
        }

        @Override
        public void setTextBeforeCursor(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("setTextBeforeCursor", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setTextBeforeCursor(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        public void setTextAfterCursor(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("setTextAfterCursor", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setTextAfterCursor(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        public void setSelectedText(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("setSelectedText", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setSelectedText(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        public void setCursorCapsMode(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setCursorCapsMode", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setCursorCapsMode(int int ), 0, this, n, n2);
        }

        @Override
        public void setExtractedText(ExtractedText extractedText, int n) {
            InvokeDynamicSupport.bootstrap("setExtractedText", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setExtractedText(android.view.inputmethod.ExtractedText int ), 0, this, extractedText, n);
        }

        @Override
        public void setRequestUpdateCursorAnchorInfoResult(boolean bl, int n) {
            InvokeDynamicSupport.bootstrap("setRequestUpdateCursorAnchorInfoResult", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setRequestUpdateCursorAnchorInfoResult(boolean int ), 0, this, bl, n);
        }

        @Override
        public void setCommitContentResult(boolean bl, int n) {
            InvokeDynamicSupport.bootstrap("setCommitContentResult", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$setCommitContentResult(boolean int ), 0, this, bl, n);
        }

        void waitForResultLocked() {
            InvokeDynamicSupport.bootstrap("waitForResultLocked", $$robo$$com_android_internal_view_InputConnectionWrapper_InputContextCallback$waitForResultLocked(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(InputContextCallback.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputContextCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

