/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CollectionUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_util_CollectionUtils$__constructor__() {
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$filter(List<T> list, Predicate<? super T> predicate) {
        ArrayList<T> result = null;
        for (int i = 0; i < CollectionUtils.size(list); ++i) {
            T item = list.get(i);
            if (!predicate.test(item)) continue;
            result = ArrayUtils.add(result, item);
        }
        return CollectionUtils.emptyIfNull(result);
    }

    private static final <I, O> List<O> $$robo$$com_android_internal_util_CollectionUtils$map(List<I> cur, Function<? super I, ? extends O> f) {
        if (ArrayUtils.isEmpty(cur)) {
            return Collections.emptyList();
        }
        ArrayList<O> result = new ArrayList<O>();
        for (int i = 0; i < cur.size(); ++i) {
            result.add(f.apply(cur.get(i)));
        }
        return result;
    }

    private static final <I, O> List<O> $$robo$$com_android_internal_util_CollectionUtils$mapNotNull(List<I> cur, Function<? super I, ? extends O> f) {
        if (ArrayUtils.isEmpty(cur)) {
            return Collections.emptyList();
        }
        ArrayList<O> result = new ArrayList<O>();
        for (int i = 0; i < cur.size(); ++i) {
            O transformed = f.apply(cur.get(i));
            if (transformed == null) continue;
            result.add(transformed);
        }
        return result;
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$emptyIfNull(List<T> cur) {
        return cur == null ? Collections.emptyList() : cur;
    }

    private static final <T> Set<T> $$robo$$com_android_internal_util_CollectionUtils$emptyIfNull(Set<T> cur) {
        return cur == null ? Collections.emptySet() : cur;
    }

    private static final int $$robo$$com_android_internal_util_CollectionUtils$size(Collection<?> cur) {
        return cur != null ? cur.size() : 0;
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$filter(List<?> list, Class<T> c) {
        if (ArrayUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<?> result = null;
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (!c.isInstance(item)) continue;
            result = ArrayUtils.add(result, item);
        }
        return CollectionUtils.emptyIfNull(result);
    }

    private static final <T> boolean $$robo$$com_android_internal_util_CollectionUtils$any(List<T> items, Predicate<T> predicate) {
        return CollectionUtils.find(items, predicate) != null;
    }

    private static final <T> T $$robo$$com_android_internal_util_CollectionUtils$find(List<T> items, Predicate<T> predicate) {
        if (ArrayUtils.isEmpty(items)) {
            return null;
        }
        for (int i = 0; i < items.size(); ++i) {
            T item = items.get(i);
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$add(List<T> cur, T val) {
        if (cur == null || cur == Collections.emptyList()) {
            cur = new ArrayList<T>();
        }
        cur.add(val);
        return cur;
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$remove(List<T> cur, T val) {
        if (ArrayUtils.isEmpty(cur)) {
            return CollectionUtils.emptyIfNull(cur);
        }
        cur.remove(val);
        return cur;
    }

    private static final <T> List<T> $$robo$$com_android_internal_util_CollectionUtils$copyOf(List<T> cur) {
        return ArrayUtils.isEmpty(cur) ? Collections.emptyList() : new ArrayList<T>(cur);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_CollectionUtils$__constructor__();
    }

    private CollectionUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_CollectionUtils$__constructor__(), 0, this);
    }

    public static <T> List<T> filter(List<T> list, Predicate<? super T> predicate) {
        return InvokeDynamicSupport.bootstrapStatic("filter", $$robo$$com_android_internal_util_CollectionUtils$filter(java.util.List<T> java.util.function.Predicate<? super T> ), 0, list, predicate);
    }

    public static <I, O> List<O> map(List<I> list, Function<? super I, ? extends O> function) {
        return InvokeDynamicSupport.bootstrapStatic("map", $$robo$$com_android_internal_util_CollectionUtils$map(java.util.List<I> java.util.function.Function<? super I, ? extends O> ), 0, list, function);
    }

    public static <I, O> List<O> mapNotNull(List<I> list, Function<? super I, ? extends O> function) {
        return InvokeDynamicSupport.bootstrapStatic("mapNotNull", $$robo$$com_android_internal_util_CollectionUtils$mapNotNull(java.util.List<I> java.util.function.Function<? super I, ? extends O> ), 0, list, function);
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return InvokeDynamicSupport.bootstrapStatic("emptyIfNull", $$robo$$com_android_internal_util_CollectionUtils$emptyIfNull(java.util.List<T> ), 0, list);
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return InvokeDynamicSupport.bootstrapStatic("emptyIfNull", $$robo$$com_android_internal_util_CollectionUtils$emptyIfNull(java.util.Set<T> ), 0, set);
    }

    public static int size(Collection<?> collection) {
        return (int)InvokeDynamicSupport.bootstrapStatic("size", $$robo$$com_android_internal_util_CollectionUtils$size(java.util.Collection<?> ), 0, collection);
    }

    public static <T> List<T> filter(List<?> list, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("filter", $$robo$$com_android_internal_util_CollectionUtils$filter(java.util.List<?> java.lang.Class<T> ), 0, list, clazz);
    }

    public static <T> boolean any(List<T> list, Predicate<T> predicate) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("any", $$robo$$com_android_internal_util_CollectionUtils$any(java.util.List<T> java.util.function.Predicate<T> ), 0, list, predicate);
    }

    public static <T> T find(List<T> list, Predicate<T> predicate) {
        return (T)InvokeDynamicSupport.bootstrapStatic("find", $$robo$$com_android_internal_util_CollectionUtils$find(java.util.List<T> java.util.function.Predicate<T> ), 0, list, predicate);
    }

    public static <T> List<T> add(List<T> list, T t) {
        return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$com_android_internal_util_CollectionUtils$add(java.util.List<T> T ), 0, list, t);
    }

    public static <T> List<T> remove(List<T> list, T t) {
        return InvokeDynamicSupport.bootstrapStatic("remove", $$robo$$com_android_internal_util_CollectionUtils$remove(java.util.List<T> T ), 0, list, t);
    }

    public static <T> List<T> copyOf(List<T> list) {
        return InvokeDynamicSupport.bootstrapStatic("copyOf", $$robo$$com_android_internal_util_CollectionUtils$copyOf(java.util.List<T> ), 0, list);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollectionUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

