/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import com.android.internal.telephony.gsm.UsimPhoneBookManager;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordLoader;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AdnRecordCache
extends Handler
implements IccConstants,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private IccFileHandler mFh;
    private UsimPhoneBookManager mUsimPhoneBookManager;
    SparseArray<ArrayList<AdnRecord>> mAdnLikeFiles;
    SparseArray<ArrayList<Message>> mAdnLikeWaiters;
    SparseArray<Message> mUserWriteResponse;
    static int EVENT_LOAD_ALL_ADN_LIKE_DONE = 1;
    static int EVENT_UPDATE_ADN_DONE = 2;

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$__constructor__(IccFileHandler fh) {
        this.mAdnLikeFiles = new SparseArray();
        this.mAdnLikeWaiters = new SparseArray();
        this.mUserWriteResponse = new SparseArray();
        this.mFh = fh;
        this.mUsimPhoneBookManager = new UsimPhoneBookManager(this.mFh, this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$reset() {
        this.mAdnLikeFiles.clear();
        this.mUsimPhoneBookManager.reset();
        this.clearWaiters();
        this.clearUserWriters();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$clearWaiters() {
        int size = this.mAdnLikeWaiters.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<Message> waiters = this.mAdnLikeWaiters.valueAt(i);
            AsyncResult ar = new AsyncResult(null, null, new RuntimeException("AdnCache reset"));
            this.notifyWaiters(waiters, ar);
        }
        this.mAdnLikeWaiters.clear();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$clearUserWriters() {
        int size = this.mUserWriteResponse.size();
        for (int i = 0; i < size; ++i) {
            this.sendErrorResponse(this.mUserWriteResponse.valueAt(i), "AdnCace reset");
        }
        this.mUserWriteResponse.clear();
    }

    private final ArrayList<AdnRecord> $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$getRecordsIfLoaded(int efid) {
        return this.mAdnLikeFiles.get(efid);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$extensionEfForEf(int efid) {
        switch (efid) {
            case 28615: {
                return 28616;
            }
            case 28474: {
                return 28490;
            }
            case 28489: {
                return 28492;
            }
            case 28475: {
                return 28491;
            }
            case 28480: {
                return 28490;
            }
            case 20272: {
                return 0;
            }
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$sendErrorResponse(Message response, String errString) {
        if (response != null) {
            RuntimeException e = new RuntimeException(errString);
            AsyncResult.forMessage((Message)response).exception = e;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$updateAdnByIndex(int efid, AdnRecord adn, int recordIndex, String pin2, Message response) {
        int extensionEF = this.extensionEfForEf(efid);
        if (extensionEF < 0) {
            this.sendErrorResponse(response, "EF is not known ADN-like EF:0x" + Integer.toHexString(efid).toUpperCase());
            return;
        }
        Message pendingResponse = this.mUserWriteResponse.get(efid);
        if (pendingResponse != null) {
            this.sendErrorResponse(response, "Have pending update for EF:0x" + Integer.toHexString(efid).toUpperCase());
            return;
        }
        this.mUserWriteResponse.put(efid, response);
        new AdnRecordLoader(this.mFh).updateEF(adn, efid, extensionEF, recordIndex, pin2, this.obtainMessage(2, efid, recordIndex, adn));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$updateAdnBySearch(int efid, AdnRecord oldAdn, AdnRecord newAdn, String pin2, Message response) {
        Message pendingResponse;
        int extensionEF = this.extensionEfForEf(efid);
        if (extensionEF < 0) {
            this.sendErrorResponse(response, "EF is not known ADN-like EF:0x" + Integer.toHexString(efid).toUpperCase());
            return;
        }
        ArrayList<AdnRecord> oldAdnList = efid == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(efid);
        if (oldAdnList == null) {
            this.sendErrorResponse(response, "Adn list not exist for EF:0x" + Integer.toHexString(efid).toUpperCase());
            return;
        }
        int index = -1;
        int count = 1;
        Iterator<AdnRecord> it = oldAdnList.iterator();
        while (it.hasNext()) {
            if (oldAdn.isEqual(it.next())) {
                index = count;
                break;
            }
            ++count;
        }
        if (index == -1) {
            this.sendErrorResponse(response, "Adn record don't exist for " + oldAdn);
            return;
        }
        if (efid == 20272) {
            AdnRecord foundAdn = oldAdnList.get(index - 1);
            efid = foundAdn.mEfid;
            extensionEF = foundAdn.mExtRecord;
            index = foundAdn.mRecordNumber;
            newAdn.mEfid = efid;
            newAdn.mExtRecord = extensionEF;
            newAdn.mRecordNumber = index;
        }
        if ((pendingResponse = this.mUserWriteResponse.get(efid)) != null) {
            this.sendErrorResponse(response, "Have pending update for EF:0x" + Integer.toHexString(efid).toUpperCase());
            return;
        }
        this.mUserWriteResponse.put(efid, response);
        new AdnRecordLoader(this.mFh).updateEF(newAdn, efid, extensionEF, index, pin2, this.obtainMessage(2, efid, index, newAdn));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$requestLoadAllAdnLike(int efid, int extensionEf, Message response) {
        ArrayList<AdnRecord> result = efid == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(efid);
        if (result != null) {
            if (response != null) {
                AsyncResult.forMessage((Message)response).result = result;
                response.sendToTarget();
            }
            return;
        }
        ArrayList<Message> waiters = this.mAdnLikeWaiters.get(efid);
        if (waiters != null) {
            waiters.add(response);
            return;
        }
        waiters = new ArrayList();
        waiters.add(response);
        this.mAdnLikeWaiters.put(efid, waiters);
        if (extensionEf < 0) {
            if (response != null) {
                AsyncResult.forMessage((Message)response).exception = new RuntimeException("EF is not known ADN-like EF:0x" + Integer.toHexString(efid).toUpperCase());
                response.sendToTarget();
            }
            return;
        }
        new AdnRecordLoader(this.mFh).loadAllFromEF(efid, extensionEf, this.obtainMessage(1, efid, 0));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$notifyWaiters(ArrayList<Message> waiters, AsyncResult ar) {
        if (waiters == null) {
            return;
        }
        int s = waiters.size();
        for (int i = 0; i < s; ++i) {
            Message waiter = waiters.get(i);
            AsyncResult.forMessage(waiter, ar.result, ar.exception);
            waiter.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                int efid = msg.arg1;
                ArrayList<Message> waiters = this.mAdnLikeWaiters.get(efid);
                this.mAdnLikeWaiters.delete(efid);
                if (ar.exception == null) {
                    this.mAdnLikeFiles.put(efid, (ArrayList)ar.result);
                }
                this.notifyWaiters(waiters, ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                int efid = msg.arg1;
                int index = msg.arg2;
                AdnRecord adn = (AdnRecord)ar.userObj;
                if (ar.exception == null) {
                    this.mAdnLikeFiles.get(efid).set(index - 1, adn);
                    this.mUsimPhoneBookManager.invalidateCache();
                }
                Message response = this.mUserWriteResponse.get(efid);
                this.mUserWriteResponse.delete(efid);
                AsyncResult.forMessage(response, null, ar.exception);
                response.sendToTarget();
            }
        }
    }

    private void __constructor__(IccFileHandler iccFileHandler) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecordCache$__constructor__(iccFileHandler);
    }

    AdnRecordCache(IccFileHandler iccFileHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$__constructor__(com.android.internal.telephony.uicc.IccFileHandler ), 0, this, iccFileHandler);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$reset(), 0, this);
    }

    private void clearWaiters() {
        InvokeDynamicSupport.bootstrap("clearWaiters", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$clearWaiters(), 0, this);
    }

    private void clearUserWriters() {
        InvokeDynamicSupport.bootstrap("clearUserWriters", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$clearUserWriters(), 0, this);
    }

    public ArrayList<AdnRecord> getRecordsIfLoaded(int n) {
        return InvokeDynamicSupport.bootstrap("getRecordsIfLoaded", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$getRecordsIfLoaded(int ), 0, this, n);
    }

    public int extensionEfForEf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("extensionEfForEf", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$extensionEfForEf(int ), 0, this, n);
    }

    private void sendErrorResponse(Message message, String string2) {
        InvokeDynamicSupport.bootstrap("sendErrorResponse", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$sendErrorResponse(android.os.Message java.lang.String ), 0, this, message, string2);
    }

    public void updateAdnByIndex(int n, AdnRecord adnRecord, int n2, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("updateAdnByIndex", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$updateAdnByIndex(int com.android.internal.telephony.uicc.AdnRecord int java.lang.String android.os.Message ), 0, this, n, adnRecord, n2, string2, message);
    }

    public void updateAdnBySearch(int n, AdnRecord adnRecord, AdnRecord adnRecord2, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("updateAdnBySearch", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$updateAdnBySearch(int com.android.internal.telephony.uicc.AdnRecord com.android.internal.telephony.uicc.AdnRecord java.lang.String android.os.Message ), 0, this, n, adnRecord, adnRecord2, string2, message);
    }

    public void requestLoadAllAdnLike(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("requestLoadAllAdnLike", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$requestLoadAllAdnLike(int int android.os.Message ), 0, this, n, n2, message);
    }

    private void notifyWaiters(ArrayList<Message> arrayList, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("notifyWaiters", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$notifyWaiters(java.util.ArrayList<android.os.Message> android.os.AsyncResult ), 0, this, arrayList, asyncResult);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_AdnRecordCache$handleMessage(android.os.Message ), 0, this, message);
    }

    public /* synthetic */ AdnRecordCache() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdnRecordCache)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

