/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GsmSMSDispatcher
extends SMSDispatcher
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GsmSMSDispatcher";
    private static boolean VDBG = false;
    protected UiccController mUiccController;
    private AtomicReference<IccRecords> mIccRecords;
    private AtomicReference<UiccCardApplication> mUiccApplication;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private static int EVENT_NEW_SMS_STATUS_REPORT = 100;

    private void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(Phone phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher, GsmInboundSmsHandler gsmInboundSmsHandler) {
        this.mUiccController = null;
        this.mIccRecords = new AtomicReference();
        this.mUiccApplication = new AtomicReference();
        this.mCi.setOnSmsStatus(this, 100, null);
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 15, null);
        Rlog.d("GsmSMSDispatcher", "GsmSMSDispatcher created");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$dispose() {
        super.dispose();
        this.mCi.unSetOnSmsStatus(this);
        this.mUiccController.unregisterForIccChanged(this);
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getFormat() {
        return "3gpp";
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleStatusReport((AsyncResult)msg.obj);
                break;
            }
            case 14: {
                this.mGsmInboundSmsHandler.sendMessage(1, msg.obj);
                break;
            }
            case 15: {
                this.onUpdateIccAvailability();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleStatusReport(AsyncResult ar) {
        byte[] pdu = (byte[])ar.result;
        SmsMessage sms = SmsMessage.newFromCDS(pdu);
        if (sms != null) {
            int tpStatus = sms.getStatus();
            int messageRef = sms.mMessageRef;
            int count = this.deliveryPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                if (tpStatus >= 64 || tpStatus < 32) {
                    this.deliveryPendingList.remove(i);
                    tracker.updateSentMessageStatus(this.mContext, tpStatus);
                }
                PendingIntent intent = tracker.mDeliveryIntent;
                Intent fillIn = new Intent();
                fillIn.putExtra("pdu", pdu);
                fillIn.putExtra("format", this.getFormat());
                try {
                    intent.send(this.mContext, -1, fillIn);
                }
                catch (PendingIntent.CanceledException canceledException) {}
                break;
            }
        }
        this.mCi.acknowledgeLastIncomingGsmSms(true, 1, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, destPort, data, pdu);
            SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), null, false, null, false, true);
            String carrierPackage = this.getCarrierAppPackageName();
            if (carrierPackage != null) {
                Rlog.d("GsmSMSDispatcher", "Found carrier package.");
                SMSDispatcher.DataSmsSender smsSender = new SMSDispatcher.DataSmsSender(this, tracker);
                smsSender.sendSmsByCarrierApp(carrierPackage, new SMSDispatcher.SmsSenderCallback(this, smsSender));
            } else {
                Rlog.v("GsmSMSDispatcher", "No carrier package.");
                this.sendRawPdu(tracker);
            }
        } else {
            Rlog.e("GsmSMSDispatcher", "GsmSMSDispatcher.sendData(): getSubmitPdu() returned null");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg, boolean persistMessage) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, text, pdu);
            SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), messageUri, false, text, true, persistMessage);
            String carrierPackage = this.getCarrierAppPackageName();
            if (carrierPackage != null) {
                Rlog.d("GsmSMSDispatcher", "Found carrier package.");
                SMSDispatcher.TextSmsSender smsSender = new SMSDispatcher.TextSmsSender(this, tracker);
                smsSender.sendSmsByCarrierApp(carrierPackage, new SMSDispatcher.SmsSenderCallback(this, smsSender));
            } else {
                Rlog.v("GsmSMSDispatcher", "No carrier package.");
                this.sendRawPdu(tracker);
            }
        } else {
            Rlog.e("GsmSMSDispatcher", "GsmSMSDispatcher.sendText(): getSubmitPdu() returned null");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        throw new IllegalStateException("This method must be called only on ImsSMSDispatcher");
    }

    private final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly);
    }

    private final SMSDispatcher.SmsTracker $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getNewSubmitPduTracker(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, String fullMessageText) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, deliveryIntent != null, SmsHeader.toByteArray(smsHeader), encoding, smsHeader.languageTable, smsHeader.languageShiftTable);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, pdu);
            return this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), unsentPartCount, anyPartFailed, messageUri, smsHeader, !lastPart, fullMessageText, true, false);
        }
        Rlog.e("GsmSMSDispatcher", "GsmSMSDispatcher.sendNewSubmitPdu(): getSubmitPdu() returned null");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSubmitPdu(SMSDispatcher.SmsTracker tracker) {
        this.sendRawPdu(tracker);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        if (tracker.mRetryCount > 0) {
            Rlog.d("GsmSMSDispatcher", "sendSms:  mRetryCount=" + tracker.mRetryCount + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
            if ((1 & pdu[0]) == 1) {
                pdu[0] = (byte)(pdu[0] | 4);
                pdu[1] = (byte)tracker.mMessageRef;
            }
        }
        Rlog.d("GsmSMSDispatcher", "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        this.sendSmsByPstn(tracker);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSmsByPstn(SMSDispatcher.SmsTracker tracker) {
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            tracker.onFailed(this.mContext, GsmSMSDispatcher.getNotInServiceError(ss), 0);
            return;
        }
        HashMap<String, Object> map = tracker.getData();
        byte[] smsc = (byte[])map.get("smsc");
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        if (0 == tracker.mImsRetry && !this.isIms()) {
            if (tracker.mRetryCount > 0 && (1 & pdu[0]) == 1) {
                pdu[0] = (byte)(pdu[0] | 4);
                pdu[1] = (byte)tracker.mMessageRef;
            }
            if (tracker.mRetryCount == 0 && tracker.mExpectMore) {
                this.mCi.sendSMSExpectMore(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
            } else {
                this.mCi.sendSMS(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
            }
        } else {
            this.mCi.sendImsGsmSms(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getUiccCardApplication() {
        Rlog.d("GsmSMSDispatcher", "GsmSMSDispatcher: subId = " + this.mPhone.getSubId() + " slotId = " + this.mPhone.getPhoneId());
        return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 1);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        UiccCardApplication app = this.mUiccApplication.get();
        if (app != newUiccApplication) {
            if (app != null) {
                Rlog.d("GsmSMSDispatcher", "Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.mIccRecords.get().unregisterForNewSms(this);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                Rlog.d("GsmSMSDispatcher", "New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                if (this.mIccRecords.get() != null) {
                    this.mIccRecords.get().registerForNewSms(this, 14, null);
                }
            }
        }
    }

    private void __constructor__(Phone phone, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher, GsmInboundSmsHandler gsmInboundSmsHandler) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(phone, smsUsageMonitor, imsSMSDispatcher, gsmInboundSmsHandler);
    }

    public GsmSMSDispatcher(Phone phone, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher, GsmInboundSmsHandler gsmInboundSmsHandler) {
        super(phone, smsUsageMonitor, imsSMSDispatcher);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsUsageMonitor com.android.internal.telephony.ImsSMSDispatcher com.android.internal.telephony.gsm.GsmInboundSmsHandler ), 0, this, phone, smsUsageMonitor, imsSMSDispatcher, gsmInboundSmsHandler);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$dispose(), 0, this);
    }

    @Override
    protected String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getFormat(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleMessage(android.os.Message ), 0, this, message);
    }

    private void handleStatusReport(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleStatusReport", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleStatusReport(android.os.AsyncResult ), 0, this, asyncResult);
    }

    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendData(java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    @Override
    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2, Uri uri, String string5, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendText(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent android.net.Uri java.lang.String boolean ), 0, this, string2, string3, string4, pendingIntent, pendingIntent2, uri, string5, bl);
    }

    @Override
    protected void injectSmsPdu(byte[] byArray, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$injectSmsPdu(byte[] java.lang.String android.app.PendingIntent ), 0, this, byArray, string2, pendingIntent);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateLength", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$calculateLength(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    @Override
    protected SMSDispatcher.SmsTracker getNewSubmitPduTracker(String string2, String string3, String string4, SmsHeader smsHeader, int n, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, String string5) {
        return InvokeDynamicSupport.bootstrap("getNewSubmitPduTracker", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getNewSubmitPduTracker(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsHeader int android.app.PendingIntent android.app.PendingIntent boolean java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri java.lang.String ), 0, this, string2, string3, string4, smsHeader, n, pendingIntent, pendingIntent2, bl, atomicInteger, atomicBoolean, uri, string5);
    }

    @Override
    protected void sendSubmitPdu(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSubmitPdu", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSubmitPdu(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSms", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    @Override
    protected void sendSmsByPstn(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSmsByPstn", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSmsByPstn(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getUiccCardApplication(), 0, this);
    }

    private void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$onUpdateIccAvailability(), 0, this);
    }

    public /* synthetic */ GsmSMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmSMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

