/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.Message;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.VisualVoicemailSmsFilter;
import com.android.internal.telephony.gsm.GsmCellBroadcastHandler;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.gsm.UsimDataDownloadHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UsimServiceTable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmInboundSmsHandler
extends InboundSmsHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private UsimDataDownloadHandler mDataDownloadHandler;

    private void $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$__constructor__(Context context, SmsStorageMonitor storageMonitor, Phone phone) {
        phone.mCi.setOnNewGsmSms(this.getHandler(), 1, null);
        this.mDataDownloadHandler = new UsimDataDownloadHandler(phone.mCi);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$onQuitting() {
        this.mPhone.mCi.unSetOnNewGsmSms(this.getHandler());
        this.mCellBroadcastHandler.dispose();
        this.log("unregistered for 3GPP SMS");
        super.onQuitting();
    }

    private static final GsmInboundSmsHandler $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$makeInboundSmsHandler(Context context, SmsStorageMonitor storageMonitor, Phone phone) {
        GsmInboundSmsHandler handler = new GsmInboundSmsHandler(context, storageMonitor, phone);
        handler.start();
        return handler;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$is3gpp2() {
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$dispatchMessageRadioSpecific(SmsMessageBase smsb) {
        SmsMessage sms = (SmsMessage)smsb;
        if (sms.isTypeZero()) {
            int destPort = -1;
            SmsHeader smsHeader = sms.getUserDataHeader();
            if (smsHeader != null && smsHeader.portAddrs != null) {
                destPort = smsHeader.portAddrs.destPort;
            }
            VisualVoicemailSmsFilter.filter(this.mContext, new byte[][]{sms.getPdu()}, "3gpp", destPort, this.mPhone.getSubId());
            this.log("Received short message type 0, Don't display or store it. Send Ack");
            return 1;
        }
        if (sms.isUsimDataDownload()) {
            UsimServiceTable ust = this.mPhone.getUsimServiceTable();
            return this.mDataDownloadHandler.handleUsimDataDownload(ust, sms);
        }
        boolean handled = false;
        if (sms.isMWISetMessage()) {
            this.updateMessageWaitingIndicator(sms.getNumOfVoicemails());
            handled = sms.isMwiDontStore();
            this.log("Received voice mail indicator set SMS shouldStore=" + !handled);
        } else if (sms.isMWIClearMessage()) {
            this.updateMessageWaitingIndicator(0);
            handled = sms.isMwiDontStore();
            this.log("Received voice mail indicator clear SMS shouldStore=" + !handled);
        }
        if (handled) {
            return 1;
        }
        if (!this.mStorageMonitor.isStorageAvailable() && sms.getMessageClass() != SmsConstants.MessageClass.CLASS_0) {
            return 3;
        }
        return this.dispatchNormalMessage(smsb);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$updateMessageWaitingIndicator(int voicemailCount) {
        if (voicemailCount < 0) {
            voicemailCount = -1;
        } else if (voicemailCount > 255) {
            voicemailCount = 255;
        }
        this.mPhone.setVoiceMessageCount(voicemailCount);
        IccRecords records = UiccController.getInstance().getIccRecords(this.mPhone.getPhoneId(), 1);
        if (records != null) {
            this.log("updateMessageWaitingIndicator: updating SIM Records");
            records.setVoiceMessageWaiting(1, voicemailCount);
        } else {
            this.log("updateMessageWaitingIndicator: SIM Records not found");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        this.mPhone.mCi.acknowledgeLastIncomingGsmSms(success, GsmInboundSmsHandler.resultToCause(result), response);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$onUpdatePhoneObject(Phone phone) {
        super.onUpdatePhoneObject(phone);
        this.log("onUpdatePhoneObject: dispose of old CellBroadcastHandler and make a new one");
        this.mCellBroadcastHandler.dispose();
        this.mCellBroadcastHandler = GsmCellBroadcastHandler.makeGsmCellBroadcastHandler(this.mContext, phone);
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 211;
            }
        }
        return 255;
    }

    private void __constructor__(Context context, SmsStorageMonitor smsStorageMonitor, Phone phone) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$__constructor__(context, smsStorageMonitor, phone);
    }

    private GsmInboundSmsHandler(Context context, SmsStorageMonitor smsStorageMonitor, Phone phone) {
        super("GsmInboundSmsHandler", context, smsStorageMonitor, phone, GsmCellBroadcastHandler.makeGsmCellBroadcastHandler(context, phone));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$__constructor__(android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.Phone ), 0, this, context, smsStorageMonitor, phone);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$onQuitting(), 0, this);
    }

    public static GsmInboundSmsHandler makeInboundSmsHandler(Context context, SmsStorageMonitor smsStorageMonitor, Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("makeInboundSmsHandler", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$makeInboundSmsHandler(android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.Phone ), 0, (Context)context, (SmsStorageMonitor)smsStorageMonitor, (Phone)phone);
    }

    @Override
    protected boolean is3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrap("is3gpp2", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$is3gpp2(), 0, this);
    }

    @Override
    protected int dispatchMessageRadioSpecific(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchMessageRadioSpecific", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$dispatchMessageRadioSpecific(com.android.internal.telephony.SmsMessageBase ), 0, this, smsMessageBase);
    }

    private void updateMessageWaitingIndicator(int n) {
        InvokeDynamicSupport.bootstrap("updateMessageWaitingIndicator", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$updateMessageWaitingIndicator(int ), 0, this, n);
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingSms", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$acknowledgeLastIncomingSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    protected void onUpdatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("onUpdatePhoneObject", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$onUpdatePhoneObject(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    private static int resultToCause(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resultToCause", $$robo$$com_android_internal_telephony_gsm_GsmInboundSmsHandler$resultToCause(int ), 0, (int)n);
    }

    public /* synthetic */ GsmInboundSmsHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmInboundSmsHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

