/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.StringNetworkSpecifier;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionMonitor;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyNetworkFactory
extends NetworkFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public String LOG_TAG;
    protected static boolean DBG = true;
    private PhoneSwitcher mPhoneSwitcher;
    private SubscriptionController mSubscriptionController;
    private SubscriptionMonitor mSubscriptionMonitor;
    private DcTracker mDcTracker;
    private HashMap<NetworkRequest, LocalLog> mDefaultRequests;
    private HashMap<NetworkRequest, LocalLog> mSpecificRequests;
    private int mPhoneId;
    private boolean mIsActive;
    private boolean mIsDefault;
    private int mSubscriptionId;
    private static int TELEPHONY_NETWORK_SCORE = 50;
    private Handler mInternalHandler;
    private static int EVENT_ACTIVE_PHONE_SWITCH = 1;
    private static int EVENT_SUBSCRIPTION_CHANGED = 2;
    private static int EVENT_DEFAULT_SUBSCRIPTION_CHANGED = 3;
    private static int EVENT_NETWORK_REQUEST = 4;
    private static int EVENT_NETWORK_RELEASE = 5;
    private static int REQUEST_LOG_SIZE = 40;
    private static boolean REQUEST = true;
    private static boolean RELEASE = false;

    private void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$__constructor__(PhoneSwitcher phoneSwitcher, SubscriptionController subscriptionController, SubscriptionMonitor subscriptionMonitor, Looper looper, Context context, int phoneId, DcTracker dcTracker) {
        this.mDefaultRequests = new HashMap();
        this.mSpecificRequests = new HashMap();
        this.mInternalHandler = new InternalHandler(this, looper);
        this.setCapabilityFilter(this.makeNetworkFilter(subscriptionController, phoneId));
        this.setScoreFilter(50);
        this.mPhoneSwitcher = phoneSwitcher;
        this.mSubscriptionController = subscriptionController;
        this.mSubscriptionMonitor = subscriptionMonitor;
        this.mPhoneId = phoneId;
        this.LOG_TAG = "TelephonyNetworkFactory[" + phoneId + "]";
        this.mDcTracker = dcTracker;
        this.mIsActive = false;
        this.mPhoneSwitcher.registerForActivePhoneSwitch(this.mPhoneId, this.mInternalHandler, 1, null);
        this.mSubscriptionId = -1;
        this.mSubscriptionMonitor.registerForSubscriptionChanged(this.mPhoneId, this.mInternalHandler, 2, null);
        this.mIsDefault = false;
        this.mSubscriptionMonitor.registerForDefaultDataSubscriptionChanged(this.mPhoneId, this.mInternalHandler, 3, null);
        this.register();
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$makeNetworkFilter(SubscriptionController subscriptionController, int phoneId) {
        int subscriptionId = subscriptionController.getSubIdUsingPhoneId(phoneId);
        return this.makeNetworkFilter(subscriptionId);
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$makeNetworkFilter(int subscriptionId) {
        NetworkCapabilities nc = new NetworkCapabilities();
        nc.addTransportType(0);
        nc.addCapability(0);
        nc.addCapability(1);
        nc.addCapability(2);
        nc.addCapability(3);
        nc.addCapability(4);
        nc.addCapability(5);
        nc.addCapability(7);
        nc.addCapability(8);
        nc.addCapability(9);
        nc.addCapability(10);
        nc.addCapability(13);
        nc.addCapability(12);
        nc.setNetworkSpecifier(new StringNetworkSpecifier(String.valueOf(subscriptionId)));
        return nc;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$applyRequests(HashMap<NetworkRequest, LocalLog> requestMap, boolean action, String logStr) {
        for (NetworkRequest networkRequest : requestMap.keySet()) {
            LocalLog localLog = requestMap.get(networkRequest);
            localLog.log(logStr);
            if (action) {
                this.mDcTracker.requestNetwork(networkRequest, localLog);
                continue;
            }
            this.mDcTracker.releaseNetwork(networkRequest, localLog);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onActivePhoneSwitch() {
        boolean newIsActive = this.mPhoneSwitcher.isPhoneActive(this.mPhoneId);
        if (this.mIsActive != newIsActive) {
            this.mIsActive = newIsActive;
            String logString = "onActivePhoneSwitch(" + this.mIsActive + ", " + this.mIsDefault + ")";
            this.log(logString);
            if (this.mIsDefault) {
                this.applyRequests(this.mDefaultRequests, this.mIsActive, logString);
            }
            this.applyRequests(this.mSpecificRequests, this.mIsActive, logString);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onSubIdChange() {
        int newSubscriptionId = this.mSubscriptionController.getSubIdUsingPhoneId(this.mPhoneId);
        if (this.mSubscriptionId != newSubscriptionId) {
            this.log("onSubIdChange " + this.mSubscriptionId + "->" + newSubscriptionId);
            this.mSubscriptionId = newSubscriptionId;
            this.setCapabilityFilter(this.makeNetworkFilter(this.mSubscriptionId));
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onDefaultChange() {
        boolean newIsDefault;
        int newDefaultSubscriptionId = this.mSubscriptionController.getDefaultDataSubId();
        boolean bl = newIsDefault = newDefaultSubscriptionId == this.mSubscriptionId;
        if (newIsDefault != this.mIsDefault) {
            this.mIsDefault = newIsDefault;
            String logString = "onDefaultChange(" + this.mIsActive + "," + this.mIsDefault + ")";
            this.log(logString);
            if (!this.mIsActive) {
                return;
            }
            this.applyRequests(this.mDefaultRequests, this.mIsDefault, logString);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$needNetworkFor(NetworkRequest networkRequest, int score) {
        Message msg = this.mInternalHandler.obtainMessage(4);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onNeedNetworkFor(Message msg) {
        NetworkRequest networkRequest = (NetworkRequest)msg.obj;
        boolean isApplicable = false;
        LocalLog localLog = null;
        if (networkRequest.networkCapabilities.getNetworkSpecifier() == null) {
            localLog = this.mDefaultRequests.get(networkRequest);
            if (localLog == null) {
                localLog = new LocalLog(40);
                localLog.log("created for " + networkRequest);
                this.mDefaultRequests.put(networkRequest, localLog);
                isApplicable = this.mIsDefault;
            }
        } else {
            localLog = this.mSpecificRequests.get(networkRequest);
            if (localLog == null) {
                localLog = new LocalLog(40);
                this.mSpecificRequests.put(networkRequest, localLog);
                isApplicable = true;
            }
        }
        if (this.mIsActive && isApplicable) {
            String s = "onNeedNetworkFor";
            localLog.log(s);
            this.log(s + " " + networkRequest);
            this.mDcTracker.requestNetwork(networkRequest, localLog);
        } else {
            String s = "not acting - isApp=" + isApplicable + ", isAct=" + this.mIsActive;
            localLog.log(s);
            this.log(s + " " + networkRequest);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$releaseNetworkFor(NetworkRequest networkRequest) {
        Message msg = this.mInternalHandler.obtainMessage(5);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onReleaseNetworkFor(Message msg) {
        NetworkRequest networkRequest = (NetworkRequest)msg.obj;
        LocalLog localLog = null;
        boolean isApplicable = false;
        if (networkRequest.networkCapabilities.getNetworkSpecifier() == null) {
            localLog = this.mDefaultRequests.remove(networkRequest);
            isApplicable = localLog != null && this.mIsDefault;
        } else {
            localLog = this.mSpecificRequests.remove(networkRequest);
            boolean bl = isApplicable = localLog != null;
        }
        if (this.mIsActive && isApplicable) {
            String s = "onReleaseNetworkFor";
            localLog.log(s);
            this.log(s + " " + networkRequest);
            this.mDcTracker.releaseNetwork(networkRequest, localLog);
        } else {
            String s = "not releasing - isApp=" + isApplicable + ", isAct=" + this.mIsActive;
            localLog.log(s);
            this.log(s + " " + networkRequest);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$log(String s) {
        Rlog.d(this.LOG_TAG, s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.LOG_TAG + " mSubId=" + this.mSubscriptionId + " mIsActive=" + this.mIsActive + " mIsDefault=" + this.mIsDefault);
        pw.println("Default Requests:");
        pw.increaseIndent();
        for (NetworkRequest nr : this.mDefaultRequests.keySet()) {
            pw.println(nr);
            pw.increaseIndent();
            this.mDefaultRequests.get(nr).dump(fd, pw, args);
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    private void __constructor__(PhoneSwitcher phoneSwitcher, SubscriptionController subscriptionController, SubscriptionMonitor subscriptionMonitor, Looper looper, Context context, int n, DcTracker dcTracker) {
        this.$$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$__constructor__(phoneSwitcher, subscriptionController, subscriptionMonitor, looper, context, n, dcTracker);
    }

    public TelephonyNetworkFactory(PhoneSwitcher phoneSwitcher, SubscriptionController subscriptionController, SubscriptionMonitor subscriptionMonitor, Looper looper, Context context, int n, DcTracker dcTracker) {
        super(looper, context, "TelephonyNetworkFactory[" + n + "]", null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$__constructor__(com.android.internal.telephony.PhoneSwitcher com.android.internal.telephony.SubscriptionController com.android.internal.telephony.SubscriptionMonitor android.os.Looper android.content.Context int com.android.internal.telephony.dataconnection.DcTracker ), 0, this, phoneSwitcher, subscriptionController, subscriptionMonitor, looper, context, n, dcTracker);
    }

    private NetworkCapabilities makeNetworkFilter(SubscriptionController subscriptionController, int n) {
        return InvokeDynamicSupport.bootstrap("makeNetworkFilter", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$makeNetworkFilter(com.android.internal.telephony.SubscriptionController int ), 0, this, subscriptionController, n);
    }

    private NetworkCapabilities makeNetworkFilter(int n) {
        return InvokeDynamicSupport.bootstrap("makeNetworkFilter", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$makeNetworkFilter(int ), 0, this, n);
    }

    private void applyRequests(HashMap<NetworkRequest, LocalLog> hashMap, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("applyRequests", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$applyRequests(java.util.HashMap<android.net.NetworkRequest, android.util.LocalLog> boolean java.lang.String ), 0, this, hashMap, bl, string2);
    }

    private void onActivePhoneSwitch() {
        InvokeDynamicSupport.bootstrap("onActivePhoneSwitch", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onActivePhoneSwitch(), 0, this);
    }

    private void onSubIdChange() {
        InvokeDynamicSupport.bootstrap("onSubIdChange", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onSubIdChange(), 0, this);
    }

    private void onDefaultChange() {
        InvokeDynamicSupport.bootstrap("onDefaultChange", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onDefaultChange(), 0, this);
    }

    @Override
    public void needNetworkFor(NetworkRequest networkRequest, int n) {
        InvokeDynamicSupport.bootstrap("needNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$needNetworkFor(android.net.NetworkRequest int ), 0, this, networkRequest, n);
    }

    private void onNeedNetworkFor(Message message) {
        InvokeDynamicSupport.bootstrap("onNeedNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onNeedNetworkFor(android.os.Message ), 0, this, message);
    }

    @Override
    public void releaseNetworkFor(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("releaseNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$releaseNetworkFor(android.net.NetworkRequest ), 0, this, networkRequest);
    }

    private void onReleaseNetworkFor(Message message) {
        InvokeDynamicSupport.bootstrap("onReleaseNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$onReleaseNetworkFor(android.os.Message ), 0, this, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ TelephonyNetworkFactory() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyNetworkFactory)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class InternalHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ TelephonyNetworkFactory this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory_InternalHandler$__constructor__(TelephonyNetworkFactory telephonyNetworkFactory, Looper looper) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory_InternalHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.onActivePhoneSwitch();
                    break;
                }
                case 2: {
                    this.this$0.onSubIdChange();
                    break;
                }
                case 3: {
                    this.this$0.onDefaultChange();
                    break;
                }
                case 4: {
                    this.this$0.onNeedNetworkFor(msg);
                    break;
                }
                case 5: {
                    this.this$0.onReleaseNetworkFor(msg);
                }
            }
        }

        private void __constructor__(TelephonyNetworkFactory telephonyNetworkFactory, Looper looper) {
            this.$$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory_InternalHandler$__constructor__(telephonyNetworkFactory, looper);
        }

        public InternalHandler(TelephonyNetworkFactory telephonyNetworkFactory, Looper looper) {
            this.this$0 = telephonyNetworkFactory;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory_InternalHandler$__constructor__(com.android.internal.telephony.dataconnection.TelephonyNetworkFactory android.os.Looper ), 0, this, telephonyNetworkFactory, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_dataconnection_TelephonyNetworkFactory_InternalHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ InternalHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

