/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.UserManager;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CarrierSmsUtils;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.IntRangeManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsNumberUtils;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IccSmsInterfaceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "IccSmsInterfaceManager";
    static boolean DBG = true;
    protected Object mLock;
    protected boolean mSuccess;
    private List<SmsRawData> mSms;
    private CellBroadcastRangeManager mCellBroadcastRangeManager;
    private CdmaBroadcastRangeManager mCdmaBroadcastRangeManager;
    private static int EVENT_LOAD_DONE = 1;
    private static int EVENT_UPDATE_DONE = 2;
    protected static int EVENT_SET_BROADCAST_ACTIVATION_DONE = 3;
    protected static int EVENT_SET_BROADCAST_CONFIG_DONE = 4;
    private static int SMS_CB_CODE_SCHEME_MIN = 0;
    private static int SMS_CB_CODE_SCHEME_MAX = 255;
    protected Phone mPhone;
    protected Context mContext;
    protected AppOpsManager mAppOps;
    private UserManager mUserManager;
    protected SMSDispatcher mDispatcher;
    protected Handler mHandler;

    private void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$__constructor__(Phone phone) {
        this.mLock = new Object();
        this.mCellBroadcastRangeManager = new CellBroadcastRangeManager(this);
        this.mCdmaBroadcastRangeManager = new CdmaBroadcastRangeManager(this);
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IccSmsInterfaceManager this$0;

            private void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_1$__constructor__(IccSmsInterfaceManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 2: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            this.this$0.mSuccess = ar.exception == null;
                            this.this$0.mLock.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            if (ar.exception == null) {
                                this.this$0.mSms = this.this$0.buildValidRawData((ArrayList)ar.result);
                                this.this$0.markMessagesAsRead((ArrayList)ar.result);
                            } else {
                                if (Rlog.isLoggable("SMS", 3)) {
                                    this.this$0.log("Cannot load Sms records");
                                }
                                this.this$0.mSms = null;
                            }
                            this.this$0.mLock.notifyAll();
                            break;
                        }
                    }
                    case 3: 
                    case 4: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            this.this$0.mSuccess = ar.exception == null;
                            this.this$0.mLock.notifyAll();
                            break;
                        }
                    }
                }
            }

            private void __constructor__(IccSmsInterfaceManager iccSmsInterfaceManager) {
                this.$$robo$$com_android_internal_telephony_IccSmsInterfaceManager_1$__constructor__(iccSmsInterfaceManager);
            }
            {
                this.this$0 = iccSmsInterfaceManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_1$__constructor__(com.android.internal.telephony.IccSmsInterfaceManager ), 0, this, iccSmsInterfaceManager);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mDispatcher = new ImsSMSDispatcher(phone, phone.mSmsStorageMonitor, phone.mSmsUsageMonitor);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$markMessagesAsRead(ArrayList<byte[]> messages) {
        if (messages == null) {
            return;
        }
        IccFileHandler fh = this.mPhone.getIccFileHandler();
        if (fh == null) {
            if (Rlog.isLoggable("SMS", 3)) {
                this.log("markMessagesAsRead - aborting, no icc card present.");
            }
            return;
        }
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] nba = new byte[n - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)1, (byte[])nba, (int)0, (int)(n - 1));
            byte[] record = this.makeSmsRecordData(1, nba);
            fh.updateEFLinearFixed(28476, i + 1, record, null, null);
            if (!Rlog.isLoggable("SMS", 3)) continue;
            this.log("SMS " + (i + 1) + " marked as read");
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$updatePhoneObject(Phone phone) {
        this.mPhone = phone;
        this.mDispatcher.updatePhoneObject(phone);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforceReceiveAndSend(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECEIVE_SMS", message);
        this.mContext.enforceCallingOrSelfPermission("android.permission.SEND_SMS", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$updateMessageOnIccEf(String callingPackage, int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> (" + Arrays.toString(pdu) + ")");
        this.enforceReceiveAndSend("Updating message on Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (status == 0) {
                if (1 == this.mPhone.getPhoneType()) {
                    this.mPhone.mCi.deleteSmsOnSim(index, response);
                } else {
                    this.mPhone.mCi.deleteSmsOnRuim(index, response);
                }
            } else {
                IccFileHandler fh = this.mPhone.getIccFileHandler();
                if (fh == null) {
                    response.recycle();
                    return this.mSuccess;
                }
                byte[] record = this.makeSmsRecordData(status, pdu);
                fh.updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$copyMessageToIccEf(String callingPackage, int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> pdu=(" + Arrays.toString(pdu) + "), smsc=(" + Arrays.toString(smsc) + ")");
        this.enforceReceiveAndSend("Copying message to Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (1 == this.mPhone.getPhoneType()) {
                this.mPhone.mCi.writeSmsToSim(status, IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), response);
            } else {
                this.mPhone.mCi.writeSmsToRuim(status, IccUtils.bytesToHexString(pdu), response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SmsRawData> $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getAllMessagesFromIccEf(String callingPackage) {
        this.log("getAllMessagesFromEF");
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECEIVE_SMS", "Reading messages from Icc");
        if (this.mAppOps.noteOp(21, Binder.getCallingUid(), callingPackage) != 0) {
            return new ArrayList<SmsRawData>();
        }
        Object object = this.mLock;
        synchronized (object) {
            IccFileHandler fh = this.mPhone.getIccFileHandler();
            if (fh == null) {
                Rlog.e("IccSmsInterfaceManager", "Cannot load Sms records. No icc card?");
                this.mSms = null;
                return this.mSms;
            }
            Message response = this.mHandler.obtainMessage(1);
            fh.loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the Icc");
            }
        }
        return this.mSms;
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendDataWithSelfPermissions(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingOrSelfPermission("android.permission.SEND_SMS", "Sending SMS message");
        this.sendDataInternal(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendData(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        this.sendDataInternal(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendDataInternal(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendData: destAddr=" + destAddr + " scAddr=" + scAddr + " destPort=" + destPort + " data='" + HexDump.toHexString(data) + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        destAddr = this.filterDestAddress(destAddr);
        this.mDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendText(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        this.sendTextInternal(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessageForNonDefaultSmsApp);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendTextWithSelfPermissions(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessage) {
        this.mPhone.getContext().enforceCallingOrSelfPermission("android.permission.SEND_SMS", "Sending SMS message");
        this.sendTextInternal(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessage);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendTextInternal(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp) {
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendText: destAddr=" + destAddr + " scAddr=" + scAddr + " text='" + text + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (!persistMessageForNonDefaultSmsApp) {
            this.enforcePrivilegedAppPermissions();
        }
        destAddr = this.filterDestAddress(destAddr);
        this.mDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, null, callingPackage, persistMessageForNonDefaultSmsApp);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        this.enforcePrivilegedAppPermissions();
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("pdu: " + pdu + "\n format=" + format + "\n receivedIntent=" + receivedIntent);
        }
        this.mDispatcher.injectSmsPdu(pdu, format, receivedIntent);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendMultipartText(String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, boolean persistMessageForNonDefaultSmsApp) {
        int i;
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (!persistMessageForNonDefaultSmsApp) {
            this.enforcePrivilegedAppPermissions();
        }
        if (Rlog.isLoggable("SMS", 2)) {
            i = 0;
            for (String part : parts) {
                this.log("sendMultipartText: destAddr=" + destAddr + ", srAddr=" + scAddr + ", part[" + i++ + "]=" + part);
            }
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        destAddr = this.filterDestAddress(destAddr);
        if (parts.size() > 1 && parts.size() < 10 && !SmsMessage.hasEmsSupport()) {
            for (i = 0; i < parts.size(); ++i) {
                String singlePart = parts.get(i);
                singlePart = SmsMessage.shouldAppendPageNumberAsPrefix() ? String.valueOf(i + 1) + '/' + parts.size() + ' ' + singlePart : singlePart.concat(' ' + String.valueOf(i + 1) + '/' + parts.size());
                PendingIntent singleSentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    singleSentIntent = sentIntents.get(i);
                }
                PendingIntent singleDeliveryIntent = null;
                if (deliveryIntents != null && deliveryIntents.size() > i) {
                    singleDeliveryIntent = deliveryIntents.get(i);
                }
                this.mDispatcher.sendText(destAddr, scAddr, singlePart, singleSentIntent, singleDeliveryIntent, null, callingPackage, persistMessageForNonDefaultSmsApp);
            }
            return;
        }
        this.mDispatcher.sendMultipartText(destAddr, scAddr, (ArrayList)parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents, null, callingPackage, persistMessageForNonDefaultSmsApp);
    }

    private final int $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getPremiumSmsPermission(String packageName) {
        return this.mDispatcher.getPremiumSmsPermission(packageName);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setPremiumSmsPermission(String packageName, int permission2) {
        this.mDispatcher.setPremiumSmsPermission(packageName, permission2);
    }

    private final ArrayList<SmsRawData> $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$buildValidRawData(ArrayList<byte[]> messages) {
        int count = messages.size();
        ArrayList<SmsRawData> ret = new ArrayList<SmsRawData>(count);
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] == 0) {
                ret.add(null);
                continue;
            }
            ret.add(new SmsRawData(messages.get(i)));
        }
        return ret;
    }

    private final byte[] $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$makeSmsRecordData(int status, byte[] pdu) {
        byte[] data = 1 == this.mPhone.getPhoneType() ? new byte[176] : new byte[255];
        data[0] = (byte)(status & 7);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)0, (byte[])data, (int)1, (int)pdu.length);
        for (int j = pdu.length + 1; j < data.length; ++j) {
            data[j] = -1;
        }
        return data;
    }

    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCellBroadcast(int messageIdentifier, int ranType) {
        return this.enableCellBroadcastRange(messageIdentifier, messageIdentifier, ranType);
    }

    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCellBroadcast(int messageIdentifier, int ranType) {
        return this.disableCellBroadcastRange(messageIdentifier, messageIdentifier, ranType);
    }

    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        if (ranType == 0) {
            return this.enableGsmBroadcastRange(startMessageId, endMessageId);
        }
        if (ranType == 1) {
            return this.enableCdmaBroadcastRange(startMessageId, endMessageId);
        }
        throw new IllegalArgumentException("Not a supportted RAN Type");
    }

    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        if (ranType == 0) {
            return this.disableGsmBroadcastRange(startMessageId, endMessageId);
        }
        if (ranType == 1) {
            return this.disableCdmaBroadcastRange(startMessageId, endMessageId);
        }
        throw new IllegalArgumentException("Not a supportted RAN Type");
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableGsmBroadcastRange(int startMessageId, int endMessageId) {
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to add GSM cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Added GSM cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableGsmBroadcastRange(int startMessageId, int endMessageId) {
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to remove GSM cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Removed GSM cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cdma broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to add cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Added cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to remove cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Removed cdma broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCellBroadcastConfig(SmsBroadcastConfigInfo[] configs) {
        this.log("Calling setGsmBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCellBroadcastActivation(boolean activate) {
        this.log("Calling setCellBroadcastActivation(" + activate + ')');
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast activation");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs) {
        this.log("Calling setCdmaBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCdmaBroadcastActivation(boolean activate) {
        this.log("Calling setCdmaBroadcastActivation(" + activate + ")");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast activation");
            }
        }
        return this.mSuccess;
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$log(String msg) {
        Log.d("IccSmsInterfaceManager", "[IccSmsInterfaceManager] " + msg);
    }

    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$isImsSmsSupported() {
        return this.mDispatcher.isIms();
    }

    private final String $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getImsSmsFormat() {
        return this.mDispatcher.getImsSmsFormat();
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendStoredText(String callingPkg, Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendStoredText: scAddr=" + scAddress + " messageUri=" + messageUri + " sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPkg) != 0) {
            return;
        }
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        if (!this.isFailedOrDraft(resolver, messageUri)) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]sendStoredText: not FAILED or DRAFT message");
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        String[] textAndAddress = this.loadTextAndAddress(resolver, messageUri);
        if (textAndAddress == null) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]sendStoredText: can not load text");
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        textAndAddress[1] = this.filterDestAddress(textAndAddress[1]);
        this.mDispatcher.sendText(textAndAddress[1], scAddress, textAndAddress[0], sentIntent, deliveryIntent, messageUri, callingPkg, true);
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendStoredMultipartText(String callingPkg, Uri messageUri, String scAddress, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (this.mAppOps.noteOp(20, Binder.getCallingUid(), callingPkg) != 0) {
            return;
        }
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        if (!this.isFailedOrDraft(resolver, messageUri)) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]sendStoredMultipartText: not FAILED or DRAFT message");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        String[] textAndAddress = this.loadTextAndAddress(resolver, messageUri);
        if (textAndAddress == null) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]sendStoredMultipartText: can not load text");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        ArrayList<String> parts = SmsManager.getDefault().divideMessage(textAndAddress[0]);
        if (parts == null || parts.size() < 1) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]sendStoredMultipartText: can not divide text");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        textAndAddress[1] = this.filterDestAddress(textAndAddress[1]);
        if (parts.size() > 1 && parts.size() < 10 && !SmsMessage.hasEmsSupport()) {
            for (int i = 0; i < parts.size(); ++i) {
                String singlePart = parts.get(i);
                singlePart = SmsMessage.shouldAppendPageNumberAsPrefix() ? String.valueOf(i + 1) + '/' + parts.size() + ' ' + singlePart : singlePart.concat(' ' + String.valueOf(i + 1) + '/' + parts.size());
                PendingIntent singleSentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    singleSentIntent = sentIntents.get(i);
                }
                PendingIntent singleDeliveryIntent = null;
                if (deliveryIntents != null && deliveryIntents.size() > i) {
                    singleDeliveryIntent = deliveryIntents.get(i);
                }
                this.mDispatcher.sendText(textAndAddress[1], scAddress, singlePart, singleSentIntent, singleDeliveryIntent, messageUri, callingPkg, true);
            }
            return;
        }
        this.mDispatcher.sendMultipartText(textAndAddress[1], scAddress, parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents, messageUri, callingPkg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$isFailedOrDraft(ContentResolver resolver, Uri messageUri) {
        long identity = Binder.clearCallingIdentity();
        Cursor cursor = null;
        try {
            cursor = resolver.query(messageUri, new String[]{"type"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int type = cursor.getInt(0);
                boolean bl = type == 3 || type == 5;
                return bl;
            }
        }
        catch (SQLiteException e) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]isFailedOrDraft: query message type failed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$loadTextAndAddress(ContentResolver resolver, Uri messageUri) {
        long identity = Binder.clearCallingIdentity();
        Cursor cursor = null;
        try {
            cursor = resolver.query(messageUri, new String[]{"body", "address"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                String[] stringArray = new String[]{cursor.getString(0), cursor.getString(1)};
                return stringArray;
            }
        }
        catch (SQLiteException e) {
            Log.e("IccSmsInterfaceManager", "[IccSmsInterfaceManager]loadText: query message text failed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$returnUnspecifiedFailure(PendingIntent pi) {
        if (pi != null) {
            try {
                pi.send(1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$returnUnspecifiedFailure(List<PendingIntent> pis) {
        if (pis == null) {
            return;
        }
        for (PendingIntent pi : pis) {
            this.returnUnspecifiedFailure(pi);
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforceCarrierPrivilege() {
        UiccController controller = UiccController.getInstance();
        if (controller == null || controller.getUiccCard(this.mPhone.getPhoneId()) == null) {
            throw new SecurityException("No Carrier Privilege: No UICC");
        }
        if (controller.getUiccCard(this.mPhone.getPhoneId()).getCarrierPrivilegeStatusForCurrentTransaction(this.mContext.getPackageManager()) != 1) {
            throw new SecurityException("No Carrier Privilege.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforcePrivilegedAppPermissions() {
        block4: {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0) {
                return;
            }
            int callingUid = Binder.getCallingUid();
            String carrierImsPackage = CarrierSmsUtils.getCarrierImsPackageForIntent(this.mContext, this.mPhone, new Intent("android.service.carrier.CarrierMessagingService"));
            try {
                if (carrierImsPackage != null && callingUid == this.mContext.getPackageManager().getPackageUid(carrierImsPackage, 0)) {
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!Rlog.isLoggable("SMS", 3)) break block4;
                this.log("Cannot find configured carrier ims package");
            }
        }
        this.enforceCarrierPrivilege();
    }

    private final String $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$filterDestAddress(String destAddr) {
        String result = null;
        result = SmsNumberUtils.filterDestAddr(this.mPhone, destAddr);
        return result != null ? result : destAddr;
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_IccSmsInterfaceManager$__constructor__(phone);
    }

    protected IccSmsInterfaceManager(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    protected void markMessagesAsRead(ArrayList<byte[]> arrayList) {
        InvokeDynamicSupport.bootstrap("markMessagesAsRead", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$markMessagesAsRead(java.util.ArrayList<byte[]> ), 0, this, arrayList);
    }

    protected void updatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$updatePhoneObject(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    protected void enforceReceiveAndSend(String string2) {
        InvokeDynamicSupport.bootstrap("enforceReceiveAndSend", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforceReceiveAndSend(java.lang.String ), 0, this, string2);
    }

    public boolean updateMessageOnIccEf(String string2, int n, int n2, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateMessageOnIccEf", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$updateMessageOnIccEf(java.lang.String int int byte[] ), 0, this, string2, n, n2, byArray);
    }

    public boolean copyMessageToIccEf(String string2, int n, byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("copyMessageToIccEf", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$copyMessageToIccEf(java.lang.String int byte[] byte[] ), 0, this, string2, n, byArray, byArray2);
    }

    public List<SmsRawData> getAllMessagesFromIccEf(String string2) {
        return InvokeDynamicSupport.bootstrap("getAllMessagesFromIccEf", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getAllMessagesFromIccEf(java.lang.String ), 0, this, string2);
    }

    public void sendDataWithSelfPermissions(String string2, String string3, String string4, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendDataWithSelfPermissions", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendDataWithSelfPermissions(java.lang.String java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, string4, n, byArray, pendingIntent, pendingIntent2);
    }

    public void sendData(String string2, String string3, String string4, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendData(java.lang.String java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, string4, n, byArray, pendingIntent, pendingIntent2);
    }

    private void sendDataInternal(String string2, String string3, String string4, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendDataInternal", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendDataInternal(java.lang.String java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, string4, n, byArray, pendingIntent, pendingIntent2);
    }

    public void sendText(String string2, String string3, String string4, String string5, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendText(java.lang.String java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent boolean ), 0, this, string2, string3, string4, string5, pendingIntent, pendingIntent2, bl);
    }

    public void sendTextWithSelfPermissions(String string2, String string3, String string4, String string5, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendTextWithSelfPermissions", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendTextWithSelfPermissions(java.lang.String java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent boolean ), 0, this, string2, string3, string4, string5, pendingIntent, pendingIntent2, bl);
    }

    private void sendTextInternal(String string2, String string3, String string4, String string5, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendTextInternal", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendTextInternal(java.lang.String java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent boolean ), 0, this, string2, string3, string4, string5, pendingIntent, pendingIntent2, bl);
    }

    public void injectSmsPdu(byte[] byArray, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$injectSmsPdu(byte[] java.lang.String android.app.PendingIntent ), 0, this, byArray, string2, pendingIntent);
    }

    public void sendMultipartText(String string2, String string3, String string4, List<String> list, List<PendingIntent> list2, List<PendingIntent> list3, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendMultipartText", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendMultipartText(java.lang.String java.lang.String java.lang.String java.util.List<java.lang.String> java.util.List<android.app.PendingIntent> java.util.List<android.app.PendingIntent> boolean ), 0, this, string2, string3, string4, list, list2, list3, bl);
    }

    public int getPremiumSmsPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPremiumSmsPermission", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getPremiumSmsPermission(java.lang.String ), 0, this, string2);
    }

    public void setPremiumSmsPermission(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPremiumSmsPermission", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setPremiumSmsPermission(java.lang.String int ), 0, this, string2, n);
    }

    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> arrayList) {
        return InvokeDynamicSupport.bootstrap("buildValidRawData", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$buildValidRawData(java.util.ArrayList<byte[]> ), 0, this, arrayList);
    }

    protected byte[] makeSmsRecordData(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("makeSmsRecordData", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$makeSmsRecordData(int byte[] ), 0, this, n, byArray);
    }

    public boolean enableCellBroadcast(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableCellBroadcast", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCellBroadcast(int int ), 0, this, n, n2);
    }

    public boolean disableCellBroadcast(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableCellBroadcast", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCellBroadcast(int int ), 0, this, n, n2);
    }

    public boolean enableCellBroadcastRange(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableCellBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCellBroadcastRange(int int int ), 0, this, n, n2, n3);
    }

    public boolean disableCellBroadcastRange(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableCellBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCellBroadcastRange(int int int ), 0, this, n, n2, n3);
    }

    public synchronized boolean enableGsmBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableGsmBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableGsmBroadcastRange(int int ), 0, this, n, n2);
    }

    public synchronized boolean disableGsmBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableGsmBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableGsmBroadcastRange(int int ), 0, this, n, n2);
    }

    public synchronized boolean enableCdmaBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableCdmaBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enableCdmaBroadcastRange(int int ), 0, this, n, n2);
    }

    public synchronized boolean disableCdmaBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableCdmaBroadcastRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$disableCdmaBroadcastRange(int int ), 0, this, n, n2);
    }

    private boolean setCellBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCellBroadcastConfig", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCellBroadcastConfig(com.android.internal.telephony.gsm.SmsBroadcastConfigInfo[] ), 0, this, smsBroadcastConfigInfoArray);
    }

    private boolean setCellBroadcastActivation(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCellBroadcastActivation", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCellBroadcastActivation(boolean ), 0, this, bl);
    }

    private boolean setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] cdmaSmsBroadcastConfigInfoArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCdmaBroadcastConfig(com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo[] ), 0, this, cdmaSmsBroadcastConfigInfoArray);
    }

    private boolean setCdmaBroadcastActivation(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCdmaBroadcastActivation", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$setCdmaBroadcastActivation(boolean ), 0, this, bl);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$log(java.lang.String ), 0, this, string2);
    }

    public boolean isImsSmsSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsSmsSupported", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$isImsSmsSupported(), 0, this);
    }

    public String getImsSmsFormat() {
        return InvokeDynamicSupport.bootstrap("getImsSmsFormat", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$getImsSmsFormat(), 0, this);
    }

    public void sendStoredText(String string2, Uri uri, String string3, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendStoredText", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendStoredText(java.lang.String android.net.Uri java.lang.String android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, uri, string3, pendingIntent, pendingIntent2);
    }

    public void sendStoredMultipartText(String string2, Uri uri, String string3, List<PendingIntent> list, List<PendingIntent> list2) {
        InvokeDynamicSupport.bootstrap("sendStoredMultipartText", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$sendStoredMultipartText(java.lang.String android.net.Uri java.lang.String java.util.List<android.app.PendingIntent> java.util.List<android.app.PendingIntent> ), 0, this, string2, uri, string3, list, list2);
    }

    private boolean isFailedOrDraft(ContentResolver contentResolver, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFailedOrDraft", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$isFailedOrDraft(android.content.ContentResolver android.net.Uri ), 0, this, contentResolver, uri);
    }

    private String[] loadTextAndAddress(ContentResolver contentResolver, Uri uri) {
        return InvokeDynamicSupport.bootstrap("loadTextAndAddress", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$loadTextAndAddress(android.content.ContentResolver android.net.Uri ), 0, this, contentResolver, uri);
    }

    private void returnUnspecifiedFailure(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("returnUnspecifiedFailure", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$returnUnspecifiedFailure(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private void returnUnspecifiedFailure(List<PendingIntent> list) {
        InvokeDynamicSupport.bootstrap("returnUnspecifiedFailure", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$returnUnspecifiedFailure(java.util.List<android.app.PendingIntent> ), 0, this, list);
    }

    private void enforceCarrierPrivilege() {
        InvokeDynamicSupport.bootstrap("enforceCarrierPrivilege", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforceCarrierPrivilege(), 0, this);
    }

    private void enforcePrivilegedAppPermissions() {
        InvokeDynamicSupport.bootstrap("enforcePrivilegedAppPermissions", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$enforcePrivilegedAppPermissions(), 0, this);
    }

    private String filterDestAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("filterDestAddress", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager$filterDestAddress(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ IccSmsInterfaceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccSmsInterfaceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class CdmaBroadcastRangeManager
    extends IntRangeManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<CdmaSmsBroadcastConfigInfo> mConfigList;
        /* synthetic */ IccSmsInterfaceManager this$0;

        private void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$__constructor__(IccSmsInterfaceManager this$0) {
            this.mConfigList = new ArrayList();
        }

        private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$startUpdate() {
            this.mConfigList.clear();
        }

        private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new CdmaSmsBroadcastConfigInfo(startId, endId, 1, selected));
        }

        private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            CdmaSmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new CdmaSmsBroadcastConfigInfo[this.mConfigList.size()]);
            return this.this$0.setCdmaBroadcastConfig(configs);
        }

        private void __constructor__(IccSmsInterfaceManager iccSmsInterfaceManager) {
            this.$$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$__constructor__(iccSmsInterfaceManager);
        }

        CdmaBroadcastRangeManager(IccSmsInterfaceManager iccSmsInterfaceManager) {
            this.this$0 = iccSmsInterfaceManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$__constructor__(com.android.internal.telephony.IccSmsInterfaceManager ), 0, this, iccSmsInterfaceManager);
        }

        @Override
        protected void startUpdate() {
            InvokeDynamicSupport.bootstrap("startUpdate", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$startUpdate(), 0, this);
        }

        @Override
        protected void addRange(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("addRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$addRange(int int boolean ), 0, this, n, n2, bl);
        }

        @Override
        protected boolean finishUpdate() {
            return (boolean)InvokeDynamicSupport.bootstrap("finishUpdate", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CdmaBroadcastRangeManager$finishUpdate(), 0, this);
        }

        public /* synthetic */ CdmaBroadcastRangeManager() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaBroadcastRangeManager)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class CellBroadcastRangeManager
    extends IntRangeManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<SmsBroadcastConfigInfo> mConfigList;
        /* synthetic */ IccSmsInterfaceManager this$0;

        private void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$__constructor__(IccSmsInterfaceManager this$0) {
            this.mConfigList = new ArrayList();
        }

        private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$startUpdate() {
            this.mConfigList.clear();
        }

        private final void $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new SmsBroadcastConfigInfo(startId, endId, 0, 255, selected));
        }

        private final boolean $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            SmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new SmsBroadcastConfigInfo[this.mConfigList.size()]);
            return this.this$0.setCellBroadcastConfig(configs);
        }

        private void __constructor__(IccSmsInterfaceManager iccSmsInterfaceManager) {
            this.$$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$__constructor__(iccSmsInterfaceManager);
        }

        CellBroadcastRangeManager(IccSmsInterfaceManager iccSmsInterfaceManager) {
            this.this$0 = iccSmsInterfaceManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$__constructor__(com.android.internal.telephony.IccSmsInterfaceManager ), 0, this, iccSmsInterfaceManager);
        }

        @Override
        protected void startUpdate() {
            InvokeDynamicSupport.bootstrap("startUpdate", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$startUpdate(), 0, this);
        }

        @Override
        protected void addRange(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("addRange", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$addRange(int int boolean ), 0, this, n, n2, bl);
        }

        @Override
        protected boolean finishUpdate() {
            return (boolean)InvokeDynamicSupport.bootstrap("finishUpdate", $$robo$$com_android_internal_telephony_IccSmsInterfaceManager_CellBroadcastRangeManager$finishUpdate(), 0, this);
        }

        public /* synthetic */ CellBroadcastRangeManager() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellBroadcastRangeManager)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

