/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Size;
import android.view.Gravity;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PipSnapAlgorithm
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SNAP_MODE_CORNERS_ONLY = 0;
    private static int SNAP_MODE_CORNERS_AND_SIDES = 1;
    private static int SNAP_MODE_EDGE = 2;
    private static int SNAP_MODE_EDGE_MAGNET_CORNERS = 3;
    private static int SNAP_MODE_LONG_EDGE_MAGNET_CORNERS = 4;
    private static float SCROLL_FRICTION_MULTIPLIER = 8.0f;
    private static float CORNER_MAGNET_THRESHOLD = 0.3f;
    private Context mContext;
    private ArrayList<Integer> mSnapGravities;
    private int mDefaultSnapMode = 3;
    private int mSnapMode;
    private float mDefaultSizePercent;
    private float mMinAspectRatioForMinSize;
    private float mMaxAspectRatioForMinSize;
    private Scroller mScroller;
    private int mOrientation;
    private int mMinimizedVisibleSize;
    private boolean mIsMinimized;

    private void $$robo$$com_android_internal_policy_PipSnapAlgorithm$__constructor__(Context context) {
        this.mSnapGravities = new ArrayList();
        this.mDefaultSnapMode = 3;
        this.mSnapMode = 3;
        this.mOrientation = 0;
        Resources res = context.getResources();
        this.mContext = context;
        this.mMinimizedVisibleSize = res.getDimensionPixelSize(17105180);
        this.mDefaultSizePercent = res.getFloat(17104954);
        this.mMaxAspectRatioForMinSize = res.getFloat(17104952);
        this.mMinAspectRatioForMinSize = 1.0f / this.mMaxAspectRatioForMinSize;
        this.onConfigurationChanged();
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$onConfigurationChanged() {
        Resources res = this.mContext.getResources();
        this.mOrientation = res.getConfiguration().orientation;
        this.mSnapMode = res.getInteger(17694834);
        this.calculateSnapTargets();
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$setMinimized(boolean isMinimized) {
        this.mIsMinimized = isMinimized;
    }

    private final Rect $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestSnapBounds(Rect movementBounds, Rect stackBounds, float velocityX, float velocityY) {
        Rect finalStackBounds = new Rect(stackBounds);
        if (this.mScroller == null) {
            ViewConfiguration viewConfig = ViewConfiguration.get(this.mContext);
            this.mScroller = new Scroller(this.mContext);
            this.mScroller.setFriction(viewConfig.getScrollFriction() * 8.0f);
        }
        this.mScroller.fling(stackBounds.left, stackBounds.top, (int)velocityX, (int)velocityY, movementBounds.left, movementBounds.right, movementBounds.top, movementBounds.bottom);
        finalStackBounds.offsetTo(this.mScroller.getFinalX(), this.mScroller.getFinalY());
        this.mScroller.abortAnimation();
        return this.findClosestSnapBounds(movementBounds, finalStackBounds);
    }

    private final Rect $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestSnapBounds(Rect movementBounds, Rect stackBounds) {
        Rect pipBounds = new Rect(movementBounds.left, movementBounds.top, movementBounds.right + stackBounds.width(), movementBounds.bottom + stackBounds.height());
        Rect newBounds = new Rect(stackBounds);
        if (this.mSnapMode == 4 || this.mSnapMode == 3) {
            float thresh;
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            float distance = this.distanceToPoint(snapTarget, stackBounds.left, stackBounds.top);
            if (distance < (thresh = (float)Math.max(stackBounds.width(), stackBounds.height()) * 0.3f)) {
                newBounds.offsetTo(snapTarget.x, snapTarget.y);
            } else {
                this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
            }
        } else if (this.mSnapMode == 2) {
            this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
        } else {
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            newBounds.offsetTo(snapTarget.x, snapTarget.y);
        }
        return newBounds;
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$applyMinimizedOffset(Rect stackBounds, Rect movementBounds, Point displaySize, Rect stableInsets) {
        if (stackBounds.left <= movementBounds.centerX()) {
            stackBounds.offsetTo(stableInsets.left + this.mMinimizedVisibleSize - stackBounds.width(), stackBounds.top);
        } else {
            stackBounds.offsetTo(displaySize.x - stableInsets.right - this.mMinimizedVisibleSize, stackBounds.top);
        }
    }

    private final float $$robo$$com_android_internal_policy_PipSnapAlgorithm$getSnapFraction(Rect stackBounds, Rect movementBounds) {
        Rect tmpBounds = new Rect();
        this.snapRectToClosestEdge(stackBounds, movementBounds, tmpBounds);
        float widthFraction = (float)(tmpBounds.left - movementBounds.left) / (float)movementBounds.width();
        float heightFraction = (float)(tmpBounds.top - movementBounds.top) / (float)movementBounds.height();
        if (tmpBounds.top == movementBounds.top) {
            return widthFraction;
        }
        if (tmpBounds.left == movementBounds.right) {
            return 1.0f + heightFraction;
        }
        if (tmpBounds.top == movementBounds.bottom) {
            return 2.0f + (1.0f - widthFraction);
        }
        return 3.0f + (1.0f - heightFraction);
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$applySnapFraction(Rect stackBounds, Rect movementBounds, float snapFraction) {
        if (snapFraction < 1.0f) {
            int offset = movementBounds.left + (int)(snapFraction * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.top);
        } else if (snapFraction < 2.0f) {
            int offset = movementBounds.top + (int)((snapFraction -= 1.0f) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.right, offset);
        } else if (snapFraction < 3.0f) {
            int offset = movementBounds.left + (int)((1.0f - (snapFraction -= 2.0f)) * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.bottom);
        } else {
            int offset = movementBounds.top + (int)((1.0f - (snapFraction -= 3.0f)) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.left, offset);
        }
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$getMovementBounds(Rect stackBounds, Rect insetBounds, Rect movementBoundsOut, int imeHeight) {
        movementBoundsOut.set(insetBounds);
        movementBoundsOut.right = Math.max(insetBounds.left, insetBounds.right - stackBounds.width());
        movementBoundsOut.bottom = Math.max(insetBounds.top, insetBounds.bottom - stackBounds.height());
        movementBoundsOut.bottom -= imeHeight;
    }

    private final Size $$robo$$com_android_internal_policy_PipSnapAlgorithm$getSizeForAspectRatio(float aspectRatio, float minEdgeSize, int displayWidth, int displayHeight) {
        int height;
        int width;
        int smallestDisplaySize = Math.min(displayWidth, displayHeight);
        int minSize = (int)Math.max(minEdgeSize, (float)smallestDisplaySize * this.mDefaultSizePercent);
        if (aspectRatio <= this.mMinAspectRatioForMinSize || aspectRatio > this.mMaxAspectRatioForMinSize) {
            if (aspectRatio <= 1.0f) {
                width = minSize;
                height = Math.round((float)width / aspectRatio);
            } else {
                height = minSize;
                width = Math.round((float)height * aspectRatio);
            }
        } else {
            float widthAtMaxAspectRatioForMinSize = this.mMaxAspectRatioForMinSize * (float)minSize;
            float radius = PointF.length(widthAtMaxAspectRatioForMinSize, minSize);
            height = (int)Math.round(Math.sqrt(radius * radius / (aspectRatio * aspectRatio + 1.0f)));
            width = Math.round((float)height * aspectRatio);
        }
        return new Size(width, height);
    }

    private final Point $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestPoint(int x, int y, Point[] points) {
        Point closestPoint = null;
        float minDistance = Float.MAX_VALUE;
        for (Point p : points) {
            float distance = this.distanceToPoint(p, x, y);
            if (!(distance < minDistance)) continue;
            closestPoint = p;
            minDistance = distance;
        }
        return closestPoint;
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$snapRectToClosestEdge(Rect stackBounds, Rect movementBounds, Rect boundsOut) {
        int boundedLeft = Math.max(movementBounds.left, Math.min(movementBounds.right, stackBounds.left));
        int boundedTop = Math.max(movementBounds.top, Math.min(movementBounds.bottom, stackBounds.top));
        boundsOut.set(stackBounds);
        if (this.mIsMinimized) {
            boundsOut.offsetTo(boundedLeft, boundedTop);
            return;
        }
        int fromLeft = Math.abs(stackBounds.left - movementBounds.left);
        int fromTop = Math.abs(stackBounds.top - movementBounds.top);
        int fromRight = Math.abs(movementBounds.right - stackBounds.left);
        int fromBottom = Math.abs(movementBounds.bottom - stackBounds.top);
        int shortest = this.mSnapMode == 4 ? (this.mOrientation == 2 ? Math.min(fromTop, fromBottom) : Math.min(fromLeft, fromRight)) : Math.min(Math.min(fromLeft, fromRight), Math.min(fromTop, fromBottom));
        if (shortest == fromLeft) {
            boundsOut.offsetTo(movementBounds.left, boundedTop);
        } else if (shortest == fromTop) {
            boundsOut.offsetTo(boundedLeft, movementBounds.top);
        } else if (shortest == fromRight) {
            boundsOut.offsetTo(movementBounds.right, boundedTop);
        } else {
            boundsOut.offsetTo(boundedLeft, movementBounds.bottom);
        }
    }

    private final float $$robo$$com_android_internal_policy_PipSnapAlgorithm$distanceToPoint(Point p, int x, int y) {
        return PointF.length(p.x - x, p.y - y);
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$calculateSnapTargets() {
        this.mSnapGravities.clear();
        switch (this.mSnapMode) {
            case 1: {
                if (this.mOrientation == 2) {
                    this.mSnapGravities.add(49);
                    this.mSnapGravities.add(81);
                } else {
                    this.mSnapGravities.add(19);
                    this.mSnapGravities.add(21);
                }
            }
            case 0: 
            case 3: 
            case 4: {
                this.mSnapGravities.add(51);
                this.mSnapGravities.add(53);
                this.mSnapGravities.add(83);
                this.mSnapGravities.add(85);
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PipSnapAlgorithm$dump(PrintWriter pw, String prefix) {
        String innerPrefix = prefix + "  ";
        pw.println(prefix + PipSnapAlgorithm.class.getSimpleName());
        pw.println(innerPrefix + "mSnapMode=" + this.mSnapMode);
        pw.println(innerPrefix + "mOrientation=" + this.mOrientation);
        pw.println(innerPrefix + "mMinimizedVisibleSize=" + this.mMinimizedVisibleSize);
        pw.println(innerPrefix + "mIsMinimized=" + this.mIsMinimized);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_policy_PipSnapAlgorithm$__constructor__(context);
    }

    public PipSnapAlgorithm(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PipSnapAlgorithm$__constructor__(android.content.Context ), 0, this, context);
    }

    public void onConfigurationChanged() {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_policy_PipSnapAlgorithm$onConfigurationChanged(), 0, this);
    }

    public void setMinimized(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMinimized", $$robo$$com_android_internal_policy_PipSnapAlgorithm$setMinimized(boolean ), 0, this, bl);
    }

    public Rect findClosestSnapBounds(Rect rect, Rect rect2, float f, float f2) {
        return InvokeDynamicSupport.bootstrap("findClosestSnapBounds", $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestSnapBounds(android.graphics.Rect android.graphics.Rect float float ), 0, this, rect, rect2, f, f2);
    }

    public Rect findClosestSnapBounds(Rect rect, Rect rect2) {
        return InvokeDynamicSupport.bootstrap("findClosestSnapBounds", $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestSnapBounds(android.graphics.Rect android.graphics.Rect ), 0, this, rect, rect2);
    }

    public void applyMinimizedOffset(Rect rect, Rect rect2, Point point, Rect rect3) {
        InvokeDynamicSupport.bootstrap("applyMinimizedOffset", $$robo$$com_android_internal_policy_PipSnapAlgorithm$applyMinimizedOffset(android.graphics.Rect android.graphics.Rect android.graphics.Point android.graphics.Rect ), 0, this, rect, rect2, point, rect3);
    }

    public float getSnapFraction(Rect rect, Rect rect2) {
        return (float)InvokeDynamicSupport.bootstrap("getSnapFraction", $$robo$$com_android_internal_policy_PipSnapAlgorithm$getSnapFraction(android.graphics.Rect android.graphics.Rect ), 0, this, rect, rect2);
    }

    public void applySnapFraction(Rect rect, Rect rect2, float f) {
        InvokeDynamicSupport.bootstrap("applySnapFraction", $$robo$$com_android_internal_policy_PipSnapAlgorithm$applySnapFraction(android.graphics.Rect android.graphics.Rect float ), 0, this, rect, rect2, f);
    }

    public void getMovementBounds(Rect rect, Rect rect2, Rect rect3, int n) {
        InvokeDynamicSupport.bootstrap("getMovementBounds", $$robo$$com_android_internal_policy_PipSnapAlgorithm$getMovementBounds(android.graphics.Rect android.graphics.Rect android.graphics.Rect int ), 0, this, rect, rect2, rect3, n);
    }

    public Size getSizeForAspectRatio(float f, float f2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSizeForAspectRatio", $$robo$$com_android_internal_policy_PipSnapAlgorithm$getSizeForAspectRatio(float float int int ), 0, this, f, f2, n, n2);
    }

    private Point findClosestPoint(int n, int n2, Point[] pointArray) {
        return InvokeDynamicSupport.bootstrap("findClosestPoint", $$robo$$com_android_internal_policy_PipSnapAlgorithm$findClosestPoint(int int android.graphics.Point[] ), 0, this, n, n2, pointArray);
    }

    private void snapRectToClosestEdge(Rect rect, Rect rect2, Rect rect3) {
        InvokeDynamicSupport.bootstrap("snapRectToClosestEdge", $$robo$$com_android_internal_policy_PipSnapAlgorithm$snapRectToClosestEdge(android.graphics.Rect android.graphics.Rect android.graphics.Rect ), 0, this, rect, rect2, rect3);
    }

    private float distanceToPoint(Point point, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("distanceToPoint", $$robo$$com_android_internal_policy_PipSnapAlgorithm$distanceToPoint(android.graphics.Point int int ), 0, this, point, n, n2);
    }

    private void calculateSnapTargets() {
        InvokeDynamicSupport.bootstrap("calculateSnapTargets", $$robo$$com_android_internal_policy_PipSnapAlgorithm$calculateSnapTargets(), 0, this);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_PipSnapAlgorithm$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    public /* synthetic */ PipSnapAlgorithm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PipSnapAlgorithm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

