/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.ArrayMap;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CpuPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CpuPowerCalculator";
    private static boolean DEBUG = false;
    private PowerProfile mProfile;

    private void $$robo$$com_android_internal_os_CpuPowerCalculator$__constructor__(PowerProfile profile) {
        this.mProfile = profile;
    }

    private final void $$robo$$com_android_internal_os_CpuPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.cpuTimeMs = (u.getUserCpuTimeUs(statsType) + u.getSystemCpuTimeUs(statsType)) / 1000L;
        long totalTime = 0L;
        int numClusters = this.mProfile.getNumCpuClusters();
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            int speedsForCluster = this.mProfile.getNumSpeedStepsInCpuCluster(cluster);
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                totalTime += u.getTimeAtCpuSpeed(cluster, speed, statsType);
            }
        }
        totalTime = Math.max(totalTime, 1L);
        double cpuPowerMaMs = 0.0;
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            int speedsForCluster = this.mProfile.getNumSpeedStepsInCpuCluster(cluster);
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                double ratio = (double)u.getTimeAtCpuSpeed(cluster, speed, statsType) / (double)totalTime;
                double cpuSpeedStepPower = ratio * (double)app.cpuTimeMs * this.mProfile.getAveragePowerForCpu(cluster, speed);
                cpuPowerMaMs += cpuSpeedStepPower;
            }
        }
        app.cpuPowerMah = cpuPowerMaMs / 3600000.0;
        double highestDrain = 0.0;
        app.cpuFgTimeMs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
        int processStatsCount = processStats.size();
        for (int i = 0; i < processStatsCount; ++i) {
            BatteryStats.Uid.Proc ps = processStats.valueAt(i);
            String processName = processStats.keyAt(i);
            app.cpuFgTimeMs += ps.getForegroundTime(statsType);
            long costValue = ps.getUserTime(statsType) + ps.getSystemTime(statsType) + ps.getForegroundTime(statsType);
            if (app.packageWithHighestDrain == null || app.packageWithHighestDrain.startsWith("*")) {
                highestDrain = costValue;
                app.packageWithHighestDrain = processName;
                continue;
            }
            if (!(highestDrain < (double)costValue) || processName.startsWith("*")) continue;
            highestDrain = costValue;
            app.packageWithHighestDrain = processName;
        }
        if (app.cpuFgTimeMs > app.cpuTimeMs) {
            app.cpuTimeMs = app.cpuFgTimeMs;
        }
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_CpuPowerCalculator$__constructor__(powerProfile);
    }

    public CpuPowerCalculator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_CpuPowerCalculator$__constructor__(com.android.internal.os.PowerProfile ), 0, this, powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_CpuPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), 0, this, batterySipper, uid, l, l2, n);
    }

    public /* synthetic */ CpuPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CpuPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

