/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.os.LocaleList;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.util.Printer;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.TextServicesManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.LocaleUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputMethodUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean DEBUG = false;
    public static int NOT_A_SUBTYPE_ID = -1;
    public static String SUBTYPE_MODE_ANY;
    public static String SUBTYPE_MODE_KEYBOARD = "keyboard";
    public static String SUBTYPE_MODE_VOICE = "voice";
    private static String TAG = "InputMethodUtils";
    private static Locale ENGLISH_LOCALE;
    private static String NOT_A_SUBTYPE_ID_STR;
    private static String TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE = "EnabledWhenDefaultIsNotAsciiCapable";
    private static String TAG_ASCII_CAPABLE = "AsciiCapable";
    private static char INPUT_METHOD_SEPARATOR = ':';
    private static char INPUT_METHOD_SUBTYPE_SEPARATOR = ';';
    private static Locale[] SEARCH_ORDER_OF_FALLBACK_LOCALES;
    private static Object sCacheLock;
    @GuardedBy(value="sCacheLock")
    private static LocaleList sCachedSystemLocales;
    @GuardedBy(value="sCacheLock")
    private static InputMethodInfo sCachedInputMethodInfo;
    @GuardedBy(value="sCacheLock")
    private static ArrayList<InputMethodSubtype> sCachedResult;
    private static LocaleUtils.LocaleExtractor<InputMethodSubtype> sSubtypeToLocale;
    private static Locale LOCALE_EN_US;
    private static Locale LOCALE_EN_GB;

    private void $$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$getApiCallStack() {
        String apiCallStack = "";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                String tempCallStack = frames[j].toString();
                if (TextUtils.isEmpty(apiCallStack)) {
                    apiCallStack = tempCallStack;
                    continue;
                }
                if (tempCallStack.indexOf("Transact(") >= 0) break;
                apiCallStack = tempCallStack;
            }
            return apiCallStack;
        }
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemIme(InputMethodInfo inputMethod) {
        return (inputMethod.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemImeThatHasSubtypeOf(InputMethodInfo imi, Context context, boolean checkDefaultAttribute, Locale requiredLocale, boolean checkCountry, String requiredSubtypeMode) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (checkDefaultAttribute && !imi.isDefault(context)) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(imi, requiredLocale, checkCountry, requiredSubtypeMode);
    }

    private static final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils$getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> imis, Context context) {
        int i;
        for (Locale fallbackLocale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (i = 0; i < imis.size(); ++i) {
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imis.get(i), context, true, fallbackLocale, true, "keyboard")) continue;
                return fallbackLocale;
            }
        }
        for (Locale fallbackLocale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (i = 0; i < imis.size(); ++i) {
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imis.get(i), context, false, fallbackLocale, true, "keyboard")) continue;
                return fallbackLocale;
            }
        }
        Slog.w("InputMethodUtils", "Found no fallback locale. imis=" + Arrays.toString(imis.toArray()));
        return null;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo imi, Context context, boolean checkDefaultAttribute) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (checkDefaultAttribute && !imi.isDefault(context)) {
            return false;
        }
        if (!imi.isAuxiliaryIme()) {
            return false;
        }
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype s = imi.getSubtypeAt(i);
            if (!s.overridesImplicitlyEnabledSubtype()) continue;
            return true;
        }
        return false;
    }

    private static final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSystemLocaleFromContext(Context context) {
        try {
            return context.getResources().getConfiguration().locale;
        }
        catch (Resources.NotFoundException ex) {
            return null;
        }
    }

    private static final InputMethodListBuilder $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMinimumKeyboardSetWithSystemLocale(ArrayList<InputMethodInfo> imis, Context context, Locale systemLocale, Locale fallbackLocale) {
        InputMethodListBuilder builder = new InputMethodListBuilder();
        builder.fillImes(imis, context, true, systemLocale, true, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, systemLocale, false, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, fallbackLocale, true, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, fallbackLocale, false, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, false, fallbackLocale, true, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, false, fallbackLocale, false, "keyboard");
        if (!builder.isEmpty()) {
            return builder;
        }
        Slog.w("InputMethodUtils", "No software keyboard is found. imis=" + Arrays.toString(imis.toArray()) + " systemLocale=" + systemLocale + " fallbackLocale=" + fallbackLocale);
        return builder;
    }

    private static final ArrayList<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getDefaultEnabledImes(Context context, ArrayList<InputMethodInfo> imis) {
        Locale fallbackLocale = InputMethodUtils.getFallbackLocaleForDefaultIme(imis, context);
        Locale systemLocale = InputMethodUtils.getSystemLocaleFromContext(context);
        return InputMethodUtils.getMinimumKeyboardSetWithSystemLocale(imis, context, systemLocale, fallbackLocale).fillImes(imis, context, true, systemLocale, true, SUBTYPE_MODE_ANY).fillAuxiliaryImes(imis, context).build();
    }

    private static final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils$constructLocaleFromString(String localeStr) {
        if (TextUtils.isEmpty(localeStr)) {
            return null;
        }
        String[] localeParams = localeStr.split("_", 3);
        if (localeParams.length >= 1 && "tl".equals(localeParams[0])) {
            localeParams[0] = "fil";
        }
        if (localeParams.length == 1) {
            return new Locale(localeParams[0]);
        }
        if (localeParams.length == 2) {
            return new Locale(localeParams[0], localeParams[1]);
        }
        if (localeParams.length == 3) {
            return new Locale(localeParams[0], localeParams[1], localeParams[2]);
        }
        return null;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(InputMethodInfo imi, Locale locale, boolean checkCountry, String mode) {
        if (locale == null) {
            return false;
        }
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            Locale subtypeLocale;
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!checkCountry ? !TextUtils.equals((subtypeLocale = new Locale(InputMethodUtils.getLanguageFromLocaleString(subtype.getLocale()))).getLanguage(), locale.getLanguage()) : (subtypeLocale = subtype.getLocaleObject()) == null || !TextUtils.equals(subtypeLocale.getLanguage(), locale.getLanguage()) || !TextUtils.equals(subtypeLocale.getCountry(), locale.getCountry())) continue;
            if (mode != SUBTYPE_MODE_ANY && !TextUtils.isEmpty(mode) && !mode.equalsIgnoreCase(subtype.getMode())) continue;
            return true;
        }
        return false;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypes(InputMethodInfo imi) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            subtypes.add(imi.getSubtypeAt(i));
        }
        return subtypes;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getOverridingImplicitlyEnabledSubtypes(InputMethodInfo imi, String mode) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || !subtype.getMode().equals(mode)) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    private static final InputMethodInfo $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMostApplicableDefaultIME(List<InputMethodInfo> enabledImes) {
        if (enabledImes == null || enabledImes.isEmpty()) {
            return null;
        }
        int i = enabledImes.size();
        int firstFoundSystemIme = -1;
        while (i > 0) {
            InputMethodInfo imi;
            if ((imi = enabledImes.get(--i)).isAuxiliaryIme()) continue;
            if (InputMethodUtils.isSystemIme(imi) && InputMethodUtils.containsSubtypeOf(imi, ENGLISH_LOCALE, false, "keyboard")) {
                return imi;
            }
            if (firstFoundSystemIme >= 0 || !InputMethodUtils.isSystemIme(imi)) continue;
            firstFoundSystemIme = i;
        }
        return enabledImes.get(Math.max(firstFoundSystemIme, 0));
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSubtypeId(InputMethodInfo imi, int subtypeHashCode) {
        return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode) != -1;
    }

    private static final int $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypeIdFromHashCode(InputMethodInfo imi, int subtypeHashCode) {
        if (imi != null) {
            int subtypeCount = imi.getSubtypeCount();
            for (int i = 0; i < subtypeCount; ++i) {
                InputMethodSubtype ims = imi.getSubtypeAt(i);
                if (subtypeHashCode != ims.hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLocked(Resources res, InputMethodInfo imi) {
        LocaleList systemLocales = res.getConfiguration().getLocales();
        Object object = sCacheLock;
        synchronized (object) {
            if (systemLocales.equals(sCachedSystemLocales) && sCachedInputMethodInfo == imi) {
                return new ArrayList<InputMethodSubtype>(sCachedResult);
            }
        }
        ArrayList<InputMethodSubtype> result = InputMethodUtils.getImplicitlyApplicableSubtypesLockedImpl(res, imi);
        Object object2 = sCacheLock;
        synchronized (object2) {
            sCachedSystemLocales = systemLocales;
            sCachedInputMethodInfo = imi;
            sCachedResult = new ArrayList<InputMethodSubtype>(result);
        }
        return result;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLockedImpl(Resources res, InputMethodInfo imi) {
        InputMethodSubtype lastResortKeyboardSubtype;
        ArrayList<InputMethodSubtype> subtypes = InputMethodUtils.getSubtypes(imi);
        LocaleList systemLocales = res.getConfiguration().getLocales();
        String systemLocale = systemLocales.get(0).toString();
        if (TextUtils.isEmpty(systemLocale)) {
            return new ArrayList<InputMethodSubtype>();
        }
        int numSubtypes = subtypes.size();
        HashMap<String, InputMethodSubtype> applicableModeAndSubtypesMap = new HashMap<String, InputMethodSubtype>();
        for (int i = 0; i < numSubtypes; ++i) {
            String mode;
            InputMethodSubtype subtype = (InputMethodSubtype)subtypes.get(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || applicableModeAndSubtypesMap.containsKey(mode = subtype.getMode())) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        if (applicableModeAndSubtypesMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        }
        HashMap nonKeyboardSubtypesMap = new HashMap();
        ArrayList<InputMethodSubtype> keyboardSubtypes = new ArrayList<InputMethodSubtype>();
        for (int i = 0; i < numSubtypes; ++i) {
            InputMethodSubtype subtype = (InputMethodSubtype)subtypes.get(i);
            String mode = subtype.getMode();
            if ("keyboard".equals(mode)) {
                keyboardSubtypes.add(subtype);
                continue;
            }
            if (!nonKeyboardSubtypesMap.containsKey(mode)) {
                nonKeyboardSubtypesMap.put(mode, new ArrayList());
            }
            ((ArrayList)nonKeyboardSubtypesMap.get(mode)).add(subtype);
        }
        ArrayList<InputMethodSubtype> applicableSubtypes = new ArrayList<InputMethodSubtype>();
        LocaleUtils.filterByLanguage(keyboardSubtypes, sSubtypeToLocale, systemLocales, applicableSubtypes);
        if (!applicableSubtypes.isEmpty()) {
            boolean hasAsciiCapableKeyboard = false;
            int numApplicationSubtypes = applicableSubtypes.size();
            for (int i = 0; i < numApplicationSubtypes; ++i) {
                InputMethodSubtype subtype = applicableSubtypes.get(i);
                if (!subtype.containsExtraValueKey("AsciiCapable")) continue;
                hasAsciiCapableKeyboard = true;
                break;
            }
            if (!hasAsciiCapableKeyboard) {
                int numKeyboardSubtypes = keyboardSubtypes.size();
                for (int i = 0; i < numKeyboardSubtypes; ++i) {
                    InputMethodSubtype subtype = (InputMethodSubtype)keyboardSubtypes.get(i);
                    String mode = subtype.getMode();
                    if (!"keyboard".equals(mode) || !subtype.containsExtraValueKey("EnabledWhenDefaultIsNotAsciiCapable")) continue;
                    applicableSubtypes.add(subtype);
                }
            }
        }
        if (applicableSubtypes.isEmpty() && (lastResortKeyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(res, subtypes, "keyboard", systemLocale, true)) != null) {
            applicableSubtypes.add(lastResortKeyboardSubtype);
        }
        for (ArrayList subtypeList : nonKeyboardSubtypesMap.values()) {
            LocaleUtils.filterByLanguage(subtypeList, sSubtypeToLocale, systemLocales, applicableSubtypes);
        }
        return applicableSubtypes;
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$getLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    private static final InputMethodSubtype $$robo$$com_android_internal_inputmethod_InputMethodUtils$findLastResortApplicableSubtypeLocked(Resources res, List<InputMethodSubtype> subtypes, String mode, String locale, boolean canIgnoreLocaleAsLastResort) {
        if (subtypes == null || subtypes.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty(locale)) {
            locale = res.getConfiguration().locale.toString();
        }
        String language = InputMethodUtils.getLanguageFromLocaleString(locale);
        boolean partialMatchFound = false;
        InputMethodSubtype applicableSubtype = null;
        InputMethodSubtype firstMatchedModeSubtype = null;
        int N = subtypes.size();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = subtypes.get(i);
            String subtypeLocale = subtype.getLocale();
            String subtypeLanguage = InputMethodUtils.getLanguageFromLocaleString(subtypeLocale);
            if (mode != null && !subtypes.get(i).getMode().equalsIgnoreCase(mode)) continue;
            if (firstMatchedModeSubtype == null) {
                firstMatchedModeSubtype = subtype;
            }
            if (locale.equals(subtypeLocale)) {
                applicableSubtype = subtype;
                break;
            }
            if (partialMatchFound || !language.equals(subtypeLanguage)) continue;
            applicableSubtype = subtype;
            partialMatchFound = true;
        }
        if (applicableSubtype == null && canIgnoreLocaleAsLastResort) {
            return firstMatchedModeSubtype;
        }
        return applicableSubtype;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$canAddToLastInputMethod(InputMethodSubtype subtype) {
        if (subtype == null) {
            return true;
        }
        return !subtype.isAuxiliary();
    }

    private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils$setNonSelectedSystemImesDisabledUntilUsed(IPackageManager packageManager, List<InputMethodInfo> enabledImis, int userId, String callingPackage) {
        String[] systemImesDisabledUntilUsed = Resources.getSystem().getStringArray(17236000);
        if (systemImesDisabledUntilUsed == null || systemImesDisabledUntilUsed.length == 0) {
            return;
        }
        SpellCheckerInfo currentSpellChecker = TextServicesManager.getInstance().getCurrentSpellChecker();
        for (String packageName : systemImesDisabledUntilUsed) {
            boolean isSystemPackage;
            boolean enabledIme = false;
            for (int j = 0; j < enabledImis.size(); ++j) {
                InputMethodInfo imi = enabledImis.get(j);
                if (!packageName.equals(imi.getPackageName())) continue;
                enabledIme = true;
                break;
            }
            if (enabledIme || currentSpellChecker != null && packageName.equals(currentSpellChecker.getPackageName())) continue;
            ApplicationInfo ai = null;
            try {
                ai = packageManager.getApplicationInfo(packageName, 32768, userId);
            }
            catch (RemoteException e) {
                Slog.w("InputMethodUtils", "getApplicationInfo failed. packageName=" + packageName + " userId=" + userId, e);
                continue;
            }
            if (ai == null) continue;
            boolean bl = isSystemPackage = (ai.flags & 1) != 0;
            if (!isSystemPackage) continue;
            InputMethodUtils.setDisabledUntilUsed(packageManager, packageName, userId, callingPackage);
        }
    }

    private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils$setDisabledUntilUsed(IPackageManager packageManager, String packageName, int userId, String callingPackage) {
        int state;
        try {
            state = packageManager.getApplicationEnabledSetting(packageName, userId);
        }
        catch (RemoteException e) {
            Slog.w("InputMethodUtils", "getApplicationEnabledSetting failed. packageName=" + packageName + " userId=" + userId, e);
            return;
        }
        if (state == 0 || state == 1) {
            try {
                packageManager.setApplicationEnabledSetting(packageName, 4, 0, userId, callingPackage);
            }
            catch (RemoteException e) {
                Slog.w("InputMethodUtils", "setApplicationEnabledSetting failed. packageName=" + packageName + " userId=" + userId + " callingPackage=" + callingPackage, e);
                return;
            }
        }
    }

    private static final CharSequence $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImeAndSubtypeDisplayName(Context context, InputMethodInfo imi, InputMethodSubtype subtype) {
        CharSequence imiLabel = imi.loadLabel(context.getPackageManager());
        return subtype != null ? TextUtils.concat(subtype.getDisplayName(context, imi.getPackageName(), imi.getServiceInfo().applicationInfo), TextUtils.isEmpty(imiLabel) ? "" : " - " + imiLabel) : imiLabel;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int uid, String packageName) {
        try {
            appOpsManager.checkPackage(uid, packageName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static final ArrayMap<String, ArraySet<String>> $$robo$$com_android_internal_inputmethod_InputMethodUtils$parseInputMethodsAndSubtypesString(String inputMethodsAndSubtypesString) {
        ArrayMap<String, ArraySet<String>> imeMap = new ArrayMap<String, ArraySet<String>>();
        if (TextUtils.isEmpty(inputMethodsAndSubtypesString)) {
            return imeMap;
        }
        TextUtils.SimpleStringSplitter typeSplitter = new TextUtils.SimpleStringSplitter(':');
        TextUtils.SimpleStringSplitter subtypeSplitter = new TextUtils.SimpleStringSplitter(';');
        List<Pair<String, ArrayList<String>>> allImeSettings = InputMethodSettings.buildInputMethodsAndSubtypeList(inputMethodsAndSubtypesString, typeSplitter, subtypeSplitter);
        for (Pair<String, ArrayList<String>> ime : allImeSettings) {
            ArraySet subtypes = new ArraySet();
            if (ime.second != null) {
                subtypes.addAll((Collection)ime.second);
            }
            imeMap.put((String)ime.first, subtypes);
        }
        return imeMap;
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$buildInputMethodsAndSubtypesString(ArrayMap<String, ArraySet<String>> map) {
        ArrayList<Pair<String, ArrayList<String>>> imeMap = new ArrayList<Pair<String, ArrayList<String>>>(4);
        for (Map.Entry<String, ArraySet<String>> entry : map.entrySet()) {
            String imeName = entry.getKey();
            ArraySet<String> subtypeSet = entry.getValue();
            ArrayList<String> subtypes = new ArrayList<String>(2);
            if (subtypeSet != null) {
                subtypes.addAll(subtypeSet);
            }
            imeMap.add(new Pair(imeName, subtypes));
        }
        return InputMethodSettings.buildInputMethodsSettingString(imeMap);
    }

    private static final ArrayList<Locale> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSuitableLocalesForSpellChecker(Locale systemLocale) {
        Locale systemLocaleLanguage;
        Locale systemLocaleLanguageCountry;
        Locale systemLocaleLanguageCountryVariant;
        if (systemLocale != null) {
            String language = systemLocale.getLanguage();
            boolean hasLanguage = !TextUtils.isEmpty(language);
            String country = systemLocale.getCountry();
            boolean hasCountry = !TextUtils.isEmpty(country);
            String variant = systemLocale.getVariant();
            boolean hasVariant = !TextUtils.isEmpty(variant);
            systemLocaleLanguageCountryVariant = hasLanguage && hasCountry && hasVariant ? new Locale(language, country, variant) : null;
            systemLocaleLanguageCountry = hasLanguage && hasCountry ? new Locale(language, country) : null;
            systemLocaleLanguage = hasLanguage ? new Locale(language) : null;
        } else {
            systemLocaleLanguageCountryVariant = null;
            systemLocaleLanguageCountry = null;
            systemLocaleLanguage = null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (systemLocaleLanguageCountryVariant != null) {
            locales.add(systemLocaleLanguageCountryVariant);
        }
        if (Locale.ENGLISH.equals(systemLocaleLanguage)) {
            if (systemLocaleLanguageCountry != null) {
                if (systemLocaleLanguageCountry != null) {
                    locales.add(systemLocaleLanguageCountry);
                }
                if (!LOCALE_EN_US.equals(systemLocaleLanguageCountry)) {
                    locales.add(LOCALE_EN_US);
                }
                if (!LOCALE_EN_GB.equals(systemLocaleLanguageCountry)) {
                    locales.add(LOCALE_EN_GB);
                }
                locales.add(Locale.ENGLISH);
            } else {
                locales.add(Locale.ENGLISH);
                locales.add(LOCALE_EN_US);
                locales.add(LOCALE_EN_GB);
            }
        } else {
            if (systemLocaleLanguageCountry != null) {
                locales.add(systemLocaleLanguageCountry);
            }
            if (systemLocaleLanguage != null) {
                locales.add(systemLocaleLanguage);
            }
            locales.add(LOCALE_EN_US);
            locales.add(LOCALE_EN_GB);
            locales.add(Locale.ENGLISH);
        }
        return locales;
    }

    static void __staticInitializer__() {
        SUBTYPE_MODE_ANY = null;
        ENGLISH_LOCALE = new Locale("en");
        NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
        SEARCH_ORDER_OF_FALLBACK_LOCALES = new Locale[]{Locale.ENGLISH, Locale.US, Locale.UK};
        sCacheLock = new Object();
        sSubtypeToLocale = new LocaleUtils.LocaleExtractor<InputMethodSubtype>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_inputmethod_InputMethodUtils_1$__constructor__() {
            }

            private final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils_1$get(InputMethodSubtype source) {
                return source != null ? source.getLocaleObject() : null;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_inputmethod_InputMethodUtils_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils_1$__constructor__(), 0, this);
            }

            @Override
            public Locale get(InputMethodSubtype inputMethodSubtype) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_inputmethod_InputMethodUtils_1$get(android.view.inputmethod.InputMethodSubtype ), 0, this, inputMethodSubtype);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        LOCALE_EN_US = new Locale("en", "US");
        LOCALE_EN_GB = new Locale("en", "GB");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__();
    }

    private InputMethodUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__(), 0, this);
    }

    public static String getApiCallStack() {
        return InvokeDynamicSupport.bootstrapStatic("getApiCallStack", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getApiCallStack(), 0);
    }

    public static boolean isSystemIme(InputMethodInfo inputMethodInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemIme", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemIme(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    public static boolean isSystemImeThatHasSubtypeOf(InputMethodInfo inputMethodInfo, Context context, boolean bl, Locale locale, boolean bl2, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemImeThatHasSubtypeOf", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemImeThatHasSubtypeOf(android.view.inputmethod.InputMethodInfo android.content.Context boolean java.util.Locale boolean java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (Context)context, (boolean)bl, (Locale)locale, (boolean)bl2, (String)string2);
    }

    public static Locale getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> arrayList, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getFallbackLocaleForDefaultIme", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getFallbackLocaleForDefaultIme(java.util.ArrayList<android.view.inputmethod.InputMethodInfo> android.content.Context ), 0, arrayList, (Context)context);
    }

    private static boolean isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo inputMethodInfo, Context context, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemAuxilialyImeThatHasAutomaticSubtype", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemAuxilialyImeThatHasAutomaticSubtype(android.view.inputmethod.InputMethodInfo android.content.Context boolean ), 0, (InputMethodInfo)inputMethodInfo, (Context)context, (boolean)bl);
    }

    public static Locale getSystemLocaleFromContext(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSystemLocaleFromContext", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSystemLocaleFromContext(android.content.Context ), 0, (Context)context);
    }

    private static InputMethodListBuilder getMinimumKeyboardSetWithSystemLocale(ArrayList<InputMethodInfo> arrayList, Context context, Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getMinimumKeyboardSetWithSystemLocale", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMinimumKeyboardSetWithSystemLocale(java.util.ArrayList<android.view.inputmethod.InputMethodInfo> android.content.Context java.util.Locale java.util.Locale ), 0, arrayList, (Context)context, (Locale)locale, (Locale)locale2);
    }

    public static ArrayList<InputMethodInfo> getDefaultEnabledImes(Context context, ArrayList<InputMethodInfo> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultEnabledImes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getDefaultEnabledImes(android.content.Context java.util.ArrayList<android.view.inputmethod.InputMethodInfo> ), 0, (Context)context, arrayList);
    }

    public static Locale constructLocaleFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("constructLocaleFromString", $$robo$$com_android_internal_inputmethod_InputMethodUtils$constructLocaleFromString(java.lang.String ), 0, (String)string2);
    }

    public static boolean containsSubtypeOf(InputMethodInfo inputMethodInfo, Locale locale, boolean bl, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSubtypeOf", $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(android.view.inputmethod.InputMethodInfo java.util.Locale boolean java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (Locale)locale, (boolean)bl, (String)string2);
    }

    public static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo inputMethodInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getSubtypes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypes(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    public static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo inputMethodInfo, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getOverridingImplicitlyEnabledSubtypes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getOverridingImplicitlyEnabledSubtypes(android.view.inputmethod.InputMethodInfo java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (String)string2);
    }

    public static InputMethodInfo getMostApplicableDefaultIME(List<InputMethodInfo> list) {
        return InvokeDynamicSupport.bootstrapStatic("getMostApplicableDefaultIME", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMostApplicableDefaultIME(java.util.List<android.view.inputmethod.InputMethodInfo> ), 0, list);
    }

    public static boolean isValidSubtypeId(InputMethodInfo inputMethodInfo, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSubtypeId", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSubtypeId(android.view.inputmethod.InputMethodInfo int ), 0, (InputMethodInfo)inputMethodInfo, (int)n);
    }

    public static int getSubtypeIdFromHashCode(InputMethodInfo inputMethodInfo, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSubtypeIdFromHashCode", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypeIdFromHashCode(android.view.inputmethod.InputMethodInfo int ), 0, (InputMethodInfo)inputMethodInfo, (int)n);
    }

    public static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources resources, InputMethodInfo inputMethodInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getImplicitlyApplicableSubtypesLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLocked(android.content.res.Resources android.view.inputmethod.InputMethodInfo ), 0, (Resources)resources, (InputMethodInfo)inputMethodInfo);
    }

    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLockedImpl(Resources resources, InputMethodInfo inputMethodInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getImplicitlyApplicableSubtypesLockedImpl", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLockedImpl(android.content.res.Resources android.view.inputmethod.InputMethodInfo ), 0, (Resources)resources, (InputMethodInfo)inputMethodInfo);
    }

    public static String getLanguageFromLocaleString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getLanguageFromLocaleString", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getLanguageFromLocaleString(java.lang.String ), 0, (String)string2);
    }

    public static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources resources, List<InputMethodSubtype> list, String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("findLastResortApplicableSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils$findLastResortApplicableSubtypeLocked(android.content.res.Resources java.util.List<android.view.inputmethod.InputMethodSubtype> java.lang.String java.lang.String boolean ), 0, (Resources)resources, list, (String)string2, (String)string3, (boolean)bl);
    }

    public static boolean canAddToLastInputMethod(InputMethodSubtype inputMethodSubtype) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canAddToLastInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils$canAddToLastInputMethod(android.view.inputmethod.InputMethodSubtype ), 0, (InputMethodSubtype)inputMethodSubtype);
    }

    public static void setNonSelectedSystemImesDisabledUntilUsed(IPackageManager iPackageManager, List<InputMethodInfo> list, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setNonSelectedSystemImesDisabledUntilUsed", $$robo$$com_android_internal_inputmethod_InputMethodUtils$setNonSelectedSystemImesDisabledUntilUsed(android.content.pm.IPackageManager java.util.List<android.view.inputmethod.InputMethodInfo> int java.lang.String ), 0, (IPackageManager)iPackageManager, list, (int)n, (String)string2);
    }

    private static void setDisabledUntilUsed(IPackageManager iPackageManager, String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setDisabledUntilUsed", $$robo$$com_android_internal_inputmethod_InputMethodUtils$setDisabledUntilUsed(android.content.pm.IPackageManager java.lang.String int java.lang.String ), 0, (IPackageManager)iPackageManager, (String)string2, (int)n, (String)string3);
    }

    public static CharSequence getImeAndSubtypeDisplayName(Context context, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        return InvokeDynamicSupport.bootstrapStatic("getImeAndSubtypeDisplayName", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImeAndSubtypeDisplayName(android.content.Context android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), 0, (Context)context, (InputMethodInfo)inputMethodInfo, (InputMethodSubtype)inputMethodSubtype);
    }

    public static boolean checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkIfPackageBelongsToUid", $$robo$$com_android_internal_inputmethod_InputMethodUtils$checkIfPackageBelongsToUid(android.app.AppOpsManager int java.lang.String ), 0, (AppOpsManager)appOpsManager, (int)n, (String)string2);
    }

    public static ArrayMap<String, ArraySet<String>> parseInputMethodsAndSubtypesString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseInputMethodsAndSubtypesString", $$robo$$com_android_internal_inputmethod_InputMethodUtils$parseInputMethodsAndSubtypesString(java.lang.String ), 0, (String)string2);
    }

    public static String buildInputMethodsAndSubtypesString(ArrayMap<String, ArraySet<String>> arrayMap) {
        return InvokeDynamicSupport.bootstrapStatic("buildInputMethodsAndSubtypesString", $$robo$$com_android_internal_inputmethod_InputMethodUtils$buildInputMethodsAndSubtypesString(android.util.ArrayMap<java.lang.String, android.util.ArraySet<java.lang.String>> ), 0, arrayMap);
    }

    public static ArrayList<Locale> getSuitableLocalesForSpellChecker(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getSuitableLocalesForSpellChecker", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSuitableLocalesForSpellChecker(java.util.Locale ), 0, (Locale)locale);
    }

    static {
        RobolectricInternals.classInitializing(InputMethodUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InputMethodSettings
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TextUtils.SimpleStringSplitter mInputMethodSplitter;
        private TextUtils.SimpleStringSplitter mSubtypeSplitter;
        private Resources mRes;
        private ContentResolver mResolver;
        private HashMap<String, InputMethodInfo> mMethodMap;
        private ArrayList<InputMethodInfo> mMethodList;
        private HashMap<String, String> mCopyOnWriteDataStore;
        private boolean mCopyOnWrite;
        private String mEnabledInputMethodsStrCache;
        private int mCurrentUserId;
        private int[] mCurrentProfileIds;

        private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildEnabledInputMethodsSettingString(StringBuilder builder, Pair<String, ArrayList<String>> ime) {
            builder.append((String)ime.first);
            for (String subtypeId : (ArrayList)ime.second) {
                builder.append(';').append(subtypeId);
            }
        }

        private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildInputMethodsSettingString(List<Pair<String, ArrayList<String>>> allImeSettingsMap) {
            StringBuilder b = new StringBuilder();
            boolean needsSeparator = false;
            for (Pair<String, ArrayList<String>> ime : allImeSettingsMap) {
                if (needsSeparator) {
                    b.append(':');
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(b, ime);
                needsSeparator = true;
            }
            return b.toString();
        }

        private static final List<Pair<String, ArrayList<String>>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildInputMethodsAndSubtypeList(String enabledInputMethodsStr, TextUtils.SimpleStringSplitter inputMethodSplitter, TextUtils.SimpleStringSplitter subtypeSplitter) {
            ArrayList<Pair<String, ArrayList<String>>> imsList = new ArrayList<Pair<String, ArrayList<String>>>();
            if (TextUtils.isEmpty(enabledInputMethodsStr)) {
                return imsList;
            }
            inputMethodSplitter.setString(enabledInputMethodsStr);
            while (inputMethodSplitter.hasNext()) {
                Object nextImsStr = inputMethodSplitter.next();
                subtypeSplitter.setString((String)nextImsStr);
                if (!subtypeSplitter.hasNext()) continue;
                ArrayList<Object> subtypeHashes = new ArrayList<Object>();
                Object imeId = subtypeSplitter.next();
                while (subtypeSplitter.hasNext()) {
                    subtypeHashes.add(subtypeSplitter.next());
                }
                imsList.add(new Pair(imeId, subtypeHashes));
            }
            return imsList;
        }

        private void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(Resources res, ContentResolver resolver, HashMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList, int userId, boolean copyOnWrite) {
            this.mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
            this.mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');
            this.mCopyOnWriteDataStore = new HashMap();
            this.mCopyOnWrite = false;
            this.mEnabledInputMethodsStrCache = "";
            this.mCurrentProfileIds = new int[0];
            this.mRes = res;
            this.mResolver = resolver;
            this.mMethodMap = methodMap;
            this.mMethodList = methodList;
            this.switchCurrentUser(userId, copyOnWrite);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$switchCurrentUser(int userId, boolean copyOnWrite) {
            if (this.mCurrentUserId != userId || this.mCopyOnWrite != copyOnWrite) {
                this.mCopyOnWriteDataStore.clear();
                this.mEnabledInputMethodsStrCache = "";
            }
            this.mCurrentUserId = userId;
            this.mCopyOnWrite = copyOnWrite;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putString(String key, String str) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, str);
            } else {
                Settings.Secure.putStringForUser(this.mResolver, key, str, this.mCurrentUserId);
            }
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getString(String key, String defaultValue) {
            String result = this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key) ? this.mCopyOnWriteDataStore.get(key) : Settings.Secure.getStringForUser(this.mResolver, key, this.mCurrentUserId);
            return result != null ? result : defaultValue;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putInt(String key, int value) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, String.valueOf(value));
            } else {
                Settings.Secure.putIntForUser(this.mResolver, key, value, this.mCurrentUserId);
            }
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getInt(String key, int defaultValue) {
            if (this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key)) {
                String result = this.mCopyOnWriteDataStore.get(key);
                return result != null ? Integer.parseInt(result) : 0;
            }
            return Settings.Secure.getIntForUser(this.mResolver, key, defaultValue, this.mCurrentUserId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putBoolean(String key, boolean value) {
            this.putInt(key, value ? 1 : 0);
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getBoolean(String key, boolean defaultValue) {
            return this.getInt(key, defaultValue ? 1 : 0) == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentProfileIds(int[] currentProfileIds) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                this.mCurrentProfileIds = currentProfileIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isCurrentProfile(int userId) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                if (userId == this.mCurrentUserId) {
                    return true;
                }
                for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
                    if (userId != this.mCurrentProfileIds[i]) continue;
                    return true;
                }
                return false;
            }
        }

        private final ArrayList<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        private final List<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
            List<InputMethodSubtype> enabledSubtypes = this.getEnabledInputMethodSubtypeListLocked(imi);
            if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
                enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
            }
            return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
        }

        private final List<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi) {
            List<Pair<String, ArrayList<String>>> imsList = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> enabledSubtypes = new ArrayList<InputMethodSubtype>();
            if (imi != null) {
                for (Pair<String, ArrayList<String>> imsPair : imsList) {
                    InputMethodInfo info = this.mMethodMap.get(imsPair.first);
                    if (info == null || !info.getId().equals(imi.getId())) continue;
                    int subtypeCount = info.getSubtypeCount();
                    for (int i = 0; i < subtypeCount; ++i) {
                        InputMethodSubtype ims = info.getSubtypeAt(i);
                        for (String s : (ArrayList)imsPair.second) {
                            if (!String.valueOf(ims.hashCode()).equals(s)) continue;
                            enabledSubtypes.add(ims);
                        }
                    }
                }
            }
            return enabledSubtypes;
        }

        private final List<Pair<String, ArrayList<String>>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsAndSubtypeListLocked() {
            return InputMethodSettings.buildInputMethodsAndSubtypeList(this.getEnabledInputMethodsStr(), this.mInputMethodSplitter, this.mSubtypeSplitter);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$appendAndPutEnabledInputMethodLocked(String id2, boolean reloadInputMethodStr) {
            if (reloadInputMethodStr) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty(this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(id2);
            } else {
                this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + id2);
            }
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder builder, List<Pair<String, ArrayList<String>>> imsList, String id2) {
            boolean isRemoved = false;
            boolean needsAppendSeparator = false;
            for (Pair<String, ArrayList<String>> ims : imsList) {
                String curId = (String)ims.first;
                if (curId.equals(id2)) {
                    isRemoved = true;
                    continue;
                }
                if (needsAppendSeparator) {
                    builder.append(':');
                } else {
                    needsAppendSeparator = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(builder, ims);
            }
            if (isRemoved) {
                this.putEnabledInputMethodsStr(builder.toString());
            }
            return isRemoved;
        }

        private final ArrayList<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<InputMethodInfo> res = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(info);
            }
            return res;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putEnabledInputMethodsStr(String str) {
            if (TextUtils.isEmpty(str)) {
                this.putString("enabled_input_methods", null);
            } else {
                this.putString("enabled_input_methods", str);
            }
            this.mEnabledInputMethodsStrCache = str != null ? str : "";
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = this.getString("enabled_input_methods", "");
            return this.mEnabledInputMethodsStrCache;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveSubtypeHistory(List<Pair<String, String>> savedImes, String newImeId, String newSubtypeId) {
            StringBuilder builder = new StringBuilder();
            boolean isImeAdded = false;
            if (!TextUtils.isEmpty(newImeId) && !TextUtils.isEmpty(newSubtypeId)) {
                builder.append(newImeId).append(';').append(newSubtypeId);
                isImeAdded = true;
            }
            for (Pair<String, String> ime : savedImes) {
                String imeId = (String)ime.first;
                String subtypeId = (String)ime.second;
                if (TextUtils.isEmpty(subtypeId)) {
                    subtypeId = NOT_A_SUBTYPE_ID_STR;
                }
                if (isImeAdded) {
                    builder.append(':');
                } else {
                    isImeAdded = true;
                }
                builder.append(imeId).append(';').append(subtypeId);
            }
            this.putSubtypeHistoryStr(builder.toString());
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$addSubtypeToHistory(String imeId, String subtypeId) {
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> ime : subtypeHistory) {
                if (!((String)ime.first).equals(imeId)) continue;
                subtypeHistory.remove(ime);
                break;
            }
            this.saveSubtypeHistory(subtypeHistory, imeId, subtypeId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSubtypeHistoryStr(String str) {
            if (TextUtils.isEmpty(str)) {
                this.putString("input_methods_subtype_history", null);
            } else {
                this.putString("input_methods_subtype_history", str);
            }
        }

        private final Pair<String, String> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLocked(String imeId) {
            Pair<String, String> ime = this.getLastSubtypeForInputMethodLockedInternal(imeId);
            if (ime != null) {
                return (String)ime.second;
            }
            return null;
        }

        private final Pair<String, String> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLockedInternal(String imeId) {
            List<Pair<String, ArrayList<String>>> enabledImes = this.getEnabledInputMethodsAndSubtypeListLocked();
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> imeAndSubtype : subtypeHistory) {
                String subtypeInTheHistory;
                String subtypeHashCode;
                String imeInTheHistory = (String)imeAndSubtype.first;
                if (!TextUtils.isEmpty(imeId) && !imeInTheHistory.equals(imeId) || TextUtils.isEmpty(subtypeHashCode = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(enabledImes, imeInTheHistory, subtypeInTheHistory = (String)imeAndSubtype.second))) continue;
                return new Pair<String, String>(imeInTheHistory, subtypeHashCode);
            }
            return null;
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> enabledImes, String imeId, String subtypeHashCode) {
            for (Pair<String, ArrayList<String>> enabledIme : enabledImes) {
                if (!((String)enabledIme.first).equals(imeId)) continue;
                ArrayList explicitlyEnabledSubtypes = (ArrayList)enabledIme.second;
                InputMethodInfo imi = this.mMethodMap.get(imeId);
                if (explicitlyEnabledSubtypes.size() == 0) {
                    ArrayList<InputMethodSubtype> implicitlySelectedSubtypes;
                    if (imi != null && imi.getSubtypeCount() > 0 && (implicitlySelectedSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(this.mRes, imi)) != null) {
                        int N = implicitlySelectedSubtypes.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype st = (InputMethodSubtype)implicitlySelectedSubtypes.get(i);
                            if (!String.valueOf(st.hashCode()).equals(subtypeHashCode)) continue;
                            return subtypeHashCode;
                        }
                    }
                } else {
                    for (String s : explicitlyEnabledSubtypes) {
                        if (!s.equals(subtypeHashCode)) continue;
                        try {
                            int hashCode = Integer.parseInt(subtypeHashCode);
                            if (InputMethodUtils.isValidSubtypeId(imi, hashCode)) {
                                return s;
                            }
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                        catch (NumberFormatException e) {
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private final List<Pair<String, String>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> imsList = new ArrayList<Pair<String, String>>();
            String subtypeHistoryStr = this.getSubtypeHistoryStr();
            if (TextUtils.isEmpty(subtypeHistoryStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(subtypeHistoryStr);
            while (this.mInputMethodSplitter.hasNext()) {
                Object nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString((String)nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                Object subtypeId = NOT_A_SUBTYPE_ID_STR;
                Object imeId = this.mSubtypeSplitter.next();
                if (this.mSubtypeSplitter.hasNext()) {
                    subtypeId = this.mSubtypeSplitter.next();
                }
                imsList.add(new Pair<Object, Object>(imeId, subtypeId));
            }
            return imsList;
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSubtypeHistoryStr() {
            String history = this.getString("input_methods_subtype_history", "");
            return history;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedInputMethod(String imeId) {
            this.putString("default_input_method", imeId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedSubtype(int subtypeId) {
            this.putInt("selected_input_method_subtype", subtypeId);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethod() {
            String imi = this.getString("default_input_method", null);
            return imi;
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isSubtypeSelected() {
            return this.getSelectedInputMethodSubtypeHashCode() != -1;
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeHashCode() {
            return this.getInt("selected_input_method_subtype", -1);
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isShowImeWithHardKeyboardEnabled() {
            return this.getBoolean("show_ime_with_hard_keyboard", false);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setShowImeWithHardKeyboard(boolean show) {
            this.putBoolean("show_ime_with_hard_keyboard", show);
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getCurrentUserId() {
            return this.mCurrentUserId;
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeId(String selectedImiId) {
            InputMethodInfo imi = this.mMethodMap.get(selectedImiId);
            if (imi == null) {
                return -1;
            }
            int subtypeHashCode = this.getSelectedInputMethodSubtypeHashCode();
            return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveCurrentInputMethodAndSubtypeToHistory(String curMethodId, InputMethodSubtype currentSubtype) {
            String subtypeId = NOT_A_SUBTYPE_ID_STR;
            if (currentSubtype != null) {
                subtypeId = String.valueOf(currentSubtype.hashCode());
            }
            if (InputMethodUtils.canAddToLastInputMethod(currentSubtype)) {
                this.addSubtypeToHistory(curMethodId, subtypeId);
            }
        }

        private final HashMap<InputMethodInfo, List<InputMethodSubtype>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> enabledInputMethodAndSubtypes = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
            for (InputMethodInfo imi : this.getEnabledInputMethodListLocked()) {
                enabledInputMethodAndSubtypes.put(imi, this.getEnabledInputMethodSubtypeListLocked(context, imi, true));
            }
            return enabledInputMethodAndSubtypes;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$dumpLocked(Printer pw, String prefix) {
            pw.println(prefix + "mCurrentUserId=" + this.mCurrentUserId);
            pw.println(prefix + "mCurrentProfileIds=" + Arrays.toString(this.mCurrentProfileIds));
            pw.println(prefix + "mCopyOnWrite=" + this.mCopyOnWrite);
            pw.println(prefix + "mEnabledInputMethodsStrCache=" + this.mEnabledInputMethodsStrCache);
        }

        private static void buildEnabledInputMethodsSettingString(StringBuilder stringBuilder, Pair<String, ArrayList<String>> pair) {
            InvokeDynamicSupport.bootstrapStatic("buildEnabledInputMethodsSettingString", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildEnabledInputMethodsSettingString(java.lang.StringBuilder android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>> ), 0, (StringBuilder)stringBuilder, pair);
        }

        public static String buildInputMethodsSettingString(List<Pair<String, ArrayList<String>>> list) {
            return InvokeDynamicSupport.bootstrapStatic("buildInputMethodsSettingString", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildInputMethodsSettingString(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> ), 0, list);
        }

        public static List<Pair<String, ArrayList<String>>> buildInputMethodsAndSubtypeList(String string2, TextUtils.SimpleStringSplitter simpleStringSplitter, TextUtils.SimpleStringSplitter simpleStringSplitter2) {
            return InvokeDynamicSupport.bootstrapStatic("buildInputMethodsAndSubtypeList", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildInputMethodsAndSubtypeList(java.lang.String android.text.TextUtils$SimpleStringSplitter android.text.TextUtils$SimpleStringSplitter ), 0, (String)string2, (TextUtils.SimpleStringSplitter)simpleStringSplitter, (TextUtils.SimpleStringSplitter)simpleStringSplitter2);
        }

        private void __constructor__(Resources resources, ContentResolver contentResolver, HashMap<String, InputMethodInfo> hashMap, ArrayList<InputMethodInfo> arrayList, int n, boolean bl) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(resources, contentResolver, hashMap, arrayList, n, bl);
        }

        public InputMethodSettings(Resources resources, ContentResolver contentResolver, HashMap<String, InputMethodInfo> hashMap, ArrayList<InputMethodInfo> arrayList, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(android.content.res.Resources android.content.ContentResolver java.util.HashMap<java.lang.String, android.view.inputmethod.InputMethodInfo> java.util.ArrayList<android.view.inputmethod.InputMethodInfo> int boolean ), 0, this, resources, contentResolver, hashMap, arrayList, n, bl);
        }

        public void switchCurrentUser(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("switchCurrentUser", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$switchCurrentUser(int boolean ), 0, this, n, bl);
        }

        private void putString(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("putString", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putString(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private String getString(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getString(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void putInt(String string2, int n) {
            InvokeDynamicSupport.bootstrap("putInt", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putInt(java.lang.String int ), 0, this, string2, n);
        }

        private int getInt(String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getInt(java.lang.String int ), 0, this, string2, n);
        }

        private void putBoolean(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("putBoolean", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putBoolean(java.lang.String boolean ), 0, this, string2, bl);
        }

        private boolean getBoolean(String string2, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getBoolean(java.lang.String boolean ), 0, this, string2, bl);
        }

        public void setCurrentProfileIds(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setCurrentProfileIds", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentProfileIds(int[] ), 0, this, nArray);
        }

        public boolean isCurrentProfile(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isCurrentProfile", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isCurrentProfile(int ), 0, this, n);
        }

        public ArrayList<InputMethodInfo> getEnabledInputMethodListLocked() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodListLocked(), 0, this);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo inputMethodInfo, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(android.content.Context android.view.inputmethod.InputMethodInfo boolean ), 0, this, context, inputMethodInfo, bl);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo inputMethodInfo) {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(android.view.inputmethod.InputMethodInfo ), 0, this, inputMethodInfo);
        }

        public List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodsAndSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsAndSubtypeListLocked(), 0, this);
        }

        public void appendAndPutEnabledInputMethodLocked(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("appendAndPutEnabledInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$appendAndPutEnabledInputMethodLocked(java.lang.String boolean ), 0, this, string2, bl);
        }

        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder stringBuilder, List<Pair<String, ArrayList<String>>> list, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("buildAndPutEnabledInputMethodsStrRemovingIdLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildAndPutEnabledInputMethodsStrRemovingIdLocked(java.lang.StringBuilder java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> java.lang.String ), 0, this, stringBuilder, list, string2);
        }

        private ArrayList<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> list) {
            return InvokeDynamicSupport.bootstrap("createEnabledInputMethodListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodListLocked(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> ), 0, this, list);
        }

        private void putEnabledInputMethodsStr(String string2) {
            InvokeDynamicSupport.bootstrap("putEnabledInputMethodsStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putEnabledInputMethodsStr(java.lang.String ), 0, this, string2);
        }

        public String getEnabledInputMethodsStr() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodsStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsStr(), 0, this);
        }

        private void saveSubtypeHistory(List<Pair<String, String>> list, String string2, String string3) {
            InvokeDynamicSupport.bootstrap("saveSubtypeHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveSubtypeHistory(java.util.List<android.util.Pair<java.lang.String, java.lang.String>> java.lang.String java.lang.String ), 0, this, list, string2, string3);
        }

        private void addSubtypeToHistory(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("addSubtypeToHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$addSubtypeToHistory(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void putSubtypeHistoryStr(String string2) {
            InvokeDynamicSupport.bootstrap("putSubtypeHistoryStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSubtypeHistoryStr(java.lang.String ), 0, this, string2);
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return InvokeDynamicSupport.bootstrap("getLastInputMethodAndSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastInputMethodAndSubtypeLocked(), 0, this);
        }

        public String getLastSubtypeForInputMethodLocked(String string2) {
            return InvokeDynamicSupport.bootstrap("getLastSubtypeForInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLocked(java.lang.String ), 0, this, string2);
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String string2) {
            return InvokeDynamicSupport.bootstrap("getLastSubtypeForInputMethodLockedInternal", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLockedInternal(java.lang.String ), 0, this, string2);
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> list, String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> java.lang.String java.lang.String ), 0, this, list, string2, string3);
        }

        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            return InvokeDynamicSupport.bootstrap("loadInputMethodAndSubtypeHistoryLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$loadInputMethodAndSubtypeHistoryLocked(), 0, this);
        }

        private String getSubtypeHistoryStr() {
            return InvokeDynamicSupport.bootstrap("getSubtypeHistoryStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSubtypeHistoryStr(), 0, this);
        }

        public void putSelectedInputMethod(String string2) {
            InvokeDynamicSupport.bootstrap("putSelectedInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedInputMethod(java.lang.String ), 0, this, string2);
        }

        public void putSelectedSubtype(int n) {
            InvokeDynamicSupport.bootstrap("putSelectedSubtype", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedSubtype(int ), 0, this, n);
        }

        public String getSelectedInputMethod() {
            return InvokeDynamicSupport.bootstrap("getSelectedInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethod(), 0, this);
        }

        public boolean isSubtypeSelected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSubtypeSelected", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isSubtypeSelected(), 0, this);
        }

        private int getSelectedInputMethodSubtypeHashCode() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedInputMethodSubtypeHashCode", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeHashCode(), 0, this);
        }

        public boolean isShowImeWithHardKeyboardEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowImeWithHardKeyboardEnabled", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isShowImeWithHardKeyboardEnabled(), 0, this);
        }

        public void setShowImeWithHardKeyboard(boolean bl) {
            InvokeDynamicSupport.bootstrap("setShowImeWithHardKeyboard", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setShowImeWithHardKeyboard(boolean ), 0, this, bl);
        }

        public int getCurrentUserId() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentUserId", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getCurrentUserId(), 0, this);
        }

        public int getSelectedInputMethodSubtypeId(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedInputMethodSubtypeId", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeId(java.lang.String ), 0, this, string2);
        }

        public void saveCurrentInputMethodAndSubtypeToHistory(String string2, InputMethodSubtype inputMethodSubtype) {
            InvokeDynamicSupport.bootstrap("saveCurrentInputMethodAndSubtypeToHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveCurrentInputMethodAndSubtypeToHistory(java.lang.String android.view.inputmethod.InputMethodSubtype ), 0, this, string2, inputMethodSubtype);
        }

        public HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            return InvokeDynamicSupport.bootstrap("getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(android.content.Context ), 0, this, context);
        }

        public void dumpLocked(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("dumpLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$dumpLocked(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        public /* synthetic */ InputMethodSettings() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class InputMethodListBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private LinkedHashSet<InputMethodInfo> mInputMethodSet;

        private void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$__constructor__() {
            this.mInputMethodSet = new LinkedHashSet();
        }

        private final InputMethodListBuilder $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$fillImes(ArrayList<InputMethodInfo> imis, Context context, boolean checkDefaultAttribute, Locale locale, boolean checkCountry, String requiredSubtypeMode) {
            for (int i = 0; i < imis.size(); ++i) {
                InputMethodInfo imi = imis.get(i);
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imi, context, checkDefaultAttribute, locale, checkCountry, requiredSubtypeMode)) continue;
                this.mInputMethodSet.add(imi);
            }
            return this;
        }

        private final InputMethodListBuilder $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$fillAuxiliaryImes(ArrayList<InputMethodInfo> imis, Context context) {
            InputMethodInfo imi;
            int i;
            for (InputMethodInfo imi2 : this.mInputMethodSet) {
                if (!imi2.isAuxiliaryIme()) continue;
                return this;
            }
            boolean added = false;
            for (i = 0; i < imis.size(); ++i) {
                imi = imis.get(i);
                if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(imi, context, true)) continue;
                this.mInputMethodSet.add(imi);
                added = true;
            }
            if (added) {
                return this;
            }
            for (i = 0; i < imis.size(); ++i) {
                imi = imis.get(i);
                if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(imi, context, false)) continue;
                this.mInputMethodSet.add(imi);
            }
            return this;
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$isEmpty() {
            return this.mInputMethodSet.isEmpty();
        }

        private final ArrayList<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$build() {
            return new ArrayList<InputMethodInfo>(this.mInputMethodSet);
        }

        private /* synthetic */ void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$__constructor__();
        }

        private InputMethodListBuilder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$__constructor__(), 0, this);
        }

        public InputMethodListBuilder fillImes(ArrayList<InputMethodInfo> arrayList, Context context, boolean bl, Locale locale, boolean bl2, String string2) {
            return InvokeDynamicSupport.bootstrap("fillImes", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$fillImes(java.util.ArrayList<android.view.inputmethod.InputMethodInfo> android.content.Context boolean java.util.Locale boolean java.lang.String ), 0, this, arrayList, context, bl, locale, bl2, string2);
        }

        public InputMethodListBuilder fillAuxiliaryImes(ArrayList<InputMethodInfo> arrayList, Context context) {
            return InvokeDynamicSupport.bootstrap("fillAuxiliaryImes", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$fillAuxiliaryImes(java.util.ArrayList<android.view.inputmethod.InputMethodInfo> android.content.Context ), 0, this, arrayList, context);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$isEmpty(), 0, this);
        }

        public ArrayList<InputMethodInfo> build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$build(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodListBuilder$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodListBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

