/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Target
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float TARGET_DARK_LUMA = 0.26f;
    private static float MAX_DARK_LUMA = 0.45f;
    private static float MIN_LIGHT_LUMA = 0.55f;
    private static float TARGET_LIGHT_LUMA = 0.74f;
    private static float MIN_NORMAL_LUMA = 0.3f;
    private static float TARGET_NORMAL_LUMA = 0.5f;
    private static float MAX_NORMAL_LUMA = 0.7f;
    private static float TARGET_MUTED_SATURATION = 0.3f;
    private static float MAX_MUTED_SATURATION = 0.4f;
    private static float TARGET_VIBRANT_SATURATION = 1.0f;
    private static float MIN_VIBRANT_SATURATION = 0.35f;
    private static float WEIGHT_SATURATION = 0.24f;
    private static float WEIGHT_LUMA = 0.52f;
    private static float WEIGHT_POPULATION = 0.24f;
    static int INDEX_MIN = 0;
    static int INDEX_TARGET = 1;
    static int INDEX_MAX = 2;
    static int INDEX_WEIGHT_SAT = 0;
    static int INDEX_WEIGHT_LUMA = 1;
    static int INDEX_WEIGHT_POP = 2;
    public static Target LIGHT_VIBRANT;
    public static Target VIBRANT;
    public static Target DARK_VIBRANT;
    public static Target LIGHT_MUTED;
    public static Target MUTED;
    public static Target DARK_MUTED;
    float[] mSaturationTargets;
    float[] mLightnessTargets;
    float[] mWeights;
    boolean mIsExclusive;

    private void $$robo$$com_android_internal_graphics_palette_Target$__constructor__() {
        this.mSaturationTargets = new float[3];
        this.mLightnessTargets = new float[3];
        this.mWeights = new float[3];
        this.mIsExclusive = true;
        Target.setTargetDefaultValues(this.mSaturationTargets);
        Target.setTargetDefaultValues(this.mLightnessTargets);
        this.setDefaultWeights();
    }

    private void $$robo$$com_android_internal_graphics_palette_Target$__constructor__(Target from) {
        this.mSaturationTargets = new float[3];
        this.mLightnessTargets = new float[3];
        this.mWeights = new float[3];
        this.mIsExclusive = true;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])from.mSaturationTargets, (int)0, (float[])this.mSaturationTargets, (int)0, (int)this.mSaturationTargets.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])from.mLightnessTargets, (int)0, (float[])this.mLightnessTargets, (int)0, (int)this.mLightnessTargets.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])from.mWeights, (int)0, (float[])this.mWeights, (int)0, (int)this.mWeights.length);
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getMinimumSaturation() {
        return this.mSaturationTargets[0];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getTargetSaturation() {
        return this.mSaturationTargets[1];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getMaximumSaturation() {
        return this.mSaturationTargets[2];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getMinimumLightness() {
        return this.mLightnessTargets[0];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getTargetLightness() {
        return this.mLightnessTargets[1];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getMaximumLightness() {
        return this.mLightnessTargets[2];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getSaturationWeight() {
        return this.mWeights[0];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getLightnessWeight() {
        return this.mWeights[1];
    }

    private final float $$robo$$com_android_internal_graphics_palette_Target$getPopulationWeight() {
        return this.mWeights[2];
    }

    private final boolean $$robo$$com_android_internal_graphics_palette_Target$isExclusive() {
        return this.mIsExclusive;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setTargetDefaultValues(float[] values) {
        values[0] = 0.0f;
        values[1] = 0.5f;
        values[2] = 1.0f;
    }

    private final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultWeights() {
        this.mWeights[0] = 0.24f;
        this.mWeights[1] = 0.52f;
        this.mWeights[2] = 0.24f;
    }

    private final void $$robo$$com_android_internal_graphics_palette_Target$normalizeWeights() {
        float sum = 0.0f;
        for (float weight : this.mWeights) {
            if (!(weight > 0.0f)) continue;
            sum += weight;
        }
        if (sum != 0.0f) {
            int z = this.mWeights.length;
            for (int i = 0; i < z; ++i) {
                if (!(this.mWeights[i] > 0.0f)) continue;
                int n = i;
                this.mWeights[n] = this.mWeights[n] / sum;
            }
        }
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultDarkLightnessValues(Target target) {
        target.mLightnessTargets[1] = 0.26f;
        target.mLightnessTargets[2] = 0.45f;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultNormalLightnessValues(Target target) {
        target.mLightnessTargets[0] = 0.3f;
        target.mLightnessTargets[1] = 0.5f;
        target.mLightnessTargets[2] = 0.7f;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultLightLightnessValues(Target target) {
        target.mLightnessTargets[0] = 0.55f;
        target.mLightnessTargets[1] = 0.74f;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultVibrantSaturationValues(Target target) {
        target.mSaturationTargets[0] = 0.35f;
        target.mSaturationTargets[1] = 1.0f;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_Target$setDefaultMutedSaturationValues(Target target) {
        target.mSaturationTargets[1] = 0.3f;
        target.mSaturationTargets[2] = 0.4f;
    }

    static void __staticInitializer__() {
        LIGHT_VIBRANT = new Target();
        Target.setDefaultLightLightnessValues(LIGHT_VIBRANT);
        Target.setDefaultVibrantSaturationValues(LIGHT_VIBRANT);
        VIBRANT = new Target();
        Target.setDefaultNormalLightnessValues(VIBRANT);
        Target.setDefaultVibrantSaturationValues(VIBRANT);
        DARK_VIBRANT = new Target();
        Target.setDefaultDarkLightnessValues(DARK_VIBRANT);
        Target.setDefaultVibrantSaturationValues(DARK_VIBRANT);
        LIGHT_MUTED = new Target();
        Target.setDefaultLightLightnessValues(LIGHT_MUTED);
        Target.setDefaultMutedSaturationValues(LIGHT_MUTED);
        MUTED = new Target();
        Target.setDefaultNormalLightnessValues(MUTED);
        Target.setDefaultMutedSaturationValues(MUTED);
        DARK_MUTED = new Target();
        Target.setDefaultDarkLightnessValues(DARK_MUTED);
        Target.setDefaultMutedSaturationValues(DARK_MUTED);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_graphics_palette_Target$__constructor__();
    }

    Target() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Target$__constructor__(), 0, this);
    }

    private void __constructor__(Target target) {
        this.$$robo$$com_android_internal_graphics_palette_Target$__constructor__(target);
    }

    Target(Target target) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Target$__constructor__(com.android.internal.graphics.palette.Target ), 0, this, target);
    }

    public float getMinimumSaturation() {
        return (float)InvokeDynamicSupport.bootstrap("getMinimumSaturation", $$robo$$com_android_internal_graphics_palette_Target$getMinimumSaturation(), 0, this);
    }

    public float getTargetSaturation() {
        return (float)InvokeDynamicSupport.bootstrap("getTargetSaturation", $$robo$$com_android_internal_graphics_palette_Target$getTargetSaturation(), 0, this);
    }

    public float getMaximumSaturation() {
        return (float)InvokeDynamicSupport.bootstrap("getMaximumSaturation", $$robo$$com_android_internal_graphics_palette_Target$getMaximumSaturation(), 0, this);
    }

    public float getMinimumLightness() {
        return (float)InvokeDynamicSupport.bootstrap("getMinimumLightness", $$robo$$com_android_internal_graphics_palette_Target$getMinimumLightness(), 0, this);
    }

    public float getTargetLightness() {
        return (float)InvokeDynamicSupport.bootstrap("getTargetLightness", $$robo$$com_android_internal_graphics_palette_Target$getTargetLightness(), 0, this);
    }

    public float getMaximumLightness() {
        return (float)InvokeDynamicSupport.bootstrap("getMaximumLightness", $$robo$$com_android_internal_graphics_palette_Target$getMaximumLightness(), 0, this);
    }

    public float getSaturationWeight() {
        return (float)InvokeDynamicSupport.bootstrap("getSaturationWeight", $$robo$$com_android_internal_graphics_palette_Target$getSaturationWeight(), 0, this);
    }

    public float getLightnessWeight() {
        return (float)InvokeDynamicSupport.bootstrap("getLightnessWeight", $$robo$$com_android_internal_graphics_palette_Target$getLightnessWeight(), 0, this);
    }

    public float getPopulationWeight() {
        return (float)InvokeDynamicSupport.bootstrap("getPopulationWeight", $$robo$$com_android_internal_graphics_palette_Target$getPopulationWeight(), 0, this);
    }

    public boolean isExclusive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExclusive", $$robo$$com_android_internal_graphics_palette_Target$isExclusive(), 0, this);
    }

    private static void setTargetDefaultValues(float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("setTargetDefaultValues", $$robo$$com_android_internal_graphics_palette_Target$setTargetDefaultValues(float[] ), 0, (float[])fArray);
    }

    private void setDefaultWeights() {
        InvokeDynamicSupport.bootstrap("setDefaultWeights", $$robo$$com_android_internal_graphics_palette_Target$setDefaultWeights(), 0, this);
    }

    void normalizeWeights() {
        InvokeDynamicSupport.bootstrap("normalizeWeights", $$robo$$com_android_internal_graphics_palette_Target$normalizeWeights(), 0, this);
    }

    private static void setDefaultDarkLightnessValues(Target target) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultDarkLightnessValues", $$robo$$com_android_internal_graphics_palette_Target$setDefaultDarkLightnessValues(com.android.internal.graphics.palette.Target ), 0, (Target)target);
    }

    private static void setDefaultNormalLightnessValues(Target target) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultNormalLightnessValues", $$robo$$com_android_internal_graphics_palette_Target$setDefaultNormalLightnessValues(com.android.internal.graphics.palette.Target ), 0, (Target)target);
    }

    private static void setDefaultLightLightnessValues(Target target) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultLightLightnessValues", $$robo$$com_android_internal_graphics_palette_Target$setDefaultLightLightnessValues(com.android.internal.graphics.palette.Target ), 0, (Target)target);
    }

    private static void setDefaultVibrantSaturationValues(Target target) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultVibrantSaturationValues", $$robo$$com_android_internal_graphics_palette_Target$setDefaultVibrantSaturationValues(com.android.internal.graphics.palette.Target ), 0, (Target)target);
    }

    private static void setDefaultMutedSaturationValues(Target target) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultMutedSaturationValues", $$robo$$com_android_internal_graphics_palette_Target$setDefaultMutedSaturationValues(com.android.internal.graphics.palette.Target ), 0, (Target)target);
    }

    static {
        RobolectricInternals.classInitializing(Target.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Target)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Target mTarget;

        private void $$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__() {
            this.mTarget = new Target();
        }

        private void $$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__(Target target) {
            this.mTarget = new Target(target);
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setMinimumSaturation(float value) {
            this.mTarget.mSaturationTargets[0] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setTargetSaturation(float value) {
            this.mTarget.mSaturationTargets[1] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setMaximumSaturation(float value) {
            this.mTarget.mSaturationTargets[2] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setMinimumLightness(float value) {
            this.mTarget.mLightnessTargets[0] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setTargetLightness(float value) {
            this.mTarget.mLightnessTargets[1] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setMaximumLightness(float value) {
            this.mTarget.mLightnessTargets[2] = value;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setSaturationWeight(float weight) {
            this.mTarget.mWeights[0] = weight;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setLightnessWeight(float weight) {
            this.mTarget.mWeights[1] = weight;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setPopulationWeight(float weight) {
            this.mTarget.mWeights[2] = weight;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Target_Builder$setExclusive(boolean exclusive) {
            this.mTarget.mIsExclusive = exclusive;
            return this;
        }

        private final Target $$robo$$com_android_internal_graphics_palette_Target_Builder$build() {
            return this.mTarget;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(Target target) {
            this.$$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__(target);
        }

        public Builder(Target target) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Target_Builder$__constructor__(com.android.internal.graphics.palette.Target ), 0, this, target);
        }

        public Builder setMinimumSaturation(float f) {
            return InvokeDynamicSupport.bootstrap("setMinimumSaturation", $$robo$$com_android_internal_graphics_palette_Target_Builder$setMinimumSaturation(float ), 0, this, f);
        }

        public Builder setTargetSaturation(float f) {
            return InvokeDynamicSupport.bootstrap("setTargetSaturation", $$robo$$com_android_internal_graphics_palette_Target_Builder$setTargetSaturation(float ), 0, this, f);
        }

        public Builder setMaximumSaturation(float f) {
            return InvokeDynamicSupport.bootstrap("setMaximumSaturation", $$robo$$com_android_internal_graphics_palette_Target_Builder$setMaximumSaturation(float ), 0, this, f);
        }

        public Builder setMinimumLightness(float f) {
            return InvokeDynamicSupport.bootstrap("setMinimumLightness", $$robo$$com_android_internal_graphics_palette_Target_Builder$setMinimumLightness(float ), 0, this, f);
        }

        public Builder setTargetLightness(float f) {
            return InvokeDynamicSupport.bootstrap("setTargetLightness", $$robo$$com_android_internal_graphics_palette_Target_Builder$setTargetLightness(float ), 0, this, f);
        }

        public Builder setMaximumLightness(float f) {
            return InvokeDynamicSupport.bootstrap("setMaximumLightness", $$robo$$com_android_internal_graphics_palette_Target_Builder$setMaximumLightness(float ), 0, this, f);
        }

        public Builder setSaturationWeight(float f) {
            return InvokeDynamicSupport.bootstrap("setSaturationWeight", $$robo$$com_android_internal_graphics_palette_Target_Builder$setSaturationWeight(float ), 0, this, f);
        }

        public Builder setLightnessWeight(float f) {
            return InvokeDynamicSupport.bootstrap("setLightnessWeight", $$robo$$com_android_internal_graphics_palette_Target_Builder$setLightnessWeight(float ), 0, this, f);
        }

        public Builder setPopulationWeight(float f) {
            return InvokeDynamicSupport.bootstrap("setPopulationWeight", $$robo$$com_android_internal_graphics_palette_Target_Builder$setPopulationWeight(float ), 0, this, f);
        }

        public Builder setExclusive(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setExclusive", $$robo$$com_android_internal_graphics_palette_Target_Builder$setExclusive(boolean ), 0, this, bl);
        }

        public Target build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$com_android_internal_graphics_palette_Target_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

