/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.SparseMappingTable;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ServiceState
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ProcessStats";
    private static boolean DEBUG = false;
    public static int SERVICE_RUN = 0;
    public static int SERVICE_STARTED = 1;
    public static int SERVICE_BOUND = 2;
    public static int SERVICE_EXEC = 3;
    public static int SERVICE_COUNT = 4;
    private String mPackage;
    private String mProcessName;
    private String mName;
    private DurationsTable mDurations;
    private ProcessState mProc;
    private Object mOwner;
    private int mRunCount;
    private int mRunState;
    private long mRunStartTime;
    private boolean mStarted;
    private boolean mRestarting;
    private int mStartedCount;
    private int mStartedState;
    private long mStartedStartTime;
    private int mBoundCount;
    private int mBoundState;
    private long mBoundStartTime;
    private int mExecCount;
    private int mExecState;
    private long mExecStartTime;

    private void $$robo$$com_android_internal_app_procstats_ServiceState$__constructor__(ProcessStats processStats, String pkg, String name, String processName, ProcessState proc) {
        this.mRunState = -1;
        this.mStartedState = -1;
        this.mBoundState = -1;
        this.mExecState = -1;
        this.mPackage = pkg;
        this.mName = name;
        this.mProcessName = processName;
        this.mProc = proc;
        this.mDurations = new DurationsTable(processStats.mTableData);
    }

    private final String $$robo$$com_android_internal_app_procstats_ServiceState$getPackage() {
        return this.mPackage;
    }

    private final String $$robo$$com_android_internal_app_procstats_ServiceState$getProcessName() {
        return this.mProcessName;
    }

    private final String $$robo$$com_android_internal_app_procstats_ServiceState$getName() {
        return this.mName;
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ServiceState$getProcess() {
        return this.mProc;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setProcess(ProcessState proc) {
        this.mProc = proc;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setMemFactor(int memFactor, long now) {
        if (this.isRestarting()) {
            this.setRestarting(true, memFactor, now);
        } else if (this.isInUse()) {
            if (this.mStartedState != -1) {
                this.setStarted(true, memFactor, now);
            }
            if (this.mBoundState != -1) {
                this.setBound(true, memFactor, now);
            }
            if (this.mExecState != -1) {
                this.setExecuting(true, memFactor, now);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$applyNewOwner(Object newOwner) {
        if (this.mOwner != newOwner) {
            if (this.mOwner == null) {
                this.mOwner = newOwner;
                this.mProc.incActiveServices(this.mName);
            } else {
                this.mOwner = newOwner;
                if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1) {
                    long now = SystemClock.uptimeMillis();
                    if (this.mStarted) {
                        this.setStarted(false, 0, now);
                    }
                    if (this.mBoundState != -1) {
                        this.setBound(false, 0, now);
                    }
                    if (this.mExecState != -1) {
                        this.setExecuting(false, 0, now);
                    }
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$clearCurrentOwner(Object owner, boolean silently) {
        if (this.mOwner == owner) {
            this.mProc.decActiveServices(this.mName);
            if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1) {
                long now = SystemClock.uptimeMillis();
                if (this.mStarted) {
                    if (!silently) {
                        Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while started: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setStarted(false, 0, now);
                }
                if (this.mBoundState != -1) {
                    if (!silently) {
                        Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while bound: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setBound(false, 0, now);
                }
                if (this.mExecState != -1) {
                    if (!silently) {
                        Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while exec: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setExecuting(false, 0, now);
                }
            }
            this.mOwner = null;
        }
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ServiceState$isInUse() {
        return this.mOwner != null || this.mRestarting;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ServiceState$isRestarting() {
        return this.mRestarting;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$add(ServiceState other) {
        this.mDurations.addDurations(other.mDurations);
        this.mRunCount += other.mRunCount;
        this.mStartedCount += other.mStartedCount;
        this.mBoundCount += other.mBoundCount;
        this.mExecCount += other.mExecCount;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$resetSafely(long now) {
        this.mDurations.resetTable();
        this.mRunCount = this.mRunState != -1 ? 1 : 0;
        this.mStartedCount = this.mStartedState != -1 ? 1 : 0;
        this.mBoundCount = this.mBoundState != -1 ? 1 : 0;
        this.mExecCount = this.mExecState != -1 ? 1 : 0;
        this.mBoundStartTime = this.mExecStartTime = now;
        this.mStartedStartTime = this.mExecStartTime;
        this.mRunStartTime = this.mExecStartTime;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$writeToParcel(Parcel out, long now) {
        this.mDurations.writeToParcel(out);
        out.writeInt(this.mRunCount);
        out.writeInt(this.mStartedCount);
        out.writeInt(this.mBoundCount);
        out.writeInt(this.mExecCount);
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ServiceState$readFromParcel(Parcel in) {
        if (!this.mDurations.readFromParcel(in)) {
            return false;
        }
        this.mRunCount = in.readInt();
        this.mStartedCount = in.readInt();
        this.mBoundCount = in.readInt();
        this.mExecCount = in.readInt();
        return true;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$commitStateTime(long now) {
        if (this.mRunState != -1) {
            this.mDurations.addDuration(0 + this.mRunState * 4, now - this.mRunStartTime);
            this.mRunStartTime = now;
        }
        if (this.mStartedState != -1) {
            this.mDurations.addDuration(1 + this.mStartedState * 4, now - this.mStartedStartTime);
            this.mStartedStartTime = now;
        }
        if (this.mBoundState != -1) {
            this.mDurations.addDuration(2 + this.mBoundState * 4, now - this.mBoundStartTime);
            this.mBoundStartTime = now;
        }
        if (this.mExecState != -1) {
            this.mDurations.addDuration(3 + this.mExecState * 4, now - this.mExecStartTime);
            this.mExecStartTime = now;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$updateRunning(int memFactor, long now) {
        int state;
        int n = state = this.mStartedState != -1 || this.mBoundState != -1 || this.mExecState != -1 ? memFactor : -1;
        if (this.mRunState != state) {
            if (this.mRunState != -1) {
                this.mDurations.addDuration(0 + this.mRunState * 4, now - this.mRunStartTime);
            } else if (state != -1) {
                ++this.mRunCount;
            }
            this.mRunState = state;
            this.mRunStartTime = now;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setStarted(boolean started, int memFactor, long now) {
        if (this.mOwner == null) {
            Slog.wtf("ProcessStats", "Starting service " + this + " without owner");
        }
        this.mStarted = started;
        this.updateStartedState(memFactor, now);
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setRestarting(boolean restarting, int memFactor, long now) {
        this.mRestarting = restarting;
        this.updateStartedState(memFactor, now);
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$updateStartedState(int memFactor, long now) {
        int state;
        boolean wasStarted = this.mStartedState != -1;
        boolean started = this.mStarted || this.mRestarting;
        int n = state = started ? memFactor : -1;
        if (this.mStartedState != state) {
            if (this.mStartedState != -1) {
                this.mDurations.addDuration(1 + this.mStartedState * 4, now - this.mStartedStartTime);
            } else if (started) {
                ++this.mStartedCount;
            }
            this.mStartedState = state;
            this.mStartedStartTime = now;
            this.mProc = this.mProc.pullFixedProc(this.mPackage);
            if (wasStarted != started) {
                if (started) {
                    this.mProc.incStartedServices(memFactor, now, this.mName);
                } else {
                    this.mProc.decStartedServices(memFactor, now, this.mName);
                }
            }
            this.updateRunning(memFactor, now);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setBound(boolean bound, int memFactor, long now) {
        int state;
        if (this.mOwner == null) {
            Slog.wtf("ProcessStats", "Binding service " + this + " without owner");
        }
        int n = state = bound ? memFactor : -1;
        if (this.mBoundState != state) {
            if (this.mBoundState != -1) {
                this.mDurations.addDuration(2 + this.mBoundState * 4, now - this.mBoundStartTime);
            } else if (bound) {
                ++this.mBoundCount;
            }
            this.mBoundState = state;
            this.mBoundStartTime = now;
            this.updateRunning(memFactor, now);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$setExecuting(boolean executing, int memFactor, long now) {
        int state;
        if (this.mOwner == null) {
            Slog.wtf("ProcessStats", "Executing service " + this + " without owner");
        }
        int n = state = executing ? memFactor : -1;
        if (this.mExecState != state) {
            if (this.mExecState != -1) {
                this.mDurations.addDuration(3 + this.mExecState * 4, now - this.mExecStartTime);
            } else if (executing) {
                ++this.mExecCount;
            }
            this.mExecState = state;
            this.mExecStartTime = now;
            this.updateRunning(memFactor, now);
        }
    }

    private final long $$robo$$com_android_internal_app_procstats_ServiceState$getDuration(int opType, int curState, long startTime, int memFactor, long now) {
        int state = opType + memFactor * 4;
        long time = this.mDurations.getValueForId((byte)state);
        if (curState == memFactor) {
            time += now - startTime;
        }
        return time;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$dumpStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, long now, long totalTime, boolean dumpSummary, boolean dumpAll) {
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Running", this.mRunCount, 0, this.mRunState, this.mRunStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Started", this.mStartedCount, 1, this.mStartedState, this.mStartedStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Bound", this.mBoundCount, 2, this.mBoundState, this.mBoundStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Executing", this.mExecCount, 3, this.mExecState, this.mExecStartTime, now, totalTime, !dumpSummary || dumpAll);
        if (dumpAll) {
            if (this.mOwner != null) {
                pw.print("        mOwner=");
                pw.println(this.mOwner);
            }
            if (this.mStarted || this.mRestarting) {
                pw.print("        mStarted=");
                pw.print(this.mStarted);
                pw.print(" mRestarting=");
                pw.println(this.mRestarting);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$dumpStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, String header, int count, int serviceType, int state, long startTime, long now, long totalTime, boolean dumpAll) {
        if (count != 0) {
            if (dumpAll) {
                pw.print(prefix);
                pw.print(header);
                pw.print(" op count ");
                pw.print(count);
                pw.println(":");
                this.dumpTime(pw, prefixInner, serviceType, state, startTime, now);
            } else {
                long myTime = this.dumpTime(null, null, serviceType, state, startTime, now);
                pw.print(prefix);
                pw.print(headerPrefix);
                pw.print(header);
                pw.print(" count ");
                pw.print(count);
                pw.print(" / time ");
                DumpUtils.printPercent(pw, (double)myTime / (double)totalTime);
                pw.println();
            }
        }
    }

    private final long $$robo$$com_android_internal_app_procstats_ServiceState$dumpTime(PrintWriter pw, String prefix, int serviceType, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = this.getDuration(serviceType, curState, curStartTime, state, now);
                String running = "";
                if (curState == state && pw != null) {
                    running = " (running)";
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$dumpTimesCheckin(PrintWriter pw, String pkgName, int uid, int vers, String serviceName, long now) {
        this.dumpTimeCheckin(pw, "pkgsvc-run", pkgName, uid, vers, serviceName, 0, this.mRunCount, this.mRunState, this.mRunStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-start", pkgName, uid, vers, serviceName, 1, this.mStartedCount, this.mStartedState, this.mStartedStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-bound", pkgName, uid, vers, serviceName, 2, this.mBoundCount, this.mBoundState, this.mBoundStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-exec", pkgName, uid, vers, serviceName, 3, this.mExecCount, this.mExecState, this.mExecStartTime, now);
    }

    private final void $$robo$$com_android_internal_app_procstats_ServiceState$dumpTimeCheckin(PrintWriter pw, String label, String packageName, int uid, int vers, String serviceName, int serviceType, int opCount, int curState, long curStartTime, long now) {
        if (opCount <= 0) {
            return;
        }
        pw.print(label);
        pw.print(",");
        pw.print(packageName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(serviceName);
        pw.print(",");
        pw.print(opCount);
        boolean didCurState = false;
        int N = this.mDurations.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mDurations.getKeyAt(i);
            long time = this.mDurations.getValue(key);
            int type = SparseMappingTable.getIdFromKey(key);
            int memFactor = type / 4;
            if ((type %= 4) != serviceType) continue;
            if (curState == memFactor) {
                didCurState = true;
                time += now - curStartTime;
            }
            DumpUtils.printAdjTagAndValue(pw, memFactor, time);
        }
        if (!didCurState && curState != -1) {
            DumpUtils.printAdjTagAndValue(pw, curState, now - curStartTime);
        }
        pw.println();
    }

    private final String $$robo$$com_android_internal_app_procstats_ServiceState$toString() {
        return "ServiceState{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " pkg=" + this.mPackage + " proc=" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    private void __constructor__(ProcessStats processStats, String string2, String string3, String string4, ProcessState processState) {
        this.$$robo$$com_android_internal_app_procstats_ServiceState$__constructor__(processStats, string2, string3, string4, processState);
    }

    public ServiceState(ProcessStats processStats, String string2, String string3, String string4, ProcessState processState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ServiceState$__constructor__(com.android.internal.app.procstats.ProcessStats java.lang.String java.lang.String java.lang.String com.android.internal.app.procstats.ProcessState ), 0, this, processStats, string2, string3, string4, processState);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$com_android_internal_app_procstats_ServiceState$getPackage(), 0, this);
    }

    public String getProcessName() {
        return InvokeDynamicSupport.bootstrap("getProcessName", $$robo$$com_android_internal_app_procstats_ServiceState$getProcessName(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$com_android_internal_app_procstats_ServiceState$getName(), 0, this);
    }

    public ProcessState getProcess() {
        return InvokeDynamicSupport.bootstrap("getProcess", $$robo$$com_android_internal_app_procstats_ServiceState$getProcess(), 0, this);
    }

    public void setProcess(ProcessState processState) {
        InvokeDynamicSupport.bootstrap("setProcess", $$robo$$com_android_internal_app_procstats_ServiceState$setProcess(com.android.internal.app.procstats.ProcessState ), 0, this, processState);
    }

    public void setMemFactor(int n, long l) {
        InvokeDynamicSupport.bootstrap("setMemFactor", $$robo$$com_android_internal_app_procstats_ServiceState$setMemFactor(int long ), 0, this, n, l);
    }

    public void applyNewOwner(Object object) {
        InvokeDynamicSupport.bootstrap("applyNewOwner", $$robo$$com_android_internal_app_procstats_ServiceState$applyNewOwner(java.lang.Object ), 0, this, object);
    }

    public void clearCurrentOwner(Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("clearCurrentOwner", $$robo$$com_android_internal_app_procstats_ServiceState$clearCurrentOwner(java.lang.Object boolean ), 0, this, object, bl);
    }

    public boolean isInUse() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInUse", $$robo$$com_android_internal_app_procstats_ServiceState$isInUse(), 0, this);
    }

    public boolean isRestarting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRestarting", $$robo$$com_android_internal_app_procstats_ServiceState$isRestarting(), 0, this);
    }

    public void add(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_procstats_ServiceState$add(com.android.internal.app.procstats.ServiceState ), 0, this, serviceState);
    }

    public void resetSafely(long l) {
        InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_procstats_ServiceState$resetSafely(long ), 0, this, l);
    }

    public void writeToParcel(Parcel parcel, long l) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_ServiceState$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
    }

    public boolean readFromParcel(Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_procstats_ServiceState$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public void commitStateTime(long l) {
        InvokeDynamicSupport.bootstrap("commitStateTime", $$robo$$com_android_internal_app_procstats_ServiceState$commitStateTime(long ), 0, this, l);
    }

    private void updateRunning(int n, long l) {
        InvokeDynamicSupport.bootstrap("updateRunning", $$robo$$com_android_internal_app_procstats_ServiceState$updateRunning(int long ), 0, this, n, l);
    }

    public void setStarted(boolean bl, int n, long l) {
        InvokeDynamicSupport.bootstrap("setStarted", $$robo$$com_android_internal_app_procstats_ServiceState$setStarted(boolean int long ), 0, this, bl, n, l);
    }

    public void setRestarting(boolean bl, int n, long l) {
        InvokeDynamicSupport.bootstrap("setRestarting", $$robo$$com_android_internal_app_procstats_ServiceState$setRestarting(boolean int long ), 0, this, bl, n, l);
    }

    public void updateStartedState(int n, long l) {
        InvokeDynamicSupport.bootstrap("updateStartedState", $$robo$$com_android_internal_app_procstats_ServiceState$updateStartedState(int long ), 0, this, n, l);
    }

    public void setBound(boolean bl, int n, long l) {
        InvokeDynamicSupport.bootstrap("setBound", $$robo$$com_android_internal_app_procstats_ServiceState$setBound(boolean int long ), 0, this, bl, n, l);
    }

    public void setExecuting(boolean bl, int n, long l) {
        InvokeDynamicSupport.bootstrap("setExecuting", $$robo$$com_android_internal_app_procstats_ServiceState$setExecuting(boolean int long ), 0, this, bl, n, l);
    }

    public long getDuration(int n, int n2, long l, int n3, long l2) {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_app_procstats_ServiceState$getDuration(int int long int long ), 0, this, n, n2, l, n3, l2);
    }

    public void dumpStats(PrintWriter printWriter, String string2, String string3, String string4, long l, long l2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("dumpStats", $$robo$$com_android_internal_app_procstats_ServiceState$dumpStats(java.io.PrintWriter java.lang.String java.lang.String java.lang.String long long boolean boolean ), 0, this, printWriter, string2, string3, string4, l, l2, bl, bl2);
    }

    private void dumpStats(PrintWriter printWriter, String string2, String string3, String string4, String string5, int n, int n2, int n3, long l, long l2, long l3, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpStats", $$robo$$com_android_internal_app_procstats_ServiceState$dumpStats(java.io.PrintWriter java.lang.String java.lang.String java.lang.String java.lang.String int int int long long long boolean ), 0, this, printWriter, string2, string3, string4, string5, n, n2, n3, l, l2, l3, bl);
    }

    public long dumpTime(PrintWriter printWriter, String string2, int n, int n2, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrap("dumpTime", $$robo$$com_android_internal_app_procstats_ServiceState$dumpTime(java.io.PrintWriter java.lang.String int int long long ), 0, this, printWriter, string2, n, n2, l, l2);
    }

    public void dumpTimesCheckin(PrintWriter printWriter, String string2, int n, int n2, String string3, long l) {
        InvokeDynamicSupport.bootstrap("dumpTimesCheckin", $$robo$$com_android_internal_app_procstats_ServiceState$dumpTimesCheckin(java.io.PrintWriter java.lang.String int int java.lang.String long ), 0, this, printWriter, string2, n, n2, string3, l);
    }

    private void dumpTimeCheckin(PrintWriter printWriter, String string2, String string3, int n, int n2, String string4, int n3, int n4, int n5, long l, long l2) {
        InvokeDynamicSupport.bootstrap("dumpTimeCheckin", $$robo$$com_android_internal_app_procstats_ServiceState$dumpTimeCheckin(java.io.PrintWriter java.lang.String java.lang.String int int java.lang.String int int int long long ), 0, this, printWriter, string2, string3, n, n2, string4, n3, n4, n5, l, l2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_procstats_ServiceState$toString(), 0, this);
    }

    public /* synthetic */ ServiceState() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

