/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Dialog;
import android.content.Context;
import android.media.MediaRouter;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRouteChooserDialog
extends Dialog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private MediaRouter mRouter;
    private MediaRouterCallback mCallback;
    private int mRouteTypes;
    private View.OnClickListener mExtendedSettingsClickListener;
    private RouteAdapter mAdapter;
    private ListView mListView;
    private Button mExtendedSettingsButton;
    private boolean mAttachedToWindow;

    private void $$robo$$com_android_internal_app_MediaRouteChooserDialog$__constructor__(Context context, int theme) {
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback(this);
    }

    private final int $$robo$$com_android_internal_app_MediaRouteChooserDialog$getRouteTypes() {
        return this.mRouteTypes;
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$setRouteTypes(int types) {
        if (this.mRouteTypes != types) {
            this.mRouteTypes = types;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(types, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$setExtendedSettingsClickListener(View.OnClickListener listener) {
        if (listener != this.mExtendedSettingsClickListener) {
            this.mExtendedSettingsClickListener = listener;
            this.updateExtendedSettingsButton();
        }
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteChooserDialog$onFilterRoute(MediaRouter.RouteInfo route) {
        return !route.isDefault() && route.isEnabled() && route.matchesTypes(this.mRouteTypes);
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(3);
        this.setContentView(17367168);
        this.setTitle(this.mRouteTypes == 4 ? 17040163 : 17040162);
        this.getWindow().setFeatureDrawableResource(3, 17302463);
        this.mAdapter = new RouteAdapter(this, this.getContext());
        this.mListView = (ListView)this.findViewById(16909037);
        this.mListView.setAdapter(this.mAdapter);
        this.mListView.setOnItemClickListener(this.mAdapter);
        this.mListView.setEmptyView((View)this.findViewById(16908292));
        this.mExtendedSettingsButton = (Button)this.findViewById(16909036);
        this.updateExtendedSettingsButton();
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$updateExtendedSettingsButton() {
        if (this.mExtendedSettingsButton != null) {
            this.mExtendedSettingsButton.setOnClickListener(this.mExtendedSettingsClickListener);
            this.mExtendedSettingsButton.setVisibility(this.mExtendedSettingsClickListener != null ? 0 : 8);
        }
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 1);
        this.refreshRoutes();
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        super.onDetachedFromWindow();
    }

    private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog$refreshRoutes() {
        if (this.mAttachedToWindow) {
            this.mAdapter.update();
        }
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$com_android_internal_app_MediaRouteChooserDialog$__constructor__(context, n);
    }

    public MediaRouteChooserDialog(Context context, int n) {
        super(context, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteChooserDialog$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public int getRouteTypes() {
        return (int)InvokeDynamicSupport.bootstrap("getRouteTypes", $$robo$$com_android_internal_app_MediaRouteChooserDialog$getRouteTypes(), 0, this);
    }

    public void setRouteTypes(int n) {
        InvokeDynamicSupport.bootstrap("setRouteTypes", $$robo$$com_android_internal_app_MediaRouteChooserDialog$setRouteTypes(int ), 0, this, n);
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        InvokeDynamicSupport.bootstrap("setExtendedSettingsClickListener", $$robo$$com_android_internal_app_MediaRouteChooserDialog$setExtendedSettingsClickListener(android.view.View$OnClickListener ), 0, this, onClickListener);
    }

    public boolean onFilterRoute(MediaRouter.RouteInfo routeInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("onFilterRoute", $$robo$$com_android_internal_app_MediaRouteChooserDialog$onFilterRoute(android.media.MediaRouter$RouteInfo ), 0, this, routeInfo);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_MediaRouteChooserDialog$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private void updateExtendedSettingsButton() {
        InvokeDynamicSupport.bootstrap("updateExtendedSettingsButton", $$robo$$com_android_internal_app_MediaRouteChooserDialog$updateExtendedSettingsButton(), 0, this);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_app_MediaRouteChooserDialog$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_app_MediaRouteChooserDialog$onDetachedFromWindow(), 0, this);
    }

    public void refreshRoutes() {
        InvokeDynamicSupport.bootstrap("refreshRoutes", $$robo$$com_android_internal_app_MediaRouteChooserDialog$refreshRoutes(), 0, this);
    }

    public /* synthetic */ MediaRouteChooserDialog() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouteChooserDialog)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public static RouteComparator sInstance;

        private void $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteComparator$__constructor__() {
        }

        private final int $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteComparator$compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            return lhs.getName().toString().compareTo(rhs.getName().toString());
        }

        static void __staticInitializer__() {
            sInstance = new RouteComparator();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteComparator$__constructor__();
        }

        private RouteComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(MediaRouter.RouteInfo routeInfo, MediaRouter.RouteInfo routeInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteComparator$compare(android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteInfo ), 0, this, routeInfo, routeInfo2);
        }

        static {
            RobolectricInternals.classInitializing(RouteComparator.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaRouteChooserDialog this$0;

        private void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$__constructor__(MediaRouteChooserDialog mediaRouteChooserDialog) {
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoutes();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoutes();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoutes();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            this.this$0.dismiss();
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$__constructor__(MediaRouteChooserDialog x0, 1 x1) {
        }

        private void __constructor__(MediaRouteChooserDialog mediaRouteChooserDialog) {
            this.$$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$__constructor__(mediaRouteChooserDialog);
        }

        private MediaRouterCallback(MediaRouteChooserDialog mediaRouteChooserDialog) {
            this.this$0 = mediaRouteChooserDialog;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$__constructor__(com.android.internal.app.MediaRouteChooserDialog ), 0, this, mediaRouteChooserDialog);
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteAdded", $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteAdded(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteRemoved", $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteRemoved(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteChanged", $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteSelected", $$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$onRouteSelected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, n, routeInfo);
        }

        private /* synthetic */ void __constructor__(MediaRouteChooserDialog mediaRouteChooserDialog, 1 var2_2) {
            this.$$robo$$com_android_internal_app_MediaRouteChooserDialog_MediaRouterCallback$__constructor__(mediaRouteChooserDialog, var2_2);
        }

        public /* synthetic */ MediaRouterCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class RouteAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo>
    implements AdapterView.OnItemClickListener {
        public transient /* synthetic */ Object __robo_data__;
        private LayoutInflater mInflater;
        /* synthetic */ MediaRouteChooserDialog this$0;

        private void $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$__constructor__(MediaRouteChooserDialog mediaRouteChooserDialog, Context context) {
            this.mInflater = LayoutInflater.from(context);
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$update() {
            this.clear();
            int count = this.this$0.mRouter.getRouteCount();
            for (int i = 0; i < count; ++i) {
                MediaRouter.RouteInfo route = this.this$0.mRouter.getRouteAt(i);
                if (!this.this$0.onFilterRoute(route)) continue;
                this.add(route);
            }
            this.sort(RouteComparator.sInstance);
            this.notifyDataSetChanged();
        }

        private final boolean $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$areAllItemsEnabled() {
            return false;
        }

        private final boolean $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$isEnabled(int position) {
            return ((MediaRouter.RouteInfo)this.getItem(position)).isEnabled();
        }

        private final View $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(17367170, parent, false);
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            TextView text1 = (TextView)view.findViewById(16908308);
            TextView text2 = (TextView)view.findViewById(16908309);
            text1.setText(route.getName());
            CharSequence description = route.getDescription();
            if (TextUtils.isEmpty(description)) {
                text2.setVisibility(8);
                text2.setText("");
            } else {
                text2.setVisibility(0);
                text2.setText(description);
            }
            view.setEnabled(route.isEnabled());
            return view;
        }

        private final void $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            if (route.isEnabled()) {
                route.select();
                this.this$0.dismiss();
            }
        }

        private void __constructor__(MediaRouteChooserDialog mediaRouteChooserDialog, Context context) {
            this.$$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$__constructor__(mediaRouteChooserDialog, context);
        }

        public RouteAdapter(MediaRouteChooserDialog mediaRouteChooserDialog, Context context) {
            this.this$0 = mediaRouteChooserDialog;
            super(context, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$__constructor__(com.android.internal.app.MediaRouteChooserDialog android.content.Context ), 0, this, mediaRouteChooserDialog, context);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$update(), 0, this);
        }

        @Override
        public boolean areAllItemsEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("areAllItemsEnabled", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$areAllItemsEnabled(), 0, this);
        }

        @Override
        public boolean isEnabled(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$isEnabled(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        @Override
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_MediaRouteChooserDialog_RouteAdapter$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        public /* synthetic */ RouteAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

