/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.os.RemoteException;
import android.telephony.Rlog;
import com.android.ims.ImsEcbmStateListener;
import com.android.ims.ImsException;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsEcbmListener;

public class ImsEcbm {
    private static final String TAG = "ImsEcbm";
    private static final boolean DBG = true;
    private final IImsEcbm miEcbm;

    public ImsEcbm(IImsEcbm iEcbm) {
        Rlog.d(TAG, "ImsEcbm created");
        this.miEcbm = iEcbm;
    }

    public void setEcbmStateListener(ImsEcbmStateListener ecbmListener) throws ImsException {
        try {
            this.miEcbm.setListener(new ImsEcbmListenerProxy(ecbmListener));
        }
        catch (RemoteException e) {
            throw new ImsException("setEcbmStateListener()", e, 106);
        }
    }

    public void exitEmergencyCallbackMode() throws ImsException {
        try {
            this.miEcbm.exitEmergencyCallbackMode();
        }
        catch (RemoteException e) {
            throw new ImsException("exitEmergencyCallbackMode()", e, 106);
        }
    }

    private class ImsEcbmListenerProxy
    extends IImsEcbmListener.Stub {
        private ImsEcbmStateListener mListener;

        public ImsEcbmListenerProxy(ImsEcbmStateListener listener) {
            this.mListener = listener;
        }

        @Override
        public void enteredECBM() {
            Rlog.d(ImsEcbm.TAG, "enteredECBM ::");
            if (this.mListener != null) {
                this.mListener.onECBMEntered();
            }
        }

        @Override
        public void exitedECBM() {
            Rlog.d(ImsEcbm.TAG, "exitedECBM ::");
            if (this.mListener != null) {
                this.mListener.onECBMExited();
            }
        }
    }
}

