/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ViewAnimator
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    int mWhichChild;
    boolean mFirstTime;
    boolean mAnimateFirstTime;
    Animation mInAnimation;
    Animation mOutAnimation;

    private void $$robo$$android_widget_ViewAnimator$__constructor__(Context context) {
        this.mWhichChild = 0;
        this.mFirstTime = true;
        this.mAnimateFirstTime = true;
        this.initViewAnimator(context, null);
    }

    private void $$robo$$android_widget_ViewAnimator$__constructor__(Context context, AttributeSet attrs) {
        this.mWhichChild = 0;
        this.mFirstTime = true;
        this.mAnimateFirstTime = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewAnimator);
        int resource = a.getResourceId(0, 0);
        if (resource > 0) {
            this.setInAnimation(context, resource);
        }
        if ((resource = a.getResourceId(1, 0)) > 0) {
            this.setOutAnimation(context, resource);
        }
        boolean flag = a.getBoolean(2, true);
        this.setAnimateFirstView(flag);
        a.recycle();
        this.initViewAnimator(context, attrs);
    }

    private final void $$robo$$android_widget_ViewAnimator$initViewAnimator(Context context, AttributeSet attrs) {
        if (attrs == null) {
            this.mMeasureAllChildren = true;
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameLayout);
        boolean measureAllChildren = a.getBoolean(0, true);
        this.setMeasureAllChildren(measureAllChildren);
        a.recycle();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ViewAnimator$setDisplayedChild(int whichChild) {
        this.mWhichChild = whichChild;
        if (whichChild >= this.getChildCount()) {
            this.mWhichChild = 0;
        } else if (whichChild < 0) {
            this.mWhichChild = this.getChildCount() - 1;
        }
        boolean hasFocus = this.getFocusedChild() != null;
        this.showOnly(this.mWhichChild);
        if (hasFocus) {
            this.requestFocus(2);
        }
    }

    private final int $$robo$$android_widget_ViewAnimator$getDisplayedChild() {
        return this.mWhichChild;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ViewAnimator$showNext() {
        this.setDisplayedChild(this.mWhichChild + 1);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ViewAnimator$showPrevious() {
        this.setDisplayedChild(this.mWhichChild - 1);
    }

    private final void $$robo$$android_widget_ViewAnimator$showOnly(int childIndex, boolean animate) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (i == childIndex) {
                if (animate && this.mInAnimation != null) {
                    child.startAnimation(this.mInAnimation);
                }
                child.setVisibility(0);
                this.mFirstTime = false;
                continue;
            }
            if (animate && this.mOutAnimation != null && child.getVisibility() == 0) {
                child.startAnimation(this.mOutAnimation);
            } else if (child.getAnimation() == this.mInAnimation) {
                child.clearAnimation();
            }
            child.setVisibility(8);
        }
    }

    private final void $$robo$$android_widget_ViewAnimator$showOnly(int childIndex) {
        boolean animate = !this.mFirstTime || this.mAnimateFirstTime;
        this.showOnly(childIndex, animate);
    }

    private final void $$robo$$android_widget_ViewAnimator$addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (this.getChildCount() == 1) {
            child.setVisibility(0);
        } else {
            child.setVisibility(8);
        }
        if (index >= 0 && this.mWhichChild >= index) {
            this.setDisplayedChild(this.mWhichChild + 1);
        }
    }

    private final void $$robo$$android_widget_ViewAnimator$removeAllViews() {
        super.removeAllViews();
        this.mWhichChild = 0;
        this.mFirstTime = true;
    }

    private final void $$robo$$android_widget_ViewAnimator$removeView(View view) {
        int index = this.indexOfChild(view);
        if (index >= 0) {
            this.removeViewAt(index);
        }
    }

    private final void $$robo$$android_widget_ViewAnimator$removeViewAt(int index) {
        super.removeViewAt(index);
        int childCount = this.getChildCount();
        if (childCount == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
        } else if (this.mWhichChild >= childCount) {
            this.setDisplayedChild(childCount - 1);
        } else if (this.mWhichChild == index) {
            this.setDisplayedChild(this.mWhichChild);
        }
    }

    private final void $$robo$$android_widget_ViewAnimator$removeViewInLayout(View view) {
        this.removeView(view);
    }

    private final void $$robo$$android_widget_ViewAnimator$removeViews(int start, int count) {
        super.removeViews(start, count);
        if (this.getChildCount() == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
        } else if (this.mWhichChild >= start && this.mWhichChild < start + count) {
            this.setDisplayedChild(this.mWhichChild);
        }
    }

    private final void $$robo$$android_widget_ViewAnimator$removeViewsInLayout(int start, int count) {
        this.removeViews(start, count);
    }

    private final View $$robo$$android_widget_ViewAnimator$getCurrentView() {
        return this.getChildAt(this.mWhichChild);
    }

    private final Animation $$robo$$android_widget_ViewAnimator$getInAnimation() {
        return this.mInAnimation;
    }

    private final void $$robo$$android_widget_ViewAnimator$setInAnimation(Animation inAnimation) {
        this.mInAnimation = inAnimation;
    }

    private final Animation $$robo$$android_widget_ViewAnimator$getOutAnimation() {
        return this.mOutAnimation;
    }

    private final void $$robo$$android_widget_ViewAnimator$setOutAnimation(Animation outAnimation) {
        this.mOutAnimation = outAnimation;
    }

    private final void $$robo$$android_widget_ViewAnimator$setInAnimation(Context context, int resourceID) {
        this.setInAnimation(AnimationUtils.loadAnimation(context, resourceID));
    }

    private final void $$robo$$android_widget_ViewAnimator$setOutAnimation(Context context, int resourceID) {
        this.setOutAnimation(AnimationUtils.loadAnimation(context, resourceID));
    }

    private final boolean $$robo$$android_widget_ViewAnimator$getAnimateFirstView() {
        return this.mAnimateFirstTime;
    }

    private final void $$robo$$android_widget_ViewAnimator$setAnimateFirstView(boolean animate) {
        this.mAnimateFirstTime = animate;
    }

    private final int $$robo$$android_widget_ViewAnimator$getBaseline() {
        return this.getCurrentView() != null ? this.getCurrentView().getBaseline() : super.getBaseline();
    }

    private final CharSequence $$robo$$android_widget_ViewAnimator$getAccessibilityClassName() {
        return ViewAnimator.class.getName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ViewAnimator$__constructor__(context);
    }

    public ViewAnimator(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ViewAnimator$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ViewAnimator$__constructor__(context, attributeSet);
    }

    public ViewAnimator(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ViewAnimator$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void initViewAnimator(Context context, AttributeSet attributeSet) {
        InvokeDynamicSupport.bootstrap("initViewAnimator", $$robo$$android_widget_ViewAnimator$initViewAnimator(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @RemotableViewMethod
    public void setDisplayedChild(int n) {
        InvokeDynamicSupport.bootstrap("setDisplayedChild", $$robo$$android_widget_ViewAnimator$setDisplayedChild(int ), 0, this, n);
    }

    public int getDisplayedChild() {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayedChild", $$robo$$android_widget_ViewAnimator$getDisplayedChild(), 0, this);
    }

    @RemotableViewMethod
    public void showNext() {
        InvokeDynamicSupport.bootstrap("showNext", $$robo$$android_widget_ViewAnimator$showNext(), 0, this);
    }

    @RemotableViewMethod
    public void showPrevious() {
        InvokeDynamicSupport.bootstrap("showPrevious", $$robo$$android_widget_ViewAnimator$showPrevious(), 0, this);
    }

    void showOnly(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("showOnly", $$robo$$android_widget_ViewAnimator$showOnly(int boolean ), 0, this, n, bl);
    }

    void showOnly(int n) {
        InvokeDynamicSupport.bootstrap("showOnly", $$robo$$android_widget_ViewAnimator$showOnly(int ), 0, this, n);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_ViewAnimator$addView(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    @Override
    public void removeAllViews() {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_ViewAnimator$removeAllViews(), 0, this);
    }

    @Override
    public void removeView(View view) {
        InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_widget_ViewAnimator$removeView(android.view.View ), 0, this, view);
    }

    @Override
    public void removeViewAt(int n) {
        InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$android_widget_ViewAnimator$removeViewAt(int ), 0, this, n);
    }

    @Override
    public void removeViewInLayout(View view) {
        InvokeDynamicSupport.bootstrap("removeViewInLayout", $$robo$$android_widget_ViewAnimator$removeViewInLayout(android.view.View ), 0, this, view);
    }

    @Override
    public void removeViews(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeViews", $$robo$$android_widget_ViewAnimator$removeViews(int int ), 0, this, n, n2);
    }

    @Override
    public void removeViewsInLayout(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeViewsInLayout", $$robo$$android_widget_ViewAnimator$removeViewsInLayout(int int ), 0, this, n, n2);
    }

    public View getCurrentView() {
        return InvokeDynamicSupport.bootstrap("getCurrentView", $$robo$$android_widget_ViewAnimator$getCurrentView(), 0, this);
    }

    public Animation getInAnimation() {
        return InvokeDynamicSupport.bootstrap("getInAnimation", $$robo$$android_widget_ViewAnimator$getInAnimation(), 0, this);
    }

    public void setInAnimation(Animation animation) {
        InvokeDynamicSupport.bootstrap("setInAnimation", $$robo$$android_widget_ViewAnimator$setInAnimation(android.view.animation.Animation ), 0, this, animation);
    }

    public Animation getOutAnimation() {
        return InvokeDynamicSupport.bootstrap("getOutAnimation", $$robo$$android_widget_ViewAnimator$getOutAnimation(), 0, this);
    }

    public void setOutAnimation(Animation animation) {
        InvokeDynamicSupport.bootstrap("setOutAnimation", $$robo$$android_widget_ViewAnimator$setOutAnimation(android.view.animation.Animation ), 0, this, animation);
    }

    public void setInAnimation(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setInAnimation", $$robo$$android_widget_ViewAnimator$setInAnimation(android.content.Context int ), 0, this, context, n);
    }

    public void setOutAnimation(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setOutAnimation", $$robo$$android_widget_ViewAnimator$setOutAnimation(android.content.Context int ), 0, this, context, n);
    }

    public boolean getAnimateFirstView() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAnimateFirstView", $$robo$$android_widget_ViewAnimator$getAnimateFirstView(), 0, this);
    }

    public void setAnimateFirstView(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnimateFirstView", $$robo$$android_widget_ViewAnimator$setAnimateFirstView(boolean ), 0, this, bl);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_ViewAnimator$getBaseline(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_ViewAnimator$getAccessibilityClassName(), 0, this);
    }

    public /* synthetic */ ViewAnimator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

