/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScrollView
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int ANIMATED_SCROLL_GAP = 250;
    static float MAX_SCROLL_FACTOR = 0.5f;
    private static String TAG = "ScrollView";
    private long mLastScroll;
    private Rect mTempRect;
    private OverScroller mScroller;
    private EdgeEffect mEdgeGlowTop;
    private EdgeEffect mEdgeGlowBottom;
    private int mLastMotionY;
    private boolean mIsLayoutDirty;
    private View mChildToScrollTo;
    private boolean mIsBeingDragged;
    private VelocityTracker mVelocityTracker;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mOverscrollDistance;
    private int mOverflingDistance;
    private float mVerticalScrollFactor;
    private int mActivePointerId;
    private int[] mScrollOffset;
    private int[] mScrollConsumed;
    private int mNestedYOffset;
    private StrictMode.Span mScrollStrictSpan;
    private StrictMode.Span mFlingStrictSpan;
    private static int INVALID_POINTER = -1;
    private SavedState mSavedState;

    private void $$robo$$android_widget_ScrollView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ScrollView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ScrollView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ScrollView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mTempRect = new Rect();
        this.mIsLayoutDirty = true;
        this.mChildToScrollTo = null;
        this.mIsBeingDragged = false;
        this.mSmoothScrollingEnabled = true;
        this.mActivePointerId = -1;
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.mScrollStrictSpan = null;
        this.mFlingStrictSpan = null;
        this.initScrollView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollView, defStyleAttr, defStyleRes);
        this.setFillViewport(a.getBoolean(0, false));
        a.recycle();
        if (context.getResources().getConfiguration().uiMode == 6) {
            this.setRevealOnFocusHint(false);
        }
    }

    private final boolean $$robo$$android_widget_ScrollView$shouldDelayChildPressedState() {
        return true;
    }

    private final float $$robo$$android_widget_ScrollView$getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        if (this.mScrollY < length) {
            return (float)this.mScrollY / (float)length;
        }
        return 1.0f;
    }

    private final float $$robo$$android_widget_ScrollView$getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        int bottomEdge = this.getHeight() - this.mPaddingBottom;
        int span = this.getChildAt(0).getBottom() - this.mScrollY - bottomEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    private final int $$robo$$android_widget_ScrollView$getMaxScrollAmount() {
        return (int)(0.5f * (float)(this.mBottom - this.mTop));
    }

    private final void $$robo$$android_widget_ScrollView$initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mVerticalScrollFactor = configuration.getScaledVerticalScrollFactor();
    }

    private final void $$robo$$android_widget_ScrollView$addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child);
    }

    private final void $$robo$$android_widget_ScrollView$addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    private final void $$robo$$android_widget_ScrollView$addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    private final void $$robo$$android_widget_ScrollView$addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    private final boolean $$robo$$android_widget_ScrollView$canScroll() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            return this.getHeight() < childHeight + this.mPaddingTop + this.mPaddingBottom;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ScrollView$isFillViewport() {
        return this.mFillViewport;
    }

    private final void $$robo$$android_widget_ScrollView$setFillViewport(boolean fillViewport) {
        if (fillViewport != this.mFillViewport) {
            this.mFillViewport = fillViewport;
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_ScrollView$isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    private final void $$robo$$android_widget_ScrollView$setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    private final void $$robo$$android_widget_ScrollView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mFillViewport) {
            return;
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int heightPadding;
            int widthPadding;
            View child = this.getChildAt(0);
            int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            if (targetSdkVersion >= 23) {
                widthPadding = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin;
                heightPadding = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin;
            } else {
                widthPadding = this.mPaddingLeft + this.mPaddingRight;
                heightPadding = this.mPaddingTop + this.mPaddingBottom;
            }
            int desiredHeight = this.getMeasuredHeight() - heightPadding;
            if (child.getMeasuredHeight() < desiredHeight) {
                int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(widthMeasureSpec, widthPadding, lp.width);
                int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(desiredHeight, 0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private final boolean $$robo$$android_widget_ScrollView$dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    private final boolean $$robo$$android_widget_ScrollView$executeKeyEvent(KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused() && event.getKeyCode() != 4) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, 130)) != null && nextFocused != this && nextFocused.requestFocus(130);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 19: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(33);
                        break;
                    }
                    handled = this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(130);
                        break;
                    }
                    handled = this.fullScroll(130);
                    break;
                }
                case 62: {
                    this.pageScroll(event.isShiftPressed() ? 33 : 130);
                }
            }
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_ScrollView$inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollY = this.mScrollY;
            View child = this.getChildAt(0);
            return y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() && x < child.getRight();
        }
        return false;
    }

    private final void $$robo$$android_widget_ScrollView$initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private final void $$robo$$android_widget_ScrollView$initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private final void $$robo$$android_widget_ScrollView$recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final void $$robo$$android_widget_ScrollView$requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    private final boolean $$robo$$android_widget_ScrollView$onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (super.onInterceptTouchEvent(ev)) {
            return true;
        }
        if (this.getScrollY() == 0 && !this.canScrollVertically(1)) {
            return false;
        }
        switch (action & 0xFF) {
            case 2: {
                ViewParent parent;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    Log.e("ScrollView", "Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent");
                    break;
                }
                int y = (int)ev.getY(pointerIndex);
                int yDiff = Math.abs(y - this.mLastMotionY);
                if (yDiff <= this.mTouchSlop || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                if (this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                if ((parent = this.getParent()) == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int y = (int)ev.getY();
                if (!this.inChild((int)ev.getX(), y)) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionY = y;
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mScroller.computeScrollOffset();
                boolean bl = this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                this.startNestedScroll(2);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    private final boolean $$robo$$android_widget_ScrollView$onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain(ev);
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    if (this.mFlingStrictSpan != null) {
                        this.mFlingStrictSpan.finish();
                        this.mFlingStrictSpan = null;
                    }
                }
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.startNestedScroll(2);
                break;
            }
            case 2: {
                int unconsumedY;
                int scrolledDeltaY;
                boolean canOverscroll;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e("ScrollView", "Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent");
                    break;
                }
                int y = (int)ev.getY(activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y - this.mScrollOffset[1];
                int oldY = this.mScrollY;
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean bl = canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                if (this.overScrollBy(0, deltaY, 0, this.mScrollY, 0, range, 0, this.mOverscrollDistance, true) && !this.hasNestedScrollingParent()) {
                    this.mVelocityTracker.clear();
                }
                if (this.dispatchNestedScroll(0, scrolledDeltaY = this.mScrollY - oldY, 0, unconsumedY = deltaY - scrolledDeltaY, this.mScrollOffset)) {
                    this.mLastMotionY -= this.mScrollOffset[1];
                    vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                    break;
                }
                if (!canOverscroll) break;
                int pulledToY = oldY + deltaY;
                if (pulledToY < 0) {
                    this.mEdgeGlowTop.onPull((float)deltaY / (float)this.getHeight(), ev.getX(activePointerIndex) / (float)this.getWidth());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (pulledToY > range) {
                    this.mEdgeGlowBottom.onPull((float)deltaY / (float)this.getHeight(), 1.0f - ev.getX(activePointerIndex) / (float)this.getWidth());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                if (this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished()) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.flingWithNestedDispatch(-initialVelocity);
                } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mLastMotionY = (int)ev.getY(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = (int)ev.getY(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private final void $$robo$$android_widget_ScrollView$onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private final boolean $$robo$$android_widget_ScrollView$onGenericMotionEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 8: {
                float axisValue = event.isFromSource(2) ? event.getAxisValue(9) : (event.isFromSource(0x400000) ? event.getAxisValue(26) : 0.0f);
                int delta = Math.round(axisValue * this.mVerticalScrollFactor);
                if (delta == 0) break;
                int range = this.getScrollRange();
                int oldScrollY = this.mScrollY;
                int newScrollY = oldScrollY - delta;
                if (newScrollY < 0) {
                    newScrollY = 0;
                } else if (newScrollY > range) {
                    newScrollY = range;
                }
                if (newScrollY == oldScrollY) break;
                super.scrollTo(this.mScrollX, newScrollY);
                return true;
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_widget_ScrollView$onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (!this.mScroller.isFinished()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
            this.invalidateParentIfNeeded();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (clampedY) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange());
            }
        } else {
            super.scrollTo(scrollX, scrollY);
        }
        this.awakenScrollBars();
    }

    private final boolean $$robo$$android_widget_ScrollView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action) {
            case 4096: 
            case 16908346: {
                int viewportHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
                int targetScrollY = Math.min(this.mScrollY + viewportHeight, this.getScrollRange());
                if (targetScrollY != this.mScrollY) {
                    this.smoothScrollTo(0, targetScrollY);
                    return true;
                }
                return false;
            }
            case 8192: 
            case 16908344: {
                int viewportHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
                int targetScrollY = Math.max(this.mScrollY - viewportHeight, 0);
                if (targetScrollY != this.mScrollY) {
                    this.smoothScrollTo(0, targetScrollY);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private final CharSequence $$robo$$android_widget_ScrollView$getAccessibilityClassName() {
        return ScrollView.class.getName();
    }

    private final void $$robo$$android_widget_ScrollView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        int scrollRange;
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled() && (scrollRange = this.getScrollRange()) > 0) {
            info.setScrollable(true);
            if (this.mScrollY > 0) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP);
            }
            if (this.mScrollY < scrollRange) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN);
            }
        }
    }

    private final void $$robo$$android_widget_ScrollView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        boolean scrollable = this.getScrollRange() > 0;
        event.setScrollable(scrollable);
        event.setScrollX(this.mScrollX);
        event.setScrollY(this.mScrollY);
        event.setMaxScrollX(this.mScrollX);
        event.setMaxScrollY(this.getScrollRange());
    }

    private final int $$robo$$android_widget_ScrollView$getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getHeight() - (this.getHeight() - this.mPaddingBottom - this.mPaddingTop));
        }
        return scrollRange;
    }

    private final View $$robo$$android_widget_ScrollView$findFocusableViewInBounds(boolean topFocus, int top, int bottom) {
        ArrayList<View> focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        int count = focusables.size();
        for (int i = 0; i < count; ++i) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            View view = (View)focusables.get(i);
            int viewTop = view.getTop();
            int viewBottom = view.getBottom();
            if (top >= viewBottom || viewTop >= bottom) continue;
            boolean bl = viewIsFullyContained = top < viewTop && viewBottom < bottom;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = topFocus && viewTop < focusCandidate.getTop() || !topFocus && viewBottom > focusCandidate.getBottom();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    private final boolean $$robo$$android_widget_ScrollView$pageScroll(int direction) {
        boolean down = direction == 130;
        int height = this.getHeight();
        if (down) {
            View view;
            this.mTempRect.top = this.getScrollY() + height;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.top + height > (view = this.getChildAt(count - 1)).getBottom()) {
                this.mTempRect.top = view.getBottom() - height;
            }
        } else {
            this.mTempRect.top = this.getScrollY() - height;
            if (this.mTempRect.top < 0) {
                this.mTempRect.top = 0;
            }
        }
        this.mTempRect.bottom = this.mTempRect.top + height;
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    private final boolean $$robo$$android_widget_ScrollView$fullScroll(int direction) {
        int count;
        boolean down = direction == 130;
        int height = this.getHeight();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = height;
        if (down && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(count - 1);
            this.mTempRect.bottom = view.getBottom() + this.mPaddingBottom;
            this.mTempRect.top = this.mTempRect.bottom - height;
        }
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    private final boolean $$robo$$android_widget_ScrollView$scrollAndFocus(int direction, int top, int bottom) {
        boolean handled = true;
        int height = this.getHeight();
        int containerTop = this.getScrollY();
        int containerBottom = containerTop + height;
        boolean up = direction == 33;
        View newFocused = this.findFocusableViewInBounds(up, top, bottom);
        if (newFocused == null) {
            newFocused = this;
        }
        if (top >= containerTop && bottom <= containerBottom) {
            handled = false;
        } else {
            int delta = up ? top - containerTop : bottom - containerBottom;
            this.doScrollY(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_ScrollView$arrowScroll(int direction) {
        int scrollDelta;
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmount();
        if (nextFocused != null && this.isWithinDeltaOfScreen(nextFocused, maxJump, this.getHeight())) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
            nextFocused.requestFocus(direction);
        } else {
            int screenBottom;
            int daBottom;
            scrollDelta = maxJump;
            if (direction == 33 && this.getScrollY() < scrollDelta) {
                scrollDelta = this.getScrollY();
            } else if (direction == 130 && this.getChildCount() > 0 && (daBottom = this.getChildAt(0).getBottom()) - (screenBottom = this.getScrollY() + this.getHeight() - this.mPaddingBottom) < maxJump) {
                scrollDelta = daBottom - screenBottom;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollY(direction == 130 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreen(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_ScrollView$isOffScreen(View descendant) {
        return !this.isWithinDeltaOfScreen(descendant, 0, this.getHeight());
    }

    private final boolean $$robo$$android_widget_ScrollView$isWithinDeltaOfScreen(View descendant, int delta, int height) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.bottom + delta >= this.getScrollY() && this.mTempRect.top - delta <= this.getScrollY() + height;
    }

    private final void $$robo$$android_widget_ScrollView$doScrollY(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(0, delta);
            } else {
                this.scrollBy(0, delta);
            }
        }
    }

    private final void $$robo$$android_widget_ScrollView$smoothScrollBy(int dx, int dy) {
        if (this.getChildCount() == 0) {
            return;
        }
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int bottom = this.getChildAt(0).getHeight();
            int maxY = Math.max(0, bottom - height);
            int scrollY = this.mScrollY;
            dy = Math.max(0, Math.min(scrollY + dy, maxY)) - scrollY;
            this.mScroller.startScroll(this.mScrollX, scrollY, 0, dy);
            this.postInvalidateOnAnimation();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
                if (this.mFlingStrictSpan != null) {
                    this.mFlingStrictSpan.finish();
                    this.mFlingStrictSpan = null;
                }
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    private final void $$robo$$android_widget_ScrollView$smoothScrollTo(int x, int y) {
        this.smoothScrollBy(x - this.mScrollX, y - this.mScrollY);
    }

    private final int $$robo$$android_widget_ScrollView$computeVerticalScrollRange() {
        int count = this.getChildCount();
        int contentHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        if (count == 0) {
            return contentHeight;
        }
        int scrollRange = this.getChildAt(0).getBottom();
        int scrollY = this.mScrollY;
        int overscrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overscrollBottom) {
            scrollRange += scrollY - overscrollBottom;
        }
        return scrollRange;
    }

    private final int $$robo$$android_widget_ScrollView$computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    private final void $$robo$$android_widget_ScrollView$measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int verticalPadding = this.mPaddingTop + this.mPaddingBottom;
        int childHeightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentHeightMeasureSpec) - verticalPadding), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_widget_ScrollView$measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int usedTotal = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed;
        int childHeightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentHeightMeasureSpec) - usedTotal), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_widget_ScrollView$computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                this.overScrollBy(x - oldX, y - oldY, oldX, oldY, 0, range, 0, this.mOverflingDistance, false);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                if (canOverscroll) {
                    if (y < 0 && oldY >= 0) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (y > range && oldY <= range) {
                        this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
        } else if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
    }

    private final void $$robo$$android_widget_ScrollView$scrollToChild(View child) {
        child.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (scrollDelta != 0) {
            this.scrollBy(0, scrollDelta);
        }
    }

    private final boolean $$robo$$android_widget_ScrollView$scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(0, delta);
            } else {
                this.smoothScrollBy(0, delta);
            }
        }
        return scroll;
    }

    private final int $$robo$$android_widget_ScrollView$computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int height = this.getHeight();
        int screenTop = this.getScrollY();
        int screenBottom = screenTop + height;
        int fadingEdge = this.getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            screenTop += fadingEdge;
        }
        if (rect.bottom < this.getChildAt(0).getHeight()) {
            screenBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom && rect.top > screenTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - screenTop) : (scrollYDelta += rect.bottom - screenBottom);
            int bottom = this.getChildAt(0).getBottom();
            int distanceToBottom = bottom - screenBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < screenTop && rect.bottom < screenBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= screenBottom - rect.bottom) : (scrollYDelta -= screenTop - rect.top);
            scrollYDelta = Math.max(scrollYDelta, -this.getScrollY());
        }
        return scrollYDelta;
    }

    private final void $$robo$$android_widget_ScrollView$requestChildFocus(View child, View focused) {
        if (focused != null && focused.getRevealOnFocusHint()) {
            if (!this.mIsLayoutDirty) {
                this.scrollToChild(focused);
            } else {
                this.mChildToScrollTo = focused;
            }
        }
        super.requestChildFocus(child, focused);
    }

    private final boolean $$robo$$android_widget_ScrollView$onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 130;
        } else if (direction == 1) {
            direction = 33;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus(this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect(this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.isOffScreen(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    private final boolean $$robo$$android_widget_ScrollView$requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    private final void $$robo$$android_widget_ScrollView$requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    private final void $$robo$$android_widget_ScrollView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
    }

    private final void $$robo$$android_widget_ScrollView$onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && ScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int childHeight;
            int scrollRange;
            if (this.mSavedState != null) {
                this.mScrollY = this.mSavedState.scrollPosition;
                this.mSavedState = null;
            }
            if (this.mScrollY > (scrollRange = Math.max(0, (childHeight = this.getChildCount() > 0 ? this.getChildAt(0).getMeasuredHeight() : 0) - (b - t - this.mPaddingBottom - this.mPaddingTop)))) {
                this.mScrollY = scrollRange;
            } else if (this.mScrollY < 0) {
                this.mScrollY = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    private final void $$robo$$android_widget_ScrollView$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        if (this.isWithinDeltaOfScreen(currentFocused, 0, oldh)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
        }
    }

    private static final boolean $$robo$$android_widget_ScrollView$isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ScrollView.isViewDescendantOf((View)((Object)theParent), parent);
    }

    private final void $$robo$$android_widget_ScrollView$fling(int velocityY) {
        if (this.getChildCount() > 0) {
            int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int bottom = this.getChildAt(0).getHeight();
            this.mScroller.fling(this.mScrollX, this.mScrollY, 0, velocityY, 0, 0, 0, Math.max(0, bottom - height), 0, height / 2);
            if (this.mFlingStrictSpan == null) {
                this.mFlingStrictSpan = StrictMode.enterCriticalSpan("ScrollView-fling");
            }
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$android_widget_ScrollView$flingWithNestedDispatch(int velocityY) {
        boolean canFling;
        boolean bl = canFling = !(this.mScrollY <= 0 && velocityY <= 0 || this.mScrollY >= this.getScrollRange() && velocityY >= 0);
        if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
            this.dispatchNestedFling(0.0f, velocityY, canFling);
            if (canFling) {
                this.fling(velocityY);
            }
        }
    }

    private final void $$robo$$android_widget_ScrollView$endDrag() {
        this.mIsBeingDragged = false;
        this.recycleVelocityTracker();
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    private final void $$robo$$android_widget_ScrollView$scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = ScrollView.clamp(x, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, child.getWidth());
            y = ScrollView.clamp(y, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, child.getHeight());
            if (x != this.mScrollX || y != this.mScrollY) {
                super.scrollTo(x, y);
            }
        }
    }

    private final void $$robo$$android_widget_ScrollView$setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(mode);
    }

    private final boolean $$robo$$android_widget_ScrollView$onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    private final void $$robo$$android_widget_ScrollView$onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(2);
    }

    private final void $$robo$$android_widget_ScrollView$onStopNestedScroll(View target) {
        super.onStopNestedScroll(target);
    }

    private final void $$robo$$android_widget_ScrollView$onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int oldScrollY = this.mScrollY;
        this.scrollBy(0, dyUnconsumed);
        int myConsumed = this.mScrollY - oldScrollY;
        int myUnconsumed = dyUnconsumed - myConsumed;
        this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null);
    }

    private final boolean $$robo$$android_widget_ScrollView$onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.flingWithNestedDispatch((int)velocityY);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_ScrollView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            float translateY;
            float translateX;
            int height;
            int width;
            int restoreCount;
            int scrollY = this.mScrollY;
            boolean clipToPadding = this.getClipToPadding();
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                if (clipToPadding) {
                    width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                    height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                    translateX = this.mPaddingLeft;
                    translateY = this.mPaddingTop;
                } else {
                    width = this.getWidth();
                    height = this.getHeight();
                    translateX = 0.0f;
                    translateY = 0.0f;
                }
                canvas.translate(translateX, (float)Math.min(0, scrollY) + translateY);
                this.mEdgeGlowTop.setSize(width, height);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                if (clipToPadding) {
                    width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                    height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                    translateX = this.mPaddingLeft;
                    translateY = this.mPaddingTop;
                } else {
                    width = this.getWidth();
                    height = this.getHeight();
                    translateX = 0.0f;
                    translateY = 0.0f;
                }
                canvas.translate((float)(-width) + translateX, (float)(Math.max(this.getScrollRange(), scrollY) + height) + translateY);
                canvas.rotate(180.0f, width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private static final int $$robo$$android_widget_ScrollView$clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    private final void $$robo$$android_widget_ScrollView$onRestoreInstanceState(Parcelable state) {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSavedState = ss;
        this.requestLayout();
    }

    private final Parcelable $$robo$$android_widget_ScrollView$onSaveInstanceState() {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            return super.onSaveInstanceState();
        }
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.scrollPosition = this.mScrollY;
        return ss;
    }

    private final void $$robo$$android_widget_ScrollView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("fillViewport", this.mFillViewport);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ScrollView$__constructor__(context);
    }

    public ScrollView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ScrollView$__constructor__(context, attributeSet);
    }

    public ScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010080);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ScrollView$__constructor__(context, attributeSet, n);
    }

    public ScrollView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ScrollView$__constructor__(context, attributeSet, n, n2);
    }

    public ScrollView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_ScrollView$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getTopFadingEdgeStrength", $$robo$$android_widget_ScrollView$getTopFadingEdgeStrength(), 0, this);
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getBottomFadingEdgeStrength", $$robo$$android_widget_ScrollView$getBottomFadingEdgeStrength(), 0, this);
    }

    public int getMaxScrollAmount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxScrollAmount", $$robo$$android_widget_ScrollView$getMaxScrollAmount(), 0, this);
    }

    private void initScrollView() {
        InvokeDynamicSupport.bootstrap("initScrollView", $$robo$$android_widget_ScrollView$initScrollView(), 0, this);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_ScrollView$addView(android.view.View ), 0, this, view);
    }

    @Override
    public void addView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_ScrollView$addView(android.view.View int ), 0, this, view, n);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_ScrollView$addView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_ScrollView$addView(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    private boolean canScroll() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScroll", $$robo$$android_widget_ScrollView$canScroll(), 0, this);
    }

    public boolean isFillViewport() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFillViewport", $$robo$$android_widget_ScrollView$isFillViewport(), 0, this);
    }

    public void setFillViewport(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillViewport", $$robo$$android_widget_ScrollView$setFillViewport(boolean ), 0, this, bl);
    }

    public boolean isSmoothScrollingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmoothScrollingEnabled", $$robo$$android_widget_ScrollView$isSmoothScrollingEnabled(), 0, this);
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSmoothScrollingEnabled", $$robo$$android_widget_ScrollView$setSmoothScrollingEnabled(boolean ), 0, this, bl);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_ScrollView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_ScrollView$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("executeKeyEvent", $$robo$$android_widget_ScrollView$executeKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    private boolean inChild(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("inChild", $$robo$$android_widget_ScrollView$inChild(int int ), 0, this, n, n2);
    }

    private void initOrResetVelocityTracker() {
        InvokeDynamicSupport.bootstrap("initOrResetVelocityTracker", $$robo$$android_widget_ScrollView$initOrResetVelocityTracker(), 0, this);
    }

    private void initVelocityTrackerIfNotExists() {
        InvokeDynamicSupport.bootstrap("initVelocityTrackerIfNotExists", $$robo$$android_widget_ScrollView$initVelocityTrackerIfNotExists(), 0, this);
    }

    private void recycleVelocityTracker() {
        InvokeDynamicSupport.bootstrap("recycleVelocityTracker", $$robo$$android_widget_ScrollView$recycleVelocityTracker(), 0, this);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        InvokeDynamicSupport.bootstrap("requestDisallowInterceptTouchEvent", $$robo$$android_widget_ScrollView$requestDisallowInterceptTouchEvent(boolean ), 0, this, bl);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_ScrollView$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_ScrollView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onSecondaryPointerUp", $$robo$$android_widget_ScrollView$onSecondaryPointerUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_widget_ScrollView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onOverScrolled", $$robo$$android_widget_ScrollView$onOverScrolled(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_ScrollView$performAccessibilityActionInternal(int android.os.Bundle ), 0, this, n, bundle);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_ScrollView$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_ScrollView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_ScrollView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private int getScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollRange", $$robo$$android_widget_ScrollView$getScrollRange(), 0, this);
    }

    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("findFocusableViewInBounds", $$robo$$android_widget_ScrollView$findFocusableViewInBounds(boolean int int ), 0, this, bl, n, n2);
    }

    public boolean pageScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageScroll", $$robo$$android_widget_ScrollView$pageScroll(int ), 0, this, n);
    }

    public boolean fullScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("fullScroll", $$robo$$android_widget_ScrollView$fullScroll(int ), 0, this, n);
    }

    private boolean scrollAndFocus(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollAndFocus", $$robo$$android_widget_ScrollView$scrollAndFocus(int int int ), 0, this, n, n2, n3);
    }

    public boolean arrowScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("arrowScroll", $$robo$$android_widget_ScrollView$arrowScroll(int ), 0, this, n);
    }

    private boolean isOffScreen(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffScreen", $$robo$$android_widget_ScrollView$isOffScreen(android.view.View ), 0, this, view);
    }

    private boolean isWithinDeltaOfScreen(View view, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWithinDeltaOfScreen", $$robo$$android_widget_ScrollView$isWithinDeltaOfScreen(android.view.View int int ), 0, this, view, n, n2);
    }

    private void doScrollY(int n) {
        InvokeDynamicSupport.bootstrap("doScrollY", $$robo$$android_widget_ScrollView$doScrollY(int ), 0, this, n);
    }

    public void smoothScrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$android_widget_ScrollView$smoothScrollBy(int int ), 0, this, n, n2);
    }

    public void smoothScrollTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollTo", $$robo$$android_widget_ScrollView$smoothScrollTo(int int ), 0, this, n, n2);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_widget_ScrollView$computeVerticalScrollRange(), 0, this);
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$android_widget_ScrollView$computeVerticalScrollOffset(), 0, this);
    }

    @Override
    protected void measureChild(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChild", $$robo$$android_widget_ScrollView$measureChild(android.view.View int int ), 0, this, view, n, n2);
    }

    @Override
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("measureChildWithMargins", $$robo$$android_widget_ScrollView$measureChildWithMargins(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$android_widget_ScrollView$computeScroll(), 0, this);
    }

    private void scrollToChild(View view) {
        InvokeDynamicSupport.bootstrap("scrollToChild", $$robo$$android_widget_ScrollView$scrollToChild(android.view.View ), 0, this, view);
    }

    private boolean scrollToChildRect(Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollToChildRect", $$robo$$android_widget_ScrollView$scrollToChildRect(android.graphics.Rect boolean ), 0, this, rect, bl);
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("computeScrollDeltaToGetChildRectOnScreen", $$robo$$android_widget_ScrollView$computeScrollDeltaToGetChildRectOnScreen(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        InvokeDynamicSupport.bootstrap("requestChildFocus", $$robo$$android_widget_ScrollView$requestChildFocus(android.view.View android.view.View ), 0, this, view, view2);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestFocusInDescendants", $$robo$$android_widget_ScrollView$onRequestFocusInDescendants(int android.graphics.Rect ), 0, this, n, rect);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$android_widget_ScrollView$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), 0, this, view, rect, bl);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_ScrollView$requestLayout(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_ScrollView$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_ScrollView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_ScrollView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    private static boolean isViewDescendantOf(View view, View view2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isViewDescendantOf", $$robo$$android_widget_ScrollView$isViewDescendantOf(android.view.View android.view.View ), 0, (View)view, (View)view2);
    }

    public void fling(int n) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_ScrollView$fling(int ), 0, this, n);
    }

    private void flingWithNestedDispatch(int n) {
        InvokeDynamicSupport.bootstrap("flingWithNestedDispatch", $$robo$$android_widget_ScrollView$flingWithNestedDispatch(int ), 0, this, n);
    }

    private void endDrag() {
        InvokeDynamicSupport.bootstrap("endDrag", $$robo$$android_widget_ScrollView$endDrag(), 0, this);
    }

    @Override
    public void scrollTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollTo", $$robo$$android_widget_ScrollView$scrollTo(int int ), 0, this, n, n2);
    }

    @Override
    public void setOverScrollMode(int n) {
        InvokeDynamicSupport.bootstrap("setOverScrollMode", $$robo$$android_widget_ScrollView$setOverScrollMode(int ), 0, this, n);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStartNestedScroll", $$robo$$android_widget_ScrollView$onStartNestedScroll(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("onNestedScrollAccepted", $$robo$$android_widget_ScrollView$onNestedScrollAccepted(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onStopNestedScroll(View view) {
        InvokeDynamicSupport.bootstrap("onStopNestedScroll", $$robo$$android_widget_ScrollView$onStopNestedScroll(android.view.View ), 0, this, view);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onNestedScroll", $$robo$$android_widget_ScrollView$onNestedScroll(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedFling", $$robo$$android_widget_ScrollView$onNestedFling(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_ScrollView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    private static int clamp(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_widget_ScrollView$clamp(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_ScrollView$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_ScrollView$onSaveInstanceState(), 0, this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_ScrollView$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    public /* synthetic */ ScrollView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int scrollPosition;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_ScrollView_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_ScrollView_SavedState$__constructor__(Parcel source) {
            this.scrollPosition = source.readInt();
        }

        private final void $$robo$$android_widget_ScrollView_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.scrollPosition);
        }

        private final String $$robo$$android_widget_ScrollView_SavedState$toString() {
            return "ScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.scrollPosition + "}";
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ScrollView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_ScrollView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_ScrollView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ScrollView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ScrollView_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ScrollView_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_ScrollView_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_ScrollView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollView_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ScrollView_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_ScrollView_SavedState$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

