/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.DataSetObserver;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListPosition;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.HeterogeneousExpandableList;
import java.util.ArrayList;
import java.util.Collections;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExpandableListConnector
extends BaseAdapter
implements Filterable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ExpandableListAdapter mExpandableListAdapter;
    private ArrayList<GroupMetadata> mExpGroupMetadataList;
    private int mTotalExpChildrenCount;
    private int mMaxExpGroupCount;
    private DataSetObserver mDataSetObserver;

    private void $$robo$$android_widget_ExpandableListConnector$__constructor__(ExpandableListAdapter expandableListAdapter) {
        this.mMaxExpGroupCount = Integer.MAX_VALUE;
        this.mDataSetObserver = new MyDataSetObserver(this);
        this.mExpGroupMetadataList = new ArrayList();
        this.setExpandableListAdapter(expandableListAdapter);
    }

    private final void $$robo$$android_widget_ExpandableListConnector$setExpandableListAdapter(ExpandableListAdapter expandableListAdapter) {
        if (this.mExpandableListAdapter != null) {
            this.mExpandableListAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mExpandableListAdapter = expandableListAdapter;
        expandableListAdapter.registerDataSetObserver(this.mDataSetObserver);
    }

    private final PositionMetadata $$robo$$android_widget_ExpandableListConnector$getUnflattenedPos(int flPos) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int numExpGroups = egml.size();
        int leftExpGroupIndex = 0;
        int rightExpGroupIndex = numExpGroups - 1;
        int midExpGroupIndex = 0;
        if (numExpGroups == 0) {
            return PositionMetadata.obtain(flPos, 2, flPos, -1, null, 0);
        }
        while (leftExpGroupIndex <= rightExpGroupIndex) {
            midExpGroupIndex = (rightExpGroupIndex - leftExpGroupIndex) / 2 + leftExpGroupIndex;
            GroupMetadata midExpGm = egml.get(midExpGroupIndex);
            if (flPos > midExpGm.lastChildFlPos) {
                leftExpGroupIndex = midExpGroupIndex + 1;
                continue;
            }
            if (flPos < midExpGm.flPos) {
                rightExpGroupIndex = midExpGroupIndex - 1;
                continue;
            }
            if (flPos == midExpGm.flPos) {
                return PositionMetadata.obtain(flPos, 2, midExpGm.gPos, -1, midExpGm, midExpGroupIndex);
            }
            if (flPos > midExpGm.lastChildFlPos) continue;
            int childPos = flPos - (midExpGm.flPos + 1);
            return PositionMetadata.obtain(flPos, 1, midExpGm.gPos, childPos, midExpGm, midExpGroupIndex);
        }
        int insertPosition = 0;
        int groupPos = 0;
        if (leftExpGroupIndex > midExpGroupIndex) {
            GroupMetadata leftExpGm = egml.get(leftExpGroupIndex - 1);
            insertPosition = leftExpGroupIndex;
            groupPos = flPos - leftExpGm.lastChildFlPos + leftExpGm.gPos;
        } else if (rightExpGroupIndex < midExpGroupIndex) {
            GroupMetadata rightExpGm = egml.get(++rightExpGroupIndex);
            insertPosition = rightExpGroupIndex;
            groupPos = rightExpGm.gPos - (rightExpGm.flPos - flPos);
        } else {
            throw new RuntimeException("Unknown state");
        }
        return PositionMetadata.obtain(flPos, 2, groupPos, -1, null, insertPosition);
    }

    private final PositionMetadata $$robo$$android_widget_ExpandableListConnector$getFlattenedPos(ExpandableListPosition pos) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int numExpGroups = egml.size();
        int leftExpGroupIndex = 0;
        int rightExpGroupIndex = numExpGroups - 1;
        int midExpGroupIndex = 0;
        if (numExpGroups == 0) {
            return PositionMetadata.obtain(pos.groupPos, pos.type, pos.groupPos, pos.childPos, null, 0);
        }
        while (leftExpGroupIndex <= rightExpGroupIndex) {
            midExpGroupIndex = (rightExpGroupIndex - leftExpGroupIndex) / 2 + leftExpGroupIndex;
            GroupMetadata midExpGm = egml.get(midExpGroupIndex);
            if (pos.groupPos > midExpGm.gPos) {
                leftExpGroupIndex = midExpGroupIndex + 1;
                continue;
            }
            if (pos.groupPos < midExpGm.gPos) {
                rightExpGroupIndex = midExpGroupIndex - 1;
                continue;
            }
            if (pos.groupPos != midExpGm.gPos) continue;
            if (pos.type == 2) {
                return PositionMetadata.obtain(midExpGm.flPos, pos.type, pos.groupPos, pos.childPos, midExpGm, midExpGroupIndex);
            }
            if (pos.type == 1) {
                return PositionMetadata.obtain(midExpGm.flPos + pos.childPos + 1, pos.type, pos.groupPos, pos.childPos, midExpGm, midExpGroupIndex);
            }
            return null;
        }
        if (pos.type != 2) {
            return null;
        }
        if (leftExpGroupIndex > midExpGroupIndex) {
            GroupMetadata leftExpGm = egml.get(leftExpGroupIndex - 1);
            int flPos = leftExpGm.lastChildFlPos + (pos.groupPos - leftExpGm.gPos);
            return PositionMetadata.obtain(flPos, pos.type, pos.groupPos, pos.childPos, null, leftExpGroupIndex);
        }
        if (rightExpGroupIndex < midExpGroupIndex) {
            GroupMetadata rightExpGm = egml.get(++rightExpGroupIndex);
            int flPos = rightExpGm.flPos - (rightExpGm.gPos - pos.groupPos);
            return PositionMetadata.obtain(flPos, pos.type, pos.groupPos, pos.childPos, null, rightExpGroupIndex);
        }
        return null;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$areAllItemsEnabled() {
        return this.mExpandableListAdapter.areAllItemsEnabled();
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$isEnabled(int flatListPos) {
        PositionMetadata metadata = this.getUnflattenedPos(flatListPos);
        ExpandableListPosition pos = metadata.position;
        boolean retValue = pos.type == 1 ? this.mExpandableListAdapter.isChildSelectable(pos.groupPos, pos.childPos) : true;
        metadata.recycle();
        return retValue;
    }

    private final int $$robo$$android_widget_ExpandableListConnector$getCount() {
        return this.mExpandableListAdapter.getGroupCount() + this.mTotalExpChildrenCount;
    }

    private final Object $$robo$$android_widget_ExpandableListConnector$getItem(int flatListPos) {
        Object retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getGroup(posMetadata.position.groupPos);
        } else if (posMetadata.position.type == 1) {
            retValue = this.mExpandableListAdapter.getChild(posMetadata.position.groupPos, posMetadata.position.childPos);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    private final long $$robo$$android_widget_ExpandableListConnector$getItemId(int flatListPos) {
        long retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        long groupId = this.mExpandableListAdapter.getGroupId(posMetadata.position.groupPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getCombinedGroupId(groupId);
        } else if (posMetadata.position.type == 1) {
            long childId = this.mExpandableListAdapter.getChildId(posMetadata.position.groupPos, posMetadata.position.childPos);
            retValue = this.mExpandableListAdapter.getCombinedChildId(groupId, childId);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    private final View $$robo$$android_widget_ExpandableListConnector$getView(int flatListPos, View convertView, ViewGroup parent) {
        View retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getGroupView(posMetadata.position.groupPos, posMetadata.isExpanded(), convertView, parent);
        } else if (posMetadata.position.type == 1) {
            boolean isLastChild = posMetadata.groupMetadata.lastChildFlPos == flatListPos;
            retValue = this.mExpandableListAdapter.getChildView(posMetadata.position.groupPos, posMetadata.position.childPos, isLastChild, convertView, parent);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    private final int $$robo$$android_widget_ExpandableListConnector$getItemViewType(int flatListPos) {
        int retValue;
        PositionMetadata metadata = this.getUnflattenedPos(flatListPos);
        ExpandableListPosition pos = metadata.position;
        if (this.mExpandableListAdapter instanceof HeterogeneousExpandableList) {
            HeterogeneousExpandableList adapter = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
            if (pos.type == 2) {
                retValue = adapter.getGroupType(pos.groupPos);
            } else {
                int childType = adapter.getChildType(pos.groupPos, pos.childPos);
                retValue = adapter.getGroupTypeCount() + childType;
            }
        } else {
            retValue = pos.type == 2 ? 0 : 1;
        }
        metadata.recycle();
        return retValue;
    }

    private final int $$robo$$android_widget_ExpandableListConnector$getViewTypeCount() {
        if (this.mExpandableListAdapter instanceof HeterogeneousExpandableList) {
            HeterogeneousExpandableList adapter = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
            return adapter.getGroupTypeCount() + adapter.getChildTypeCount();
        }
        return 2;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$hasStableIds() {
        return this.mExpandableListAdapter.hasStableIds();
    }

    private final void $$robo$$android_widget_ExpandableListConnector$refreshExpGroupMetadataList(boolean forceChildrenCountRefresh, boolean syncGroupPositions) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int egmlSize = egml.size();
        int curFlPos = 0;
        this.mTotalExpChildrenCount = 0;
        if (syncGroupPositions) {
            boolean positionsChanged = false;
            for (int i = egmlSize - 1; i >= 0; --i) {
                GroupMetadata curGm = egml.get(i);
                int newGPos = this.findGroupPosition(curGm.gId, curGm.gPos);
                if (newGPos == curGm.gPos) continue;
                if (newGPos == -1) {
                    egml.remove(i);
                    --egmlSize;
                }
                curGm.gPos = newGPos;
                if (positionsChanged) continue;
                positionsChanged = true;
            }
            if (positionsChanged) {
                Collections.sort(egml);
            }
        }
        int lastGPos = 0;
        for (int i = 0; i < egmlSize; ++i) {
            GroupMetadata curGm = egml.get(i);
            int gChildrenCount = curGm.lastChildFlPos == -1 || forceChildrenCountRefresh ? this.mExpandableListAdapter.getChildrenCount(curGm.gPos) : curGm.lastChildFlPos - curGm.flPos;
            this.mTotalExpChildrenCount += gChildrenCount;
            lastGPos = curGm.gPos;
            curGm.flPos = curFlPos += curGm.gPos - lastGPos;
            curGm.lastChildFlPos = curFlPos += gChildrenCount;
        }
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$collapseGroup(int groupPos) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtain(2, groupPos, -1, -1);
        PositionMetadata pm = this.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        if (pm == null) {
            return false;
        }
        boolean retValue = this.collapseGroup(pm);
        pm.recycle();
        return retValue;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$collapseGroup(PositionMetadata posMetadata) {
        if (posMetadata.groupMetadata == null) {
            return false;
        }
        this.mExpGroupMetadataList.remove(posMetadata.groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupCollapsed(posMetadata.groupMetadata.gPos);
        return true;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$expandGroup(int groupPos) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtain(2, groupPos, -1, -1);
        PositionMetadata pm = this.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        boolean retValue = this.expandGroup(pm);
        pm.recycle();
        return retValue;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$expandGroup(PositionMetadata posMetadata) {
        if (posMetadata.position.groupPos < 0) {
            throw new RuntimeException("Need group");
        }
        if (this.mMaxExpGroupCount == 0) {
            return false;
        }
        if (posMetadata.groupMetadata != null) {
            return false;
        }
        if (this.mExpGroupMetadataList.size() >= this.mMaxExpGroupCount) {
            GroupMetadata collapsedGm = this.mExpGroupMetadataList.get(0);
            int collapsedIndex = this.mExpGroupMetadataList.indexOf(collapsedGm);
            this.collapseGroup(collapsedGm.gPos);
            if (posMetadata.groupInsertIndex > collapsedIndex) {
                --posMetadata.groupInsertIndex;
            }
        }
        GroupMetadata expandedGm = GroupMetadata.obtain(-1, -1, posMetadata.position.groupPos, this.mExpandableListAdapter.getGroupId(posMetadata.position.groupPos));
        this.mExpGroupMetadataList.add(posMetadata.groupInsertIndex, expandedGm);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupExpanded(expandedGm.gPos);
        return true;
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$isGroupExpanded(int groupPosition) {
        for (int i = this.mExpGroupMetadataList.size() - 1; i >= 0; --i) {
            GroupMetadata groupMetadata = this.mExpGroupMetadataList.get(i);
            if (groupMetadata.gPos != groupPosition) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_ExpandableListConnector$setMaxExpGroupCount(int maxExpGroupCount) {
        this.mMaxExpGroupCount = maxExpGroupCount;
    }

    private final ExpandableListAdapter $$robo$$android_widget_ExpandableListConnector$getAdapter() {
        return this.mExpandableListAdapter;
    }

    private final Filter $$robo$$android_widget_ExpandableListConnector$getFilter() {
        ExpandableListAdapter adapter = this.getAdapter();
        if (adapter instanceof Filterable) {
            return ((Filterable)((Object)adapter)).getFilter();
        }
        return null;
    }

    private final ArrayList<GroupMetadata> $$robo$$android_widget_ExpandableListConnector$getExpandedGroupMetadataList() {
        return this.mExpGroupMetadataList;
    }

    private final void $$robo$$android_widget_ExpandableListConnector$setExpandedGroupMetadataList(ArrayList<GroupMetadata> expandedGroupMetadataList) {
        if (expandedGroupMetadataList == null || this.mExpandableListAdapter == null) {
            return;
        }
        int numGroups = this.mExpandableListAdapter.getGroupCount();
        for (int i = expandedGroupMetadataList.size() - 1; i >= 0; --i) {
            if (expandedGroupMetadataList.get((int)i).gPos < numGroups) continue;
            return;
        }
        this.mExpGroupMetadataList = expandedGroupMetadataList;
        this.refreshExpGroupMetadataList(true, false);
    }

    private final boolean $$robo$$android_widget_ExpandableListConnector$isEmpty() {
        ExpandableListAdapter adapter = this.getAdapter();
        return adapter != null ? adapter.isEmpty() : true;
    }

    private final int $$robo$$android_widget_ExpandableListConnector$findGroupPosition(long groupIdToMatch, int seedGroupPosition) {
        int count = this.mExpandableListAdapter.getGroupCount();
        if (count == 0) {
            return -1;
        }
        if (groupIdToMatch == Long.MIN_VALUE) {
            return -1;
        }
        seedGroupPosition = Math.max(0, seedGroupPosition);
        seedGroupPosition = Math.min(count - 1, seedGroupPosition);
        long endTime = SystemClock.uptimeMillis() + 100L;
        int first = seedGroupPosition;
        int last = seedGroupPosition;
        boolean next = false;
        ExpandableListAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return -1;
        }
        while (SystemClock.uptimeMillis() <= endTime) {
            boolean hitFirst;
            long rowId = adapter.getGroupId(seedGroupPosition);
            if (rowId == groupIdToMatch) {
                return seedGroupPosition;
            }
            boolean hitLast = last == count - 1;
            boolean bl = hitFirst = first == 0;
            if (hitLast && hitFirst) break;
            if (hitFirst || next && !hitLast) {
                seedGroupPosition = ++last;
                next = false;
                continue;
            }
            if (!hitLast && (next || hitFirst)) continue;
            seedGroupPosition = --first;
            next = true;
        }
        return -1;
    }

    private void __constructor__(ExpandableListAdapter expandableListAdapter) {
        this.$$robo$$android_widget_ExpandableListConnector$__constructor__(expandableListAdapter);
    }

    public ExpandableListConnector(ExpandableListAdapter expandableListAdapter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListConnector$__constructor__(android.widget.ExpandableListAdapter ), 0, this, expandableListAdapter);
    }

    public void setExpandableListAdapter(ExpandableListAdapter expandableListAdapter) {
        InvokeDynamicSupport.bootstrap("setExpandableListAdapter", $$robo$$android_widget_ExpandableListConnector$setExpandableListAdapter(android.widget.ExpandableListAdapter ), 0, this, expandableListAdapter);
    }

    PositionMetadata getUnflattenedPos(int n) {
        return InvokeDynamicSupport.bootstrap("getUnflattenedPos", $$robo$$android_widget_ExpandableListConnector$getUnflattenedPos(int ), 0, this, n);
    }

    PositionMetadata getFlattenedPos(ExpandableListPosition expandableListPosition) {
        return InvokeDynamicSupport.bootstrap("getFlattenedPos", $$robo$$android_widget_ExpandableListConnector$getFlattenedPos(android.widget.ExpandableListPosition ), 0, this, expandableListPosition);
    }

    @Override
    public boolean areAllItemsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("areAllItemsEnabled", $$robo$$android_widget_ExpandableListConnector$areAllItemsEnabled(), 0, this);
    }

    @Override
    public boolean isEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_ExpandableListConnector$isEnabled(int ), 0, this, n);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_ExpandableListConnector$getCount(), 0, this);
    }

    @Override
    public Object getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_ExpandableListConnector$getItem(int ), 0, this, n);
    }

    @Override
    public long getItemId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_ExpandableListConnector$getItemId(int ), 0, this, n);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_ExpandableListConnector$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    @Override
    public int getItemViewType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$android_widget_ExpandableListConnector$getItemViewType(int ), 0, this, n);
    }

    @Override
    public int getViewTypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getViewTypeCount", $$robo$$android_widget_ExpandableListConnector$getViewTypeCount(), 0, this);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_ExpandableListConnector$hasStableIds(), 0, this);
    }

    private void refreshExpGroupMetadataList(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("refreshExpGroupMetadataList", $$robo$$android_widget_ExpandableListConnector$refreshExpGroupMetadataList(boolean boolean ), 0, this, bl, bl2);
    }

    boolean collapseGroup(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseGroup", $$robo$$android_widget_ExpandableListConnector$collapseGroup(int ), 0, this, n);
    }

    boolean collapseGroup(PositionMetadata positionMetadata) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseGroup", $$robo$$android_widget_ExpandableListConnector$collapseGroup(android.widget.ExpandableListConnector$PositionMetadata ), 0, this, positionMetadata);
    }

    boolean expandGroup(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandGroup", $$robo$$android_widget_ExpandableListConnector$expandGroup(int ), 0, this, n);
    }

    boolean expandGroup(PositionMetadata positionMetadata) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandGroup", $$robo$$android_widget_ExpandableListConnector$expandGroup(android.widget.ExpandableListConnector$PositionMetadata ), 0, this, positionMetadata);
    }

    public boolean isGroupExpanded(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupExpanded", $$robo$$android_widget_ExpandableListConnector$isGroupExpanded(int ), 0, this, n);
    }

    public void setMaxExpGroupCount(int n) {
        InvokeDynamicSupport.bootstrap("setMaxExpGroupCount", $$robo$$android_widget_ExpandableListConnector$setMaxExpGroupCount(int ), 0, this, n);
    }

    ExpandableListAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_ExpandableListConnector$getAdapter(), 0, this);
    }

    @Override
    public Filter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_widget_ExpandableListConnector$getFilter(), 0, this);
    }

    ArrayList<GroupMetadata> getExpandedGroupMetadataList() {
        return InvokeDynamicSupport.bootstrap("getExpandedGroupMetadataList", $$robo$$android_widget_ExpandableListConnector$getExpandedGroupMetadataList(), 0, this);
    }

    void setExpandedGroupMetadataList(ArrayList<GroupMetadata> arrayList) {
        InvokeDynamicSupport.bootstrap("setExpandedGroupMetadataList", $$robo$$android_widget_ExpandableListConnector$setExpandedGroupMetadataList(java.util.ArrayList<android.widget.ExpandableListConnector$GroupMetadata> ), 0, this, arrayList);
    }

    @Override
    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_widget_ExpandableListConnector$isEmpty(), 0, this);
    }

    int findGroupPosition(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findGroupPosition", $$robo$$android_widget_ExpandableListConnector$findGroupPosition(long int ), 0, this, l, n);
    }

    public /* synthetic */ ExpandableListConnector() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExpandableListConnector)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PositionMetadata
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 5;
        private static ArrayList<PositionMetadata> sPool;
        public ExpandableListPosition position;
        public GroupMetadata groupMetadata;
        public int groupInsertIndex;

        private final void $$robo$$android_widget_ExpandableListConnector_PositionMetadata$resetState() {
            if (this.position != null) {
                this.position.recycle();
                this.position = null;
            }
            this.groupMetadata = null;
            this.groupInsertIndex = 0;
        }

        private void $$robo$$android_widget_ExpandableListConnector_PositionMetadata$__constructor__() {
        }

        private static final PositionMetadata $$robo$$android_widget_ExpandableListConnector_PositionMetadata$obtain(int flatListPos, int type, int groupPos, int childPos, GroupMetadata groupMetadata, int groupInsertIndex) {
            PositionMetadata pm = PositionMetadata.getRecycledOrCreate();
            pm.position = ExpandableListPosition.obtain(type, groupPos, childPos, flatListPos);
            pm.groupMetadata = groupMetadata;
            pm.groupInsertIndex = groupInsertIndex;
            return pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final PositionMetadata $$robo$$android_widget_ExpandableListConnector_PositionMetadata$getRecycledOrCreate() {
            PositionMetadata pm;
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() <= 0) {
                    return new PositionMetadata();
                }
                pm = sPool.remove(0);
            }
            pm.resetState();
            return pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_ExpandableListConnector_PositionMetadata$recycle() {
            this.resetState();
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() < 5) {
                    sPool.add(this);
                }
            }
        }

        private final boolean $$robo$$android_widget_ExpandableListConnector_PositionMetadata$isExpanded() {
            return this.groupMetadata != null;
        }

        static void __staticInitializer__() {
            sPool = new ArrayList(5);
        }

        private void resetState() {
            InvokeDynamicSupport.bootstrap("resetState", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$resetState(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ExpandableListConnector_PositionMetadata$__constructor__();
        }

        private PositionMetadata() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$__constructor__(), 0, this);
        }

        static PositionMetadata obtain(int n, int n2, int n3, int n4, GroupMetadata groupMetadata, int n5) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$obtain(int int int int android.widget.ExpandableListConnector$GroupMetadata int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (GroupMetadata)groupMetadata, (int)n5);
        }

        private static PositionMetadata getRecycledOrCreate() {
            return InvokeDynamicSupport.bootstrapStatic("getRecycledOrCreate", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$getRecycledOrCreate(), 0);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$recycle(), 0, this);
        }

        public boolean isExpanded() {
            return (boolean)InvokeDynamicSupport.bootstrap("isExpanded", $$robo$$android_widget_ExpandableListConnector_PositionMetadata$isExpanded(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(PositionMetadata.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PositionMetadata)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GroupMetadata
    implements Parcelable,
    Comparable<GroupMetadata> {
        public transient /* synthetic */ Object __robo_data__;
        static int REFRESH = -1;
        int flPos;
        int lastChildFlPos;
        int gPos;
        long gId;
        public static Parcelable.Creator<GroupMetadata> CREATOR;

        private void $$robo$$android_widget_ExpandableListConnector_GroupMetadata$__constructor__() {
        }

        private static final GroupMetadata $$robo$$android_widget_ExpandableListConnector_GroupMetadata$obtain(int flPos, int lastChildFlPos, int gPos, long gId) {
            GroupMetadata gm = new GroupMetadata();
            gm.flPos = flPos;
            gm.lastChildFlPos = lastChildFlPos;
            gm.gPos = gPos;
            gm.gId = gId;
            return gm;
        }

        private final int $$robo$$android_widget_ExpandableListConnector_GroupMetadata$compareTo(GroupMetadata another) {
            if (another == null) {
                throw new IllegalArgumentException();
            }
            return this.gPos - another.gPos;
        }

        private final int $$robo$$android_widget_ExpandableListConnector_GroupMetadata$describeContents() {
            return 0;
        }

        private final void $$robo$$android_widget_ExpandableListConnector_GroupMetadata$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.flPos);
            dest.writeInt(this.lastChildFlPos);
            dest.writeInt(this.gPos);
            dest.writeLong(this.gId);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<GroupMetadata>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$__constructor__() {
                }

                private final GroupMetadata $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$createFromParcel(Parcel in) {
                    GroupMetadata gm = GroupMetadata.obtain(in.readInt(), in.readInt(), in.readInt(), in.readLong());
                    return gm;
                }

                private final GroupMetadata[] $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$newArray(int size) {
                    return new GroupMetadata[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$__constructor__(), 0, this);
                }

                @Override
                public GroupMetadata createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public GroupMetadata[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ExpandableListConnector_GroupMetadata_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ExpandableListConnector_GroupMetadata$__constructor__();
        }

        private GroupMetadata() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListConnector_GroupMetadata$__constructor__(), 0, this);
        }

        static GroupMetadata obtain(int n, int n2, int n3, long l) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_widget_ExpandableListConnector_GroupMetadata$obtain(int int int long ), 0, (int)n, (int)n2, (int)n3, (long)l);
        }

        @Override
        public int compareTo(GroupMetadata groupMetadata) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_widget_ExpandableListConnector_GroupMetadata$compareTo(android.widget.ExpandableListConnector$GroupMetadata ), 0, this, groupMetadata);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_ExpandableListConnector_GroupMetadata$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ExpandableListConnector_GroupMetadata$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(GroupMetadata.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GroupMetadata)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected class MyDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ExpandableListConnector this$0;

        private void $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$__constructor__(ExpandableListConnector this$0) {
        }

        private final void $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$onChanged() {
            this.this$0.refreshExpGroupMetadataList(true, true);
            this.this$0.notifyDataSetChanged();
        }

        private final void $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$onInvalidated() {
            this.this$0.refreshExpGroupMetadataList(true, true);
            this.this$0.notifyDataSetInvalidated();
        }

        private void __constructor__(ExpandableListConnector expandableListConnector) {
            this.$$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$__constructor__(expandableListConnector);
        }

        protected MyDataSetObserver(ExpandableListConnector expandableListConnector) {
            this.this$0 = expandableListConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$__constructor__(android.widget.ExpandableListConnector ), 0, this, expandableListConnector);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$onChanged(), 0, this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_ExpandableListConnector_MyDataSetObserver$onInvalidated(), 0, this);
        }

        public /* synthetic */ MyDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

