/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.net.Uri;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class Chronometer
extends TextView
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Chronometer";
    private long mBase;
    private long mNow;
    private boolean mVisible;
    private boolean mStarted;
    private boolean mRunning;
    private boolean mLogged;
    private String mFormat;
    private Formatter mFormatter;
    private Locale mFormatterLocale;
    private Object[] mFormatterArgs;
    private StringBuilder mFormatBuilder;
    private OnChronometerTickListener mOnChronometerTickListener;
    private StringBuilder mRecycle;
    private boolean mCountDown;
    private Runnable mTickRunnable;
    private static int MIN_IN_SEC = 60;
    private static int HOUR_IN_SEC = 3600;

    private void $$robo$$android_widget_Chronometer$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_Chronometer$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_Chronometer$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_Chronometer$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mFormatterArgs = new Object[1];
        this.mRecycle = new StringBuilder(8);
        this.mTickRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Chronometer this$0;

            private void $$robo$$android_widget_Chronometer_1$__constructor__(Chronometer this$0) {
            }

            private final void $$robo$$android_widget_Chronometer_1$run() {
                if (this.this$0.mRunning) {
                    this.this$0.updateText(SystemClock.elapsedRealtime());
                    this.this$0.dispatchChronometerTick();
                    this.this$0.postDelayed(this.this$0.mTickRunnable, 1000L);
                }
            }

            private void __constructor__(Chronometer chronometer) {
                this.$$robo$$android_widget_Chronometer_1$__constructor__(chronometer);
            }
            {
                this.this$0 = chronometer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Chronometer_1$__constructor__(android.widget.Chronometer ), 0, this, chronometer);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Chronometer_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Chronometer, defStyleAttr, defStyleRes);
        this.setFormat(a.getString(0));
        this.setCountDown(a.getBoolean(1, false));
        a.recycle();
        this.init();
    }

    private final void $$robo$$android_widget_Chronometer$init() {
        this.mBase = SystemClock.elapsedRealtime();
        this.updateText(this.mBase);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_Chronometer$setCountDown(boolean countDown) {
        this.mCountDown = countDown;
        this.updateText(SystemClock.elapsedRealtime());
    }

    private final boolean $$robo$$android_widget_Chronometer$isCountDown() {
        return this.mCountDown;
    }

    private final boolean $$robo$$android_widget_Chronometer$isTheFinalCountDown() {
        try {
            this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse("https://youtu.be/9jK-NcRmVcw")).addCategory("android.intent.category.BROWSABLE").addFlags(528384));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_Chronometer$setBase(long base) {
        this.mBase = base;
        this.dispatchChronometerTick();
        this.updateText(SystemClock.elapsedRealtime());
    }

    private final long $$robo$$android_widget_Chronometer$getBase() {
        return this.mBase;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_Chronometer$setFormat(String format) {
        this.mFormat = format;
        if (format != null && this.mFormatBuilder == null) {
            this.mFormatBuilder = new StringBuilder(format.length() * 2);
        }
    }

    private final String $$robo$$android_widget_Chronometer$getFormat() {
        return this.mFormat;
    }

    private final void $$robo$$android_widget_Chronometer$setOnChronometerTickListener(OnChronometerTickListener listener) {
        this.mOnChronometerTickListener = listener;
    }

    private final OnChronometerTickListener $$robo$$android_widget_Chronometer$getOnChronometerTickListener() {
        return this.mOnChronometerTickListener;
    }

    private final void $$robo$$android_widget_Chronometer$start() {
        this.mStarted = true;
        this.updateRunning();
    }

    private final void $$robo$$android_widget_Chronometer$stop() {
        this.mStarted = false;
        this.updateRunning();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_Chronometer$setStarted(boolean started) {
        this.mStarted = started;
        this.updateRunning();
    }

    private final void $$robo$$android_widget_Chronometer$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    private final void $$robo$$android_widget_Chronometer$onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning();
    }

    private final void $$robo$$android_widget_Chronometer$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.updateRunning();
    }

    private final synchronized void $$robo$$android_widget_Chronometer$updateText(long now) {
        String text;
        block6: {
            this.mNow = now;
            long seconds = this.mCountDown ? this.mBase - now : now - this.mBase;
            boolean negative = false;
            if ((seconds /= 1000L) < 0L) {
                seconds = -seconds;
                negative = true;
            }
            text = DateUtils.formatElapsedTime(this.mRecycle, seconds);
            if (negative) {
                text = this.getResources().getString(17040278, text);
            }
            if (this.mFormat != null) {
                Locale loc = Locale.getDefault();
                if (this.mFormatter == null || !loc.equals(this.mFormatterLocale)) {
                    this.mFormatterLocale = loc;
                    this.mFormatter = new Formatter(this.mFormatBuilder, loc);
                }
                this.mFormatBuilder.setLength(0);
                this.mFormatterArgs[0] = text;
                try {
                    this.mFormatter.format(this.mFormat, this.mFormatterArgs);
                    text = this.mFormatBuilder.toString();
                }
                catch (IllegalFormatException ex) {
                    if (this.mLogged) break block6;
                    Log.w("Chronometer", "Illegal format string: " + this.mFormat);
                    this.mLogged = true;
                }
            }
        }
        this.setText(text);
    }

    private final void $$robo$$android_widget_Chronometer$updateRunning() {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted && this.isShown();
        if (running != this.mRunning) {
            if (running) {
                this.updateText(SystemClock.elapsedRealtime());
                this.dispatchChronometerTick();
                this.postDelayed(this.mTickRunnable, 1000L);
            } else {
                this.removeCallbacks(this.mTickRunnable);
            }
            this.mRunning = running;
        }
    }

    private final void $$robo$$android_widget_Chronometer$dispatchChronometerTick() {
        if (this.mOnChronometerTickListener != null) {
            this.mOnChronometerTickListener.onChronometerTick(this);
        }
    }

    private static final String $$robo$$android_widget_Chronometer$formatDuration(long ms) {
        int duration = (int)(ms / 1000L);
        if (duration < 0) {
            duration = -duration;
        }
        int h = 0;
        int m = 0;
        if (duration >= 3600) {
            h = duration / 3600;
            duration -= h * 3600;
        }
        if (duration >= 60) {
            m = duration / 60;
            duration -= m * 60;
        }
        int s = duration;
        ArrayList<Measure> measures = new ArrayList<Measure>();
        if (h > 0) {
            measures.add(new Measure(h, MeasureUnit.HOUR));
        }
        if (m > 0) {
            measures.add(new Measure(m, MeasureUnit.MINUTE));
        }
        measures.add(new Measure(s, MeasureUnit.SECOND));
        return MeasureFormat.getInstance(Locale.getDefault(), MeasureFormat.FormatWidth.WIDE).formatMeasures(measures.toArray(new Measure[measures.size()]));
    }

    private final CharSequence $$robo$$android_widget_Chronometer$getContentDescription() {
        return Chronometer.formatDuration(this.mNow - this.mBase);
    }

    private final CharSequence $$robo$$android_widget_Chronometer$getAccessibilityClassName() {
        return Chronometer.class.getName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_Chronometer$__constructor__(context);
    }

    public Chronometer(Context context) {
        this(context, null, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Chronometer$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_Chronometer$__constructor__(context, attributeSet);
    }

    public Chronometer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Chronometer$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_Chronometer$__constructor__(context, attributeSet, n);
    }

    public Chronometer(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Chronometer$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_Chronometer$__constructor__(context, attributeSet, n, n2);
    }

    public Chronometer(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Chronometer$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_Chronometer$init(), 0, this);
    }

    @RemotableViewMethod
    public void setCountDown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCountDown", $$robo$$android_widget_Chronometer$setCountDown(boolean ), 0, this, bl);
    }

    public boolean isCountDown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCountDown", $$robo$$android_widget_Chronometer$isCountDown(), 0, this);
    }

    public boolean isTheFinalCountDown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTheFinalCountDown", $$robo$$android_widget_Chronometer$isTheFinalCountDown(), 0, this);
    }

    @RemotableViewMethod
    public void setBase(long l) {
        InvokeDynamicSupport.bootstrap("setBase", $$robo$$android_widget_Chronometer$setBase(long ), 0, this, l);
    }

    public long getBase() {
        return (long)InvokeDynamicSupport.bootstrap("getBase", $$robo$$android_widget_Chronometer$getBase(), 0, this);
    }

    @RemotableViewMethod
    public void setFormat(String string2) {
        InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_widget_Chronometer$setFormat(java.lang.String ), 0, this, string2);
    }

    public String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_widget_Chronometer$getFormat(), 0, this);
    }

    public void setOnChronometerTickListener(OnChronometerTickListener onChronometerTickListener) {
        InvokeDynamicSupport.bootstrap("setOnChronometerTickListener", $$robo$$android_widget_Chronometer$setOnChronometerTickListener(android.widget.Chronometer$OnChronometerTickListener ), 0, this, onChronometerTickListener);
    }

    public OnChronometerTickListener getOnChronometerTickListener() {
        return InvokeDynamicSupport.bootstrap("getOnChronometerTickListener", $$robo$$android_widget_Chronometer$getOnChronometerTickListener(), 0, this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_Chronometer$start(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_widget_Chronometer$stop(), 0, this);
    }

    @RemotableViewMethod
    public void setStarted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStarted", $$robo$$android_widget_Chronometer$setStarted(boolean ), 0, this, bl);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_Chronometer$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowVisibilityChanged", $$robo$$android_widget_Chronometer$onWindowVisibilityChanged(int ), 0, this, n);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_widget_Chronometer$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private synchronized void updateText(long l) {
        InvokeDynamicSupport.bootstrap("updateText", $$robo$$android_widget_Chronometer$updateText(long ), 0, this, l);
    }

    private void updateRunning() {
        InvokeDynamicSupport.bootstrap("updateRunning", $$robo$$android_widget_Chronometer$updateRunning(), 0, this);
    }

    void dispatchChronometerTick() {
        InvokeDynamicSupport.bootstrap("dispatchChronometerTick", $$robo$$android_widget_Chronometer$dispatchChronometerTick(), 0, this);
    }

    private static String formatDuration(long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_widget_Chronometer$formatDuration(long ), 0, (long)l);
    }

    @Override
    public CharSequence getContentDescription() {
        return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$android_widget_Chronometer$getContentDescription(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_Chronometer$getAccessibilityClassName(), 0, this);
    }

    public /* synthetic */ Chronometer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Chronometer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnChronometerTickListener
    extends InstrumentedInterface {
        public void onChronometerTick(Chronometer var1);
    }
}

